(ns modular.cylon-oauth-example.website
  (:require
   [clj-time.core :as t]
   [clj-time.format :as f]
   [clj-time.coerce :as c]
   [bidi.bidi :refer (path-for)]
   [bidi.ring :refer (redirect)]
   [ring.util.response :as ring-response]
   [clojure.pprint :refer (pprint)]
   [clojure.tools.logging :refer :all]
   [com.stuartsierra.component :refer (using)]
   [hiccup.core :as hiccup]
   [modular.bidi :refer (WebService as-request-handler)]
   [modular.ring :refer (WebRequestHandler)]
   [modular.template :refer (render-template template-model)]
   [ring.util.response :refer (response)]
   [tangrammer.component.co-dependency :refer (co-using)]
   [cylon.oauth.client :refer (wrap-require-authorization refresh-token*)]
   [cylon.authentication :refer (authenticate)]
   [cylon.session :refer (session respond-with-new-session! assoc-session-data! respond-close-session!)]
   [modular.cylon-oauth-example.protocols :refer (EmployeeStore get-e put-e all update-e)]
   [cylon.util :refer (absolute-uri)]
   [ring.middleware.params :refer (wrap-params)]
   [ring.util.codec :refer (url-encode url-decode)]
   [modular.cylon-oauth-example.auth-middleware :as middleware]
   [modular.cylon-oauth-example.auth-calls :as auth-calls]
   [modular.cylon-oauth-example.calendar-middleware :as cal-middleware]
   [modular.cylon-oauth-example.calendar-cals :as call-cald]
   [ring.middleware.json :refer ( wrap-json-params wrap-json-response)]
   )
  (:import [com.google.appengine.api.datastore Entity DatastoreService DatastoreServiceFactory EntityNotFoundException]))




(defn make-full-link [req port-listener router path]
  (format "%s://%s:%s%s"
          (name (:scheme req))
          (:server-name req)
          port-listener
          (path-for (:routes router) path)))

(defn menu [router uri oauth-item]
  (hiccup/html
   [:ul.nav.masthead-nav
    (concat (for [[k label] [[::index "Home"]
                             [::calendar-home "Buscador"]]

                  :let [href (path-for (:routes @router) k)]]
              [:li (when (= href uri) {:class "active"})
               [:a (merge {:href href}) label]]
              ) oauth-item)]))

(defn menu-extended [router req oauth-client ]
  (menu router  (:uri req)
        (when (:cylon/access-token (authenticate oauth-client req))
          [[:li
            [:a (merge {:href (str (path-for (:routes @router) :cylon.oauth.client.web-client/logout)
                                   "?post_logout_redirect_uri="
                                   (make-full-link req (:server-port req) @router ::index))})
             "Log Out"]]
           ])))

(defn page [templater menu content]
  (response
   (render-template
    templater
    "templates/page.html.mustache"
    {:menu menu
     :content content})))

(defn index [employees-store templater router oauth-client ]
  (fn [req]

    (let
        [menu (menu-extended router req oauth-client )]


      (page templater menu
           (hiccup/html
            [:div
             [:h1.cover-heading (str "Bienvenid@!")]

             [:p.lead "Esta aplicaci&oacute;n sirve para buscar asociados que est&eacute;n disponibles en un intervalo de fechas"]
             [:p.lead "Haz click en " [:a {:href (path-for (:routes @router) ::calendar-home)} "'Buscador'"] " para empezar"]
             [:p "Requisitos:"
              [:ul
               [:li "Tienes que pertenecer a la asociaci&oacute;n APIT "]
               [:li "Tener una cuenta google"]
               [:li "Tener un " [:a {:href "https://www.google.com/calendar"} "calendario google"] " con el nombre 'apit' "]
               [:li "Cuando no quieras aparecer como disponible en los resultados de esta aplicaci&oacute; solamente tienes que poner eventos en tu calendario de google 'apit' "]]]])))))

;; search-employees

;; query all events calendars employees

;; page admin to edit users

(def query-start "2015-02-03T00:00:01+0000")
(def query-end  "2015-02-04T00:00:01+0000")

;(f/show-formatters)
(defn calendar-component [s]
  (do [:div.col-md-6
       [:div.form-group
        [:div#dp1.input-append.date {:data-date (f/unparse (f/formatter "dd-MM-YYYY") (t/now)) :data-date-format "dd-mm-yyyy"}
         [:input.span2 {:size 16 :type "text" :value (f/unparse (f/formatter "dd-MM-YYYY") (t/now)) :readonly "true"}]
         [:span.add-on [:i.icon-calendar]]
         ]]
       [:div
       [:select#range
        [:option {:value "AM"} "AM"]
        [:option {:value "PM"} "PM"]
        [:option {:value "Night"} "Night"]
        [:option {:value "FullDay"} "FullDay"]
        ]]]




      ))

(def e (f/unparse (f/formatters :date-time-no-ms)(f/parse (f/formatters :date-time-no-ms) query-end)))

(defn adapt-dates[^String start ^String range]
  (t/plus (c/from-long (Long. start)) (t/days 1))
  )

(def ranges {:AM [(fn [c] (t/plus c (t/hours 8)))
                  (fn [c] (t/plus c (t/hours 14)))]
             :PM [(fn [c] (t/plus c (t/hours 14)))
                  (fn [c] (t/plus c (t/hours 20)))]
             :Night [(fn [c] (t/plus c (t/hours 20)))
                     (fn [c] (t/plus c (t/hours 24)))]
             :FullDay [(fn [c] (t/plus c (t/hours 8)))
                     (fn [c] (t/plus c (t/hours 19)))]
             }
  )

(defn util- [^String date r]

  [ (->> (-> (f/parse(f/formatter "dd-MM-yyyy") date)
             ((first (get ranges r))))
         (f/unparse (f/formatters :date-time-no-ms)))
    (->> (-> (f/parse(f/formatter "dd-MM-yyyy") date)
                        ((last (get ranges r))))
       (f/unparse (f/formatters :date-time-no-ms)))
    ])



;(adapt-dates query-start nil)

(defn get-refresh-token
  [oauth-client r-t]
  (apply refresh-token*
         (-> ((juxt :access-token-uri :client-id :client-secret) oauth-client)
             (conj r-t))))
;; am: desde las xxx hasta las 14:30
;; pm: desde las 14:30 hasta las 2000
;; nocturna: desde las 2000 hasta las xxx
(def t "ya29.FQG1rHgcJIvxit19Kyx0pj2nxuMkpNz-mhbjWusd7NFvzABlk3F2CxIVyScQgFTKZmncomIiHZcQYw")
(def c "3poq2tucglrg4h5lul044dluns@group.calendar.google.com")
;;(call-cald/cal-events t c query-start e)
(defn calendar-search [employees-allowed employees-store oauth-client session-store ]
  (-> (fn [req]
        (let [access-token (:cylon/access-token req)
              email (:cylon/email req)
              query-start (get-in req [:params "start"])
              range (get-in req [:params "range"])
              [d-start d-end] (util- query-start (keyword range))]

          (println "start***********" query-start)
;          (println "start***********" (t/plus (c/from-long (Long. query-start)) (t/days 1)))
          (println "range***********" range)

          (if (and query-start query-end)
            (let [connected-employees (:buscador/connected-employees (session session-store req))
                  r (reduce (fn [c {:keys [id token refresh-token calendar]}]
                        (->> (call-cald/cal-events token calendar d-start d-end)
                             (map (fn [{:keys [start end]}]
                                    {:id id :start start  :end end}))
                             (apply conj c)))
                      [] connected-employees)]
              (ring-response/response
               {:results r
                :free (vec  (clojure.set/difference  (set (mapv :id connected-employees)) (set (mapv :id r))))
                :busy (mapv :id r)
                :filter (str query-start " " range)
               }))
            (ring-response/response  {:error "ERROR! ups!"}))))


      wrap-json-params

      wrap-json-response

      (cal-middleware/connect-active-users-data oauth-client session-store employees-store)

      (cal-middleware/required-calendar-exists? "apit" employees-store)

      (middleware/store-refresh-token employees-store)

      (middleware/wrap-users-restricted session-store  employees-allowed )

      (wrap-require-authorization oauth-client  "https://www.googleapis.com/auth/calendar.readonly")

      ))

(defn calendar-home [employees-allowed employees-store templater router oauth-client session-store ]
  (-> (fn [req]
        (let [access-token (:cylon/access-token req)
              email (:cylon/email req)
              calendar (:buscador/calendar (session session-store req))]
          (page templater (menu-extended router req oauth-client)
                (hiccup/html
                 [:div
                  [:h1.cover-heading "Buscador de asociados disponibles"]]

                 [:div.container
                  (calendar-component "start")]
                 [:div.container
                  [:div.col-md-4 [:div.input-group [:input#query_calls.form-control {:type :button :value "buscar!"}]]]
                  ]

                 [:div#results]
                 [:div
                  [:h1 "&nbsp;"][:h1 "&nbsp;"]
                  [:table {:border 1 :width "100%"}
                   [:tr
                    [:td "Asociaciados APIT"]
                    [:td "&nbsp;"]
                    [:td "Asociados no participantes en la consulta"]

]
                   [:tr
                    [:td [:ul
                          (for [asoc* (-> employees-allowed keys set)]
                            [:li asoc*])]]
                    [:td "&nbsp;"]
                    [:td [:ul
                          (for [asoc* (clojure.set/difference (-> employees-allowed keys set)  (set (map :id (all employees-store))))]
                            [:li asoc*])]]]]
                  ]
                 ))

          ))

      (cal-middleware/required-calendar-exists? "apit" employees-store)

      (middleware/store-refresh-token employees-store)

      (middleware/wrap-users-restricted session-store employees-allowed)

      (wrap-require-authorization oauth-client  "https://www.googleapis.com/auth/calendar.readonly")

      ))

(defn employees [users-allowed employees-store templater router oauth-client session-store ]
  (-> (fn [req]
        (let [access-token (:cylon/access-token req)
              email (:cylon/email req)]
          (page templater (menu-extended router req oauth-client)
                (hiccup/html
                 [:div#results]
                 [:div
                  [:h1.cover-heading "Admin employees" email]
                  [:table
                   [:tr [:td "id"] [:td "token"] [:td "refresh-token"] [:td "calendar"] ]
                   (for [{:keys [id token refresh-token calendar]} (all employees-store)]
                     [:tr [:td id] [:td token] [:td refresh-token] [:td calendar] ]
                     )]
                  [:p "Protected Info, user auth: " email]
                  ]))

          ))

      (middleware/wrap-users-restricted session-store users-allowed)

      (wrap-require-authorization oauth-client  "https://www.googleapis.com/auth/calendar.readonly")))

(defrecord Website [oauth-client templater router  employees-store employees-allowed session-store]
  WebService
  (request-handlers [this]
    {::index (index employees-store templater router oauth-client)
     ::calendar-home (calendar-home employees-allowed employees-store templater router oauth-client session-store)
     ::calendar-search (calendar-search employees-allowed employees-store oauth-client session-store)
     ::employees (employees {"juanantonioruz@gmail.com" "admin web"}  employees-store templater router oauth-client session-store)
     })

  (routes [_] ["/" {"index.html" ::index
                    "" (redirect ::index)
                    "buscador.html" ::calendar-home
                    "search.html" ::calendar-search
                    "employees.html" ::employees
                    }])
  (uri-context [_] ""))

(defn new-website [& {:as opts}]
  (-> (map->Website opts)
      (using [:templater :oauth-client :employees-store :session-store])
      (co-using [:router])))
