(ns modular.cylon-oauth-example.employees-store
  (:require   [com.stuartsierra.component :as component :refer (using)]
              [plumbing.core :refer (<-)]
              [modular.cylon-oauth-example.protocols :refer (EmployeeStore get-e put-e update-e all)])
  (:import [com.google.appengine.api.datastore Entity Query DatastoreService DatastoreServiceFactory Key EntityNotFoundException])
  )


(defn update-prop [e k m]
  (when (k m)
        (.setProperty e (name k) (k m))))

(defn format-e [employee]
  {:token (.getProperty employee "token")
   :refresh-token (.getProperty employee "refresh-token")
   :id (.getName (.getKey employee))
   :calendar (.getProperty employee "calendar")
   :class "Employee"})


(defn datastore []
  (DatastoreServiceFactory/getDatastoreService))
(defrecord GoogleEmployeeStore []

  EmployeeStore
  (put-e [this options]
    (let [^DatastoreService datastore (datastore)
          ^Entity e (Entity. "Employee" (:id options))]

      (doall (map #(update-prop e % options) [:token :refresh-token :calendar]))

      (.put datastore e)
      (println "inserted done!!" e)
      (format-e e)
      )

    )
  (get-e [this id]
    (let [^DatastoreService datastore (datastore)]
      (try
        (let [employee (.get datastore (.getKey (Entity. "Employee" id)))]
          (format-e employee)
          )
        (catch EntityNotFoundException ex (do (println (str "caught exception " (.getMessage ex)))
                                             nil)))

      )

    )
  (update-e [this id options]
    (put-e this (merge (get-e this id) options))
    )
  (all [this]
        (map format-e (iterator-seq (.asIterator (.prepare (datastore) (Query."Employee")))))
    )


  )




(defn new-employees-store
  [& {:as opts}]
  (->> opts

       map->GoogleEmployeeStore))
