(ns modular.cylon-oauth-example.auth-middleware
  (:require
   [cylon.session :refer (session respond-with-new-session! assoc-session-data! respond-close-session!)]
   [modular.cylon-oauth-example.auth-calls :as auth-calss]
   [modular.cylon-oauth-example.protocols :refer (EmployeeStore get-e put-e all update-e)]))

(defn me [access-token]
  (let [r (cylon.oauth.client/http-request-form :get "https://www.googleapis.com/userinfo/v2/me"
                                                nil
                                                {"Authorization" (str "Bearer " access-token)})]

      (if-not (get-in r [:body "error"])
      {:email (get (:body r) "email")
       :name (get (:body r) "name")}
      (println (get-in r [:body "error"])))))

(defn user-logged-email [access-token  session-store req]
  (or (:cylon/email (session session-store req))
                        (do
                          (when-let [e (:email (auth-calss/me access-token))]
                            (assoc-session-data! session-store req {:cylon/email e})
                            e))))

(defn wrap-users-restricted [h session-store employees-allowed]
  (fn [req]
    (println "???????????????????????? wrapiing users" employees-allowed)
    (let [access-token (:cylon/access-token req)
          email (user-logged-email access-token session-store req)
          employees-allowed (-> employees-allowed keys set)]
      (do
        (println employees-allowed email access-token)
        (if (contains? employees-allowed email)
          (h (assoc req :cylon/email email))
          {:status 401 :body (str "Sorry, you're not an allowed user " email)})))))

(defn store-refresh-token [h employees-store]
  ;; only in first call with oauth2 server we get refresh-token!!
  (fn [req]
    (println "???????????????????????? storing refresh token")
          (when-let [refresh-token (:cylon/refresh-token req)]
            (do
              (println "refresh-token" refresh-token)
              (put-e employees-store {:id (:cylon/email req)
                                      :token (:cylon/access-token req)
                                      :refresh-token refresh-token})
              ))
          (h req)
  ))
