(ns modular.cylon-oauth-example.auth-calls
  (:require [cylon.oauth.client :refer (http-request-form refresh-token*)]))

(defn get-refresh-token
  [oauth-client r-t]
  (apply refresh-token*
         (-> ((juxt :access-token-uri :client-id :client-secret) oauth-client)
             (conj r-t))))


(defn me [access-token]
  (let [r (http-request-form :get "https://www.googleapis.com/userinfo/v2/me"
                                                nil
                                                {"Authorization" (str "Bearer " access-token)})]

      (if-not (get-in r [:body "error"])
      {:email (get (:body r) "email")
       :name (get (:body r) "name")}
      (let [e (get-in r [:body "error"])]
        (println e)
        (get-in e ["errors" 0 "reason"])))))
