(ns tandem.exception
  "Our exception handling class.  Adds support for an HTTP status error
  response to the basic Exception classes."
  (:gen-class
   :extends RuntimeException
   :name tandem.TandemException
   :constructors {[Long String Object] [String]
                  [Long String] [String]}
   :init init
   :state state
   :methods [[status [] Long]
             [duplicate [] Object]]))

(defn -init
  "Pass in the status keyword (see above) and the error message.  You may
  optionally include a duplicate."
  ([status message duplicate]
    [[message] {:status status :duplicate duplicate}])
  ([status message]
    [[message] {:status status}]))

(defn -status
  "Return the HTTP response code for this exception.  Indicates the kind of
  exception, such as a portfolio not being found."
  [this]
  (:status (.state this)))

(defn -duplicate
  "Return the duplicate, if there is one."
  [this]
  (:duplicate (.state this)))
