(ns tandem.http.status
  
  "HTTP response status codes, from Netty."
  
  (:import org.jboss.netty.handler.codec.http.HttpResponseStatus))

(def ^{:doc "202 Accepted"} ^:static accepted HttpResponseStatus/ACCEPTED)
(def ^{:doc "502 Bad Gateway"} ^:static bad-gateway HttpResponseStatus/BAD_GATEWAY)
(def ^{:doc "400 Bad Request"} ^:static bad-request HttpResponseStatus/BAD_REQUEST)
(def ^{:doc "409 Conflict"} ^:static conflict HttpResponseStatus/CONFLICT)
(def ^{:doc "100 Continue"} ^:static continue HttpResponseStatus/CONTINUE)
(def ^{:doc "201 Created"} ^:static created HttpResponseStatus/CREATED)
(def ^{:doc "417 Expectation Failed"} ^:static expectation-failed HttpResponseStatus/EXPECTATION_FAILED)
(def ^{:doc "424 Failed Dependency (WebDAV, RFC4918)"} ^:static failed-dependency HttpResponseStatus/FAILED_DEPENDENCY)
(def ^{:doc "403 Forbidden"} ^:static forbidden HttpResponseStatus/FORBIDDEN)
(def ^{:doc "302 Found"} ^:static found HttpResponseStatus/FOUND)
(def ^{:doc "504 Gateway Timeout"} ^:static gateway-timeout HttpResponseStatus/GATEWAY_TIMEOUT)
(def ^{:doc "410 Gone"} ^:static gone HttpResponseStatus/GONE)
(def ^{:doc "505 HTTP Version Not Supported"} ^:static http-version-not-supported HttpResponseStatus/HTTP_VERSION_NOT_SUPPORTED)
(def ^{:doc "507 Insufficient Storage (WebDAV, DFC4918)"} ^:static insufficient-storage HttpResponseStatus/INSUFFICIENT_STORAGE)
(def ^{:doc "500 Internal Server Error"} ^:static internal-server-error HttpResponseStatus/INTERNAL_SERVER_ERROR)
(def ^{:doc "411 Length Required"} ^:static length-required HttpResponseStatus/LENGTH_REQUIRED)
(def ^{:doc "423 Locked (WebDAV, RFC4918)"} ^:static locked HttpResponseStatus/LOCKED)
(def ^{:doc "405 Method Not Allowed"} ^:static method-not-allowed HttpResponseStatus/METHOD_NOT_ALLOWED)
(def ^{:doc "301 Moved Permanently"} ^:static moved-permanently HttpResponseStatus/MOVED_PERMANENTLY)
(def ^{:doc "207 Multi-Status (WebDAV, RFC2518)"} ^:static multi-status HttpResponseStatus/MULTI_STATUS)
(def ^{:doc "300 Multiple Choices"} ^:static multiple-choices HttpResponseStatus/MULTIPLE_CHOICES)
(def ^{:doc "204 No Content"} ^:static no-content HttpResponseStatus/NO_CONTENT)
(def ^{:doc "203 Non-Authoritative Information (since HTTP/1.1)"} ^:static non-authoritative-information HttpResponseStatus/NON_AUTHORITATIVE_INFORMATION)
(def ^{:doc "406 Not Acceptable"} ^:static not-acceptable HttpResponseStatus/NOT_ACCEPTABLE)
(def ^{:doc "510 Not Extended (RFC2774)"} ^:static not-extended HttpResponseStatus/NOT_EXTENDED)
(def ^{:doc "404 Not Found"} ^:static not-found HttpResponseStatus/NOT_FOUND)
(def ^{:doc "501 Not Implemented"} ^:static not-implemented HttpResponseStatus/NOT_IMPLEMENTED)
(def ^{:doc "304 Not Modified"} ^:static not-modified HttpResponseStatus/NOT_MODIFIED)
(def ^{:doc "200 OK"} ^:static ok HttpResponseStatus/OK)
(def ^{:doc "206 Partial Content"} ^:static partial-content HttpResponseStatus/PARTIAL_CONTENT)
(def ^{:doc "402 Payment Required"} ^:static payment-required HttpResponseStatus/PAYMENT_REQUIRED)
(def ^{:doc "412 Precondition Failed"} ^:static precondition-failed HttpResponseStatus/PRECONDITION_FAILED)
(def ^{:doc "102 Processing (WebDAV, RFC2518)"} ^:static processing HttpResponseStatus/PROCESSING)
(def ^{:doc "407 Proxy Authentication Required"} ^:static proxy-authentication-required HttpResponseStatus/PROXY_AUTHENTICATION_REQUIRED)
(def ^{:doc "413 Request Entity Too Large"} ^:static request-entity-too-large HttpResponseStatus/REQUEST_ENTITY_TOO_LARGE)
(def ^{:doc "408 Request Timeout"} ^:static request-timeout HttpResponseStatus/REQUEST_TIMEOUT)
(def ^{:doc "414 Request-URI Too Long"} ^:static request-uri-too-long HttpResponseStatus/REQUEST_URI_TOO_LONG)
(def ^{:doc "416 Requested Range Not Satisfiable"} ^:static requested-range-not-satisfiable HttpResponseStatus/REQUESTED_RANGE_NOT_SATISFIABLE)
(def ^{:doc "205 Reset Content"} ^:static reset-content HttpResponseStatus/RESET_CONTENT)
(def ^{:doc "303 See Other (since HTTP/1.1)"} ^:static see-other HttpResponseStatus/SEE_OTHER)
(def ^{:doc "503 Service Unavailable"} ^:static service-unavailable HttpResponseStatus/SERVICE_UNAVAILABLE)
(def ^{:doc "101 Switching Protocols"} ^:static switching-protocols HttpResponseStatus/SWITCHING_PROTOCOLS)
(def ^{:doc "307 Temporary Redirect (since HTTP/1.1)"} ^:static temporary-redirect HttpResponseStatus/TEMPORARY_REDIRECT)
(def ^{:doc "401 Unauthorized"} ^:static unauthorized HttpResponseStatus/UNAUTHORIZED)
(def ^{:doc "425 Unordered Collection (WebDAV, RFC3648)"} ^:static unordered-collection HttpResponseStatus/UNORDERED_COLLECTION)
(def ^{:doc "422 Unprocessable Entity (WebDAV, RFC4918)"} ^:static unprocessable-entity HttpResponseStatus/UNPROCESSABLE_ENTITY)
(def ^{:doc "415 Unsupported Media Type"} ^:static unsupported-media-type HttpResponseStatus/UNSUPPORTED_MEDIA_TYPE)
(def ^{:doc "426 Upgrade Required (RFC2817)"} ^:static upgrade-required HttpResponseStatus/UPGRADE_REQUIRED)
(def ^{:doc "305 Use Proxy (since HTTP/1.1)"} ^:static use-proxy HttpResponseStatus/USE_PROXY)
(def ^{:doc "506 Variant Also Negotiates (RFC2295)"} ^:static variant-also-negotiates HttpResponseStatus/VARIANT_ALSO_NEGOTIATES)