(ns tandem.http.header
  
  "HTTP header name values, from Netty, for easy access.  There are many, many
  values defined in this namespace; we don't recommend just 'use'-ing it.  If
  you do 'use' instead of require it, you should exclude the range function from
  clojure.core."
  
  (:refer-clojure :exclude [range])
  (:use [clojure.string :only (lower-case)])
  (:import org.jboss.netty.handler.codec.http.HttpHeaders$Names))

(def ^{:doc "Accept"} ^:static accept (lower-case HttpHeaders$Names/ACCEPT))
(def ^{:doc "Accept-Charset"} ^:static accept-charset (lower-case (HttpHeaders$Names/ACCEPT_CHARSET)))
(def ^{:doc "Accept-Encoding"} ^:static accept-encoding (lower-case (HttpHeaders$Names/ACCEPT_ENCODING)))
(def ^{:doc "Accept-Language"} ^:static accept-language (lower-case (HttpHeaders$Names/ACCEPT_LANGUAGE)))
(def ^{:doc "Accept-Patch"} ^:static accept-patch (lower-case (HttpHeaders$Names/ACCEPT_PATCH)))
(def ^{:doc "Accept-Ranges"} ^:static accept-ranges (lower-case (HttpHeaders$Names/ACCEPT_RANGES)))
(def ^{:doc "Age"} ^:static age (lower-case (HttpHeaders$Names/AGE)))
(def ^{:doc "Allow"} ^:static allow (lower-case (HttpHeaders$Names/ALLOW)))
(def ^{:doc "Authorization"} ^:static authorization (lower-case (HttpHeaders$Names/AUTHORIZATION)))
(def ^{:doc "Cache-Control"} ^:static cache-control (lower-case (HttpHeaders$Names/CACHE_CONTROL)))
(def ^{:doc "Connection"} ^:static connection (lower-case (HttpHeaders$Names/CONNECTION)))
(def ^{:doc "Content-Base"} ^:static content-base (lower-case (HttpHeaders$Names/CONTENT_BASE)))
(def ^{:doc "Content-Encoding"} ^:static content-encoding (lower-case (HttpHeaders$Names/CONTENT_ENCODING)))
(def ^{:doc "Content-Language"} ^:static content-language (lower-case (HttpHeaders$Names/CONTENT_LANGUAGE)))
(def ^{:doc "Content-Length"} ^:static content-length (lower-case (HttpHeaders$Names/CONTENT_LENGTH)))
(def ^{:doc "Content-Location"} ^:static content-location (lower-case (HttpHeaders$Names/CONTENT_LOCATION)))
(def ^{:doc "Content-MD5"} ^:static content-md5 (lower-case (HttpHeaders$Names/CONTENT_MD5)))
(def ^{:doc "Content-Range"} ^:static content-range (lower-case (HttpHeaders$Names/CONTENT_RANGE)))
(def ^{:doc "Content-Transfer-Encoding"} ^:static content-transfer-encoding (lower-case (HttpHeaders$Names/CONTENT_TRANSFER_ENCODING)))
(def ^{:doc "Content-Type"} ^:static content-type (lower-case (HttpHeaders$Names/CONTENT_TYPE)))
(def ^{:doc "Cookie"} ^:static cookie (lower-case (HttpHeaders$Names/COOKIE)))
(def ^{:doc "Date"} ^:static date (lower-case (HttpHeaders$Names/DATE)))
(def ^{:doc "ETag"} ^:static etag (lower-case (HttpHeaders$Names/ETAG)))
(def ^{:doc "Expect"} ^:static expect (lower-case (HttpHeaders$Names/EXPECT)))
(def ^{:doc "Expires"} ^:static expires (lower-case (HttpHeaders$Names/EXPIRES)))
(def ^{:doc "From"} ^:static from (lower-case (HttpHeaders$Names/FROM)))
(def ^{:doc "Host"} ^:static host (lower-case (HttpHeaders$Names/HOST)))
(def ^{:doc "If-Match"} ^:static if-match (lower-case (HttpHeaders$Names/IF_MATCH)))
(def ^{:doc "If-Modified-Since"} ^:static if-modified-since (lower-case (HttpHeaders$Names/IF_MODIFIED_SINCE)))
(def ^{:doc "If-None-Match"} ^:static if-none-match (lower-case (HttpHeaders$Names/IF_NONE_MATCH)))
(def ^{:doc "If-Range"} ^:static if-range (lower-case (HttpHeaders$Names/IF_RANGE)))
(def ^{:doc "If-Unmodified-Since"} ^:static if-unmodified-since (lower-case (HttpHeaders$Names/IF_UNMODIFIED_SINCE)))
(def ^{:doc "Last-Modified"} ^:static last-modified (lower-case (HttpHeaders$Names/LAST_MODIFIED)))
(def ^{:doc "Location"} ^:static location (lower-case (HttpHeaders$Names/LOCATION)))
(def ^{:doc "Max-Forwards"} ^:static max-forwards (lower-case (HttpHeaders$Names/MAX_FORWARDS)))
(def ^{:doc "Origin"} ^:static origin (lower-case (HttpHeaders$Names/ORIGIN)))
(def ^{:doc "Pragma"} ^:static pragma (lower-case (HttpHeaders$Names/PRAGMA)))
(def ^{:doc "Proxy-Authenticate"} ^:static proxy-authenticate (lower-case (HttpHeaders$Names/PROXY_AUTHENTICATE)))
(def ^{:doc "Proxy-Authorization"} ^:static proxy-authorization (lower-case (HttpHeaders$Names/PROXY_AUTHORIZATION)))
(def ^{:doc "Range"} ^:static range (lower-case (HttpHeaders$Names/RANGE)))
(def ^{:doc "Referer"} ^:static referer (lower-case (HttpHeaders$Names/REFERER)))
(def ^{:doc "Retry-After"} ^:static retry-after (lower-case (HttpHeaders$Names/RETRY_AFTER)))
(def ^{:doc "Sec-WebSocket-Key1"} ^:static sec-websocket-key1 (lower-case (HttpHeaders$Names/SEC_WEBSOCKET_KEY1)))
(def ^{:doc "Sec-WebSocket-Key2"} ^:static sec-websocket-key2 (lower-case (HttpHeaders$Names/SEC_WEBSOCKET_KEY2)))
(def ^{:doc "Sec-WebSocket-Location"} ^:static sec-websocket-location (lower-case (HttpHeaders$Names/SEC_WEBSOCKET_LOCATION)))
(def ^{:doc "Sec-WebSocket-Origin"} ^:static sec-websocket-origin (lower-case (HttpHeaders$Names/SEC_WEBSOCKET_ORIGIN)))
(def ^{:doc "Sec-WebSocket-Protocol"} ^:static sec-websocket-protocol (lower-case (HttpHeaders$Names/SEC_WEBSOCKET_PROTOCOL)))
(def ^{:doc "Server"} ^:static server (lower-case (HttpHeaders$Names/SERVER)))
(def ^{:doc "Set-Cookie"} ^:static set-cookie (lower-case (HttpHeaders$Names/SET_COOKIE)))
(def ^{:doc "Set-Cookie2"} ^:static set-cookie2 (lower-case (HttpHeaders$Names/SET_COOKIE2)))
(def ^{:doc "TE"} ^:static te (lower-case (HttpHeaders$Names/TE)))
(def ^{:doc "Trailer"} ^:static trailer (lower-case (HttpHeaders$Names/TRAILER)))
(def ^{:doc "Transfer-Encoding"} ^:static transfer-encoding (lower-case (HttpHeaders$Names/TRANSFER_ENCODING)))
(def ^{:doc "Upgrade"} ^:static upgrade (lower-case (HttpHeaders$Names/UPGRADE)))
(def ^{:doc "User-Agent"} ^:static user-agent (lower-case (HttpHeaders$Names/USER_AGENT)))
(def ^{:doc "Vary"} ^:static vary (lower-case (HttpHeaders$Names/VARY)))
(def ^{:doc "Via"} ^:static via (lower-case (HttpHeaders$Names/VIA)))
(def ^{:doc "Warning"} ^:static warning (lower-case (HttpHeaders$Names/WARNING)))
(def ^{:doc "WebSocket-Location"} ^:static websocket-location (lower-case (HttpHeaders$Names/WEBSOCKET_LOCATION)))
(def ^{:doc "WebSocket-Origin"} ^:static websocket-origin (lower-case (HttpHeaders$Names/WEBSOCKET_ORIGIN)))
(def ^{:doc "WebSocket-Protocol"} ^:static websocket-protocol (lower-case (HttpHeaders$Names/WEBSOCKET_PROTOCOL)))
(def ^{:doc "WWW-Authenticate"} ^:static www-authenticate (lower-case (HttpHeaders$Names/WWW_AUTHENTICATE)))

;; Not included by Netty 
(def ^{:doc "X-Scheme"} ^:static x-scheme "x-scheme")
