(ns phosphor.icon
  (:refer-clojure :exclude [atom cat divide drop empty hash key list repeat shuffle])
  (:require [shadow.resource :as rc]
            [vrac.web :as vw :refer [$]]
            [phosphor.icon-svg :as svg]))

(defn icon-component [svg-str]
  (fn [props]
    ($ (vw/html-text-to-dom svg-str)
       {:class ["icon"]
        :width "1em"
        :height "1em"}
       props)))

(def acorn-bold (icon-component svg/acorn-bold))
(def acorn (icon-component svg/acorn-regular))
(def acorn-light (icon-component svg/acorn-light))
(def acorn-thin (icon-component svg/acorn-thin))
(def acorn-fill (icon-component svg/acorn-fill))
(def acorn-duotone (icon-component svg/acorn-duotone))
(def address-book-bold (icon-component svg/address-book-bold))
(def address-book (icon-component svg/address-book-regular))
(def address-book-light (icon-component svg/address-book-light))
(def address-book-thin (icon-component svg/address-book-thin))
(def address-book-fill (icon-component svg/address-book-fill))
(def address-book-duotone (icon-component svg/address-book-duotone))
(def address-book-tabs-bold (icon-component svg/address-book-tabs-bold))
(def address-book-tabs (icon-component svg/address-book-tabs-regular))
(def address-book-tabs-light (icon-component svg/address-book-tabs-light))
(def address-book-tabs-thin (icon-component svg/address-book-tabs-thin))
(def address-book-tabs-fill (icon-component svg/address-book-tabs-fill))
(def address-book-tabs-duotone (icon-component svg/address-book-tabs-duotone))
(def air-traffic-control-bold (icon-component svg/air-traffic-control-bold))
(def air-traffic-control (icon-component svg/air-traffic-control-regular))
(def air-traffic-control-light (icon-component svg/air-traffic-control-light))
(def air-traffic-control-thin (icon-component svg/air-traffic-control-thin))
(def air-traffic-control-fill (icon-component svg/air-traffic-control-fill))
(def air-traffic-control-duotone (icon-component svg/air-traffic-control-duotone))
(def airplane-bold (icon-component svg/airplane-bold))
(def airplane (icon-component svg/airplane-regular))
(def airplane-light (icon-component svg/airplane-light))
(def airplane-thin (icon-component svg/airplane-thin))
(def airplane-fill (icon-component svg/airplane-fill))
(def airplane-duotone (icon-component svg/airplane-duotone))
(def airplane-in-flight-bold (icon-component svg/airplane-in-flight-bold))
(def airplane-in-flight (icon-component svg/airplane-in-flight-regular))
(def airplane-in-flight-light (icon-component svg/airplane-in-flight-light))
(def airplane-in-flight-thin (icon-component svg/airplane-in-flight-thin))
(def airplane-in-flight-fill (icon-component svg/airplane-in-flight-fill))
(def airplane-in-flight-duotone (icon-component svg/airplane-in-flight-duotone))
(def airplane-landing-bold (icon-component svg/airplane-landing-bold))
(def airplane-landing (icon-component svg/airplane-landing-regular))
(def airplane-landing-light (icon-component svg/airplane-landing-light))
(def airplane-landing-thin (icon-component svg/airplane-landing-thin))
(def airplane-landing-fill (icon-component svg/airplane-landing-fill))
(def airplane-landing-duotone (icon-component svg/airplane-landing-duotone))
(def airplane-takeoff-bold (icon-component svg/airplane-takeoff-bold))
(def airplane-takeoff (icon-component svg/airplane-takeoff-regular))
(def airplane-takeoff-light (icon-component svg/airplane-takeoff-light))
(def airplane-takeoff-thin (icon-component svg/airplane-takeoff-thin))
(def airplane-takeoff-fill (icon-component svg/airplane-takeoff-fill))
(def airplane-takeoff-duotone (icon-component svg/airplane-takeoff-duotone))
(def airplane-taxiing-bold (icon-component svg/airplane-taxiing-bold))
(def airplane-taxiing (icon-component svg/airplane-taxiing-regular))
(def airplane-taxiing-light (icon-component svg/airplane-taxiing-light))
(def airplane-taxiing-thin (icon-component svg/airplane-taxiing-thin))
(def airplane-taxiing-fill (icon-component svg/airplane-taxiing-fill))
(def airplane-taxiing-duotone (icon-component svg/airplane-taxiing-duotone))
(def airplane-tilt-bold (icon-component svg/airplane-tilt-bold))
(def airplane-tilt (icon-component svg/airplane-tilt-regular))
(def airplane-tilt-light (icon-component svg/airplane-tilt-light))
(def airplane-tilt-thin (icon-component svg/airplane-tilt-thin))
(def airplane-tilt-fill (icon-component svg/airplane-tilt-fill))
(def airplane-tilt-duotone (icon-component svg/airplane-tilt-duotone))
(def airplay-bold (icon-component svg/airplay-bold))
(def airplay (icon-component svg/airplay-regular))
(def airplay-light (icon-component svg/airplay-light))
(def airplay-thin (icon-component svg/airplay-thin))
(def airplay-fill (icon-component svg/airplay-fill))
(def airplay-duotone (icon-component svg/airplay-duotone))
(def alarm-bold (icon-component svg/alarm-bold))
(def alarm (icon-component svg/alarm-regular))
(def alarm-light (icon-component svg/alarm-light))
(def alarm-thin (icon-component svg/alarm-thin))
(def alarm-fill (icon-component svg/alarm-fill))
(def alarm-duotone (icon-component svg/alarm-duotone))
(def alien-bold (icon-component svg/alien-bold))
(def alien (icon-component svg/alien-regular))
(def alien-light (icon-component svg/alien-light))
(def alien-thin (icon-component svg/alien-thin))
(def alien-fill (icon-component svg/alien-fill))
(def alien-duotone (icon-component svg/alien-duotone))
(def align-bottom-bold (icon-component svg/align-bottom-bold))
(def align-bottom (icon-component svg/align-bottom-regular))
(def align-bottom-light (icon-component svg/align-bottom-light))
(def align-bottom-thin (icon-component svg/align-bottom-thin))
(def align-bottom-fill (icon-component svg/align-bottom-fill))
(def align-bottom-duotone (icon-component svg/align-bottom-duotone))
(def align-bottom-simple-bold (icon-component svg/align-bottom-simple-bold))
(def align-bottom-simple (icon-component svg/align-bottom-simple-regular))
(def align-bottom-simple-light (icon-component svg/align-bottom-simple-light))
(def align-bottom-simple-thin (icon-component svg/align-bottom-simple-thin))
(def align-bottom-simple-fill (icon-component svg/align-bottom-simple-fill))
(def align-bottom-simple-duotone (icon-component svg/align-bottom-simple-duotone))
(def align-center-horizontal-bold (icon-component svg/align-center-horizontal-bold))
(def align-center-horizontal (icon-component svg/align-center-horizontal-regular))
(def align-center-horizontal-light (icon-component svg/align-center-horizontal-light))
(def align-center-horizontal-thin (icon-component svg/align-center-horizontal-thin))
(def align-center-horizontal-fill (icon-component svg/align-center-horizontal-fill))
(def align-center-horizontal-duotone (icon-component svg/align-center-horizontal-duotone))
(def align-center-horizontal-simple-bold (icon-component svg/align-center-horizontal-simple-bold))
(def align-center-horizontal-simple (icon-component svg/align-center-horizontal-simple-regular))
(def align-center-horizontal-simple-light (icon-component svg/align-center-horizontal-simple-light))
(def align-center-horizontal-simple-thin (icon-component svg/align-center-horizontal-simple-thin))
(def align-center-horizontal-simple-fill (icon-component svg/align-center-horizontal-simple-fill))
(def align-center-horizontal-simple-duotone (icon-component svg/align-center-horizontal-simple-duotone))
(def align-center-vertical-bold (icon-component svg/align-center-vertical-bold))
(def align-center-vertical (icon-component svg/align-center-vertical-regular))
(def align-center-vertical-light (icon-component svg/align-center-vertical-light))
(def align-center-vertical-thin (icon-component svg/align-center-vertical-thin))
(def align-center-vertical-fill (icon-component svg/align-center-vertical-fill))
(def align-center-vertical-duotone (icon-component svg/align-center-vertical-duotone))
(def align-center-vertical-simple-bold (icon-component svg/align-center-vertical-simple-bold))
(def align-center-vertical-simple (icon-component svg/align-center-vertical-simple-regular))
(def align-center-vertical-simple-light (icon-component svg/align-center-vertical-simple-light))
(def align-center-vertical-simple-thin (icon-component svg/align-center-vertical-simple-thin))
(def align-center-vertical-simple-fill (icon-component svg/align-center-vertical-simple-fill))
(def align-center-vertical-simple-duotone (icon-component svg/align-center-vertical-simple-duotone))
(def align-left-bold (icon-component svg/align-left-bold))
(def align-left (icon-component svg/align-left-regular))
(def align-left-light (icon-component svg/align-left-light))
(def align-left-thin (icon-component svg/align-left-thin))
(def align-left-fill (icon-component svg/align-left-fill))
(def align-left-duotone (icon-component svg/align-left-duotone))
(def align-left-simple-bold (icon-component svg/align-left-simple-bold))
(def align-left-simple (icon-component svg/align-left-simple-regular))
(def align-left-simple-light (icon-component svg/align-left-simple-light))
(def align-left-simple-thin (icon-component svg/align-left-simple-thin))
(def align-left-simple-fill (icon-component svg/align-left-simple-fill))
(def align-left-simple-duotone (icon-component svg/align-left-simple-duotone))
(def align-right-bold (icon-component svg/align-right-bold))
(def align-right (icon-component svg/align-right-regular))
(def align-right-light (icon-component svg/align-right-light))
(def align-right-thin (icon-component svg/align-right-thin))
(def align-right-fill (icon-component svg/align-right-fill))
(def align-right-duotone (icon-component svg/align-right-duotone))
(def align-right-simple-bold (icon-component svg/align-right-simple-bold))
(def align-right-simple (icon-component svg/align-right-simple-regular))
(def align-right-simple-light (icon-component svg/align-right-simple-light))
(def align-right-simple-thin (icon-component svg/align-right-simple-thin))
(def align-right-simple-fill (icon-component svg/align-right-simple-fill))
(def align-right-simple-duotone (icon-component svg/align-right-simple-duotone))
(def align-top-bold (icon-component svg/align-top-bold))
(def align-top (icon-component svg/align-top-regular))
(def align-top-light (icon-component svg/align-top-light))
(def align-top-thin (icon-component svg/align-top-thin))
(def align-top-fill (icon-component svg/align-top-fill))
(def align-top-duotone (icon-component svg/align-top-duotone))
(def align-top-simple-bold (icon-component svg/align-top-simple-bold))
(def align-top-simple (icon-component svg/align-top-simple-regular))
(def align-top-simple-light (icon-component svg/align-top-simple-light))
(def align-top-simple-thin (icon-component svg/align-top-simple-thin))
(def align-top-simple-fill (icon-component svg/align-top-simple-fill))
(def align-top-simple-duotone (icon-component svg/align-top-simple-duotone))
(def amazon-logo-bold (icon-component svg/amazon-logo-bold))
(def amazon-logo (icon-component svg/amazon-logo-regular))
(def amazon-logo-light (icon-component svg/amazon-logo-light))
(def amazon-logo-thin (icon-component svg/amazon-logo-thin))
(def amazon-logo-fill (icon-component svg/amazon-logo-fill))
(def amazon-logo-duotone (icon-component svg/amazon-logo-duotone))
(def ambulance-bold (icon-component svg/ambulance-bold))
(def ambulance (icon-component svg/ambulance-regular))
(def ambulance-light (icon-component svg/ambulance-light))
(def ambulance-thin (icon-component svg/ambulance-thin))
(def ambulance-fill (icon-component svg/ambulance-fill))
(def ambulance-duotone (icon-component svg/ambulance-duotone))
(def anchor-bold (icon-component svg/anchor-bold))
(def anchor (icon-component svg/anchor-regular))
(def anchor-light (icon-component svg/anchor-light))
(def anchor-thin (icon-component svg/anchor-thin))
(def anchor-fill (icon-component svg/anchor-fill))
(def anchor-duotone (icon-component svg/anchor-duotone))
(def anchor-simple-bold (icon-component svg/anchor-simple-bold))
(def anchor-simple (icon-component svg/anchor-simple-regular))
(def anchor-simple-light (icon-component svg/anchor-simple-light))
(def anchor-simple-thin (icon-component svg/anchor-simple-thin))
(def anchor-simple-fill (icon-component svg/anchor-simple-fill))
(def anchor-simple-duotone (icon-component svg/anchor-simple-duotone))
(def android-logo-bold (icon-component svg/android-logo-bold))
(def android-logo (icon-component svg/android-logo-regular))
(def android-logo-light (icon-component svg/android-logo-light))
(def android-logo-thin (icon-component svg/android-logo-thin))
(def android-logo-fill (icon-component svg/android-logo-fill))
(def android-logo-duotone (icon-component svg/android-logo-duotone))
(def angle-bold (icon-component svg/angle-bold))
(def angle (icon-component svg/angle-regular))
(def angle-light (icon-component svg/angle-light))
(def angle-thin (icon-component svg/angle-thin))
(def angle-fill (icon-component svg/angle-fill))
(def angle-duotone (icon-component svg/angle-duotone))
(def angular-logo-bold (icon-component svg/angular-logo-bold))
(def angular-logo (icon-component svg/angular-logo-regular))
(def angular-logo-light (icon-component svg/angular-logo-light))
(def angular-logo-thin (icon-component svg/angular-logo-thin))
(def angular-logo-fill (icon-component svg/angular-logo-fill))
(def angular-logo-duotone (icon-component svg/angular-logo-duotone))
(def aperture-bold (icon-component svg/aperture-bold))
(def aperture (icon-component svg/aperture-regular))
(def aperture-light (icon-component svg/aperture-light))
(def aperture-thin (icon-component svg/aperture-thin))
(def aperture-fill (icon-component svg/aperture-fill))
(def aperture-duotone (icon-component svg/aperture-duotone))
(def app-store-logo-bold (icon-component svg/app-store-logo-bold))
(def app-store-logo (icon-component svg/app-store-logo-regular))
(def app-store-logo-light (icon-component svg/app-store-logo-light))
(def app-store-logo-thin (icon-component svg/app-store-logo-thin))
(def app-store-logo-fill (icon-component svg/app-store-logo-fill))
(def app-store-logo-duotone (icon-component svg/app-store-logo-duotone))
(def app-window-bold (icon-component svg/app-window-bold))
(def app-window (icon-component svg/app-window-regular))
(def app-window-light (icon-component svg/app-window-light))
(def app-window-thin (icon-component svg/app-window-thin))
(def app-window-fill (icon-component svg/app-window-fill))
(def app-window-duotone (icon-component svg/app-window-duotone))
(def apple-logo-bold (icon-component svg/apple-logo-bold))
(def apple-logo (icon-component svg/apple-logo-regular))
(def apple-logo-light (icon-component svg/apple-logo-light))
(def apple-logo-thin (icon-component svg/apple-logo-thin))
(def apple-logo-fill (icon-component svg/apple-logo-fill))
(def apple-logo-duotone (icon-component svg/apple-logo-duotone))
(def apple-podcasts-logo-bold (icon-component svg/apple-podcasts-logo-bold))
(def apple-podcasts-logo (icon-component svg/apple-podcasts-logo-regular))
(def apple-podcasts-logo-light (icon-component svg/apple-podcasts-logo-light))
(def apple-podcasts-logo-thin (icon-component svg/apple-podcasts-logo-thin))
(def apple-podcasts-logo-fill (icon-component svg/apple-podcasts-logo-fill))
(def apple-podcasts-logo-duotone (icon-component svg/apple-podcasts-logo-duotone))
(def approximate-equals-bold (icon-component svg/approximate-equals-bold))
(def approximate-equals (icon-component svg/approximate-equals-regular))
(def approximate-equals-light (icon-component svg/approximate-equals-light))
(def approximate-equals-thin (icon-component svg/approximate-equals-thin))
(def approximate-equals-fill (icon-component svg/approximate-equals-fill))
(def approximate-equals-duotone (icon-component svg/approximate-equals-duotone))
(def archive-bold (icon-component svg/archive-bold))
(def archive (icon-component svg/archive-regular))
(def archive-light (icon-component svg/archive-light))
(def archive-thin (icon-component svg/archive-thin))
(def archive-fill (icon-component svg/archive-fill))
(def archive-duotone (icon-component svg/archive-duotone))
(def armchair-bold (icon-component svg/armchair-bold))
(def armchair (icon-component svg/armchair-regular))
(def armchair-light (icon-component svg/armchair-light))
(def armchair-thin (icon-component svg/armchair-thin))
(def armchair-fill (icon-component svg/armchair-fill))
(def armchair-duotone (icon-component svg/armchair-duotone))
(def arrow-arc-left-bold (icon-component svg/arrow-arc-left-bold))
(def arrow-arc-left (icon-component svg/arrow-arc-left-regular))
(def arrow-arc-left-light (icon-component svg/arrow-arc-left-light))
(def arrow-arc-left-thin (icon-component svg/arrow-arc-left-thin))
(def arrow-arc-left-fill (icon-component svg/arrow-arc-left-fill))
(def arrow-arc-left-duotone (icon-component svg/arrow-arc-left-duotone))
(def arrow-arc-right-bold (icon-component svg/arrow-arc-right-bold))
(def arrow-arc-right (icon-component svg/arrow-arc-right-regular))
(def arrow-arc-right-light (icon-component svg/arrow-arc-right-light))
(def arrow-arc-right-thin (icon-component svg/arrow-arc-right-thin))
(def arrow-arc-right-fill (icon-component svg/arrow-arc-right-fill))
(def arrow-arc-right-duotone (icon-component svg/arrow-arc-right-duotone))
(def arrow-bend-double-up-left-bold (icon-component svg/arrow-bend-double-up-left-bold))
(def arrow-bend-double-up-left (icon-component svg/arrow-bend-double-up-left-regular))
(def arrow-bend-double-up-left-light (icon-component svg/arrow-bend-double-up-left-light))
(def arrow-bend-double-up-left-thin (icon-component svg/arrow-bend-double-up-left-thin))
(def arrow-bend-double-up-left-fill (icon-component svg/arrow-bend-double-up-left-fill))
(def arrow-bend-double-up-left-duotone (icon-component svg/arrow-bend-double-up-left-duotone))
(def arrow-bend-double-up-right-bold (icon-component svg/arrow-bend-double-up-right-bold))
(def arrow-bend-double-up-right (icon-component svg/arrow-bend-double-up-right-regular))
(def arrow-bend-double-up-right-light (icon-component svg/arrow-bend-double-up-right-light))
(def arrow-bend-double-up-right-thin (icon-component svg/arrow-bend-double-up-right-thin))
(def arrow-bend-double-up-right-fill (icon-component svg/arrow-bend-double-up-right-fill))
(def arrow-bend-double-up-right-duotone (icon-component svg/arrow-bend-double-up-right-duotone))
(def arrow-bend-down-left-bold (icon-component svg/arrow-bend-down-left-bold))
(def arrow-bend-down-left (icon-component svg/arrow-bend-down-left-regular))
(def arrow-bend-down-left-light (icon-component svg/arrow-bend-down-left-light))
(def arrow-bend-down-left-thin (icon-component svg/arrow-bend-down-left-thin))
(def arrow-bend-down-left-fill (icon-component svg/arrow-bend-down-left-fill))
(def arrow-bend-down-left-duotone (icon-component svg/arrow-bend-down-left-duotone))
(def arrow-bend-down-right-bold (icon-component svg/arrow-bend-down-right-bold))
(def arrow-bend-down-right (icon-component svg/arrow-bend-down-right-regular))
(def arrow-bend-down-right-light (icon-component svg/arrow-bend-down-right-light))
(def arrow-bend-down-right-thin (icon-component svg/arrow-bend-down-right-thin))
(def arrow-bend-down-right-fill (icon-component svg/arrow-bend-down-right-fill))
(def arrow-bend-down-right-duotone (icon-component svg/arrow-bend-down-right-duotone))
(def arrow-bend-left-down-bold (icon-component svg/arrow-bend-left-down-bold))
(def arrow-bend-left-down (icon-component svg/arrow-bend-left-down-regular))
(def arrow-bend-left-down-light (icon-component svg/arrow-bend-left-down-light))
(def arrow-bend-left-down-thin (icon-component svg/arrow-bend-left-down-thin))
(def arrow-bend-left-down-fill (icon-component svg/arrow-bend-left-down-fill))
(def arrow-bend-left-down-duotone (icon-component svg/arrow-bend-left-down-duotone))
(def arrow-bend-left-up-bold (icon-component svg/arrow-bend-left-up-bold))
(def arrow-bend-left-up (icon-component svg/arrow-bend-left-up-regular))
(def arrow-bend-left-up-light (icon-component svg/arrow-bend-left-up-light))
(def arrow-bend-left-up-thin (icon-component svg/arrow-bend-left-up-thin))
(def arrow-bend-left-up-fill (icon-component svg/arrow-bend-left-up-fill))
(def arrow-bend-left-up-duotone (icon-component svg/arrow-bend-left-up-duotone))
(def arrow-bend-right-down-bold (icon-component svg/arrow-bend-right-down-bold))
(def arrow-bend-right-down (icon-component svg/arrow-bend-right-down-regular))
(def arrow-bend-right-down-light (icon-component svg/arrow-bend-right-down-light))
(def arrow-bend-right-down-thin (icon-component svg/arrow-bend-right-down-thin))
(def arrow-bend-right-down-fill (icon-component svg/arrow-bend-right-down-fill))
(def arrow-bend-right-down-duotone (icon-component svg/arrow-bend-right-down-duotone))
(def arrow-bend-right-up-bold (icon-component svg/arrow-bend-right-up-bold))
(def arrow-bend-right-up (icon-component svg/arrow-bend-right-up-regular))
(def arrow-bend-right-up-light (icon-component svg/arrow-bend-right-up-light))
(def arrow-bend-right-up-thin (icon-component svg/arrow-bend-right-up-thin))
(def arrow-bend-right-up-fill (icon-component svg/arrow-bend-right-up-fill))
(def arrow-bend-right-up-duotone (icon-component svg/arrow-bend-right-up-duotone))
(def arrow-bend-up-left-bold (icon-component svg/arrow-bend-up-left-bold))
(def arrow-bend-up-left (icon-component svg/arrow-bend-up-left-regular))
(def arrow-bend-up-left-light (icon-component svg/arrow-bend-up-left-light))
(def arrow-bend-up-left-thin (icon-component svg/arrow-bend-up-left-thin))
(def arrow-bend-up-left-fill (icon-component svg/arrow-bend-up-left-fill))
(def arrow-bend-up-left-duotone (icon-component svg/arrow-bend-up-left-duotone))
(def arrow-bend-up-right-bold (icon-component svg/arrow-bend-up-right-bold))
(def arrow-bend-up-right (icon-component svg/arrow-bend-up-right-regular))
(def arrow-bend-up-right-light (icon-component svg/arrow-bend-up-right-light))
(def arrow-bend-up-right-thin (icon-component svg/arrow-bend-up-right-thin))
(def arrow-bend-up-right-fill (icon-component svg/arrow-bend-up-right-fill))
(def arrow-bend-up-right-duotone (icon-component svg/arrow-bend-up-right-duotone))
(def arrow-circle-down-bold (icon-component svg/arrow-circle-down-bold))
(def arrow-circle-down (icon-component svg/arrow-circle-down-regular))
(def arrow-circle-down-light (icon-component svg/arrow-circle-down-light))
(def arrow-circle-down-thin (icon-component svg/arrow-circle-down-thin))
(def arrow-circle-down-fill (icon-component svg/arrow-circle-down-fill))
(def arrow-circle-down-duotone (icon-component svg/arrow-circle-down-duotone))
(def arrow-circle-down-left-bold (icon-component svg/arrow-circle-down-left-bold))
(def arrow-circle-down-left (icon-component svg/arrow-circle-down-left-regular))
(def arrow-circle-down-left-light (icon-component svg/arrow-circle-down-left-light))
(def arrow-circle-down-left-thin (icon-component svg/arrow-circle-down-left-thin))
(def arrow-circle-down-left-fill (icon-component svg/arrow-circle-down-left-fill))
(def arrow-circle-down-left-duotone (icon-component svg/arrow-circle-down-left-duotone))
(def arrow-circle-down-right-bold (icon-component svg/arrow-circle-down-right-bold))
(def arrow-circle-down-right (icon-component svg/arrow-circle-down-right-regular))
(def arrow-circle-down-right-light (icon-component svg/arrow-circle-down-right-light))
(def arrow-circle-down-right-thin (icon-component svg/arrow-circle-down-right-thin))
(def arrow-circle-down-right-fill (icon-component svg/arrow-circle-down-right-fill))
(def arrow-circle-down-right-duotone (icon-component svg/arrow-circle-down-right-duotone))
(def arrow-circle-left-bold (icon-component svg/arrow-circle-left-bold))
(def arrow-circle-left (icon-component svg/arrow-circle-left-regular))
(def arrow-circle-left-light (icon-component svg/arrow-circle-left-light))
(def arrow-circle-left-thin (icon-component svg/arrow-circle-left-thin))
(def arrow-circle-left-fill (icon-component svg/arrow-circle-left-fill))
(def arrow-circle-left-duotone (icon-component svg/arrow-circle-left-duotone))
(def arrow-circle-right-bold (icon-component svg/arrow-circle-right-bold))
(def arrow-circle-right (icon-component svg/arrow-circle-right-regular))
(def arrow-circle-right-light (icon-component svg/arrow-circle-right-light))
(def arrow-circle-right-thin (icon-component svg/arrow-circle-right-thin))
(def arrow-circle-right-fill (icon-component svg/arrow-circle-right-fill))
(def arrow-circle-right-duotone (icon-component svg/arrow-circle-right-duotone))
(def arrow-circle-up-bold (icon-component svg/arrow-circle-up-bold))
(def arrow-circle-up (icon-component svg/arrow-circle-up-regular))
(def arrow-circle-up-light (icon-component svg/arrow-circle-up-light))
(def arrow-circle-up-thin (icon-component svg/arrow-circle-up-thin))
(def arrow-circle-up-fill (icon-component svg/arrow-circle-up-fill))
(def arrow-circle-up-duotone (icon-component svg/arrow-circle-up-duotone))
(def arrow-circle-up-left-bold (icon-component svg/arrow-circle-up-left-bold))
(def arrow-circle-up-left (icon-component svg/arrow-circle-up-left-regular))
(def arrow-circle-up-left-light (icon-component svg/arrow-circle-up-left-light))
(def arrow-circle-up-left-thin (icon-component svg/arrow-circle-up-left-thin))
(def arrow-circle-up-left-fill (icon-component svg/arrow-circle-up-left-fill))
(def arrow-circle-up-left-duotone (icon-component svg/arrow-circle-up-left-duotone))
(def arrow-circle-up-right-bold (icon-component svg/arrow-circle-up-right-bold))
(def arrow-circle-up-right (icon-component svg/arrow-circle-up-right-regular))
(def arrow-circle-up-right-light (icon-component svg/arrow-circle-up-right-light))
(def arrow-circle-up-right-thin (icon-component svg/arrow-circle-up-right-thin))
(def arrow-circle-up-right-fill (icon-component svg/arrow-circle-up-right-fill))
(def arrow-circle-up-right-duotone (icon-component svg/arrow-circle-up-right-duotone))
(def arrow-clockwise-bold (icon-component svg/arrow-clockwise-bold))
(def arrow-clockwise (icon-component svg/arrow-clockwise-regular))
(def arrow-clockwise-light (icon-component svg/arrow-clockwise-light))
(def arrow-clockwise-thin (icon-component svg/arrow-clockwise-thin))
(def arrow-clockwise-fill (icon-component svg/arrow-clockwise-fill))
(def arrow-clockwise-duotone (icon-component svg/arrow-clockwise-duotone))
(def arrow-counter-clockwise-bold (icon-component svg/arrow-counter-clockwise-bold))
(def arrow-counter-clockwise (icon-component svg/arrow-counter-clockwise-regular))
(def arrow-counter-clockwise-light (icon-component svg/arrow-counter-clockwise-light))
(def arrow-counter-clockwise-thin (icon-component svg/arrow-counter-clockwise-thin))
(def arrow-counter-clockwise-fill (icon-component svg/arrow-counter-clockwise-fill))
(def arrow-counter-clockwise-duotone (icon-component svg/arrow-counter-clockwise-duotone))
(def arrow-down-bold (icon-component svg/arrow-down-bold))
(def arrow-down (icon-component svg/arrow-down-regular))
(def arrow-down-light (icon-component svg/arrow-down-light))
(def arrow-down-thin (icon-component svg/arrow-down-thin))
(def arrow-down-fill (icon-component svg/arrow-down-fill))
(def arrow-down-duotone (icon-component svg/arrow-down-duotone))
(def arrow-down-left-bold (icon-component svg/arrow-down-left-bold))
(def arrow-down-left (icon-component svg/arrow-down-left-regular))
(def arrow-down-left-light (icon-component svg/arrow-down-left-light))
(def arrow-down-left-thin (icon-component svg/arrow-down-left-thin))
(def arrow-down-left-fill (icon-component svg/arrow-down-left-fill))
(def arrow-down-left-duotone (icon-component svg/arrow-down-left-duotone))
(def arrow-down-right-bold (icon-component svg/arrow-down-right-bold))
(def arrow-down-right (icon-component svg/arrow-down-right-regular))
(def arrow-down-right-light (icon-component svg/arrow-down-right-light))
(def arrow-down-right-thin (icon-component svg/arrow-down-right-thin))
(def arrow-down-right-fill (icon-component svg/arrow-down-right-fill))
(def arrow-down-right-duotone (icon-component svg/arrow-down-right-duotone))
(def arrow-elbow-down-left-bold (icon-component svg/arrow-elbow-down-left-bold))
(def arrow-elbow-down-left (icon-component svg/arrow-elbow-down-left-regular))
(def arrow-elbow-down-left-light (icon-component svg/arrow-elbow-down-left-light))
(def arrow-elbow-down-left-thin (icon-component svg/arrow-elbow-down-left-thin))
(def arrow-elbow-down-left-fill (icon-component svg/arrow-elbow-down-left-fill))
(def arrow-elbow-down-left-duotone (icon-component svg/arrow-elbow-down-left-duotone))
(def arrow-elbow-down-right-bold (icon-component svg/arrow-elbow-down-right-bold))
(def arrow-elbow-down-right (icon-component svg/arrow-elbow-down-right-regular))
(def arrow-elbow-down-right-light (icon-component svg/arrow-elbow-down-right-light))
(def arrow-elbow-down-right-thin (icon-component svg/arrow-elbow-down-right-thin))
(def arrow-elbow-down-right-fill (icon-component svg/arrow-elbow-down-right-fill))
(def arrow-elbow-down-right-duotone (icon-component svg/arrow-elbow-down-right-duotone))
(def arrow-elbow-left-bold (icon-component svg/arrow-elbow-left-bold))
(def arrow-elbow-left (icon-component svg/arrow-elbow-left-regular))
(def arrow-elbow-left-light (icon-component svg/arrow-elbow-left-light))
(def arrow-elbow-left-thin (icon-component svg/arrow-elbow-left-thin))
(def arrow-elbow-left-fill (icon-component svg/arrow-elbow-left-fill))
(def arrow-elbow-left-duotone (icon-component svg/arrow-elbow-left-duotone))
(def arrow-elbow-left-down-bold (icon-component svg/arrow-elbow-left-down-bold))
(def arrow-elbow-left-down (icon-component svg/arrow-elbow-left-down-regular))
(def arrow-elbow-left-down-light (icon-component svg/arrow-elbow-left-down-light))
(def arrow-elbow-left-down-thin (icon-component svg/arrow-elbow-left-down-thin))
(def arrow-elbow-left-down-fill (icon-component svg/arrow-elbow-left-down-fill))
(def arrow-elbow-left-down-duotone (icon-component svg/arrow-elbow-left-down-duotone))
(def arrow-elbow-left-up-bold (icon-component svg/arrow-elbow-left-up-bold))
(def arrow-elbow-left-up (icon-component svg/arrow-elbow-left-up-regular))
(def arrow-elbow-left-up-light (icon-component svg/arrow-elbow-left-up-light))
(def arrow-elbow-left-up-thin (icon-component svg/arrow-elbow-left-up-thin))
(def arrow-elbow-left-up-fill (icon-component svg/arrow-elbow-left-up-fill))
(def arrow-elbow-left-up-duotone (icon-component svg/arrow-elbow-left-up-duotone))
(def arrow-elbow-right-bold (icon-component svg/arrow-elbow-right-bold))
(def arrow-elbow-right (icon-component svg/arrow-elbow-right-regular))
(def arrow-elbow-right-light (icon-component svg/arrow-elbow-right-light))
(def arrow-elbow-right-thin (icon-component svg/arrow-elbow-right-thin))
(def arrow-elbow-right-fill (icon-component svg/arrow-elbow-right-fill))
(def arrow-elbow-right-duotone (icon-component svg/arrow-elbow-right-duotone))
(def arrow-elbow-right-down-bold (icon-component svg/arrow-elbow-right-down-bold))
(def arrow-elbow-right-down (icon-component svg/arrow-elbow-right-down-regular))
(def arrow-elbow-right-down-light (icon-component svg/arrow-elbow-right-down-light))
(def arrow-elbow-right-down-thin (icon-component svg/arrow-elbow-right-down-thin))
(def arrow-elbow-right-down-fill (icon-component svg/arrow-elbow-right-down-fill))
(def arrow-elbow-right-down-duotone (icon-component svg/arrow-elbow-right-down-duotone))
(def arrow-elbow-right-up-bold (icon-component svg/arrow-elbow-right-up-bold))
(def arrow-elbow-right-up (icon-component svg/arrow-elbow-right-up-regular))
(def arrow-elbow-right-up-light (icon-component svg/arrow-elbow-right-up-light))
(def arrow-elbow-right-up-thin (icon-component svg/arrow-elbow-right-up-thin))
(def arrow-elbow-right-up-fill (icon-component svg/arrow-elbow-right-up-fill))
(def arrow-elbow-right-up-duotone (icon-component svg/arrow-elbow-right-up-duotone))
(def arrow-elbow-up-left-bold (icon-component svg/arrow-elbow-up-left-bold))
(def arrow-elbow-up-left (icon-component svg/arrow-elbow-up-left-regular))
(def arrow-elbow-up-left-light (icon-component svg/arrow-elbow-up-left-light))
(def arrow-elbow-up-left-thin (icon-component svg/arrow-elbow-up-left-thin))
(def arrow-elbow-up-left-fill (icon-component svg/arrow-elbow-up-left-fill))
(def arrow-elbow-up-left-duotone (icon-component svg/arrow-elbow-up-left-duotone))
(def arrow-elbow-up-right-bold (icon-component svg/arrow-elbow-up-right-bold))
(def arrow-elbow-up-right (icon-component svg/arrow-elbow-up-right-regular))
(def arrow-elbow-up-right-light (icon-component svg/arrow-elbow-up-right-light))
(def arrow-elbow-up-right-thin (icon-component svg/arrow-elbow-up-right-thin))
(def arrow-elbow-up-right-fill (icon-component svg/arrow-elbow-up-right-fill))
(def arrow-elbow-up-right-duotone (icon-component svg/arrow-elbow-up-right-duotone))
(def arrow-fat-down-bold (icon-component svg/arrow-fat-down-bold))
(def arrow-fat-down (icon-component svg/arrow-fat-down-regular))
(def arrow-fat-down-light (icon-component svg/arrow-fat-down-light))
(def arrow-fat-down-thin (icon-component svg/arrow-fat-down-thin))
(def arrow-fat-down-fill (icon-component svg/arrow-fat-down-fill))
(def arrow-fat-down-duotone (icon-component svg/arrow-fat-down-duotone))
(def arrow-fat-left-bold (icon-component svg/arrow-fat-left-bold))
(def arrow-fat-left (icon-component svg/arrow-fat-left-regular))
(def arrow-fat-left-light (icon-component svg/arrow-fat-left-light))
(def arrow-fat-left-thin (icon-component svg/arrow-fat-left-thin))
(def arrow-fat-left-fill (icon-component svg/arrow-fat-left-fill))
(def arrow-fat-left-duotone (icon-component svg/arrow-fat-left-duotone))
(def arrow-fat-line-down-bold (icon-component svg/arrow-fat-line-down-bold))
(def arrow-fat-line-down (icon-component svg/arrow-fat-line-down-regular))
(def arrow-fat-line-down-light (icon-component svg/arrow-fat-line-down-light))
(def arrow-fat-line-down-thin (icon-component svg/arrow-fat-line-down-thin))
(def arrow-fat-line-down-fill (icon-component svg/arrow-fat-line-down-fill))
(def arrow-fat-line-down-duotone (icon-component svg/arrow-fat-line-down-duotone))
(def arrow-fat-line-left-bold (icon-component svg/arrow-fat-line-left-bold))
(def arrow-fat-line-left (icon-component svg/arrow-fat-line-left-regular))
(def arrow-fat-line-left-light (icon-component svg/arrow-fat-line-left-light))
(def arrow-fat-line-left-thin (icon-component svg/arrow-fat-line-left-thin))
(def arrow-fat-line-left-fill (icon-component svg/arrow-fat-line-left-fill))
(def arrow-fat-line-left-duotone (icon-component svg/arrow-fat-line-left-duotone))
(def arrow-fat-line-right-bold (icon-component svg/arrow-fat-line-right-bold))
(def arrow-fat-line-right (icon-component svg/arrow-fat-line-right-regular))
(def arrow-fat-line-right-light (icon-component svg/arrow-fat-line-right-light))
(def arrow-fat-line-right-thin (icon-component svg/arrow-fat-line-right-thin))
(def arrow-fat-line-right-fill (icon-component svg/arrow-fat-line-right-fill))
(def arrow-fat-line-right-duotone (icon-component svg/arrow-fat-line-right-duotone))
(def arrow-fat-line-up-bold (icon-component svg/arrow-fat-line-up-bold))
(def arrow-fat-line-up (icon-component svg/arrow-fat-line-up-regular))
(def arrow-fat-line-up-light (icon-component svg/arrow-fat-line-up-light))
(def arrow-fat-line-up-thin (icon-component svg/arrow-fat-line-up-thin))
(def arrow-fat-line-up-fill (icon-component svg/arrow-fat-line-up-fill))
(def arrow-fat-line-up-duotone (icon-component svg/arrow-fat-line-up-duotone))
(def arrow-fat-lines-down-bold (icon-component svg/arrow-fat-lines-down-bold))
(def arrow-fat-lines-down (icon-component svg/arrow-fat-lines-down-regular))
(def arrow-fat-lines-down-light (icon-component svg/arrow-fat-lines-down-light))
(def arrow-fat-lines-down-thin (icon-component svg/arrow-fat-lines-down-thin))
(def arrow-fat-lines-down-fill (icon-component svg/arrow-fat-lines-down-fill))
(def arrow-fat-lines-down-duotone (icon-component svg/arrow-fat-lines-down-duotone))
(def arrow-fat-lines-left-bold (icon-component svg/arrow-fat-lines-left-bold))
(def arrow-fat-lines-left (icon-component svg/arrow-fat-lines-left-regular))
(def arrow-fat-lines-left-light (icon-component svg/arrow-fat-lines-left-light))
(def arrow-fat-lines-left-thin (icon-component svg/arrow-fat-lines-left-thin))
(def arrow-fat-lines-left-fill (icon-component svg/arrow-fat-lines-left-fill))
(def arrow-fat-lines-left-duotone (icon-component svg/arrow-fat-lines-left-duotone))
(def arrow-fat-lines-right-bold (icon-component svg/arrow-fat-lines-right-bold))
(def arrow-fat-lines-right (icon-component svg/arrow-fat-lines-right-regular))
(def arrow-fat-lines-right-light (icon-component svg/arrow-fat-lines-right-light))
(def arrow-fat-lines-right-thin (icon-component svg/arrow-fat-lines-right-thin))
(def arrow-fat-lines-right-fill (icon-component svg/arrow-fat-lines-right-fill))
(def arrow-fat-lines-right-duotone (icon-component svg/arrow-fat-lines-right-duotone))
(def arrow-fat-lines-up-bold (icon-component svg/arrow-fat-lines-up-bold))
(def arrow-fat-lines-up (icon-component svg/arrow-fat-lines-up-regular))
(def arrow-fat-lines-up-light (icon-component svg/arrow-fat-lines-up-light))
(def arrow-fat-lines-up-thin (icon-component svg/arrow-fat-lines-up-thin))
(def arrow-fat-lines-up-fill (icon-component svg/arrow-fat-lines-up-fill))
(def arrow-fat-lines-up-duotone (icon-component svg/arrow-fat-lines-up-duotone))
(def arrow-fat-right-bold (icon-component svg/arrow-fat-right-bold))
(def arrow-fat-right (icon-component svg/arrow-fat-right-regular))
(def arrow-fat-right-light (icon-component svg/arrow-fat-right-light))
(def arrow-fat-right-thin (icon-component svg/arrow-fat-right-thin))
(def arrow-fat-right-fill (icon-component svg/arrow-fat-right-fill))
(def arrow-fat-right-duotone (icon-component svg/arrow-fat-right-duotone))
(def arrow-fat-up-bold (icon-component svg/arrow-fat-up-bold))
(def arrow-fat-up (icon-component svg/arrow-fat-up-regular))
(def arrow-fat-up-light (icon-component svg/arrow-fat-up-light))
(def arrow-fat-up-thin (icon-component svg/arrow-fat-up-thin))
(def arrow-fat-up-fill (icon-component svg/arrow-fat-up-fill))
(def arrow-fat-up-duotone (icon-component svg/arrow-fat-up-duotone))
(def arrow-left-bold (icon-component svg/arrow-left-bold))
(def arrow-left (icon-component svg/arrow-left-regular))
(def arrow-left-light (icon-component svg/arrow-left-light))
(def arrow-left-thin (icon-component svg/arrow-left-thin))
(def arrow-left-fill (icon-component svg/arrow-left-fill))
(def arrow-left-duotone (icon-component svg/arrow-left-duotone))
(def arrow-line-down-bold (icon-component svg/arrow-line-down-bold))
(def arrow-line-down (icon-component svg/arrow-line-down-regular))
(def arrow-line-down-light (icon-component svg/arrow-line-down-light))
(def arrow-line-down-thin (icon-component svg/arrow-line-down-thin))
(def arrow-line-down-fill (icon-component svg/arrow-line-down-fill))
(def arrow-line-down-duotone (icon-component svg/arrow-line-down-duotone))
(def arrow-line-down-left-bold (icon-component svg/arrow-line-down-left-bold))
(def arrow-line-down-left (icon-component svg/arrow-line-down-left-regular))
(def arrow-line-down-left-light (icon-component svg/arrow-line-down-left-light))
(def arrow-line-down-left-thin (icon-component svg/arrow-line-down-left-thin))
(def arrow-line-down-left-fill (icon-component svg/arrow-line-down-left-fill))
(def arrow-line-down-left-duotone (icon-component svg/arrow-line-down-left-duotone))
(def arrow-line-down-right-bold (icon-component svg/arrow-line-down-right-bold))
(def arrow-line-down-right (icon-component svg/arrow-line-down-right-regular))
(def arrow-line-down-right-light (icon-component svg/arrow-line-down-right-light))
(def arrow-line-down-right-thin (icon-component svg/arrow-line-down-right-thin))
(def arrow-line-down-right-fill (icon-component svg/arrow-line-down-right-fill))
(def arrow-line-down-right-duotone (icon-component svg/arrow-line-down-right-duotone))
(def arrow-line-left-bold (icon-component svg/arrow-line-left-bold))
(def arrow-line-left (icon-component svg/arrow-line-left-regular))
(def arrow-line-left-light (icon-component svg/arrow-line-left-light))
(def arrow-line-left-thin (icon-component svg/arrow-line-left-thin))
(def arrow-line-left-fill (icon-component svg/arrow-line-left-fill))
(def arrow-line-left-duotone (icon-component svg/arrow-line-left-duotone))
(def arrow-line-right-bold (icon-component svg/arrow-line-right-bold))
(def arrow-line-right (icon-component svg/arrow-line-right-regular))
(def arrow-line-right-light (icon-component svg/arrow-line-right-light))
(def arrow-line-right-thin (icon-component svg/arrow-line-right-thin))
(def arrow-line-right-fill (icon-component svg/arrow-line-right-fill))
(def arrow-line-right-duotone (icon-component svg/arrow-line-right-duotone))
(def arrow-line-up-bold (icon-component svg/arrow-line-up-bold))
(def arrow-line-up (icon-component svg/arrow-line-up-regular))
(def arrow-line-up-light (icon-component svg/arrow-line-up-light))
(def arrow-line-up-thin (icon-component svg/arrow-line-up-thin))
(def arrow-line-up-fill (icon-component svg/arrow-line-up-fill))
(def arrow-line-up-duotone (icon-component svg/arrow-line-up-duotone))
(def arrow-line-up-left-bold (icon-component svg/arrow-line-up-left-bold))
(def arrow-line-up-left (icon-component svg/arrow-line-up-left-regular))
(def arrow-line-up-left-light (icon-component svg/arrow-line-up-left-light))
(def arrow-line-up-left-thin (icon-component svg/arrow-line-up-left-thin))
(def arrow-line-up-left-fill (icon-component svg/arrow-line-up-left-fill))
(def arrow-line-up-left-duotone (icon-component svg/arrow-line-up-left-duotone))
(def arrow-line-up-right-bold (icon-component svg/arrow-line-up-right-bold))
(def arrow-line-up-right (icon-component svg/arrow-line-up-right-regular))
(def arrow-line-up-right-light (icon-component svg/arrow-line-up-right-light))
(def arrow-line-up-right-thin (icon-component svg/arrow-line-up-right-thin))
(def arrow-line-up-right-fill (icon-component svg/arrow-line-up-right-fill))
(def arrow-line-up-right-duotone (icon-component svg/arrow-line-up-right-duotone))
(def arrow-right-bold (icon-component svg/arrow-right-bold))
(def arrow-right (icon-component svg/arrow-right-regular))
(def arrow-right-light (icon-component svg/arrow-right-light))
(def arrow-right-thin (icon-component svg/arrow-right-thin))
(def arrow-right-fill (icon-component svg/arrow-right-fill))
(def arrow-right-duotone (icon-component svg/arrow-right-duotone))
(def arrow-square-down-bold (icon-component svg/arrow-square-down-bold))
(def arrow-square-down (icon-component svg/arrow-square-down-regular))
(def arrow-square-down-light (icon-component svg/arrow-square-down-light))
(def arrow-square-down-thin (icon-component svg/arrow-square-down-thin))
(def arrow-square-down-fill (icon-component svg/arrow-square-down-fill))
(def arrow-square-down-duotone (icon-component svg/arrow-square-down-duotone))
(def arrow-square-down-left-bold (icon-component svg/arrow-square-down-left-bold))
(def arrow-square-down-left (icon-component svg/arrow-square-down-left-regular))
(def arrow-square-down-left-light (icon-component svg/arrow-square-down-left-light))
(def arrow-square-down-left-thin (icon-component svg/arrow-square-down-left-thin))
(def arrow-square-down-left-fill (icon-component svg/arrow-square-down-left-fill))
(def arrow-square-down-left-duotone (icon-component svg/arrow-square-down-left-duotone))
(def arrow-square-down-right-bold (icon-component svg/arrow-square-down-right-bold))
(def arrow-square-down-right (icon-component svg/arrow-square-down-right-regular))
(def arrow-square-down-right-light (icon-component svg/arrow-square-down-right-light))
(def arrow-square-down-right-thin (icon-component svg/arrow-square-down-right-thin))
(def arrow-square-down-right-fill (icon-component svg/arrow-square-down-right-fill))
(def arrow-square-down-right-duotone (icon-component svg/arrow-square-down-right-duotone))
(def arrow-square-in-bold (icon-component svg/arrow-square-in-bold))
(def arrow-square-in (icon-component svg/arrow-square-in-regular))
(def arrow-square-in-light (icon-component svg/arrow-square-in-light))
(def arrow-square-in-thin (icon-component svg/arrow-square-in-thin))
(def arrow-square-in-fill (icon-component svg/arrow-square-in-fill))
(def arrow-square-in-duotone (icon-component svg/arrow-square-in-duotone))
(def arrow-square-left-bold (icon-component svg/arrow-square-left-bold))
(def arrow-square-left (icon-component svg/arrow-square-left-regular))
(def arrow-square-left-light (icon-component svg/arrow-square-left-light))
(def arrow-square-left-thin (icon-component svg/arrow-square-left-thin))
(def arrow-square-left-fill (icon-component svg/arrow-square-left-fill))
(def arrow-square-left-duotone (icon-component svg/arrow-square-left-duotone))
(def arrow-square-out-bold (icon-component svg/arrow-square-out-bold))
(def arrow-square-out (icon-component svg/arrow-square-out-regular))
(def arrow-square-out-light (icon-component svg/arrow-square-out-light))
(def arrow-square-out-thin (icon-component svg/arrow-square-out-thin))
(def arrow-square-out-fill (icon-component svg/arrow-square-out-fill))
(def arrow-square-out-duotone (icon-component svg/arrow-square-out-duotone))
(def arrow-square-right-bold (icon-component svg/arrow-square-right-bold))
(def arrow-square-right (icon-component svg/arrow-square-right-regular))
(def arrow-square-right-light (icon-component svg/arrow-square-right-light))
(def arrow-square-right-thin (icon-component svg/arrow-square-right-thin))
(def arrow-square-right-fill (icon-component svg/arrow-square-right-fill))
(def arrow-square-right-duotone (icon-component svg/arrow-square-right-duotone))
(def arrow-square-up-bold (icon-component svg/arrow-square-up-bold))
(def arrow-square-up (icon-component svg/arrow-square-up-regular))
(def arrow-square-up-light (icon-component svg/arrow-square-up-light))
(def arrow-square-up-thin (icon-component svg/arrow-square-up-thin))
(def arrow-square-up-fill (icon-component svg/arrow-square-up-fill))
(def arrow-square-up-duotone (icon-component svg/arrow-square-up-duotone))
(def arrow-square-up-left-bold (icon-component svg/arrow-square-up-left-bold))
(def arrow-square-up-left (icon-component svg/arrow-square-up-left-regular))
(def arrow-square-up-left-light (icon-component svg/arrow-square-up-left-light))
(def arrow-square-up-left-thin (icon-component svg/arrow-square-up-left-thin))
(def arrow-square-up-left-fill (icon-component svg/arrow-square-up-left-fill))
(def arrow-square-up-left-duotone (icon-component svg/arrow-square-up-left-duotone))
(def arrow-square-up-right-bold (icon-component svg/arrow-square-up-right-bold))
(def arrow-square-up-right (icon-component svg/arrow-square-up-right-regular))
(def arrow-square-up-right-light (icon-component svg/arrow-square-up-right-light))
(def arrow-square-up-right-thin (icon-component svg/arrow-square-up-right-thin))
(def arrow-square-up-right-fill (icon-component svg/arrow-square-up-right-fill))
(def arrow-square-up-right-duotone (icon-component svg/arrow-square-up-right-duotone))
(def arrow-u-down-left-bold (icon-component svg/arrow-u-down-left-bold))
(def arrow-u-down-left (icon-component svg/arrow-u-down-left-regular))
(def arrow-u-down-left-light (icon-component svg/arrow-u-down-left-light))
(def arrow-u-down-left-thin (icon-component svg/arrow-u-down-left-thin))
(def arrow-u-down-left-fill (icon-component svg/arrow-u-down-left-fill))
(def arrow-u-down-left-duotone (icon-component svg/arrow-u-down-left-duotone))
(def arrow-u-down-right-bold (icon-component svg/arrow-u-down-right-bold))
(def arrow-u-down-right (icon-component svg/arrow-u-down-right-regular))
(def arrow-u-down-right-light (icon-component svg/arrow-u-down-right-light))
(def arrow-u-down-right-thin (icon-component svg/arrow-u-down-right-thin))
(def arrow-u-down-right-fill (icon-component svg/arrow-u-down-right-fill))
(def arrow-u-down-right-duotone (icon-component svg/arrow-u-down-right-duotone))
(def arrow-u-left-down-bold (icon-component svg/arrow-u-left-down-bold))
(def arrow-u-left-down (icon-component svg/arrow-u-left-down-regular))
(def arrow-u-left-down-light (icon-component svg/arrow-u-left-down-light))
(def arrow-u-left-down-thin (icon-component svg/arrow-u-left-down-thin))
(def arrow-u-left-down-fill (icon-component svg/arrow-u-left-down-fill))
(def arrow-u-left-down-duotone (icon-component svg/arrow-u-left-down-duotone))
(def arrow-u-left-up-bold (icon-component svg/arrow-u-left-up-bold))
(def arrow-u-left-up (icon-component svg/arrow-u-left-up-regular))
(def arrow-u-left-up-light (icon-component svg/arrow-u-left-up-light))
(def arrow-u-left-up-thin (icon-component svg/arrow-u-left-up-thin))
(def arrow-u-left-up-fill (icon-component svg/arrow-u-left-up-fill))
(def arrow-u-left-up-duotone (icon-component svg/arrow-u-left-up-duotone))
(def arrow-u-right-down-bold (icon-component svg/arrow-u-right-down-bold))
(def arrow-u-right-down (icon-component svg/arrow-u-right-down-regular))
(def arrow-u-right-down-light (icon-component svg/arrow-u-right-down-light))
(def arrow-u-right-down-thin (icon-component svg/arrow-u-right-down-thin))
(def arrow-u-right-down-fill (icon-component svg/arrow-u-right-down-fill))
(def arrow-u-right-down-duotone (icon-component svg/arrow-u-right-down-duotone))
(def arrow-u-right-up-bold (icon-component svg/arrow-u-right-up-bold))
(def arrow-u-right-up (icon-component svg/arrow-u-right-up-regular))
(def arrow-u-right-up-light (icon-component svg/arrow-u-right-up-light))
(def arrow-u-right-up-thin (icon-component svg/arrow-u-right-up-thin))
(def arrow-u-right-up-fill (icon-component svg/arrow-u-right-up-fill))
(def arrow-u-right-up-duotone (icon-component svg/arrow-u-right-up-duotone))
(def arrow-u-up-left-bold (icon-component svg/arrow-u-up-left-bold))
(def arrow-u-up-left (icon-component svg/arrow-u-up-left-regular))
(def arrow-u-up-left-light (icon-component svg/arrow-u-up-left-light))
(def arrow-u-up-left-thin (icon-component svg/arrow-u-up-left-thin))
(def arrow-u-up-left-fill (icon-component svg/arrow-u-up-left-fill))
(def arrow-u-up-left-duotone (icon-component svg/arrow-u-up-left-duotone))
(def arrow-u-up-right-bold (icon-component svg/arrow-u-up-right-bold))
(def arrow-u-up-right (icon-component svg/arrow-u-up-right-regular))
(def arrow-u-up-right-light (icon-component svg/arrow-u-up-right-light))
(def arrow-u-up-right-thin (icon-component svg/arrow-u-up-right-thin))
(def arrow-u-up-right-fill (icon-component svg/arrow-u-up-right-fill))
(def arrow-u-up-right-duotone (icon-component svg/arrow-u-up-right-duotone))
(def arrow-up-bold (icon-component svg/arrow-up-bold))
(def arrow-up (icon-component svg/arrow-up-regular))
(def arrow-up-light (icon-component svg/arrow-up-light))
(def arrow-up-thin (icon-component svg/arrow-up-thin))
(def arrow-up-fill (icon-component svg/arrow-up-fill))
(def arrow-up-duotone (icon-component svg/arrow-up-duotone))
(def arrow-up-left-bold (icon-component svg/arrow-up-left-bold))
(def arrow-up-left (icon-component svg/arrow-up-left-regular))
(def arrow-up-left-light (icon-component svg/arrow-up-left-light))
(def arrow-up-left-thin (icon-component svg/arrow-up-left-thin))
(def arrow-up-left-fill (icon-component svg/arrow-up-left-fill))
(def arrow-up-left-duotone (icon-component svg/arrow-up-left-duotone))
(def arrow-up-right-bold (icon-component svg/arrow-up-right-bold))
(def arrow-up-right (icon-component svg/arrow-up-right-regular))
(def arrow-up-right-light (icon-component svg/arrow-up-right-light))
(def arrow-up-right-thin (icon-component svg/arrow-up-right-thin))
(def arrow-up-right-fill (icon-component svg/arrow-up-right-fill))
(def arrow-up-right-duotone (icon-component svg/arrow-up-right-duotone))
(def arrows-clockwise-bold (icon-component svg/arrows-clockwise-bold))
(def arrows-clockwise (icon-component svg/arrows-clockwise-regular))
(def arrows-clockwise-light (icon-component svg/arrows-clockwise-light))
(def arrows-clockwise-thin (icon-component svg/arrows-clockwise-thin))
(def arrows-clockwise-fill (icon-component svg/arrows-clockwise-fill))
(def arrows-clockwise-duotone (icon-component svg/arrows-clockwise-duotone))
(def arrows-counter-clockwise-bold (icon-component svg/arrows-counter-clockwise-bold))
(def arrows-counter-clockwise (icon-component svg/arrows-counter-clockwise-regular))
(def arrows-counter-clockwise-light (icon-component svg/arrows-counter-clockwise-light))
(def arrows-counter-clockwise-thin (icon-component svg/arrows-counter-clockwise-thin))
(def arrows-counter-clockwise-fill (icon-component svg/arrows-counter-clockwise-fill))
(def arrows-counter-clockwise-duotone (icon-component svg/arrows-counter-clockwise-duotone))
(def arrows-down-up-bold (icon-component svg/arrows-down-up-bold))
(def arrows-down-up (icon-component svg/arrows-down-up-regular))
(def arrows-down-up-light (icon-component svg/arrows-down-up-light))
(def arrows-down-up-thin (icon-component svg/arrows-down-up-thin))
(def arrows-down-up-fill (icon-component svg/arrows-down-up-fill))
(def arrows-down-up-duotone (icon-component svg/arrows-down-up-duotone))
(def arrows-horizontal-bold (icon-component svg/arrows-horizontal-bold))
(def arrows-horizontal (icon-component svg/arrows-horizontal-regular))
(def arrows-horizontal-light (icon-component svg/arrows-horizontal-light))
(def arrows-horizontal-thin (icon-component svg/arrows-horizontal-thin))
(def arrows-horizontal-fill (icon-component svg/arrows-horizontal-fill))
(def arrows-horizontal-duotone (icon-component svg/arrows-horizontal-duotone))
(def arrows-in-bold (icon-component svg/arrows-in-bold))
(def arrows-in (icon-component svg/arrows-in-regular))
(def arrows-in-light (icon-component svg/arrows-in-light))
(def arrows-in-thin (icon-component svg/arrows-in-thin))
(def arrows-in-fill (icon-component svg/arrows-in-fill))
(def arrows-in-duotone (icon-component svg/arrows-in-duotone))
(def arrows-in-cardinal-bold (icon-component svg/arrows-in-cardinal-bold))
(def arrows-in-cardinal (icon-component svg/arrows-in-cardinal-regular))
(def arrows-in-cardinal-light (icon-component svg/arrows-in-cardinal-light))
(def arrows-in-cardinal-thin (icon-component svg/arrows-in-cardinal-thin))
(def arrows-in-cardinal-fill (icon-component svg/arrows-in-cardinal-fill))
(def arrows-in-cardinal-duotone (icon-component svg/arrows-in-cardinal-duotone))
(def arrows-in-line-horizontal-bold (icon-component svg/arrows-in-line-horizontal-bold))
(def arrows-in-line-horizontal (icon-component svg/arrows-in-line-horizontal-regular))
(def arrows-in-line-horizontal-light (icon-component svg/arrows-in-line-horizontal-light))
(def arrows-in-line-horizontal-thin (icon-component svg/arrows-in-line-horizontal-thin))
(def arrows-in-line-horizontal-fill (icon-component svg/arrows-in-line-horizontal-fill))
(def arrows-in-line-horizontal-duotone (icon-component svg/arrows-in-line-horizontal-duotone))
(def arrows-in-line-vertical-bold (icon-component svg/arrows-in-line-vertical-bold))
(def arrows-in-line-vertical (icon-component svg/arrows-in-line-vertical-regular))
(def arrows-in-line-vertical-light (icon-component svg/arrows-in-line-vertical-light))
(def arrows-in-line-vertical-thin (icon-component svg/arrows-in-line-vertical-thin))
(def arrows-in-line-vertical-fill (icon-component svg/arrows-in-line-vertical-fill))
(def arrows-in-line-vertical-duotone (icon-component svg/arrows-in-line-vertical-duotone))
(def arrows-in-simple-bold (icon-component svg/arrows-in-simple-bold))
(def arrows-in-simple (icon-component svg/arrows-in-simple-regular))
(def arrows-in-simple-light (icon-component svg/arrows-in-simple-light))
(def arrows-in-simple-thin (icon-component svg/arrows-in-simple-thin))
(def arrows-in-simple-fill (icon-component svg/arrows-in-simple-fill))
(def arrows-in-simple-duotone (icon-component svg/arrows-in-simple-duotone))
(def arrows-left-right-bold (icon-component svg/arrows-left-right-bold))
(def arrows-left-right (icon-component svg/arrows-left-right-regular))
(def arrows-left-right-light (icon-component svg/arrows-left-right-light))
(def arrows-left-right-thin (icon-component svg/arrows-left-right-thin))
(def arrows-left-right-fill (icon-component svg/arrows-left-right-fill))
(def arrows-left-right-duotone (icon-component svg/arrows-left-right-duotone))
(def arrows-merge-bold (icon-component svg/arrows-merge-bold))
(def arrows-merge (icon-component svg/arrows-merge-regular))
(def arrows-merge-light (icon-component svg/arrows-merge-light))
(def arrows-merge-thin (icon-component svg/arrows-merge-thin))
(def arrows-merge-fill (icon-component svg/arrows-merge-fill))
(def arrows-merge-duotone (icon-component svg/arrows-merge-duotone))
(def arrows-out-bold (icon-component svg/arrows-out-bold))
(def arrows-out (icon-component svg/arrows-out-regular))
(def arrows-out-light (icon-component svg/arrows-out-light))
(def arrows-out-thin (icon-component svg/arrows-out-thin))
(def arrows-out-fill (icon-component svg/arrows-out-fill))
(def arrows-out-duotone (icon-component svg/arrows-out-duotone))
(def arrows-out-cardinal-bold (icon-component svg/arrows-out-cardinal-bold))
(def arrows-out-cardinal (icon-component svg/arrows-out-cardinal-regular))
(def arrows-out-cardinal-light (icon-component svg/arrows-out-cardinal-light))
(def arrows-out-cardinal-thin (icon-component svg/arrows-out-cardinal-thin))
(def arrows-out-cardinal-fill (icon-component svg/arrows-out-cardinal-fill))
(def arrows-out-cardinal-duotone (icon-component svg/arrows-out-cardinal-duotone))
(def arrows-out-line-horizontal-bold (icon-component svg/arrows-out-line-horizontal-bold))
(def arrows-out-line-horizontal (icon-component svg/arrows-out-line-horizontal-regular))
(def arrows-out-line-horizontal-light (icon-component svg/arrows-out-line-horizontal-light))
(def arrows-out-line-horizontal-thin (icon-component svg/arrows-out-line-horizontal-thin))
(def arrows-out-line-horizontal-fill (icon-component svg/arrows-out-line-horizontal-fill))
(def arrows-out-line-horizontal-duotone (icon-component svg/arrows-out-line-horizontal-duotone))
(def arrows-out-line-vertical-bold (icon-component svg/arrows-out-line-vertical-bold))
(def arrows-out-line-vertical (icon-component svg/arrows-out-line-vertical-regular))
(def arrows-out-line-vertical-light (icon-component svg/arrows-out-line-vertical-light))
(def arrows-out-line-vertical-thin (icon-component svg/arrows-out-line-vertical-thin))
(def arrows-out-line-vertical-fill (icon-component svg/arrows-out-line-vertical-fill))
(def arrows-out-line-vertical-duotone (icon-component svg/arrows-out-line-vertical-duotone))
(def arrows-out-simple-bold (icon-component svg/arrows-out-simple-bold))
(def arrows-out-simple (icon-component svg/arrows-out-simple-regular))
(def arrows-out-simple-light (icon-component svg/arrows-out-simple-light))
(def arrows-out-simple-thin (icon-component svg/arrows-out-simple-thin))
(def arrows-out-simple-fill (icon-component svg/arrows-out-simple-fill))
(def arrows-out-simple-duotone (icon-component svg/arrows-out-simple-duotone))
(def arrows-split-bold (icon-component svg/arrows-split-bold))
(def arrows-split (icon-component svg/arrows-split-regular))
(def arrows-split-light (icon-component svg/arrows-split-light))
(def arrows-split-thin (icon-component svg/arrows-split-thin))
(def arrows-split-fill (icon-component svg/arrows-split-fill))
(def arrows-split-duotone (icon-component svg/arrows-split-duotone))
(def arrows-vertical-bold (icon-component svg/arrows-vertical-bold))
(def arrows-vertical (icon-component svg/arrows-vertical-regular))
(def arrows-vertical-light (icon-component svg/arrows-vertical-light))
(def arrows-vertical-thin (icon-component svg/arrows-vertical-thin))
(def arrows-vertical-fill (icon-component svg/arrows-vertical-fill))
(def arrows-vertical-duotone (icon-component svg/arrows-vertical-duotone))
(def article-bold (icon-component svg/article-bold))
(def article (icon-component svg/article-regular))
(def article-light (icon-component svg/article-light))
(def article-thin (icon-component svg/article-thin))
(def article-fill (icon-component svg/article-fill))
(def article-duotone (icon-component svg/article-duotone))
(def article-medium-bold (icon-component svg/article-medium-bold))
(def article-medium (icon-component svg/article-medium-regular))
(def article-medium-light (icon-component svg/article-medium-light))
(def article-medium-thin (icon-component svg/article-medium-thin))
(def article-medium-fill (icon-component svg/article-medium-fill))
(def article-medium-duotone (icon-component svg/article-medium-duotone))
(def article-ny-times-bold (icon-component svg/article-ny-times-bold))
(def article-ny-times (icon-component svg/article-ny-times-regular))
(def article-ny-times-light (icon-component svg/article-ny-times-light))
(def article-ny-times-thin (icon-component svg/article-ny-times-thin))
(def article-ny-times-fill (icon-component svg/article-ny-times-fill))
(def article-ny-times-duotone (icon-component svg/article-ny-times-duotone))
(def asclepius-bold (icon-component svg/asclepius-bold))
(def asclepius (icon-component svg/asclepius-regular))
(def asclepius-light (icon-component svg/asclepius-light))
(def asclepius-thin (icon-component svg/asclepius-thin))
(def asclepius-fill (icon-component svg/asclepius-fill))
(def asclepius-duotone (icon-component svg/asclepius-duotone))
(def asterisk-bold (icon-component svg/asterisk-bold))
(def asterisk (icon-component svg/asterisk-regular))
(def asterisk-light (icon-component svg/asterisk-light))
(def asterisk-thin (icon-component svg/asterisk-thin))
(def asterisk-fill (icon-component svg/asterisk-fill))
(def asterisk-duotone (icon-component svg/asterisk-duotone))
(def asterisk-simple-bold (icon-component svg/asterisk-simple-bold))
(def asterisk-simple (icon-component svg/asterisk-simple-regular))
(def asterisk-simple-light (icon-component svg/asterisk-simple-light))
(def asterisk-simple-thin (icon-component svg/asterisk-simple-thin))
(def asterisk-simple-fill (icon-component svg/asterisk-simple-fill))
(def asterisk-simple-duotone (icon-component svg/asterisk-simple-duotone))
(def at-bold (icon-component svg/at-bold))
(def at (icon-component svg/at-regular))
(def at-light (icon-component svg/at-light))
(def at-thin (icon-component svg/at-thin))
(def at-fill (icon-component svg/at-fill))
(def at-duotone (icon-component svg/at-duotone))
(def atom-bold (icon-component svg/atom-bold))
(def atom (icon-component svg/atom-regular))
(def atom-light (icon-component svg/atom-light))
(def atom-thin (icon-component svg/atom-thin))
(def atom-fill (icon-component svg/atom-fill))
(def atom-duotone (icon-component svg/atom-duotone))
(def avocado-bold (icon-component svg/avocado-bold))
(def avocado (icon-component svg/avocado-regular))
(def avocado-light (icon-component svg/avocado-light))
(def avocado-thin (icon-component svg/avocado-thin))
(def avocado-fill (icon-component svg/avocado-fill))
(def avocado-duotone (icon-component svg/avocado-duotone))
(def axe-bold (icon-component svg/axe-bold))
(def axe (icon-component svg/axe-regular))
(def axe-light (icon-component svg/axe-light))
(def axe-thin (icon-component svg/axe-thin))
(def axe-fill (icon-component svg/axe-fill))
(def axe-duotone (icon-component svg/axe-duotone))
(def baby-bold (icon-component svg/baby-bold))
(def baby (icon-component svg/baby-regular))
(def baby-light (icon-component svg/baby-light))
(def baby-thin (icon-component svg/baby-thin))
(def baby-fill (icon-component svg/baby-fill))
(def baby-duotone (icon-component svg/baby-duotone))
(def baby-carriage-bold (icon-component svg/baby-carriage-bold))
(def baby-carriage (icon-component svg/baby-carriage-regular))
(def baby-carriage-light (icon-component svg/baby-carriage-light))
(def baby-carriage-thin (icon-component svg/baby-carriage-thin))
(def baby-carriage-fill (icon-component svg/baby-carriage-fill))
(def baby-carriage-duotone (icon-component svg/baby-carriage-duotone))
(def backpack-bold (icon-component svg/backpack-bold))
(def backpack (icon-component svg/backpack-regular))
(def backpack-light (icon-component svg/backpack-light))
(def backpack-thin (icon-component svg/backpack-thin))
(def backpack-fill (icon-component svg/backpack-fill))
(def backpack-duotone (icon-component svg/backpack-duotone))
(def backspace-bold (icon-component svg/backspace-bold))
(def backspace (icon-component svg/backspace-regular))
(def backspace-light (icon-component svg/backspace-light))
(def backspace-thin (icon-component svg/backspace-thin))
(def backspace-fill (icon-component svg/backspace-fill))
(def backspace-duotone (icon-component svg/backspace-duotone))
(def bag-bold (icon-component svg/bag-bold))
(def bag (icon-component svg/bag-regular))
(def bag-light (icon-component svg/bag-light))
(def bag-thin (icon-component svg/bag-thin))
(def bag-fill (icon-component svg/bag-fill))
(def bag-duotone (icon-component svg/bag-duotone))
(def bag-simple-bold (icon-component svg/bag-simple-bold))
(def bag-simple (icon-component svg/bag-simple-regular))
(def bag-simple-light (icon-component svg/bag-simple-light))
(def bag-simple-thin (icon-component svg/bag-simple-thin))
(def bag-simple-fill (icon-component svg/bag-simple-fill))
(def bag-simple-duotone (icon-component svg/bag-simple-duotone))
(def balloon-bold (icon-component svg/balloon-bold))
(def balloon (icon-component svg/balloon-regular))
(def balloon-light (icon-component svg/balloon-light))
(def balloon-thin (icon-component svg/balloon-thin))
(def balloon-fill (icon-component svg/balloon-fill))
(def balloon-duotone (icon-component svg/balloon-duotone))
(def bandaids-bold (icon-component svg/bandaids-bold))
(def bandaids (icon-component svg/bandaids-regular))
(def bandaids-light (icon-component svg/bandaids-light))
(def bandaids-thin (icon-component svg/bandaids-thin))
(def bandaids-fill (icon-component svg/bandaids-fill))
(def bandaids-duotone (icon-component svg/bandaids-duotone))
(def bank-bold (icon-component svg/bank-bold))
(def bank (icon-component svg/bank-regular))
(def bank-light (icon-component svg/bank-light))
(def bank-thin (icon-component svg/bank-thin))
(def bank-fill (icon-component svg/bank-fill))
(def bank-duotone (icon-component svg/bank-duotone))
(def barbell-bold (icon-component svg/barbell-bold))
(def barbell (icon-component svg/barbell-regular))
(def barbell-light (icon-component svg/barbell-light))
(def barbell-thin (icon-component svg/barbell-thin))
(def barbell-fill (icon-component svg/barbell-fill))
(def barbell-duotone (icon-component svg/barbell-duotone))
(def barcode-bold (icon-component svg/barcode-bold))
(def barcode (icon-component svg/barcode-regular))
(def barcode-light (icon-component svg/barcode-light))
(def barcode-thin (icon-component svg/barcode-thin))
(def barcode-fill (icon-component svg/barcode-fill))
(def barcode-duotone (icon-component svg/barcode-duotone))
(def barn-bold (icon-component svg/barn-bold))
(def barn (icon-component svg/barn-regular))
(def barn-light (icon-component svg/barn-light))
(def barn-thin (icon-component svg/barn-thin))
(def barn-fill (icon-component svg/barn-fill))
(def barn-duotone (icon-component svg/barn-duotone))
(def barricade-bold (icon-component svg/barricade-bold))
(def barricade (icon-component svg/barricade-regular))
(def barricade-light (icon-component svg/barricade-light))
(def barricade-thin (icon-component svg/barricade-thin))
(def barricade-fill (icon-component svg/barricade-fill))
(def barricade-duotone (icon-component svg/barricade-duotone))
(def baseball-bold (icon-component svg/baseball-bold))
(def baseball (icon-component svg/baseball-regular))
(def baseball-light (icon-component svg/baseball-light))
(def baseball-thin (icon-component svg/baseball-thin))
(def baseball-fill (icon-component svg/baseball-fill))
(def baseball-duotone (icon-component svg/baseball-duotone))
(def baseball-cap-bold (icon-component svg/baseball-cap-bold))
(def baseball-cap (icon-component svg/baseball-cap-regular))
(def baseball-cap-light (icon-component svg/baseball-cap-light))
(def baseball-cap-thin (icon-component svg/baseball-cap-thin))
(def baseball-cap-fill (icon-component svg/baseball-cap-fill))
(def baseball-cap-duotone (icon-component svg/baseball-cap-duotone))
(def baseball-helmet-bold (icon-component svg/baseball-helmet-bold))
(def baseball-helmet (icon-component svg/baseball-helmet-regular))
(def baseball-helmet-light (icon-component svg/baseball-helmet-light))
(def baseball-helmet-thin (icon-component svg/baseball-helmet-thin))
(def baseball-helmet-fill (icon-component svg/baseball-helmet-fill))
(def baseball-helmet-duotone (icon-component svg/baseball-helmet-duotone))
(def basket-bold (icon-component svg/basket-bold))
(def basket (icon-component svg/basket-regular))
(def basket-light (icon-component svg/basket-light))
(def basket-thin (icon-component svg/basket-thin))
(def basket-fill (icon-component svg/basket-fill))
(def basket-duotone (icon-component svg/basket-duotone))
(def basketball-bold (icon-component svg/basketball-bold))
(def basketball (icon-component svg/basketball-regular))
(def basketball-light (icon-component svg/basketball-light))
(def basketball-thin (icon-component svg/basketball-thin))
(def basketball-fill (icon-component svg/basketball-fill))
(def basketball-duotone (icon-component svg/basketball-duotone))
(def bathtub-bold (icon-component svg/bathtub-bold))
(def bathtub (icon-component svg/bathtub-regular))
(def bathtub-light (icon-component svg/bathtub-light))
(def bathtub-thin (icon-component svg/bathtub-thin))
(def bathtub-fill (icon-component svg/bathtub-fill))
(def bathtub-duotone (icon-component svg/bathtub-duotone))
(def battery-charging-bold (icon-component svg/battery-charging-bold))
(def battery-charging (icon-component svg/battery-charging-regular))
(def battery-charging-light (icon-component svg/battery-charging-light))
(def battery-charging-thin (icon-component svg/battery-charging-thin))
(def battery-charging-fill (icon-component svg/battery-charging-fill))
(def battery-charging-duotone (icon-component svg/battery-charging-duotone))
(def battery-charging-vertical-bold (icon-component svg/battery-charging-vertical-bold))
(def battery-charging-vertical (icon-component svg/battery-charging-vertical-regular))
(def battery-charging-vertical-light (icon-component svg/battery-charging-vertical-light))
(def battery-charging-vertical-thin (icon-component svg/battery-charging-vertical-thin))
(def battery-charging-vertical-fill (icon-component svg/battery-charging-vertical-fill))
(def battery-charging-vertical-duotone (icon-component svg/battery-charging-vertical-duotone))
(def battery-empty-bold (icon-component svg/battery-empty-bold))
(def battery-empty (icon-component svg/battery-empty-regular))
(def battery-empty-light (icon-component svg/battery-empty-light))
(def battery-empty-thin (icon-component svg/battery-empty-thin))
(def battery-empty-fill (icon-component svg/battery-empty-fill))
(def battery-empty-duotone (icon-component svg/battery-empty-duotone))
(def battery-full-bold (icon-component svg/battery-full-bold))
(def battery-full (icon-component svg/battery-full-regular))
(def battery-full-light (icon-component svg/battery-full-light))
(def battery-full-thin (icon-component svg/battery-full-thin))
(def battery-full-fill (icon-component svg/battery-full-fill))
(def battery-full-duotone (icon-component svg/battery-full-duotone))
(def battery-high-bold (icon-component svg/battery-high-bold))
(def battery-high (icon-component svg/battery-high-regular))
(def battery-high-light (icon-component svg/battery-high-light))
(def battery-high-thin (icon-component svg/battery-high-thin))
(def battery-high-fill (icon-component svg/battery-high-fill))
(def battery-high-duotone (icon-component svg/battery-high-duotone))
(def battery-low-bold (icon-component svg/battery-low-bold))
(def battery-low (icon-component svg/battery-low-regular))
(def battery-low-light (icon-component svg/battery-low-light))
(def battery-low-thin (icon-component svg/battery-low-thin))
(def battery-low-fill (icon-component svg/battery-low-fill))
(def battery-low-duotone (icon-component svg/battery-low-duotone))
(def battery-medium-bold (icon-component svg/battery-medium-bold))
(def battery-medium (icon-component svg/battery-medium-regular))
(def battery-medium-light (icon-component svg/battery-medium-light))
(def battery-medium-thin (icon-component svg/battery-medium-thin))
(def battery-medium-fill (icon-component svg/battery-medium-fill))
(def battery-medium-duotone (icon-component svg/battery-medium-duotone))
(def battery-plus-bold (icon-component svg/battery-plus-bold))
(def battery-plus (icon-component svg/battery-plus-regular))
(def battery-plus-light (icon-component svg/battery-plus-light))
(def battery-plus-thin (icon-component svg/battery-plus-thin))
(def battery-plus-fill (icon-component svg/battery-plus-fill))
(def battery-plus-duotone (icon-component svg/battery-plus-duotone))
(def battery-plus-vertical-bold (icon-component svg/battery-plus-vertical-bold))
(def battery-plus-vertical (icon-component svg/battery-plus-vertical-regular))
(def battery-plus-vertical-light (icon-component svg/battery-plus-vertical-light))
(def battery-plus-vertical-thin (icon-component svg/battery-plus-vertical-thin))
(def battery-plus-vertical-fill (icon-component svg/battery-plus-vertical-fill))
(def battery-plus-vertical-duotone (icon-component svg/battery-plus-vertical-duotone))
(def battery-vertical-empty-bold (icon-component svg/battery-vertical-empty-bold))
(def battery-vertical-empty (icon-component svg/battery-vertical-empty-regular))
(def battery-vertical-empty-light (icon-component svg/battery-vertical-empty-light))
(def battery-vertical-empty-thin (icon-component svg/battery-vertical-empty-thin))
(def battery-vertical-empty-fill (icon-component svg/battery-vertical-empty-fill))
(def battery-vertical-empty-duotone (icon-component svg/battery-vertical-empty-duotone))
(def battery-vertical-full-bold (icon-component svg/battery-vertical-full-bold))
(def battery-vertical-full (icon-component svg/battery-vertical-full-regular))
(def battery-vertical-full-light (icon-component svg/battery-vertical-full-light))
(def battery-vertical-full-thin (icon-component svg/battery-vertical-full-thin))
(def battery-vertical-full-fill (icon-component svg/battery-vertical-full-fill))
(def battery-vertical-full-duotone (icon-component svg/battery-vertical-full-duotone))
(def battery-vertical-high-bold (icon-component svg/battery-vertical-high-bold))
(def battery-vertical-high (icon-component svg/battery-vertical-high-regular))
(def battery-vertical-high-light (icon-component svg/battery-vertical-high-light))
(def battery-vertical-high-thin (icon-component svg/battery-vertical-high-thin))
(def battery-vertical-high-fill (icon-component svg/battery-vertical-high-fill))
(def battery-vertical-high-duotone (icon-component svg/battery-vertical-high-duotone))
(def battery-vertical-low-bold (icon-component svg/battery-vertical-low-bold))
(def battery-vertical-low (icon-component svg/battery-vertical-low-regular))
(def battery-vertical-low-light (icon-component svg/battery-vertical-low-light))
(def battery-vertical-low-thin (icon-component svg/battery-vertical-low-thin))
(def battery-vertical-low-fill (icon-component svg/battery-vertical-low-fill))
(def battery-vertical-low-duotone (icon-component svg/battery-vertical-low-duotone))
(def battery-vertical-medium-bold (icon-component svg/battery-vertical-medium-bold))
(def battery-vertical-medium (icon-component svg/battery-vertical-medium-regular))
(def battery-vertical-medium-light (icon-component svg/battery-vertical-medium-light))
(def battery-vertical-medium-thin (icon-component svg/battery-vertical-medium-thin))
(def battery-vertical-medium-fill (icon-component svg/battery-vertical-medium-fill))
(def battery-vertical-medium-duotone (icon-component svg/battery-vertical-medium-duotone))
(def battery-warning-bold (icon-component svg/battery-warning-bold))
(def battery-warning (icon-component svg/battery-warning-regular))
(def battery-warning-light (icon-component svg/battery-warning-light))
(def battery-warning-thin (icon-component svg/battery-warning-thin))
(def battery-warning-fill (icon-component svg/battery-warning-fill))
(def battery-warning-duotone (icon-component svg/battery-warning-duotone))
(def battery-warning-vertical-bold (icon-component svg/battery-warning-vertical-bold))
(def battery-warning-vertical (icon-component svg/battery-warning-vertical-regular))
(def battery-warning-vertical-light (icon-component svg/battery-warning-vertical-light))
(def battery-warning-vertical-thin (icon-component svg/battery-warning-vertical-thin))
(def battery-warning-vertical-fill (icon-component svg/battery-warning-vertical-fill))
(def battery-warning-vertical-duotone (icon-component svg/battery-warning-vertical-duotone))
(def beach-ball-bold (icon-component svg/beach-ball-bold))
(def beach-ball (icon-component svg/beach-ball-regular))
(def beach-ball-light (icon-component svg/beach-ball-light))
(def beach-ball-thin (icon-component svg/beach-ball-thin))
(def beach-ball-fill (icon-component svg/beach-ball-fill))
(def beach-ball-duotone (icon-component svg/beach-ball-duotone))
(def beanie-bold (icon-component svg/beanie-bold))
(def beanie (icon-component svg/beanie-regular))
(def beanie-light (icon-component svg/beanie-light))
(def beanie-thin (icon-component svg/beanie-thin))
(def beanie-fill (icon-component svg/beanie-fill))
(def beanie-duotone (icon-component svg/beanie-duotone))
(def bed-bold (icon-component svg/bed-bold))
(def bed (icon-component svg/bed-regular))
(def bed-light (icon-component svg/bed-light))
(def bed-thin (icon-component svg/bed-thin))
(def bed-fill (icon-component svg/bed-fill))
(def bed-duotone (icon-component svg/bed-duotone))
(def beer-bottle-bold (icon-component svg/beer-bottle-bold))
(def beer-bottle (icon-component svg/beer-bottle-regular))
(def beer-bottle-light (icon-component svg/beer-bottle-light))
(def beer-bottle-thin (icon-component svg/beer-bottle-thin))
(def beer-bottle-fill (icon-component svg/beer-bottle-fill))
(def beer-bottle-duotone (icon-component svg/beer-bottle-duotone))
(def beer-stein-bold (icon-component svg/beer-stein-bold))
(def beer-stein (icon-component svg/beer-stein-regular))
(def beer-stein-light (icon-component svg/beer-stein-light))
(def beer-stein-thin (icon-component svg/beer-stein-thin))
(def beer-stein-fill (icon-component svg/beer-stein-fill))
(def beer-stein-duotone (icon-component svg/beer-stein-duotone))
(def behance-logo-bold (icon-component svg/behance-logo-bold))
(def behance-logo (icon-component svg/behance-logo-regular))
(def behance-logo-light (icon-component svg/behance-logo-light))
(def behance-logo-thin (icon-component svg/behance-logo-thin))
(def behance-logo-fill (icon-component svg/behance-logo-fill))
(def behance-logo-duotone (icon-component svg/behance-logo-duotone))
(def bell-bold (icon-component svg/bell-bold))
(def bell (icon-component svg/bell-regular))
(def bell-light (icon-component svg/bell-light))
(def bell-thin (icon-component svg/bell-thin))
(def bell-fill (icon-component svg/bell-fill))
(def bell-duotone (icon-component svg/bell-duotone))
(def bell-ringing-bold (icon-component svg/bell-ringing-bold))
(def bell-ringing (icon-component svg/bell-ringing-regular))
(def bell-ringing-light (icon-component svg/bell-ringing-light))
(def bell-ringing-thin (icon-component svg/bell-ringing-thin))
(def bell-ringing-fill (icon-component svg/bell-ringing-fill))
(def bell-ringing-duotone (icon-component svg/bell-ringing-duotone))
(def bell-simple-bold (icon-component svg/bell-simple-bold))
(def bell-simple (icon-component svg/bell-simple-regular))
(def bell-simple-light (icon-component svg/bell-simple-light))
(def bell-simple-thin (icon-component svg/bell-simple-thin))
(def bell-simple-fill (icon-component svg/bell-simple-fill))
(def bell-simple-duotone (icon-component svg/bell-simple-duotone))
(def bell-simple-ringing-bold (icon-component svg/bell-simple-ringing-bold))
(def bell-simple-ringing (icon-component svg/bell-simple-ringing-regular))
(def bell-simple-ringing-light (icon-component svg/bell-simple-ringing-light))
(def bell-simple-ringing-thin (icon-component svg/bell-simple-ringing-thin))
(def bell-simple-ringing-fill (icon-component svg/bell-simple-ringing-fill))
(def bell-simple-ringing-duotone (icon-component svg/bell-simple-ringing-duotone))
(def bell-simple-slash-bold (icon-component svg/bell-simple-slash-bold))
(def bell-simple-slash (icon-component svg/bell-simple-slash-regular))
(def bell-simple-slash-light (icon-component svg/bell-simple-slash-light))
(def bell-simple-slash-thin (icon-component svg/bell-simple-slash-thin))
(def bell-simple-slash-fill (icon-component svg/bell-simple-slash-fill))
(def bell-simple-slash-duotone (icon-component svg/bell-simple-slash-duotone))
(def bell-simple-z-bold (icon-component svg/bell-simple-z-bold))
(def bell-simple-z (icon-component svg/bell-simple-z-regular))
(def bell-simple-z-light (icon-component svg/bell-simple-z-light))
(def bell-simple-z-thin (icon-component svg/bell-simple-z-thin))
(def bell-simple-z-fill (icon-component svg/bell-simple-z-fill))
(def bell-simple-z-duotone (icon-component svg/bell-simple-z-duotone))
(def bell-slash-bold (icon-component svg/bell-slash-bold))
(def bell-slash (icon-component svg/bell-slash-regular))
(def bell-slash-light (icon-component svg/bell-slash-light))
(def bell-slash-thin (icon-component svg/bell-slash-thin))
(def bell-slash-fill (icon-component svg/bell-slash-fill))
(def bell-slash-duotone (icon-component svg/bell-slash-duotone))
(def bell-z-bold (icon-component svg/bell-z-bold))
(def bell-z (icon-component svg/bell-z-regular))
(def bell-z-light (icon-component svg/bell-z-light))
(def bell-z-thin (icon-component svg/bell-z-thin))
(def bell-z-fill (icon-component svg/bell-z-fill))
(def bell-z-duotone (icon-component svg/bell-z-duotone))
(def belt-bold (icon-component svg/belt-bold))
(def belt (icon-component svg/belt-regular))
(def belt-light (icon-component svg/belt-light))
(def belt-thin (icon-component svg/belt-thin))
(def belt-fill (icon-component svg/belt-fill))
(def belt-duotone (icon-component svg/belt-duotone))
(def bezier-curve-bold (icon-component svg/bezier-curve-bold))
(def bezier-curve (icon-component svg/bezier-curve-regular))
(def bezier-curve-light (icon-component svg/bezier-curve-light))
(def bezier-curve-thin (icon-component svg/bezier-curve-thin))
(def bezier-curve-fill (icon-component svg/bezier-curve-fill))
(def bezier-curve-duotone (icon-component svg/bezier-curve-duotone))
(def bicycle-bold (icon-component svg/bicycle-bold))
(def bicycle (icon-component svg/bicycle-regular))
(def bicycle-light (icon-component svg/bicycle-light))
(def bicycle-thin (icon-component svg/bicycle-thin))
(def bicycle-fill (icon-component svg/bicycle-fill))
(def bicycle-duotone (icon-component svg/bicycle-duotone))
(def binary-bold (icon-component svg/binary-bold))
(def binary (icon-component svg/binary-regular))
(def binary-light (icon-component svg/binary-light))
(def binary-thin (icon-component svg/binary-thin))
(def binary-fill (icon-component svg/binary-fill))
(def binary-duotone (icon-component svg/binary-duotone))
(def binoculars-bold (icon-component svg/binoculars-bold))
(def binoculars (icon-component svg/binoculars-regular))
(def binoculars-light (icon-component svg/binoculars-light))
(def binoculars-thin (icon-component svg/binoculars-thin))
(def binoculars-fill (icon-component svg/binoculars-fill))
(def binoculars-duotone (icon-component svg/binoculars-duotone))
(def biohazard-bold (icon-component svg/biohazard-bold))
(def biohazard (icon-component svg/biohazard-regular))
(def biohazard-light (icon-component svg/biohazard-light))
(def biohazard-thin (icon-component svg/biohazard-thin))
(def biohazard-fill (icon-component svg/biohazard-fill))
(def biohazard-duotone (icon-component svg/biohazard-duotone))
(def bird-bold (icon-component svg/bird-bold))
(def bird (icon-component svg/bird-regular))
(def bird-light (icon-component svg/bird-light))
(def bird-thin (icon-component svg/bird-thin))
(def bird-fill (icon-component svg/bird-fill))
(def bird-duotone (icon-component svg/bird-duotone))
(def blueprint-bold (icon-component svg/blueprint-bold))
(def blueprint (icon-component svg/blueprint-regular))
(def blueprint-light (icon-component svg/blueprint-light))
(def blueprint-thin (icon-component svg/blueprint-thin))
(def blueprint-fill (icon-component svg/blueprint-fill))
(def blueprint-duotone (icon-component svg/blueprint-duotone))
(def bluetooth-bold (icon-component svg/bluetooth-bold))
(def bluetooth (icon-component svg/bluetooth-regular))
(def bluetooth-light (icon-component svg/bluetooth-light))
(def bluetooth-thin (icon-component svg/bluetooth-thin))
(def bluetooth-fill (icon-component svg/bluetooth-fill))
(def bluetooth-duotone (icon-component svg/bluetooth-duotone))
(def bluetooth-connected-bold (icon-component svg/bluetooth-connected-bold))
(def bluetooth-connected (icon-component svg/bluetooth-connected-regular))
(def bluetooth-connected-light (icon-component svg/bluetooth-connected-light))
(def bluetooth-connected-thin (icon-component svg/bluetooth-connected-thin))
(def bluetooth-connected-fill (icon-component svg/bluetooth-connected-fill))
(def bluetooth-connected-duotone (icon-component svg/bluetooth-connected-duotone))
(def bluetooth-slash-bold (icon-component svg/bluetooth-slash-bold))
(def bluetooth-slash (icon-component svg/bluetooth-slash-regular))
(def bluetooth-slash-light (icon-component svg/bluetooth-slash-light))
(def bluetooth-slash-thin (icon-component svg/bluetooth-slash-thin))
(def bluetooth-slash-fill (icon-component svg/bluetooth-slash-fill))
(def bluetooth-slash-duotone (icon-component svg/bluetooth-slash-duotone))
(def bluetooth-x-bold (icon-component svg/bluetooth-x-bold))
(def bluetooth-x (icon-component svg/bluetooth-x-regular))
(def bluetooth-x-light (icon-component svg/bluetooth-x-light))
(def bluetooth-x-thin (icon-component svg/bluetooth-x-thin))
(def bluetooth-x-fill (icon-component svg/bluetooth-x-fill))
(def bluetooth-x-duotone (icon-component svg/bluetooth-x-duotone))
(def boat-bold (icon-component svg/boat-bold))
(def boat (icon-component svg/boat-regular))
(def boat-light (icon-component svg/boat-light))
(def boat-thin (icon-component svg/boat-thin))
(def boat-fill (icon-component svg/boat-fill))
(def boat-duotone (icon-component svg/boat-duotone))
(def bomb-bold (icon-component svg/bomb-bold))
(def bomb (icon-component svg/bomb-regular))
(def bomb-light (icon-component svg/bomb-light))
(def bomb-thin (icon-component svg/bomb-thin))
(def bomb-fill (icon-component svg/bomb-fill))
(def bomb-duotone (icon-component svg/bomb-duotone))
(def bone-bold (icon-component svg/bone-bold))
(def bone (icon-component svg/bone-regular))
(def bone-light (icon-component svg/bone-light))
(def bone-thin (icon-component svg/bone-thin))
(def bone-fill (icon-component svg/bone-fill))
(def bone-duotone (icon-component svg/bone-duotone))
(def book-bold (icon-component svg/book-bold))
(def book (icon-component svg/book-regular))
(def book-light (icon-component svg/book-light))
(def book-thin (icon-component svg/book-thin))
(def book-fill (icon-component svg/book-fill))
(def book-duotone (icon-component svg/book-duotone))
(def book-bookmark-bold (icon-component svg/book-bookmark-bold))
(def book-bookmark (icon-component svg/book-bookmark-regular))
(def book-bookmark-light (icon-component svg/book-bookmark-light))
(def book-bookmark-thin (icon-component svg/book-bookmark-thin))
(def book-bookmark-fill (icon-component svg/book-bookmark-fill))
(def book-bookmark-duotone (icon-component svg/book-bookmark-duotone))
(def book-open-bold (icon-component svg/book-open-bold))
(def book-open (icon-component svg/book-open-regular))
(def book-open-light (icon-component svg/book-open-light))
(def book-open-thin (icon-component svg/book-open-thin))
(def book-open-fill (icon-component svg/book-open-fill))
(def book-open-duotone (icon-component svg/book-open-duotone))
(def book-open-text-bold (icon-component svg/book-open-text-bold))
(def book-open-text (icon-component svg/book-open-text-regular))
(def book-open-text-light (icon-component svg/book-open-text-light))
(def book-open-text-thin (icon-component svg/book-open-text-thin))
(def book-open-text-fill (icon-component svg/book-open-text-fill))
(def book-open-text-duotone (icon-component svg/book-open-text-duotone))
(def book-open-user-bold (icon-component svg/book-open-user-bold))
(def book-open-user (icon-component svg/book-open-user-regular))
(def book-open-user-light (icon-component svg/book-open-user-light))
(def book-open-user-thin (icon-component svg/book-open-user-thin))
(def book-open-user-fill (icon-component svg/book-open-user-fill))
(def book-open-user-duotone (icon-component svg/book-open-user-duotone))
(def bookmark-bold (icon-component svg/bookmark-bold))
(def bookmark (icon-component svg/bookmark-regular))
(def bookmark-light (icon-component svg/bookmark-light))
(def bookmark-thin (icon-component svg/bookmark-thin))
(def bookmark-fill (icon-component svg/bookmark-fill))
(def bookmark-duotone (icon-component svg/bookmark-duotone))
(def bookmark-simple-bold (icon-component svg/bookmark-simple-bold))
(def bookmark-simple (icon-component svg/bookmark-simple-regular))
(def bookmark-simple-light (icon-component svg/bookmark-simple-light))
(def bookmark-simple-thin (icon-component svg/bookmark-simple-thin))
(def bookmark-simple-fill (icon-component svg/bookmark-simple-fill))
(def bookmark-simple-duotone (icon-component svg/bookmark-simple-duotone))
(def bookmarks-bold (icon-component svg/bookmarks-bold))
(def bookmarks (icon-component svg/bookmarks-regular))
(def bookmarks-light (icon-component svg/bookmarks-light))
(def bookmarks-thin (icon-component svg/bookmarks-thin))
(def bookmarks-fill (icon-component svg/bookmarks-fill))
(def bookmarks-duotone (icon-component svg/bookmarks-duotone))
(def bookmarks-simple-bold (icon-component svg/bookmarks-simple-bold))
(def bookmarks-simple (icon-component svg/bookmarks-simple-regular))
(def bookmarks-simple-light (icon-component svg/bookmarks-simple-light))
(def bookmarks-simple-thin (icon-component svg/bookmarks-simple-thin))
(def bookmarks-simple-fill (icon-component svg/bookmarks-simple-fill))
(def bookmarks-simple-duotone (icon-component svg/bookmarks-simple-duotone))
(def books-bold (icon-component svg/books-bold))
(def books (icon-component svg/books-regular))
(def books-light (icon-component svg/books-light))
(def books-thin (icon-component svg/books-thin))
(def books-fill (icon-component svg/books-fill))
(def books-duotone (icon-component svg/books-duotone))
(def boot-bold (icon-component svg/boot-bold))
(def boot (icon-component svg/boot-regular))
(def boot-light (icon-component svg/boot-light))
(def boot-thin (icon-component svg/boot-thin))
(def boot-fill (icon-component svg/boot-fill))
(def boot-duotone (icon-component svg/boot-duotone))
(def boules-bold (icon-component svg/boules-bold))
(def boules (icon-component svg/boules-regular))
(def boules-light (icon-component svg/boules-light))
(def boules-thin (icon-component svg/boules-thin))
(def boules-fill (icon-component svg/boules-fill))
(def boules-duotone (icon-component svg/boules-duotone))
(def bounding-box-bold (icon-component svg/bounding-box-bold))
(def bounding-box (icon-component svg/bounding-box-regular))
(def bounding-box-light (icon-component svg/bounding-box-light))
(def bounding-box-thin (icon-component svg/bounding-box-thin))
(def bounding-box-fill (icon-component svg/bounding-box-fill))
(def bounding-box-duotone (icon-component svg/bounding-box-duotone))
(def bowl-food-bold (icon-component svg/bowl-food-bold))
(def bowl-food (icon-component svg/bowl-food-regular))
(def bowl-food-light (icon-component svg/bowl-food-light))
(def bowl-food-thin (icon-component svg/bowl-food-thin))
(def bowl-food-fill (icon-component svg/bowl-food-fill))
(def bowl-food-duotone (icon-component svg/bowl-food-duotone))
(def bowl-steam-bold (icon-component svg/bowl-steam-bold))
(def bowl-steam (icon-component svg/bowl-steam-regular))
(def bowl-steam-light (icon-component svg/bowl-steam-light))
(def bowl-steam-thin (icon-component svg/bowl-steam-thin))
(def bowl-steam-fill (icon-component svg/bowl-steam-fill))
(def bowl-steam-duotone (icon-component svg/bowl-steam-duotone))
(def bowling-ball-bold (icon-component svg/bowling-ball-bold))
(def bowling-ball (icon-component svg/bowling-ball-regular))
(def bowling-ball-light (icon-component svg/bowling-ball-light))
(def bowling-ball-thin (icon-component svg/bowling-ball-thin))
(def bowling-ball-fill (icon-component svg/bowling-ball-fill))
(def bowling-ball-duotone (icon-component svg/bowling-ball-duotone))
(def box-arrow-down-bold (icon-component svg/box-arrow-down-bold))
(def box-arrow-down (icon-component svg/box-arrow-down-regular))
(def box-arrow-down-light (icon-component svg/box-arrow-down-light))
(def box-arrow-down-thin (icon-component svg/box-arrow-down-thin))
(def box-arrow-down-fill (icon-component svg/box-arrow-down-fill))
(def box-arrow-down-duotone (icon-component svg/box-arrow-down-duotone))
(def box-arrow-up-bold (icon-component svg/box-arrow-up-bold))
(def box-arrow-up (icon-component svg/box-arrow-up-regular))
(def box-arrow-up-light (icon-component svg/box-arrow-up-light))
(def box-arrow-up-thin (icon-component svg/box-arrow-up-thin))
(def box-arrow-up-fill (icon-component svg/box-arrow-up-fill))
(def box-arrow-up-duotone (icon-component svg/box-arrow-up-duotone))
(def boxing-glove-bold (icon-component svg/boxing-glove-bold))
(def boxing-glove (icon-component svg/boxing-glove-regular))
(def boxing-glove-light (icon-component svg/boxing-glove-light))
(def boxing-glove-thin (icon-component svg/boxing-glove-thin))
(def boxing-glove-fill (icon-component svg/boxing-glove-fill))
(def boxing-glove-duotone (icon-component svg/boxing-glove-duotone))
(def brackets-angle-bold (icon-component svg/brackets-angle-bold))
(def brackets-angle (icon-component svg/brackets-angle-regular))
(def brackets-angle-light (icon-component svg/brackets-angle-light))
(def brackets-angle-thin (icon-component svg/brackets-angle-thin))
(def brackets-angle-fill (icon-component svg/brackets-angle-fill))
(def brackets-angle-duotone (icon-component svg/brackets-angle-duotone))
(def brackets-curly-bold (icon-component svg/brackets-curly-bold))
(def brackets-curly (icon-component svg/brackets-curly-regular))
(def brackets-curly-light (icon-component svg/brackets-curly-light))
(def brackets-curly-thin (icon-component svg/brackets-curly-thin))
(def brackets-curly-fill (icon-component svg/brackets-curly-fill))
(def brackets-curly-duotone (icon-component svg/brackets-curly-duotone))
(def brackets-round-bold (icon-component svg/brackets-round-bold))
(def brackets-round (icon-component svg/brackets-round-regular))
(def brackets-round-light (icon-component svg/brackets-round-light))
(def brackets-round-thin (icon-component svg/brackets-round-thin))
(def brackets-round-fill (icon-component svg/brackets-round-fill))
(def brackets-round-duotone (icon-component svg/brackets-round-duotone))
(def brackets-square-bold (icon-component svg/brackets-square-bold))
(def brackets-square (icon-component svg/brackets-square-regular))
(def brackets-square-light (icon-component svg/brackets-square-light))
(def brackets-square-thin (icon-component svg/brackets-square-thin))
(def brackets-square-fill (icon-component svg/brackets-square-fill))
(def brackets-square-duotone (icon-component svg/brackets-square-duotone))
(def brain-bold (icon-component svg/brain-bold))
(def brain (icon-component svg/brain-regular))
(def brain-light (icon-component svg/brain-light))
(def brain-thin (icon-component svg/brain-thin))
(def brain-fill (icon-component svg/brain-fill))
(def brain-duotone (icon-component svg/brain-duotone))
(def brandy-bold (icon-component svg/brandy-bold))
(def brandy (icon-component svg/brandy-regular))
(def brandy-light (icon-component svg/brandy-light))
(def brandy-thin (icon-component svg/brandy-thin))
(def brandy-fill (icon-component svg/brandy-fill))
(def brandy-duotone (icon-component svg/brandy-duotone))
(def bread-bold (icon-component svg/bread-bold))
(def bread (icon-component svg/bread-regular))
(def bread-light (icon-component svg/bread-light))
(def bread-thin (icon-component svg/bread-thin))
(def bread-fill (icon-component svg/bread-fill))
(def bread-duotone (icon-component svg/bread-duotone))
(def bridge-bold (icon-component svg/bridge-bold))
(def bridge (icon-component svg/bridge-regular))
(def bridge-light (icon-component svg/bridge-light))
(def bridge-thin (icon-component svg/bridge-thin))
(def bridge-fill (icon-component svg/bridge-fill))
(def bridge-duotone (icon-component svg/bridge-duotone))
(def briefcase-bold (icon-component svg/briefcase-bold))
(def briefcase (icon-component svg/briefcase-regular))
(def briefcase-light (icon-component svg/briefcase-light))
(def briefcase-thin (icon-component svg/briefcase-thin))
(def briefcase-fill (icon-component svg/briefcase-fill))
(def briefcase-duotone (icon-component svg/briefcase-duotone))
(def briefcase-metal-bold (icon-component svg/briefcase-metal-bold))
(def briefcase-metal (icon-component svg/briefcase-metal-regular))
(def briefcase-metal-light (icon-component svg/briefcase-metal-light))
(def briefcase-metal-thin (icon-component svg/briefcase-metal-thin))
(def briefcase-metal-fill (icon-component svg/briefcase-metal-fill))
(def briefcase-metal-duotone (icon-component svg/briefcase-metal-duotone))
(def broadcast-bold (icon-component svg/broadcast-bold))
(def broadcast (icon-component svg/broadcast-regular))
(def broadcast-light (icon-component svg/broadcast-light))
(def broadcast-thin (icon-component svg/broadcast-thin))
(def broadcast-fill (icon-component svg/broadcast-fill))
(def broadcast-duotone (icon-component svg/broadcast-duotone))
(def broom-bold (icon-component svg/broom-bold))
(def broom (icon-component svg/broom-regular))
(def broom-light (icon-component svg/broom-light))
(def broom-thin (icon-component svg/broom-thin))
(def broom-fill (icon-component svg/broom-fill))
(def broom-duotone (icon-component svg/broom-duotone))
(def browser-bold (icon-component svg/browser-bold))
(def browser (icon-component svg/browser-regular))
(def browser-light (icon-component svg/browser-light))
(def browser-thin (icon-component svg/browser-thin))
(def browser-fill (icon-component svg/browser-fill))
(def browser-duotone (icon-component svg/browser-duotone))
(def browsers-bold (icon-component svg/browsers-bold))
(def browsers (icon-component svg/browsers-regular))
(def browsers-light (icon-component svg/browsers-light))
(def browsers-thin (icon-component svg/browsers-thin))
(def browsers-fill (icon-component svg/browsers-fill))
(def browsers-duotone (icon-component svg/browsers-duotone))
(def bug-bold (icon-component svg/bug-bold))
(def bug (icon-component svg/bug-regular))
(def bug-light (icon-component svg/bug-light))
(def bug-thin (icon-component svg/bug-thin))
(def bug-fill (icon-component svg/bug-fill))
(def bug-duotone (icon-component svg/bug-duotone))
(def bug-beetle-bold (icon-component svg/bug-beetle-bold))
(def bug-beetle (icon-component svg/bug-beetle-regular))
(def bug-beetle-light (icon-component svg/bug-beetle-light))
(def bug-beetle-thin (icon-component svg/bug-beetle-thin))
(def bug-beetle-fill (icon-component svg/bug-beetle-fill))
(def bug-beetle-duotone (icon-component svg/bug-beetle-duotone))
(def bug-droid-bold (icon-component svg/bug-droid-bold))
(def bug-droid (icon-component svg/bug-droid-regular))
(def bug-droid-light (icon-component svg/bug-droid-light))
(def bug-droid-thin (icon-component svg/bug-droid-thin))
(def bug-droid-fill (icon-component svg/bug-droid-fill))
(def bug-droid-duotone (icon-component svg/bug-droid-duotone))
(def building-bold (icon-component svg/building-bold))
(def building (icon-component svg/building-regular))
(def building-light (icon-component svg/building-light))
(def building-thin (icon-component svg/building-thin))
(def building-fill (icon-component svg/building-fill))
(def building-duotone (icon-component svg/building-duotone))
(def building-apartment-bold (icon-component svg/building-apartment-bold))
(def building-apartment (icon-component svg/building-apartment-regular))
(def building-apartment-light (icon-component svg/building-apartment-light))
(def building-apartment-thin (icon-component svg/building-apartment-thin))
(def building-apartment-fill (icon-component svg/building-apartment-fill))
(def building-apartment-duotone (icon-component svg/building-apartment-duotone))
(def building-office-bold (icon-component svg/building-office-bold))
(def building-office (icon-component svg/building-office-regular))
(def building-office-light (icon-component svg/building-office-light))
(def building-office-thin (icon-component svg/building-office-thin))
(def building-office-fill (icon-component svg/building-office-fill))
(def building-office-duotone (icon-component svg/building-office-duotone))
(def buildings-bold (icon-component svg/buildings-bold))
(def buildings (icon-component svg/buildings-regular))
(def buildings-light (icon-component svg/buildings-light))
(def buildings-thin (icon-component svg/buildings-thin))
(def buildings-fill (icon-component svg/buildings-fill))
(def buildings-duotone (icon-component svg/buildings-duotone))
(def bulldozer-bold (icon-component svg/bulldozer-bold))
(def bulldozer (icon-component svg/bulldozer-regular))
(def bulldozer-light (icon-component svg/bulldozer-light))
(def bulldozer-thin (icon-component svg/bulldozer-thin))
(def bulldozer-fill (icon-component svg/bulldozer-fill))
(def bulldozer-duotone (icon-component svg/bulldozer-duotone))
(def bus-bold (icon-component svg/bus-bold))
(def bus (icon-component svg/bus-regular))
(def bus-light (icon-component svg/bus-light))
(def bus-thin (icon-component svg/bus-thin))
(def bus-fill (icon-component svg/bus-fill))
(def bus-duotone (icon-component svg/bus-duotone))
(def butterfly-bold (icon-component svg/butterfly-bold))
(def butterfly (icon-component svg/butterfly-regular))
(def butterfly-light (icon-component svg/butterfly-light))
(def butterfly-thin (icon-component svg/butterfly-thin))
(def butterfly-fill (icon-component svg/butterfly-fill))
(def butterfly-duotone (icon-component svg/butterfly-duotone))
(def cable-car-bold (icon-component svg/cable-car-bold))
(def cable-car (icon-component svg/cable-car-regular))
(def cable-car-light (icon-component svg/cable-car-light))
(def cable-car-thin (icon-component svg/cable-car-thin))
(def cable-car-fill (icon-component svg/cable-car-fill))
(def cable-car-duotone (icon-component svg/cable-car-duotone))
(def cactus-bold (icon-component svg/cactus-bold))
(def cactus (icon-component svg/cactus-regular))
(def cactus-light (icon-component svg/cactus-light))
(def cactus-thin (icon-component svg/cactus-thin))
(def cactus-fill (icon-component svg/cactus-fill))
(def cactus-duotone (icon-component svg/cactus-duotone))
(def cake-bold (icon-component svg/cake-bold))
(def cake (icon-component svg/cake-regular))
(def cake-light (icon-component svg/cake-light))
(def cake-thin (icon-component svg/cake-thin))
(def cake-fill (icon-component svg/cake-fill))
(def cake-duotone (icon-component svg/cake-duotone))
(def calculator-bold (icon-component svg/calculator-bold))
(def calculator (icon-component svg/calculator-regular))
(def calculator-light (icon-component svg/calculator-light))
(def calculator-thin (icon-component svg/calculator-thin))
(def calculator-fill (icon-component svg/calculator-fill))
(def calculator-duotone (icon-component svg/calculator-duotone))
(def calendar-bold (icon-component svg/calendar-bold))
(def calendar (icon-component svg/calendar-regular))
(def calendar-light (icon-component svg/calendar-light))
(def calendar-thin (icon-component svg/calendar-thin))
(def calendar-fill (icon-component svg/calendar-fill))
(def calendar-duotone (icon-component svg/calendar-duotone))
(def calendar-blank-bold (icon-component svg/calendar-blank-bold))
(def calendar-blank (icon-component svg/calendar-blank-regular))
(def calendar-blank-light (icon-component svg/calendar-blank-light))
(def calendar-blank-thin (icon-component svg/calendar-blank-thin))
(def calendar-blank-fill (icon-component svg/calendar-blank-fill))
(def calendar-blank-duotone (icon-component svg/calendar-blank-duotone))
(def calendar-check-bold (icon-component svg/calendar-check-bold))
(def calendar-check (icon-component svg/calendar-check-regular))
(def calendar-check-light (icon-component svg/calendar-check-light))
(def calendar-check-thin (icon-component svg/calendar-check-thin))
(def calendar-check-fill (icon-component svg/calendar-check-fill))
(def calendar-check-duotone (icon-component svg/calendar-check-duotone))
(def calendar-dot-bold (icon-component svg/calendar-dot-bold))
(def calendar-dot (icon-component svg/calendar-dot-regular))
(def calendar-dot-light (icon-component svg/calendar-dot-light))
(def calendar-dot-thin (icon-component svg/calendar-dot-thin))
(def calendar-dot-fill (icon-component svg/calendar-dot-fill))
(def calendar-dot-duotone (icon-component svg/calendar-dot-duotone))
(def calendar-dots-bold (icon-component svg/calendar-dots-bold))
(def calendar-dots (icon-component svg/calendar-dots-regular))
(def calendar-dots-light (icon-component svg/calendar-dots-light))
(def calendar-dots-thin (icon-component svg/calendar-dots-thin))
(def calendar-dots-fill (icon-component svg/calendar-dots-fill))
(def calendar-dots-duotone (icon-component svg/calendar-dots-duotone))
(def calendar-heart-bold (icon-component svg/calendar-heart-bold))
(def calendar-heart (icon-component svg/calendar-heart-regular))
(def calendar-heart-light (icon-component svg/calendar-heart-light))
(def calendar-heart-thin (icon-component svg/calendar-heart-thin))
(def calendar-heart-fill (icon-component svg/calendar-heart-fill))
(def calendar-heart-duotone (icon-component svg/calendar-heart-duotone))
(def calendar-minus-bold (icon-component svg/calendar-minus-bold))
(def calendar-minus (icon-component svg/calendar-minus-regular))
(def calendar-minus-light (icon-component svg/calendar-minus-light))
(def calendar-minus-thin (icon-component svg/calendar-minus-thin))
(def calendar-minus-fill (icon-component svg/calendar-minus-fill))
(def calendar-minus-duotone (icon-component svg/calendar-minus-duotone))
(def calendar-plus-bold (icon-component svg/calendar-plus-bold))
(def calendar-plus (icon-component svg/calendar-plus-regular))
(def calendar-plus-light (icon-component svg/calendar-plus-light))
(def calendar-plus-thin (icon-component svg/calendar-plus-thin))
(def calendar-plus-fill (icon-component svg/calendar-plus-fill))
(def calendar-plus-duotone (icon-component svg/calendar-plus-duotone))
(def calendar-slash-bold (icon-component svg/calendar-slash-bold))
(def calendar-slash (icon-component svg/calendar-slash-regular))
(def calendar-slash-light (icon-component svg/calendar-slash-light))
(def calendar-slash-thin (icon-component svg/calendar-slash-thin))
(def calendar-slash-fill (icon-component svg/calendar-slash-fill))
(def calendar-slash-duotone (icon-component svg/calendar-slash-duotone))
(def calendar-star-bold (icon-component svg/calendar-star-bold))
(def calendar-star (icon-component svg/calendar-star-regular))
(def calendar-star-light (icon-component svg/calendar-star-light))
(def calendar-star-thin (icon-component svg/calendar-star-thin))
(def calendar-star-fill (icon-component svg/calendar-star-fill))
(def calendar-star-duotone (icon-component svg/calendar-star-duotone))
(def calendar-x-bold (icon-component svg/calendar-x-bold))
(def calendar-x (icon-component svg/calendar-x-regular))
(def calendar-x-light (icon-component svg/calendar-x-light))
(def calendar-x-thin (icon-component svg/calendar-x-thin))
(def calendar-x-fill (icon-component svg/calendar-x-fill))
(def calendar-x-duotone (icon-component svg/calendar-x-duotone))
(def call-bell-bold (icon-component svg/call-bell-bold))
(def call-bell (icon-component svg/call-bell-regular))
(def call-bell-light (icon-component svg/call-bell-light))
(def call-bell-thin (icon-component svg/call-bell-thin))
(def call-bell-fill (icon-component svg/call-bell-fill))
(def call-bell-duotone (icon-component svg/call-bell-duotone))
(def camera-bold (icon-component svg/camera-bold))
(def camera (icon-component svg/camera-regular))
(def camera-light (icon-component svg/camera-light))
(def camera-thin (icon-component svg/camera-thin))
(def camera-fill (icon-component svg/camera-fill))
(def camera-duotone (icon-component svg/camera-duotone))
(def camera-plus-bold (icon-component svg/camera-plus-bold))
(def camera-plus (icon-component svg/camera-plus-regular))
(def camera-plus-light (icon-component svg/camera-plus-light))
(def camera-plus-thin (icon-component svg/camera-plus-thin))
(def camera-plus-fill (icon-component svg/camera-plus-fill))
(def camera-plus-duotone (icon-component svg/camera-plus-duotone))
(def camera-rotate-bold (icon-component svg/camera-rotate-bold))
(def camera-rotate (icon-component svg/camera-rotate-regular))
(def camera-rotate-light (icon-component svg/camera-rotate-light))
(def camera-rotate-thin (icon-component svg/camera-rotate-thin))
(def camera-rotate-fill (icon-component svg/camera-rotate-fill))
(def camera-rotate-duotone (icon-component svg/camera-rotate-duotone))
(def camera-slash-bold (icon-component svg/camera-slash-bold))
(def camera-slash (icon-component svg/camera-slash-regular))
(def camera-slash-light (icon-component svg/camera-slash-light))
(def camera-slash-thin (icon-component svg/camera-slash-thin))
(def camera-slash-fill (icon-component svg/camera-slash-fill))
(def camera-slash-duotone (icon-component svg/camera-slash-duotone))
(def campfire-bold (icon-component svg/campfire-bold))
(def campfire (icon-component svg/campfire-regular))
(def campfire-light (icon-component svg/campfire-light))
(def campfire-thin (icon-component svg/campfire-thin))
(def campfire-fill (icon-component svg/campfire-fill))
(def campfire-duotone (icon-component svg/campfire-duotone))
(def car-bold (icon-component svg/car-bold))
(def car (icon-component svg/car-regular))
(def car-light (icon-component svg/car-light))
(def car-thin (icon-component svg/car-thin))
(def car-fill (icon-component svg/car-fill))
(def car-duotone (icon-component svg/car-duotone))
(def car-battery-bold (icon-component svg/car-battery-bold))
(def car-battery (icon-component svg/car-battery-regular))
(def car-battery-light (icon-component svg/car-battery-light))
(def car-battery-thin (icon-component svg/car-battery-thin))
(def car-battery-fill (icon-component svg/car-battery-fill))
(def car-battery-duotone (icon-component svg/car-battery-duotone))
(def car-profile-bold (icon-component svg/car-profile-bold))
(def car-profile (icon-component svg/car-profile-regular))
(def car-profile-light (icon-component svg/car-profile-light))
(def car-profile-thin (icon-component svg/car-profile-thin))
(def car-profile-fill (icon-component svg/car-profile-fill))
(def car-profile-duotone (icon-component svg/car-profile-duotone))
(def car-simple-bold (icon-component svg/car-simple-bold))
(def car-simple (icon-component svg/car-simple-regular))
(def car-simple-light (icon-component svg/car-simple-light))
(def car-simple-thin (icon-component svg/car-simple-thin))
(def car-simple-fill (icon-component svg/car-simple-fill))
(def car-simple-duotone (icon-component svg/car-simple-duotone))
(def cardholder-bold (icon-component svg/cardholder-bold))
(def cardholder (icon-component svg/cardholder-regular))
(def cardholder-light (icon-component svg/cardholder-light))
(def cardholder-thin (icon-component svg/cardholder-thin))
(def cardholder-fill (icon-component svg/cardholder-fill))
(def cardholder-duotone (icon-component svg/cardholder-duotone))
(def cards-bold (icon-component svg/cards-bold))
(def cards (icon-component svg/cards-regular))
(def cards-light (icon-component svg/cards-light))
(def cards-thin (icon-component svg/cards-thin))
(def cards-fill (icon-component svg/cards-fill))
(def cards-duotone (icon-component svg/cards-duotone))
(def cards-three-bold (icon-component svg/cards-three-bold))
(def cards-three (icon-component svg/cards-three-regular))
(def cards-three-light (icon-component svg/cards-three-light))
(def cards-three-thin (icon-component svg/cards-three-thin))
(def cards-three-fill (icon-component svg/cards-three-fill))
(def cards-three-duotone (icon-component svg/cards-three-duotone))
(def caret-circle-double-down-bold (icon-component svg/caret-circle-double-down-bold))
(def caret-circle-double-down (icon-component svg/caret-circle-double-down-regular))
(def caret-circle-double-down-light (icon-component svg/caret-circle-double-down-light))
(def caret-circle-double-down-thin (icon-component svg/caret-circle-double-down-thin))
(def caret-circle-double-down-fill (icon-component svg/caret-circle-double-down-fill))
(def caret-circle-double-down-duotone (icon-component svg/caret-circle-double-down-duotone))
(def caret-circle-double-left-bold (icon-component svg/caret-circle-double-left-bold))
(def caret-circle-double-left (icon-component svg/caret-circle-double-left-regular))
(def caret-circle-double-left-light (icon-component svg/caret-circle-double-left-light))
(def caret-circle-double-left-thin (icon-component svg/caret-circle-double-left-thin))
(def caret-circle-double-left-fill (icon-component svg/caret-circle-double-left-fill))
(def caret-circle-double-left-duotone (icon-component svg/caret-circle-double-left-duotone))
(def caret-circle-double-right-bold (icon-component svg/caret-circle-double-right-bold))
(def caret-circle-double-right (icon-component svg/caret-circle-double-right-regular))
(def caret-circle-double-right-light (icon-component svg/caret-circle-double-right-light))
(def caret-circle-double-right-thin (icon-component svg/caret-circle-double-right-thin))
(def caret-circle-double-right-fill (icon-component svg/caret-circle-double-right-fill))
(def caret-circle-double-right-duotone (icon-component svg/caret-circle-double-right-duotone))
(def caret-circle-double-up-bold (icon-component svg/caret-circle-double-up-bold))
(def caret-circle-double-up (icon-component svg/caret-circle-double-up-regular))
(def caret-circle-double-up-light (icon-component svg/caret-circle-double-up-light))
(def caret-circle-double-up-thin (icon-component svg/caret-circle-double-up-thin))
(def caret-circle-double-up-fill (icon-component svg/caret-circle-double-up-fill))
(def caret-circle-double-up-duotone (icon-component svg/caret-circle-double-up-duotone))
(def caret-circle-down-bold (icon-component svg/caret-circle-down-bold))
(def caret-circle-down (icon-component svg/caret-circle-down-regular))
(def caret-circle-down-light (icon-component svg/caret-circle-down-light))
(def caret-circle-down-thin (icon-component svg/caret-circle-down-thin))
(def caret-circle-down-fill (icon-component svg/caret-circle-down-fill))
(def caret-circle-down-duotone (icon-component svg/caret-circle-down-duotone))
(def caret-circle-left-bold (icon-component svg/caret-circle-left-bold))
(def caret-circle-left (icon-component svg/caret-circle-left-regular))
(def caret-circle-left-light (icon-component svg/caret-circle-left-light))
(def caret-circle-left-thin (icon-component svg/caret-circle-left-thin))
(def caret-circle-left-fill (icon-component svg/caret-circle-left-fill))
(def caret-circle-left-duotone (icon-component svg/caret-circle-left-duotone))
(def caret-circle-right-bold (icon-component svg/caret-circle-right-bold))
(def caret-circle-right (icon-component svg/caret-circle-right-regular))
(def caret-circle-right-light (icon-component svg/caret-circle-right-light))
(def caret-circle-right-thin (icon-component svg/caret-circle-right-thin))
(def caret-circle-right-fill (icon-component svg/caret-circle-right-fill))
(def caret-circle-right-duotone (icon-component svg/caret-circle-right-duotone))
(def caret-circle-up-bold (icon-component svg/caret-circle-up-bold))
(def caret-circle-up (icon-component svg/caret-circle-up-regular))
(def caret-circle-up-light (icon-component svg/caret-circle-up-light))
(def caret-circle-up-thin (icon-component svg/caret-circle-up-thin))
(def caret-circle-up-fill (icon-component svg/caret-circle-up-fill))
(def caret-circle-up-duotone (icon-component svg/caret-circle-up-duotone))
(def caret-circle-up-down-bold (icon-component svg/caret-circle-up-down-bold))
(def caret-circle-up-down (icon-component svg/caret-circle-up-down-regular))
(def caret-circle-up-down-light (icon-component svg/caret-circle-up-down-light))
(def caret-circle-up-down-thin (icon-component svg/caret-circle-up-down-thin))
(def caret-circle-up-down-fill (icon-component svg/caret-circle-up-down-fill))
(def caret-circle-up-down-duotone (icon-component svg/caret-circle-up-down-duotone))
(def caret-double-down-bold (icon-component svg/caret-double-down-bold))
(def caret-double-down (icon-component svg/caret-double-down-regular))
(def caret-double-down-light (icon-component svg/caret-double-down-light))
(def caret-double-down-thin (icon-component svg/caret-double-down-thin))
(def caret-double-down-fill (icon-component svg/caret-double-down-fill))
(def caret-double-down-duotone (icon-component svg/caret-double-down-duotone))
(def caret-double-left-bold (icon-component svg/caret-double-left-bold))
(def caret-double-left (icon-component svg/caret-double-left-regular))
(def caret-double-left-light (icon-component svg/caret-double-left-light))
(def caret-double-left-thin (icon-component svg/caret-double-left-thin))
(def caret-double-left-fill (icon-component svg/caret-double-left-fill))
(def caret-double-left-duotone (icon-component svg/caret-double-left-duotone))
(def caret-double-right-bold (icon-component svg/caret-double-right-bold))
(def caret-double-right (icon-component svg/caret-double-right-regular))
(def caret-double-right-light (icon-component svg/caret-double-right-light))
(def caret-double-right-thin (icon-component svg/caret-double-right-thin))
(def caret-double-right-fill (icon-component svg/caret-double-right-fill))
(def caret-double-right-duotone (icon-component svg/caret-double-right-duotone))
(def caret-double-up-bold (icon-component svg/caret-double-up-bold))
(def caret-double-up (icon-component svg/caret-double-up-regular))
(def caret-double-up-light (icon-component svg/caret-double-up-light))
(def caret-double-up-thin (icon-component svg/caret-double-up-thin))
(def caret-double-up-fill (icon-component svg/caret-double-up-fill))
(def caret-double-up-duotone (icon-component svg/caret-double-up-duotone))
(def caret-down-bold (icon-component svg/caret-down-bold))
(def caret-down (icon-component svg/caret-down-regular))
(def caret-down-light (icon-component svg/caret-down-light))
(def caret-down-thin (icon-component svg/caret-down-thin))
(def caret-down-fill (icon-component svg/caret-down-fill))
(def caret-down-duotone (icon-component svg/caret-down-duotone))
(def caret-left-bold (icon-component svg/caret-left-bold))
(def caret-left (icon-component svg/caret-left-regular))
(def caret-left-light (icon-component svg/caret-left-light))
(def caret-left-thin (icon-component svg/caret-left-thin))
(def caret-left-fill (icon-component svg/caret-left-fill))
(def caret-left-duotone (icon-component svg/caret-left-duotone))
(def caret-line-down-bold (icon-component svg/caret-line-down-bold))
(def caret-line-down (icon-component svg/caret-line-down-regular))
(def caret-line-down-light (icon-component svg/caret-line-down-light))
(def caret-line-down-thin (icon-component svg/caret-line-down-thin))
(def caret-line-down-fill (icon-component svg/caret-line-down-fill))
(def caret-line-down-duotone (icon-component svg/caret-line-down-duotone))
(def caret-line-left-bold (icon-component svg/caret-line-left-bold))
(def caret-line-left (icon-component svg/caret-line-left-regular))
(def caret-line-left-light (icon-component svg/caret-line-left-light))
(def caret-line-left-thin (icon-component svg/caret-line-left-thin))
(def caret-line-left-fill (icon-component svg/caret-line-left-fill))
(def caret-line-left-duotone (icon-component svg/caret-line-left-duotone))
(def caret-line-right-bold (icon-component svg/caret-line-right-bold))
(def caret-line-right (icon-component svg/caret-line-right-regular))
(def caret-line-right-light (icon-component svg/caret-line-right-light))
(def caret-line-right-thin (icon-component svg/caret-line-right-thin))
(def caret-line-right-fill (icon-component svg/caret-line-right-fill))
(def caret-line-right-duotone (icon-component svg/caret-line-right-duotone))
(def caret-line-up-bold (icon-component svg/caret-line-up-bold))
(def caret-line-up (icon-component svg/caret-line-up-regular))
(def caret-line-up-light (icon-component svg/caret-line-up-light))
(def caret-line-up-thin (icon-component svg/caret-line-up-thin))
(def caret-line-up-fill (icon-component svg/caret-line-up-fill))
(def caret-line-up-duotone (icon-component svg/caret-line-up-duotone))
(def caret-right-bold (icon-component svg/caret-right-bold))
(def caret-right (icon-component svg/caret-right-regular))
(def caret-right-light (icon-component svg/caret-right-light))
(def caret-right-thin (icon-component svg/caret-right-thin))
(def caret-right-fill (icon-component svg/caret-right-fill))
(def caret-right-duotone (icon-component svg/caret-right-duotone))
(def caret-up-bold (icon-component svg/caret-up-bold))
(def caret-up (icon-component svg/caret-up-regular))
(def caret-up-light (icon-component svg/caret-up-light))
(def caret-up-thin (icon-component svg/caret-up-thin))
(def caret-up-fill (icon-component svg/caret-up-fill))
(def caret-up-duotone (icon-component svg/caret-up-duotone))
(def caret-up-down-bold (icon-component svg/caret-up-down-bold))
(def caret-up-down (icon-component svg/caret-up-down-regular))
(def caret-up-down-light (icon-component svg/caret-up-down-light))
(def caret-up-down-thin (icon-component svg/caret-up-down-thin))
(def caret-up-down-fill (icon-component svg/caret-up-down-fill))
(def caret-up-down-duotone (icon-component svg/caret-up-down-duotone))
(def carrot-bold (icon-component svg/carrot-bold))
(def carrot (icon-component svg/carrot-regular))
(def carrot-light (icon-component svg/carrot-light))
(def carrot-thin (icon-component svg/carrot-thin))
(def carrot-fill (icon-component svg/carrot-fill))
(def carrot-duotone (icon-component svg/carrot-duotone))
(def cash-register-bold (icon-component svg/cash-register-bold))
(def cash-register (icon-component svg/cash-register-regular))
(def cash-register-light (icon-component svg/cash-register-light))
(def cash-register-thin (icon-component svg/cash-register-thin))
(def cash-register-fill (icon-component svg/cash-register-fill))
(def cash-register-duotone (icon-component svg/cash-register-duotone))
(def cassette-tape-bold (icon-component svg/cassette-tape-bold))
(def cassette-tape (icon-component svg/cassette-tape-regular))
(def cassette-tape-light (icon-component svg/cassette-tape-light))
(def cassette-tape-thin (icon-component svg/cassette-tape-thin))
(def cassette-tape-fill (icon-component svg/cassette-tape-fill))
(def cassette-tape-duotone (icon-component svg/cassette-tape-duotone))
(def castle-turret-bold (icon-component svg/castle-turret-bold))
(def castle-turret (icon-component svg/castle-turret-regular))
(def castle-turret-light (icon-component svg/castle-turret-light))
(def castle-turret-thin (icon-component svg/castle-turret-thin))
(def castle-turret-fill (icon-component svg/castle-turret-fill))
(def castle-turret-duotone (icon-component svg/castle-turret-duotone))
(def cat-bold (icon-component svg/cat-bold))
(def cat (icon-component svg/cat-regular))
(def cat-light (icon-component svg/cat-light))
(def cat-thin (icon-component svg/cat-thin))
(def cat-fill (icon-component svg/cat-fill))
(def cat-duotone (icon-component svg/cat-duotone))
(def cell-signal-full-bold (icon-component svg/cell-signal-full-bold))
(def cell-signal-full (icon-component svg/cell-signal-full-regular))
(def cell-signal-full-light (icon-component svg/cell-signal-full-light))
(def cell-signal-full-thin (icon-component svg/cell-signal-full-thin))
(def cell-signal-full-fill (icon-component svg/cell-signal-full-fill))
(def cell-signal-full-duotone (icon-component svg/cell-signal-full-duotone))
(def cell-signal-high-bold (icon-component svg/cell-signal-high-bold))
(def cell-signal-high (icon-component svg/cell-signal-high-regular))
(def cell-signal-high-light (icon-component svg/cell-signal-high-light))
(def cell-signal-high-thin (icon-component svg/cell-signal-high-thin))
(def cell-signal-high-fill (icon-component svg/cell-signal-high-fill))
(def cell-signal-high-duotone (icon-component svg/cell-signal-high-duotone))
(def cell-signal-low-bold (icon-component svg/cell-signal-low-bold))
(def cell-signal-low (icon-component svg/cell-signal-low-regular))
(def cell-signal-low-light (icon-component svg/cell-signal-low-light))
(def cell-signal-low-thin (icon-component svg/cell-signal-low-thin))
(def cell-signal-low-fill (icon-component svg/cell-signal-low-fill))
(def cell-signal-low-duotone (icon-component svg/cell-signal-low-duotone))
(def cell-signal-medium-bold (icon-component svg/cell-signal-medium-bold))
(def cell-signal-medium (icon-component svg/cell-signal-medium-regular))
(def cell-signal-medium-light (icon-component svg/cell-signal-medium-light))
(def cell-signal-medium-thin (icon-component svg/cell-signal-medium-thin))
(def cell-signal-medium-fill (icon-component svg/cell-signal-medium-fill))
(def cell-signal-medium-duotone (icon-component svg/cell-signal-medium-duotone))
(def cell-signal-none-bold (icon-component svg/cell-signal-none-bold))
(def cell-signal-none (icon-component svg/cell-signal-none-regular))
(def cell-signal-none-light (icon-component svg/cell-signal-none-light))
(def cell-signal-none-thin (icon-component svg/cell-signal-none-thin))
(def cell-signal-none-fill (icon-component svg/cell-signal-none-fill))
(def cell-signal-none-duotone (icon-component svg/cell-signal-none-duotone))
(def cell-signal-slash-bold (icon-component svg/cell-signal-slash-bold))
(def cell-signal-slash (icon-component svg/cell-signal-slash-regular))
(def cell-signal-slash-light (icon-component svg/cell-signal-slash-light))
(def cell-signal-slash-thin (icon-component svg/cell-signal-slash-thin))
(def cell-signal-slash-fill (icon-component svg/cell-signal-slash-fill))
(def cell-signal-slash-duotone (icon-component svg/cell-signal-slash-duotone))
(def cell-signal-x-bold (icon-component svg/cell-signal-x-bold))
(def cell-signal-x (icon-component svg/cell-signal-x-regular))
(def cell-signal-x-light (icon-component svg/cell-signal-x-light))
(def cell-signal-x-thin (icon-component svg/cell-signal-x-thin))
(def cell-signal-x-fill (icon-component svg/cell-signal-x-fill))
(def cell-signal-x-duotone (icon-component svg/cell-signal-x-duotone))
(def cell-tower-bold (icon-component svg/cell-tower-bold))
(def cell-tower (icon-component svg/cell-tower-regular))
(def cell-tower-light (icon-component svg/cell-tower-light))
(def cell-tower-thin (icon-component svg/cell-tower-thin))
(def cell-tower-fill (icon-component svg/cell-tower-fill))
(def cell-tower-duotone (icon-component svg/cell-tower-duotone))
(def certificate-bold (icon-component svg/certificate-bold))
(def certificate (icon-component svg/certificate-regular))
(def certificate-light (icon-component svg/certificate-light))
(def certificate-thin (icon-component svg/certificate-thin))
(def certificate-fill (icon-component svg/certificate-fill))
(def certificate-duotone (icon-component svg/certificate-duotone))
(def chair-bold (icon-component svg/chair-bold))
(def chair (icon-component svg/chair-regular))
(def chair-light (icon-component svg/chair-light))
(def chair-thin (icon-component svg/chair-thin))
(def chair-fill (icon-component svg/chair-fill))
(def chair-duotone (icon-component svg/chair-duotone))
(def chalkboard-bold (icon-component svg/chalkboard-bold))
(def chalkboard (icon-component svg/chalkboard-regular))
(def chalkboard-light (icon-component svg/chalkboard-light))
(def chalkboard-thin (icon-component svg/chalkboard-thin))
(def chalkboard-fill (icon-component svg/chalkboard-fill))
(def chalkboard-duotone (icon-component svg/chalkboard-duotone))
(def chalkboard-simple-bold (icon-component svg/chalkboard-simple-bold))
(def chalkboard-simple (icon-component svg/chalkboard-simple-regular))
(def chalkboard-simple-light (icon-component svg/chalkboard-simple-light))
(def chalkboard-simple-thin (icon-component svg/chalkboard-simple-thin))
(def chalkboard-simple-fill (icon-component svg/chalkboard-simple-fill))
(def chalkboard-simple-duotone (icon-component svg/chalkboard-simple-duotone))
(def chalkboard-teacher-bold (icon-component svg/chalkboard-teacher-bold))
(def chalkboard-teacher (icon-component svg/chalkboard-teacher-regular))
(def chalkboard-teacher-light (icon-component svg/chalkboard-teacher-light))
(def chalkboard-teacher-thin (icon-component svg/chalkboard-teacher-thin))
(def chalkboard-teacher-fill (icon-component svg/chalkboard-teacher-fill))
(def chalkboard-teacher-duotone (icon-component svg/chalkboard-teacher-duotone))
(def champagne-bold (icon-component svg/champagne-bold))
(def champagne (icon-component svg/champagne-regular))
(def champagne-light (icon-component svg/champagne-light))
(def champagne-thin (icon-component svg/champagne-thin))
(def champagne-fill (icon-component svg/champagne-fill))
(def champagne-duotone (icon-component svg/champagne-duotone))
(def charging-station-bold (icon-component svg/charging-station-bold))
(def charging-station (icon-component svg/charging-station-regular))
(def charging-station-light (icon-component svg/charging-station-light))
(def charging-station-thin (icon-component svg/charging-station-thin))
(def charging-station-fill (icon-component svg/charging-station-fill))
(def charging-station-duotone (icon-component svg/charging-station-duotone))
(def chart-bar-bold (icon-component svg/chart-bar-bold))
(def chart-bar (icon-component svg/chart-bar-regular))
(def chart-bar-light (icon-component svg/chart-bar-light))
(def chart-bar-thin (icon-component svg/chart-bar-thin))
(def chart-bar-fill (icon-component svg/chart-bar-fill))
(def chart-bar-duotone (icon-component svg/chart-bar-duotone))
(def chart-bar-horizontal-bold (icon-component svg/chart-bar-horizontal-bold))
(def chart-bar-horizontal (icon-component svg/chart-bar-horizontal-regular))
(def chart-bar-horizontal-light (icon-component svg/chart-bar-horizontal-light))
(def chart-bar-horizontal-thin (icon-component svg/chart-bar-horizontal-thin))
(def chart-bar-horizontal-fill (icon-component svg/chart-bar-horizontal-fill))
(def chart-bar-horizontal-duotone (icon-component svg/chart-bar-horizontal-duotone))
(def chart-donut-bold (icon-component svg/chart-donut-bold))
(def chart-donut (icon-component svg/chart-donut-regular))
(def chart-donut-light (icon-component svg/chart-donut-light))
(def chart-donut-thin (icon-component svg/chart-donut-thin))
(def chart-donut-fill (icon-component svg/chart-donut-fill))
(def chart-donut-duotone (icon-component svg/chart-donut-duotone))
(def chart-line-bold (icon-component svg/chart-line-bold))
(def chart-line (icon-component svg/chart-line-regular))
(def chart-line-light (icon-component svg/chart-line-light))
(def chart-line-thin (icon-component svg/chart-line-thin))
(def chart-line-fill (icon-component svg/chart-line-fill))
(def chart-line-duotone (icon-component svg/chart-line-duotone))
(def chart-line-down-bold (icon-component svg/chart-line-down-bold))
(def chart-line-down (icon-component svg/chart-line-down-regular))
(def chart-line-down-light (icon-component svg/chart-line-down-light))
(def chart-line-down-thin (icon-component svg/chart-line-down-thin))
(def chart-line-down-fill (icon-component svg/chart-line-down-fill))
(def chart-line-down-duotone (icon-component svg/chart-line-down-duotone))
(def chart-line-up-bold (icon-component svg/chart-line-up-bold))
(def chart-line-up (icon-component svg/chart-line-up-regular))
(def chart-line-up-light (icon-component svg/chart-line-up-light))
(def chart-line-up-thin (icon-component svg/chart-line-up-thin))
(def chart-line-up-fill (icon-component svg/chart-line-up-fill))
(def chart-line-up-duotone (icon-component svg/chart-line-up-duotone))
(def chart-pie-bold (icon-component svg/chart-pie-bold))
(def chart-pie (icon-component svg/chart-pie-regular))
(def chart-pie-light (icon-component svg/chart-pie-light))
(def chart-pie-thin (icon-component svg/chart-pie-thin))
(def chart-pie-fill (icon-component svg/chart-pie-fill))
(def chart-pie-duotone (icon-component svg/chart-pie-duotone))
(def chart-pie-slice-bold (icon-component svg/chart-pie-slice-bold))
(def chart-pie-slice (icon-component svg/chart-pie-slice-regular))
(def chart-pie-slice-light (icon-component svg/chart-pie-slice-light))
(def chart-pie-slice-thin (icon-component svg/chart-pie-slice-thin))
(def chart-pie-slice-fill (icon-component svg/chart-pie-slice-fill))
(def chart-pie-slice-duotone (icon-component svg/chart-pie-slice-duotone))
(def chart-polar-bold (icon-component svg/chart-polar-bold))
(def chart-polar (icon-component svg/chart-polar-regular))
(def chart-polar-light (icon-component svg/chart-polar-light))
(def chart-polar-thin (icon-component svg/chart-polar-thin))
(def chart-polar-fill (icon-component svg/chart-polar-fill))
(def chart-polar-duotone (icon-component svg/chart-polar-duotone))
(def chart-scatter-bold (icon-component svg/chart-scatter-bold))
(def chart-scatter (icon-component svg/chart-scatter-regular))
(def chart-scatter-light (icon-component svg/chart-scatter-light))
(def chart-scatter-thin (icon-component svg/chart-scatter-thin))
(def chart-scatter-fill (icon-component svg/chart-scatter-fill))
(def chart-scatter-duotone (icon-component svg/chart-scatter-duotone))
(def chat-bold (icon-component svg/chat-bold))
(def chat (icon-component svg/chat-regular))
(def chat-light (icon-component svg/chat-light))
(def chat-thin (icon-component svg/chat-thin))
(def chat-fill (icon-component svg/chat-fill))
(def chat-duotone (icon-component svg/chat-duotone))
(def chat-centered-bold (icon-component svg/chat-centered-bold))
(def chat-centered (icon-component svg/chat-centered-regular))
(def chat-centered-light (icon-component svg/chat-centered-light))
(def chat-centered-thin (icon-component svg/chat-centered-thin))
(def chat-centered-fill (icon-component svg/chat-centered-fill))
(def chat-centered-duotone (icon-component svg/chat-centered-duotone))
(def chat-centered-dots-bold (icon-component svg/chat-centered-dots-bold))
(def chat-centered-dots (icon-component svg/chat-centered-dots-regular))
(def chat-centered-dots-light (icon-component svg/chat-centered-dots-light))
(def chat-centered-dots-thin (icon-component svg/chat-centered-dots-thin))
(def chat-centered-dots-fill (icon-component svg/chat-centered-dots-fill))
(def chat-centered-dots-duotone (icon-component svg/chat-centered-dots-duotone))
(def chat-centered-slash-bold (icon-component svg/chat-centered-slash-bold))
(def chat-centered-slash (icon-component svg/chat-centered-slash-regular))
(def chat-centered-slash-light (icon-component svg/chat-centered-slash-light))
(def chat-centered-slash-thin (icon-component svg/chat-centered-slash-thin))
(def chat-centered-slash-fill (icon-component svg/chat-centered-slash-fill))
(def chat-centered-slash-duotone (icon-component svg/chat-centered-slash-duotone))
(def chat-centered-text-bold (icon-component svg/chat-centered-text-bold))
(def chat-centered-text (icon-component svg/chat-centered-text-regular))
(def chat-centered-text-light (icon-component svg/chat-centered-text-light))
(def chat-centered-text-thin (icon-component svg/chat-centered-text-thin))
(def chat-centered-text-fill (icon-component svg/chat-centered-text-fill))
(def chat-centered-text-duotone (icon-component svg/chat-centered-text-duotone))
(def chat-circle-bold (icon-component svg/chat-circle-bold))
(def chat-circle (icon-component svg/chat-circle-regular))
(def chat-circle-light (icon-component svg/chat-circle-light))
(def chat-circle-thin (icon-component svg/chat-circle-thin))
(def chat-circle-fill (icon-component svg/chat-circle-fill))
(def chat-circle-duotone (icon-component svg/chat-circle-duotone))
(def chat-circle-dots-bold (icon-component svg/chat-circle-dots-bold))
(def chat-circle-dots (icon-component svg/chat-circle-dots-regular))
(def chat-circle-dots-light (icon-component svg/chat-circle-dots-light))
(def chat-circle-dots-thin (icon-component svg/chat-circle-dots-thin))
(def chat-circle-dots-fill (icon-component svg/chat-circle-dots-fill))
(def chat-circle-dots-duotone (icon-component svg/chat-circle-dots-duotone))
(def chat-circle-slash-bold (icon-component svg/chat-circle-slash-bold))
(def chat-circle-slash (icon-component svg/chat-circle-slash-regular))
(def chat-circle-slash-light (icon-component svg/chat-circle-slash-light))
(def chat-circle-slash-thin (icon-component svg/chat-circle-slash-thin))
(def chat-circle-slash-fill (icon-component svg/chat-circle-slash-fill))
(def chat-circle-slash-duotone (icon-component svg/chat-circle-slash-duotone))
(def chat-circle-text-bold (icon-component svg/chat-circle-text-bold))
(def chat-circle-text (icon-component svg/chat-circle-text-regular))
(def chat-circle-text-light (icon-component svg/chat-circle-text-light))
(def chat-circle-text-thin (icon-component svg/chat-circle-text-thin))
(def chat-circle-text-fill (icon-component svg/chat-circle-text-fill))
(def chat-circle-text-duotone (icon-component svg/chat-circle-text-duotone))
(def chat-dots-bold (icon-component svg/chat-dots-bold))
(def chat-dots (icon-component svg/chat-dots-regular))
(def chat-dots-light (icon-component svg/chat-dots-light))
(def chat-dots-thin (icon-component svg/chat-dots-thin))
(def chat-dots-fill (icon-component svg/chat-dots-fill))
(def chat-dots-duotone (icon-component svg/chat-dots-duotone))
(def chat-slash-bold (icon-component svg/chat-slash-bold))
(def chat-slash (icon-component svg/chat-slash-regular))
(def chat-slash-light (icon-component svg/chat-slash-light))
(def chat-slash-thin (icon-component svg/chat-slash-thin))
(def chat-slash-fill (icon-component svg/chat-slash-fill))
(def chat-slash-duotone (icon-component svg/chat-slash-duotone))
(def chat-teardrop-bold (icon-component svg/chat-teardrop-bold))
(def chat-teardrop (icon-component svg/chat-teardrop-regular))
(def chat-teardrop-light (icon-component svg/chat-teardrop-light))
(def chat-teardrop-thin (icon-component svg/chat-teardrop-thin))
(def chat-teardrop-fill (icon-component svg/chat-teardrop-fill))
(def chat-teardrop-duotone (icon-component svg/chat-teardrop-duotone))
(def chat-teardrop-dots-bold (icon-component svg/chat-teardrop-dots-bold))
(def chat-teardrop-dots (icon-component svg/chat-teardrop-dots-regular))
(def chat-teardrop-dots-light (icon-component svg/chat-teardrop-dots-light))
(def chat-teardrop-dots-thin (icon-component svg/chat-teardrop-dots-thin))
(def chat-teardrop-dots-fill (icon-component svg/chat-teardrop-dots-fill))
(def chat-teardrop-dots-duotone (icon-component svg/chat-teardrop-dots-duotone))
(def chat-teardrop-slash-bold (icon-component svg/chat-teardrop-slash-bold))
(def chat-teardrop-slash (icon-component svg/chat-teardrop-slash-regular))
(def chat-teardrop-slash-light (icon-component svg/chat-teardrop-slash-light))
(def chat-teardrop-slash-thin (icon-component svg/chat-teardrop-slash-thin))
(def chat-teardrop-slash-fill (icon-component svg/chat-teardrop-slash-fill))
(def chat-teardrop-slash-duotone (icon-component svg/chat-teardrop-slash-duotone))
(def chat-teardrop-text-bold (icon-component svg/chat-teardrop-text-bold))
(def chat-teardrop-text (icon-component svg/chat-teardrop-text-regular))
(def chat-teardrop-text-light (icon-component svg/chat-teardrop-text-light))
(def chat-teardrop-text-thin (icon-component svg/chat-teardrop-text-thin))
(def chat-teardrop-text-fill (icon-component svg/chat-teardrop-text-fill))
(def chat-teardrop-text-duotone (icon-component svg/chat-teardrop-text-duotone))
(def chat-text-bold (icon-component svg/chat-text-bold))
(def chat-text (icon-component svg/chat-text-regular))
(def chat-text-light (icon-component svg/chat-text-light))
(def chat-text-thin (icon-component svg/chat-text-thin))
(def chat-text-fill (icon-component svg/chat-text-fill))
(def chat-text-duotone (icon-component svg/chat-text-duotone))
(def chats-bold (icon-component svg/chats-bold))
(def chats (icon-component svg/chats-regular))
(def chats-light (icon-component svg/chats-light))
(def chats-thin (icon-component svg/chats-thin))
(def chats-fill (icon-component svg/chats-fill))
(def chats-duotone (icon-component svg/chats-duotone))
(def chats-circle-bold (icon-component svg/chats-circle-bold))
(def chats-circle (icon-component svg/chats-circle-regular))
(def chats-circle-light (icon-component svg/chats-circle-light))
(def chats-circle-thin (icon-component svg/chats-circle-thin))
(def chats-circle-fill (icon-component svg/chats-circle-fill))
(def chats-circle-duotone (icon-component svg/chats-circle-duotone))
(def chats-teardrop-bold (icon-component svg/chats-teardrop-bold))
(def chats-teardrop (icon-component svg/chats-teardrop-regular))
(def chats-teardrop-light (icon-component svg/chats-teardrop-light))
(def chats-teardrop-thin (icon-component svg/chats-teardrop-thin))
(def chats-teardrop-fill (icon-component svg/chats-teardrop-fill))
(def chats-teardrop-duotone (icon-component svg/chats-teardrop-duotone))
(def check-bold (icon-component svg/check-bold))
(def check (icon-component svg/check-regular))
(def check-light (icon-component svg/check-light))
(def check-thin (icon-component svg/check-thin))
(def check-fill (icon-component svg/check-fill))
(def check-duotone (icon-component svg/check-duotone))
(def check-circle-bold (icon-component svg/check-circle-bold))
(def check-circle (icon-component svg/check-circle-regular))
(def check-circle-light (icon-component svg/check-circle-light))
(def check-circle-thin (icon-component svg/check-circle-thin))
(def check-circle-fill (icon-component svg/check-circle-fill))
(def check-circle-duotone (icon-component svg/check-circle-duotone))
(def check-fat-bold (icon-component svg/check-fat-bold))
(def check-fat (icon-component svg/check-fat-regular))
(def check-fat-light (icon-component svg/check-fat-light))
(def check-fat-thin (icon-component svg/check-fat-thin))
(def check-fat-fill (icon-component svg/check-fat-fill))
(def check-fat-duotone (icon-component svg/check-fat-duotone))
(def check-square-bold (icon-component svg/check-square-bold))
(def check-square (icon-component svg/check-square-regular))
(def check-square-light (icon-component svg/check-square-light))
(def check-square-thin (icon-component svg/check-square-thin))
(def check-square-fill (icon-component svg/check-square-fill))
(def check-square-duotone (icon-component svg/check-square-duotone))
(def check-square-offset-bold (icon-component svg/check-square-offset-bold))
(def check-square-offset (icon-component svg/check-square-offset-regular))
(def check-square-offset-light (icon-component svg/check-square-offset-light))
(def check-square-offset-thin (icon-component svg/check-square-offset-thin))
(def check-square-offset-fill (icon-component svg/check-square-offset-fill))
(def check-square-offset-duotone (icon-component svg/check-square-offset-duotone))
(def checkerboard-bold (icon-component svg/checkerboard-bold))
(def checkerboard (icon-component svg/checkerboard-regular))
(def checkerboard-light (icon-component svg/checkerboard-light))
(def checkerboard-thin (icon-component svg/checkerboard-thin))
(def checkerboard-fill (icon-component svg/checkerboard-fill))
(def checkerboard-duotone (icon-component svg/checkerboard-duotone))
(def checks-bold (icon-component svg/checks-bold))
(def checks (icon-component svg/checks-regular))
(def checks-light (icon-component svg/checks-light))
(def checks-thin (icon-component svg/checks-thin))
(def checks-fill (icon-component svg/checks-fill))
(def checks-duotone (icon-component svg/checks-duotone))
(def cheers-bold (icon-component svg/cheers-bold))
(def cheers (icon-component svg/cheers-regular))
(def cheers-light (icon-component svg/cheers-light))
(def cheers-thin (icon-component svg/cheers-thin))
(def cheers-fill (icon-component svg/cheers-fill))
(def cheers-duotone (icon-component svg/cheers-duotone))
(def cheese-bold (icon-component svg/cheese-bold))
(def cheese (icon-component svg/cheese-regular))
(def cheese-light (icon-component svg/cheese-light))
(def cheese-thin (icon-component svg/cheese-thin))
(def cheese-fill (icon-component svg/cheese-fill))
(def cheese-duotone (icon-component svg/cheese-duotone))
(def chef-hat-bold (icon-component svg/chef-hat-bold))
(def chef-hat (icon-component svg/chef-hat-regular))
(def chef-hat-light (icon-component svg/chef-hat-light))
(def chef-hat-thin (icon-component svg/chef-hat-thin))
(def chef-hat-fill (icon-component svg/chef-hat-fill))
(def chef-hat-duotone (icon-component svg/chef-hat-duotone))
(def cherries-bold (icon-component svg/cherries-bold))
(def cherries (icon-component svg/cherries-regular))
(def cherries-light (icon-component svg/cherries-light))
(def cherries-thin (icon-component svg/cherries-thin))
(def cherries-fill (icon-component svg/cherries-fill))
(def cherries-duotone (icon-component svg/cherries-duotone))
(def church-bold (icon-component svg/church-bold))
(def church (icon-component svg/church-regular))
(def church-light (icon-component svg/church-light))
(def church-thin (icon-component svg/church-thin))
(def church-fill (icon-component svg/church-fill))
(def church-duotone (icon-component svg/church-duotone))
(def cigarette-bold (icon-component svg/cigarette-bold))
(def cigarette (icon-component svg/cigarette-regular))
(def cigarette-light (icon-component svg/cigarette-light))
(def cigarette-thin (icon-component svg/cigarette-thin))
(def cigarette-fill (icon-component svg/cigarette-fill))
(def cigarette-duotone (icon-component svg/cigarette-duotone))
(def cigarette-slash-bold (icon-component svg/cigarette-slash-bold))
(def cigarette-slash (icon-component svg/cigarette-slash-regular))
(def cigarette-slash-light (icon-component svg/cigarette-slash-light))
(def cigarette-slash-thin (icon-component svg/cigarette-slash-thin))
(def cigarette-slash-fill (icon-component svg/cigarette-slash-fill))
(def cigarette-slash-duotone (icon-component svg/cigarette-slash-duotone))
(def circle-bold (icon-component svg/circle-bold))
(def circle (icon-component svg/circle-regular))
(def circle-light (icon-component svg/circle-light))
(def circle-thin (icon-component svg/circle-thin))
(def circle-fill (icon-component svg/circle-fill))
(def circle-duotone (icon-component svg/circle-duotone))
(def circle-dashed-bold (icon-component svg/circle-dashed-bold))
(def circle-dashed (icon-component svg/circle-dashed-regular))
(def circle-dashed-light (icon-component svg/circle-dashed-light))
(def circle-dashed-thin (icon-component svg/circle-dashed-thin))
(def circle-dashed-fill (icon-component svg/circle-dashed-fill))
(def circle-dashed-duotone (icon-component svg/circle-dashed-duotone))
(def circle-half-bold (icon-component svg/circle-half-bold))
(def circle-half (icon-component svg/circle-half-regular))
(def circle-half-light (icon-component svg/circle-half-light))
(def circle-half-thin (icon-component svg/circle-half-thin))
(def circle-half-fill (icon-component svg/circle-half-fill))
(def circle-half-duotone (icon-component svg/circle-half-duotone))
(def circle-half-tilt-bold (icon-component svg/circle-half-tilt-bold))
(def circle-half-tilt (icon-component svg/circle-half-tilt-regular))
(def circle-half-tilt-light (icon-component svg/circle-half-tilt-light))
(def circle-half-tilt-thin (icon-component svg/circle-half-tilt-thin))
(def circle-half-tilt-fill (icon-component svg/circle-half-tilt-fill))
(def circle-half-tilt-duotone (icon-component svg/circle-half-tilt-duotone))
(def circle-notch-bold (icon-component svg/circle-notch-bold))
(def circle-notch (icon-component svg/circle-notch-regular))
(def circle-notch-light (icon-component svg/circle-notch-light))
(def circle-notch-thin (icon-component svg/circle-notch-thin))
(def circle-notch-fill (icon-component svg/circle-notch-fill))
(def circle-notch-duotone (icon-component svg/circle-notch-duotone))
(def circles-four-bold (icon-component svg/circles-four-bold))
(def circles-four (icon-component svg/circles-four-regular))
(def circles-four-light (icon-component svg/circles-four-light))
(def circles-four-thin (icon-component svg/circles-four-thin))
(def circles-four-fill (icon-component svg/circles-four-fill))
(def circles-four-duotone (icon-component svg/circles-four-duotone))
(def circles-three-bold (icon-component svg/circles-three-bold))
(def circles-three (icon-component svg/circles-three-regular))
(def circles-three-light (icon-component svg/circles-three-light))
(def circles-three-thin (icon-component svg/circles-three-thin))
(def circles-three-fill (icon-component svg/circles-three-fill))
(def circles-three-duotone (icon-component svg/circles-three-duotone))
(def circles-three-plus-bold (icon-component svg/circles-three-plus-bold))
(def circles-three-plus (icon-component svg/circles-three-plus-regular))
(def circles-three-plus-light (icon-component svg/circles-three-plus-light))
(def circles-three-plus-thin (icon-component svg/circles-three-plus-thin))
(def circles-three-plus-fill (icon-component svg/circles-three-plus-fill))
(def circles-three-plus-duotone (icon-component svg/circles-three-plus-duotone))
(def circuitry-bold (icon-component svg/circuitry-bold))
(def circuitry (icon-component svg/circuitry-regular))
(def circuitry-light (icon-component svg/circuitry-light))
(def circuitry-thin (icon-component svg/circuitry-thin))
(def circuitry-fill (icon-component svg/circuitry-fill))
(def circuitry-duotone (icon-component svg/circuitry-duotone))
(def city-bold (icon-component svg/city-bold))
(def city (icon-component svg/city-regular))
(def city-light (icon-component svg/city-light))
(def city-thin (icon-component svg/city-thin))
(def city-fill (icon-component svg/city-fill))
(def city-duotone (icon-component svg/city-duotone))
(def clipboard-bold (icon-component svg/clipboard-bold))
(def clipboard (icon-component svg/clipboard-regular))
(def clipboard-light (icon-component svg/clipboard-light))
(def clipboard-thin (icon-component svg/clipboard-thin))
(def clipboard-fill (icon-component svg/clipboard-fill))
(def clipboard-duotone (icon-component svg/clipboard-duotone))
(def clipboard-text-bold (icon-component svg/clipboard-text-bold))
(def clipboard-text (icon-component svg/clipboard-text-regular))
(def clipboard-text-light (icon-component svg/clipboard-text-light))
(def clipboard-text-thin (icon-component svg/clipboard-text-thin))
(def clipboard-text-fill (icon-component svg/clipboard-text-fill))
(def clipboard-text-duotone (icon-component svg/clipboard-text-duotone))
(def clock-bold (icon-component svg/clock-bold))
(def clock (icon-component svg/clock-regular))
(def clock-light (icon-component svg/clock-light))
(def clock-thin (icon-component svg/clock-thin))
(def clock-fill (icon-component svg/clock-fill))
(def clock-duotone (icon-component svg/clock-duotone))
(def clock-afternoon-bold (icon-component svg/clock-afternoon-bold))
(def clock-afternoon (icon-component svg/clock-afternoon-regular))
(def clock-afternoon-light (icon-component svg/clock-afternoon-light))
(def clock-afternoon-thin (icon-component svg/clock-afternoon-thin))
(def clock-afternoon-fill (icon-component svg/clock-afternoon-fill))
(def clock-afternoon-duotone (icon-component svg/clock-afternoon-duotone))
(def clock-clockwise-bold (icon-component svg/clock-clockwise-bold))
(def clock-clockwise (icon-component svg/clock-clockwise-regular))
(def clock-clockwise-light (icon-component svg/clock-clockwise-light))
(def clock-clockwise-thin (icon-component svg/clock-clockwise-thin))
(def clock-clockwise-fill (icon-component svg/clock-clockwise-fill))
(def clock-clockwise-duotone (icon-component svg/clock-clockwise-duotone))
(def clock-countdown-bold (icon-component svg/clock-countdown-bold))
(def clock-countdown (icon-component svg/clock-countdown-regular))
(def clock-countdown-light (icon-component svg/clock-countdown-light))
(def clock-countdown-thin (icon-component svg/clock-countdown-thin))
(def clock-countdown-fill (icon-component svg/clock-countdown-fill))
(def clock-countdown-duotone (icon-component svg/clock-countdown-duotone))
(def clock-counter-clockwise-bold (icon-component svg/clock-counter-clockwise-bold))
(def clock-counter-clockwise (icon-component svg/clock-counter-clockwise-regular))
(def clock-counter-clockwise-light (icon-component svg/clock-counter-clockwise-light))
(def clock-counter-clockwise-thin (icon-component svg/clock-counter-clockwise-thin))
(def clock-counter-clockwise-fill (icon-component svg/clock-counter-clockwise-fill))
(def clock-counter-clockwise-duotone (icon-component svg/clock-counter-clockwise-duotone))
(def clock-user-bold (icon-component svg/clock-user-bold))
(def clock-user (icon-component svg/clock-user-regular))
(def clock-user-light (icon-component svg/clock-user-light))
(def clock-user-thin (icon-component svg/clock-user-thin))
(def clock-user-fill (icon-component svg/clock-user-fill))
(def clock-user-duotone (icon-component svg/clock-user-duotone))
(def closed-captioning-bold (icon-component svg/closed-captioning-bold))
(def closed-captioning (icon-component svg/closed-captioning-regular))
(def closed-captioning-light (icon-component svg/closed-captioning-light))
(def closed-captioning-thin (icon-component svg/closed-captioning-thin))
(def closed-captioning-fill (icon-component svg/closed-captioning-fill))
(def closed-captioning-duotone (icon-component svg/closed-captioning-duotone))
(def cloud-bold (icon-component svg/cloud-bold))
(def cloud (icon-component svg/cloud-regular))
(def cloud-light (icon-component svg/cloud-light))
(def cloud-thin (icon-component svg/cloud-thin))
(def cloud-fill (icon-component svg/cloud-fill))
(def cloud-duotone (icon-component svg/cloud-duotone))
(def cloud-arrow-down-bold (icon-component svg/cloud-arrow-down-bold))
(def cloud-arrow-down (icon-component svg/cloud-arrow-down-regular))
(def cloud-arrow-down-light (icon-component svg/cloud-arrow-down-light))
(def cloud-arrow-down-thin (icon-component svg/cloud-arrow-down-thin))
(def cloud-arrow-down-fill (icon-component svg/cloud-arrow-down-fill))
(def cloud-arrow-down-duotone (icon-component svg/cloud-arrow-down-duotone))
(def cloud-arrow-up-bold (icon-component svg/cloud-arrow-up-bold))
(def cloud-arrow-up (icon-component svg/cloud-arrow-up-regular))
(def cloud-arrow-up-light (icon-component svg/cloud-arrow-up-light))
(def cloud-arrow-up-thin (icon-component svg/cloud-arrow-up-thin))
(def cloud-arrow-up-fill (icon-component svg/cloud-arrow-up-fill))
(def cloud-arrow-up-duotone (icon-component svg/cloud-arrow-up-duotone))
(def cloud-check-bold (icon-component svg/cloud-check-bold))
(def cloud-check (icon-component svg/cloud-check-regular))
(def cloud-check-light (icon-component svg/cloud-check-light))
(def cloud-check-thin (icon-component svg/cloud-check-thin))
(def cloud-check-fill (icon-component svg/cloud-check-fill))
(def cloud-check-duotone (icon-component svg/cloud-check-duotone))
(def cloud-fog-bold (icon-component svg/cloud-fog-bold))
(def cloud-fog (icon-component svg/cloud-fog-regular))
(def cloud-fog-light (icon-component svg/cloud-fog-light))
(def cloud-fog-thin (icon-component svg/cloud-fog-thin))
(def cloud-fog-fill (icon-component svg/cloud-fog-fill))
(def cloud-fog-duotone (icon-component svg/cloud-fog-duotone))
(def cloud-lightning-bold (icon-component svg/cloud-lightning-bold))
(def cloud-lightning (icon-component svg/cloud-lightning-regular))
(def cloud-lightning-light (icon-component svg/cloud-lightning-light))
(def cloud-lightning-thin (icon-component svg/cloud-lightning-thin))
(def cloud-lightning-fill (icon-component svg/cloud-lightning-fill))
(def cloud-lightning-duotone (icon-component svg/cloud-lightning-duotone))
(def cloud-moon-bold (icon-component svg/cloud-moon-bold))
(def cloud-moon (icon-component svg/cloud-moon-regular))
(def cloud-moon-light (icon-component svg/cloud-moon-light))
(def cloud-moon-thin (icon-component svg/cloud-moon-thin))
(def cloud-moon-fill (icon-component svg/cloud-moon-fill))
(def cloud-moon-duotone (icon-component svg/cloud-moon-duotone))
(def cloud-rain-bold (icon-component svg/cloud-rain-bold))
(def cloud-rain (icon-component svg/cloud-rain-regular))
(def cloud-rain-light (icon-component svg/cloud-rain-light))
(def cloud-rain-thin (icon-component svg/cloud-rain-thin))
(def cloud-rain-fill (icon-component svg/cloud-rain-fill))
(def cloud-rain-duotone (icon-component svg/cloud-rain-duotone))
(def cloud-slash-bold (icon-component svg/cloud-slash-bold))
(def cloud-slash (icon-component svg/cloud-slash-regular))
(def cloud-slash-light (icon-component svg/cloud-slash-light))
(def cloud-slash-thin (icon-component svg/cloud-slash-thin))
(def cloud-slash-fill (icon-component svg/cloud-slash-fill))
(def cloud-slash-duotone (icon-component svg/cloud-slash-duotone))
(def cloud-snow-bold (icon-component svg/cloud-snow-bold))
(def cloud-snow (icon-component svg/cloud-snow-regular))
(def cloud-snow-light (icon-component svg/cloud-snow-light))
(def cloud-snow-thin (icon-component svg/cloud-snow-thin))
(def cloud-snow-fill (icon-component svg/cloud-snow-fill))
(def cloud-snow-duotone (icon-component svg/cloud-snow-duotone))
(def cloud-sun-bold (icon-component svg/cloud-sun-bold))
(def cloud-sun (icon-component svg/cloud-sun-regular))
(def cloud-sun-light (icon-component svg/cloud-sun-light))
(def cloud-sun-thin (icon-component svg/cloud-sun-thin))
(def cloud-sun-fill (icon-component svg/cloud-sun-fill))
(def cloud-sun-duotone (icon-component svg/cloud-sun-duotone))
(def cloud-warning-bold (icon-component svg/cloud-warning-bold))
(def cloud-warning (icon-component svg/cloud-warning-regular))
(def cloud-warning-light (icon-component svg/cloud-warning-light))
(def cloud-warning-thin (icon-component svg/cloud-warning-thin))
(def cloud-warning-fill (icon-component svg/cloud-warning-fill))
(def cloud-warning-duotone (icon-component svg/cloud-warning-duotone))
(def cloud-x-bold (icon-component svg/cloud-x-bold))
(def cloud-x (icon-component svg/cloud-x-regular))
(def cloud-x-light (icon-component svg/cloud-x-light))
(def cloud-x-thin (icon-component svg/cloud-x-thin))
(def cloud-x-fill (icon-component svg/cloud-x-fill))
(def cloud-x-duotone (icon-component svg/cloud-x-duotone))
(def clover-bold (icon-component svg/clover-bold))
(def clover (icon-component svg/clover-regular))
(def clover-light (icon-component svg/clover-light))
(def clover-thin (icon-component svg/clover-thin))
(def clover-fill (icon-component svg/clover-fill))
(def clover-duotone (icon-component svg/clover-duotone))
(def club-bold (icon-component svg/club-bold))
(def club (icon-component svg/club-regular))
(def club-light (icon-component svg/club-light))
(def club-thin (icon-component svg/club-thin))
(def club-fill (icon-component svg/club-fill))
(def club-duotone (icon-component svg/club-duotone))
(def coat-hanger-bold (icon-component svg/coat-hanger-bold))
(def coat-hanger (icon-component svg/coat-hanger-regular))
(def coat-hanger-light (icon-component svg/coat-hanger-light))
(def coat-hanger-thin (icon-component svg/coat-hanger-thin))
(def coat-hanger-fill (icon-component svg/coat-hanger-fill))
(def coat-hanger-duotone (icon-component svg/coat-hanger-duotone))
(def coda-logo-bold (icon-component svg/coda-logo-bold))
(def coda-logo (icon-component svg/coda-logo-regular))
(def coda-logo-light (icon-component svg/coda-logo-light))
(def coda-logo-thin (icon-component svg/coda-logo-thin))
(def coda-logo-fill (icon-component svg/coda-logo-fill))
(def coda-logo-duotone (icon-component svg/coda-logo-duotone))
(def code-bold (icon-component svg/code-bold))
(def code (icon-component svg/code-regular))
(def code-light (icon-component svg/code-light))
(def code-thin (icon-component svg/code-thin))
(def code-fill (icon-component svg/code-fill))
(def code-duotone (icon-component svg/code-duotone))
(def code-block-bold (icon-component svg/code-block-bold))
(def code-block (icon-component svg/code-block-regular))
(def code-block-light (icon-component svg/code-block-light))
(def code-block-thin (icon-component svg/code-block-thin))
(def code-block-fill (icon-component svg/code-block-fill))
(def code-block-duotone (icon-component svg/code-block-duotone))
(def code-simple-bold (icon-component svg/code-simple-bold))
(def code-simple (icon-component svg/code-simple-regular))
(def code-simple-light (icon-component svg/code-simple-light))
(def code-simple-thin (icon-component svg/code-simple-thin))
(def code-simple-fill (icon-component svg/code-simple-fill))
(def code-simple-duotone (icon-component svg/code-simple-duotone))
(def codepen-logo-bold (icon-component svg/codepen-logo-bold))
(def codepen-logo (icon-component svg/codepen-logo-regular))
(def codepen-logo-light (icon-component svg/codepen-logo-light))
(def codepen-logo-thin (icon-component svg/codepen-logo-thin))
(def codepen-logo-fill (icon-component svg/codepen-logo-fill))
(def codepen-logo-duotone (icon-component svg/codepen-logo-duotone))
(def codesandbox-logo-bold (icon-component svg/codesandbox-logo-bold))
(def codesandbox-logo (icon-component svg/codesandbox-logo-regular))
(def codesandbox-logo-light (icon-component svg/codesandbox-logo-light))
(def codesandbox-logo-thin (icon-component svg/codesandbox-logo-thin))
(def codesandbox-logo-fill (icon-component svg/codesandbox-logo-fill))
(def codesandbox-logo-duotone (icon-component svg/codesandbox-logo-duotone))
(def coffee-bold (icon-component svg/coffee-bold))
(def coffee (icon-component svg/coffee-regular))
(def coffee-light (icon-component svg/coffee-light))
(def coffee-thin (icon-component svg/coffee-thin))
(def coffee-fill (icon-component svg/coffee-fill))
(def coffee-duotone (icon-component svg/coffee-duotone))
(def coffee-bean-bold (icon-component svg/coffee-bean-bold))
(def coffee-bean (icon-component svg/coffee-bean-regular))
(def coffee-bean-light (icon-component svg/coffee-bean-light))
(def coffee-bean-thin (icon-component svg/coffee-bean-thin))
(def coffee-bean-fill (icon-component svg/coffee-bean-fill))
(def coffee-bean-duotone (icon-component svg/coffee-bean-duotone))
(def coin-bold (icon-component svg/coin-bold))
(def coin (icon-component svg/coin-regular))
(def coin-light (icon-component svg/coin-light))
(def coin-thin (icon-component svg/coin-thin))
(def coin-fill (icon-component svg/coin-fill))
(def coin-duotone (icon-component svg/coin-duotone))
(def coin-vertical-bold (icon-component svg/coin-vertical-bold))
(def coin-vertical (icon-component svg/coin-vertical-regular))
(def coin-vertical-light (icon-component svg/coin-vertical-light))
(def coin-vertical-thin (icon-component svg/coin-vertical-thin))
(def coin-vertical-fill (icon-component svg/coin-vertical-fill))
(def coin-vertical-duotone (icon-component svg/coin-vertical-duotone))
(def coins-bold (icon-component svg/coins-bold))
(def coins (icon-component svg/coins-regular))
(def coins-light (icon-component svg/coins-light))
(def coins-thin (icon-component svg/coins-thin))
(def coins-fill (icon-component svg/coins-fill))
(def coins-duotone (icon-component svg/coins-duotone))
(def columns-bold (icon-component svg/columns-bold))
(def columns (icon-component svg/columns-regular))
(def columns-light (icon-component svg/columns-light))
(def columns-thin (icon-component svg/columns-thin))
(def columns-fill (icon-component svg/columns-fill))
(def columns-duotone (icon-component svg/columns-duotone))
(def columns-plus-left-bold (icon-component svg/columns-plus-left-bold))
(def columns-plus-left (icon-component svg/columns-plus-left-regular))
(def columns-plus-left-light (icon-component svg/columns-plus-left-light))
(def columns-plus-left-thin (icon-component svg/columns-plus-left-thin))
(def columns-plus-left-fill (icon-component svg/columns-plus-left-fill))
(def columns-plus-left-duotone (icon-component svg/columns-plus-left-duotone))
(def columns-plus-right-bold (icon-component svg/columns-plus-right-bold))
(def columns-plus-right (icon-component svg/columns-plus-right-regular))
(def columns-plus-right-light (icon-component svg/columns-plus-right-light))
(def columns-plus-right-thin (icon-component svg/columns-plus-right-thin))
(def columns-plus-right-fill (icon-component svg/columns-plus-right-fill))
(def columns-plus-right-duotone (icon-component svg/columns-plus-right-duotone))
(def command-bold (icon-component svg/command-bold))
(def command (icon-component svg/command-regular))
(def command-light (icon-component svg/command-light))
(def command-thin (icon-component svg/command-thin))
(def command-fill (icon-component svg/command-fill))
(def command-duotone (icon-component svg/command-duotone))
(def compass-bold (icon-component svg/compass-bold))
(def compass (icon-component svg/compass-regular))
(def compass-light (icon-component svg/compass-light))
(def compass-thin (icon-component svg/compass-thin))
(def compass-fill (icon-component svg/compass-fill))
(def compass-duotone (icon-component svg/compass-duotone))
(def compass-rose-bold (icon-component svg/compass-rose-bold))
(def compass-rose (icon-component svg/compass-rose-regular))
(def compass-rose-light (icon-component svg/compass-rose-light))
(def compass-rose-thin (icon-component svg/compass-rose-thin))
(def compass-rose-fill (icon-component svg/compass-rose-fill))
(def compass-rose-duotone (icon-component svg/compass-rose-duotone))
(def compass-tool-bold (icon-component svg/compass-tool-bold))
(def compass-tool (icon-component svg/compass-tool-regular))
(def compass-tool-light (icon-component svg/compass-tool-light))
(def compass-tool-thin (icon-component svg/compass-tool-thin))
(def compass-tool-fill (icon-component svg/compass-tool-fill))
(def compass-tool-duotone (icon-component svg/compass-tool-duotone))
(def computer-tower-bold (icon-component svg/computer-tower-bold))
(def computer-tower (icon-component svg/computer-tower-regular))
(def computer-tower-light (icon-component svg/computer-tower-light))
(def computer-tower-thin (icon-component svg/computer-tower-thin))
(def computer-tower-fill (icon-component svg/computer-tower-fill))
(def computer-tower-duotone (icon-component svg/computer-tower-duotone))
(def confetti-bold (icon-component svg/confetti-bold))
(def confetti (icon-component svg/confetti-regular))
(def confetti-light (icon-component svg/confetti-light))
(def confetti-thin (icon-component svg/confetti-thin))
(def confetti-fill (icon-component svg/confetti-fill))
(def confetti-duotone (icon-component svg/confetti-duotone))
(def contactless-payment-bold (icon-component svg/contactless-payment-bold))
(def contactless-payment (icon-component svg/contactless-payment-regular))
(def contactless-payment-light (icon-component svg/contactless-payment-light))
(def contactless-payment-thin (icon-component svg/contactless-payment-thin))
(def contactless-payment-fill (icon-component svg/contactless-payment-fill))
(def contactless-payment-duotone (icon-component svg/contactless-payment-duotone))
(def control-bold (icon-component svg/control-bold))
(def control (icon-component svg/control-regular))
(def control-light (icon-component svg/control-light))
(def control-thin (icon-component svg/control-thin))
(def control-fill (icon-component svg/control-fill))
(def control-duotone (icon-component svg/control-duotone))
(def cookie-bold (icon-component svg/cookie-bold))
(def cookie (icon-component svg/cookie-regular))
(def cookie-light (icon-component svg/cookie-light))
(def cookie-thin (icon-component svg/cookie-thin))
(def cookie-fill (icon-component svg/cookie-fill))
(def cookie-duotone (icon-component svg/cookie-duotone))
(def cooking-pot-bold (icon-component svg/cooking-pot-bold))
(def cooking-pot (icon-component svg/cooking-pot-regular))
(def cooking-pot-light (icon-component svg/cooking-pot-light))
(def cooking-pot-thin (icon-component svg/cooking-pot-thin))
(def cooking-pot-fill (icon-component svg/cooking-pot-fill))
(def cooking-pot-duotone (icon-component svg/cooking-pot-duotone))
(def copy-bold (icon-component svg/copy-bold))
(def copy (icon-component svg/copy-regular))
(def copy-light (icon-component svg/copy-light))
(def copy-thin (icon-component svg/copy-thin))
(def copy-fill (icon-component svg/copy-fill))
(def copy-duotone (icon-component svg/copy-duotone))
(def copy-simple-bold (icon-component svg/copy-simple-bold))
(def copy-simple (icon-component svg/copy-simple-regular))
(def copy-simple-light (icon-component svg/copy-simple-light))
(def copy-simple-thin (icon-component svg/copy-simple-thin))
(def copy-simple-fill (icon-component svg/copy-simple-fill))
(def copy-simple-duotone (icon-component svg/copy-simple-duotone))
(def copyleft-bold (icon-component svg/copyleft-bold))
(def copyleft (icon-component svg/copyleft-regular))
(def copyleft-light (icon-component svg/copyleft-light))
(def copyleft-thin (icon-component svg/copyleft-thin))
(def copyleft-fill (icon-component svg/copyleft-fill))
(def copyleft-duotone (icon-component svg/copyleft-duotone))
(def copyright-bold (icon-component svg/copyright-bold))
(def copyright (icon-component svg/copyright-regular))
(def copyright-light (icon-component svg/copyright-light))
(def copyright-thin (icon-component svg/copyright-thin))
(def copyright-fill (icon-component svg/copyright-fill))
(def copyright-duotone (icon-component svg/copyright-duotone))
(def corners-in-bold (icon-component svg/corners-in-bold))
(def corners-in (icon-component svg/corners-in-regular))
(def corners-in-light (icon-component svg/corners-in-light))
(def corners-in-thin (icon-component svg/corners-in-thin))
(def corners-in-fill (icon-component svg/corners-in-fill))
(def corners-in-duotone (icon-component svg/corners-in-duotone))
(def corners-out-bold (icon-component svg/corners-out-bold))
(def corners-out (icon-component svg/corners-out-regular))
(def corners-out-light (icon-component svg/corners-out-light))
(def corners-out-thin (icon-component svg/corners-out-thin))
(def corners-out-fill (icon-component svg/corners-out-fill))
(def corners-out-duotone (icon-component svg/corners-out-duotone))
(def couch-bold (icon-component svg/couch-bold))
(def couch (icon-component svg/couch-regular))
(def couch-light (icon-component svg/couch-light))
(def couch-thin (icon-component svg/couch-thin))
(def couch-fill (icon-component svg/couch-fill))
(def couch-duotone (icon-component svg/couch-duotone))
(def court-basketball-bold (icon-component svg/court-basketball-bold))
(def court-basketball (icon-component svg/court-basketball-regular))
(def court-basketball-light (icon-component svg/court-basketball-light))
(def court-basketball-thin (icon-component svg/court-basketball-thin))
(def court-basketball-fill (icon-component svg/court-basketball-fill))
(def court-basketball-duotone (icon-component svg/court-basketball-duotone))
(def cow-bold (icon-component svg/cow-bold))
(def cow (icon-component svg/cow-regular))
(def cow-light (icon-component svg/cow-light))
(def cow-thin (icon-component svg/cow-thin))
(def cow-fill (icon-component svg/cow-fill))
(def cow-duotone (icon-component svg/cow-duotone))
(def cowboy-hat-bold (icon-component svg/cowboy-hat-bold))
(def cowboy-hat (icon-component svg/cowboy-hat-regular))
(def cowboy-hat-light (icon-component svg/cowboy-hat-light))
(def cowboy-hat-thin (icon-component svg/cowboy-hat-thin))
(def cowboy-hat-fill (icon-component svg/cowboy-hat-fill))
(def cowboy-hat-duotone (icon-component svg/cowboy-hat-duotone))
(def cpu-bold (icon-component svg/cpu-bold))
(def cpu (icon-component svg/cpu-regular))
(def cpu-light (icon-component svg/cpu-light))
(def cpu-thin (icon-component svg/cpu-thin))
(def cpu-fill (icon-component svg/cpu-fill))
(def cpu-duotone (icon-component svg/cpu-duotone))
(def crane-bold (icon-component svg/crane-bold))
(def crane (icon-component svg/crane-regular))
(def crane-light (icon-component svg/crane-light))
(def crane-thin (icon-component svg/crane-thin))
(def crane-fill (icon-component svg/crane-fill))
(def crane-duotone (icon-component svg/crane-duotone))
(def crane-tower-bold (icon-component svg/crane-tower-bold))
(def crane-tower (icon-component svg/crane-tower-regular))
(def crane-tower-light (icon-component svg/crane-tower-light))
(def crane-tower-thin (icon-component svg/crane-tower-thin))
(def crane-tower-fill (icon-component svg/crane-tower-fill))
(def crane-tower-duotone (icon-component svg/crane-tower-duotone))
(def credit-card-bold (icon-component svg/credit-card-bold))
(def credit-card (icon-component svg/credit-card-regular))
(def credit-card-light (icon-component svg/credit-card-light))
(def credit-card-thin (icon-component svg/credit-card-thin))
(def credit-card-fill (icon-component svg/credit-card-fill))
(def credit-card-duotone (icon-component svg/credit-card-duotone))
(def cricket-bold (icon-component svg/cricket-bold))
(def cricket (icon-component svg/cricket-regular))
(def cricket-light (icon-component svg/cricket-light))
(def cricket-thin (icon-component svg/cricket-thin))
(def cricket-fill (icon-component svg/cricket-fill))
(def cricket-duotone (icon-component svg/cricket-duotone))
(def crop-bold (icon-component svg/crop-bold))
(def crop (icon-component svg/crop-regular))
(def crop-light (icon-component svg/crop-light))
(def crop-thin (icon-component svg/crop-thin))
(def crop-fill (icon-component svg/crop-fill))
(def crop-duotone (icon-component svg/crop-duotone))
(def cross-bold (icon-component svg/cross-bold))
(def cross (icon-component svg/cross-regular))
(def cross-light (icon-component svg/cross-light))
(def cross-thin (icon-component svg/cross-thin))
(def cross-fill (icon-component svg/cross-fill))
(def cross-duotone (icon-component svg/cross-duotone))
(def crosshair-bold (icon-component svg/crosshair-bold))
(def crosshair (icon-component svg/crosshair-regular))
(def crosshair-light (icon-component svg/crosshair-light))
(def crosshair-thin (icon-component svg/crosshair-thin))
(def crosshair-fill (icon-component svg/crosshair-fill))
(def crosshair-duotone (icon-component svg/crosshair-duotone))
(def crosshair-simple-bold (icon-component svg/crosshair-simple-bold))
(def crosshair-simple (icon-component svg/crosshair-simple-regular))
(def crosshair-simple-light (icon-component svg/crosshair-simple-light))
(def crosshair-simple-thin (icon-component svg/crosshair-simple-thin))
(def crosshair-simple-fill (icon-component svg/crosshair-simple-fill))
(def crosshair-simple-duotone (icon-component svg/crosshair-simple-duotone))
(def crown-bold (icon-component svg/crown-bold))
(def crown (icon-component svg/crown-regular))
(def crown-light (icon-component svg/crown-light))
(def crown-thin (icon-component svg/crown-thin))
(def crown-fill (icon-component svg/crown-fill))
(def crown-duotone (icon-component svg/crown-duotone))
(def crown-cross-bold (icon-component svg/crown-cross-bold))
(def crown-cross (icon-component svg/crown-cross-regular))
(def crown-cross-light (icon-component svg/crown-cross-light))
(def crown-cross-thin (icon-component svg/crown-cross-thin))
(def crown-cross-fill (icon-component svg/crown-cross-fill))
(def crown-cross-duotone (icon-component svg/crown-cross-duotone))
(def crown-simple-bold (icon-component svg/crown-simple-bold))
(def crown-simple (icon-component svg/crown-simple-regular))
(def crown-simple-light (icon-component svg/crown-simple-light))
(def crown-simple-thin (icon-component svg/crown-simple-thin))
(def crown-simple-fill (icon-component svg/crown-simple-fill))
(def crown-simple-duotone (icon-component svg/crown-simple-duotone))
(def cube-bold (icon-component svg/cube-bold))
(def cube (icon-component svg/cube-regular))
(def cube-light (icon-component svg/cube-light))
(def cube-thin (icon-component svg/cube-thin))
(def cube-fill (icon-component svg/cube-fill))
(def cube-duotone (icon-component svg/cube-duotone))
(def cube-focus-bold (icon-component svg/cube-focus-bold))
(def cube-focus (icon-component svg/cube-focus-regular))
(def cube-focus-light (icon-component svg/cube-focus-light))
(def cube-focus-thin (icon-component svg/cube-focus-thin))
(def cube-focus-fill (icon-component svg/cube-focus-fill))
(def cube-focus-duotone (icon-component svg/cube-focus-duotone))
(def cube-transparent-bold (icon-component svg/cube-transparent-bold))
(def cube-transparent (icon-component svg/cube-transparent-regular))
(def cube-transparent-light (icon-component svg/cube-transparent-light))
(def cube-transparent-thin (icon-component svg/cube-transparent-thin))
(def cube-transparent-fill (icon-component svg/cube-transparent-fill))
(def cube-transparent-duotone (icon-component svg/cube-transparent-duotone))
(def currency-btc-bold (icon-component svg/currency-btc-bold))
(def currency-btc (icon-component svg/currency-btc-regular))
(def currency-btc-light (icon-component svg/currency-btc-light))
(def currency-btc-thin (icon-component svg/currency-btc-thin))
(def currency-btc-fill (icon-component svg/currency-btc-fill))
(def currency-btc-duotone (icon-component svg/currency-btc-duotone))
(def currency-circle-dollar-bold (icon-component svg/currency-circle-dollar-bold))
(def currency-circle-dollar (icon-component svg/currency-circle-dollar-regular))
(def currency-circle-dollar-light (icon-component svg/currency-circle-dollar-light))
(def currency-circle-dollar-thin (icon-component svg/currency-circle-dollar-thin))
(def currency-circle-dollar-fill (icon-component svg/currency-circle-dollar-fill))
(def currency-circle-dollar-duotone (icon-component svg/currency-circle-dollar-duotone))
(def currency-cny-bold (icon-component svg/currency-cny-bold))
(def currency-cny (icon-component svg/currency-cny-regular))
(def currency-cny-light (icon-component svg/currency-cny-light))
(def currency-cny-thin (icon-component svg/currency-cny-thin))
(def currency-cny-fill (icon-component svg/currency-cny-fill))
(def currency-cny-duotone (icon-component svg/currency-cny-duotone))
(def currency-dollar-bold (icon-component svg/currency-dollar-bold))
(def currency-dollar (icon-component svg/currency-dollar-regular))
(def currency-dollar-light (icon-component svg/currency-dollar-light))
(def currency-dollar-thin (icon-component svg/currency-dollar-thin))
(def currency-dollar-fill (icon-component svg/currency-dollar-fill))
(def currency-dollar-duotone (icon-component svg/currency-dollar-duotone))
(def currency-dollar-simple-bold (icon-component svg/currency-dollar-simple-bold))
(def currency-dollar-simple (icon-component svg/currency-dollar-simple-regular))
(def currency-dollar-simple-light (icon-component svg/currency-dollar-simple-light))
(def currency-dollar-simple-thin (icon-component svg/currency-dollar-simple-thin))
(def currency-dollar-simple-fill (icon-component svg/currency-dollar-simple-fill))
(def currency-dollar-simple-duotone (icon-component svg/currency-dollar-simple-duotone))
(def currency-eth-bold (icon-component svg/currency-eth-bold))
(def currency-eth (icon-component svg/currency-eth-regular))
(def currency-eth-light (icon-component svg/currency-eth-light))
(def currency-eth-thin (icon-component svg/currency-eth-thin))
(def currency-eth-fill (icon-component svg/currency-eth-fill))
(def currency-eth-duotone (icon-component svg/currency-eth-duotone))
(def currency-eur-bold (icon-component svg/currency-eur-bold))
(def currency-eur (icon-component svg/currency-eur-regular))
(def currency-eur-light (icon-component svg/currency-eur-light))
(def currency-eur-thin (icon-component svg/currency-eur-thin))
(def currency-eur-fill (icon-component svg/currency-eur-fill))
(def currency-eur-duotone (icon-component svg/currency-eur-duotone))
(def currency-gbp-bold (icon-component svg/currency-gbp-bold))
(def currency-gbp (icon-component svg/currency-gbp-regular))
(def currency-gbp-light (icon-component svg/currency-gbp-light))
(def currency-gbp-thin (icon-component svg/currency-gbp-thin))
(def currency-gbp-fill (icon-component svg/currency-gbp-fill))
(def currency-gbp-duotone (icon-component svg/currency-gbp-duotone))
(def currency-inr-bold (icon-component svg/currency-inr-bold))
(def currency-inr (icon-component svg/currency-inr-regular))
(def currency-inr-light (icon-component svg/currency-inr-light))
(def currency-inr-thin (icon-component svg/currency-inr-thin))
(def currency-inr-fill (icon-component svg/currency-inr-fill))
(def currency-inr-duotone (icon-component svg/currency-inr-duotone))
(def currency-jpy-bold (icon-component svg/currency-jpy-bold))
(def currency-jpy (icon-component svg/currency-jpy-regular))
(def currency-jpy-light (icon-component svg/currency-jpy-light))
(def currency-jpy-thin (icon-component svg/currency-jpy-thin))
(def currency-jpy-fill (icon-component svg/currency-jpy-fill))
(def currency-jpy-duotone (icon-component svg/currency-jpy-duotone))
(def currency-krw-bold (icon-component svg/currency-krw-bold))
(def currency-krw (icon-component svg/currency-krw-regular))
(def currency-krw-light (icon-component svg/currency-krw-light))
(def currency-krw-thin (icon-component svg/currency-krw-thin))
(def currency-krw-fill (icon-component svg/currency-krw-fill))
(def currency-krw-duotone (icon-component svg/currency-krw-duotone))
(def currency-kzt-bold (icon-component svg/currency-kzt-bold))
(def currency-kzt (icon-component svg/currency-kzt-regular))
(def currency-kzt-light (icon-component svg/currency-kzt-light))
(def currency-kzt-thin (icon-component svg/currency-kzt-thin))
(def currency-kzt-fill (icon-component svg/currency-kzt-fill))
(def currency-kzt-duotone (icon-component svg/currency-kzt-duotone))
(def currency-ngn-bold (icon-component svg/currency-ngn-bold))
(def currency-ngn (icon-component svg/currency-ngn-regular))
(def currency-ngn-light (icon-component svg/currency-ngn-light))
(def currency-ngn-thin (icon-component svg/currency-ngn-thin))
(def currency-ngn-fill (icon-component svg/currency-ngn-fill))
(def currency-ngn-duotone (icon-component svg/currency-ngn-duotone))
(def currency-rub-bold (icon-component svg/currency-rub-bold))
(def currency-rub (icon-component svg/currency-rub-regular))
(def currency-rub-light (icon-component svg/currency-rub-light))
(def currency-rub-thin (icon-component svg/currency-rub-thin))
(def currency-rub-fill (icon-component svg/currency-rub-fill))
(def currency-rub-duotone (icon-component svg/currency-rub-duotone))
(def cursor-bold (icon-component svg/cursor-bold))
(def cursor (icon-component svg/cursor-regular))
(def cursor-light (icon-component svg/cursor-light))
(def cursor-thin (icon-component svg/cursor-thin))
(def cursor-fill (icon-component svg/cursor-fill))
(def cursor-duotone (icon-component svg/cursor-duotone))
(def cursor-click-bold (icon-component svg/cursor-click-bold))
(def cursor-click (icon-component svg/cursor-click-regular))
(def cursor-click-light (icon-component svg/cursor-click-light))
(def cursor-click-thin (icon-component svg/cursor-click-thin))
(def cursor-click-fill (icon-component svg/cursor-click-fill))
(def cursor-click-duotone (icon-component svg/cursor-click-duotone))
(def cursor-text-bold (icon-component svg/cursor-text-bold))
(def cursor-text (icon-component svg/cursor-text-regular))
(def cursor-text-light (icon-component svg/cursor-text-light))
(def cursor-text-thin (icon-component svg/cursor-text-thin))
(def cursor-text-fill (icon-component svg/cursor-text-fill))
(def cursor-text-duotone (icon-component svg/cursor-text-duotone))
(def cylinder-bold (icon-component svg/cylinder-bold))
(def cylinder (icon-component svg/cylinder-regular))
(def cylinder-light (icon-component svg/cylinder-light))
(def cylinder-thin (icon-component svg/cylinder-thin))
(def cylinder-fill (icon-component svg/cylinder-fill))
(def cylinder-duotone (icon-component svg/cylinder-duotone))
(def database-bold (icon-component svg/database-bold))
(def database (icon-component svg/database-regular))
(def database-light (icon-component svg/database-light))
(def database-thin (icon-component svg/database-thin))
(def database-fill (icon-component svg/database-fill))
(def database-duotone (icon-component svg/database-duotone))
(def desk-bold (icon-component svg/desk-bold))
(def desk (icon-component svg/desk-regular))
(def desk-light (icon-component svg/desk-light))
(def desk-thin (icon-component svg/desk-thin))
(def desk-fill (icon-component svg/desk-fill))
(def desk-duotone (icon-component svg/desk-duotone))
(def desktop-bold (icon-component svg/desktop-bold))
(def desktop (icon-component svg/desktop-regular))
(def desktop-light (icon-component svg/desktop-light))
(def desktop-thin (icon-component svg/desktop-thin))
(def desktop-fill (icon-component svg/desktop-fill))
(def desktop-duotone (icon-component svg/desktop-duotone))
(def desktop-tower-bold (icon-component svg/desktop-tower-bold))
(def desktop-tower (icon-component svg/desktop-tower-regular))
(def desktop-tower-light (icon-component svg/desktop-tower-light))
(def desktop-tower-thin (icon-component svg/desktop-tower-thin))
(def desktop-tower-fill (icon-component svg/desktop-tower-fill))
(def desktop-tower-duotone (icon-component svg/desktop-tower-duotone))
(def detective-bold (icon-component svg/detective-bold))
(def detective (icon-component svg/detective-regular))
(def detective-light (icon-component svg/detective-light))
(def detective-thin (icon-component svg/detective-thin))
(def detective-fill (icon-component svg/detective-fill))
(def detective-duotone (icon-component svg/detective-duotone))
(def dev-to-logo-bold (icon-component svg/dev-to-logo-bold))
(def dev-to-logo (icon-component svg/dev-to-logo-regular))
(def dev-to-logo-light (icon-component svg/dev-to-logo-light))
(def dev-to-logo-thin (icon-component svg/dev-to-logo-thin))
(def dev-to-logo-fill (icon-component svg/dev-to-logo-fill))
(def dev-to-logo-duotone (icon-component svg/dev-to-logo-duotone))
(def device-mobile-bold (icon-component svg/device-mobile-bold))
(def device-mobile (icon-component svg/device-mobile-regular))
(def device-mobile-light (icon-component svg/device-mobile-light))
(def device-mobile-thin (icon-component svg/device-mobile-thin))
(def device-mobile-fill (icon-component svg/device-mobile-fill))
(def device-mobile-duotone (icon-component svg/device-mobile-duotone))
(def device-mobile-camera-bold (icon-component svg/device-mobile-camera-bold))
(def device-mobile-camera (icon-component svg/device-mobile-camera-regular))
(def device-mobile-camera-light (icon-component svg/device-mobile-camera-light))
(def device-mobile-camera-thin (icon-component svg/device-mobile-camera-thin))
(def device-mobile-camera-fill (icon-component svg/device-mobile-camera-fill))
(def device-mobile-camera-duotone (icon-component svg/device-mobile-camera-duotone))
(def device-mobile-slash-bold (icon-component svg/device-mobile-slash-bold))
(def device-mobile-slash (icon-component svg/device-mobile-slash-regular))
(def device-mobile-slash-light (icon-component svg/device-mobile-slash-light))
(def device-mobile-slash-thin (icon-component svg/device-mobile-slash-thin))
(def device-mobile-slash-fill (icon-component svg/device-mobile-slash-fill))
(def device-mobile-slash-duotone (icon-component svg/device-mobile-slash-duotone))
(def device-mobile-speaker-bold (icon-component svg/device-mobile-speaker-bold))
(def device-mobile-speaker (icon-component svg/device-mobile-speaker-regular))
(def device-mobile-speaker-light (icon-component svg/device-mobile-speaker-light))
(def device-mobile-speaker-thin (icon-component svg/device-mobile-speaker-thin))
(def device-mobile-speaker-fill (icon-component svg/device-mobile-speaker-fill))
(def device-mobile-speaker-duotone (icon-component svg/device-mobile-speaker-duotone))
(def device-rotate-bold (icon-component svg/device-rotate-bold))
(def device-rotate (icon-component svg/device-rotate-regular))
(def device-rotate-light (icon-component svg/device-rotate-light))
(def device-rotate-thin (icon-component svg/device-rotate-thin))
(def device-rotate-fill (icon-component svg/device-rotate-fill))
(def device-rotate-duotone (icon-component svg/device-rotate-duotone))
(def device-tablet-bold (icon-component svg/device-tablet-bold))
(def device-tablet (icon-component svg/device-tablet-regular))
(def device-tablet-light (icon-component svg/device-tablet-light))
(def device-tablet-thin (icon-component svg/device-tablet-thin))
(def device-tablet-fill (icon-component svg/device-tablet-fill))
(def device-tablet-duotone (icon-component svg/device-tablet-duotone))
(def device-tablet-camera-bold (icon-component svg/device-tablet-camera-bold))
(def device-tablet-camera (icon-component svg/device-tablet-camera-regular))
(def device-tablet-camera-light (icon-component svg/device-tablet-camera-light))
(def device-tablet-camera-thin (icon-component svg/device-tablet-camera-thin))
(def device-tablet-camera-fill (icon-component svg/device-tablet-camera-fill))
(def device-tablet-camera-duotone (icon-component svg/device-tablet-camera-duotone))
(def device-tablet-speaker-bold (icon-component svg/device-tablet-speaker-bold))
(def device-tablet-speaker (icon-component svg/device-tablet-speaker-regular))
(def device-tablet-speaker-light (icon-component svg/device-tablet-speaker-light))
(def device-tablet-speaker-thin (icon-component svg/device-tablet-speaker-thin))
(def device-tablet-speaker-fill (icon-component svg/device-tablet-speaker-fill))
(def device-tablet-speaker-duotone (icon-component svg/device-tablet-speaker-duotone))
(def devices-bold (icon-component svg/devices-bold))
(def devices (icon-component svg/devices-regular))
(def devices-light (icon-component svg/devices-light))
(def devices-thin (icon-component svg/devices-thin))
(def devices-fill (icon-component svg/devices-fill))
(def devices-duotone (icon-component svg/devices-duotone))
(def diamond-bold (icon-component svg/diamond-bold))
(def diamond (icon-component svg/diamond-regular))
(def diamond-light (icon-component svg/diamond-light))
(def diamond-thin (icon-component svg/diamond-thin))
(def diamond-fill (icon-component svg/diamond-fill))
(def diamond-duotone (icon-component svg/diamond-duotone))
(def diamonds-four-bold (icon-component svg/diamonds-four-bold))
(def diamonds-four (icon-component svg/diamonds-four-regular))
(def diamonds-four-light (icon-component svg/diamonds-four-light))
(def diamonds-four-thin (icon-component svg/diamonds-four-thin))
(def diamonds-four-fill (icon-component svg/diamonds-four-fill))
(def diamonds-four-duotone (icon-component svg/diamonds-four-duotone))
(def dice-five-bold (icon-component svg/dice-five-bold))
(def dice-five (icon-component svg/dice-five-regular))
(def dice-five-light (icon-component svg/dice-five-light))
(def dice-five-thin (icon-component svg/dice-five-thin))
(def dice-five-fill (icon-component svg/dice-five-fill))
(def dice-five-duotone (icon-component svg/dice-five-duotone))
(def dice-four-bold (icon-component svg/dice-four-bold))
(def dice-four (icon-component svg/dice-four-regular))
(def dice-four-light (icon-component svg/dice-four-light))
(def dice-four-thin (icon-component svg/dice-four-thin))
(def dice-four-fill (icon-component svg/dice-four-fill))
(def dice-four-duotone (icon-component svg/dice-four-duotone))
(def dice-one-bold (icon-component svg/dice-one-bold))
(def dice-one (icon-component svg/dice-one-regular))
(def dice-one-light (icon-component svg/dice-one-light))
(def dice-one-thin (icon-component svg/dice-one-thin))
(def dice-one-fill (icon-component svg/dice-one-fill))
(def dice-one-duotone (icon-component svg/dice-one-duotone))
(def dice-six-bold (icon-component svg/dice-six-bold))
(def dice-six (icon-component svg/dice-six-regular))
(def dice-six-light (icon-component svg/dice-six-light))
(def dice-six-thin (icon-component svg/dice-six-thin))
(def dice-six-fill (icon-component svg/dice-six-fill))
(def dice-six-duotone (icon-component svg/dice-six-duotone))
(def dice-three-bold (icon-component svg/dice-three-bold))
(def dice-three (icon-component svg/dice-three-regular))
(def dice-three-light (icon-component svg/dice-three-light))
(def dice-three-thin (icon-component svg/dice-three-thin))
(def dice-three-fill (icon-component svg/dice-three-fill))
(def dice-three-duotone (icon-component svg/dice-three-duotone))
(def dice-two-bold (icon-component svg/dice-two-bold))
(def dice-two (icon-component svg/dice-two-regular))
(def dice-two-light (icon-component svg/dice-two-light))
(def dice-two-thin (icon-component svg/dice-two-thin))
(def dice-two-fill (icon-component svg/dice-two-fill))
(def dice-two-duotone (icon-component svg/dice-two-duotone))
(def disc-bold (icon-component svg/disc-bold))
(def disc (icon-component svg/disc-regular))
(def disc-light (icon-component svg/disc-light))
(def disc-thin (icon-component svg/disc-thin))
(def disc-fill (icon-component svg/disc-fill))
(def disc-duotone (icon-component svg/disc-duotone))
(def disco-ball-bold (icon-component svg/disco-ball-bold))
(def disco-ball (icon-component svg/disco-ball-regular))
(def disco-ball-light (icon-component svg/disco-ball-light))
(def disco-ball-thin (icon-component svg/disco-ball-thin))
(def disco-ball-fill (icon-component svg/disco-ball-fill))
(def disco-ball-duotone (icon-component svg/disco-ball-duotone))
(def discord-logo-bold (icon-component svg/discord-logo-bold))
(def discord-logo (icon-component svg/discord-logo-regular))
(def discord-logo-light (icon-component svg/discord-logo-light))
(def discord-logo-thin (icon-component svg/discord-logo-thin))
(def discord-logo-fill (icon-component svg/discord-logo-fill))
(def discord-logo-duotone (icon-component svg/discord-logo-duotone))
(def divide-bold (icon-component svg/divide-bold))
(def divide (icon-component svg/divide-regular))
(def divide-light (icon-component svg/divide-light))
(def divide-thin (icon-component svg/divide-thin))
(def divide-fill (icon-component svg/divide-fill))
(def divide-duotone (icon-component svg/divide-duotone))
(def dna-bold (icon-component svg/dna-bold))
(def dna (icon-component svg/dna-regular))
(def dna-light (icon-component svg/dna-light))
(def dna-thin (icon-component svg/dna-thin))
(def dna-fill (icon-component svg/dna-fill))
(def dna-duotone (icon-component svg/dna-duotone))
(def dog-bold (icon-component svg/dog-bold))
(def dog (icon-component svg/dog-regular))
(def dog-light (icon-component svg/dog-light))
(def dog-thin (icon-component svg/dog-thin))
(def dog-fill (icon-component svg/dog-fill))
(def dog-duotone (icon-component svg/dog-duotone))
(def door-bold (icon-component svg/door-bold))
(def door (icon-component svg/door-regular))
(def door-light (icon-component svg/door-light))
(def door-thin (icon-component svg/door-thin))
(def door-fill (icon-component svg/door-fill))
(def door-duotone (icon-component svg/door-duotone))
(def door-open-bold (icon-component svg/door-open-bold))
(def door-open (icon-component svg/door-open-regular))
(def door-open-light (icon-component svg/door-open-light))
(def door-open-thin (icon-component svg/door-open-thin))
(def door-open-fill (icon-component svg/door-open-fill))
(def door-open-duotone (icon-component svg/door-open-duotone))
(def dot-bold (icon-component svg/dot-bold))
(def dot (icon-component svg/dot-regular))
(def dot-light (icon-component svg/dot-light))
(def dot-thin (icon-component svg/dot-thin))
(def dot-fill (icon-component svg/dot-fill))
(def dot-duotone (icon-component svg/dot-duotone))
(def dot-outline-bold (icon-component svg/dot-outline-bold))
(def dot-outline (icon-component svg/dot-outline-regular))
(def dot-outline-light (icon-component svg/dot-outline-light))
(def dot-outline-thin (icon-component svg/dot-outline-thin))
(def dot-outline-fill (icon-component svg/dot-outline-fill))
(def dot-outline-duotone (icon-component svg/dot-outline-duotone))
(def dots-nine-bold (icon-component svg/dots-nine-bold))
(def dots-nine (icon-component svg/dots-nine-regular))
(def dots-nine-light (icon-component svg/dots-nine-light))
(def dots-nine-thin (icon-component svg/dots-nine-thin))
(def dots-nine-fill (icon-component svg/dots-nine-fill))
(def dots-nine-duotone (icon-component svg/dots-nine-duotone))
(def dots-six-bold (icon-component svg/dots-six-bold))
(def dots-six (icon-component svg/dots-six-regular))
(def dots-six-light (icon-component svg/dots-six-light))
(def dots-six-thin (icon-component svg/dots-six-thin))
(def dots-six-fill (icon-component svg/dots-six-fill))
(def dots-six-duotone (icon-component svg/dots-six-duotone))
(def dots-six-vertical-bold (icon-component svg/dots-six-vertical-bold))
(def dots-six-vertical (icon-component svg/dots-six-vertical-regular))
(def dots-six-vertical-light (icon-component svg/dots-six-vertical-light))
(def dots-six-vertical-thin (icon-component svg/dots-six-vertical-thin))
(def dots-six-vertical-fill (icon-component svg/dots-six-vertical-fill))
(def dots-six-vertical-duotone (icon-component svg/dots-six-vertical-duotone))
(def dots-three-bold (icon-component svg/dots-three-bold))
(def dots-three (icon-component svg/dots-three-regular))
(def dots-three-light (icon-component svg/dots-three-light))
(def dots-three-thin (icon-component svg/dots-three-thin))
(def dots-three-fill (icon-component svg/dots-three-fill))
(def dots-three-duotone (icon-component svg/dots-three-duotone))
(def dots-three-circle-bold (icon-component svg/dots-three-circle-bold))
(def dots-three-circle (icon-component svg/dots-three-circle-regular))
(def dots-three-circle-light (icon-component svg/dots-three-circle-light))
(def dots-three-circle-thin (icon-component svg/dots-three-circle-thin))
(def dots-three-circle-fill (icon-component svg/dots-three-circle-fill))
(def dots-three-circle-duotone (icon-component svg/dots-three-circle-duotone))
(def dots-three-circle-vertical-bold (icon-component svg/dots-three-circle-vertical-bold))
(def dots-three-circle-vertical (icon-component svg/dots-three-circle-vertical-regular))
(def dots-three-circle-vertical-light (icon-component svg/dots-three-circle-vertical-light))
(def dots-three-circle-vertical-thin (icon-component svg/dots-three-circle-vertical-thin))
(def dots-three-circle-vertical-fill (icon-component svg/dots-three-circle-vertical-fill))
(def dots-three-circle-vertical-duotone (icon-component svg/dots-three-circle-vertical-duotone))
(def dots-three-outline-bold (icon-component svg/dots-three-outline-bold))
(def dots-three-outline (icon-component svg/dots-three-outline-regular))
(def dots-three-outline-light (icon-component svg/dots-three-outline-light))
(def dots-three-outline-thin (icon-component svg/dots-three-outline-thin))
(def dots-three-outline-fill (icon-component svg/dots-three-outline-fill))
(def dots-three-outline-duotone (icon-component svg/dots-three-outline-duotone))
(def dots-three-outline-vertical-bold (icon-component svg/dots-three-outline-vertical-bold))
(def dots-three-outline-vertical (icon-component svg/dots-three-outline-vertical-regular))
(def dots-three-outline-vertical-light (icon-component svg/dots-three-outline-vertical-light))
(def dots-three-outline-vertical-thin (icon-component svg/dots-three-outline-vertical-thin))
(def dots-three-outline-vertical-fill (icon-component svg/dots-three-outline-vertical-fill))
(def dots-three-outline-vertical-duotone (icon-component svg/dots-three-outline-vertical-duotone))
(def dots-three-vertical-bold (icon-component svg/dots-three-vertical-bold))
(def dots-three-vertical (icon-component svg/dots-three-vertical-regular))
(def dots-three-vertical-light (icon-component svg/dots-three-vertical-light))
(def dots-three-vertical-thin (icon-component svg/dots-three-vertical-thin))
(def dots-three-vertical-fill (icon-component svg/dots-three-vertical-fill))
(def dots-three-vertical-duotone (icon-component svg/dots-three-vertical-duotone))
(def download-bold (icon-component svg/download-bold))
(def download (icon-component svg/download-regular))
(def download-light (icon-component svg/download-light))
(def download-thin (icon-component svg/download-thin))
(def download-fill (icon-component svg/download-fill))
(def download-duotone (icon-component svg/download-duotone))
(def download-simple-bold (icon-component svg/download-simple-bold))
(def download-simple (icon-component svg/download-simple-regular))
(def download-simple-light (icon-component svg/download-simple-light))
(def download-simple-thin (icon-component svg/download-simple-thin))
(def download-simple-fill (icon-component svg/download-simple-fill))
(def download-simple-duotone (icon-component svg/download-simple-duotone))
(def dress-bold (icon-component svg/dress-bold))
(def dress (icon-component svg/dress-regular))
(def dress-light (icon-component svg/dress-light))
(def dress-thin (icon-component svg/dress-thin))
(def dress-fill (icon-component svg/dress-fill))
(def dress-duotone (icon-component svg/dress-duotone))
(def dresser-bold (icon-component svg/dresser-bold))
(def dresser (icon-component svg/dresser-regular))
(def dresser-light (icon-component svg/dresser-light))
(def dresser-thin (icon-component svg/dresser-thin))
(def dresser-fill (icon-component svg/dresser-fill))
(def dresser-duotone (icon-component svg/dresser-duotone))
(def dribbble-logo-bold (icon-component svg/dribbble-logo-bold))
(def dribbble-logo (icon-component svg/dribbble-logo-regular))
(def dribbble-logo-light (icon-component svg/dribbble-logo-light))
(def dribbble-logo-thin (icon-component svg/dribbble-logo-thin))
(def dribbble-logo-fill (icon-component svg/dribbble-logo-fill))
(def dribbble-logo-duotone (icon-component svg/dribbble-logo-duotone))
(def drone-bold (icon-component svg/drone-bold))
(def drone (icon-component svg/drone-regular))
(def drone-light (icon-component svg/drone-light))
(def drone-thin (icon-component svg/drone-thin))
(def drone-fill (icon-component svg/drone-fill))
(def drone-duotone (icon-component svg/drone-duotone))
(def drop-bold (icon-component svg/drop-bold))
(def drop (icon-component svg/drop-regular))
(def drop-light (icon-component svg/drop-light))
(def drop-thin (icon-component svg/drop-thin))
(def drop-fill (icon-component svg/drop-fill))
(def drop-duotone (icon-component svg/drop-duotone))
(def drop-half-bold (icon-component svg/drop-half-bold))
(def drop-half (icon-component svg/drop-half-regular))
(def drop-half-light (icon-component svg/drop-half-light))
(def drop-half-thin (icon-component svg/drop-half-thin))
(def drop-half-fill (icon-component svg/drop-half-fill))
(def drop-half-duotone (icon-component svg/drop-half-duotone))
(def drop-half-bottom-bold (icon-component svg/drop-half-bottom-bold))
(def drop-half-bottom (icon-component svg/drop-half-bottom-regular))
(def drop-half-bottom-light (icon-component svg/drop-half-bottom-light))
(def drop-half-bottom-thin (icon-component svg/drop-half-bottom-thin))
(def drop-half-bottom-fill (icon-component svg/drop-half-bottom-fill))
(def drop-half-bottom-duotone (icon-component svg/drop-half-bottom-duotone))
(def drop-simple-bold (icon-component svg/drop-simple-bold))
(def drop-simple (icon-component svg/drop-simple-regular))
(def drop-simple-light (icon-component svg/drop-simple-light))
(def drop-simple-thin (icon-component svg/drop-simple-thin))
(def drop-simple-fill (icon-component svg/drop-simple-fill))
(def drop-simple-duotone (icon-component svg/drop-simple-duotone))
(def drop-slash-bold (icon-component svg/drop-slash-bold))
(def drop-slash (icon-component svg/drop-slash-regular))
(def drop-slash-light (icon-component svg/drop-slash-light))
(def drop-slash-thin (icon-component svg/drop-slash-thin))
(def drop-slash-fill (icon-component svg/drop-slash-fill))
(def drop-slash-duotone (icon-component svg/drop-slash-duotone))
(def dropbox-logo-bold (icon-component svg/dropbox-logo-bold))
(def dropbox-logo (icon-component svg/dropbox-logo-regular))
(def dropbox-logo-light (icon-component svg/dropbox-logo-light))
(def dropbox-logo-thin (icon-component svg/dropbox-logo-thin))
(def dropbox-logo-fill (icon-component svg/dropbox-logo-fill))
(def dropbox-logo-duotone (icon-component svg/dropbox-logo-duotone))
(def ear-bold (icon-component svg/ear-bold))
(def ear (icon-component svg/ear-regular))
(def ear-light (icon-component svg/ear-light))
(def ear-thin (icon-component svg/ear-thin))
(def ear-fill (icon-component svg/ear-fill))
(def ear-duotone (icon-component svg/ear-duotone))
(def ear-slash-bold (icon-component svg/ear-slash-bold))
(def ear-slash (icon-component svg/ear-slash-regular))
(def ear-slash-light (icon-component svg/ear-slash-light))
(def ear-slash-thin (icon-component svg/ear-slash-thin))
(def ear-slash-fill (icon-component svg/ear-slash-fill))
(def ear-slash-duotone (icon-component svg/ear-slash-duotone))
(def egg-bold (icon-component svg/egg-bold))
(def egg (icon-component svg/egg-regular))
(def egg-light (icon-component svg/egg-light))
(def egg-thin (icon-component svg/egg-thin))
(def egg-fill (icon-component svg/egg-fill))
(def egg-duotone (icon-component svg/egg-duotone))
(def egg-crack-bold (icon-component svg/egg-crack-bold))
(def egg-crack (icon-component svg/egg-crack-regular))
(def egg-crack-light (icon-component svg/egg-crack-light))
(def egg-crack-thin (icon-component svg/egg-crack-thin))
(def egg-crack-fill (icon-component svg/egg-crack-fill))
(def egg-crack-duotone (icon-component svg/egg-crack-duotone))
(def eject-bold (icon-component svg/eject-bold))
(def eject (icon-component svg/eject-regular))
(def eject-light (icon-component svg/eject-light))
(def eject-thin (icon-component svg/eject-thin))
(def eject-fill (icon-component svg/eject-fill))
(def eject-duotone (icon-component svg/eject-duotone))
(def eject-simple-bold (icon-component svg/eject-simple-bold))
(def eject-simple (icon-component svg/eject-simple-regular))
(def eject-simple-light (icon-component svg/eject-simple-light))
(def eject-simple-thin (icon-component svg/eject-simple-thin))
(def eject-simple-fill (icon-component svg/eject-simple-fill))
(def eject-simple-duotone (icon-component svg/eject-simple-duotone))
(def elevator-bold (icon-component svg/elevator-bold))
(def elevator (icon-component svg/elevator-regular))
(def elevator-light (icon-component svg/elevator-light))
(def elevator-thin (icon-component svg/elevator-thin))
(def elevator-fill (icon-component svg/elevator-fill))
(def elevator-duotone (icon-component svg/elevator-duotone))
(def empty-bold (icon-component svg/empty-bold))
(def empty (icon-component svg/empty-regular))
(def empty-light (icon-component svg/empty-light))
(def empty-thin (icon-component svg/empty-thin))
(def empty-fill (icon-component svg/empty-fill))
(def empty-duotone (icon-component svg/empty-duotone))
(def engine-bold (icon-component svg/engine-bold))
(def engine (icon-component svg/engine-regular))
(def engine-light (icon-component svg/engine-light))
(def engine-thin (icon-component svg/engine-thin))
(def engine-fill (icon-component svg/engine-fill))
(def engine-duotone (icon-component svg/engine-duotone))
(def envelope-bold (icon-component svg/envelope-bold))
(def envelope (icon-component svg/envelope-regular))
(def envelope-light (icon-component svg/envelope-light))
(def envelope-thin (icon-component svg/envelope-thin))
(def envelope-fill (icon-component svg/envelope-fill))
(def envelope-duotone (icon-component svg/envelope-duotone))
(def envelope-open-bold (icon-component svg/envelope-open-bold))
(def envelope-open (icon-component svg/envelope-open-regular))
(def envelope-open-light (icon-component svg/envelope-open-light))
(def envelope-open-thin (icon-component svg/envelope-open-thin))
(def envelope-open-fill (icon-component svg/envelope-open-fill))
(def envelope-open-duotone (icon-component svg/envelope-open-duotone))
(def envelope-simple-bold (icon-component svg/envelope-simple-bold))
(def envelope-simple (icon-component svg/envelope-simple-regular))
(def envelope-simple-light (icon-component svg/envelope-simple-light))
(def envelope-simple-thin (icon-component svg/envelope-simple-thin))
(def envelope-simple-fill (icon-component svg/envelope-simple-fill))
(def envelope-simple-duotone (icon-component svg/envelope-simple-duotone))
(def envelope-simple-open-bold (icon-component svg/envelope-simple-open-bold))
(def envelope-simple-open (icon-component svg/envelope-simple-open-regular))
(def envelope-simple-open-light (icon-component svg/envelope-simple-open-light))
(def envelope-simple-open-thin (icon-component svg/envelope-simple-open-thin))
(def envelope-simple-open-fill (icon-component svg/envelope-simple-open-fill))
(def envelope-simple-open-duotone (icon-component svg/envelope-simple-open-duotone))
(def equalizer-bold (icon-component svg/equalizer-bold))
(def equalizer (icon-component svg/equalizer-regular))
(def equalizer-light (icon-component svg/equalizer-light))
(def equalizer-thin (icon-component svg/equalizer-thin))
(def equalizer-fill (icon-component svg/equalizer-fill))
(def equalizer-duotone (icon-component svg/equalizer-duotone))
(def equals-bold (icon-component svg/equals-bold))
(def equals (icon-component svg/equals-regular))
(def equals-light (icon-component svg/equals-light))
(def equals-thin (icon-component svg/equals-thin))
(def equals-fill (icon-component svg/equals-fill))
(def equals-duotone (icon-component svg/equals-duotone))
(def eraser-bold (icon-component svg/eraser-bold))
(def eraser (icon-component svg/eraser-regular))
(def eraser-light (icon-component svg/eraser-light))
(def eraser-thin (icon-component svg/eraser-thin))
(def eraser-fill (icon-component svg/eraser-fill))
(def eraser-duotone (icon-component svg/eraser-duotone))
(def escalator-down-bold (icon-component svg/escalator-down-bold))
(def escalator-down (icon-component svg/escalator-down-regular))
(def escalator-down-light (icon-component svg/escalator-down-light))
(def escalator-down-thin (icon-component svg/escalator-down-thin))
(def escalator-down-fill (icon-component svg/escalator-down-fill))
(def escalator-down-duotone (icon-component svg/escalator-down-duotone))
(def escalator-up-bold (icon-component svg/escalator-up-bold))
(def escalator-up (icon-component svg/escalator-up-regular))
(def escalator-up-light (icon-component svg/escalator-up-light))
(def escalator-up-thin (icon-component svg/escalator-up-thin))
(def escalator-up-fill (icon-component svg/escalator-up-fill))
(def escalator-up-duotone (icon-component svg/escalator-up-duotone))
(def exam-bold (icon-component svg/exam-bold))
(def exam (icon-component svg/exam-regular))
(def exam-light (icon-component svg/exam-light))
(def exam-thin (icon-component svg/exam-thin))
(def exam-fill (icon-component svg/exam-fill))
(def exam-duotone (icon-component svg/exam-duotone))
(def exclamation-mark-bold (icon-component svg/exclamation-mark-bold))
(def exclamation-mark (icon-component svg/exclamation-mark-regular))
(def exclamation-mark-light (icon-component svg/exclamation-mark-light))
(def exclamation-mark-thin (icon-component svg/exclamation-mark-thin))
(def exclamation-mark-fill (icon-component svg/exclamation-mark-fill))
(def exclamation-mark-duotone (icon-component svg/exclamation-mark-duotone))
(def exclude-bold (icon-component svg/exclude-bold))
(def exclude (icon-component svg/exclude-regular))
(def exclude-light (icon-component svg/exclude-light))
(def exclude-thin (icon-component svg/exclude-thin))
(def exclude-fill (icon-component svg/exclude-fill))
(def exclude-duotone (icon-component svg/exclude-duotone))
(def exclude-square-bold (icon-component svg/exclude-square-bold))
(def exclude-square (icon-component svg/exclude-square-regular))
(def exclude-square-light (icon-component svg/exclude-square-light))
(def exclude-square-thin (icon-component svg/exclude-square-thin))
(def exclude-square-fill (icon-component svg/exclude-square-fill))
(def exclude-square-duotone (icon-component svg/exclude-square-duotone))
(def export-bold (icon-component svg/export-bold))
(def export (icon-component svg/export-regular))
(def export-light (icon-component svg/export-light))
(def export-thin (icon-component svg/export-thin))
(def export-fill (icon-component svg/export-fill))
(def export-duotone (icon-component svg/export-duotone))
(def eye-bold (icon-component svg/eye-bold))
(def eye (icon-component svg/eye-regular))
(def eye-light (icon-component svg/eye-light))
(def eye-thin (icon-component svg/eye-thin))
(def eye-fill (icon-component svg/eye-fill))
(def eye-duotone (icon-component svg/eye-duotone))
(def eye-closed-bold (icon-component svg/eye-closed-bold))
(def eye-closed (icon-component svg/eye-closed-regular))
(def eye-closed-light (icon-component svg/eye-closed-light))
(def eye-closed-thin (icon-component svg/eye-closed-thin))
(def eye-closed-fill (icon-component svg/eye-closed-fill))
(def eye-closed-duotone (icon-component svg/eye-closed-duotone))
(def eye-slash-bold (icon-component svg/eye-slash-bold))
(def eye-slash (icon-component svg/eye-slash-regular))
(def eye-slash-light (icon-component svg/eye-slash-light))
(def eye-slash-thin (icon-component svg/eye-slash-thin))
(def eye-slash-fill (icon-component svg/eye-slash-fill))
(def eye-slash-duotone (icon-component svg/eye-slash-duotone))
(def eyedropper-bold (icon-component svg/eyedropper-bold))
(def eyedropper (icon-component svg/eyedropper-regular))
(def eyedropper-light (icon-component svg/eyedropper-light))
(def eyedropper-thin (icon-component svg/eyedropper-thin))
(def eyedropper-fill (icon-component svg/eyedropper-fill))
(def eyedropper-duotone (icon-component svg/eyedropper-duotone))
(def eyedropper-sample-bold (icon-component svg/eyedropper-sample-bold))
(def eyedropper-sample (icon-component svg/eyedropper-sample-regular))
(def eyedropper-sample-light (icon-component svg/eyedropper-sample-light))
(def eyedropper-sample-thin (icon-component svg/eyedropper-sample-thin))
(def eyedropper-sample-fill (icon-component svg/eyedropper-sample-fill))
(def eyedropper-sample-duotone (icon-component svg/eyedropper-sample-duotone))
(def eyeglasses-bold (icon-component svg/eyeglasses-bold))
(def eyeglasses (icon-component svg/eyeglasses-regular))
(def eyeglasses-light (icon-component svg/eyeglasses-light))
(def eyeglasses-thin (icon-component svg/eyeglasses-thin))
(def eyeglasses-fill (icon-component svg/eyeglasses-fill))
(def eyeglasses-duotone (icon-component svg/eyeglasses-duotone))
(def eyes-bold (icon-component svg/eyes-bold))
(def eyes (icon-component svg/eyes-regular))
(def eyes-light (icon-component svg/eyes-light))
(def eyes-thin (icon-component svg/eyes-thin))
(def eyes-fill (icon-component svg/eyes-fill))
(def eyes-duotone (icon-component svg/eyes-duotone))
(def face-mask-bold (icon-component svg/face-mask-bold))
(def face-mask (icon-component svg/face-mask-regular))
(def face-mask-light (icon-component svg/face-mask-light))
(def face-mask-thin (icon-component svg/face-mask-thin))
(def face-mask-fill (icon-component svg/face-mask-fill))
(def face-mask-duotone (icon-component svg/face-mask-duotone))
(def facebook-logo-bold (icon-component svg/facebook-logo-bold))
(def facebook-logo (icon-component svg/facebook-logo-regular))
(def facebook-logo-light (icon-component svg/facebook-logo-light))
(def facebook-logo-thin (icon-component svg/facebook-logo-thin))
(def facebook-logo-fill (icon-component svg/facebook-logo-fill))
(def facebook-logo-duotone (icon-component svg/facebook-logo-duotone))
(def factory-bold (icon-component svg/factory-bold))
(def factory (icon-component svg/factory-regular))
(def factory-light (icon-component svg/factory-light))
(def factory-thin (icon-component svg/factory-thin))
(def factory-fill (icon-component svg/factory-fill))
(def factory-duotone (icon-component svg/factory-duotone))
(def faders-bold (icon-component svg/faders-bold))
(def faders (icon-component svg/faders-regular))
(def faders-light (icon-component svg/faders-light))
(def faders-thin (icon-component svg/faders-thin))
(def faders-fill (icon-component svg/faders-fill))
(def faders-duotone (icon-component svg/faders-duotone))
(def faders-horizontal-bold (icon-component svg/faders-horizontal-bold))
(def faders-horizontal (icon-component svg/faders-horizontal-regular))
(def faders-horizontal-light (icon-component svg/faders-horizontal-light))
(def faders-horizontal-thin (icon-component svg/faders-horizontal-thin))
(def faders-horizontal-fill (icon-component svg/faders-horizontal-fill))
(def faders-horizontal-duotone (icon-component svg/faders-horizontal-duotone))
(def fallout-shelter-bold (icon-component svg/fallout-shelter-bold))
(def fallout-shelter (icon-component svg/fallout-shelter-regular))
(def fallout-shelter-light (icon-component svg/fallout-shelter-light))
(def fallout-shelter-thin (icon-component svg/fallout-shelter-thin))
(def fallout-shelter-fill (icon-component svg/fallout-shelter-fill))
(def fallout-shelter-duotone (icon-component svg/fallout-shelter-duotone))
(def fan-bold (icon-component svg/fan-bold))
(def fan (icon-component svg/fan-regular))
(def fan-light (icon-component svg/fan-light))
(def fan-thin (icon-component svg/fan-thin))
(def fan-fill (icon-component svg/fan-fill))
(def fan-duotone (icon-component svg/fan-duotone))
(def farm-bold (icon-component svg/farm-bold))
(def farm (icon-component svg/farm-regular))
(def farm-light (icon-component svg/farm-light))
(def farm-thin (icon-component svg/farm-thin))
(def farm-fill (icon-component svg/farm-fill))
(def farm-duotone (icon-component svg/farm-duotone))
(def fast-forward-bold (icon-component svg/fast-forward-bold))
(def fast-forward (icon-component svg/fast-forward-regular))
(def fast-forward-light (icon-component svg/fast-forward-light))
(def fast-forward-thin (icon-component svg/fast-forward-thin))
(def fast-forward-fill (icon-component svg/fast-forward-fill))
(def fast-forward-duotone (icon-component svg/fast-forward-duotone))
(def fast-forward-circle-bold (icon-component svg/fast-forward-circle-bold))
(def fast-forward-circle (icon-component svg/fast-forward-circle-regular))
(def fast-forward-circle-light (icon-component svg/fast-forward-circle-light))
(def fast-forward-circle-thin (icon-component svg/fast-forward-circle-thin))
(def fast-forward-circle-fill (icon-component svg/fast-forward-circle-fill))
(def fast-forward-circle-duotone (icon-component svg/fast-forward-circle-duotone))
(def feather-bold (icon-component svg/feather-bold))
(def feather (icon-component svg/feather-regular))
(def feather-light (icon-component svg/feather-light))
(def feather-thin (icon-component svg/feather-thin))
(def feather-fill (icon-component svg/feather-fill))
(def feather-duotone (icon-component svg/feather-duotone))
(def fediverse-logo-bold (icon-component svg/fediverse-logo-bold))
(def fediverse-logo (icon-component svg/fediverse-logo-regular))
(def fediverse-logo-light (icon-component svg/fediverse-logo-light))
(def fediverse-logo-thin (icon-component svg/fediverse-logo-thin))
(def fediverse-logo-fill (icon-component svg/fediverse-logo-fill))
(def fediverse-logo-duotone (icon-component svg/fediverse-logo-duotone))
(def figma-logo-bold (icon-component svg/figma-logo-bold))
(def figma-logo (icon-component svg/figma-logo-regular))
(def figma-logo-light (icon-component svg/figma-logo-light))
(def figma-logo-thin (icon-component svg/figma-logo-thin))
(def figma-logo-fill (icon-component svg/figma-logo-fill))
(def figma-logo-duotone (icon-component svg/figma-logo-duotone))
(def file-bold (icon-component svg/file-bold))
(def file (icon-component svg/file-regular))
(def file-light (icon-component svg/file-light))
(def file-thin (icon-component svg/file-thin))
(def file-fill (icon-component svg/file-fill))
(def file-duotone (icon-component svg/file-duotone))
(def file-archive-bold (icon-component svg/file-archive-bold))
(def file-archive (icon-component svg/file-archive-regular))
(def file-archive-light (icon-component svg/file-archive-light))
(def file-archive-thin (icon-component svg/file-archive-thin))
(def file-archive-fill (icon-component svg/file-archive-fill))
(def file-archive-duotone (icon-component svg/file-archive-duotone))
(def file-arrow-down-bold (icon-component svg/file-arrow-down-bold))
(def file-arrow-down (icon-component svg/file-arrow-down-regular))
(def file-arrow-down-light (icon-component svg/file-arrow-down-light))
(def file-arrow-down-thin (icon-component svg/file-arrow-down-thin))
(def file-arrow-down-fill (icon-component svg/file-arrow-down-fill))
(def file-arrow-down-duotone (icon-component svg/file-arrow-down-duotone))
(def file-arrow-up-bold (icon-component svg/file-arrow-up-bold))
(def file-arrow-up (icon-component svg/file-arrow-up-regular))
(def file-arrow-up-light (icon-component svg/file-arrow-up-light))
(def file-arrow-up-thin (icon-component svg/file-arrow-up-thin))
(def file-arrow-up-fill (icon-component svg/file-arrow-up-fill))
(def file-arrow-up-duotone (icon-component svg/file-arrow-up-duotone))
(def file-audio-bold (icon-component svg/file-audio-bold))
(def file-audio (icon-component svg/file-audio-regular))
(def file-audio-light (icon-component svg/file-audio-light))
(def file-audio-thin (icon-component svg/file-audio-thin))
(def file-audio-fill (icon-component svg/file-audio-fill))
(def file-audio-duotone (icon-component svg/file-audio-duotone))
(def file-c-bold (icon-component svg/file-c-bold))
(def file-c (icon-component svg/file-c-regular))
(def file-c-light (icon-component svg/file-c-light))
(def file-c-thin (icon-component svg/file-c-thin))
(def file-c-fill (icon-component svg/file-c-fill))
(def file-c-duotone (icon-component svg/file-c-duotone))
(def file-c-sharp-bold (icon-component svg/file-c-sharp-bold))
(def file-c-sharp (icon-component svg/file-c-sharp-regular))
(def file-c-sharp-light (icon-component svg/file-c-sharp-light))
(def file-c-sharp-thin (icon-component svg/file-c-sharp-thin))
(def file-c-sharp-fill (icon-component svg/file-c-sharp-fill))
(def file-c-sharp-duotone (icon-component svg/file-c-sharp-duotone))
(def file-cloud-bold (icon-component svg/file-cloud-bold))
(def file-cloud (icon-component svg/file-cloud-regular))
(def file-cloud-light (icon-component svg/file-cloud-light))
(def file-cloud-thin (icon-component svg/file-cloud-thin))
(def file-cloud-fill (icon-component svg/file-cloud-fill))
(def file-cloud-duotone (icon-component svg/file-cloud-duotone))
(def file-code-bold (icon-component svg/file-code-bold))
(def file-code (icon-component svg/file-code-regular))
(def file-code-light (icon-component svg/file-code-light))
(def file-code-thin (icon-component svg/file-code-thin))
(def file-code-fill (icon-component svg/file-code-fill))
(def file-code-duotone (icon-component svg/file-code-duotone))
(def file-cpp-bold (icon-component svg/file-cpp-bold))
(def file-cpp (icon-component svg/file-cpp-regular))
(def file-cpp-light (icon-component svg/file-cpp-light))
(def file-cpp-thin (icon-component svg/file-cpp-thin))
(def file-cpp-fill (icon-component svg/file-cpp-fill))
(def file-cpp-duotone (icon-component svg/file-cpp-duotone))
(def file-css-bold (icon-component svg/file-css-bold))
(def file-css (icon-component svg/file-css-regular))
(def file-css-light (icon-component svg/file-css-light))
(def file-css-thin (icon-component svg/file-css-thin))
(def file-css-fill (icon-component svg/file-css-fill))
(def file-css-duotone (icon-component svg/file-css-duotone))
(def file-csv-bold (icon-component svg/file-csv-bold))
(def file-csv (icon-component svg/file-csv-regular))
(def file-csv-light (icon-component svg/file-csv-light))
(def file-csv-thin (icon-component svg/file-csv-thin))
(def file-csv-fill (icon-component svg/file-csv-fill))
(def file-csv-duotone (icon-component svg/file-csv-duotone))
(def file-dashed-bold (icon-component svg/file-dashed-bold))
(def file-dashed (icon-component svg/file-dashed-regular))
(def file-dashed-light (icon-component svg/file-dashed-light))
(def file-dashed-thin (icon-component svg/file-dashed-thin))
(def file-dashed-fill (icon-component svg/file-dashed-fill))
(def file-dashed-duotone (icon-component svg/file-dashed-duotone))
(def file-doc-bold (icon-component svg/file-doc-bold))
(def file-doc (icon-component svg/file-doc-regular))
(def file-doc-light (icon-component svg/file-doc-light))
(def file-doc-thin (icon-component svg/file-doc-thin))
(def file-doc-fill (icon-component svg/file-doc-fill))
(def file-doc-duotone (icon-component svg/file-doc-duotone))
(def file-html-bold (icon-component svg/file-html-bold))
(def file-html (icon-component svg/file-html-regular))
(def file-html-light (icon-component svg/file-html-light))
(def file-html-thin (icon-component svg/file-html-thin))
(def file-html-fill (icon-component svg/file-html-fill))
(def file-html-duotone (icon-component svg/file-html-duotone))
(def file-image-bold (icon-component svg/file-image-bold))
(def file-image (icon-component svg/file-image-regular))
(def file-image-light (icon-component svg/file-image-light))
(def file-image-thin (icon-component svg/file-image-thin))
(def file-image-fill (icon-component svg/file-image-fill))
(def file-image-duotone (icon-component svg/file-image-duotone))
(def file-ini-bold (icon-component svg/file-ini-bold))
(def file-ini (icon-component svg/file-ini-regular))
(def file-ini-light (icon-component svg/file-ini-light))
(def file-ini-thin (icon-component svg/file-ini-thin))
(def file-ini-fill (icon-component svg/file-ini-fill))
(def file-ini-duotone (icon-component svg/file-ini-duotone))
(def file-jpg-bold (icon-component svg/file-jpg-bold))
(def file-jpg (icon-component svg/file-jpg-regular))
(def file-jpg-light (icon-component svg/file-jpg-light))
(def file-jpg-thin (icon-component svg/file-jpg-thin))
(def file-jpg-fill (icon-component svg/file-jpg-fill))
(def file-jpg-duotone (icon-component svg/file-jpg-duotone))
(def file-js-bold (icon-component svg/file-js-bold))
(def file-js (icon-component svg/file-js-regular))
(def file-js-light (icon-component svg/file-js-light))
(def file-js-thin (icon-component svg/file-js-thin))
(def file-js-fill (icon-component svg/file-js-fill))
(def file-js-duotone (icon-component svg/file-js-duotone))
(def file-jsx-bold (icon-component svg/file-jsx-bold))
(def file-jsx (icon-component svg/file-jsx-regular))
(def file-jsx-light (icon-component svg/file-jsx-light))
(def file-jsx-thin (icon-component svg/file-jsx-thin))
(def file-jsx-fill (icon-component svg/file-jsx-fill))
(def file-jsx-duotone (icon-component svg/file-jsx-duotone))
(def file-lock-bold (icon-component svg/file-lock-bold))
(def file-lock (icon-component svg/file-lock-regular))
(def file-lock-light (icon-component svg/file-lock-light))
(def file-lock-thin (icon-component svg/file-lock-thin))
(def file-lock-fill (icon-component svg/file-lock-fill))
(def file-lock-duotone (icon-component svg/file-lock-duotone))
(def file-magnifying-glass-bold (icon-component svg/file-magnifying-glass-bold))
(def file-magnifying-glass (icon-component svg/file-magnifying-glass-regular))
(def file-magnifying-glass-light (icon-component svg/file-magnifying-glass-light))
(def file-magnifying-glass-thin (icon-component svg/file-magnifying-glass-thin))
(def file-magnifying-glass-fill (icon-component svg/file-magnifying-glass-fill))
(def file-magnifying-glass-duotone (icon-component svg/file-magnifying-glass-duotone))
(def file-md-bold (icon-component svg/file-md-bold))
(def file-md (icon-component svg/file-md-regular))
(def file-md-light (icon-component svg/file-md-light))
(def file-md-thin (icon-component svg/file-md-thin))
(def file-md-fill (icon-component svg/file-md-fill))
(def file-md-duotone (icon-component svg/file-md-duotone))
(def file-minus-bold (icon-component svg/file-minus-bold))
(def file-minus (icon-component svg/file-minus-regular))
(def file-minus-light (icon-component svg/file-minus-light))
(def file-minus-thin (icon-component svg/file-minus-thin))
(def file-minus-fill (icon-component svg/file-minus-fill))
(def file-minus-duotone (icon-component svg/file-minus-duotone))
(def file-pdf-bold (icon-component svg/file-pdf-bold))
(def file-pdf (icon-component svg/file-pdf-regular))
(def file-pdf-light (icon-component svg/file-pdf-light))
(def file-pdf-thin (icon-component svg/file-pdf-thin))
(def file-pdf-fill (icon-component svg/file-pdf-fill))
(def file-pdf-duotone (icon-component svg/file-pdf-duotone))
(def file-plus-bold (icon-component svg/file-plus-bold))
(def file-plus (icon-component svg/file-plus-regular))
(def file-plus-light (icon-component svg/file-plus-light))
(def file-plus-thin (icon-component svg/file-plus-thin))
(def file-plus-fill (icon-component svg/file-plus-fill))
(def file-plus-duotone (icon-component svg/file-plus-duotone))
(def file-png-bold (icon-component svg/file-png-bold))
(def file-png (icon-component svg/file-png-regular))
(def file-png-light (icon-component svg/file-png-light))
(def file-png-thin (icon-component svg/file-png-thin))
(def file-png-fill (icon-component svg/file-png-fill))
(def file-png-duotone (icon-component svg/file-png-duotone))
(def file-ppt-bold (icon-component svg/file-ppt-bold))
(def file-ppt (icon-component svg/file-ppt-regular))
(def file-ppt-light (icon-component svg/file-ppt-light))
(def file-ppt-thin (icon-component svg/file-ppt-thin))
(def file-ppt-fill (icon-component svg/file-ppt-fill))
(def file-ppt-duotone (icon-component svg/file-ppt-duotone))
(def file-py-bold (icon-component svg/file-py-bold))
(def file-py (icon-component svg/file-py-regular))
(def file-py-light (icon-component svg/file-py-light))
(def file-py-thin (icon-component svg/file-py-thin))
(def file-py-fill (icon-component svg/file-py-fill))
(def file-py-duotone (icon-component svg/file-py-duotone))
(def file-rs-bold (icon-component svg/file-rs-bold))
(def file-rs (icon-component svg/file-rs-regular))
(def file-rs-light (icon-component svg/file-rs-light))
(def file-rs-thin (icon-component svg/file-rs-thin))
(def file-rs-fill (icon-component svg/file-rs-fill))
(def file-rs-duotone (icon-component svg/file-rs-duotone))
(def file-sql-bold (icon-component svg/file-sql-bold))
(def file-sql (icon-component svg/file-sql-regular))
(def file-sql-light (icon-component svg/file-sql-light))
(def file-sql-thin (icon-component svg/file-sql-thin))
(def file-sql-fill (icon-component svg/file-sql-fill))
(def file-sql-duotone (icon-component svg/file-sql-duotone))
(def file-svg-bold (icon-component svg/file-svg-bold))
(def file-svg (icon-component svg/file-svg-regular))
(def file-svg-light (icon-component svg/file-svg-light))
(def file-svg-thin (icon-component svg/file-svg-thin))
(def file-svg-fill (icon-component svg/file-svg-fill))
(def file-svg-duotone (icon-component svg/file-svg-duotone))
(def file-text-bold (icon-component svg/file-text-bold))
(def file-text (icon-component svg/file-text-regular))
(def file-text-light (icon-component svg/file-text-light))
(def file-text-thin (icon-component svg/file-text-thin))
(def file-text-fill (icon-component svg/file-text-fill))
(def file-text-duotone (icon-component svg/file-text-duotone))
(def file-ts-bold (icon-component svg/file-ts-bold))
(def file-ts (icon-component svg/file-ts-regular))
(def file-ts-light (icon-component svg/file-ts-light))
(def file-ts-thin (icon-component svg/file-ts-thin))
(def file-ts-fill (icon-component svg/file-ts-fill))
(def file-ts-duotone (icon-component svg/file-ts-duotone))
(def file-tsx-bold (icon-component svg/file-tsx-bold))
(def file-tsx (icon-component svg/file-tsx-regular))
(def file-tsx-light (icon-component svg/file-tsx-light))
(def file-tsx-thin (icon-component svg/file-tsx-thin))
(def file-tsx-fill (icon-component svg/file-tsx-fill))
(def file-tsx-duotone (icon-component svg/file-tsx-duotone))
(def file-txt-bold (icon-component svg/file-txt-bold))
(def file-txt (icon-component svg/file-txt-regular))
(def file-txt-light (icon-component svg/file-txt-light))
(def file-txt-thin (icon-component svg/file-txt-thin))
(def file-txt-fill (icon-component svg/file-txt-fill))
(def file-txt-duotone (icon-component svg/file-txt-duotone))
(def file-video-bold (icon-component svg/file-video-bold))
(def file-video (icon-component svg/file-video-regular))
(def file-video-light (icon-component svg/file-video-light))
(def file-video-thin (icon-component svg/file-video-thin))
(def file-video-fill (icon-component svg/file-video-fill))
(def file-video-duotone (icon-component svg/file-video-duotone))
(def file-vue-bold (icon-component svg/file-vue-bold))
(def file-vue (icon-component svg/file-vue-regular))
(def file-vue-light (icon-component svg/file-vue-light))
(def file-vue-thin (icon-component svg/file-vue-thin))
(def file-vue-fill (icon-component svg/file-vue-fill))
(def file-vue-duotone (icon-component svg/file-vue-duotone))
(def file-x-bold (icon-component svg/file-x-bold))
(def file-x (icon-component svg/file-x-regular))
(def file-x-light (icon-component svg/file-x-light))
(def file-x-thin (icon-component svg/file-x-thin))
(def file-x-fill (icon-component svg/file-x-fill))
(def file-x-duotone (icon-component svg/file-x-duotone))
(def file-xls-bold (icon-component svg/file-xls-bold))
(def file-xls (icon-component svg/file-xls-regular))
(def file-xls-light (icon-component svg/file-xls-light))
(def file-xls-thin (icon-component svg/file-xls-thin))
(def file-xls-fill (icon-component svg/file-xls-fill))
(def file-xls-duotone (icon-component svg/file-xls-duotone))
(def file-zip-bold (icon-component svg/file-zip-bold))
(def file-zip (icon-component svg/file-zip-regular))
(def file-zip-light (icon-component svg/file-zip-light))
(def file-zip-thin (icon-component svg/file-zip-thin))
(def file-zip-fill (icon-component svg/file-zip-fill))
(def file-zip-duotone (icon-component svg/file-zip-duotone))
(def files-bold (icon-component svg/files-bold))
(def files (icon-component svg/files-regular))
(def files-light (icon-component svg/files-light))
(def files-thin (icon-component svg/files-thin))
(def files-fill (icon-component svg/files-fill))
(def files-duotone (icon-component svg/files-duotone))
(def film-reel-bold (icon-component svg/film-reel-bold))
(def film-reel (icon-component svg/film-reel-regular))
(def film-reel-light (icon-component svg/film-reel-light))
(def film-reel-thin (icon-component svg/film-reel-thin))
(def film-reel-fill (icon-component svg/film-reel-fill))
(def film-reel-duotone (icon-component svg/film-reel-duotone))
(def film-script-bold (icon-component svg/film-script-bold))
(def film-script (icon-component svg/film-script-regular))
(def film-script-light (icon-component svg/film-script-light))
(def film-script-thin (icon-component svg/film-script-thin))
(def film-script-fill (icon-component svg/film-script-fill))
(def film-script-duotone (icon-component svg/film-script-duotone))
(def film-slate-bold (icon-component svg/film-slate-bold))
(def film-slate (icon-component svg/film-slate-regular))
(def film-slate-light (icon-component svg/film-slate-light))
(def film-slate-thin (icon-component svg/film-slate-thin))
(def film-slate-fill (icon-component svg/film-slate-fill))
(def film-slate-duotone (icon-component svg/film-slate-duotone))
(def film-strip-bold (icon-component svg/film-strip-bold))
(def film-strip (icon-component svg/film-strip-regular))
(def film-strip-light (icon-component svg/film-strip-light))
(def film-strip-thin (icon-component svg/film-strip-thin))
(def film-strip-fill (icon-component svg/film-strip-fill))
(def film-strip-duotone (icon-component svg/film-strip-duotone))
(def fingerprint-bold (icon-component svg/fingerprint-bold))
(def fingerprint (icon-component svg/fingerprint-regular))
(def fingerprint-light (icon-component svg/fingerprint-light))
(def fingerprint-thin (icon-component svg/fingerprint-thin))
(def fingerprint-fill (icon-component svg/fingerprint-fill))
(def fingerprint-duotone (icon-component svg/fingerprint-duotone))
(def fingerprint-simple-bold (icon-component svg/fingerprint-simple-bold))
(def fingerprint-simple (icon-component svg/fingerprint-simple-regular))
(def fingerprint-simple-light (icon-component svg/fingerprint-simple-light))
(def fingerprint-simple-thin (icon-component svg/fingerprint-simple-thin))
(def fingerprint-simple-fill (icon-component svg/fingerprint-simple-fill))
(def fingerprint-simple-duotone (icon-component svg/fingerprint-simple-duotone))
(def finn-the-human-bold (icon-component svg/finn-the-human-bold))
(def finn-the-human (icon-component svg/finn-the-human-regular))
(def finn-the-human-light (icon-component svg/finn-the-human-light))
(def finn-the-human-thin (icon-component svg/finn-the-human-thin))
(def finn-the-human-fill (icon-component svg/finn-the-human-fill))
(def finn-the-human-duotone (icon-component svg/finn-the-human-duotone))
(def fire-bold (icon-component svg/fire-bold))
(def fire (icon-component svg/fire-regular))
(def fire-light (icon-component svg/fire-light))
(def fire-thin (icon-component svg/fire-thin))
(def fire-fill (icon-component svg/fire-fill))
(def fire-duotone (icon-component svg/fire-duotone))
(def fire-extinguisher-bold (icon-component svg/fire-extinguisher-bold))
(def fire-extinguisher (icon-component svg/fire-extinguisher-regular))
(def fire-extinguisher-light (icon-component svg/fire-extinguisher-light))
(def fire-extinguisher-thin (icon-component svg/fire-extinguisher-thin))
(def fire-extinguisher-fill (icon-component svg/fire-extinguisher-fill))
(def fire-extinguisher-duotone (icon-component svg/fire-extinguisher-duotone))
(def fire-simple-bold (icon-component svg/fire-simple-bold))
(def fire-simple (icon-component svg/fire-simple-regular))
(def fire-simple-light (icon-component svg/fire-simple-light))
(def fire-simple-thin (icon-component svg/fire-simple-thin))
(def fire-simple-fill (icon-component svg/fire-simple-fill))
(def fire-simple-duotone (icon-component svg/fire-simple-duotone))
(def fire-truck-bold (icon-component svg/fire-truck-bold))
(def fire-truck (icon-component svg/fire-truck-regular))
(def fire-truck-light (icon-component svg/fire-truck-light))
(def fire-truck-thin (icon-component svg/fire-truck-thin))
(def fire-truck-fill (icon-component svg/fire-truck-fill))
(def fire-truck-duotone (icon-component svg/fire-truck-duotone))
(def first-aid-bold (icon-component svg/first-aid-bold))
(def first-aid (icon-component svg/first-aid-regular))
(def first-aid-light (icon-component svg/first-aid-light))
(def first-aid-thin (icon-component svg/first-aid-thin))
(def first-aid-fill (icon-component svg/first-aid-fill))
(def first-aid-duotone (icon-component svg/first-aid-duotone))
(def first-aid-kit-bold (icon-component svg/first-aid-kit-bold))
(def first-aid-kit (icon-component svg/first-aid-kit-regular))
(def first-aid-kit-light (icon-component svg/first-aid-kit-light))
(def first-aid-kit-thin (icon-component svg/first-aid-kit-thin))
(def first-aid-kit-fill (icon-component svg/first-aid-kit-fill))
(def first-aid-kit-duotone (icon-component svg/first-aid-kit-duotone))
(def fish-bold (icon-component svg/fish-bold))
(def fish (icon-component svg/fish-regular))
(def fish-light (icon-component svg/fish-light))
(def fish-thin (icon-component svg/fish-thin))
(def fish-fill (icon-component svg/fish-fill))
(def fish-duotone (icon-component svg/fish-duotone))
(def fish-simple-bold (icon-component svg/fish-simple-bold))
(def fish-simple (icon-component svg/fish-simple-regular))
(def fish-simple-light (icon-component svg/fish-simple-light))
(def fish-simple-thin (icon-component svg/fish-simple-thin))
(def fish-simple-fill (icon-component svg/fish-simple-fill))
(def fish-simple-duotone (icon-component svg/fish-simple-duotone))
(def flag-bold (icon-component svg/flag-bold))
(def flag (icon-component svg/flag-regular))
(def flag-light (icon-component svg/flag-light))
(def flag-thin (icon-component svg/flag-thin))
(def flag-fill (icon-component svg/flag-fill))
(def flag-duotone (icon-component svg/flag-duotone))
(def flag-banner-bold (icon-component svg/flag-banner-bold))
(def flag-banner (icon-component svg/flag-banner-regular))
(def flag-banner-light (icon-component svg/flag-banner-light))
(def flag-banner-thin (icon-component svg/flag-banner-thin))
(def flag-banner-fill (icon-component svg/flag-banner-fill))
(def flag-banner-duotone (icon-component svg/flag-banner-duotone))
(def flag-banner-fold-bold (icon-component svg/flag-banner-fold-bold))
(def flag-banner-fold (icon-component svg/flag-banner-fold-regular))
(def flag-banner-fold-light (icon-component svg/flag-banner-fold-light))
(def flag-banner-fold-thin (icon-component svg/flag-banner-fold-thin))
(def flag-banner-fold-fill (icon-component svg/flag-banner-fold-fill))
(def flag-banner-fold-duotone (icon-component svg/flag-banner-fold-duotone))
(def flag-checkered-bold (icon-component svg/flag-checkered-bold))
(def flag-checkered (icon-component svg/flag-checkered-regular))
(def flag-checkered-light (icon-component svg/flag-checkered-light))
(def flag-checkered-thin (icon-component svg/flag-checkered-thin))
(def flag-checkered-fill (icon-component svg/flag-checkered-fill))
(def flag-checkered-duotone (icon-component svg/flag-checkered-duotone))
(def flag-pennant-bold (icon-component svg/flag-pennant-bold))
(def flag-pennant (icon-component svg/flag-pennant-regular))
(def flag-pennant-light (icon-component svg/flag-pennant-light))
(def flag-pennant-thin (icon-component svg/flag-pennant-thin))
(def flag-pennant-fill (icon-component svg/flag-pennant-fill))
(def flag-pennant-duotone (icon-component svg/flag-pennant-duotone))
(def flame-bold (icon-component svg/flame-bold))
(def flame (icon-component svg/flame-regular))
(def flame-light (icon-component svg/flame-light))
(def flame-thin (icon-component svg/flame-thin))
(def flame-fill (icon-component svg/flame-fill))
(def flame-duotone (icon-component svg/flame-duotone))
(def flashlight-bold (icon-component svg/flashlight-bold))
(def flashlight (icon-component svg/flashlight-regular))
(def flashlight-light (icon-component svg/flashlight-light))
(def flashlight-thin (icon-component svg/flashlight-thin))
(def flashlight-fill (icon-component svg/flashlight-fill))
(def flashlight-duotone (icon-component svg/flashlight-duotone))
(def flask-bold (icon-component svg/flask-bold))
(def flask (icon-component svg/flask-regular))
(def flask-light (icon-component svg/flask-light))
(def flask-thin (icon-component svg/flask-thin))
(def flask-fill (icon-component svg/flask-fill))
(def flask-duotone (icon-component svg/flask-duotone))
(def flip-horizontal-bold (icon-component svg/flip-horizontal-bold))
(def flip-horizontal (icon-component svg/flip-horizontal-regular))
(def flip-horizontal-light (icon-component svg/flip-horizontal-light))
(def flip-horizontal-thin (icon-component svg/flip-horizontal-thin))
(def flip-horizontal-fill (icon-component svg/flip-horizontal-fill))
(def flip-horizontal-duotone (icon-component svg/flip-horizontal-duotone))
(def flip-vertical-bold (icon-component svg/flip-vertical-bold))
(def flip-vertical (icon-component svg/flip-vertical-regular))
(def flip-vertical-light (icon-component svg/flip-vertical-light))
(def flip-vertical-thin (icon-component svg/flip-vertical-thin))
(def flip-vertical-fill (icon-component svg/flip-vertical-fill))
(def flip-vertical-duotone (icon-component svg/flip-vertical-duotone))
(def floppy-disk-bold (icon-component svg/floppy-disk-bold))
(def floppy-disk (icon-component svg/floppy-disk-regular))
(def floppy-disk-light (icon-component svg/floppy-disk-light))
(def floppy-disk-thin (icon-component svg/floppy-disk-thin))
(def floppy-disk-fill (icon-component svg/floppy-disk-fill))
(def floppy-disk-duotone (icon-component svg/floppy-disk-duotone))
(def floppy-disk-back-bold (icon-component svg/floppy-disk-back-bold))
(def floppy-disk-back (icon-component svg/floppy-disk-back-regular))
(def floppy-disk-back-light (icon-component svg/floppy-disk-back-light))
(def floppy-disk-back-thin (icon-component svg/floppy-disk-back-thin))
(def floppy-disk-back-fill (icon-component svg/floppy-disk-back-fill))
(def floppy-disk-back-duotone (icon-component svg/floppy-disk-back-duotone))
(def flow-arrow-bold (icon-component svg/flow-arrow-bold))
(def flow-arrow (icon-component svg/flow-arrow-regular))
(def flow-arrow-light (icon-component svg/flow-arrow-light))
(def flow-arrow-thin (icon-component svg/flow-arrow-thin))
(def flow-arrow-fill (icon-component svg/flow-arrow-fill))
(def flow-arrow-duotone (icon-component svg/flow-arrow-duotone))
(def flower-bold (icon-component svg/flower-bold))
(def flower (icon-component svg/flower-regular))
(def flower-light (icon-component svg/flower-light))
(def flower-thin (icon-component svg/flower-thin))
(def flower-fill (icon-component svg/flower-fill))
(def flower-duotone (icon-component svg/flower-duotone))
(def flower-lotus-bold (icon-component svg/flower-lotus-bold))
(def flower-lotus (icon-component svg/flower-lotus-regular))
(def flower-lotus-light (icon-component svg/flower-lotus-light))
(def flower-lotus-thin (icon-component svg/flower-lotus-thin))
(def flower-lotus-fill (icon-component svg/flower-lotus-fill))
(def flower-lotus-duotone (icon-component svg/flower-lotus-duotone))
(def flower-tulip-bold (icon-component svg/flower-tulip-bold))
(def flower-tulip (icon-component svg/flower-tulip-regular))
(def flower-tulip-light (icon-component svg/flower-tulip-light))
(def flower-tulip-thin (icon-component svg/flower-tulip-thin))
(def flower-tulip-fill (icon-component svg/flower-tulip-fill))
(def flower-tulip-duotone (icon-component svg/flower-tulip-duotone))
(def flying-saucer-bold (icon-component svg/flying-saucer-bold))
(def flying-saucer (icon-component svg/flying-saucer-regular))
(def flying-saucer-light (icon-component svg/flying-saucer-light))
(def flying-saucer-thin (icon-component svg/flying-saucer-thin))
(def flying-saucer-fill (icon-component svg/flying-saucer-fill))
(def flying-saucer-duotone (icon-component svg/flying-saucer-duotone))
(def folder-bold (icon-component svg/folder-bold))
(def folder (icon-component svg/folder-regular))
(def folder-light (icon-component svg/folder-light))
(def folder-thin (icon-component svg/folder-thin))
(def folder-fill (icon-component svg/folder-fill))
(def folder-duotone (icon-component svg/folder-duotone))
(def folder-dashed-bold (icon-component svg/folder-dashed-bold))
(def folder-dashed (icon-component svg/folder-dashed-regular))
(def folder-dashed-light (icon-component svg/folder-dashed-light))
(def folder-dashed-thin (icon-component svg/folder-dashed-thin))
(def folder-dashed-fill (icon-component svg/folder-dashed-fill))
(def folder-dashed-duotone (icon-component svg/folder-dashed-duotone))
(def folder-lock-bold (icon-component svg/folder-lock-bold))
(def folder-lock (icon-component svg/folder-lock-regular))
(def folder-lock-light (icon-component svg/folder-lock-light))
(def folder-lock-thin (icon-component svg/folder-lock-thin))
(def folder-lock-fill (icon-component svg/folder-lock-fill))
(def folder-lock-duotone (icon-component svg/folder-lock-duotone))
(def folder-minus-bold (icon-component svg/folder-minus-bold))
(def folder-minus (icon-component svg/folder-minus-regular))
(def folder-minus-light (icon-component svg/folder-minus-light))
(def folder-minus-thin (icon-component svg/folder-minus-thin))
(def folder-minus-fill (icon-component svg/folder-minus-fill))
(def folder-minus-duotone (icon-component svg/folder-minus-duotone))
(def folder-open-bold (icon-component svg/folder-open-bold))
(def folder-open (icon-component svg/folder-open-regular))
(def folder-open-light (icon-component svg/folder-open-light))
(def folder-open-thin (icon-component svg/folder-open-thin))
(def folder-open-fill (icon-component svg/folder-open-fill))
(def folder-open-duotone (icon-component svg/folder-open-duotone))
(def folder-plus-bold (icon-component svg/folder-plus-bold))
(def folder-plus (icon-component svg/folder-plus-regular))
(def folder-plus-light (icon-component svg/folder-plus-light))
(def folder-plus-thin (icon-component svg/folder-plus-thin))
(def folder-plus-fill (icon-component svg/folder-plus-fill))
(def folder-plus-duotone (icon-component svg/folder-plus-duotone))
(def folder-simple-bold (icon-component svg/folder-simple-bold))
(def folder-simple (icon-component svg/folder-simple-regular))
(def folder-simple-light (icon-component svg/folder-simple-light))
(def folder-simple-thin (icon-component svg/folder-simple-thin))
(def folder-simple-fill (icon-component svg/folder-simple-fill))
(def folder-simple-duotone (icon-component svg/folder-simple-duotone))
(def folder-simple-dashed-bold (icon-component svg/folder-simple-dashed-bold))
(def folder-simple-dashed (icon-component svg/folder-simple-dashed-regular))
(def folder-simple-dashed-light (icon-component svg/folder-simple-dashed-light))
(def folder-simple-dashed-thin (icon-component svg/folder-simple-dashed-thin))
(def folder-simple-dashed-fill (icon-component svg/folder-simple-dashed-fill))
(def folder-simple-dashed-duotone (icon-component svg/folder-simple-dashed-duotone))
(def folder-simple-lock-bold (icon-component svg/folder-simple-lock-bold))
(def folder-simple-lock (icon-component svg/folder-simple-lock-regular))
(def folder-simple-lock-light (icon-component svg/folder-simple-lock-light))
(def folder-simple-lock-thin (icon-component svg/folder-simple-lock-thin))
(def folder-simple-lock-fill (icon-component svg/folder-simple-lock-fill))
(def folder-simple-lock-duotone (icon-component svg/folder-simple-lock-duotone))
(def folder-simple-minus-bold (icon-component svg/folder-simple-minus-bold))
(def folder-simple-minus (icon-component svg/folder-simple-minus-regular))
(def folder-simple-minus-light (icon-component svg/folder-simple-minus-light))
(def folder-simple-minus-thin (icon-component svg/folder-simple-minus-thin))
(def folder-simple-minus-fill (icon-component svg/folder-simple-minus-fill))
(def folder-simple-minus-duotone (icon-component svg/folder-simple-minus-duotone))
(def folder-simple-plus-bold (icon-component svg/folder-simple-plus-bold))
(def folder-simple-plus (icon-component svg/folder-simple-plus-regular))
(def folder-simple-plus-light (icon-component svg/folder-simple-plus-light))
(def folder-simple-plus-thin (icon-component svg/folder-simple-plus-thin))
(def folder-simple-plus-fill (icon-component svg/folder-simple-plus-fill))
(def folder-simple-plus-duotone (icon-component svg/folder-simple-plus-duotone))
(def folder-simple-star-bold (icon-component svg/folder-simple-star-bold))
(def folder-simple-star (icon-component svg/folder-simple-star-regular))
(def folder-simple-star-light (icon-component svg/folder-simple-star-light))
(def folder-simple-star-thin (icon-component svg/folder-simple-star-thin))
(def folder-simple-star-fill (icon-component svg/folder-simple-star-fill))
(def folder-simple-star-duotone (icon-component svg/folder-simple-star-duotone))
(def folder-simple-user-bold (icon-component svg/folder-simple-user-bold))
(def folder-simple-user (icon-component svg/folder-simple-user-regular))
(def folder-simple-user-light (icon-component svg/folder-simple-user-light))
(def folder-simple-user-thin (icon-component svg/folder-simple-user-thin))
(def folder-simple-user-fill (icon-component svg/folder-simple-user-fill))
(def folder-simple-user-duotone (icon-component svg/folder-simple-user-duotone))
(def folder-star-bold (icon-component svg/folder-star-bold))
(def folder-star (icon-component svg/folder-star-regular))
(def folder-star-light (icon-component svg/folder-star-light))
(def folder-star-thin (icon-component svg/folder-star-thin))
(def folder-star-fill (icon-component svg/folder-star-fill))
(def folder-star-duotone (icon-component svg/folder-star-duotone))
(def folder-user-bold (icon-component svg/folder-user-bold))
(def folder-user (icon-component svg/folder-user-regular))
(def folder-user-light (icon-component svg/folder-user-light))
(def folder-user-thin (icon-component svg/folder-user-thin))
(def folder-user-fill (icon-component svg/folder-user-fill))
(def folder-user-duotone (icon-component svg/folder-user-duotone))
(def folders-bold (icon-component svg/folders-bold))
(def folders (icon-component svg/folders-regular))
(def folders-light (icon-component svg/folders-light))
(def folders-thin (icon-component svg/folders-thin))
(def folders-fill (icon-component svg/folders-fill))
(def folders-duotone (icon-component svg/folders-duotone))
(def football-bold (icon-component svg/football-bold))
(def football (icon-component svg/football-regular))
(def football-light (icon-component svg/football-light))
(def football-thin (icon-component svg/football-thin))
(def football-fill (icon-component svg/football-fill))
(def football-duotone (icon-component svg/football-duotone))
(def football-helmet-bold (icon-component svg/football-helmet-bold))
(def football-helmet (icon-component svg/football-helmet-regular))
(def football-helmet-light (icon-component svg/football-helmet-light))
(def football-helmet-thin (icon-component svg/football-helmet-thin))
(def football-helmet-fill (icon-component svg/football-helmet-fill))
(def football-helmet-duotone (icon-component svg/football-helmet-duotone))
(def footprints-bold (icon-component svg/footprints-bold))
(def footprints (icon-component svg/footprints-regular))
(def footprints-light (icon-component svg/footprints-light))
(def footprints-thin (icon-component svg/footprints-thin))
(def footprints-fill (icon-component svg/footprints-fill))
(def footprints-duotone (icon-component svg/footprints-duotone))
(def fork-knife-bold (icon-component svg/fork-knife-bold))
(def fork-knife (icon-component svg/fork-knife-regular))
(def fork-knife-light (icon-component svg/fork-knife-light))
(def fork-knife-thin (icon-component svg/fork-knife-thin))
(def fork-knife-fill (icon-component svg/fork-knife-fill))
(def fork-knife-duotone (icon-component svg/fork-knife-duotone))
(def four-k-bold (icon-component svg/four-k-bold))
(def four-k (icon-component svg/four-k-regular))
(def four-k-light (icon-component svg/four-k-light))
(def four-k-thin (icon-component svg/four-k-thin))
(def four-k-fill (icon-component svg/four-k-fill))
(def four-k-duotone (icon-component svg/four-k-duotone))
(def frame-corners-bold (icon-component svg/frame-corners-bold))
(def frame-corners (icon-component svg/frame-corners-regular))
(def frame-corners-light (icon-component svg/frame-corners-light))
(def frame-corners-thin (icon-component svg/frame-corners-thin))
(def frame-corners-fill (icon-component svg/frame-corners-fill))
(def frame-corners-duotone (icon-component svg/frame-corners-duotone))
(def framer-logo-bold (icon-component svg/framer-logo-bold))
(def framer-logo (icon-component svg/framer-logo-regular))
(def framer-logo-light (icon-component svg/framer-logo-light))
(def framer-logo-thin (icon-component svg/framer-logo-thin))
(def framer-logo-fill (icon-component svg/framer-logo-fill))
(def framer-logo-duotone (icon-component svg/framer-logo-duotone))
(def function-bold (icon-component svg/function-bold))
(def function (icon-component svg/function-regular))
(def function-light (icon-component svg/function-light))
(def function-thin (icon-component svg/function-thin))
(def function-fill (icon-component svg/function-fill))
(def function-duotone (icon-component svg/function-duotone))
(def funnel-bold (icon-component svg/funnel-bold))
(def funnel (icon-component svg/funnel-regular))
(def funnel-light (icon-component svg/funnel-light))
(def funnel-thin (icon-component svg/funnel-thin))
(def funnel-fill (icon-component svg/funnel-fill))
(def funnel-duotone (icon-component svg/funnel-duotone))
(def funnel-simple-bold (icon-component svg/funnel-simple-bold))
(def funnel-simple (icon-component svg/funnel-simple-regular))
(def funnel-simple-light (icon-component svg/funnel-simple-light))
(def funnel-simple-thin (icon-component svg/funnel-simple-thin))
(def funnel-simple-fill (icon-component svg/funnel-simple-fill))
(def funnel-simple-duotone (icon-component svg/funnel-simple-duotone))
(def funnel-simple-x-bold (icon-component svg/funnel-simple-x-bold))
(def funnel-simple-x (icon-component svg/funnel-simple-x-regular))
(def funnel-simple-x-light (icon-component svg/funnel-simple-x-light))
(def funnel-simple-x-thin (icon-component svg/funnel-simple-x-thin))
(def funnel-simple-x-fill (icon-component svg/funnel-simple-x-fill))
(def funnel-simple-x-duotone (icon-component svg/funnel-simple-x-duotone))
(def funnel-x-bold (icon-component svg/funnel-x-bold))
(def funnel-x (icon-component svg/funnel-x-regular))
(def funnel-x-light (icon-component svg/funnel-x-light))
(def funnel-x-thin (icon-component svg/funnel-x-thin))
(def funnel-x-fill (icon-component svg/funnel-x-fill))
(def funnel-x-duotone (icon-component svg/funnel-x-duotone))
(def game-controller-bold (icon-component svg/game-controller-bold))
(def game-controller (icon-component svg/game-controller-regular))
(def game-controller-light (icon-component svg/game-controller-light))
(def game-controller-thin (icon-component svg/game-controller-thin))
(def game-controller-fill (icon-component svg/game-controller-fill))
(def game-controller-duotone (icon-component svg/game-controller-duotone))
(def garage-bold (icon-component svg/garage-bold))
(def garage (icon-component svg/garage-regular))
(def garage-light (icon-component svg/garage-light))
(def garage-thin (icon-component svg/garage-thin))
(def garage-fill (icon-component svg/garage-fill))
(def garage-duotone (icon-component svg/garage-duotone))
(def gas-can-bold (icon-component svg/gas-can-bold))
(def gas-can (icon-component svg/gas-can-regular))
(def gas-can-light (icon-component svg/gas-can-light))
(def gas-can-thin (icon-component svg/gas-can-thin))
(def gas-can-fill (icon-component svg/gas-can-fill))
(def gas-can-duotone (icon-component svg/gas-can-duotone))
(def gas-pump-bold (icon-component svg/gas-pump-bold))
(def gas-pump (icon-component svg/gas-pump-regular))
(def gas-pump-light (icon-component svg/gas-pump-light))
(def gas-pump-thin (icon-component svg/gas-pump-thin))
(def gas-pump-fill (icon-component svg/gas-pump-fill))
(def gas-pump-duotone (icon-component svg/gas-pump-duotone))
(def gauge-bold (icon-component svg/gauge-bold))
(def gauge (icon-component svg/gauge-regular))
(def gauge-light (icon-component svg/gauge-light))
(def gauge-thin (icon-component svg/gauge-thin))
(def gauge-fill (icon-component svg/gauge-fill))
(def gauge-duotone (icon-component svg/gauge-duotone))
(def gavel-bold (icon-component svg/gavel-bold))
(def gavel (icon-component svg/gavel-regular))
(def gavel-light (icon-component svg/gavel-light))
(def gavel-thin (icon-component svg/gavel-thin))
(def gavel-fill (icon-component svg/gavel-fill))
(def gavel-duotone (icon-component svg/gavel-duotone))
(def gear-bold (icon-component svg/gear-bold))
(def gear (icon-component svg/gear-regular))
(def gear-light (icon-component svg/gear-light))
(def gear-thin (icon-component svg/gear-thin))
(def gear-fill (icon-component svg/gear-fill))
(def gear-duotone (icon-component svg/gear-duotone))
(def gear-fine-bold (icon-component svg/gear-fine-bold))
(def gear-fine (icon-component svg/gear-fine-regular))
(def gear-fine-light (icon-component svg/gear-fine-light))
(def gear-fine-thin (icon-component svg/gear-fine-thin))
(def gear-fine-fill (icon-component svg/gear-fine-fill))
(def gear-fine-duotone (icon-component svg/gear-fine-duotone))
(def gear-six-bold (icon-component svg/gear-six-bold))
(def gear-six (icon-component svg/gear-six-regular))
(def gear-six-light (icon-component svg/gear-six-light))
(def gear-six-thin (icon-component svg/gear-six-thin))
(def gear-six-fill (icon-component svg/gear-six-fill))
(def gear-six-duotone (icon-component svg/gear-six-duotone))
(def gender-female-bold (icon-component svg/gender-female-bold))
(def gender-female (icon-component svg/gender-female-regular))
(def gender-female-light (icon-component svg/gender-female-light))
(def gender-female-thin (icon-component svg/gender-female-thin))
(def gender-female-fill (icon-component svg/gender-female-fill))
(def gender-female-duotone (icon-component svg/gender-female-duotone))
(def gender-intersex-bold (icon-component svg/gender-intersex-bold))
(def gender-intersex (icon-component svg/gender-intersex-regular))
(def gender-intersex-light (icon-component svg/gender-intersex-light))
(def gender-intersex-thin (icon-component svg/gender-intersex-thin))
(def gender-intersex-fill (icon-component svg/gender-intersex-fill))
(def gender-intersex-duotone (icon-component svg/gender-intersex-duotone))
(def gender-male-bold (icon-component svg/gender-male-bold))
(def gender-male (icon-component svg/gender-male-regular))
(def gender-male-light (icon-component svg/gender-male-light))
(def gender-male-thin (icon-component svg/gender-male-thin))
(def gender-male-fill (icon-component svg/gender-male-fill))
(def gender-male-duotone (icon-component svg/gender-male-duotone))
(def gender-neuter-bold (icon-component svg/gender-neuter-bold))
(def gender-neuter (icon-component svg/gender-neuter-regular))
(def gender-neuter-light (icon-component svg/gender-neuter-light))
(def gender-neuter-thin (icon-component svg/gender-neuter-thin))
(def gender-neuter-fill (icon-component svg/gender-neuter-fill))
(def gender-neuter-duotone (icon-component svg/gender-neuter-duotone))
(def gender-nonbinary-bold (icon-component svg/gender-nonbinary-bold))
(def gender-nonbinary (icon-component svg/gender-nonbinary-regular))
(def gender-nonbinary-light (icon-component svg/gender-nonbinary-light))
(def gender-nonbinary-thin (icon-component svg/gender-nonbinary-thin))
(def gender-nonbinary-fill (icon-component svg/gender-nonbinary-fill))
(def gender-nonbinary-duotone (icon-component svg/gender-nonbinary-duotone))
(def gender-transgender-bold (icon-component svg/gender-transgender-bold))
(def gender-transgender (icon-component svg/gender-transgender-regular))
(def gender-transgender-light (icon-component svg/gender-transgender-light))
(def gender-transgender-thin (icon-component svg/gender-transgender-thin))
(def gender-transgender-fill (icon-component svg/gender-transgender-fill))
(def gender-transgender-duotone (icon-component svg/gender-transgender-duotone))
(def ghost-bold (icon-component svg/ghost-bold))
(def ghost (icon-component svg/ghost-regular))
(def ghost-light (icon-component svg/ghost-light))
(def ghost-thin (icon-component svg/ghost-thin))
(def ghost-fill (icon-component svg/ghost-fill))
(def ghost-duotone (icon-component svg/ghost-duotone))
(def gif-bold (icon-component svg/gif-bold))
(def gif (icon-component svg/gif-regular))
(def gif-light (icon-component svg/gif-light))
(def gif-thin (icon-component svg/gif-thin))
(def gif-fill (icon-component svg/gif-fill))
(def gif-duotone (icon-component svg/gif-duotone))
(def gift-bold (icon-component svg/gift-bold))
(def gift (icon-component svg/gift-regular))
(def gift-light (icon-component svg/gift-light))
(def gift-thin (icon-component svg/gift-thin))
(def gift-fill (icon-component svg/gift-fill))
(def gift-duotone (icon-component svg/gift-duotone))
(def git-branch-bold (icon-component svg/git-branch-bold))
(def git-branch (icon-component svg/git-branch-regular))
(def git-branch-light (icon-component svg/git-branch-light))
(def git-branch-thin (icon-component svg/git-branch-thin))
(def git-branch-fill (icon-component svg/git-branch-fill))
(def git-branch-duotone (icon-component svg/git-branch-duotone))
(def git-commit-bold (icon-component svg/git-commit-bold))
(def git-commit (icon-component svg/git-commit-regular))
(def git-commit-light (icon-component svg/git-commit-light))
(def git-commit-thin (icon-component svg/git-commit-thin))
(def git-commit-fill (icon-component svg/git-commit-fill))
(def git-commit-duotone (icon-component svg/git-commit-duotone))
(def git-diff-bold (icon-component svg/git-diff-bold))
(def git-diff (icon-component svg/git-diff-regular))
(def git-diff-light (icon-component svg/git-diff-light))
(def git-diff-thin (icon-component svg/git-diff-thin))
(def git-diff-fill (icon-component svg/git-diff-fill))
(def git-diff-duotone (icon-component svg/git-diff-duotone))
(def git-fork-bold (icon-component svg/git-fork-bold))
(def git-fork (icon-component svg/git-fork-regular))
(def git-fork-light (icon-component svg/git-fork-light))
(def git-fork-thin (icon-component svg/git-fork-thin))
(def git-fork-fill (icon-component svg/git-fork-fill))
(def git-fork-duotone (icon-component svg/git-fork-duotone))
(def git-merge-bold (icon-component svg/git-merge-bold))
(def git-merge (icon-component svg/git-merge-regular))
(def git-merge-light (icon-component svg/git-merge-light))
(def git-merge-thin (icon-component svg/git-merge-thin))
(def git-merge-fill (icon-component svg/git-merge-fill))
(def git-merge-duotone (icon-component svg/git-merge-duotone))
(def git-pull-request-bold (icon-component svg/git-pull-request-bold))
(def git-pull-request (icon-component svg/git-pull-request-regular))
(def git-pull-request-light (icon-component svg/git-pull-request-light))
(def git-pull-request-thin (icon-component svg/git-pull-request-thin))
(def git-pull-request-fill (icon-component svg/git-pull-request-fill))
(def git-pull-request-duotone (icon-component svg/git-pull-request-duotone))
(def github-logo-bold (icon-component svg/github-logo-bold))
(def github-logo (icon-component svg/github-logo-regular))
(def github-logo-light (icon-component svg/github-logo-light))
(def github-logo-thin (icon-component svg/github-logo-thin))
(def github-logo-fill (icon-component svg/github-logo-fill))
(def github-logo-duotone (icon-component svg/github-logo-duotone))
(def gitlab-logo-bold (icon-component svg/gitlab-logo-bold))
(def gitlab-logo (icon-component svg/gitlab-logo-regular))
(def gitlab-logo-light (icon-component svg/gitlab-logo-light))
(def gitlab-logo-thin (icon-component svg/gitlab-logo-thin))
(def gitlab-logo-fill (icon-component svg/gitlab-logo-fill))
(def gitlab-logo-duotone (icon-component svg/gitlab-logo-duotone))
(def gitlab-logo-simple-bold (icon-component svg/gitlab-logo-simple-bold))
(def gitlab-logo-simple (icon-component svg/gitlab-logo-simple-regular))
(def gitlab-logo-simple-light (icon-component svg/gitlab-logo-simple-light))
(def gitlab-logo-simple-thin (icon-component svg/gitlab-logo-simple-thin))
(def gitlab-logo-simple-fill (icon-component svg/gitlab-logo-simple-fill))
(def gitlab-logo-simple-duotone (icon-component svg/gitlab-logo-simple-duotone))
(def globe-bold (icon-component svg/globe-bold))
(def globe (icon-component svg/globe-regular))
(def globe-light (icon-component svg/globe-light))
(def globe-thin (icon-component svg/globe-thin))
(def globe-fill (icon-component svg/globe-fill))
(def globe-duotone (icon-component svg/globe-duotone))
(def globe-hemisphere-east-bold (icon-component svg/globe-hemisphere-east-bold))
(def globe-hemisphere-east (icon-component svg/globe-hemisphere-east-regular))
(def globe-hemisphere-east-light (icon-component svg/globe-hemisphere-east-light))
(def globe-hemisphere-east-thin (icon-component svg/globe-hemisphere-east-thin))
(def globe-hemisphere-east-fill (icon-component svg/globe-hemisphere-east-fill))
(def globe-hemisphere-east-duotone (icon-component svg/globe-hemisphere-east-duotone))
(def globe-hemisphere-west-bold (icon-component svg/globe-hemisphere-west-bold))
(def globe-hemisphere-west (icon-component svg/globe-hemisphere-west-regular))
(def globe-hemisphere-west-light (icon-component svg/globe-hemisphere-west-light))
(def globe-hemisphere-west-thin (icon-component svg/globe-hemisphere-west-thin))
(def globe-hemisphere-west-fill (icon-component svg/globe-hemisphere-west-fill))
(def globe-hemisphere-west-duotone (icon-component svg/globe-hemisphere-west-duotone))
(def globe-simple-bold (icon-component svg/globe-simple-bold))
(def globe-simple (icon-component svg/globe-simple-regular))
(def globe-simple-light (icon-component svg/globe-simple-light))
(def globe-simple-thin (icon-component svg/globe-simple-thin))
(def globe-simple-fill (icon-component svg/globe-simple-fill))
(def globe-simple-duotone (icon-component svg/globe-simple-duotone))
(def globe-simple-x-bold (icon-component svg/globe-simple-x-bold))
(def globe-simple-x (icon-component svg/globe-simple-x-regular))
(def globe-simple-x-light (icon-component svg/globe-simple-x-light))
(def globe-simple-x-thin (icon-component svg/globe-simple-x-thin))
(def globe-simple-x-fill (icon-component svg/globe-simple-x-fill))
(def globe-simple-x-duotone (icon-component svg/globe-simple-x-duotone))
(def globe-stand-bold (icon-component svg/globe-stand-bold))
(def globe-stand (icon-component svg/globe-stand-regular))
(def globe-stand-light (icon-component svg/globe-stand-light))
(def globe-stand-thin (icon-component svg/globe-stand-thin))
(def globe-stand-fill (icon-component svg/globe-stand-fill))
(def globe-stand-duotone (icon-component svg/globe-stand-duotone))
(def globe-x-bold (icon-component svg/globe-x-bold))
(def globe-x (icon-component svg/globe-x-regular))
(def globe-x-light (icon-component svg/globe-x-light))
(def globe-x-thin (icon-component svg/globe-x-thin))
(def globe-x-fill (icon-component svg/globe-x-fill))
(def globe-x-duotone (icon-component svg/globe-x-duotone))
(def goggles-bold (icon-component svg/goggles-bold))
(def goggles (icon-component svg/goggles-regular))
(def goggles-light (icon-component svg/goggles-light))
(def goggles-thin (icon-component svg/goggles-thin))
(def goggles-fill (icon-component svg/goggles-fill))
(def goggles-duotone (icon-component svg/goggles-duotone))
(def golf-bold (icon-component svg/golf-bold))
(def golf (icon-component svg/golf-regular))
(def golf-light (icon-component svg/golf-light))
(def golf-thin (icon-component svg/golf-thin))
(def golf-fill (icon-component svg/golf-fill))
(def golf-duotone (icon-component svg/golf-duotone))
(def goodreads-logo-bold (icon-component svg/goodreads-logo-bold))
(def goodreads-logo (icon-component svg/goodreads-logo-regular))
(def goodreads-logo-light (icon-component svg/goodreads-logo-light))
(def goodreads-logo-thin (icon-component svg/goodreads-logo-thin))
(def goodreads-logo-fill (icon-component svg/goodreads-logo-fill))
(def goodreads-logo-duotone (icon-component svg/goodreads-logo-duotone))
(def google-cardboard-logo-bold (icon-component svg/google-cardboard-logo-bold))
(def google-cardboard-logo (icon-component svg/google-cardboard-logo-regular))
(def google-cardboard-logo-light (icon-component svg/google-cardboard-logo-light))
(def google-cardboard-logo-thin (icon-component svg/google-cardboard-logo-thin))
(def google-cardboard-logo-fill (icon-component svg/google-cardboard-logo-fill))
(def google-cardboard-logo-duotone (icon-component svg/google-cardboard-logo-duotone))
(def google-chrome-logo-bold (icon-component svg/google-chrome-logo-bold))
(def google-chrome-logo (icon-component svg/google-chrome-logo-regular))
(def google-chrome-logo-light (icon-component svg/google-chrome-logo-light))
(def google-chrome-logo-thin (icon-component svg/google-chrome-logo-thin))
(def google-chrome-logo-fill (icon-component svg/google-chrome-logo-fill))
(def google-chrome-logo-duotone (icon-component svg/google-chrome-logo-duotone))
(def google-drive-logo-bold (icon-component svg/google-drive-logo-bold))
(def google-drive-logo (icon-component svg/google-drive-logo-regular))
(def google-drive-logo-light (icon-component svg/google-drive-logo-light))
(def google-drive-logo-thin (icon-component svg/google-drive-logo-thin))
(def google-drive-logo-fill (icon-component svg/google-drive-logo-fill))
(def google-drive-logo-duotone (icon-component svg/google-drive-logo-duotone))
(def google-logo-bold (icon-component svg/google-logo-bold))
(def google-logo (icon-component svg/google-logo-regular))
(def google-logo-light (icon-component svg/google-logo-light))
(def google-logo-thin (icon-component svg/google-logo-thin))
(def google-logo-fill (icon-component svg/google-logo-fill))
(def google-logo-duotone (icon-component svg/google-logo-duotone))
(def google-photos-logo-bold (icon-component svg/google-photos-logo-bold))
(def google-photos-logo (icon-component svg/google-photos-logo-regular))
(def google-photos-logo-light (icon-component svg/google-photos-logo-light))
(def google-photos-logo-thin (icon-component svg/google-photos-logo-thin))
(def google-photos-logo-fill (icon-component svg/google-photos-logo-fill))
(def google-photos-logo-duotone (icon-component svg/google-photos-logo-duotone))
(def google-play-logo-bold (icon-component svg/google-play-logo-bold))
(def google-play-logo (icon-component svg/google-play-logo-regular))
(def google-play-logo-light (icon-component svg/google-play-logo-light))
(def google-play-logo-thin (icon-component svg/google-play-logo-thin))
(def google-play-logo-fill (icon-component svg/google-play-logo-fill))
(def google-play-logo-duotone (icon-component svg/google-play-logo-duotone))
(def google-podcasts-logo-bold (icon-component svg/google-podcasts-logo-bold))
(def google-podcasts-logo (icon-component svg/google-podcasts-logo-regular))
(def google-podcasts-logo-light (icon-component svg/google-podcasts-logo-light))
(def google-podcasts-logo-thin (icon-component svg/google-podcasts-logo-thin))
(def google-podcasts-logo-fill (icon-component svg/google-podcasts-logo-fill))
(def google-podcasts-logo-duotone (icon-component svg/google-podcasts-logo-duotone))
(def gps-bold (icon-component svg/gps-bold))
(def gps (icon-component svg/gps-regular))
(def gps-light (icon-component svg/gps-light))
(def gps-thin (icon-component svg/gps-thin))
(def gps-fill (icon-component svg/gps-fill))
(def gps-duotone (icon-component svg/gps-duotone))
(def gps-fix-bold (icon-component svg/gps-fix-bold))
(def gps-fix (icon-component svg/gps-fix-regular))
(def gps-fix-light (icon-component svg/gps-fix-light))
(def gps-fix-thin (icon-component svg/gps-fix-thin))
(def gps-fix-fill (icon-component svg/gps-fix-fill))
(def gps-fix-duotone (icon-component svg/gps-fix-duotone))
(def gps-slash-bold (icon-component svg/gps-slash-bold))
(def gps-slash (icon-component svg/gps-slash-regular))
(def gps-slash-light (icon-component svg/gps-slash-light))
(def gps-slash-thin (icon-component svg/gps-slash-thin))
(def gps-slash-fill (icon-component svg/gps-slash-fill))
(def gps-slash-duotone (icon-component svg/gps-slash-duotone))
(def gradient-bold (icon-component svg/gradient-bold))
(def gradient (icon-component svg/gradient-regular))
(def gradient-light (icon-component svg/gradient-light))
(def gradient-thin (icon-component svg/gradient-thin))
(def gradient-fill (icon-component svg/gradient-fill))
(def gradient-duotone (icon-component svg/gradient-duotone))
(def graduation-cap-bold (icon-component svg/graduation-cap-bold))
(def graduation-cap (icon-component svg/graduation-cap-regular))
(def graduation-cap-light (icon-component svg/graduation-cap-light))
(def graduation-cap-thin (icon-component svg/graduation-cap-thin))
(def graduation-cap-fill (icon-component svg/graduation-cap-fill))
(def graduation-cap-duotone (icon-component svg/graduation-cap-duotone))
(def grains-bold (icon-component svg/grains-bold))
(def grains (icon-component svg/grains-regular))
(def grains-light (icon-component svg/grains-light))
(def grains-thin (icon-component svg/grains-thin))
(def grains-fill (icon-component svg/grains-fill))
(def grains-duotone (icon-component svg/grains-duotone))
(def grains-slash-bold (icon-component svg/grains-slash-bold))
(def grains-slash (icon-component svg/grains-slash-regular))
(def grains-slash-light (icon-component svg/grains-slash-light))
(def grains-slash-thin (icon-component svg/grains-slash-thin))
(def grains-slash-fill (icon-component svg/grains-slash-fill))
(def grains-slash-duotone (icon-component svg/grains-slash-duotone))
(def graph-bold (icon-component svg/graph-bold))
(def graph (icon-component svg/graph-regular))
(def graph-light (icon-component svg/graph-light))
(def graph-thin (icon-component svg/graph-thin))
(def graph-fill (icon-component svg/graph-fill))
(def graph-duotone (icon-component svg/graph-duotone))
(def graphics-card-bold (icon-component svg/graphics-card-bold))
(def graphics-card (icon-component svg/graphics-card-regular))
(def graphics-card-light (icon-component svg/graphics-card-light))
(def graphics-card-thin (icon-component svg/graphics-card-thin))
(def graphics-card-fill (icon-component svg/graphics-card-fill))
(def graphics-card-duotone (icon-component svg/graphics-card-duotone))
(def greater-than-bold (icon-component svg/greater-than-bold))
(def greater-than (icon-component svg/greater-than-regular))
(def greater-than-light (icon-component svg/greater-than-light))
(def greater-than-thin (icon-component svg/greater-than-thin))
(def greater-than-fill (icon-component svg/greater-than-fill))
(def greater-than-duotone (icon-component svg/greater-than-duotone))
(def greater-than-or-equal-bold (icon-component svg/greater-than-or-equal-bold))
(def greater-than-or-equal (icon-component svg/greater-than-or-equal-regular))
(def greater-than-or-equal-light (icon-component svg/greater-than-or-equal-light))
(def greater-than-or-equal-thin (icon-component svg/greater-than-or-equal-thin))
(def greater-than-or-equal-fill (icon-component svg/greater-than-or-equal-fill))
(def greater-than-or-equal-duotone (icon-component svg/greater-than-or-equal-duotone))
(def grid-four-bold (icon-component svg/grid-four-bold))
(def grid-four (icon-component svg/grid-four-regular))
(def grid-four-light (icon-component svg/grid-four-light))
(def grid-four-thin (icon-component svg/grid-four-thin))
(def grid-four-fill (icon-component svg/grid-four-fill))
(def grid-four-duotone (icon-component svg/grid-four-duotone))
(def grid-nine-bold (icon-component svg/grid-nine-bold))
(def grid-nine (icon-component svg/grid-nine-regular))
(def grid-nine-light (icon-component svg/grid-nine-light))
(def grid-nine-thin (icon-component svg/grid-nine-thin))
(def grid-nine-fill (icon-component svg/grid-nine-fill))
(def grid-nine-duotone (icon-component svg/grid-nine-duotone))
(def guitar-bold (icon-component svg/guitar-bold))
(def guitar (icon-component svg/guitar-regular))
(def guitar-light (icon-component svg/guitar-light))
(def guitar-thin (icon-component svg/guitar-thin))
(def guitar-fill (icon-component svg/guitar-fill))
(def guitar-duotone (icon-component svg/guitar-duotone))
(def hair-dryer-bold (icon-component svg/hair-dryer-bold))
(def hair-dryer (icon-component svg/hair-dryer-regular))
(def hair-dryer-light (icon-component svg/hair-dryer-light))
(def hair-dryer-thin (icon-component svg/hair-dryer-thin))
(def hair-dryer-fill (icon-component svg/hair-dryer-fill))
(def hair-dryer-duotone (icon-component svg/hair-dryer-duotone))
(def hamburger-bold (icon-component svg/hamburger-bold))
(def hamburger (icon-component svg/hamburger-regular))
(def hamburger-light (icon-component svg/hamburger-light))
(def hamburger-thin (icon-component svg/hamburger-thin))
(def hamburger-fill (icon-component svg/hamburger-fill))
(def hamburger-duotone (icon-component svg/hamburger-duotone))
(def hammer-bold (icon-component svg/hammer-bold))
(def hammer (icon-component svg/hammer-regular))
(def hammer-light (icon-component svg/hammer-light))
(def hammer-thin (icon-component svg/hammer-thin))
(def hammer-fill (icon-component svg/hammer-fill))
(def hammer-duotone (icon-component svg/hammer-duotone))
(def hand-bold (icon-component svg/hand-bold))
(def hand (icon-component svg/hand-regular))
(def hand-light (icon-component svg/hand-light))
(def hand-thin (icon-component svg/hand-thin))
(def hand-fill (icon-component svg/hand-fill))
(def hand-duotone (icon-component svg/hand-duotone))
(def hand-arrow-down-bold (icon-component svg/hand-arrow-down-bold))
(def hand-arrow-down (icon-component svg/hand-arrow-down-regular))
(def hand-arrow-down-light (icon-component svg/hand-arrow-down-light))
(def hand-arrow-down-thin (icon-component svg/hand-arrow-down-thin))
(def hand-arrow-down-fill (icon-component svg/hand-arrow-down-fill))
(def hand-arrow-down-duotone (icon-component svg/hand-arrow-down-duotone))
(def hand-arrow-up-bold (icon-component svg/hand-arrow-up-bold))
(def hand-arrow-up (icon-component svg/hand-arrow-up-regular))
(def hand-arrow-up-light (icon-component svg/hand-arrow-up-light))
(def hand-arrow-up-thin (icon-component svg/hand-arrow-up-thin))
(def hand-arrow-up-fill (icon-component svg/hand-arrow-up-fill))
(def hand-arrow-up-duotone (icon-component svg/hand-arrow-up-duotone))
(def hand-coins-bold (icon-component svg/hand-coins-bold))
(def hand-coins (icon-component svg/hand-coins-regular))
(def hand-coins-light (icon-component svg/hand-coins-light))
(def hand-coins-thin (icon-component svg/hand-coins-thin))
(def hand-coins-fill (icon-component svg/hand-coins-fill))
(def hand-coins-duotone (icon-component svg/hand-coins-duotone))
(def hand-deposit-bold (icon-component svg/hand-deposit-bold))
(def hand-deposit (icon-component svg/hand-deposit-regular))
(def hand-deposit-light (icon-component svg/hand-deposit-light))
(def hand-deposit-thin (icon-component svg/hand-deposit-thin))
(def hand-deposit-fill (icon-component svg/hand-deposit-fill))
(def hand-deposit-duotone (icon-component svg/hand-deposit-duotone))
(def hand-eye-bold (icon-component svg/hand-eye-bold))
(def hand-eye (icon-component svg/hand-eye-regular))
(def hand-eye-light (icon-component svg/hand-eye-light))
(def hand-eye-thin (icon-component svg/hand-eye-thin))
(def hand-eye-fill (icon-component svg/hand-eye-fill))
(def hand-eye-duotone (icon-component svg/hand-eye-duotone))
(def hand-fist-bold (icon-component svg/hand-fist-bold))
(def hand-fist (icon-component svg/hand-fist-regular))
(def hand-fist-light (icon-component svg/hand-fist-light))
(def hand-fist-thin (icon-component svg/hand-fist-thin))
(def hand-fist-fill (icon-component svg/hand-fist-fill))
(def hand-fist-duotone (icon-component svg/hand-fist-duotone))
(def hand-grabbing-bold (icon-component svg/hand-grabbing-bold))
(def hand-grabbing (icon-component svg/hand-grabbing-regular))
(def hand-grabbing-light (icon-component svg/hand-grabbing-light))
(def hand-grabbing-thin (icon-component svg/hand-grabbing-thin))
(def hand-grabbing-fill (icon-component svg/hand-grabbing-fill))
(def hand-grabbing-duotone (icon-component svg/hand-grabbing-duotone))
(def hand-heart-bold (icon-component svg/hand-heart-bold))
(def hand-heart (icon-component svg/hand-heart-regular))
(def hand-heart-light (icon-component svg/hand-heart-light))
(def hand-heart-thin (icon-component svg/hand-heart-thin))
(def hand-heart-fill (icon-component svg/hand-heart-fill))
(def hand-heart-duotone (icon-component svg/hand-heart-duotone))
(def hand-palm-bold (icon-component svg/hand-palm-bold))
(def hand-palm (icon-component svg/hand-palm-regular))
(def hand-palm-light (icon-component svg/hand-palm-light))
(def hand-palm-thin (icon-component svg/hand-palm-thin))
(def hand-palm-fill (icon-component svg/hand-palm-fill))
(def hand-palm-duotone (icon-component svg/hand-palm-duotone))
(def hand-peace-bold (icon-component svg/hand-peace-bold))
(def hand-peace (icon-component svg/hand-peace-regular))
(def hand-peace-light (icon-component svg/hand-peace-light))
(def hand-peace-thin (icon-component svg/hand-peace-thin))
(def hand-peace-fill (icon-component svg/hand-peace-fill))
(def hand-peace-duotone (icon-component svg/hand-peace-duotone))
(def hand-pointing-bold (icon-component svg/hand-pointing-bold))
(def hand-pointing (icon-component svg/hand-pointing-regular))
(def hand-pointing-light (icon-component svg/hand-pointing-light))
(def hand-pointing-thin (icon-component svg/hand-pointing-thin))
(def hand-pointing-fill (icon-component svg/hand-pointing-fill))
(def hand-pointing-duotone (icon-component svg/hand-pointing-duotone))
(def hand-soap-bold (icon-component svg/hand-soap-bold))
(def hand-soap (icon-component svg/hand-soap-regular))
(def hand-soap-light (icon-component svg/hand-soap-light))
(def hand-soap-thin (icon-component svg/hand-soap-thin))
(def hand-soap-fill (icon-component svg/hand-soap-fill))
(def hand-soap-duotone (icon-component svg/hand-soap-duotone))
(def hand-swipe-left-bold (icon-component svg/hand-swipe-left-bold))
(def hand-swipe-left (icon-component svg/hand-swipe-left-regular))
(def hand-swipe-left-light (icon-component svg/hand-swipe-left-light))
(def hand-swipe-left-thin (icon-component svg/hand-swipe-left-thin))
(def hand-swipe-left-fill (icon-component svg/hand-swipe-left-fill))
(def hand-swipe-left-duotone (icon-component svg/hand-swipe-left-duotone))
(def hand-swipe-right-bold (icon-component svg/hand-swipe-right-bold))
(def hand-swipe-right (icon-component svg/hand-swipe-right-regular))
(def hand-swipe-right-light (icon-component svg/hand-swipe-right-light))
(def hand-swipe-right-thin (icon-component svg/hand-swipe-right-thin))
(def hand-swipe-right-fill (icon-component svg/hand-swipe-right-fill))
(def hand-swipe-right-duotone (icon-component svg/hand-swipe-right-duotone))
(def hand-tap-bold (icon-component svg/hand-tap-bold))
(def hand-tap (icon-component svg/hand-tap-regular))
(def hand-tap-light (icon-component svg/hand-tap-light))
(def hand-tap-thin (icon-component svg/hand-tap-thin))
(def hand-tap-fill (icon-component svg/hand-tap-fill))
(def hand-tap-duotone (icon-component svg/hand-tap-duotone))
(def hand-waving-bold (icon-component svg/hand-waving-bold))
(def hand-waving (icon-component svg/hand-waving-regular))
(def hand-waving-light (icon-component svg/hand-waving-light))
(def hand-waving-thin (icon-component svg/hand-waving-thin))
(def hand-waving-fill (icon-component svg/hand-waving-fill))
(def hand-waving-duotone (icon-component svg/hand-waving-duotone))
(def hand-withdraw-bold (icon-component svg/hand-withdraw-bold))
(def hand-withdraw (icon-component svg/hand-withdraw-regular))
(def hand-withdraw-light (icon-component svg/hand-withdraw-light))
(def hand-withdraw-thin (icon-component svg/hand-withdraw-thin))
(def hand-withdraw-fill (icon-component svg/hand-withdraw-fill))
(def hand-withdraw-duotone (icon-component svg/hand-withdraw-duotone))
(def handbag-bold (icon-component svg/handbag-bold))
(def handbag (icon-component svg/handbag-regular))
(def handbag-light (icon-component svg/handbag-light))
(def handbag-thin (icon-component svg/handbag-thin))
(def handbag-fill (icon-component svg/handbag-fill))
(def handbag-duotone (icon-component svg/handbag-duotone))
(def handbag-simple-bold (icon-component svg/handbag-simple-bold))
(def handbag-simple (icon-component svg/handbag-simple-regular))
(def handbag-simple-light (icon-component svg/handbag-simple-light))
(def handbag-simple-thin (icon-component svg/handbag-simple-thin))
(def handbag-simple-fill (icon-component svg/handbag-simple-fill))
(def handbag-simple-duotone (icon-component svg/handbag-simple-duotone))
(def hands-clapping-bold (icon-component svg/hands-clapping-bold))
(def hands-clapping (icon-component svg/hands-clapping-regular))
(def hands-clapping-light (icon-component svg/hands-clapping-light))
(def hands-clapping-thin (icon-component svg/hands-clapping-thin))
(def hands-clapping-fill (icon-component svg/hands-clapping-fill))
(def hands-clapping-duotone (icon-component svg/hands-clapping-duotone))
(def hands-praying-bold (icon-component svg/hands-praying-bold))
(def hands-praying (icon-component svg/hands-praying-regular))
(def hands-praying-light (icon-component svg/hands-praying-light))
(def hands-praying-thin (icon-component svg/hands-praying-thin))
(def hands-praying-fill (icon-component svg/hands-praying-fill))
(def hands-praying-duotone (icon-component svg/hands-praying-duotone))
(def handshake-bold (icon-component svg/handshake-bold))
(def handshake (icon-component svg/handshake-regular))
(def handshake-light (icon-component svg/handshake-light))
(def handshake-thin (icon-component svg/handshake-thin))
(def handshake-fill (icon-component svg/handshake-fill))
(def handshake-duotone (icon-component svg/handshake-duotone))
(def hard-drive-bold (icon-component svg/hard-drive-bold))
(def hard-drive (icon-component svg/hard-drive-regular))
(def hard-drive-light (icon-component svg/hard-drive-light))
(def hard-drive-thin (icon-component svg/hard-drive-thin))
(def hard-drive-fill (icon-component svg/hard-drive-fill))
(def hard-drive-duotone (icon-component svg/hard-drive-duotone))
(def hard-drives-bold (icon-component svg/hard-drives-bold))
(def hard-drives (icon-component svg/hard-drives-regular))
(def hard-drives-light (icon-component svg/hard-drives-light))
(def hard-drives-thin (icon-component svg/hard-drives-thin))
(def hard-drives-fill (icon-component svg/hard-drives-fill))
(def hard-drives-duotone (icon-component svg/hard-drives-duotone))
(def hard-hat-bold (icon-component svg/hard-hat-bold))
(def hard-hat (icon-component svg/hard-hat-regular))
(def hard-hat-light (icon-component svg/hard-hat-light))
(def hard-hat-thin (icon-component svg/hard-hat-thin))
(def hard-hat-fill (icon-component svg/hard-hat-fill))
(def hard-hat-duotone (icon-component svg/hard-hat-duotone))
(def hash-bold (icon-component svg/hash-bold))
(def hash (icon-component svg/hash-regular))
(def hash-light (icon-component svg/hash-light))
(def hash-thin (icon-component svg/hash-thin))
(def hash-fill (icon-component svg/hash-fill))
(def hash-duotone (icon-component svg/hash-duotone))
(def hash-straight-bold (icon-component svg/hash-straight-bold))
(def hash-straight (icon-component svg/hash-straight-regular))
(def hash-straight-light (icon-component svg/hash-straight-light))
(def hash-straight-thin (icon-component svg/hash-straight-thin))
(def hash-straight-fill (icon-component svg/hash-straight-fill))
(def hash-straight-duotone (icon-component svg/hash-straight-duotone))
(def head-circuit-bold (icon-component svg/head-circuit-bold))
(def head-circuit (icon-component svg/head-circuit-regular))
(def head-circuit-light (icon-component svg/head-circuit-light))
(def head-circuit-thin (icon-component svg/head-circuit-thin))
(def head-circuit-fill (icon-component svg/head-circuit-fill))
(def head-circuit-duotone (icon-component svg/head-circuit-duotone))
(def headlights-bold (icon-component svg/headlights-bold))
(def headlights (icon-component svg/headlights-regular))
(def headlights-light (icon-component svg/headlights-light))
(def headlights-thin (icon-component svg/headlights-thin))
(def headlights-fill (icon-component svg/headlights-fill))
(def headlights-duotone (icon-component svg/headlights-duotone))
(def headphones-bold (icon-component svg/headphones-bold))
(def headphones (icon-component svg/headphones-regular))
(def headphones-light (icon-component svg/headphones-light))
(def headphones-thin (icon-component svg/headphones-thin))
(def headphones-fill (icon-component svg/headphones-fill))
(def headphones-duotone (icon-component svg/headphones-duotone))
(def headset-bold (icon-component svg/headset-bold))
(def headset (icon-component svg/headset-regular))
(def headset-light (icon-component svg/headset-light))
(def headset-thin (icon-component svg/headset-thin))
(def headset-fill (icon-component svg/headset-fill))
(def headset-duotone (icon-component svg/headset-duotone))
(def heart-bold (icon-component svg/heart-bold))
(def heart (icon-component svg/heart-regular))
(def heart-light (icon-component svg/heart-light))
(def heart-thin (icon-component svg/heart-thin))
(def heart-fill (icon-component svg/heart-fill))
(def heart-duotone (icon-component svg/heart-duotone))
(def heart-break-bold (icon-component svg/heart-break-bold))
(def heart-break (icon-component svg/heart-break-regular))
(def heart-break-light (icon-component svg/heart-break-light))
(def heart-break-thin (icon-component svg/heart-break-thin))
(def heart-break-fill (icon-component svg/heart-break-fill))
(def heart-break-duotone (icon-component svg/heart-break-duotone))
(def heart-half-bold (icon-component svg/heart-half-bold))
(def heart-half (icon-component svg/heart-half-regular))
(def heart-half-light (icon-component svg/heart-half-light))
(def heart-half-thin (icon-component svg/heart-half-thin))
(def heart-half-fill (icon-component svg/heart-half-fill))
(def heart-half-duotone (icon-component svg/heart-half-duotone))
(def heart-straight-bold (icon-component svg/heart-straight-bold))
(def heart-straight (icon-component svg/heart-straight-regular))
(def heart-straight-light (icon-component svg/heart-straight-light))
(def heart-straight-thin (icon-component svg/heart-straight-thin))
(def heart-straight-fill (icon-component svg/heart-straight-fill))
(def heart-straight-duotone (icon-component svg/heart-straight-duotone))
(def heart-straight-break-bold (icon-component svg/heart-straight-break-bold))
(def heart-straight-break (icon-component svg/heart-straight-break-regular))
(def heart-straight-break-light (icon-component svg/heart-straight-break-light))
(def heart-straight-break-thin (icon-component svg/heart-straight-break-thin))
(def heart-straight-break-fill (icon-component svg/heart-straight-break-fill))
(def heart-straight-break-duotone (icon-component svg/heart-straight-break-duotone))
(def heartbeat-bold (icon-component svg/heartbeat-bold))
(def heartbeat (icon-component svg/heartbeat-regular))
(def heartbeat-light (icon-component svg/heartbeat-light))
(def heartbeat-thin (icon-component svg/heartbeat-thin))
(def heartbeat-fill (icon-component svg/heartbeat-fill))
(def heartbeat-duotone (icon-component svg/heartbeat-duotone))
(def hexagon-bold (icon-component svg/hexagon-bold))
(def hexagon (icon-component svg/hexagon-regular))
(def hexagon-light (icon-component svg/hexagon-light))
(def hexagon-thin (icon-component svg/hexagon-thin))
(def hexagon-fill (icon-component svg/hexagon-fill))
(def hexagon-duotone (icon-component svg/hexagon-duotone))
(def high-definition-bold (icon-component svg/high-definition-bold))
(def high-definition (icon-component svg/high-definition-regular))
(def high-definition-light (icon-component svg/high-definition-light))
(def high-definition-thin (icon-component svg/high-definition-thin))
(def high-definition-fill (icon-component svg/high-definition-fill))
(def high-definition-duotone (icon-component svg/high-definition-duotone))
(def high-heel-bold (icon-component svg/high-heel-bold))
(def high-heel (icon-component svg/high-heel-regular))
(def high-heel-light (icon-component svg/high-heel-light))
(def high-heel-thin (icon-component svg/high-heel-thin))
(def high-heel-fill (icon-component svg/high-heel-fill))
(def high-heel-duotone (icon-component svg/high-heel-duotone))
(def highlighter-bold (icon-component svg/highlighter-bold))
(def highlighter (icon-component svg/highlighter-regular))
(def highlighter-light (icon-component svg/highlighter-light))
(def highlighter-thin (icon-component svg/highlighter-thin))
(def highlighter-fill (icon-component svg/highlighter-fill))
(def highlighter-duotone (icon-component svg/highlighter-duotone))
(def highlighter-circle-bold (icon-component svg/highlighter-circle-bold))
(def highlighter-circle (icon-component svg/highlighter-circle-regular))
(def highlighter-circle-light (icon-component svg/highlighter-circle-light))
(def highlighter-circle-thin (icon-component svg/highlighter-circle-thin))
(def highlighter-circle-fill (icon-component svg/highlighter-circle-fill))
(def highlighter-circle-duotone (icon-component svg/highlighter-circle-duotone))
(def hockey-bold (icon-component svg/hockey-bold))
(def hockey (icon-component svg/hockey-regular))
(def hockey-light (icon-component svg/hockey-light))
(def hockey-thin (icon-component svg/hockey-thin))
(def hockey-fill (icon-component svg/hockey-fill))
(def hockey-duotone (icon-component svg/hockey-duotone))
(def hoodie-bold (icon-component svg/hoodie-bold))
(def hoodie (icon-component svg/hoodie-regular))
(def hoodie-light (icon-component svg/hoodie-light))
(def hoodie-thin (icon-component svg/hoodie-thin))
(def hoodie-fill (icon-component svg/hoodie-fill))
(def hoodie-duotone (icon-component svg/hoodie-duotone))
(def horse-bold (icon-component svg/horse-bold))
(def horse (icon-component svg/horse-regular))
(def horse-light (icon-component svg/horse-light))
(def horse-thin (icon-component svg/horse-thin))
(def horse-fill (icon-component svg/horse-fill))
(def horse-duotone (icon-component svg/horse-duotone))
(def hospital-bold (icon-component svg/hospital-bold))
(def hospital (icon-component svg/hospital-regular))
(def hospital-light (icon-component svg/hospital-light))
(def hospital-thin (icon-component svg/hospital-thin))
(def hospital-fill (icon-component svg/hospital-fill))
(def hospital-duotone (icon-component svg/hospital-duotone))
(def hourglass-bold (icon-component svg/hourglass-bold))
(def hourglass (icon-component svg/hourglass-regular))
(def hourglass-light (icon-component svg/hourglass-light))
(def hourglass-thin (icon-component svg/hourglass-thin))
(def hourglass-fill (icon-component svg/hourglass-fill))
(def hourglass-duotone (icon-component svg/hourglass-duotone))
(def hourglass-high-bold (icon-component svg/hourglass-high-bold))
(def hourglass-high (icon-component svg/hourglass-high-regular))
(def hourglass-high-light (icon-component svg/hourglass-high-light))
(def hourglass-high-thin (icon-component svg/hourglass-high-thin))
(def hourglass-high-fill (icon-component svg/hourglass-high-fill))
(def hourglass-high-duotone (icon-component svg/hourglass-high-duotone))
(def hourglass-low-bold (icon-component svg/hourglass-low-bold))
(def hourglass-low (icon-component svg/hourglass-low-regular))
(def hourglass-low-light (icon-component svg/hourglass-low-light))
(def hourglass-low-thin (icon-component svg/hourglass-low-thin))
(def hourglass-low-fill (icon-component svg/hourglass-low-fill))
(def hourglass-low-duotone (icon-component svg/hourglass-low-duotone))
(def hourglass-medium-bold (icon-component svg/hourglass-medium-bold))
(def hourglass-medium (icon-component svg/hourglass-medium-regular))
(def hourglass-medium-light (icon-component svg/hourglass-medium-light))
(def hourglass-medium-thin (icon-component svg/hourglass-medium-thin))
(def hourglass-medium-fill (icon-component svg/hourglass-medium-fill))
(def hourglass-medium-duotone (icon-component svg/hourglass-medium-duotone))
(def hourglass-simple-bold (icon-component svg/hourglass-simple-bold))
(def hourglass-simple (icon-component svg/hourglass-simple-regular))
(def hourglass-simple-light (icon-component svg/hourglass-simple-light))
(def hourglass-simple-thin (icon-component svg/hourglass-simple-thin))
(def hourglass-simple-fill (icon-component svg/hourglass-simple-fill))
(def hourglass-simple-duotone (icon-component svg/hourglass-simple-duotone))
(def hourglass-simple-high-bold (icon-component svg/hourglass-simple-high-bold))
(def hourglass-simple-high (icon-component svg/hourglass-simple-high-regular))
(def hourglass-simple-high-light (icon-component svg/hourglass-simple-high-light))
(def hourglass-simple-high-thin (icon-component svg/hourglass-simple-high-thin))
(def hourglass-simple-high-fill (icon-component svg/hourglass-simple-high-fill))
(def hourglass-simple-high-duotone (icon-component svg/hourglass-simple-high-duotone))
(def hourglass-simple-low-bold (icon-component svg/hourglass-simple-low-bold))
(def hourglass-simple-low (icon-component svg/hourglass-simple-low-regular))
(def hourglass-simple-low-light (icon-component svg/hourglass-simple-low-light))
(def hourglass-simple-low-thin (icon-component svg/hourglass-simple-low-thin))
(def hourglass-simple-low-fill (icon-component svg/hourglass-simple-low-fill))
(def hourglass-simple-low-duotone (icon-component svg/hourglass-simple-low-duotone))
(def hourglass-simple-medium-bold (icon-component svg/hourglass-simple-medium-bold))
(def hourglass-simple-medium (icon-component svg/hourglass-simple-medium-regular))
(def hourglass-simple-medium-light (icon-component svg/hourglass-simple-medium-light))
(def hourglass-simple-medium-thin (icon-component svg/hourglass-simple-medium-thin))
(def hourglass-simple-medium-fill (icon-component svg/hourglass-simple-medium-fill))
(def hourglass-simple-medium-duotone (icon-component svg/hourglass-simple-medium-duotone))
(def house-bold (icon-component svg/house-bold))
(def house (icon-component svg/house-regular))
(def house-light (icon-component svg/house-light))
(def house-thin (icon-component svg/house-thin))
(def house-fill (icon-component svg/house-fill))
(def house-duotone (icon-component svg/house-duotone))
(def house-line-bold (icon-component svg/house-line-bold))
(def house-line (icon-component svg/house-line-regular))
(def house-line-light (icon-component svg/house-line-light))
(def house-line-thin (icon-component svg/house-line-thin))
(def house-line-fill (icon-component svg/house-line-fill))
(def house-line-duotone (icon-component svg/house-line-duotone))
(def house-simple-bold (icon-component svg/house-simple-bold))
(def house-simple (icon-component svg/house-simple-regular))
(def house-simple-light (icon-component svg/house-simple-light))
(def house-simple-thin (icon-component svg/house-simple-thin))
(def house-simple-fill (icon-component svg/house-simple-fill))
(def house-simple-duotone (icon-component svg/house-simple-duotone))
(def hurricane-bold (icon-component svg/hurricane-bold))
(def hurricane (icon-component svg/hurricane-regular))
(def hurricane-light (icon-component svg/hurricane-light))
(def hurricane-thin (icon-component svg/hurricane-thin))
(def hurricane-fill (icon-component svg/hurricane-fill))
(def hurricane-duotone (icon-component svg/hurricane-duotone))
(def ice-cream-bold (icon-component svg/ice-cream-bold))
(def ice-cream (icon-component svg/ice-cream-regular))
(def ice-cream-light (icon-component svg/ice-cream-light))
(def ice-cream-thin (icon-component svg/ice-cream-thin))
(def ice-cream-fill (icon-component svg/ice-cream-fill))
(def ice-cream-duotone (icon-component svg/ice-cream-duotone))
(def identification-badge-bold (icon-component svg/identification-badge-bold))
(def identification-badge (icon-component svg/identification-badge-regular))
(def identification-badge-light (icon-component svg/identification-badge-light))
(def identification-badge-thin (icon-component svg/identification-badge-thin))
(def identification-badge-fill (icon-component svg/identification-badge-fill))
(def identification-badge-duotone (icon-component svg/identification-badge-duotone))
(def identification-card-bold (icon-component svg/identification-card-bold))
(def identification-card (icon-component svg/identification-card-regular))
(def identification-card-light (icon-component svg/identification-card-light))
(def identification-card-thin (icon-component svg/identification-card-thin))
(def identification-card-fill (icon-component svg/identification-card-fill))
(def identification-card-duotone (icon-component svg/identification-card-duotone))
(def image-bold (icon-component svg/image-bold))
(def image (icon-component svg/image-regular))
(def image-light (icon-component svg/image-light))
(def image-thin (icon-component svg/image-thin))
(def image-fill (icon-component svg/image-fill))
(def image-duotone (icon-component svg/image-duotone))
(def image-broken-bold (icon-component svg/image-broken-bold))
(def image-broken (icon-component svg/image-broken-regular))
(def image-broken-light (icon-component svg/image-broken-light))
(def image-broken-thin (icon-component svg/image-broken-thin))
(def image-broken-fill (icon-component svg/image-broken-fill))
(def image-broken-duotone (icon-component svg/image-broken-duotone))
(def image-square-bold (icon-component svg/image-square-bold))
(def image-square (icon-component svg/image-square-regular))
(def image-square-light (icon-component svg/image-square-light))
(def image-square-thin (icon-component svg/image-square-thin))
(def image-square-fill (icon-component svg/image-square-fill))
(def image-square-duotone (icon-component svg/image-square-duotone))
(def images-bold (icon-component svg/images-bold))
(def images (icon-component svg/images-regular))
(def images-light (icon-component svg/images-light))
(def images-thin (icon-component svg/images-thin))
(def images-fill (icon-component svg/images-fill))
(def images-duotone (icon-component svg/images-duotone))
(def images-square-bold (icon-component svg/images-square-bold))
(def images-square (icon-component svg/images-square-regular))
(def images-square-light (icon-component svg/images-square-light))
(def images-square-thin (icon-component svg/images-square-thin))
(def images-square-fill (icon-component svg/images-square-fill))
(def images-square-duotone (icon-component svg/images-square-duotone))
(def infinity-bold (icon-component svg/infinity-bold))
(def infinity (icon-component svg/infinity-regular))
(def infinity-light (icon-component svg/infinity-light))
(def infinity-thin (icon-component svg/infinity-thin))
(def infinity-fill (icon-component svg/infinity-fill))
(def infinity-duotone (icon-component svg/infinity-duotone))
(def info-bold (icon-component svg/info-bold))
(def info (icon-component svg/info-regular))
(def info-light (icon-component svg/info-light))
(def info-thin (icon-component svg/info-thin))
(def info-fill (icon-component svg/info-fill))
(def info-duotone (icon-component svg/info-duotone))
(def instagram-logo-bold (icon-component svg/instagram-logo-bold))
(def instagram-logo (icon-component svg/instagram-logo-regular))
(def instagram-logo-light (icon-component svg/instagram-logo-light))
(def instagram-logo-thin (icon-component svg/instagram-logo-thin))
(def instagram-logo-fill (icon-component svg/instagram-logo-fill))
(def instagram-logo-duotone (icon-component svg/instagram-logo-duotone))
(def intersect-bold (icon-component svg/intersect-bold))
(def intersect (icon-component svg/intersect-regular))
(def intersect-light (icon-component svg/intersect-light))
(def intersect-thin (icon-component svg/intersect-thin))
(def intersect-fill (icon-component svg/intersect-fill))
(def intersect-duotone (icon-component svg/intersect-duotone))
(def intersect-square-bold (icon-component svg/intersect-square-bold))
(def intersect-square (icon-component svg/intersect-square-regular))
(def intersect-square-light (icon-component svg/intersect-square-light))
(def intersect-square-thin (icon-component svg/intersect-square-thin))
(def intersect-square-fill (icon-component svg/intersect-square-fill))
(def intersect-square-duotone (icon-component svg/intersect-square-duotone))
(def intersect-three-bold (icon-component svg/intersect-three-bold))
(def intersect-three (icon-component svg/intersect-three-regular))
(def intersect-three-light (icon-component svg/intersect-three-light))
(def intersect-three-thin (icon-component svg/intersect-three-thin))
(def intersect-three-fill (icon-component svg/intersect-three-fill))
(def intersect-three-duotone (icon-component svg/intersect-three-duotone))
(def intersection-bold (icon-component svg/intersection-bold))
(def intersection (icon-component svg/intersection-regular))
(def intersection-light (icon-component svg/intersection-light))
(def intersection-thin (icon-component svg/intersection-thin))
(def intersection-fill (icon-component svg/intersection-fill))
(def intersection-duotone (icon-component svg/intersection-duotone))
(def invoice-bold (icon-component svg/invoice-bold))
(def invoice (icon-component svg/invoice-regular))
(def invoice-light (icon-component svg/invoice-light))
(def invoice-thin (icon-component svg/invoice-thin))
(def invoice-fill (icon-component svg/invoice-fill))
(def invoice-duotone (icon-component svg/invoice-duotone))
(def island-bold (icon-component svg/island-bold))
(def island (icon-component svg/island-regular))
(def island-light (icon-component svg/island-light))
(def island-thin (icon-component svg/island-thin))
(def island-fill (icon-component svg/island-fill))
(def island-duotone (icon-component svg/island-duotone))
(def jar-bold (icon-component svg/jar-bold))
(def jar (icon-component svg/jar-regular))
(def jar-light (icon-component svg/jar-light))
(def jar-thin (icon-component svg/jar-thin))
(def jar-fill (icon-component svg/jar-fill))
(def jar-duotone (icon-component svg/jar-duotone))
(def jar-label-bold (icon-component svg/jar-label-bold))
(def jar-label (icon-component svg/jar-label-regular))
(def jar-label-light (icon-component svg/jar-label-light))
(def jar-label-thin (icon-component svg/jar-label-thin))
(def jar-label-fill (icon-component svg/jar-label-fill))
(def jar-label-duotone (icon-component svg/jar-label-duotone))
(def jeep-bold (icon-component svg/jeep-bold))
(def jeep (icon-component svg/jeep-regular))
(def jeep-light (icon-component svg/jeep-light))
(def jeep-thin (icon-component svg/jeep-thin))
(def jeep-fill (icon-component svg/jeep-fill))
(def jeep-duotone (icon-component svg/jeep-duotone))
(def joystick-bold (icon-component svg/joystick-bold))
(def joystick (icon-component svg/joystick-regular))
(def joystick-light (icon-component svg/joystick-light))
(def joystick-thin (icon-component svg/joystick-thin))
(def joystick-fill (icon-component svg/joystick-fill))
(def joystick-duotone (icon-component svg/joystick-duotone))
(def kanban-bold (icon-component svg/kanban-bold))
(def kanban (icon-component svg/kanban-regular))
(def kanban-light (icon-component svg/kanban-light))
(def kanban-thin (icon-component svg/kanban-thin))
(def kanban-fill (icon-component svg/kanban-fill))
(def kanban-duotone (icon-component svg/kanban-duotone))
(def key-bold (icon-component svg/key-bold))
(def key (icon-component svg/key-regular))
(def key-light (icon-component svg/key-light))
(def key-thin (icon-component svg/key-thin))
(def key-fill (icon-component svg/key-fill))
(def key-duotone (icon-component svg/key-duotone))
(def key-return-bold (icon-component svg/key-return-bold))
(def key-return (icon-component svg/key-return-regular))
(def key-return-light (icon-component svg/key-return-light))
(def key-return-thin (icon-component svg/key-return-thin))
(def key-return-fill (icon-component svg/key-return-fill))
(def key-return-duotone (icon-component svg/key-return-duotone))
(def keyboard-bold (icon-component svg/keyboard-bold))
(def keyboard (icon-component svg/keyboard-regular))
(def keyboard-light (icon-component svg/keyboard-light))
(def keyboard-thin (icon-component svg/keyboard-thin))
(def keyboard-fill (icon-component svg/keyboard-fill))
(def keyboard-duotone (icon-component svg/keyboard-duotone))
(def keyhole-bold (icon-component svg/keyhole-bold))
(def keyhole (icon-component svg/keyhole-regular))
(def keyhole-light (icon-component svg/keyhole-light))
(def keyhole-thin (icon-component svg/keyhole-thin))
(def keyhole-fill (icon-component svg/keyhole-fill))
(def keyhole-duotone (icon-component svg/keyhole-duotone))
(def knife-bold (icon-component svg/knife-bold))
(def knife (icon-component svg/knife-regular))
(def knife-light (icon-component svg/knife-light))
(def knife-thin (icon-component svg/knife-thin))
(def knife-fill (icon-component svg/knife-fill))
(def knife-duotone (icon-component svg/knife-duotone))
(def ladder-bold (icon-component svg/ladder-bold))
(def ladder (icon-component svg/ladder-regular))
(def ladder-light (icon-component svg/ladder-light))
(def ladder-thin (icon-component svg/ladder-thin))
(def ladder-fill (icon-component svg/ladder-fill))
(def ladder-duotone (icon-component svg/ladder-duotone))
(def ladder-simple-bold (icon-component svg/ladder-simple-bold))
(def ladder-simple (icon-component svg/ladder-simple-regular))
(def ladder-simple-light (icon-component svg/ladder-simple-light))
(def ladder-simple-thin (icon-component svg/ladder-simple-thin))
(def ladder-simple-fill (icon-component svg/ladder-simple-fill))
(def ladder-simple-duotone (icon-component svg/ladder-simple-duotone))
(def lamp-bold (icon-component svg/lamp-bold))
(def lamp (icon-component svg/lamp-regular))
(def lamp-light (icon-component svg/lamp-light))
(def lamp-thin (icon-component svg/lamp-thin))
(def lamp-fill (icon-component svg/lamp-fill))
(def lamp-duotone (icon-component svg/lamp-duotone))
(def lamp-pendant-bold (icon-component svg/lamp-pendant-bold))
(def lamp-pendant (icon-component svg/lamp-pendant-regular))
(def lamp-pendant-light (icon-component svg/lamp-pendant-light))
(def lamp-pendant-thin (icon-component svg/lamp-pendant-thin))
(def lamp-pendant-fill (icon-component svg/lamp-pendant-fill))
(def lamp-pendant-duotone (icon-component svg/lamp-pendant-duotone))
(def laptop-bold (icon-component svg/laptop-bold))
(def laptop (icon-component svg/laptop-regular))
(def laptop-light (icon-component svg/laptop-light))
(def laptop-thin (icon-component svg/laptop-thin))
(def laptop-fill (icon-component svg/laptop-fill))
(def laptop-duotone (icon-component svg/laptop-duotone))
(def lasso-bold (icon-component svg/lasso-bold))
(def lasso (icon-component svg/lasso-regular))
(def lasso-light (icon-component svg/lasso-light))
(def lasso-thin (icon-component svg/lasso-thin))
(def lasso-fill (icon-component svg/lasso-fill))
(def lasso-duotone (icon-component svg/lasso-duotone))
(def lastfm-logo-bold (icon-component svg/lastfm-logo-bold))
(def lastfm-logo (icon-component svg/lastfm-logo-regular))
(def lastfm-logo-light (icon-component svg/lastfm-logo-light))
(def lastfm-logo-thin (icon-component svg/lastfm-logo-thin))
(def lastfm-logo-fill (icon-component svg/lastfm-logo-fill))
(def lastfm-logo-duotone (icon-component svg/lastfm-logo-duotone))
(def layout-bold (icon-component svg/layout-bold))
(def layout (icon-component svg/layout-regular))
(def layout-light (icon-component svg/layout-light))
(def layout-thin (icon-component svg/layout-thin))
(def layout-fill (icon-component svg/layout-fill))
(def layout-duotone (icon-component svg/layout-duotone))
(def leaf-bold (icon-component svg/leaf-bold))
(def leaf (icon-component svg/leaf-regular))
(def leaf-light (icon-component svg/leaf-light))
(def leaf-thin (icon-component svg/leaf-thin))
(def leaf-fill (icon-component svg/leaf-fill))
(def leaf-duotone (icon-component svg/leaf-duotone))
(def lectern-bold (icon-component svg/lectern-bold))
(def lectern (icon-component svg/lectern-regular))
(def lectern-light (icon-component svg/lectern-light))
(def lectern-thin (icon-component svg/lectern-thin))
(def lectern-fill (icon-component svg/lectern-fill))
(def lectern-duotone (icon-component svg/lectern-duotone))
(def lego-bold (icon-component svg/lego-bold))
(def lego (icon-component svg/lego-regular))
(def lego-light (icon-component svg/lego-light))
(def lego-thin (icon-component svg/lego-thin))
(def lego-fill (icon-component svg/lego-fill))
(def lego-duotone (icon-component svg/lego-duotone))
(def lego-smiley-bold (icon-component svg/lego-smiley-bold))
(def lego-smiley (icon-component svg/lego-smiley-regular))
(def lego-smiley-light (icon-component svg/lego-smiley-light))
(def lego-smiley-thin (icon-component svg/lego-smiley-thin))
(def lego-smiley-fill (icon-component svg/lego-smiley-fill))
(def lego-smiley-duotone (icon-component svg/lego-smiley-duotone))
(def less-than-bold (icon-component svg/less-than-bold))
(def less-than (icon-component svg/less-than-regular))
(def less-than-light (icon-component svg/less-than-light))
(def less-than-thin (icon-component svg/less-than-thin))
(def less-than-fill (icon-component svg/less-than-fill))
(def less-than-duotone (icon-component svg/less-than-duotone))
(def less-than-or-equal-bold (icon-component svg/less-than-or-equal-bold))
(def less-than-or-equal (icon-component svg/less-than-or-equal-regular))
(def less-than-or-equal-light (icon-component svg/less-than-or-equal-light))
(def less-than-or-equal-thin (icon-component svg/less-than-or-equal-thin))
(def less-than-or-equal-fill (icon-component svg/less-than-or-equal-fill))
(def less-than-or-equal-duotone (icon-component svg/less-than-or-equal-duotone))
(def letter-circle-h-bold (icon-component svg/letter-circle-h-bold))
(def letter-circle-h (icon-component svg/letter-circle-h-regular))
(def letter-circle-h-light (icon-component svg/letter-circle-h-light))
(def letter-circle-h-thin (icon-component svg/letter-circle-h-thin))
(def letter-circle-h-fill (icon-component svg/letter-circle-h-fill))
(def letter-circle-h-duotone (icon-component svg/letter-circle-h-duotone))
(def letter-circle-p-bold (icon-component svg/letter-circle-p-bold))
(def letter-circle-p (icon-component svg/letter-circle-p-regular))
(def letter-circle-p-light (icon-component svg/letter-circle-p-light))
(def letter-circle-p-thin (icon-component svg/letter-circle-p-thin))
(def letter-circle-p-fill (icon-component svg/letter-circle-p-fill))
(def letter-circle-p-duotone (icon-component svg/letter-circle-p-duotone))
(def letter-circle-v-bold (icon-component svg/letter-circle-v-bold))
(def letter-circle-v (icon-component svg/letter-circle-v-regular))
(def letter-circle-v-light (icon-component svg/letter-circle-v-light))
(def letter-circle-v-thin (icon-component svg/letter-circle-v-thin))
(def letter-circle-v-fill (icon-component svg/letter-circle-v-fill))
(def letter-circle-v-duotone (icon-component svg/letter-circle-v-duotone))
(def lifebuoy-bold (icon-component svg/lifebuoy-bold))
(def lifebuoy (icon-component svg/lifebuoy-regular))
(def lifebuoy-light (icon-component svg/lifebuoy-light))
(def lifebuoy-thin (icon-component svg/lifebuoy-thin))
(def lifebuoy-fill (icon-component svg/lifebuoy-fill))
(def lifebuoy-duotone (icon-component svg/lifebuoy-duotone))
(def lightbulb-bold (icon-component svg/lightbulb-bold))
(def lightbulb (icon-component svg/lightbulb-regular))
(def lightbulb-light (icon-component svg/lightbulb-light))
(def lightbulb-thin (icon-component svg/lightbulb-thin))
(def lightbulb-fill (icon-component svg/lightbulb-fill))
(def lightbulb-duotone (icon-component svg/lightbulb-duotone))
(def lightbulb-filament-bold (icon-component svg/lightbulb-filament-bold))
(def lightbulb-filament (icon-component svg/lightbulb-filament-regular))
(def lightbulb-filament-light (icon-component svg/lightbulb-filament-light))
(def lightbulb-filament-thin (icon-component svg/lightbulb-filament-thin))
(def lightbulb-filament-fill (icon-component svg/lightbulb-filament-fill))
(def lightbulb-filament-duotone (icon-component svg/lightbulb-filament-duotone))
(def lighthouse-bold (icon-component svg/lighthouse-bold))
(def lighthouse (icon-component svg/lighthouse-regular))
(def lighthouse-light (icon-component svg/lighthouse-light))
(def lighthouse-thin (icon-component svg/lighthouse-thin))
(def lighthouse-fill (icon-component svg/lighthouse-fill))
(def lighthouse-duotone (icon-component svg/lighthouse-duotone))
(def lightning-bold (icon-component svg/lightning-bold))
(def lightning (icon-component svg/lightning-regular))
(def lightning-light (icon-component svg/lightning-light))
(def lightning-thin (icon-component svg/lightning-thin))
(def lightning-fill (icon-component svg/lightning-fill))
(def lightning-duotone (icon-component svg/lightning-duotone))
(def lightning-a-bold (icon-component svg/lightning-a-bold))
(def lightning-a (icon-component svg/lightning-a-regular))
(def lightning-a-light (icon-component svg/lightning-a-light))
(def lightning-a-thin (icon-component svg/lightning-a-thin))
(def lightning-a-fill (icon-component svg/lightning-a-fill))
(def lightning-a-duotone (icon-component svg/lightning-a-duotone))
(def lightning-slash-bold (icon-component svg/lightning-slash-bold))
(def lightning-slash (icon-component svg/lightning-slash-regular))
(def lightning-slash-light (icon-component svg/lightning-slash-light))
(def lightning-slash-thin (icon-component svg/lightning-slash-thin))
(def lightning-slash-fill (icon-component svg/lightning-slash-fill))
(def lightning-slash-duotone (icon-component svg/lightning-slash-duotone))
(def line-segment-bold (icon-component svg/line-segment-bold))
(def line-segment (icon-component svg/line-segment-regular))
(def line-segment-light (icon-component svg/line-segment-light))
(def line-segment-thin (icon-component svg/line-segment-thin))
(def line-segment-fill (icon-component svg/line-segment-fill))
(def line-segment-duotone (icon-component svg/line-segment-duotone))
(def line-segments-bold (icon-component svg/line-segments-bold))
(def line-segments (icon-component svg/line-segments-regular))
(def line-segments-light (icon-component svg/line-segments-light))
(def line-segments-thin (icon-component svg/line-segments-thin))
(def line-segments-fill (icon-component svg/line-segments-fill))
(def line-segments-duotone (icon-component svg/line-segments-duotone))
(def line-vertical-bold (icon-component svg/line-vertical-bold))
(def line-vertical (icon-component svg/line-vertical-regular))
(def line-vertical-light (icon-component svg/line-vertical-light))
(def line-vertical-thin (icon-component svg/line-vertical-thin))
(def line-vertical-fill (icon-component svg/line-vertical-fill))
(def line-vertical-duotone (icon-component svg/line-vertical-duotone))
(def link-bold (icon-component svg/link-bold))
(def link (icon-component svg/link-regular))
(def link-light (icon-component svg/link-light))
(def link-thin (icon-component svg/link-thin))
(def link-fill (icon-component svg/link-fill))
(def link-duotone (icon-component svg/link-duotone))
(def link-break-bold (icon-component svg/link-break-bold))
(def link-break (icon-component svg/link-break-regular))
(def link-break-light (icon-component svg/link-break-light))
(def link-break-thin (icon-component svg/link-break-thin))
(def link-break-fill (icon-component svg/link-break-fill))
(def link-break-duotone (icon-component svg/link-break-duotone))
(def link-simple-bold (icon-component svg/link-simple-bold))
(def link-simple (icon-component svg/link-simple-regular))
(def link-simple-light (icon-component svg/link-simple-light))
(def link-simple-thin (icon-component svg/link-simple-thin))
(def link-simple-fill (icon-component svg/link-simple-fill))
(def link-simple-duotone (icon-component svg/link-simple-duotone))
(def link-simple-break-bold (icon-component svg/link-simple-break-bold))
(def link-simple-break (icon-component svg/link-simple-break-regular))
(def link-simple-break-light (icon-component svg/link-simple-break-light))
(def link-simple-break-thin (icon-component svg/link-simple-break-thin))
(def link-simple-break-fill (icon-component svg/link-simple-break-fill))
(def link-simple-break-duotone (icon-component svg/link-simple-break-duotone))
(def link-simple-horizontal-bold (icon-component svg/link-simple-horizontal-bold))
(def link-simple-horizontal (icon-component svg/link-simple-horizontal-regular))
(def link-simple-horizontal-light (icon-component svg/link-simple-horizontal-light))
(def link-simple-horizontal-thin (icon-component svg/link-simple-horizontal-thin))
(def link-simple-horizontal-fill (icon-component svg/link-simple-horizontal-fill))
(def link-simple-horizontal-duotone (icon-component svg/link-simple-horizontal-duotone))
(def link-simple-horizontal-break-bold (icon-component svg/link-simple-horizontal-break-bold))
(def link-simple-horizontal-break (icon-component svg/link-simple-horizontal-break-regular))
(def link-simple-horizontal-break-light (icon-component svg/link-simple-horizontal-break-light))
(def link-simple-horizontal-break-thin (icon-component svg/link-simple-horizontal-break-thin))
(def link-simple-horizontal-break-fill (icon-component svg/link-simple-horizontal-break-fill))
(def link-simple-horizontal-break-duotone (icon-component svg/link-simple-horizontal-break-duotone))
(def linkedin-logo-bold (icon-component svg/linkedin-logo-bold))
(def linkedin-logo (icon-component svg/linkedin-logo-regular))
(def linkedin-logo-light (icon-component svg/linkedin-logo-light))
(def linkedin-logo-thin (icon-component svg/linkedin-logo-thin))
(def linkedin-logo-fill (icon-component svg/linkedin-logo-fill))
(def linkedin-logo-duotone (icon-component svg/linkedin-logo-duotone))
(def linktree-logo-bold (icon-component svg/linktree-logo-bold))
(def linktree-logo (icon-component svg/linktree-logo-regular))
(def linktree-logo-light (icon-component svg/linktree-logo-light))
(def linktree-logo-thin (icon-component svg/linktree-logo-thin))
(def linktree-logo-fill (icon-component svg/linktree-logo-fill))
(def linktree-logo-duotone (icon-component svg/linktree-logo-duotone))
(def linux-logo-bold (icon-component svg/linux-logo-bold))
(def linux-logo (icon-component svg/linux-logo-regular))
(def linux-logo-light (icon-component svg/linux-logo-light))
(def linux-logo-thin (icon-component svg/linux-logo-thin))
(def linux-logo-fill (icon-component svg/linux-logo-fill))
(def linux-logo-duotone (icon-component svg/linux-logo-duotone))
(def list-bold (icon-component svg/list-bold))
(def list (icon-component svg/list-regular))
(def list-light (icon-component svg/list-light))
(def list-thin (icon-component svg/list-thin))
(def list-fill (icon-component svg/list-fill))
(def list-duotone (icon-component svg/list-duotone))
(def list-bullets-bold (icon-component svg/list-bullets-bold))
(def list-bullets (icon-component svg/list-bullets-regular))
(def list-bullets-light (icon-component svg/list-bullets-light))
(def list-bullets-thin (icon-component svg/list-bullets-thin))
(def list-bullets-fill (icon-component svg/list-bullets-fill))
(def list-bullets-duotone (icon-component svg/list-bullets-duotone))
(def list-checks-bold (icon-component svg/list-checks-bold))
(def list-checks (icon-component svg/list-checks-regular))
(def list-checks-light (icon-component svg/list-checks-light))
(def list-checks-thin (icon-component svg/list-checks-thin))
(def list-checks-fill (icon-component svg/list-checks-fill))
(def list-checks-duotone (icon-component svg/list-checks-duotone))
(def list-dashes-bold (icon-component svg/list-dashes-bold))
(def list-dashes (icon-component svg/list-dashes-regular))
(def list-dashes-light (icon-component svg/list-dashes-light))
(def list-dashes-thin (icon-component svg/list-dashes-thin))
(def list-dashes-fill (icon-component svg/list-dashes-fill))
(def list-dashes-duotone (icon-component svg/list-dashes-duotone))
(def list-heart-bold (icon-component svg/list-heart-bold))
(def list-heart (icon-component svg/list-heart-regular))
(def list-heart-light (icon-component svg/list-heart-light))
(def list-heart-thin (icon-component svg/list-heart-thin))
(def list-heart-fill (icon-component svg/list-heart-fill))
(def list-heart-duotone (icon-component svg/list-heart-duotone))
(def list-magnifying-glass-bold (icon-component svg/list-magnifying-glass-bold))
(def list-magnifying-glass (icon-component svg/list-magnifying-glass-regular))
(def list-magnifying-glass-light (icon-component svg/list-magnifying-glass-light))
(def list-magnifying-glass-thin (icon-component svg/list-magnifying-glass-thin))
(def list-magnifying-glass-fill (icon-component svg/list-magnifying-glass-fill))
(def list-magnifying-glass-duotone (icon-component svg/list-magnifying-glass-duotone))
(def list-numbers-bold (icon-component svg/list-numbers-bold))
(def list-numbers (icon-component svg/list-numbers-regular))
(def list-numbers-light (icon-component svg/list-numbers-light))
(def list-numbers-thin (icon-component svg/list-numbers-thin))
(def list-numbers-fill (icon-component svg/list-numbers-fill))
(def list-numbers-duotone (icon-component svg/list-numbers-duotone))
(def list-plus-bold (icon-component svg/list-plus-bold))
(def list-plus (icon-component svg/list-plus-regular))
(def list-plus-light (icon-component svg/list-plus-light))
(def list-plus-thin (icon-component svg/list-plus-thin))
(def list-plus-fill (icon-component svg/list-plus-fill))
(def list-plus-duotone (icon-component svg/list-plus-duotone))
(def list-star-bold (icon-component svg/list-star-bold))
(def list-star (icon-component svg/list-star-regular))
(def list-star-light (icon-component svg/list-star-light))
(def list-star-thin (icon-component svg/list-star-thin))
(def list-star-fill (icon-component svg/list-star-fill))
(def list-star-duotone (icon-component svg/list-star-duotone))
(def lock-bold (icon-component svg/lock-bold))
(def lock (icon-component svg/lock-regular))
(def lock-light (icon-component svg/lock-light))
(def lock-thin (icon-component svg/lock-thin))
(def lock-fill (icon-component svg/lock-fill))
(def lock-duotone (icon-component svg/lock-duotone))
(def lock-key-bold (icon-component svg/lock-key-bold))
(def lock-key (icon-component svg/lock-key-regular))
(def lock-key-light (icon-component svg/lock-key-light))
(def lock-key-thin (icon-component svg/lock-key-thin))
(def lock-key-fill (icon-component svg/lock-key-fill))
(def lock-key-duotone (icon-component svg/lock-key-duotone))
(def lock-key-open-bold (icon-component svg/lock-key-open-bold))
(def lock-key-open (icon-component svg/lock-key-open-regular))
(def lock-key-open-light (icon-component svg/lock-key-open-light))
(def lock-key-open-thin (icon-component svg/lock-key-open-thin))
(def lock-key-open-fill (icon-component svg/lock-key-open-fill))
(def lock-key-open-duotone (icon-component svg/lock-key-open-duotone))
(def lock-laminated-bold (icon-component svg/lock-laminated-bold))
(def lock-laminated (icon-component svg/lock-laminated-regular))
(def lock-laminated-light (icon-component svg/lock-laminated-light))
(def lock-laminated-thin (icon-component svg/lock-laminated-thin))
(def lock-laminated-fill (icon-component svg/lock-laminated-fill))
(def lock-laminated-duotone (icon-component svg/lock-laminated-duotone))
(def lock-laminated-open-bold (icon-component svg/lock-laminated-open-bold))
(def lock-laminated-open (icon-component svg/lock-laminated-open-regular))
(def lock-laminated-open-light (icon-component svg/lock-laminated-open-light))
(def lock-laminated-open-thin (icon-component svg/lock-laminated-open-thin))
(def lock-laminated-open-fill (icon-component svg/lock-laminated-open-fill))
(def lock-laminated-open-duotone (icon-component svg/lock-laminated-open-duotone))
(def lock-open-bold (icon-component svg/lock-open-bold))
(def lock-open (icon-component svg/lock-open-regular))
(def lock-open-light (icon-component svg/lock-open-light))
(def lock-open-thin (icon-component svg/lock-open-thin))
(def lock-open-fill (icon-component svg/lock-open-fill))
(def lock-open-duotone (icon-component svg/lock-open-duotone))
(def lock-simple-bold (icon-component svg/lock-simple-bold))
(def lock-simple (icon-component svg/lock-simple-regular))
(def lock-simple-light (icon-component svg/lock-simple-light))
(def lock-simple-thin (icon-component svg/lock-simple-thin))
(def lock-simple-fill (icon-component svg/lock-simple-fill))
(def lock-simple-duotone (icon-component svg/lock-simple-duotone))
(def lock-simple-open-bold (icon-component svg/lock-simple-open-bold))
(def lock-simple-open (icon-component svg/lock-simple-open-regular))
(def lock-simple-open-light (icon-component svg/lock-simple-open-light))
(def lock-simple-open-thin (icon-component svg/lock-simple-open-thin))
(def lock-simple-open-fill (icon-component svg/lock-simple-open-fill))
(def lock-simple-open-duotone (icon-component svg/lock-simple-open-duotone))
(def lockers-bold (icon-component svg/lockers-bold))
(def lockers (icon-component svg/lockers-regular))
(def lockers-light (icon-component svg/lockers-light))
(def lockers-thin (icon-component svg/lockers-thin))
(def lockers-fill (icon-component svg/lockers-fill))
(def lockers-duotone (icon-component svg/lockers-duotone))
(def log-bold (icon-component svg/log-bold))
(def log (icon-component svg/log-regular))
(def log-light (icon-component svg/log-light))
(def log-thin (icon-component svg/log-thin))
(def log-fill (icon-component svg/log-fill))
(def log-duotone (icon-component svg/log-duotone))
(def magic-wand-bold (icon-component svg/magic-wand-bold))
(def magic-wand (icon-component svg/magic-wand-regular))
(def magic-wand-light (icon-component svg/magic-wand-light))
(def magic-wand-thin (icon-component svg/magic-wand-thin))
(def magic-wand-fill (icon-component svg/magic-wand-fill))
(def magic-wand-duotone (icon-component svg/magic-wand-duotone))
(def magnet-bold (icon-component svg/magnet-bold))
(def magnet (icon-component svg/magnet-regular))
(def magnet-light (icon-component svg/magnet-light))
(def magnet-thin (icon-component svg/magnet-thin))
(def magnet-fill (icon-component svg/magnet-fill))
(def magnet-duotone (icon-component svg/magnet-duotone))
(def magnet-straight-bold (icon-component svg/magnet-straight-bold))
(def magnet-straight (icon-component svg/magnet-straight-regular))
(def magnet-straight-light (icon-component svg/magnet-straight-light))
(def magnet-straight-thin (icon-component svg/magnet-straight-thin))
(def magnet-straight-fill (icon-component svg/magnet-straight-fill))
(def magnet-straight-duotone (icon-component svg/magnet-straight-duotone))
(def magnifying-glass-bold (icon-component svg/magnifying-glass-bold))
(def magnifying-glass (icon-component svg/magnifying-glass-regular))
(def magnifying-glass-light (icon-component svg/magnifying-glass-light))
(def magnifying-glass-thin (icon-component svg/magnifying-glass-thin))
(def magnifying-glass-fill (icon-component svg/magnifying-glass-fill))
(def magnifying-glass-duotone (icon-component svg/magnifying-glass-duotone))
(def magnifying-glass-minus-bold (icon-component svg/magnifying-glass-minus-bold))
(def magnifying-glass-minus (icon-component svg/magnifying-glass-minus-regular))
(def magnifying-glass-minus-light (icon-component svg/magnifying-glass-minus-light))
(def magnifying-glass-minus-thin (icon-component svg/magnifying-glass-minus-thin))
(def magnifying-glass-minus-fill (icon-component svg/magnifying-glass-minus-fill))
(def magnifying-glass-minus-duotone (icon-component svg/magnifying-glass-minus-duotone))
(def magnifying-glass-plus-bold (icon-component svg/magnifying-glass-plus-bold))
(def magnifying-glass-plus (icon-component svg/magnifying-glass-plus-regular))
(def magnifying-glass-plus-light (icon-component svg/magnifying-glass-plus-light))
(def magnifying-glass-plus-thin (icon-component svg/magnifying-glass-plus-thin))
(def magnifying-glass-plus-fill (icon-component svg/magnifying-glass-plus-fill))
(def magnifying-glass-plus-duotone (icon-component svg/magnifying-glass-plus-duotone))
(def mailbox-bold (icon-component svg/mailbox-bold))
(def mailbox (icon-component svg/mailbox-regular))
(def mailbox-light (icon-component svg/mailbox-light))
(def mailbox-thin (icon-component svg/mailbox-thin))
(def mailbox-fill (icon-component svg/mailbox-fill))
(def mailbox-duotone (icon-component svg/mailbox-duotone))
(def map-pin-bold (icon-component svg/map-pin-bold))
(def map-pin (icon-component svg/map-pin-regular))
(def map-pin-light (icon-component svg/map-pin-light))
(def map-pin-thin (icon-component svg/map-pin-thin))
(def map-pin-fill (icon-component svg/map-pin-fill))
(def map-pin-duotone (icon-component svg/map-pin-duotone))
(def map-pin-area-bold (icon-component svg/map-pin-area-bold))
(def map-pin-area (icon-component svg/map-pin-area-regular))
(def map-pin-area-light (icon-component svg/map-pin-area-light))
(def map-pin-area-thin (icon-component svg/map-pin-area-thin))
(def map-pin-area-fill (icon-component svg/map-pin-area-fill))
(def map-pin-area-duotone (icon-component svg/map-pin-area-duotone))
(def map-pin-line-bold (icon-component svg/map-pin-line-bold))
(def map-pin-line (icon-component svg/map-pin-line-regular))
(def map-pin-line-light (icon-component svg/map-pin-line-light))
(def map-pin-line-thin (icon-component svg/map-pin-line-thin))
(def map-pin-line-fill (icon-component svg/map-pin-line-fill))
(def map-pin-line-duotone (icon-component svg/map-pin-line-duotone))
(def map-pin-plus-bold (icon-component svg/map-pin-plus-bold))
(def map-pin-plus (icon-component svg/map-pin-plus-regular))
(def map-pin-plus-light (icon-component svg/map-pin-plus-light))
(def map-pin-plus-thin (icon-component svg/map-pin-plus-thin))
(def map-pin-plus-fill (icon-component svg/map-pin-plus-fill))
(def map-pin-plus-duotone (icon-component svg/map-pin-plus-duotone))
(def map-pin-simple-bold (icon-component svg/map-pin-simple-bold))
(def map-pin-simple (icon-component svg/map-pin-simple-regular))
(def map-pin-simple-light (icon-component svg/map-pin-simple-light))
(def map-pin-simple-thin (icon-component svg/map-pin-simple-thin))
(def map-pin-simple-fill (icon-component svg/map-pin-simple-fill))
(def map-pin-simple-duotone (icon-component svg/map-pin-simple-duotone))
(def map-pin-simple-area-bold (icon-component svg/map-pin-simple-area-bold))
(def map-pin-simple-area (icon-component svg/map-pin-simple-area-regular))
(def map-pin-simple-area-light (icon-component svg/map-pin-simple-area-light))
(def map-pin-simple-area-thin (icon-component svg/map-pin-simple-area-thin))
(def map-pin-simple-area-fill (icon-component svg/map-pin-simple-area-fill))
(def map-pin-simple-area-duotone (icon-component svg/map-pin-simple-area-duotone))
(def map-pin-simple-line-bold (icon-component svg/map-pin-simple-line-bold))
(def map-pin-simple-line (icon-component svg/map-pin-simple-line-regular))
(def map-pin-simple-line-light (icon-component svg/map-pin-simple-line-light))
(def map-pin-simple-line-thin (icon-component svg/map-pin-simple-line-thin))
(def map-pin-simple-line-fill (icon-component svg/map-pin-simple-line-fill))
(def map-pin-simple-line-duotone (icon-component svg/map-pin-simple-line-duotone))
(def map-trifold-bold (icon-component svg/map-trifold-bold))
(def map-trifold (icon-component svg/map-trifold-regular))
(def map-trifold-light (icon-component svg/map-trifold-light))
(def map-trifold-thin (icon-component svg/map-trifold-thin))
(def map-trifold-fill (icon-component svg/map-trifold-fill))
(def map-trifold-duotone (icon-component svg/map-trifold-duotone))
(def markdown-logo-bold (icon-component svg/markdown-logo-bold))
(def markdown-logo (icon-component svg/markdown-logo-regular))
(def markdown-logo-light (icon-component svg/markdown-logo-light))
(def markdown-logo-thin (icon-component svg/markdown-logo-thin))
(def markdown-logo-fill (icon-component svg/markdown-logo-fill))
(def markdown-logo-duotone (icon-component svg/markdown-logo-duotone))
(def marker-circle-bold (icon-component svg/marker-circle-bold))
(def marker-circle (icon-component svg/marker-circle-regular))
(def marker-circle-light (icon-component svg/marker-circle-light))
(def marker-circle-thin (icon-component svg/marker-circle-thin))
(def marker-circle-fill (icon-component svg/marker-circle-fill))
(def marker-circle-duotone (icon-component svg/marker-circle-duotone))
(def martini-bold (icon-component svg/martini-bold))
(def martini (icon-component svg/martini-regular))
(def martini-light (icon-component svg/martini-light))
(def martini-thin (icon-component svg/martini-thin))
(def martini-fill (icon-component svg/martini-fill))
(def martini-duotone (icon-component svg/martini-duotone))
(def mask-happy-bold (icon-component svg/mask-happy-bold))
(def mask-happy (icon-component svg/mask-happy-regular))
(def mask-happy-light (icon-component svg/mask-happy-light))
(def mask-happy-thin (icon-component svg/mask-happy-thin))
(def mask-happy-fill (icon-component svg/mask-happy-fill))
(def mask-happy-duotone (icon-component svg/mask-happy-duotone))
(def mask-sad-bold (icon-component svg/mask-sad-bold))
(def mask-sad (icon-component svg/mask-sad-regular))
(def mask-sad-light (icon-component svg/mask-sad-light))
(def mask-sad-thin (icon-component svg/mask-sad-thin))
(def mask-sad-fill (icon-component svg/mask-sad-fill))
(def mask-sad-duotone (icon-component svg/mask-sad-duotone))
(def mastodon-logo-bold (icon-component svg/mastodon-logo-bold))
(def mastodon-logo (icon-component svg/mastodon-logo-regular))
(def mastodon-logo-light (icon-component svg/mastodon-logo-light))
(def mastodon-logo-thin (icon-component svg/mastodon-logo-thin))
(def mastodon-logo-fill (icon-component svg/mastodon-logo-fill))
(def mastodon-logo-duotone (icon-component svg/mastodon-logo-duotone))
(def math-operations-bold (icon-component svg/math-operations-bold))
(def math-operations (icon-component svg/math-operations-regular))
(def math-operations-light (icon-component svg/math-operations-light))
(def math-operations-thin (icon-component svg/math-operations-thin))
(def math-operations-fill (icon-component svg/math-operations-fill))
(def math-operations-duotone (icon-component svg/math-operations-duotone))
(def matrix-logo-bold (icon-component svg/matrix-logo-bold))
(def matrix-logo (icon-component svg/matrix-logo-regular))
(def matrix-logo-light (icon-component svg/matrix-logo-light))
(def matrix-logo-thin (icon-component svg/matrix-logo-thin))
(def matrix-logo-fill (icon-component svg/matrix-logo-fill))
(def matrix-logo-duotone (icon-component svg/matrix-logo-duotone))
(def medal-bold (icon-component svg/medal-bold))
(def medal (icon-component svg/medal-regular))
(def medal-light (icon-component svg/medal-light))
(def medal-thin (icon-component svg/medal-thin))
(def medal-fill (icon-component svg/medal-fill))
(def medal-duotone (icon-component svg/medal-duotone))
(def medal-military-bold (icon-component svg/medal-military-bold))
(def medal-military (icon-component svg/medal-military-regular))
(def medal-military-light (icon-component svg/medal-military-light))
(def medal-military-thin (icon-component svg/medal-military-thin))
(def medal-military-fill (icon-component svg/medal-military-fill))
(def medal-military-duotone (icon-component svg/medal-military-duotone))
(def medium-logo-bold (icon-component svg/medium-logo-bold))
(def medium-logo (icon-component svg/medium-logo-regular))
(def medium-logo-light (icon-component svg/medium-logo-light))
(def medium-logo-thin (icon-component svg/medium-logo-thin))
(def medium-logo-fill (icon-component svg/medium-logo-fill))
(def medium-logo-duotone (icon-component svg/medium-logo-duotone))
(def megaphone-bold (icon-component svg/megaphone-bold))
(def megaphone (icon-component svg/megaphone-regular))
(def megaphone-light (icon-component svg/megaphone-light))
(def megaphone-thin (icon-component svg/megaphone-thin))
(def megaphone-fill (icon-component svg/megaphone-fill))
(def megaphone-duotone (icon-component svg/megaphone-duotone))
(def megaphone-simple-bold (icon-component svg/megaphone-simple-bold))
(def megaphone-simple (icon-component svg/megaphone-simple-regular))
(def megaphone-simple-light (icon-component svg/megaphone-simple-light))
(def megaphone-simple-thin (icon-component svg/megaphone-simple-thin))
(def megaphone-simple-fill (icon-component svg/megaphone-simple-fill))
(def megaphone-simple-duotone (icon-component svg/megaphone-simple-duotone))
(def member-of-bold (icon-component svg/member-of-bold))
(def member-of (icon-component svg/member-of-regular))
(def member-of-light (icon-component svg/member-of-light))
(def member-of-thin (icon-component svg/member-of-thin))
(def member-of-fill (icon-component svg/member-of-fill))
(def member-of-duotone (icon-component svg/member-of-duotone))
(def memory-bold (icon-component svg/memory-bold))
(def memory (icon-component svg/memory-regular))
(def memory-light (icon-component svg/memory-light))
(def memory-thin (icon-component svg/memory-thin))
(def memory-fill (icon-component svg/memory-fill))
(def memory-duotone (icon-component svg/memory-duotone))
(def messenger-logo-bold (icon-component svg/messenger-logo-bold))
(def messenger-logo (icon-component svg/messenger-logo-regular))
(def messenger-logo-light (icon-component svg/messenger-logo-light))
(def messenger-logo-thin (icon-component svg/messenger-logo-thin))
(def messenger-logo-fill (icon-component svg/messenger-logo-fill))
(def messenger-logo-duotone (icon-component svg/messenger-logo-duotone))
(def meta-logo-bold (icon-component svg/meta-logo-bold))
(def meta-logo (icon-component svg/meta-logo-regular))
(def meta-logo-light (icon-component svg/meta-logo-light))
(def meta-logo-thin (icon-component svg/meta-logo-thin))
(def meta-logo-fill (icon-component svg/meta-logo-fill))
(def meta-logo-duotone (icon-component svg/meta-logo-duotone))
(def meteor-bold (icon-component svg/meteor-bold))
(def meteor (icon-component svg/meteor-regular))
(def meteor-light (icon-component svg/meteor-light))
(def meteor-thin (icon-component svg/meteor-thin))
(def meteor-fill (icon-component svg/meteor-fill))
(def meteor-duotone (icon-component svg/meteor-duotone))
(def metronome-bold (icon-component svg/metronome-bold))
(def metronome (icon-component svg/metronome-regular))
(def metronome-light (icon-component svg/metronome-light))
(def metronome-thin (icon-component svg/metronome-thin))
(def metronome-fill (icon-component svg/metronome-fill))
(def metronome-duotone (icon-component svg/metronome-duotone))
(def microphone-bold (icon-component svg/microphone-bold))
(def microphone (icon-component svg/microphone-regular))
(def microphone-light (icon-component svg/microphone-light))
(def microphone-thin (icon-component svg/microphone-thin))
(def microphone-fill (icon-component svg/microphone-fill))
(def microphone-duotone (icon-component svg/microphone-duotone))
(def microphone-slash-bold (icon-component svg/microphone-slash-bold))
(def microphone-slash (icon-component svg/microphone-slash-regular))
(def microphone-slash-light (icon-component svg/microphone-slash-light))
(def microphone-slash-thin (icon-component svg/microphone-slash-thin))
(def microphone-slash-fill (icon-component svg/microphone-slash-fill))
(def microphone-slash-duotone (icon-component svg/microphone-slash-duotone))
(def microphone-stage-bold (icon-component svg/microphone-stage-bold))
(def microphone-stage (icon-component svg/microphone-stage-regular))
(def microphone-stage-light (icon-component svg/microphone-stage-light))
(def microphone-stage-thin (icon-component svg/microphone-stage-thin))
(def microphone-stage-fill (icon-component svg/microphone-stage-fill))
(def microphone-stage-duotone (icon-component svg/microphone-stage-duotone))
(def microscope-bold (icon-component svg/microscope-bold))
(def microscope (icon-component svg/microscope-regular))
(def microscope-light (icon-component svg/microscope-light))
(def microscope-thin (icon-component svg/microscope-thin))
(def microscope-fill (icon-component svg/microscope-fill))
(def microscope-duotone (icon-component svg/microscope-duotone))
(def microsoft-excel-logo-bold (icon-component svg/microsoft-excel-logo-bold))
(def microsoft-excel-logo (icon-component svg/microsoft-excel-logo-regular))
(def microsoft-excel-logo-light (icon-component svg/microsoft-excel-logo-light))
(def microsoft-excel-logo-thin (icon-component svg/microsoft-excel-logo-thin))
(def microsoft-excel-logo-fill (icon-component svg/microsoft-excel-logo-fill))
(def microsoft-excel-logo-duotone (icon-component svg/microsoft-excel-logo-duotone))
(def microsoft-outlook-logo-bold (icon-component svg/microsoft-outlook-logo-bold))
(def microsoft-outlook-logo (icon-component svg/microsoft-outlook-logo-regular))
(def microsoft-outlook-logo-light (icon-component svg/microsoft-outlook-logo-light))
(def microsoft-outlook-logo-thin (icon-component svg/microsoft-outlook-logo-thin))
(def microsoft-outlook-logo-fill (icon-component svg/microsoft-outlook-logo-fill))
(def microsoft-outlook-logo-duotone (icon-component svg/microsoft-outlook-logo-duotone))
(def microsoft-powerpoint-logo-bold (icon-component svg/microsoft-powerpoint-logo-bold))
(def microsoft-powerpoint-logo (icon-component svg/microsoft-powerpoint-logo-regular))
(def microsoft-powerpoint-logo-light (icon-component svg/microsoft-powerpoint-logo-light))
(def microsoft-powerpoint-logo-thin (icon-component svg/microsoft-powerpoint-logo-thin))
(def microsoft-powerpoint-logo-fill (icon-component svg/microsoft-powerpoint-logo-fill))
(def microsoft-powerpoint-logo-duotone (icon-component svg/microsoft-powerpoint-logo-duotone))
(def microsoft-teams-logo-bold (icon-component svg/microsoft-teams-logo-bold))
(def microsoft-teams-logo (icon-component svg/microsoft-teams-logo-regular))
(def microsoft-teams-logo-light (icon-component svg/microsoft-teams-logo-light))
(def microsoft-teams-logo-thin (icon-component svg/microsoft-teams-logo-thin))
(def microsoft-teams-logo-fill (icon-component svg/microsoft-teams-logo-fill))
(def microsoft-teams-logo-duotone (icon-component svg/microsoft-teams-logo-duotone))
(def microsoft-word-logo-bold (icon-component svg/microsoft-word-logo-bold))
(def microsoft-word-logo (icon-component svg/microsoft-word-logo-regular))
(def microsoft-word-logo-light (icon-component svg/microsoft-word-logo-light))
(def microsoft-word-logo-thin (icon-component svg/microsoft-word-logo-thin))
(def microsoft-word-logo-fill (icon-component svg/microsoft-word-logo-fill))
(def microsoft-word-logo-duotone (icon-component svg/microsoft-word-logo-duotone))
(def minus-bold (icon-component svg/minus-bold))
(def minus (icon-component svg/minus-regular))
(def minus-light (icon-component svg/minus-light))
(def minus-thin (icon-component svg/minus-thin))
(def minus-fill (icon-component svg/minus-fill))
(def minus-duotone (icon-component svg/minus-duotone))
(def minus-circle-bold (icon-component svg/minus-circle-bold))
(def minus-circle (icon-component svg/minus-circle-regular))
(def minus-circle-light (icon-component svg/minus-circle-light))
(def minus-circle-thin (icon-component svg/minus-circle-thin))
(def minus-circle-fill (icon-component svg/minus-circle-fill))
(def minus-circle-duotone (icon-component svg/minus-circle-duotone))
(def minus-square-bold (icon-component svg/minus-square-bold))
(def minus-square (icon-component svg/minus-square-regular))
(def minus-square-light (icon-component svg/minus-square-light))
(def minus-square-thin (icon-component svg/minus-square-thin))
(def minus-square-fill (icon-component svg/minus-square-fill))
(def minus-square-duotone (icon-component svg/minus-square-duotone))
(def money-bold (icon-component svg/money-bold))
(def money (icon-component svg/money-regular))
(def money-light (icon-component svg/money-light))
(def money-thin (icon-component svg/money-thin))
(def money-fill (icon-component svg/money-fill))
(def money-duotone (icon-component svg/money-duotone))
(def money-wavy-bold (icon-component svg/money-wavy-bold))
(def money-wavy (icon-component svg/money-wavy-regular))
(def money-wavy-light (icon-component svg/money-wavy-light))
(def money-wavy-thin (icon-component svg/money-wavy-thin))
(def money-wavy-fill (icon-component svg/money-wavy-fill))
(def money-wavy-duotone (icon-component svg/money-wavy-duotone))
(def monitor-bold (icon-component svg/monitor-bold))
(def monitor (icon-component svg/monitor-regular))
(def monitor-light (icon-component svg/monitor-light))
(def monitor-thin (icon-component svg/monitor-thin))
(def monitor-fill (icon-component svg/monitor-fill))
(def monitor-duotone (icon-component svg/monitor-duotone))
(def monitor-arrow-up-bold (icon-component svg/monitor-arrow-up-bold))
(def monitor-arrow-up (icon-component svg/monitor-arrow-up-regular))
(def monitor-arrow-up-light (icon-component svg/monitor-arrow-up-light))
(def monitor-arrow-up-thin (icon-component svg/monitor-arrow-up-thin))
(def monitor-arrow-up-fill (icon-component svg/monitor-arrow-up-fill))
(def monitor-arrow-up-duotone (icon-component svg/monitor-arrow-up-duotone))
(def monitor-play-bold (icon-component svg/monitor-play-bold))
(def monitor-play (icon-component svg/monitor-play-regular))
(def monitor-play-light (icon-component svg/monitor-play-light))
(def monitor-play-thin (icon-component svg/monitor-play-thin))
(def monitor-play-fill (icon-component svg/monitor-play-fill))
(def monitor-play-duotone (icon-component svg/monitor-play-duotone))
(def moon-bold (icon-component svg/moon-bold))
(def moon (icon-component svg/moon-regular))
(def moon-light (icon-component svg/moon-light))
(def moon-thin (icon-component svg/moon-thin))
(def moon-fill (icon-component svg/moon-fill))
(def moon-duotone (icon-component svg/moon-duotone))
(def moon-stars-bold (icon-component svg/moon-stars-bold))
(def moon-stars (icon-component svg/moon-stars-regular))
(def moon-stars-light (icon-component svg/moon-stars-light))
(def moon-stars-thin (icon-component svg/moon-stars-thin))
(def moon-stars-fill (icon-component svg/moon-stars-fill))
(def moon-stars-duotone (icon-component svg/moon-stars-duotone))
(def moped-bold (icon-component svg/moped-bold))
(def moped (icon-component svg/moped-regular))
(def moped-light (icon-component svg/moped-light))
(def moped-thin (icon-component svg/moped-thin))
(def moped-fill (icon-component svg/moped-fill))
(def moped-duotone (icon-component svg/moped-duotone))
(def moped-front-bold (icon-component svg/moped-front-bold))
(def moped-front (icon-component svg/moped-front-regular))
(def moped-front-light (icon-component svg/moped-front-light))
(def moped-front-thin (icon-component svg/moped-front-thin))
(def moped-front-fill (icon-component svg/moped-front-fill))
(def moped-front-duotone (icon-component svg/moped-front-duotone))
(def mosque-bold (icon-component svg/mosque-bold))
(def mosque (icon-component svg/mosque-regular))
(def mosque-light (icon-component svg/mosque-light))
(def mosque-thin (icon-component svg/mosque-thin))
(def mosque-fill (icon-component svg/mosque-fill))
(def mosque-duotone (icon-component svg/mosque-duotone))
(def motorcycle-bold (icon-component svg/motorcycle-bold))
(def motorcycle (icon-component svg/motorcycle-regular))
(def motorcycle-light (icon-component svg/motorcycle-light))
(def motorcycle-thin (icon-component svg/motorcycle-thin))
(def motorcycle-fill (icon-component svg/motorcycle-fill))
(def motorcycle-duotone (icon-component svg/motorcycle-duotone))
(def mountains-bold (icon-component svg/mountains-bold))
(def mountains (icon-component svg/mountains-regular))
(def mountains-light (icon-component svg/mountains-light))
(def mountains-thin (icon-component svg/mountains-thin))
(def mountains-fill (icon-component svg/mountains-fill))
(def mountains-duotone (icon-component svg/mountains-duotone))
(def mouse-bold (icon-component svg/mouse-bold))
(def mouse (icon-component svg/mouse-regular))
(def mouse-light (icon-component svg/mouse-light))
(def mouse-thin (icon-component svg/mouse-thin))
(def mouse-fill (icon-component svg/mouse-fill))
(def mouse-duotone (icon-component svg/mouse-duotone))
(def mouse-left-click-bold (icon-component svg/mouse-left-click-bold))
(def mouse-left-click (icon-component svg/mouse-left-click-regular))
(def mouse-left-click-light (icon-component svg/mouse-left-click-light))
(def mouse-left-click-thin (icon-component svg/mouse-left-click-thin))
(def mouse-left-click-fill (icon-component svg/mouse-left-click-fill))
(def mouse-left-click-duotone (icon-component svg/mouse-left-click-duotone))
(def mouse-middle-click-bold (icon-component svg/mouse-middle-click-bold))
(def mouse-middle-click (icon-component svg/mouse-middle-click-regular))
(def mouse-middle-click-light (icon-component svg/mouse-middle-click-light))
(def mouse-middle-click-thin (icon-component svg/mouse-middle-click-thin))
(def mouse-middle-click-fill (icon-component svg/mouse-middle-click-fill))
(def mouse-middle-click-duotone (icon-component svg/mouse-middle-click-duotone))
(def mouse-right-click-bold (icon-component svg/mouse-right-click-bold))
(def mouse-right-click (icon-component svg/mouse-right-click-regular))
(def mouse-right-click-light (icon-component svg/mouse-right-click-light))
(def mouse-right-click-thin (icon-component svg/mouse-right-click-thin))
(def mouse-right-click-fill (icon-component svg/mouse-right-click-fill))
(def mouse-right-click-duotone (icon-component svg/mouse-right-click-duotone))
(def mouse-scroll-bold (icon-component svg/mouse-scroll-bold))
(def mouse-scroll (icon-component svg/mouse-scroll-regular))
(def mouse-scroll-light (icon-component svg/mouse-scroll-light))
(def mouse-scroll-thin (icon-component svg/mouse-scroll-thin))
(def mouse-scroll-fill (icon-component svg/mouse-scroll-fill))
(def mouse-scroll-duotone (icon-component svg/mouse-scroll-duotone))
(def mouse-simple-bold (icon-component svg/mouse-simple-bold))
(def mouse-simple (icon-component svg/mouse-simple-regular))
(def mouse-simple-light (icon-component svg/mouse-simple-light))
(def mouse-simple-thin (icon-component svg/mouse-simple-thin))
(def mouse-simple-fill (icon-component svg/mouse-simple-fill))
(def mouse-simple-duotone (icon-component svg/mouse-simple-duotone))
(def music-note-bold (icon-component svg/music-note-bold))
(def music-note (icon-component svg/music-note-regular))
(def music-note-light (icon-component svg/music-note-light))
(def music-note-thin (icon-component svg/music-note-thin))
(def music-note-fill (icon-component svg/music-note-fill))
(def music-note-duotone (icon-component svg/music-note-duotone))
(def music-note-simple-bold (icon-component svg/music-note-simple-bold))
(def music-note-simple (icon-component svg/music-note-simple-regular))
(def music-note-simple-light (icon-component svg/music-note-simple-light))
(def music-note-simple-thin (icon-component svg/music-note-simple-thin))
(def music-note-simple-fill (icon-component svg/music-note-simple-fill))
(def music-note-simple-duotone (icon-component svg/music-note-simple-duotone))
(def music-notes-bold (icon-component svg/music-notes-bold))
(def music-notes (icon-component svg/music-notes-regular))
(def music-notes-light (icon-component svg/music-notes-light))
(def music-notes-thin (icon-component svg/music-notes-thin))
(def music-notes-fill (icon-component svg/music-notes-fill))
(def music-notes-duotone (icon-component svg/music-notes-duotone))
(def music-notes-minus-bold (icon-component svg/music-notes-minus-bold))
(def music-notes-minus (icon-component svg/music-notes-minus-regular))
(def music-notes-minus-light (icon-component svg/music-notes-minus-light))
(def music-notes-minus-thin (icon-component svg/music-notes-minus-thin))
(def music-notes-minus-fill (icon-component svg/music-notes-minus-fill))
(def music-notes-minus-duotone (icon-component svg/music-notes-minus-duotone))
(def music-notes-plus-bold (icon-component svg/music-notes-plus-bold))
(def music-notes-plus (icon-component svg/music-notes-plus-regular))
(def music-notes-plus-light (icon-component svg/music-notes-plus-light))
(def music-notes-plus-thin (icon-component svg/music-notes-plus-thin))
(def music-notes-plus-fill (icon-component svg/music-notes-plus-fill))
(def music-notes-plus-duotone (icon-component svg/music-notes-plus-duotone))
(def music-notes-simple-bold (icon-component svg/music-notes-simple-bold))
(def music-notes-simple (icon-component svg/music-notes-simple-regular))
(def music-notes-simple-light (icon-component svg/music-notes-simple-light))
(def music-notes-simple-thin (icon-component svg/music-notes-simple-thin))
(def music-notes-simple-fill (icon-component svg/music-notes-simple-fill))
(def music-notes-simple-duotone (icon-component svg/music-notes-simple-duotone))
(def navigation-arrow-bold (icon-component svg/navigation-arrow-bold))
(def navigation-arrow (icon-component svg/navigation-arrow-regular))
(def navigation-arrow-light (icon-component svg/navigation-arrow-light))
(def navigation-arrow-thin (icon-component svg/navigation-arrow-thin))
(def navigation-arrow-fill (icon-component svg/navigation-arrow-fill))
(def navigation-arrow-duotone (icon-component svg/navigation-arrow-duotone))
(def needle-bold (icon-component svg/needle-bold))
(def needle (icon-component svg/needle-regular))
(def needle-light (icon-component svg/needle-light))
(def needle-thin (icon-component svg/needle-thin))
(def needle-fill (icon-component svg/needle-fill))
(def needle-duotone (icon-component svg/needle-duotone))
(def network-bold (icon-component svg/network-bold))
(def network (icon-component svg/network-regular))
(def network-light (icon-component svg/network-light))
(def network-thin (icon-component svg/network-thin))
(def network-fill (icon-component svg/network-fill))
(def network-duotone (icon-component svg/network-duotone))
(def network-slash-bold (icon-component svg/network-slash-bold))
(def network-slash (icon-component svg/network-slash-regular))
(def network-slash-light (icon-component svg/network-slash-light))
(def network-slash-thin (icon-component svg/network-slash-thin))
(def network-slash-fill (icon-component svg/network-slash-fill))
(def network-slash-duotone (icon-component svg/network-slash-duotone))
(def network-x-bold (icon-component svg/network-x-bold))
(def network-x (icon-component svg/network-x-regular))
(def network-x-light (icon-component svg/network-x-light))
(def network-x-thin (icon-component svg/network-x-thin))
(def network-x-fill (icon-component svg/network-x-fill))
(def network-x-duotone (icon-component svg/network-x-duotone))
(def newspaper-bold (icon-component svg/newspaper-bold))
(def newspaper (icon-component svg/newspaper-regular))
(def newspaper-light (icon-component svg/newspaper-light))
(def newspaper-thin (icon-component svg/newspaper-thin))
(def newspaper-fill (icon-component svg/newspaper-fill))
(def newspaper-duotone (icon-component svg/newspaper-duotone))
(def newspaper-clipping-bold (icon-component svg/newspaper-clipping-bold))
(def newspaper-clipping (icon-component svg/newspaper-clipping-regular))
(def newspaper-clipping-light (icon-component svg/newspaper-clipping-light))
(def newspaper-clipping-thin (icon-component svg/newspaper-clipping-thin))
(def newspaper-clipping-fill (icon-component svg/newspaper-clipping-fill))
(def newspaper-clipping-duotone (icon-component svg/newspaper-clipping-duotone))
(def not-equals-bold (icon-component svg/not-equals-bold))
(def not-equals (icon-component svg/not-equals-regular))
(def not-equals-light (icon-component svg/not-equals-light))
(def not-equals-thin (icon-component svg/not-equals-thin))
(def not-equals-fill (icon-component svg/not-equals-fill))
(def not-equals-duotone (icon-component svg/not-equals-duotone))
(def not-member-of-bold (icon-component svg/not-member-of-bold))
(def not-member-of (icon-component svg/not-member-of-regular))
(def not-member-of-light (icon-component svg/not-member-of-light))
(def not-member-of-thin (icon-component svg/not-member-of-thin))
(def not-member-of-fill (icon-component svg/not-member-of-fill))
(def not-member-of-duotone (icon-component svg/not-member-of-duotone))
(def not-subset-of-bold (icon-component svg/not-subset-of-bold))
(def not-subset-of (icon-component svg/not-subset-of-regular))
(def not-subset-of-light (icon-component svg/not-subset-of-light))
(def not-subset-of-thin (icon-component svg/not-subset-of-thin))
(def not-subset-of-fill (icon-component svg/not-subset-of-fill))
(def not-subset-of-duotone (icon-component svg/not-subset-of-duotone))
(def not-superset-of-bold (icon-component svg/not-superset-of-bold))
(def not-superset-of (icon-component svg/not-superset-of-regular))
(def not-superset-of-light (icon-component svg/not-superset-of-light))
(def not-superset-of-thin (icon-component svg/not-superset-of-thin))
(def not-superset-of-fill (icon-component svg/not-superset-of-fill))
(def not-superset-of-duotone (icon-component svg/not-superset-of-duotone))
(def notches-bold (icon-component svg/notches-bold))
(def notches (icon-component svg/notches-regular))
(def notches-light (icon-component svg/notches-light))
(def notches-thin (icon-component svg/notches-thin))
(def notches-fill (icon-component svg/notches-fill))
(def notches-duotone (icon-component svg/notches-duotone))
(def note-bold (icon-component svg/note-bold))
(def note (icon-component svg/note-regular))
(def note-light (icon-component svg/note-light))
(def note-thin (icon-component svg/note-thin))
(def note-fill (icon-component svg/note-fill))
(def note-duotone (icon-component svg/note-duotone))
(def note-blank-bold (icon-component svg/note-blank-bold))
(def note-blank (icon-component svg/note-blank-regular))
(def note-blank-light (icon-component svg/note-blank-light))
(def note-blank-thin (icon-component svg/note-blank-thin))
(def note-blank-fill (icon-component svg/note-blank-fill))
(def note-blank-duotone (icon-component svg/note-blank-duotone))
(def note-pencil-bold (icon-component svg/note-pencil-bold))
(def note-pencil (icon-component svg/note-pencil-regular))
(def note-pencil-light (icon-component svg/note-pencil-light))
(def note-pencil-thin (icon-component svg/note-pencil-thin))
(def note-pencil-fill (icon-component svg/note-pencil-fill))
(def note-pencil-duotone (icon-component svg/note-pencil-duotone))
(def notebook-bold (icon-component svg/notebook-bold))
(def notebook (icon-component svg/notebook-regular))
(def notebook-light (icon-component svg/notebook-light))
(def notebook-thin (icon-component svg/notebook-thin))
(def notebook-fill (icon-component svg/notebook-fill))
(def notebook-duotone (icon-component svg/notebook-duotone))
(def notepad-bold (icon-component svg/notepad-bold))
(def notepad (icon-component svg/notepad-regular))
(def notepad-light (icon-component svg/notepad-light))
(def notepad-thin (icon-component svg/notepad-thin))
(def notepad-fill (icon-component svg/notepad-fill))
(def notepad-duotone (icon-component svg/notepad-duotone))
(def notification-bold (icon-component svg/notification-bold))
(def notification (icon-component svg/notification-regular))
(def notification-light (icon-component svg/notification-light))
(def notification-thin (icon-component svg/notification-thin))
(def notification-fill (icon-component svg/notification-fill))
(def notification-duotone (icon-component svg/notification-duotone))
(def notion-logo-bold (icon-component svg/notion-logo-bold))
(def notion-logo (icon-component svg/notion-logo-regular))
(def notion-logo-light (icon-component svg/notion-logo-light))
(def notion-logo-thin (icon-component svg/notion-logo-thin))
(def notion-logo-fill (icon-component svg/notion-logo-fill))
(def notion-logo-duotone (icon-component svg/notion-logo-duotone))
(def nuclear-plant-bold (icon-component svg/nuclear-plant-bold))
(def nuclear-plant (icon-component svg/nuclear-plant-regular))
(def nuclear-plant-light (icon-component svg/nuclear-plant-light))
(def nuclear-plant-thin (icon-component svg/nuclear-plant-thin))
(def nuclear-plant-fill (icon-component svg/nuclear-plant-fill))
(def nuclear-plant-duotone (icon-component svg/nuclear-plant-duotone))
(def number-circle-eight-bold (icon-component svg/number-circle-eight-bold))
(def number-circle-eight (icon-component svg/number-circle-eight-regular))
(def number-circle-eight-light (icon-component svg/number-circle-eight-light))
(def number-circle-eight-thin (icon-component svg/number-circle-eight-thin))
(def number-circle-eight-fill (icon-component svg/number-circle-eight-fill))
(def number-circle-eight-duotone (icon-component svg/number-circle-eight-duotone))
(def number-circle-five-bold (icon-component svg/number-circle-five-bold))
(def number-circle-five (icon-component svg/number-circle-five-regular))
(def number-circle-five-light (icon-component svg/number-circle-five-light))
(def number-circle-five-thin (icon-component svg/number-circle-five-thin))
(def number-circle-five-fill (icon-component svg/number-circle-five-fill))
(def number-circle-five-duotone (icon-component svg/number-circle-five-duotone))
(def number-circle-four-bold (icon-component svg/number-circle-four-bold))
(def number-circle-four (icon-component svg/number-circle-four-regular))
(def number-circle-four-light (icon-component svg/number-circle-four-light))
(def number-circle-four-thin (icon-component svg/number-circle-four-thin))
(def number-circle-four-fill (icon-component svg/number-circle-four-fill))
(def number-circle-four-duotone (icon-component svg/number-circle-four-duotone))
(def number-circle-nine-bold (icon-component svg/number-circle-nine-bold))
(def number-circle-nine (icon-component svg/number-circle-nine-regular))
(def number-circle-nine-light (icon-component svg/number-circle-nine-light))
(def number-circle-nine-thin (icon-component svg/number-circle-nine-thin))
(def number-circle-nine-fill (icon-component svg/number-circle-nine-fill))
(def number-circle-nine-duotone (icon-component svg/number-circle-nine-duotone))
(def number-circle-one-bold (icon-component svg/number-circle-one-bold))
(def number-circle-one (icon-component svg/number-circle-one-regular))
(def number-circle-one-light (icon-component svg/number-circle-one-light))
(def number-circle-one-thin (icon-component svg/number-circle-one-thin))
(def number-circle-one-fill (icon-component svg/number-circle-one-fill))
(def number-circle-one-duotone (icon-component svg/number-circle-one-duotone))
(def number-circle-seven-bold (icon-component svg/number-circle-seven-bold))
(def number-circle-seven (icon-component svg/number-circle-seven-regular))
(def number-circle-seven-light (icon-component svg/number-circle-seven-light))
(def number-circle-seven-thin (icon-component svg/number-circle-seven-thin))
(def number-circle-seven-fill (icon-component svg/number-circle-seven-fill))
(def number-circle-seven-duotone (icon-component svg/number-circle-seven-duotone))
(def number-circle-six-bold (icon-component svg/number-circle-six-bold))
(def number-circle-six (icon-component svg/number-circle-six-regular))
(def number-circle-six-light (icon-component svg/number-circle-six-light))
(def number-circle-six-thin (icon-component svg/number-circle-six-thin))
(def number-circle-six-fill (icon-component svg/number-circle-six-fill))
(def number-circle-six-duotone (icon-component svg/number-circle-six-duotone))
(def number-circle-three-bold (icon-component svg/number-circle-three-bold))
(def number-circle-three (icon-component svg/number-circle-three-regular))
(def number-circle-three-light (icon-component svg/number-circle-three-light))
(def number-circle-three-thin (icon-component svg/number-circle-three-thin))
(def number-circle-three-fill (icon-component svg/number-circle-three-fill))
(def number-circle-three-duotone (icon-component svg/number-circle-three-duotone))
(def number-circle-two-bold (icon-component svg/number-circle-two-bold))
(def number-circle-two (icon-component svg/number-circle-two-regular))
(def number-circle-two-light (icon-component svg/number-circle-two-light))
(def number-circle-two-thin (icon-component svg/number-circle-two-thin))
(def number-circle-two-fill (icon-component svg/number-circle-two-fill))
(def number-circle-two-duotone (icon-component svg/number-circle-two-duotone))
(def number-circle-zero-bold (icon-component svg/number-circle-zero-bold))
(def number-circle-zero (icon-component svg/number-circle-zero-regular))
(def number-circle-zero-light (icon-component svg/number-circle-zero-light))
(def number-circle-zero-thin (icon-component svg/number-circle-zero-thin))
(def number-circle-zero-fill (icon-component svg/number-circle-zero-fill))
(def number-circle-zero-duotone (icon-component svg/number-circle-zero-duotone))
(def number-eight-bold (icon-component svg/number-eight-bold))
(def number-eight (icon-component svg/number-eight-regular))
(def number-eight-light (icon-component svg/number-eight-light))
(def number-eight-thin (icon-component svg/number-eight-thin))
(def number-eight-fill (icon-component svg/number-eight-fill))
(def number-eight-duotone (icon-component svg/number-eight-duotone))
(def number-five-bold (icon-component svg/number-five-bold))
(def number-five (icon-component svg/number-five-regular))
(def number-five-light (icon-component svg/number-five-light))
(def number-five-thin (icon-component svg/number-five-thin))
(def number-five-fill (icon-component svg/number-five-fill))
(def number-five-duotone (icon-component svg/number-five-duotone))
(def number-four-bold (icon-component svg/number-four-bold))
(def number-four (icon-component svg/number-four-regular))
(def number-four-light (icon-component svg/number-four-light))
(def number-four-thin (icon-component svg/number-four-thin))
(def number-four-fill (icon-component svg/number-four-fill))
(def number-four-duotone (icon-component svg/number-four-duotone))
(def number-nine-bold (icon-component svg/number-nine-bold))
(def number-nine (icon-component svg/number-nine-regular))
(def number-nine-light (icon-component svg/number-nine-light))
(def number-nine-thin (icon-component svg/number-nine-thin))
(def number-nine-fill (icon-component svg/number-nine-fill))
(def number-nine-duotone (icon-component svg/number-nine-duotone))
(def number-one-bold (icon-component svg/number-one-bold))
(def number-one (icon-component svg/number-one-regular))
(def number-one-light (icon-component svg/number-one-light))
(def number-one-thin (icon-component svg/number-one-thin))
(def number-one-fill (icon-component svg/number-one-fill))
(def number-one-duotone (icon-component svg/number-one-duotone))
(def number-seven-bold (icon-component svg/number-seven-bold))
(def number-seven (icon-component svg/number-seven-regular))
(def number-seven-light (icon-component svg/number-seven-light))
(def number-seven-thin (icon-component svg/number-seven-thin))
(def number-seven-fill (icon-component svg/number-seven-fill))
(def number-seven-duotone (icon-component svg/number-seven-duotone))
(def number-six-bold (icon-component svg/number-six-bold))
(def number-six (icon-component svg/number-six-regular))
(def number-six-light (icon-component svg/number-six-light))
(def number-six-thin (icon-component svg/number-six-thin))
(def number-six-fill (icon-component svg/number-six-fill))
(def number-six-duotone (icon-component svg/number-six-duotone))
(def number-square-eight-bold (icon-component svg/number-square-eight-bold))
(def number-square-eight (icon-component svg/number-square-eight-regular))
(def number-square-eight-light (icon-component svg/number-square-eight-light))
(def number-square-eight-thin (icon-component svg/number-square-eight-thin))
(def number-square-eight-fill (icon-component svg/number-square-eight-fill))
(def number-square-eight-duotone (icon-component svg/number-square-eight-duotone))
(def number-square-five-bold (icon-component svg/number-square-five-bold))
(def number-square-five (icon-component svg/number-square-five-regular))
(def number-square-five-light (icon-component svg/number-square-five-light))
(def number-square-five-thin (icon-component svg/number-square-five-thin))
(def number-square-five-fill (icon-component svg/number-square-five-fill))
(def number-square-five-duotone (icon-component svg/number-square-five-duotone))
(def number-square-four-bold (icon-component svg/number-square-four-bold))
(def number-square-four (icon-component svg/number-square-four-regular))
(def number-square-four-light (icon-component svg/number-square-four-light))
(def number-square-four-thin (icon-component svg/number-square-four-thin))
(def number-square-four-fill (icon-component svg/number-square-four-fill))
(def number-square-four-duotone (icon-component svg/number-square-four-duotone))
(def number-square-nine-bold (icon-component svg/number-square-nine-bold))
(def number-square-nine (icon-component svg/number-square-nine-regular))
(def number-square-nine-light (icon-component svg/number-square-nine-light))
(def number-square-nine-thin (icon-component svg/number-square-nine-thin))
(def number-square-nine-fill (icon-component svg/number-square-nine-fill))
(def number-square-nine-duotone (icon-component svg/number-square-nine-duotone))
(def number-square-one-bold (icon-component svg/number-square-one-bold))
(def number-square-one (icon-component svg/number-square-one-regular))
(def number-square-one-light (icon-component svg/number-square-one-light))
(def number-square-one-thin (icon-component svg/number-square-one-thin))
(def number-square-one-fill (icon-component svg/number-square-one-fill))
(def number-square-one-duotone (icon-component svg/number-square-one-duotone))
(def number-square-seven-bold (icon-component svg/number-square-seven-bold))
(def number-square-seven (icon-component svg/number-square-seven-regular))
(def number-square-seven-light (icon-component svg/number-square-seven-light))
(def number-square-seven-thin (icon-component svg/number-square-seven-thin))
(def number-square-seven-fill (icon-component svg/number-square-seven-fill))
(def number-square-seven-duotone (icon-component svg/number-square-seven-duotone))
(def number-square-six-bold (icon-component svg/number-square-six-bold))
(def number-square-six (icon-component svg/number-square-six-regular))
(def number-square-six-light (icon-component svg/number-square-six-light))
(def number-square-six-thin (icon-component svg/number-square-six-thin))
(def number-square-six-fill (icon-component svg/number-square-six-fill))
(def number-square-six-duotone (icon-component svg/number-square-six-duotone))
(def number-square-three-bold (icon-component svg/number-square-three-bold))
(def number-square-three (icon-component svg/number-square-three-regular))
(def number-square-three-light (icon-component svg/number-square-three-light))
(def number-square-three-thin (icon-component svg/number-square-three-thin))
(def number-square-three-fill (icon-component svg/number-square-three-fill))
(def number-square-three-duotone (icon-component svg/number-square-three-duotone))
(def number-square-two-bold (icon-component svg/number-square-two-bold))
(def number-square-two (icon-component svg/number-square-two-regular))
(def number-square-two-light (icon-component svg/number-square-two-light))
(def number-square-two-thin (icon-component svg/number-square-two-thin))
(def number-square-two-fill (icon-component svg/number-square-two-fill))
(def number-square-two-duotone (icon-component svg/number-square-two-duotone))
(def number-square-zero-bold (icon-component svg/number-square-zero-bold))
(def number-square-zero (icon-component svg/number-square-zero-regular))
(def number-square-zero-light (icon-component svg/number-square-zero-light))
(def number-square-zero-thin (icon-component svg/number-square-zero-thin))
(def number-square-zero-fill (icon-component svg/number-square-zero-fill))
(def number-square-zero-duotone (icon-component svg/number-square-zero-duotone))
(def number-three-bold (icon-component svg/number-three-bold))
(def number-three (icon-component svg/number-three-regular))
(def number-three-light (icon-component svg/number-three-light))
(def number-three-thin (icon-component svg/number-three-thin))
(def number-three-fill (icon-component svg/number-three-fill))
(def number-three-duotone (icon-component svg/number-three-duotone))
(def number-two-bold (icon-component svg/number-two-bold))
(def number-two (icon-component svg/number-two-regular))
(def number-two-light (icon-component svg/number-two-light))
(def number-two-thin (icon-component svg/number-two-thin))
(def number-two-fill (icon-component svg/number-two-fill))
(def number-two-duotone (icon-component svg/number-two-duotone))
(def number-zero-bold (icon-component svg/number-zero-bold))
(def number-zero (icon-component svg/number-zero-regular))
(def number-zero-light (icon-component svg/number-zero-light))
(def number-zero-thin (icon-component svg/number-zero-thin))
(def number-zero-fill (icon-component svg/number-zero-fill))
(def number-zero-duotone (icon-component svg/number-zero-duotone))
(def numpad-bold (icon-component svg/numpad-bold))
(def numpad (icon-component svg/numpad-regular))
(def numpad-light (icon-component svg/numpad-light))
(def numpad-thin (icon-component svg/numpad-thin))
(def numpad-fill (icon-component svg/numpad-fill))
(def numpad-duotone (icon-component svg/numpad-duotone))
(def nut-bold (icon-component svg/nut-bold))
(def nut (icon-component svg/nut-regular))
(def nut-light (icon-component svg/nut-light))
(def nut-thin (icon-component svg/nut-thin))
(def nut-fill (icon-component svg/nut-fill))
(def nut-duotone (icon-component svg/nut-duotone))
(def ny-times-logo-bold (icon-component svg/ny-times-logo-bold))
(def ny-times-logo (icon-component svg/ny-times-logo-regular))
(def ny-times-logo-light (icon-component svg/ny-times-logo-light))
(def ny-times-logo-thin (icon-component svg/ny-times-logo-thin))
(def ny-times-logo-fill (icon-component svg/ny-times-logo-fill))
(def ny-times-logo-duotone (icon-component svg/ny-times-logo-duotone))
(def octagon-bold (icon-component svg/octagon-bold))
(def octagon (icon-component svg/octagon-regular))
(def octagon-light (icon-component svg/octagon-light))
(def octagon-thin (icon-component svg/octagon-thin))
(def octagon-fill (icon-component svg/octagon-fill))
(def octagon-duotone (icon-component svg/octagon-duotone))
(def office-chair-bold (icon-component svg/office-chair-bold))
(def office-chair (icon-component svg/office-chair-regular))
(def office-chair-light (icon-component svg/office-chair-light))
(def office-chair-thin (icon-component svg/office-chair-thin))
(def office-chair-fill (icon-component svg/office-chair-fill))
(def office-chair-duotone (icon-component svg/office-chair-duotone))
(def onigiri-bold (icon-component svg/onigiri-bold))
(def onigiri (icon-component svg/onigiri-regular))
(def onigiri-light (icon-component svg/onigiri-light))
(def onigiri-thin (icon-component svg/onigiri-thin))
(def onigiri-fill (icon-component svg/onigiri-fill))
(def onigiri-duotone (icon-component svg/onigiri-duotone))
(def open-ai-logo-bold (icon-component svg/open-ai-logo-bold))
(def open-ai-logo (icon-component svg/open-ai-logo-regular))
(def open-ai-logo-light (icon-component svg/open-ai-logo-light))
(def open-ai-logo-thin (icon-component svg/open-ai-logo-thin))
(def open-ai-logo-fill (icon-component svg/open-ai-logo-fill))
(def open-ai-logo-duotone (icon-component svg/open-ai-logo-duotone))
(def option-bold (icon-component svg/option-bold))
(def option (icon-component svg/option-regular))
(def option-light (icon-component svg/option-light))
(def option-thin (icon-component svg/option-thin))
(def option-fill (icon-component svg/option-fill))
(def option-duotone (icon-component svg/option-duotone))
(def orange-bold (icon-component svg/orange-bold))
(def orange (icon-component svg/orange-regular))
(def orange-light (icon-component svg/orange-light))
(def orange-thin (icon-component svg/orange-thin))
(def orange-fill (icon-component svg/orange-fill))
(def orange-duotone (icon-component svg/orange-duotone))
(def orange-slice-bold (icon-component svg/orange-slice-bold))
(def orange-slice (icon-component svg/orange-slice-regular))
(def orange-slice-light (icon-component svg/orange-slice-light))
(def orange-slice-thin (icon-component svg/orange-slice-thin))
(def orange-slice-fill (icon-component svg/orange-slice-fill))
(def orange-slice-duotone (icon-component svg/orange-slice-duotone))
(def oven-bold (icon-component svg/oven-bold))
(def oven (icon-component svg/oven-regular))
(def oven-light (icon-component svg/oven-light))
(def oven-thin (icon-component svg/oven-thin))
(def oven-fill (icon-component svg/oven-fill))
(def oven-duotone (icon-component svg/oven-duotone))
(def package-bold (icon-component svg/package-bold))
(def package (icon-component svg/package-regular))
(def package-light (icon-component svg/package-light))
(def package-thin (icon-component svg/package-thin))
(def package-fill (icon-component svg/package-fill))
(def package-duotone (icon-component svg/package-duotone))
(def paint-brush-bold (icon-component svg/paint-brush-bold))
(def paint-brush (icon-component svg/paint-brush-regular))
(def paint-brush-light (icon-component svg/paint-brush-light))
(def paint-brush-thin (icon-component svg/paint-brush-thin))
(def paint-brush-fill (icon-component svg/paint-brush-fill))
(def paint-brush-duotone (icon-component svg/paint-brush-duotone))
(def paint-brush-broad-bold (icon-component svg/paint-brush-broad-bold))
(def paint-brush-broad (icon-component svg/paint-brush-broad-regular))
(def paint-brush-broad-light (icon-component svg/paint-brush-broad-light))
(def paint-brush-broad-thin (icon-component svg/paint-brush-broad-thin))
(def paint-brush-broad-fill (icon-component svg/paint-brush-broad-fill))
(def paint-brush-broad-duotone (icon-component svg/paint-brush-broad-duotone))
(def paint-brush-household-bold (icon-component svg/paint-brush-household-bold))
(def paint-brush-household (icon-component svg/paint-brush-household-regular))
(def paint-brush-household-light (icon-component svg/paint-brush-household-light))
(def paint-brush-household-thin (icon-component svg/paint-brush-household-thin))
(def paint-brush-household-fill (icon-component svg/paint-brush-household-fill))
(def paint-brush-household-duotone (icon-component svg/paint-brush-household-duotone))
(def paint-bucket-bold (icon-component svg/paint-bucket-bold))
(def paint-bucket (icon-component svg/paint-bucket-regular))
(def paint-bucket-light (icon-component svg/paint-bucket-light))
(def paint-bucket-thin (icon-component svg/paint-bucket-thin))
(def paint-bucket-fill (icon-component svg/paint-bucket-fill))
(def paint-bucket-duotone (icon-component svg/paint-bucket-duotone))
(def paint-roller-bold (icon-component svg/paint-roller-bold))
(def paint-roller (icon-component svg/paint-roller-regular))
(def paint-roller-light (icon-component svg/paint-roller-light))
(def paint-roller-thin (icon-component svg/paint-roller-thin))
(def paint-roller-fill (icon-component svg/paint-roller-fill))
(def paint-roller-duotone (icon-component svg/paint-roller-duotone))
(def palette-bold (icon-component svg/palette-bold))
(def palette (icon-component svg/palette-regular))
(def palette-light (icon-component svg/palette-light))
(def palette-thin (icon-component svg/palette-thin))
(def palette-fill (icon-component svg/palette-fill))
(def palette-duotone (icon-component svg/palette-duotone))
(def panorama-bold (icon-component svg/panorama-bold))
(def panorama (icon-component svg/panorama-regular))
(def panorama-light (icon-component svg/panorama-light))
(def panorama-thin (icon-component svg/panorama-thin))
(def panorama-fill (icon-component svg/panorama-fill))
(def panorama-duotone (icon-component svg/panorama-duotone))
(def pants-bold (icon-component svg/pants-bold))
(def pants (icon-component svg/pants-regular))
(def pants-light (icon-component svg/pants-light))
(def pants-thin (icon-component svg/pants-thin))
(def pants-fill (icon-component svg/pants-fill))
(def pants-duotone (icon-component svg/pants-duotone))
(def paper-plane-bold (icon-component svg/paper-plane-bold))
(def paper-plane (icon-component svg/paper-plane-regular))
(def paper-plane-light (icon-component svg/paper-plane-light))
(def paper-plane-thin (icon-component svg/paper-plane-thin))
(def paper-plane-fill (icon-component svg/paper-plane-fill))
(def paper-plane-duotone (icon-component svg/paper-plane-duotone))
(def paper-plane-right-bold (icon-component svg/paper-plane-right-bold))
(def paper-plane-right (icon-component svg/paper-plane-right-regular))
(def paper-plane-right-light (icon-component svg/paper-plane-right-light))
(def paper-plane-right-thin (icon-component svg/paper-plane-right-thin))
(def paper-plane-right-fill (icon-component svg/paper-plane-right-fill))
(def paper-plane-right-duotone (icon-component svg/paper-plane-right-duotone))
(def paper-plane-tilt-bold (icon-component svg/paper-plane-tilt-bold))
(def paper-plane-tilt (icon-component svg/paper-plane-tilt-regular))
(def paper-plane-tilt-light (icon-component svg/paper-plane-tilt-light))
(def paper-plane-tilt-thin (icon-component svg/paper-plane-tilt-thin))
(def paper-plane-tilt-fill (icon-component svg/paper-plane-tilt-fill))
(def paper-plane-tilt-duotone (icon-component svg/paper-plane-tilt-duotone))
(def paperclip-bold (icon-component svg/paperclip-bold))
(def paperclip (icon-component svg/paperclip-regular))
(def paperclip-light (icon-component svg/paperclip-light))
(def paperclip-thin (icon-component svg/paperclip-thin))
(def paperclip-fill (icon-component svg/paperclip-fill))
(def paperclip-duotone (icon-component svg/paperclip-duotone))
(def paperclip-horizontal-bold (icon-component svg/paperclip-horizontal-bold))
(def paperclip-horizontal (icon-component svg/paperclip-horizontal-regular))
(def paperclip-horizontal-light (icon-component svg/paperclip-horizontal-light))
(def paperclip-horizontal-thin (icon-component svg/paperclip-horizontal-thin))
(def paperclip-horizontal-fill (icon-component svg/paperclip-horizontal-fill))
(def paperclip-horizontal-duotone (icon-component svg/paperclip-horizontal-duotone))
(def parachute-bold (icon-component svg/parachute-bold))
(def parachute (icon-component svg/parachute-regular))
(def parachute-light (icon-component svg/parachute-light))
(def parachute-thin (icon-component svg/parachute-thin))
(def parachute-fill (icon-component svg/parachute-fill))
(def parachute-duotone (icon-component svg/parachute-duotone))
(def paragraph-bold (icon-component svg/paragraph-bold))
(def paragraph (icon-component svg/paragraph-regular))
(def paragraph-light (icon-component svg/paragraph-light))
(def paragraph-thin (icon-component svg/paragraph-thin))
(def paragraph-fill (icon-component svg/paragraph-fill))
(def paragraph-duotone (icon-component svg/paragraph-duotone))
(def parallelogram-bold (icon-component svg/parallelogram-bold))
(def parallelogram (icon-component svg/parallelogram-regular))
(def parallelogram-light (icon-component svg/parallelogram-light))
(def parallelogram-thin (icon-component svg/parallelogram-thin))
(def parallelogram-fill (icon-component svg/parallelogram-fill))
(def parallelogram-duotone (icon-component svg/parallelogram-duotone))
(def park-bold (icon-component svg/park-bold))
(def park (icon-component svg/park-regular))
(def park-light (icon-component svg/park-light))
(def park-thin (icon-component svg/park-thin))
(def park-fill (icon-component svg/park-fill))
(def park-duotone (icon-component svg/park-duotone))
(def password-bold (icon-component svg/password-bold))
(def password (icon-component svg/password-regular))
(def password-light (icon-component svg/password-light))
(def password-thin (icon-component svg/password-thin))
(def password-fill (icon-component svg/password-fill))
(def password-duotone (icon-component svg/password-duotone))
(def path-bold (icon-component svg/path-bold))
(def path (icon-component svg/path-regular))
(def path-light (icon-component svg/path-light))
(def path-thin (icon-component svg/path-thin))
(def path-fill (icon-component svg/path-fill))
(def path-duotone (icon-component svg/path-duotone))
(def patreon-logo-bold (icon-component svg/patreon-logo-bold))
(def patreon-logo (icon-component svg/patreon-logo-regular))
(def patreon-logo-light (icon-component svg/patreon-logo-light))
(def patreon-logo-thin (icon-component svg/patreon-logo-thin))
(def patreon-logo-fill (icon-component svg/patreon-logo-fill))
(def patreon-logo-duotone (icon-component svg/patreon-logo-duotone))
(def pause-bold (icon-component svg/pause-bold))
(def pause (icon-component svg/pause-regular))
(def pause-light (icon-component svg/pause-light))
(def pause-thin (icon-component svg/pause-thin))
(def pause-fill (icon-component svg/pause-fill))
(def pause-duotone (icon-component svg/pause-duotone))
(def pause-circle-bold (icon-component svg/pause-circle-bold))
(def pause-circle (icon-component svg/pause-circle-regular))
(def pause-circle-light (icon-component svg/pause-circle-light))
(def pause-circle-thin (icon-component svg/pause-circle-thin))
(def pause-circle-fill (icon-component svg/pause-circle-fill))
(def pause-circle-duotone (icon-component svg/pause-circle-duotone))
(def paw-print-bold (icon-component svg/paw-print-bold))
(def paw-print (icon-component svg/paw-print-regular))
(def paw-print-light (icon-component svg/paw-print-light))
(def paw-print-thin (icon-component svg/paw-print-thin))
(def paw-print-fill (icon-component svg/paw-print-fill))
(def paw-print-duotone (icon-component svg/paw-print-duotone))
(def paypal-logo-bold (icon-component svg/paypal-logo-bold))
(def paypal-logo (icon-component svg/paypal-logo-regular))
(def paypal-logo-light (icon-component svg/paypal-logo-light))
(def paypal-logo-thin (icon-component svg/paypal-logo-thin))
(def paypal-logo-fill (icon-component svg/paypal-logo-fill))
(def paypal-logo-duotone (icon-component svg/paypal-logo-duotone))
(def peace-bold (icon-component svg/peace-bold))
(def peace (icon-component svg/peace-regular))
(def peace-light (icon-component svg/peace-light))
(def peace-thin (icon-component svg/peace-thin))
(def peace-fill (icon-component svg/peace-fill))
(def peace-duotone (icon-component svg/peace-duotone))
(def pen-bold (icon-component svg/pen-bold))
(def pen (icon-component svg/pen-regular))
(def pen-light (icon-component svg/pen-light))
(def pen-thin (icon-component svg/pen-thin))
(def pen-fill (icon-component svg/pen-fill))
(def pen-duotone (icon-component svg/pen-duotone))
(def pen-nib-bold (icon-component svg/pen-nib-bold))
(def pen-nib (icon-component svg/pen-nib-regular))
(def pen-nib-light (icon-component svg/pen-nib-light))
(def pen-nib-thin (icon-component svg/pen-nib-thin))
(def pen-nib-fill (icon-component svg/pen-nib-fill))
(def pen-nib-duotone (icon-component svg/pen-nib-duotone))
(def pen-nib-straight-bold (icon-component svg/pen-nib-straight-bold))
(def pen-nib-straight (icon-component svg/pen-nib-straight-regular))
(def pen-nib-straight-light (icon-component svg/pen-nib-straight-light))
(def pen-nib-straight-thin (icon-component svg/pen-nib-straight-thin))
(def pen-nib-straight-fill (icon-component svg/pen-nib-straight-fill))
(def pen-nib-straight-duotone (icon-component svg/pen-nib-straight-duotone))
(def pencil-bold (icon-component svg/pencil-bold))
(def pencil (icon-component svg/pencil-regular))
(def pencil-light (icon-component svg/pencil-light))
(def pencil-thin (icon-component svg/pencil-thin))
(def pencil-fill (icon-component svg/pencil-fill))
(def pencil-duotone (icon-component svg/pencil-duotone))
(def pencil-circle-bold (icon-component svg/pencil-circle-bold))
(def pencil-circle (icon-component svg/pencil-circle-regular))
(def pencil-circle-light (icon-component svg/pencil-circle-light))
(def pencil-circle-thin (icon-component svg/pencil-circle-thin))
(def pencil-circle-fill (icon-component svg/pencil-circle-fill))
(def pencil-circle-duotone (icon-component svg/pencil-circle-duotone))
(def pencil-line-bold (icon-component svg/pencil-line-bold))
(def pencil-line (icon-component svg/pencil-line-regular))
(def pencil-line-light (icon-component svg/pencil-line-light))
(def pencil-line-thin (icon-component svg/pencil-line-thin))
(def pencil-line-fill (icon-component svg/pencil-line-fill))
(def pencil-line-duotone (icon-component svg/pencil-line-duotone))
(def pencil-ruler-bold (icon-component svg/pencil-ruler-bold))
(def pencil-ruler (icon-component svg/pencil-ruler-regular))
(def pencil-ruler-light (icon-component svg/pencil-ruler-light))
(def pencil-ruler-thin (icon-component svg/pencil-ruler-thin))
(def pencil-ruler-fill (icon-component svg/pencil-ruler-fill))
(def pencil-ruler-duotone (icon-component svg/pencil-ruler-duotone))
(def pencil-simple-bold (icon-component svg/pencil-simple-bold))
(def pencil-simple (icon-component svg/pencil-simple-regular))
(def pencil-simple-light (icon-component svg/pencil-simple-light))
(def pencil-simple-thin (icon-component svg/pencil-simple-thin))
(def pencil-simple-fill (icon-component svg/pencil-simple-fill))
(def pencil-simple-duotone (icon-component svg/pencil-simple-duotone))
(def pencil-simple-line-bold (icon-component svg/pencil-simple-line-bold))
(def pencil-simple-line (icon-component svg/pencil-simple-line-regular))
(def pencil-simple-line-light (icon-component svg/pencil-simple-line-light))
(def pencil-simple-line-thin (icon-component svg/pencil-simple-line-thin))
(def pencil-simple-line-fill (icon-component svg/pencil-simple-line-fill))
(def pencil-simple-line-duotone (icon-component svg/pencil-simple-line-duotone))
(def pencil-simple-slash-bold (icon-component svg/pencil-simple-slash-bold))
(def pencil-simple-slash (icon-component svg/pencil-simple-slash-regular))
(def pencil-simple-slash-light (icon-component svg/pencil-simple-slash-light))
(def pencil-simple-slash-thin (icon-component svg/pencil-simple-slash-thin))
(def pencil-simple-slash-fill (icon-component svg/pencil-simple-slash-fill))
(def pencil-simple-slash-duotone (icon-component svg/pencil-simple-slash-duotone))
(def pencil-slash-bold (icon-component svg/pencil-slash-bold))
(def pencil-slash (icon-component svg/pencil-slash-regular))
(def pencil-slash-light (icon-component svg/pencil-slash-light))
(def pencil-slash-thin (icon-component svg/pencil-slash-thin))
(def pencil-slash-fill (icon-component svg/pencil-slash-fill))
(def pencil-slash-duotone (icon-component svg/pencil-slash-duotone))
(def pentagon-bold (icon-component svg/pentagon-bold))
(def pentagon (icon-component svg/pentagon-regular))
(def pentagon-light (icon-component svg/pentagon-light))
(def pentagon-thin (icon-component svg/pentagon-thin))
(def pentagon-fill (icon-component svg/pentagon-fill))
(def pentagon-duotone (icon-component svg/pentagon-duotone))
(def pentagram-bold (icon-component svg/pentagram-bold))
(def pentagram (icon-component svg/pentagram-regular))
(def pentagram-light (icon-component svg/pentagram-light))
(def pentagram-thin (icon-component svg/pentagram-thin))
(def pentagram-fill (icon-component svg/pentagram-fill))
(def pentagram-duotone (icon-component svg/pentagram-duotone))
(def pepper-bold (icon-component svg/pepper-bold))
(def pepper (icon-component svg/pepper-regular))
(def pepper-light (icon-component svg/pepper-light))
(def pepper-thin (icon-component svg/pepper-thin))
(def pepper-fill (icon-component svg/pepper-fill))
(def pepper-duotone (icon-component svg/pepper-duotone))
(def percent-bold (icon-component svg/percent-bold))
(def percent (icon-component svg/percent-regular))
(def percent-light (icon-component svg/percent-light))
(def percent-thin (icon-component svg/percent-thin))
(def percent-fill (icon-component svg/percent-fill))
(def percent-duotone (icon-component svg/percent-duotone))
(def person-bold (icon-component svg/person-bold))
(def person (icon-component svg/person-regular))
(def person-light (icon-component svg/person-light))
(def person-thin (icon-component svg/person-thin))
(def person-fill (icon-component svg/person-fill))
(def person-duotone (icon-component svg/person-duotone))
(def person-arms-spread-bold (icon-component svg/person-arms-spread-bold))
(def person-arms-spread (icon-component svg/person-arms-spread-regular))
(def person-arms-spread-light (icon-component svg/person-arms-spread-light))
(def person-arms-spread-thin (icon-component svg/person-arms-spread-thin))
(def person-arms-spread-fill (icon-component svg/person-arms-spread-fill))
(def person-arms-spread-duotone (icon-component svg/person-arms-spread-duotone))
(def person-simple-bold (icon-component svg/person-simple-bold))
(def person-simple (icon-component svg/person-simple-regular))
(def person-simple-light (icon-component svg/person-simple-light))
(def person-simple-thin (icon-component svg/person-simple-thin))
(def person-simple-fill (icon-component svg/person-simple-fill))
(def person-simple-duotone (icon-component svg/person-simple-duotone))
(def person-simple-bike-bold (icon-component svg/person-simple-bike-bold))
(def person-simple-bike (icon-component svg/person-simple-bike-regular))
(def person-simple-bike-light (icon-component svg/person-simple-bike-light))
(def person-simple-bike-thin (icon-component svg/person-simple-bike-thin))
(def person-simple-bike-fill (icon-component svg/person-simple-bike-fill))
(def person-simple-bike-duotone (icon-component svg/person-simple-bike-duotone))
(def person-simple-circle-bold (icon-component svg/person-simple-circle-bold))
(def person-simple-circle (icon-component svg/person-simple-circle-regular))
(def person-simple-circle-light (icon-component svg/person-simple-circle-light))
(def person-simple-circle-thin (icon-component svg/person-simple-circle-thin))
(def person-simple-circle-fill (icon-component svg/person-simple-circle-fill))
(def person-simple-circle-duotone (icon-component svg/person-simple-circle-duotone))
(def person-simple-hike-bold (icon-component svg/person-simple-hike-bold))
(def person-simple-hike (icon-component svg/person-simple-hike-regular))
(def person-simple-hike-light (icon-component svg/person-simple-hike-light))
(def person-simple-hike-thin (icon-component svg/person-simple-hike-thin))
(def person-simple-hike-fill (icon-component svg/person-simple-hike-fill))
(def person-simple-hike-duotone (icon-component svg/person-simple-hike-duotone))
(def person-simple-run-bold (icon-component svg/person-simple-run-bold))
(def person-simple-run (icon-component svg/person-simple-run-regular))
(def person-simple-run-light (icon-component svg/person-simple-run-light))
(def person-simple-run-thin (icon-component svg/person-simple-run-thin))
(def person-simple-run-fill (icon-component svg/person-simple-run-fill))
(def person-simple-run-duotone (icon-component svg/person-simple-run-duotone))
(def person-simple-ski-bold (icon-component svg/person-simple-ski-bold))
(def person-simple-ski (icon-component svg/person-simple-ski-regular))
(def person-simple-ski-light (icon-component svg/person-simple-ski-light))
(def person-simple-ski-thin (icon-component svg/person-simple-ski-thin))
(def person-simple-ski-fill (icon-component svg/person-simple-ski-fill))
(def person-simple-ski-duotone (icon-component svg/person-simple-ski-duotone))
(def person-simple-snowboard-bold (icon-component svg/person-simple-snowboard-bold))
(def person-simple-snowboard (icon-component svg/person-simple-snowboard-regular))
(def person-simple-snowboard-light (icon-component svg/person-simple-snowboard-light))
(def person-simple-snowboard-thin (icon-component svg/person-simple-snowboard-thin))
(def person-simple-snowboard-fill (icon-component svg/person-simple-snowboard-fill))
(def person-simple-snowboard-duotone (icon-component svg/person-simple-snowboard-duotone))
(def person-simple-swim-bold (icon-component svg/person-simple-swim-bold))
(def person-simple-swim (icon-component svg/person-simple-swim-regular))
(def person-simple-swim-light (icon-component svg/person-simple-swim-light))
(def person-simple-swim-thin (icon-component svg/person-simple-swim-thin))
(def person-simple-swim-fill (icon-component svg/person-simple-swim-fill))
(def person-simple-swim-duotone (icon-component svg/person-simple-swim-duotone))
(def person-simple-tai-chi-bold (icon-component svg/person-simple-tai-chi-bold))
(def person-simple-tai-chi (icon-component svg/person-simple-tai-chi-regular))
(def person-simple-tai-chi-light (icon-component svg/person-simple-tai-chi-light))
(def person-simple-tai-chi-thin (icon-component svg/person-simple-tai-chi-thin))
(def person-simple-tai-chi-fill (icon-component svg/person-simple-tai-chi-fill))
(def person-simple-tai-chi-duotone (icon-component svg/person-simple-tai-chi-duotone))
(def person-simple-throw-bold (icon-component svg/person-simple-throw-bold))
(def person-simple-throw (icon-component svg/person-simple-throw-regular))
(def person-simple-throw-light (icon-component svg/person-simple-throw-light))
(def person-simple-throw-thin (icon-component svg/person-simple-throw-thin))
(def person-simple-throw-fill (icon-component svg/person-simple-throw-fill))
(def person-simple-throw-duotone (icon-component svg/person-simple-throw-duotone))
(def person-simple-walk-bold (icon-component svg/person-simple-walk-bold))
(def person-simple-walk (icon-component svg/person-simple-walk-regular))
(def person-simple-walk-light (icon-component svg/person-simple-walk-light))
(def person-simple-walk-thin (icon-component svg/person-simple-walk-thin))
(def person-simple-walk-fill (icon-component svg/person-simple-walk-fill))
(def person-simple-walk-duotone (icon-component svg/person-simple-walk-duotone))
(def perspective-bold (icon-component svg/perspective-bold))
(def perspective (icon-component svg/perspective-regular))
(def perspective-light (icon-component svg/perspective-light))
(def perspective-thin (icon-component svg/perspective-thin))
(def perspective-fill (icon-component svg/perspective-fill))
(def perspective-duotone (icon-component svg/perspective-duotone))
(def phone-bold (icon-component svg/phone-bold))
(def phone (icon-component svg/phone-regular))
(def phone-light (icon-component svg/phone-light))
(def phone-thin (icon-component svg/phone-thin))
(def phone-fill (icon-component svg/phone-fill))
(def phone-duotone (icon-component svg/phone-duotone))
(def phone-call-bold (icon-component svg/phone-call-bold))
(def phone-call (icon-component svg/phone-call-regular))
(def phone-call-light (icon-component svg/phone-call-light))
(def phone-call-thin (icon-component svg/phone-call-thin))
(def phone-call-fill (icon-component svg/phone-call-fill))
(def phone-call-duotone (icon-component svg/phone-call-duotone))
(def phone-disconnect-bold (icon-component svg/phone-disconnect-bold))
(def phone-disconnect (icon-component svg/phone-disconnect-regular))
(def phone-disconnect-light (icon-component svg/phone-disconnect-light))
(def phone-disconnect-thin (icon-component svg/phone-disconnect-thin))
(def phone-disconnect-fill (icon-component svg/phone-disconnect-fill))
(def phone-disconnect-duotone (icon-component svg/phone-disconnect-duotone))
(def phone-incoming-bold (icon-component svg/phone-incoming-bold))
(def phone-incoming (icon-component svg/phone-incoming-regular))
(def phone-incoming-light (icon-component svg/phone-incoming-light))
(def phone-incoming-thin (icon-component svg/phone-incoming-thin))
(def phone-incoming-fill (icon-component svg/phone-incoming-fill))
(def phone-incoming-duotone (icon-component svg/phone-incoming-duotone))
(def phone-list-bold (icon-component svg/phone-list-bold))
(def phone-list (icon-component svg/phone-list-regular))
(def phone-list-light (icon-component svg/phone-list-light))
(def phone-list-thin (icon-component svg/phone-list-thin))
(def phone-list-fill (icon-component svg/phone-list-fill))
(def phone-list-duotone (icon-component svg/phone-list-duotone))
(def phone-outgoing-bold (icon-component svg/phone-outgoing-bold))
(def phone-outgoing (icon-component svg/phone-outgoing-regular))
(def phone-outgoing-light (icon-component svg/phone-outgoing-light))
(def phone-outgoing-thin (icon-component svg/phone-outgoing-thin))
(def phone-outgoing-fill (icon-component svg/phone-outgoing-fill))
(def phone-outgoing-duotone (icon-component svg/phone-outgoing-duotone))
(def phone-pause-bold (icon-component svg/phone-pause-bold))
(def phone-pause (icon-component svg/phone-pause-regular))
(def phone-pause-light (icon-component svg/phone-pause-light))
(def phone-pause-thin (icon-component svg/phone-pause-thin))
(def phone-pause-fill (icon-component svg/phone-pause-fill))
(def phone-pause-duotone (icon-component svg/phone-pause-duotone))
(def phone-plus-bold (icon-component svg/phone-plus-bold))
(def phone-plus (icon-component svg/phone-plus-regular))
(def phone-plus-light (icon-component svg/phone-plus-light))
(def phone-plus-thin (icon-component svg/phone-plus-thin))
(def phone-plus-fill (icon-component svg/phone-plus-fill))
(def phone-plus-duotone (icon-component svg/phone-plus-duotone))
(def phone-slash-bold (icon-component svg/phone-slash-bold))
(def phone-slash (icon-component svg/phone-slash-regular))
(def phone-slash-light (icon-component svg/phone-slash-light))
(def phone-slash-thin (icon-component svg/phone-slash-thin))
(def phone-slash-fill (icon-component svg/phone-slash-fill))
(def phone-slash-duotone (icon-component svg/phone-slash-duotone))
(def phone-transfer-bold (icon-component svg/phone-transfer-bold))
(def phone-transfer (icon-component svg/phone-transfer-regular))
(def phone-transfer-light (icon-component svg/phone-transfer-light))
(def phone-transfer-thin (icon-component svg/phone-transfer-thin))
(def phone-transfer-fill (icon-component svg/phone-transfer-fill))
(def phone-transfer-duotone (icon-component svg/phone-transfer-duotone))
(def phone-x-bold (icon-component svg/phone-x-bold))
(def phone-x (icon-component svg/phone-x-regular))
(def phone-x-light (icon-component svg/phone-x-light))
(def phone-x-thin (icon-component svg/phone-x-thin))
(def phone-x-fill (icon-component svg/phone-x-fill))
(def phone-x-duotone (icon-component svg/phone-x-duotone))
(def phosphor-logo-bold (icon-component svg/phosphor-logo-bold))
(def phosphor-logo (icon-component svg/phosphor-logo-regular))
(def phosphor-logo-light (icon-component svg/phosphor-logo-light))
(def phosphor-logo-thin (icon-component svg/phosphor-logo-thin))
(def phosphor-logo-fill (icon-component svg/phosphor-logo-fill))
(def phosphor-logo-duotone (icon-component svg/phosphor-logo-duotone))
(def pi-bold (icon-component svg/pi-bold))
(def pi (icon-component svg/pi-regular))
(def pi-light (icon-component svg/pi-light))
(def pi-thin (icon-component svg/pi-thin))
(def pi-fill (icon-component svg/pi-fill))
(def pi-duotone (icon-component svg/pi-duotone))
(def piano-keys-bold (icon-component svg/piano-keys-bold))
(def piano-keys (icon-component svg/piano-keys-regular))
(def piano-keys-light (icon-component svg/piano-keys-light))
(def piano-keys-thin (icon-component svg/piano-keys-thin))
(def piano-keys-fill (icon-component svg/piano-keys-fill))
(def piano-keys-duotone (icon-component svg/piano-keys-duotone))
(def picnic-table-bold (icon-component svg/picnic-table-bold))
(def picnic-table (icon-component svg/picnic-table-regular))
(def picnic-table-light (icon-component svg/picnic-table-light))
(def picnic-table-thin (icon-component svg/picnic-table-thin))
(def picnic-table-fill (icon-component svg/picnic-table-fill))
(def picnic-table-duotone (icon-component svg/picnic-table-duotone))
(def picture-in-picture-bold (icon-component svg/picture-in-picture-bold))
(def picture-in-picture (icon-component svg/picture-in-picture-regular))
(def picture-in-picture-light (icon-component svg/picture-in-picture-light))
(def picture-in-picture-thin (icon-component svg/picture-in-picture-thin))
(def picture-in-picture-fill (icon-component svg/picture-in-picture-fill))
(def picture-in-picture-duotone (icon-component svg/picture-in-picture-duotone))
(def piggy-bank-bold (icon-component svg/piggy-bank-bold))
(def piggy-bank (icon-component svg/piggy-bank-regular))
(def piggy-bank-light (icon-component svg/piggy-bank-light))
(def piggy-bank-thin (icon-component svg/piggy-bank-thin))
(def piggy-bank-fill (icon-component svg/piggy-bank-fill))
(def piggy-bank-duotone (icon-component svg/piggy-bank-duotone))
(def pill-bold (icon-component svg/pill-bold))
(def pill (icon-component svg/pill-regular))
(def pill-light (icon-component svg/pill-light))
(def pill-thin (icon-component svg/pill-thin))
(def pill-fill (icon-component svg/pill-fill))
(def pill-duotone (icon-component svg/pill-duotone))
(def ping-pong-bold (icon-component svg/ping-pong-bold))
(def ping-pong (icon-component svg/ping-pong-regular))
(def ping-pong-light (icon-component svg/ping-pong-light))
(def ping-pong-thin (icon-component svg/ping-pong-thin))
(def ping-pong-fill (icon-component svg/ping-pong-fill))
(def ping-pong-duotone (icon-component svg/ping-pong-duotone))
(def pint-glass-bold (icon-component svg/pint-glass-bold))
(def pint-glass (icon-component svg/pint-glass-regular))
(def pint-glass-light (icon-component svg/pint-glass-light))
(def pint-glass-thin (icon-component svg/pint-glass-thin))
(def pint-glass-fill (icon-component svg/pint-glass-fill))
(def pint-glass-duotone (icon-component svg/pint-glass-duotone))
(def pinterest-logo-bold (icon-component svg/pinterest-logo-bold))
(def pinterest-logo (icon-component svg/pinterest-logo-regular))
(def pinterest-logo-light (icon-component svg/pinterest-logo-light))
(def pinterest-logo-thin (icon-component svg/pinterest-logo-thin))
(def pinterest-logo-fill (icon-component svg/pinterest-logo-fill))
(def pinterest-logo-duotone (icon-component svg/pinterest-logo-duotone))
(def pinwheel-bold (icon-component svg/pinwheel-bold))
(def pinwheel (icon-component svg/pinwheel-regular))
(def pinwheel-light (icon-component svg/pinwheel-light))
(def pinwheel-thin (icon-component svg/pinwheel-thin))
(def pinwheel-fill (icon-component svg/pinwheel-fill))
(def pinwheel-duotone (icon-component svg/pinwheel-duotone))
(def pipe-bold (icon-component svg/pipe-bold))
(def pipe (icon-component svg/pipe-regular))
(def pipe-light (icon-component svg/pipe-light))
(def pipe-thin (icon-component svg/pipe-thin))
(def pipe-fill (icon-component svg/pipe-fill))
(def pipe-duotone (icon-component svg/pipe-duotone))
(def pipe-wrench-bold (icon-component svg/pipe-wrench-bold))
(def pipe-wrench (icon-component svg/pipe-wrench-regular))
(def pipe-wrench-light (icon-component svg/pipe-wrench-light))
(def pipe-wrench-thin (icon-component svg/pipe-wrench-thin))
(def pipe-wrench-fill (icon-component svg/pipe-wrench-fill))
(def pipe-wrench-duotone (icon-component svg/pipe-wrench-duotone))
(def pix-logo-bold (icon-component svg/pix-logo-bold))
(def pix-logo (icon-component svg/pix-logo-regular))
(def pix-logo-light (icon-component svg/pix-logo-light))
(def pix-logo-thin (icon-component svg/pix-logo-thin))
(def pix-logo-fill (icon-component svg/pix-logo-fill))
(def pix-logo-duotone (icon-component svg/pix-logo-duotone))
(def pizza-bold (icon-component svg/pizza-bold))
(def pizza (icon-component svg/pizza-regular))
(def pizza-light (icon-component svg/pizza-light))
(def pizza-thin (icon-component svg/pizza-thin))
(def pizza-fill (icon-component svg/pizza-fill))
(def pizza-duotone (icon-component svg/pizza-duotone))
(def placeholder-bold (icon-component svg/placeholder-bold))
(def placeholder (icon-component svg/placeholder-regular))
(def placeholder-light (icon-component svg/placeholder-light))
(def placeholder-thin (icon-component svg/placeholder-thin))
(def placeholder-fill (icon-component svg/placeholder-fill))
(def placeholder-duotone (icon-component svg/placeholder-duotone))
(def planet-bold (icon-component svg/planet-bold))
(def planet (icon-component svg/planet-regular))
(def planet-light (icon-component svg/planet-light))
(def planet-thin (icon-component svg/planet-thin))
(def planet-fill (icon-component svg/planet-fill))
(def planet-duotone (icon-component svg/planet-duotone))
(def plant-bold (icon-component svg/plant-bold))
(def plant (icon-component svg/plant-regular))
(def plant-light (icon-component svg/plant-light))
(def plant-thin (icon-component svg/plant-thin))
(def plant-fill (icon-component svg/plant-fill))
(def plant-duotone (icon-component svg/plant-duotone))
(def play-bold (icon-component svg/play-bold))
(def play (icon-component svg/play-regular))
(def play-light (icon-component svg/play-light))
(def play-thin (icon-component svg/play-thin))
(def play-fill (icon-component svg/play-fill))
(def play-duotone (icon-component svg/play-duotone))
(def play-circle-bold (icon-component svg/play-circle-bold))
(def play-circle (icon-component svg/play-circle-regular))
(def play-circle-light (icon-component svg/play-circle-light))
(def play-circle-thin (icon-component svg/play-circle-thin))
(def play-circle-fill (icon-component svg/play-circle-fill))
(def play-circle-duotone (icon-component svg/play-circle-duotone))
(def play-pause-bold (icon-component svg/play-pause-bold))
(def play-pause (icon-component svg/play-pause-regular))
(def play-pause-light (icon-component svg/play-pause-light))
(def play-pause-thin (icon-component svg/play-pause-thin))
(def play-pause-fill (icon-component svg/play-pause-fill))
(def play-pause-duotone (icon-component svg/play-pause-duotone))
(def playlist-bold (icon-component svg/playlist-bold))
(def playlist (icon-component svg/playlist-regular))
(def playlist-light (icon-component svg/playlist-light))
(def playlist-thin (icon-component svg/playlist-thin))
(def playlist-fill (icon-component svg/playlist-fill))
(def playlist-duotone (icon-component svg/playlist-duotone))
(def plug-bold (icon-component svg/plug-bold))
(def plug (icon-component svg/plug-regular))
(def plug-light (icon-component svg/plug-light))
(def plug-thin (icon-component svg/plug-thin))
(def plug-fill (icon-component svg/plug-fill))
(def plug-duotone (icon-component svg/plug-duotone))
(def plug-charging-bold (icon-component svg/plug-charging-bold))
(def plug-charging (icon-component svg/plug-charging-regular))
(def plug-charging-light (icon-component svg/plug-charging-light))
(def plug-charging-thin (icon-component svg/plug-charging-thin))
(def plug-charging-fill (icon-component svg/plug-charging-fill))
(def plug-charging-duotone (icon-component svg/plug-charging-duotone))
(def plugs-bold (icon-component svg/plugs-bold))
(def plugs (icon-component svg/plugs-regular))
(def plugs-light (icon-component svg/plugs-light))
(def plugs-thin (icon-component svg/plugs-thin))
(def plugs-fill (icon-component svg/plugs-fill))
(def plugs-duotone (icon-component svg/plugs-duotone))
(def plugs-connected-bold (icon-component svg/plugs-connected-bold))
(def plugs-connected (icon-component svg/plugs-connected-regular))
(def plugs-connected-light (icon-component svg/plugs-connected-light))
(def plugs-connected-thin (icon-component svg/plugs-connected-thin))
(def plugs-connected-fill (icon-component svg/plugs-connected-fill))
(def plugs-connected-duotone (icon-component svg/plugs-connected-duotone))
(def plus-bold (icon-component svg/plus-bold))
(def plus (icon-component svg/plus-regular))
(def plus-light (icon-component svg/plus-light))
(def plus-thin (icon-component svg/plus-thin))
(def plus-fill (icon-component svg/plus-fill))
(def plus-duotone (icon-component svg/plus-duotone))
(def plus-circle-bold (icon-component svg/plus-circle-bold))
(def plus-circle (icon-component svg/plus-circle-regular))
(def plus-circle-light (icon-component svg/plus-circle-light))
(def plus-circle-thin (icon-component svg/plus-circle-thin))
(def plus-circle-fill (icon-component svg/plus-circle-fill))
(def plus-circle-duotone (icon-component svg/plus-circle-duotone))
(def plus-minus-bold (icon-component svg/plus-minus-bold))
(def plus-minus (icon-component svg/plus-minus-regular))
(def plus-minus-light (icon-component svg/plus-minus-light))
(def plus-minus-thin (icon-component svg/plus-minus-thin))
(def plus-minus-fill (icon-component svg/plus-minus-fill))
(def plus-minus-duotone (icon-component svg/plus-minus-duotone))
(def plus-square-bold (icon-component svg/plus-square-bold))
(def plus-square (icon-component svg/plus-square-regular))
(def plus-square-light (icon-component svg/plus-square-light))
(def plus-square-thin (icon-component svg/plus-square-thin))
(def plus-square-fill (icon-component svg/plus-square-fill))
(def plus-square-duotone (icon-component svg/plus-square-duotone))
(def poker-chip-bold (icon-component svg/poker-chip-bold))
(def poker-chip (icon-component svg/poker-chip-regular))
(def poker-chip-light (icon-component svg/poker-chip-light))
(def poker-chip-thin (icon-component svg/poker-chip-thin))
(def poker-chip-fill (icon-component svg/poker-chip-fill))
(def poker-chip-duotone (icon-component svg/poker-chip-duotone))
(def police-car-bold (icon-component svg/police-car-bold))
(def police-car (icon-component svg/police-car-regular))
(def police-car-light (icon-component svg/police-car-light))
(def police-car-thin (icon-component svg/police-car-thin))
(def police-car-fill (icon-component svg/police-car-fill))
(def police-car-duotone (icon-component svg/police-car-duotone))
(def polygon-bold (icon-component svg/polygon-bold))
(def polygon (icon-component svg/polygon-regular))
(def polygon-light (icon-component svg/polygon-light))
(def polygon-thin (icon-component svg/polygon-thin))
(def polygon-fill (icon-component svg/polygon-fill))
(def polygon-duotone (icon-component svg/polygon-duotone))
(def popcorn-bold (icon-component svg/popcorn-bold))
(def popcorn (icon-component svg/popcorn-regular))
(def popcorn-light (icon-component svg/popcorn-light))
(def popcorn-thin (icon-component svg/popcorn-thin))
(def popcorn-fill (icon-component svg/popcorn-fill))
(def popcorn-duotone (icon-component svg/popcorn-duotone))
(def popsicle-bold (icon-component svg/popsicle-bold))
(def popsicle (icon-component svg/popsicle-regular))
(def popsicle-light (icon-component svg/popsicle-light))
(def popsicle-thin (icon-component svg/popsicle-thin))
(def popsicle-fill (icon-component svg/popsicle-fill))
(def popsicle-duotone (icon-component svg/popsicle-duotone))
(def potted-plant-bold (icon-component svg/potted-plant-bold))
(def potted-plant (icon-component svg/potted-plant-regular))
(def potted-plant-light (icon-component svg/potted-plant-light))
(def potted-plant-thin (icon-component svg/potted-plant-thin))
(def potted-plant-fill (icon-component svg/potted-plant-fill))
(def potted-plant-duotone (icon-component svg/potted-plant-duotone))
(def power-bold (icon-component svg/power-bold))
(def power (icon-component svg/power-regular))
(def power-light (icon-component svg/power-light))
(def power-thin (icon-component svg/power-thin))
(def power-fill (icon-component svg/power-fill))
(def power-duotone (icon-component svg/power-duotone))
(def prescription-bold (icon-component svg/prescription-bold))
(def prescription (icon-component svg/prescription-regular))
(def prescription-light (icon-component svg/prescription-light))
(def prescription-thin (icon-component svg/prescription-thin))
(def prescription-fill (icon-component svg/prescription-fill))
(def prescription-duotone (icon-component svg/prescription-duotone))
(def presentation-bold (icon-component svg/presentation-bold))
(def presentation (icon-component svg/presentation-regular))
(def presentation-light (icon-component svg/presentation-light))
(def presentation-thin (icon-component svg/presentation-thin))
(def presentation-fill (icon-component svg/presentation-fill))
(def presentation-duotone (icon-component svg/presentation-duotone))
(def presentation-chart-bold (icon-component svg/presentation-chart-bold))
(def presentation-chart (icon-component svg/presentation-chart-regular))
(def presentation-chart-light (icon-component svg/presentation-chart-light))
(def presentation-chart-thin (icon-component svg/presentation-chart-thin))
(def presentation-chart-fill (icon-component svg/presentation-chart-fill))
(def presentation-chart-duotone (icon-component svg/presentation-chart-duotone))
(def printer-bold (icon-component svg/printer-bold))
(def printer (icon-component svg/printer-regular))
(def printer-light (icon-component svg/printer-light))
(def printer-thin (icon-component svg/printer-thin))
(def printer-fill (icon-component svg/printer-fill))
(def printer-duotone (icon-component svg/printer-duotone))
(def prohibit-bold (icon-component svg/prohibit-bold))
(def prohibit (icon-component svg/prohibit-regular))
(def prohibit-light (icon-component svg/prohibit-light))
(def prohibit-thin (icon-component svg/prohibit-thin))
(def prohibit-fill (icon-component svg/prohibit-fill))
(def prohibit-duotone (icon-component svg/prohibit-duotone))
(def prohibit-inset-bold (icon-component svg/prohibit-inset-bold))
(def prohibit-inset (icon-component svg/prohibit-inset-regular))
(def prohibit-inset-light (icon-component svg/prohibit-inset-light))
(def prohibit-inset-thin (icon-component svg/prohibit-inset-thin))
(def prohibit-inset-fill (icon-component svg/prohibit-inset-fill))
(def prohibit-inset-duotone (icon-component svg/prohibit-inset-duotone))
(def projector-screen-bold (icon-component svg/projector-screen-bold))
(def projector-screen (icon-component svg/projector-screen-regular))
(def projector-screen-light (icon-component svg/projector-screen-light))
(def projector-screen-thin (icon-component svg/projector-screen-thin))
(def projector-screen-fill (icon-component svg/projector-screen-fill))
(def projector-screen-duotone (icon-component svg/projector-screen-duotone))
(def projector-screen-chart-bold (icon-component svg/projector-screen-chart-bold))
(def projector-screen-chart (icon-component svg/projector-screen-chart-regular))
(def projector-screen-chart-light (icon-component svg/projector-screen-chart-light))
(def projector-screen-chart-thin (icon-component svg/projector-screen-chart-thin))
(def projector-screen-chart-fill (icon-component svg/projector-screen-chart-fill))
(def projector-screen-chart-duotone (icon-component svg/projector-screen-chart-duotone))
(def pulse-bold (icon-component svg/pulse-bold))
(def pulse (icon-component svg/pulse-regular))
(def pulse-light (icon-component svg/pulse-light))
(def pulse-thin (icon-component svg/pulse-thin))
(def pulse-fill (icon-component svg/pulse-fill))
(def pulse-duotone (icon-component svg/pulse-duotone))
(def push-pin-bold (icon-component svg/push-pin-bold))
(def push-pin (icon-component svg/push-pin-regular))
(def push-pin-light (icon-component svg/push-pin-light))
(def push-pin-thin (icon-component svg/push-pin-thin))
(def push-pin-fill (icon-component svg/push-pin-fill))
(def push-pin-duotone (icon-component svg/push-pin-duotone))
(def push-pin-simple-bold (icon-component svg/push-pin-simple-bold))
(def push-pin-simple (icon-component svg/push-pin-simple-regular))
(def push-pin-simple-light (icon-component svg/push-pin-simple-light))
(def push-pin-simple-thin (icon-component svg/push-pin-simple-thin))
(def push-pin-simple-fill (icon-component svg/push-pin-simple-fill))
(def push-pin-simple-duotone (icon-component svg/push-pin-simple-duotone))
(def push-pin-simple-slash-bold (icon-component svg/push-pin-simple-slash-bold))
(def push-pin-simple-slash (icon-component svg/push-pin-simple-slash-regular))
(def push-pin-simple-slash-light (icon-component svg/push-pin-simple-slash-light))
(def push-pin-simple-slash-thin (icon-component svg/push-pin-simple-slash-thin))
(def push-pin-simple-slash-fill (icon-component svg/push-pin-simple-slash-fill))
(def push-pin-simple-slash-duotone (icon-component svg/push-pin-simple-slash-duotone))
(def push-pin-slash-bold (icon-component svg/push-pin-slash-bold))
(def push-pin-slash (icon-component svg/push-pin-slash-regular))
(def push-pin-slash-light (icon-component svg/push-pin-slash-light))
(def push-pin-slash-thin (icon-component svg/push-pin-slash-thin))
(def push-pin-slash-fill (icon-component svg/push-pin-slash-fill))
(def push-pin-slash-duotone (icon-component svg/push-pin-slash-duotone))
(def puzzle-piece-bold (icon-component svg/puzzle-piece-bold))
(def puzzle-piece (icon-component svg/puzzle-piece-regular))
(def puzzle-piece-light (icon-component svg/puzzle-piece-light))
(def puzzle-piece-thin (icon-component svg/puzzle-piece-thin))
(def puzzle-piece-fill (icon-component svg/puzzle-piece-fill))
(def puzzle-piece-duotone (icon-component svg/puzzle-piece-duotone))
(def qr-code-bold (icon-component svg/qr-code-bold))
(def qr-code (icon-component svg/qr-code-regular))
(def qr-code-light (icon-component svg/qr-code-light))
(def qr-code-thin (icon-component svg/qr-code-thin))
(def qr-code-fill (icon-component svg/qr-code-fill))
(def qr-code-duotone (icon-component svg/qr-code-duotone))
(def question-bold (icon-component svg/question-bold))
(def question (icon-component svg/question-regular))
(def question-light (icon-component svg/question-light))
(def question-thin (icon-component svg/question-thin))
(def question-fill (icon-component svg/question-fill))
(def question-duotone (icon-component svg/question-duotone))
(def question-mark-bold (icon-component svg/question-mark-bold))
(def question-mark (icon-component svg/question-mark-regular))
(def question-mark-light (icon-component svg/question-mark-light))
(def question-mark-thin (icon-component svg/question-mark-thin))
(def question-mark-fill (icon-component svg/question-mark-fill))
(def question-mark-duotone (icon-component svg/question-mark-duotone))
(def queue-bold (icon-component svg/queue-bold))
(def queue (icon-component svg/queue-regular))
(def queue-light (icon-component svg/queue-light))
(def queue-thin (icon-component svg/queue-thin))
(def queue-fill (icon-component svg/queue-fill))
(def queue-duotone (icon-component svg/queue-duotone))
(def quotes-bold (icon-component svg/quotes-bold))
(def quotes (icon-component svg/quotes-regular))
(def quotes-light (icon-component svg/quotes-light))
(def quotes-thin (icon-component svg/quotes-thin))
(def quotes-fill (icon-component svg/quotes-fill))
(def quotes-duotone (icon-component svg/quotes-duotone))
(def rabbit-bold (icon-component svg/rabbit-bold))
(def rabbit (icon-component svg/rabbit-regular))
(def rabbit-light (icon-component svg/rabbit-light))
(def rabbit-thin (icon-component svg/rabbit-thin))
(def rabbit-fill (icon-component svg/rabbit-fill))
(def rabbit-duotone (icon-component svg/rabbit-duotone))
(def racquet-bold (icon-component svg/racquet-bold))
(def racquet (icon-component svg/racquet-regular))
(def racquet-light (icon-component svg/racquet-light))
(def racquet-thin (icon-component svg/racquet-thin))
(def racquet-fill (icon-component svg/racquet-fill))
(def racquet-duotone (icon-component svg/racquet-duotone))
(def radical-bold (icon-component svg/radical-bold))
(def radical (icon-component svg/radical-regular))
(def radical-light (icon-component svg/radical-light))
(def radical-thin (icon-component svg/radical-thin))
(def radical-fill (icon-component svg/radical-fill))
(def radical-duotone (icon-component svg/radical-duotone))
(def radio-bold (icon-component svg/radio-bold))
(def radio (icon-component svg/radio-regular))
(def radio-light (icon-component svg/radio-light))
(def radio-thin (icon-component svg/radio-thin))
(def radio-fill (icon-component svg/radio-fill))
(def radio-duotone (icon-component svg/radio-duotone))
(def radio-button-bold (icon-component svg/radio-button-bold))
(def radio-button (icon-component svg/radio-button-regular))
(def radio-button-light (icon-component svg/radio-button-light))
(def radio-button-thin (icon-component svg/radio-button-thin))
(def radio-button-fill (icon-component svg/radio-button-fill))
(def radio-button-duotone (icon-component svg/radio-button-duotone))
(def radioactive-bold (icon-component svg/radioactive-bold))
(def radioactive (icon-component svg/radioactive-regular))
(def radioactive-light (icon-component svg/radioactive-light))
(def radioactive-thin (icon-component svg/radioactive-thin))
(def radioactive-fill (icon-component svg/radioactive-fill))
(def radioactive-duotone (icon-component svg/radioactive-duotone))
(def rainbow-bold (icon-component svg/rainbow-bold))
(def rainbow (icon-component svg/rainbow-regular))
(def rainbow-light (icon-component svg/rainbow-light))
(def rainbow-thin (icon-component svg/rainbow-thin))
(def rainbow-fill (icon-component svg/rainbow-fill))
(def rainbow-duotone (icon-component svg/rainbow-duotone))
(def rainbow-cloud-bold (icon-component svg/rainbow-cloud-bold))
(def rainbow-cloud (icon-component svg/rainbow-cloud-regular))
(def rainbow-cloud-light (icon-component svg/rainbow-cloud-light))
(def rainbow-cloud-thin (icon-component svg/rainbow-cloud-thin))
(def rainbow-cloud-fill (icon-component svg/rainbow-cloud-fill))
(def rainbow-cloud-duotone (icon-component svg/rainbow-cloud-duotone))
(def ranking-bold (icon-component svg/ranking-bold))
(def ranking (icon-component svg/ranking-regular))
(def ranking-light (icon-component svg/ranking-light))
(def ranking-thin (icon-component svg/ranking-thin))
(def ranking-fill (icon-component svg/ranking-fill))
(def ranking-duotone (icon-component svg/ranking-duotone))
(def read-cv-logo-bold (icon-component svg/read-cv-logo-bold))
(def read-cv-logo (icon-component svg/read-cv-logo-regular))
(def read-cv-logo-light (icon-component svg/read-cv-logo-light))
(def read-cv-logo-thin (icon-component svg/read-cv-logo-thin))
(def read-cv-logo-fill (icon-component svg/read-cv-logo-fill))
(def read-cv-logo-duotone (icon-component svg/read-cv-logo-duotone))
(def receipt-bold (icon-component svg/receipt-bold))
(def receipt (icon-component svg/receipt-regular))
(def receipt-light (icon-component svg/receipt-light))
(def receipt-thin (icon-component svg/receipt-thin))
(def receipt-fill (icon-component svg/receipt-fill))
(def receipt-duotone (icon-component svg/receipt-duotone))
(def receipt-x-bold (icon-component svg/receipt-x-bold))
(def receipt-x (icon-component svg/receipt-x-regular))
(def receipt-x-light (icon-component svg/receipt-x-light))
(def receipt-x-thin (icon-component svg/receipt-x-thin))
(def receipt-x-fill (icon-component svg/receipt-x-fill))
(def receipt-x-duotone (icon-component svg/receipt-x-duotone))
(def record-bold (icon-component svg/record-bold))
(def record (icon-component svg/record-regular))
(def record-light (icon-component svg/record-light))
(def record-thin (icon-component svg/record-thin))
(def record-fill (icon-component svg/record-fill))
(def record-duotone (icon-component svg/record-duotone))
(def rectangle-bold (icon-component svg/rectangle-bold))
(def rectangle (icon-component svg/rectangle-regular))
(def rectangle-light (icon-component svg/rectangle-light))
(def rectangle-thin (icon-component svg/rectangle-thin))
(def rectangle-fill (icon-component svg/rectangle-fill))
(def rectangle-duotone (icon-component svg/rectangle-duotone))
(def rectangle-dashed-bold (icon-component svg/rectangle-dashed-bold))
(def rectangle-dashed (icon-component svg/rectangle-dashed-regular))
(def rectangle-dashed-light (icon-component svg/rectangle-dashed-light))
(def rectangle-dashed-thin (icon-component svg/rectangle-dashed-thin))
(def rectangle-dashed-fill (icon-component svg/rectangle-dashed-fill))
(def rectangle-dashed-duotone (icon-component svg/rectangle-dashed-duotone))
(def recycle-bold (icon-component svg/recycle-bold))
(def recycle (icon-component svg/recycle-regular))
(def recycle-light (icon-component svg/recycle-light))
(def recycle-thin (icon-component svg/recycle-thin))
(def recycle-fill (icon-component svg/recycle-fill))
(def recycle-duotone (icon-component svg/recycle-duotone))
(def reddit-logo-bold (icon-component svg/reddit-logo-bold))
(def reddit-logo (icon-component svg/reddit-logo-regular))
(def reddit-logo-light (icon-component svg/reddit-logo-light))
(def reddit-logo-thin (icon-component svg/reddit-logo-thin))
(def reddit-logo-fill (icon-component svg/reddit-logo-fill))
(def reddit-logo-duotone (icon-component svg/reddit-logo-duotone))
(def repeat-bold (icon-component svg/repeat-bold))
(def repeat (icon-component svg/repeat-regular))
(def repeat-light (icon-component svg/repeat-light))
(def repeat-thin (icon-component svg/repeat-thin))
(def repeat-fill (icon-component svg/repeat-fill))
(def repeat-duotone (icon-component svg/repeat-duotone))
(def repeat-once-bold (icon-component svg/repeat-once-bold))
(def repeat-once (icon-component svg/repeat-once-regular))
(def repeat-once-light (icon-component svg/repeat-once-light))
(def repeat-once-thin (icon-component svg/repeat-once-thin))
(def repeat-once-fill (icon-component svg/repeat-once-fill))
(def repeat-once-duotone (icon-component svg/repeat-once-duotone))
(def replit-logo-bold (icon-component svg/replit-logo-bold))
(def replit-logo (icon-component svg/replit-logo-regular))
(def replit-logo-light (icon-component svg/replit-logo-light))
(def replit-logo-thin (icon-component svg/replit-logo-thin))
(def replit-logo-fill (icon-component svg/replit-logo-fill))
(def replit-logo-duotone (icon-component svg/replit-logo-duotone))
(def resize-bold (icon-component svg/resize-bold))
(def resize (icon-component svg/resize-regular))
(def resize-light (icon-component svg/resize-light))
(def resize-thin (icon-component svg/resize-thin))
(def resize-fill (icon-component svg/resize-fill))
(def resize-duotone (icon-component svg/resize-duotone))
(def rewind-bold (icon-component svg/rewind-bold))
(def rewind (icon-component svg/rewind-regular))
(def rewind-light (icon-component svg/rewind-light))
(def rewind-thin (icon-component svg/rewind-thin))
(def rewind-fill (icon-component svg/rewind-fill))
(def rewind-duotone (icon-component svg/rewind-duotone))
(def rewind-circle-bold (icon-component svg/rewind-circle-bold))
(def rewind-circle (icon-component svg/rewind-circle-regular))
(def rewind-circle-light (icon-component svg/rewind-circle-light))
(def rewind-circle-thin (icon-component svg/rewind-circle-thin))
(def rewind-circle-fill (icon-component svg/rewind-circle-fill))
(def rewind-circle-duotone (icon-component svg/rewind-circle-duotone))
(def road-horizon-bold (icon-component svg/road-horizon-bold))
(def road-horizon (icon-component svg/road-horizon-regular))
(def road-horizon-light (icon-component svg/road-horizon-light))
(def road-horizon-thin (icon-component svg/road-horizon-thin))
(def road-horizon-fill (icon-component svg/road-horizon-fill))
(def road-horizon-duotone (icon-component svg/road-horizon-duotone))
(def robot-bold (icon-component svg/robot-bold))
(def robot (icon-component svg/robot-regular))
(def robot-light (icon-component svg/robot-light))
(def robot-thin (icon-component svg/robot-thin))
(def robot-fill (icon-component svg/robot-fill))
(def robot-duotone (icon-component svg/robot-duotone))
(def rocket-bold (icon-component svg/rocket-bold))
(def rocket (icon-component svg/rocket-regular))
(def rocket-light (icon-component svg/rocket-light))
(def rocket-thin (icon-component svg/rocket-thin))
(def rocket-fill (icon-component svg/rocket-fill))
(def rocket-duotone (icon-component svg/rocket-duotone))
(def rocket-launch-bold (icon-component svg/rocket-launch-bold))
(def rocket-launch (icon-component svg/rocket-launch-regular))
(def rocket-launch-light (icon-component svg/rocket-launch-light))
(def rocket-launch-thin (icon-component svg/rocket-launch-thin))
(def rocket-launch-fill (icon-component svg/rocket-launch-fill))
(def rocket-launch-duotone (icon-component svg/rocket-launch-duotone))
(def rows-bold (icon-component svg/rows-bold))
(def rows (icon-component svg/rows-regular))
(def rows-light (icon-component svg/rows-light))
(def rows-thin (icon-component svg/rows-thin))
(def rows-fill (icon-component svg/rows-fill))
(def rows-duotone (icon-component svg/rows-duotone))
(def rows-plus-bottom-bold (icon-component svg/rows-plus-bottom-bold))
(def rows-plus-bottom (icon-component svg/rows-plus-bottom-regular))
(def rows-plus-bottom-light (icon-component svg/rows-plus-bottom-light))
(def rows-plus-bottom-thin (icon-component svg/rows-plus-bottom-thin))
(def rows-plus-bottom-fill (icon-component svg/rows-plus-bottom-fill))
(def rows-plus-bottom-duotone (icon-component svg/rows-plus-bottom-duotone))
(def rows-plus-top-bold (icon-component svg/rows-plus-top-bold))
(def rows-plus-top (icon-component svg/rows-plus-top-regular))
(def rows-plus-top-light (icon-component svg/rows-plus-top-light))
(def rows-plus-top-thin (icon-component svg/rows-plus-top-thin))
(def rows-plus-top-fill (icon-component svg/rows-plus-top-fill))
(def rows-plus-top-duotone (icon-component svg/rows-plus-top-duotone))
(def rss-bold (icon-component svg/rss-bold))
(def rss (icon-component svg/rss-regular))
(def rss-light (icon-component svg/rss-light))
(def rss-thin (icon-component svg/rss-thin))
(def rss-fill (icon-component svg/rss-fill))
(def rss-duotone (icon-component svg/rss-duotone))
(def rss-simple-bold (icon-component svg/rss-simple-bold))
(def rss-simple (icon-component svg/rss-simple-regular))
(def rss-simple-light (icon-component svg/rss-simple-light))
(def rss-simple-thin (icon-component svg/rss-simple-thin))
(def rss-simple-fill (icon-component svg/rss-simple-fill))
(def rss-simple-duotone (icon-component svg/rss-simple-duotone))
(def rug-bold (icon-component svg/rug-bold))
(def rug (icon-component svg/rug-regular))
(def rug-light (icon-component svg/rug-light))
(def rug-thin (icon-component svg/rug-thin))
(def rug-fill (icon-component svg/rug-fill))
(def rug-duotone (icon-component svg/rug-duotone))
(def ruler-bold (icon-component svg/ruler-bold))
(def ruler (icon-component svg/ruler-regular))
(def ruler-light (icon-component svg/ruler-light))
(def ruler-thin (icon-component svg/ruler-thin))
(def ruler-fill (icon-component svg/ruler-fill))
(def ruler-duotone (icon-component svg/ruler-duotone))
(def sailboat-bold (icon-component svg/sailboat-bold))
(def sailboat (icon-component svg/sailboat-regular))
(def sailboat-light (icon-component svg/sailboat-light))
(def sailboat-thin (icon-component svg/sailboat-thin))
(def sailboat-fill (icon-component svg/sailboat-fill))
(def sailboat-duotone (icon-component svg/sailboat-duotone))
(def scales-bold (icon-component svg/scales-bold))
(def scales (icon-component svg/scales-regular))
(def scales-light (icon-component svg/scales-light))
(def scales-thin (icon-component svg/scales-thin))
(def scales-fill (icon-component svg/scales-fill))
(def scales-duotone (icon-component svg/scales-duotone))
(def scan-bold (icon-component svg/scan-bold))
(def scan (icon-component svg/scan-regular))
(def scan-light (icon-component svg/scan-light))
(def scan-thin (icon-component svg/scan-thin))
(def scan-fill (icon-component svg/scan-fill))
(def scan-duotone (icon-component svg/scan-duotone))
(def scan-smiley-bold (icon-component svg/scan-smiley-bold))
(def scan-smiley (icon-component svg/scan-smiley-regular))
(def scan-smiley-light (icon-component svg/scan-smiley-light))
(def scan-smiley-thin (icon-component svg/scan-smiley-thin))
(def scan-smiley-fill (icon-component svg/scan-smiley-fill))
(def scan-smiley-duotone (icon-component svg/scan-smiley-duotone))
(def scissors-bold (icon-component svg/scissors-bold))
(def scissors (icon-component svg/scissors-regular))
(def scissors-light (icon-component svg/scissors-light))
(def scissors-thin (icon-component svg/scissors-thin))
(def scissors-fill (icon-component svg/scissors-fill))
(def scissors-duotone (icon-component svg/scissors-duotone))
(def scooter-bold (icon-component svg/scooter-bold))
(def scooter (icon-component svg/scooter-regular))
(def scooter-light (icon-component svg/scooter-light))
(def scooter-thin (icon-component svg/scooter-thin))
(def scooter-fill (icon-component svg/scooter-fill))
(def scooter-duotone (icon-component svg/scooter-duotone))
(def screencast-bold (icon-component svg/screencast-bold))
(def screencast (icon-component svg/screencast-regular))
(def screencast-light (icon-component svg/screencast-light))
(def screencast-thin (icon-component svg/screencast-thin))
(def screencast-fill (icon-component svg/screencast-fill))
(def screencast-duotone (icon-component svg/screencast-duotone))
(def screwdriver-bold (icon-component svg/screwdriver-bold))
(def screwdriver (icon-component svg/screwdriver-regular))
(def screwdriver-light (icon-component svg/screwdriver-light))
(def screwdriver-thin (icon-component svg/screwdriver-thin))
(def screwdriver-fill (icon-component svg/screwdriver-fill))
(def screwdriver-duotone (icon-component svg/screwdriver-duotone))
(def scribble-bold (icon-component svg/scribble-bold))
(def scribble (icon-component svg/scribble-regular))
(def scribble-light (icon-component svg/scribble-light))
(def scribble-thin (icon-component svg/scribble-thin))
(def scribble-fill (icon-component svg/scribble-fill))
(def scribble-duotone (icon-component svg/scribble-duotone))
(def scribble-loop-bold (icon-component svg/scribble-loop-bold))
(def scribble-loop (icon-component svg/scribble-loop-regular))
(def scribble-loop-light (icon-component svg/scribble-loop-light))
(def scribble-loop-thin (icon-component svg/scribble-loop-thin))
(def scribble-loop-fill (icon-component svg/scribble-loop-fill))
(def scribble-loop-duotone (icon-component svg/scribble-loop-duotone))
(def scroll-bold (icon-component svg/scroll-bold))
(def scroll (icon-component svg/scroll-regular))
(def scroll-light (icon-component svg/scroll-light))
(def scroll-thin (icon-component svg/scroll-thin))
(def scroll-fill (icon-component svg/scroll-fill))
(def scroll-duotone (icon-component svg/scroll-duotone))
(def seal-bold (icon-component svg/seal-bold))
(def seal (icon-component svg/seal-regular))
(def seal-light (icon-component svg/seal-light))
(def seal-thin (icon-component svg/seal-thin))
(def seal-fill (icon-component svg/seal-fill))
(def seal-duotone (icon-component svg/seal-duotone))
(def seal-check-bold (icon-component svg/seal-check-bold))
(def seal-check (icon-component svg/seal-check-regular))
(def seal-check-light (icon-component svg/seal-check-light))
(def seal-check-thin (icon-component svg/seal-check-thin))
(def seal-check-fill (icon-component svg/seal-check-fill))
(def seal-check-duotone (icon-component svg/seal-check-duotone))
(def seal-percent-bold (icon-component svg/seal-percent-bold))
(def seal-percent (icon-component svg/seal-percent-regular))
(def seal-percent-light (icon-component svg/seal-percent-light))
(def seal-percent-thin (icon-component svg/seal-percent-thin))
(def seal-percent-fill (icon-component svg/seal-percent-fill))
(def seal-percent-duotone (icon-component svg/seal-percent-duotone))
(def seal-question-bold (icon-component svg/seal-question-bold))
(def seal-question (icon-component svg/seal-question-regular))
(def seal-question-light (icon-component svg/seal-question-light))
(def seal-question-thin (icon-component svg/seal-question-thin))
(def seal-question-fill (icon-component svg/seal-question-fill))
(def seal-question-duotone (icon-component svg/seal-question-duotone))
(def seal-warning-bold (icon-component svg/seal-warning-bold))
(def seal-warning (icon-component svg/seal-warning-regular))
(def seal-warning-light (icon-component svg/seal-warning-light))
(def seal-warning-thin (icon-component svg/seal-warning-thin))
(def seal-warning-fill (icon-component svg/seal-warning-fill))
(def seal-warning-duotone (icon-component svg/seal-warning-duotone))
(def seat-bold (icon-component svg/seat-bold))
(def seat (icon-component svg/seat-regular))
(def seat-light (icon-component svg/seat-light))
(def seat-thin (icon-component svg/seat-thin))
(def seat-fill (icon-component svg/seat-fill))
(def seat-duotone (icon-component svg/seat-duotone))
(def seatbelt-bold (icon-component svg/seatbelt-bold))
(def seatbelt (icon-component svg/seatbelt-regular))
(def seatbelt-light (icon-component svg/seatbelt-light))
(def seatbelt-thin (icon-component svg/seatbelt-thin))
(def seatbelt-fill (icon-component svg/seatbelt-fill))
(def seatbelt-duotone (icon-component svg/seatbelt-duotone))
(def security-camera-bold (icon-component svg/security-camera-bold))
(def security-camera (icon-component svg/security-camera-regular))
(def security-camera-light (icon-component svg/security-camera-light))
(def security-camera-thin (icon-component svg/security-camera-thin))
(def security-camera-fill (icon-component svg/security-camera-fill))
(def security-camera-duotone (icon-component svg/security-camera-duotone))
(def selection-bold (icon-component svg/selection-bold))
(def selection (icon-component svg/selection-regular))
(def selection-light (icon-component svg/selection-light))
(def selection-thin (icon-component svg/selection-thin))
(def selection-fill (icon-component svg/selection-fill))
(def selection-duotone (icon-component svg/selection-duotone))
(def selection-all-bold (icon-component svg/selection-all-bold))
(def selection-all (icon-component svg/selection-all-regular))
(def selection-all-light (icon-component svg/selection-all-light))
(def selection-all-thin (icon-component svg/selection-all-thin))
(def selection-all-fill (icon-component svg/selection-all-fill))
(def selection-all-duotone (icon-component svg/selection-all-duotone))
(def selection-background-bold (icon-component svg/selection-background-bold))
(def selection-background (icon-component svg/selection-background-regular))
(def selection-background-light (icon-component svg/selection-background-light))
(def selection-background-thin (icon-component svg/selection-background-thin))
(def selection-background-fill (icon-component svg/selection-background-fill))
(def selection-background-duotone (icon-component svg/selection-background-duotone))
(def selection-foreground-bold (icon-component svg/selection-foreground-bold))
(def selection-foreground (icon-component svg/selection-foreground-regular))
(def selection-foreground-light (icon-component svg/selection-foreground-light))
(def selection-foreground-thin (icon-component svg/selection-foreground-thin))
(def selection-foreground-fill (icon-component svg/selection-foreground-fill))
(def selection-foreground-duotone (icon-component svg/selection-foreground-duotone))
(def selection-inverse-bold (icon-component svg/selection-inverse-bold))
(def selection-inverse (icon-component svg/selection-inverse-regular))
(def selection-inverse-light (icon-component svg/selection-inverse-light))
(def selection-inverse-thin (icon-component svg/selection-inverse-thin))
(def selection-inverse-fill (icon-component svg/selection-inverse-fill))
(def selection-inverse-duotone (icon-component svg/selection-inverse-duotone))
(def selection-plus-bold (icon-component svg/selection-plus-bold))
(def selection-plus (icon-component svg/selection-plus-regular))
(def selection-plus-light (icon-component svg/selection-plus-light))
(def selection-plus-thin (icon-component svg/selection-plus-thin))
(def selection-plus-fill (icon-component svg/selection-plus-fill))
(def selection-plus-duotone (icon-component svg/selection-plus-duotone))
(def selection-slash-bold (icon-component svg/selection-slash-bold))
(def selection-slash (icon-component svg/selection-slash-regular))
(def selection-slash-light (icon-component svg/selection-slash-light))
(def selection-slash-thin (icon-component svg/selection-slash-thin))
(def selection-slash-fill (icon-component svg/selection-slash-fill))
(def selection-slash-duotone (icon-component svg/selection-slash-duotone))
(def shapes-bold (icon-component svg/shapes-bold))
(def shapes (icon-component svg/shapes-regular))
(def shapes-light (icon-component svg/shapes-light))
(def shapes-thin (icon-component svg/shapes-thin))
(def shapes-fill (icon-component svg/shapes-fill))
(def shapes-duotone (icon-component svg/shapes-duotone))
(def share-bold (icon-component svg/share-bold))
(def share (icon-component svg/share-regular))
(def share-light (icon-component svg/share-light))
(def share-thin (icon-component svg/share-thin))
(def share-fill (icon-component svg/share-fill))
(def share-duotone (icon-component svg/share-duotone))
(def share-fat-bold (icon-component svg/share-fat-bold))
(def share-fat (icon-component svg/share-fat-regular))
(def share-fat-light (icon-component svg/share-fat-light))
(def share-fat-thin (icon-component svg/share-fat-thin))
(def share-fat-fill (icon-component svg/share-fat-fill))
(def share-fat-duotone (icon-component svg/share-fat-duotone))
(def share-network-bold (icon-component svg/share-network-bold))
(def share-network (icon-component svg/share-network-regular))
(def share-network-light (icon-component svg/share-network-light))
(def share-network-thin (icon-component svg/share-network-thin))
(def share-network-fill (icon-component svg/share-network-fill))
(def share-network-duotone (icon-component svg/share-network-duotone))
(def shield-bold (icon-component svg/shield-bold))
(def shield (icon-component svg/shield-regular))
(def shield-light (icon-component svg/shield-light))
(def shield-thin (icon-component svg/shield-thin))
(def shield-fill (icon-component svg/shield-fill))
(def shield-duotone (icon-component svg/shield-duotone))
(def shield-check-bold (icon-component svg/shield-check-bold))
(def shield-check (icon-component svg/shield-check-regular))
(def shield-check-light (icon-component svg/shield-check-light))
(def shield-check-thin (icon-component svg/shield-check-thin))
(def shield-check-fill (icon-component svg/shield-check-fill))
(def shield-check-duotone (icon-component svg/shield-check-duotone))
(def shield-checkered-bold (icon-component svg/shield-checkered-bold))
(def shield-checkered (icon-component svg/shield-checkered-regular))
(def shield-checkered-light (icon-component svg/shield-checkered-light))
(def shield-checkered-thin (icon-component svg/shield-checkered-thin))
(def shield-checkered-fill (icon-component svg/shield-checkered-fill))
(def shield-checkered-duotone (icon-component svg/shield-checkered-duotone))
(def shield-chevron-bold (icon-component svg/shield-chevron-bold))
(def shield-chevron (icon-component svg/shield-chevron-regular))
(def shield-chevron-light (icon-component svg/shield-chevron-light))
(def shield-chevron-thin (icon-component svg/shield-chevron-thin))
(def shield-chevron-fill (icon-component svg/shield-chevron-fill))
(def shield-chevron-duotone (icon-component svg/shield-chevron-duotone))
(def shield-plus-bold (icon-component svg/shield-plus-bold))
(def shield-plus (icon-component svg/shield-plus-regular))
(def shield-plus-light (icon-component svg/shield-plus-light))
(def shield-plus-thin (icon-component svg/shield-plus-thin))
(def shield-plus-fill (icon-component svg/shield-plus-fill))
(def shield-plus-duotone (icon-component svg/shield-plus-duotone))
(def shield-slash-bold (icon-component svg/shield-slash-bold))
(def shield-slash (icon-component svg/shield-slash-regular))
(def shield-slash-light (icon-component svg/shield-slash-light))
(def shield-slash-thin (icon-component svg/shield-slash-thin))
(def shield-slash-fill (icon-component svg/shield-slash-fill))
(def shield-slash-duotone (icon-component svg/shield-slash-duotone))
(def shield-star-bold (icon-component svg/shield-star-bold))
(def shield-star (icon-component svg/shield-star-regular))
(def shield-star-light (icon-component svg/shield-star-light))
(def shield-star-thin (icon-component svg/shield-star-thin))
(def shield-star-fill (icon-component svg/shield-star-fill))
(def shield-star-duotone (icon-component svg/shield-star-duotone))
(def shield-warning-bold (icon-component svg/shield-warning-bold))
(def shield-warning (icon-component svg/shield-warning-regular))
(def shield-warning-light (icon-component svg/shield-warning-light))
(def shield-warning-thin (icon-component svg/shield-warning-thin))
(def shield-warning-fill (icon-component svg/shield-warning-fill))
(def shield-warning-duotone (icon-component svg/shield-warning-duotone))
(def shipping-container-bold (icon-component svg/shipping-container-bold))
(def shipping-container (icon-component svg/shipping-container-regular))
(def shipping-container-light (icon-component svg/shipping-container-light))
(def shipping-container-thin (icon-component svg/shipping-container-thin))
(def shipping-container-fill (icon-component svg/shipping-container-fill))
(def shipping-container-duotone (icon-component svg/shipping-container-duotone))
(def shirt-folded-bold (icon-component svg/shirt-folded-bold))
(def shirt-folded (icon-component svg/shirt-folded-regular))
(def shirt-folded-light (icon-component svg/shirt-folded-light))
(def shirt-folded-thin (icon-component svg/shirt-folded-thin))
(def shirt-folded-fill (icon-component svg/shirt-folded-fill))
(def shirt-folded-duotone (icon-component svg/shirt-folded-duotone))
(def shooting-star-bold (icon-component svg/shooting-star-bold))
(def shooting-star (icon-component svg/shooting-star-regular))
(def shooting-star-light (icon-component svg/shooting-star-light))
(def shooting-star-thin (icon-component svg/shooting-star-thin))
(def shooting-star-fill (icon-component svg/shooting-star-fill))
(def shooting-star-duotone (icon-component svg/shooting-star-duotone))
(def shopping-bag-bold (icon-component svg/shopping-bag-bold))
(def shopping-bag (icon-component svg/shopping-bag-regular))
(def shopping-bag-light (icon-component svg/shopping-bag-light))
(def shopping-bag-thin (icon-component svg/shopping-bag-thin))
(def shopping-bag-fill (icon-component svg/shopping-bag-fill))
(def shopping-bag-duotone (icon-component svg/shopping-bag-duotone))
(def shopping-bag-open-bold (icon-component svg/shopping-bag-open-bold))
(def shopping-bag-open (icon-component svg/shopping-bag-open-regular))
(def shopping-bag-open-light (icon-component svg/shopping-bag-open-light))
(def shopping-bag-open-thin (icon-component svg/shopping-bag-open-thin))
(def shopping-bag-open-fill (icon-component svg/shopping-bag-open-fill))
(def shopping-bag-open-duotone (icon-component svg/shopping-bag-open-duotone))
(def shopping-cart-bold (icon-component svg/shopping-cart-bold))
(def shopping-cart (icon-component svg/shopping-cart-regular))
(def shopping-cart-light (icon-component svg/shopping-cart-light))
(def shopping-cart-thin (icon-component svg/shopping-cart-thin))
(def shopping-cart-fill (icon-component svg/shopping-cart-fill))
(def shopping-cart-duotone (icon-component svg/shopping-cart-duotone))
(def shopping-cart-simple-bold (icon-component svg/shopping-cart-simple-bold))
(def shopping-cart-simple (icon-component svg/shopping-cart-simple-regular))
(def shopping-cart-simple-light (icon-component svg/shopping-cart-simple-light))
(def shopping-cart-simple-thin (icon-component svg/shopping-cart-simple-thin))
(def shopping-cart-simple-fill (icon-component svg/shopping-cart-simple-fill))
(def shopping-cart-simple-duotone (icon-component svg/shopping-cart-simple-duotone))
(def shovel-bold (icon-component svg/shovel-bold))
(def shovel (icon-component svg/shovel-regular))
(def shovel-light (icon-component svg/shovel-light))
(def shovel-thin (icon-component svg/shovel-thin))
(def shovel-fill (icon-component svg/shovel-fill))
(def shovel-duotone (icon-component svg/shovel-duotone))
(def shower-bold (icon-component svg/shower-bold))
(def shower (icon-component svg/shower-regular))
(def shower-light (icon-component svg/shower-light))
(def shower-thin (icon-component svg/shower-thin))
(def shower-fill (icon-component svg/shower-fill))
(def shower-duotone (icon-component svg/shower-duotone))
(def shrimp-bold (icon-component svg/shrimp-bold))
(def shrimp (icon-component svg/shrimp-regular))
(def shrimp-light (icon-component svg/shrimp-light))
(def shrimp-thin (icon-component svg/shrimp-thin))
(def shrimp-fill (icon-component svg/shrimp-fill))
(def shrimp-duotone (icon-component svg/shrimp-duotone))
(def shuffle-bold (icon-component svg/shuffle-bold))
(def shuffle (icon-component svg/shuffle-regular))
(def shuffle-light (icon-component svg/shuffle-light))
(def shuffle-thin (icon-component svg/shuffle-thin))
(def shuffle-fill (icon-component svg/shuffle-fill))
(def shuffle-duotone (icon-component svg/shuffle-duotone))
(def shuffle-angular-bold (icon-component svg/shuffle-angular-bold))
(def shuffle-angular (icon-component svg/shuffle-angular-regular))
(def shuffle-angular-light (icon-component svg/shuffle-angular-light))
(def shuffle-angular-thin (icon-component svg/shuffle-angular-thin))
(def shuffle-angular-fill (icon-component svg/shuffle-angular-fill))
(def shuffle-angular-duotone (icon-component svg/shuffle-angular-duotone))
(def shuffle-simple-bold (icon-component svg/shuffle-simple-bold))
(def shuffle-simple (icon-component svg/shuffle-simple-regular))
(def shuffle-simple-light (icon-component svg/shuffle-simple-light))
(def shuffle-simple-thin (icon-component svg/shuffle-simple-thin))
(def shuffle-simple-fill (icon-component svg/shuffle-simple-fill))
(def shuffle-simple-duotone (icon-component svg/shuffle-simple-duotone))
(def sidebar-bold (icon-component svg/sidebar-bold))
(def sidebar (icon-component svg/sidebar-regular))
(def sidebar-light (icon-component svg/sidebar-light))
(def sidebar-thin (icon-component svg/sidebar-thin))
(def sidebar-fill (icon-component svg/sidebar-fill))
(def sidebar-duotone (icon-component svg/sidebar-duotone))
(def sidebar-simple-bold (icon-component svg/sidebar-simple-bold))
(def sidebar-simple (icon-component svg/sidebar-simple-regular))
(def sidebar-simple-light (icon-component svg/sidebar-simple-light))
(def sidebar-simple-thin (icon-component svg/sidebar-simple-thin))
(def sidebar-simple-fill (icon-component svg/sidebar-simple-fill))
(def sidebar-simple-duotone (icon-component svg/sidebar-simple-duotone))
(def sigma-bold (icon-component svg/sigma-bold))
(def sigma (icon-component svg/sigma-regular))
(def sigma-light (icon-component svg/sigma-light))
(def sigma-thin (icon-component svg/sigma-thin))
(def sigma-fill (icon-component svg/sigma-fill))
(def sigma-duotone (icon-component svg/sigma-duotone))
(def sign-in-bold (icon-component svg/sign-in-bold))
(def sign-in (icon-component svg/sign-in-regular))
(def sign-in-light (icon-component svg/sign-in-light))
(def sign-in-thin (icon-component svg/sign-in-thin))
(def sign-in-fill (icon-component svg/sign-in-fill))
(def sign-in-duotone (icon-component svg/sign-in-duotone))
(def sign-out-bold (icon-component svg/sign-out-bold))
(def sign-out (icon-component svg/sign-out-regular))
(def sign-out-light (icon-component svg/sign-out-light))
(def sign-out-thin (icon-component svg/sign-out-thin))
(def sign-out-fill (icon-component svg/sign-out-fill))
(def sign-out-duotone (icon-component svg/sign-out-duotone))
(def signature-bold (icon-component svg/signature-bold))
(def signature (icon-component svg/signature-regular))
(def signature-light (icon-component svg/signature-light))
(def signature-thin (icon-component svg/signature-thin))
(def signature-fill (icon-component svg/signature-fill))
(def signature-duotone (icon-component svg/signature-duotone))
(def signpost-bold (icon-component svg/signpost-bold))
(def signpost (icon-component svg/signpost-regular))
(def signpost-light (icon-component svg/signpost-light))
(def signpost-thin (icon-component svg/signpost-thin))
(def signpost-fill (icon-component svg/signpost-fill))
(def signpost-duotone (icon-component svg/signpost-duotone))
(def sim-card-bold (icon-component svg/sim-card-bold))
(def sim-card (icon-component svg/sim-card-regular))
(def sim-card-light (icon-component svg/sim-card-light))
(def sim-card-thin (icon-component svg/sim-card-thin))
(def sim-card-fill (icon-component svg/sim-card-fill))
(def sim-card-duotone (icon-component svg/sim-card-duotone))
(def siren-bold (icon-component svg/siren-bold))
(def siren (icon-component svg/siren-regular))
(def siren-light (icon-component svg/siren-light))
(def siren-thin (icon-component svg/siren-thin))
(def siren-fill (icon-component svg/siren-fill))
(def siren-duotone (icon-component svg/siren-duotone))
(def sketch-logo-bold (icon-component svg/sketch-logo-bold))
(def sketch-logo (icon-component svg/sketch-logo-regular))
(def sketch-logo-light (icon-component svg/sketch-logo-light))
(def sketch-logo-thin (icon-component svg/sketch-logo-thin))
(def sketch-logo-fill (icon-component svg/sketch-logo-fill))
(def sketch-logo-duotone (icon-component svg/sketch-logo-duotone))
(def skip-back-bold (icon-component svg/skip-back-bold))
(def skip-back (icon-component svg/skip-back-regular))
(def skip-back-light (icon-component svg/skip-back-light))
(def skip-back-thin (icon-component svg/skip-back-thin))
(def skip-back-fill (icon-component svg/skip-back-fill))
(def skip-back-duotone (icon-component svg/skip-back-duotone))
(def skip-back-circle-bold (icon-component svg/skip-back-circle-bold))
(def skip-back-circle (icon-component svg/skip-back-circle-regular))
(def skip-back-circle-light (icon-component svg/skip-back-circle-light))
(def skip-back-circle-thin (icon-component svg/skip-back-circle-thin))
(def skip-back-circle-fill (icon-component svg/skip-back-circle-fill))
(def skip-back-circle-duotone (icon-component svg/skip-back-circle-duotone))
(def skip-forward-bold (icon-component svg/skip-forward-bold))
(def skip-forward (icon-component svg/skip-forward-regular))
(def skip-forward-light (icon-component svg/skip-forward-light))
(def skip-forward-thin (icon-component svg/skip-forward-thin))
(def skip-forward-fill (icon-component svg/skip-forward-fill))
(def skip-forward-duotone (icon-component svg/skip-forward-duotone))
(def skip-forward-circle-bold (icon-component svg/skip-forward-circle-bold))
(def skip-forward-circle (icon-component svg/skip-forward-circle-regular))
(def skip-forward-circle-light (icon-component svg/skip-forward-circle-light))
(def skip-forward-circle-thin (icon-component svg/skip-forward-circle-thin))
(def skip-forward-circle-fill (icon-component svg/skip-forward-circle-fill))
(def skip-forward-circle-duotone (icon-component svg/skip-forward-circle-duotone))
(def skull-bold (icon-component svg/skull-bold))
(def skull (icon-component svg/skull-regular))
(def skull-light (icon-component svg/skull-light))
(def skull-thin (icon-component svg/skull-thin))
(def skull-fill (icon-component svg/skull-fill))
(def skull-duotone (icon-component svg/skull-duotone))
(def skype-logo-bold (icon-component svg/skype-logo-bold))
(def skype-logo (icon-component svg/skype-logo-regular))
(def skype-logo-light (icon-component svg/skype-logo-light))
(def skype-logo-thin (icon-component svg/skype-logo-thin))
(def skype-logo-fill (icon-component svg/skype-logo-fill))
(def skype-logo-duotone (icon-component svg/skype-logo-duotone))
(def slack-logo-bold (icon-component svg/slack-logo-bold))
(def slack-logo (icon-component svg/slack-logo-regular))
(def slack-logo-light (icon-component svg/slack-logo-light))
(def slack-logo-thin (icon-component svg/slack-logo-thin))
(def slack-logo-fill (icon-component svg/slack-logo-fill))
(def slack-logo-duotone (icon-component svg/slack-logo-duotone))
(def sliders-bold (icon-component svg/sliders-bold))
(def sliders (icon-component svg/sliders-regular))
(def sliders-light (icon-component svg/sliders-light))
(def sliders-thin (icon-component svg/sliders-thin))
(def sliders-fill (icon-component svg/sliders-fill))
(def sliders-duotone (icon-component svg/sliders-duotone))
(def sliders-horizontal-bold (icon-component svg/sliders-horizontal-bold))
(def sliders-horizontal (icon-component svg/sliders-horizontal-regular))
(def sliders-horizontal-light (icon-component svg/sliders-horizontal-light))
(def sliders-horizontal-thin (icon-component svg/sliders-horizontal-thin))
(def sliders-horizontal-fill (icon-component svg/sliders-horizontal-fill))
(def sliders-horizontal-duotone (icon-component svg/sliders-horizontal-duotone))
(def slideshow-bold (icon-component svg/slideshow-bold))
(def slideshow (icon-component svg/slideshow-regular))
(def slideshow-light (icon-component svg/slideshow-light))
(def slideshow-thin (icon-component svg/slideshow-thin))
(def slideshow-fill (icon-component svg/slideshow-fill))
(def slideshow-duotone (icon-component svg/slideshow-duotone))
(def smiley-bold (icon-component svg/smiley-bold))
(def smiley (icon-component svg/smiley-regular))
(def smiley-light (icon-component svg/smiley-light))
(def smiley-thin (icon-component svg/smiley-thin))
(def smiley-fill (icon-component svg/smiley-fill))
(def smiley-duotone (icon-component svg/smiley-duotone))
(def smiley-angry-bold (icon-component svg/smiley-angry-bold))
(def smiley-angry (icon-component svg/smiley-angry-regular))
(def smiley-angry-light (icon-component svg/smiley-angry-light))
(def smiley-angry-thin (icon-component svg/smiley-angry-thin))
(def smiley-angry-fill (icon-component svg/smiley-angry-fill))
(def smiley-angry-duotone (icon-component svg/smiley-angry-duotone))
(def smiley-blank-bold (icon-component svg/smiley-blank-bold))
(def smiley-blank (icon-component svg/smiley-blank-regular))
(def smiley-blank-light (icon-component svg/smiley-blank-light))
(def smiley-blank-thin (icon-component svg/smiley-blank-thin))
(def smiley-blank-fill (icon-component svg/smiley-blank-fill))
(def smiley-blank-duotone (icon-component svg/smiley-blank-duotone))
(def smiley-meh-bold (icon-component svg/smiley-meh-bold))
(def smiley-meh (icon-component svg/smiley-meh-regular))
(def smiley-meh-light (icon-component svg/smiley-meh-light))
(def smiley-meh-thin (icon-component svg/smiley-meh-thin))
(def smiley-meh-fill (icon-component svg/smiley-meh-fill))
(def smiley-meh-duotone (icon-component svg/smiley-meh-duotone))
(def smiley-melting-bold (icon-component svg/smiley-melting-bold))
(def smiley-melting (icon-component svg/smiley-melting-regular))
(def smiley-melting-light (icon-component svg/smiley-melting-light))
(def smiley-melting-thin (icon-component svg/smiley-melting-thin))
(def smiley-melting-fill (icon-component svg/smiley-melting-fill))
(def smiley-melting-duotone (icon-component svg/smiley-melting-duotone))
(def smiley-nervous-bold (icon-component svg/smiley-nervous-bold))
(def smiley-nervous (icon-component svg/smiley-nervous-regular))
(def smiley-nervous-light (icon-component svg/smiley-nervous-light))
(def smiley-nervous-thin (icon-component svg/smiley-nervous-thin))
(def smiley-nervous-fill (icon-component svg/smiley-nervous-fill))
(def smiley-nervous-duotone (icon-component svg/smiley-nervous-duotone))
(def smiley-sad-bold (icon-component svg/smiley-sad-bold))
(def smiley-sad (icon-component svg/smiley-sad-regular))
(def smiley-sad-light (icon-component svg/smiley-sad-light))
(def smiley-sad-thin (icon-component svg/smiley-sad-thin))
(def smiley-sad-fill (icon-component svg/smiley-sad-fill))
(def smiley-sad-duotone (icon-component svg/smiley-sad-duotone))
(def smiley-sticker-bold (icon-component svg/smiley-sticker-bold))
(def smiley-sticker (icon-component svg/smiley-sticker-regular))
(def smiley-sticker-light (icon-component svg/smiley-sticker-light))
(def smiley-sticker-thin (icon-component svg/smiley-sticker-thin))
(def smiley-sticker-fill (icon-component svg/smiley-sticker-fill))
(def smiley-sticker-duotone (icon-component svg/smiley-sticker-duotone))
(def smiley-wink-bold (icon-component svg/smiley-wink-bold))
(def smiley-wink (icon-component svg/smiley-wink-regular))
(def smiley-wink-light (icon-component svg/smiley-wink-light))
(def smiley-wink-thin (icon-component svg/smiley-wink-thin))
(def smiley-wink-fill (icon-component svg/smiley-wink-fill))
(def smiley-wink-duotone (icon-component svg/smiley-wink-duotone))
(def smiley-x-eyes-bold (icon-component svg/smiley-x-eyes-bold))
(def smiley-x-eyes (icon-component svg/smiley-x-eyes-regular))
(def smiley-x-eyes-light (icon-component svg/smiley-x-eyes-light))
(def smiley-x-eyes-thin (icon-component svg/smiley-x-eyes-thin))
(def smiley-x-eyes-fill (icon-component svg/smiley-x-eyes-fill))
(def smiley-x-eyes-duotone (icon-component svg/smiley-x-eyes-duotone))
(def snapchat-logo-bold (icon-component svg/snapchat-logo-bold))
(def snapchat-logo (icon-component svg/snapchat-logo-regular))
(def snapchat-logo-light (icon-component svg/snapchat-logo-light))
(def snapchat-logo-thin (icon-component svg/snapchat-logo-thin))
(def snapchat-logo-fill (icon-component svg/snapchat-logo-fill))
(def snapchat-logo-duotone (icon-component svg/snapchat-logo-duotone))
(def sneaker-bold (icon-component svg/sneaker-bold))
(def sneaker (icon-component svg/sneaker-regular))
(def sneaker-light (icon-component svg/sneaker-light))
(def sneaker-thin (icon-component svg/sneaker-thin))
(def sneaker-fill (icon-component svg/sneaker-fill))
(def sneaker-duotone (icon-component svg/sneaker-duotone))
(def sneaker-move-bold (icon-component svg/sneaker-move-bold))
(def sneaker-move (icon-component svg/sneaker-move-regular))
(def sneaker-move-light (icon-component svg/sneaker-move-light))
(def sneaker-move-thin (icon-component svg/sneaker-move-thin))
(def sneaker-move-fill (icon-component svg/sneaker-move-fill))
(def sneaker-move-duotone (icon-component svg/sneaker-move-duotone))
(def snowflake-bold (icon-component svg/snowflake-bold))
(def snowflake (icon-component svg/snowflake-regular))
(def snowflake-light (icon-component svg/snowflake-light))
(def snowflake-thin (icon-component svg/snowflake-thin))
(def snowflake-fill (icon-component svg/snowflake-fill))
(def snowflake-duotone (icon-component svg/snowflake-duotone))
(def soccer-ball-bold (icon-component svg/soccer-ball-bold))
(def soccer-ball (icon-component svg/soccer-ball-regular))
(def soccer-ball-light (icon-component svg/soccer-ball-light))
(def soccer-ball-thin (icon-component svg/soccer-ball-thin))
(def soccer-ball-fill (icon-component svg/soccer-ball-fill))
(def soccer-ball-duotone (icon-component svg/soccer-ball-duotone))
(def sock-bold (icon-component svg/sock-bold))
(def sock (icon-component svg/sock-regular))
(def sock-light (icon-component svg/sock-light))
(def sock-thin (icon-component svg/sock-thin))
(def sock-fill (icon-component svg/sock-fill))
(def sock-duotone (icon-component svg/sock-duotone))
(def solar-panel-bold (icon-component svg/solar-panel-bold))
(def solar-panel (icon-component svg/solar-panel-regular))
(def solar-panel-light (icon-component svg/solar-panel-light))
(def solar-panel-thin (icon-component svg/solar-panel-thin))
(def solar-panel-fill (icon-component svg/solar-panel-fill))
(def solar-panel-duotone (icon-component svg/solar-panel-duotone))
(def solar-roof-bold (icon-component svg/solar-roof-bold))
(def solar-roof (icon-component svg/solar-roof-regular))
(def solar-roof-light (icon-component svg/solar-roof-light))
(def solar-roof-thin (icon-component svg/solar-roof-thin))
(def solar-roof-fill (icon-component svg/solar-roof-fill))
(def solar-roof-duotone (icon-component svg/solar-roof-duotone))
(def sort-ascending-bold (icon-component svg/sort-ascending-bold))
(def sort-ascending (icon-component svg/sort-ascending-regular))
(def sort-ascending-light (icon-component svg/sort-ascending-light))
(def sort-ascending-thin (icon-component svg/sort-ascending-thin))
(def sort-ascending-fill (icon-component svg/sort-ascending-fill))
(def sort-ascending-duotone (icon-component svg/sort-ascending-duotone))
(def sort-descending-bold (icon-component svg/sort-descending-bold))
(def sort-descending (icon-component svg/sort-descending-regular))
(def sort-descending-light (icon-component svg/sort-descending-light))
(def sort-descending-thin (icon-component svg/sort-descending-thin))
(def sort-descending-fill (icon-component svg/sort-descending-fill))
(def sort-descending-duotone (icon-component svg/sort-descending-duotone))
(def soundcloud-logo-bold (icon-component svg/soundcloud-logo-bold))
(def soundcloud-logo (icon-component svg/soundcloud-logo-regular))
(def soundcloud-logo-light (icon-component svg/soundcloud-logo-light))
(def soundcloud-logo-thin (icon-component svg/soundcloud-logo-thin))
(def soundcloud-logo-fill (icon-component svg/soundcloud-logo-fill))
(def soundcloud-logo-duotone (icon-component svg/soundcloud-logo-duotone))
(def spade-bold (icon-component svg/spade-bold))
(def spade (icon-component svg/spade-regular))
(def spade-light (icon-component svg/spade-light))
(def spade-thin (icon-component svg/spade-thin))
(def spade-fill (icon-component svg/spade-fill))
(def spade-duotone (icon-component svg/spade-duotone))
(def sparkle-bold (icon-component svg/sparkle-bold))
(def sparkle (icon-component svg/sparkle-regular))
(def sparkle-light (icon-component svg/sparkle-light))
(def sparkle-thin (icon-component svg/sparkle-thin))
(def sparkle-fill (icon-component svg/sparkle-fill))
(def sparkle-duotone (icon-component svg/sparkle-duotone))
(def speaker-hifi-bold (icon-component svg/speaker-hifi-bold))
(def speaker-hifi (icon-component svg/speaker-hifi-regular))
(def speaker-hifi-light (icon-component svg/speaker-hifi-light))
(def speaker-hifi-thin (icon-component svg/speaker-hifi-thin))
(def speaker-hifi-fill (icon-component svg/speaker-hifi-fill))
(def speaker-hifi-duotone (icon-component svg/speaker-hifi-duotone))
(def speaker-high-bold (icon-component svg/speaker-high-bold))
(def speaker-high (icon-component svg/speaker-high-regular))
(def speaker-high-light (icon-component svg/speaker-high-light))
(def speaker-high-thin (icon-component svg/speaker-high-thin))
(def speaker-high-fill (icon-component svg/speaker-high-fill))
(def speaker-high-duotone (icon-component svg/speaker-high-duotone))
(def speaker-low-bold (icon-component svg/speaker-low-bold))
(def speaker-low (icon-component svg/speaker-low-regular))
(def speaker-low-light (icon-component svg/speaker-low-light))
(def speaker-low-thin (icon-component svg/speaker-low-thin))
(def speaker-low-fill (icon-component svg/speaker-low-fill))
(def speaker-low-duotone (icon-component svg/speaker-low-duotone))
(def speaker-none-bold (icon-component svg/speaker-none-bold))
(def speaker-none (icon-component svg/speaker-none-regular))
(def speaker-none-light (icon-component svg/speaker-none-light))
(def speaker-none-thin (icon-component svg/speaker-none-thin))
(def speaker-none-fill (icon-component svg/speaker-none-fill))
(def speaker-none-duotone (icon-component svg/speaker-none-duotone))
(def speaker-simple-high-bold (icon-component svg/speaker-simple-high-bold))
(def speaker-simple-high (icon-component svg/speaker-simple-high-regular))
(def speaker-simple-high-light (icon-component svg/speaker-simple-high-light))
(def speaker-simple-high-thin (icon-component svg/speaker-simple-high-thin))
(def speaker-simple-high-fill (icon-component svg/speaker-simple-high-fill))
(def speaker-simple-high-duotone (icon-component svg/speaker-simple-high-duotone))
(def speaker-simple-low-bold (icon-component svg/speaker-simple-low-bold))
(def speaker-simple-low (icon-component svg/speaker-simple-low-regular))
(def speaker-simple-low-light (icon-component svg/speaker-simple-low-light))
(def speaker-simple-low-thin (icon-component svg/speaker-simple-low-thin))
(def speaker-simple-low-fill (icon-component svg/speaker-simple-low-fill))
(def speaker-simple-low-duotone (icon-component svg/speaker-simple-low-duotone))
(def speaker-simple-none-bold (icon-component svg/speaker-simple-none-bold))
(def speaker-simple-none (icon-component svg/speaker-simple-none-regular))
(def speaker-simple-none-light (icon-component svg/speaker-simple-none-light))
(def speaker-simple-none-thin (icon-component svg/speaker-simple-none-thin))
(def speaker-simple-none-fill (icon-component svg/speaker-simple-none-fill))
(def speaker-simple-none-duotone (icon-component svg/speaker-simple-none-duotone))
(def speaker-simple-slash-bold (icon-component svg/speaker-simple-slash-bold))
(def speaker-simple-slash (icon-component svg/speaker-simple-slash-regular))
(def speaker-simple-slash-light (icon-component svg/speaker-simple-slash-light))
(def speaker-simple-slash-thin (icon-component svg/speaker-simple-slash-thin))
(def speaker-simple-slash-fill (icon-component svg/speaker-simple-slash-fill))
(def speaker-simple-slash-duotone (icon-component svg/speaker-simple-slash-duotone))
(def speaker-simple-x-bold (icon-component svg/speaker-simple-x-bold))
(def speaker-simple-x (icon-component svg/speaker-simple-x-regular))
(def speaker-simple-x-light (icon-component svg/speaker-simple-x-light))
(def speaker-simple-x-thin (icon-component svg/speaker-simple-x-thin))
(def speaker-simple-x-fill (icon-component svg/speaker-simple-x-fill))
(def speaker-simple-x-duotone (icon-component svg/speaker-simple-x-duotone))
(def speaker-slash-bold (icon-component svg/speaker-slash-bold))
(def speaker-slash (icon-component svg/speaker-slash-regular))
(def speaker-slash-light (icon-component svg/speaker-slash-light))
(def speaker-slash-thin (icon-component svg/speaker-slash-thin))
(def speaker-slash-fill (icon-component svg/speaker-slash-fill))
(def speaker-slash-duotone (icon-component svg/speaker-slash-duotone))
(def speaker-x-bold (icon-component svg/speaker-x-bold))
(def speaker-x (icon-component svg/speaker-x-regular))
(def speaker-x-light (icon-component svg/speaker-x-light))
(def speaker-x-thin (icon-component svg/speaker-x-thin))
(def speaker-x-fill (icon-component svg/speaker-x-fill))
(def speaker-x-duotone (icon-component svg/speaker-x-duotone))
(def speedometer-bold (icon-component svg/speedometer-bold))
(def speedometer (icon-component svg/speedometer-regular))
(def speedometer-light (icon-component svg/speedometer-light))
(def speedometer-thin (icon-component svg/speedometer-thin))
(def speedometer-fill (icon-component svg/speedometer-fill))
(def speedometer-duotone (icon-component svg/speedometer-duotone))
(def sphere-bold (icon-component svg/sphere-bold))
(def sphere (icon-component svg/sphere-regular))
(def sphere-light (icon-component svg/sphere-light))
(def sphere-thin (icon-component svg/sphere-thin))
(def sphere-fill (icon-component svg/sphere-fill))
(def sphere-duotone (icon-component svg/sphere-duotone))
(def spinner-bold (icon-component svg/spinner-bold))
(def spinner (icon-component svg/spinner-regular))
(def spinner-light (icon-component svg/spinner-light))
(def spinner-thin (icon-component svg/spinner-thin))
(def spinner-fill (icon-component svg/spinner-fill))
(def spinner-duotone (icon-component svg/spinner-duotone))
(def spinner-ball-bold (icon-component svg/spinner-ball-bold))
(def spinner-ball (icon-component svg/spinner-ball-regular))
(def spinner-ball-light (icon-component svg/spinner-ball-light))
(def spinner-ball-thin (icon-component svg/spinner-ball-thin))
(def spinner-ball-fill (icon-component svg/spinner-ball-fill))
(def spinner-ball-duotone (icon-component svg/spinner-ball-duotone))
(def spinner-gap-bold (icon-component svg/spinner-gap-bold))
(def spinner-gap (icon-component svg/spinner-gap-regular))
(def spinner-gap-light (icon-component svg/spinner-gap-light))
(def spinner-gap-thin (icon-component svg/spinner-gap-thin))
(def spinner-gap-fill (icon-component svg/spinner-gap-fill))
(def spinner-gap-duotone (icon-component svg/spinner-gap-duotone))
(def spiral-bold (icon-component svg/spiral-bold))
(def spiral (icon-component svg/spiral-regular))
(def spiral-light (icon-component svg/spiral-light))
(def spiral-thin (icon-component svg/spiral-thin))
(def spiral-fill (icon-component svg/spiral-fill))
(def spiral-duotone (icon-component svg/spiral-duotone))
(def split-horizontal-bold (icon-component svg/split-horizontal-bold))
(def split-horizontal (icon-component svg/split-horizontal-regular))
(def split-horizontal-light (icon-component svg/split-horizontal-light))
(def split-horizontal-thin (icon-component svg/split-horizontal-thin))
(def split-horizontal-fill (icon-component svg/split-horizontal-fill))
(def split-horizontal-duotone (icon-component svg/split-horizontal-duotone))
(def split-vertical-bold (icon-component svg/split-vertical-bold))
(def split-vertical (icon-component svg/split-vertical-regular))
(def split-vertical-light (icon-component svg/split-vertical-light))
(def split-vertical-thin (icon-component svg/split-vertical-thin))
(def split-vertical-fill (icon-component svg/split-vertical-fill))
(def split-vertical-duotone (icon-component svg/split-vertical-duotone))
(def spotify-logo-bold (icon-component svg/spotify-logo-bold))
(def spotify-logo (icon-component svg/spotify-logo-regular))
(def spotify-logo-light (icon-component svg/spotify-logo-light))
(def spotify-logo-thin (icon-component svg/spotify-logo-thin))
(def spotify-logo-fill (icon-component svg/spotify-logo-fill))
(def spotify-logo-duotone (icon-component svg/spotify-logo-duotone))
(def spray-bottle-bold (icon-component svg/spray-bottle-bold))
(def spray-bottle (icon-component svg/spray-bottle-regular))
(def spray-bottle-light (icon-component svg/spray-bottle-light))
(def spray-bottle-thin (icon-component svg/spray-bottle-thin))
(def spray-bottle-fill (icon-component svg/spray-bottle-fill))
(def spray-bottle-duotone (icon-component svg/spray-bottle-duotone))
(def square-bold (icon-component svg/square-bold))
(def square (icon-component svg/square-regular))
(def square-light (icon-component svg/square-light))
(def square-thin (icon-component svg/square-thin))
(def square-fill (icon-component svg/square-fill))
(def square-duotone (icon-component svg/square-duotone))
(def square-half-bold (icon-component svg/square-half-bold))
(def square-half (icon-component svg/square-half-regular))
(def square-half-light (icon-component svg/square-half-light))
(def square-half-thin (icon-component svg/square-half-thin))
(def square-half-fill (icon-component svg/square-half-fill))
(def square-half-duotone (icon-component svg/square-half-duotone))
(def square-half-bottom-bold (icon-component svg/square-half-bottom-bold))
(def square-half-bottom (icon-component svg/square-half-bottom-regular))
(def square-half-bottom-light (icon-component svg/square-half-bottom-light))
(def square-half-bottom-thin (icon-component svg/square-half-bottom-thin))
(def square-half-bottom-fill (icon-component svg/square-half-bottom-fill))
(def square-half-bottom-duotone (icon-component svg/square-half-bottom-duotone))
(def square-logo-bold (icon-component svg/square-logo-bold))
(def square-logo (icon-component svg/square-logo-regular))
(def square-logo-light (icon-component svg/square-logo-light))
(def square-logo-thin (icon-component svg/square-logo-thin))
(def square-logo-fill (icon-component svg/square-logo-fill))
(def square-logo-duotone (icon-component svg/square-logo-duotone))
(def square-split-horizontal-bold (icon-component svg/square-split-horizontal-bold))
(def square-split-horizontal (icon-component svg/square-split-horizontal-regular))
(def square-split-horizontal-light (icon-component svg/square-split-horizontal-light))
(def square-split-horizontal-thin (icon-component svg/square-split-horizontal-thin))
(def square-split-horizontal-fill (icon-component svg/square-split-horizontal-fill))
(def square-split-horizontal-duotone (icon-component svg/square-split-horizontal-duotone))
(def square-split-vertical-bold (icon-component svg/square-split-vertical-bold))
(def square-split-vertical (icon-component svg/square-split-vertical-regular))
(def square-split-vertical-light (icon-component svg/square-split-vertical-light))
(def square-split-vertical-thin (icon-component svg/square-split-vertical-thin))
(def square-split-vertical-fill (icon-component svg/square-split-vertical-fill))
(def square-split-vertical-duotone (icon-component svg/square-split-vertical-duotone))
(def squares-four-bold (icon-component svg/squares-four-bold))
(def squares-four (icon-component svg/squares-four-regular))
(def squares-four-light (icon-component svg/squares-four-light))
(def squares-four-thin (icon-component svg/squares-four-thin))
(def squares-four-fill (icon-component svg/squares-four-fill))
(def squares-four-duotone (icon-component svg/squares-four-duotone))
(def stack-bold (icon-component svg/stack-bold))
(def stack (icon-component svg/stack-regular))
(def stack-light (icon-component svg/stack-light))
(def stack-thin (icon-component svg/stack-thin))
(def stack-fill (icon-component svg/stack-fill))
(def stack-duotone (icon-component svg/stack-duotone))
(def stack-minus-bold (icon-component svg/stack-minus-bold))
(def stack-minus (icon-component svg/stack-minus-regular))
(def stack-minus-light (icon-component svg/stack-minus-light))
(def stack-minus-thin (icon-component svg/stack-minus-thin))
(def stack-minus-fill (icon-component svg/stack-minus-fill))
(def stack-minus-duotone (icon-component svg/stack-minus-duotone))
(def stack-overflow-logo-bold (icon-component svg/stack-overflow-logo-bold))
(def stack-overflow-logo (icon-component svg/stack-overflow-logo-regular))
(def stack-overflow-logo-light (icon-component svg/stack-overflow-logo-light))
(def stack-overflow-logo-thin (icon-component svg/stack-overflow-logo-thin))
(def stack-overflow-logo-fill (icon-component svg/stack-overflow-logo-fill))
(def stack-overflow-logo-duotone (icon-component svg/stack-overflow-logo-duotone))
(def stack-plus-bold (icon-component svg/stack-plus-bold))
(def stack-plus (icon-component svg/stack-plus-regular))
(def stack-plus-light (icon-component svg/stack-plus-light))
(def stack-plus-thin (icon-component svg/stack-plus-thin))
(def stack-plus-fill (icon-component svg/stack-plus-fill))
(def stack-plus-duotone (icon-component svg/stack-plus-duotone))
(def stack-simple-bold (icon-component svg/stack-simple-bold))
(def stack-simple (icon-component svg/stack-simple-regular))
(def stack-simple-light (icon-component svg/stack-simple-light))
(def stack-simple-thin (icon-component svg/stack-simple-thin))
(def stack-simple-fill (icon-component svg/stack-simple-fill))
(def stack-simple-duotone (icon-component svg/stack-simple-duotone))
(def stairs-bold (icon-component svg/stairs-bold))
(def stairs (icon-component svg/stairs-regular))
(def stairs-light (icon-component svg/stairs-light))
(def stairs-thin (icon-component svg/stairs-thin))
(def stairs-fill (icon-component svg/stairs-fill))
(def stairs-duotone (icon-component svg/stairs-duotone))
(def stamp-bold (icon-component svg/stamp-bold))
(def stamp (icon-component svg/stamp-regular))
(def stamp-light (icon-component svg/stamp-light))
(def stamp-thin (icon-component svg/stamp-thin))
(def stamp-fill (icon-component svg/stamp-fill))
(def stamp-duotone (icon-component svg/stamp-duotone))
(def standard-definition-bold (icon-component svg/standard-definition-bold))
(def standard-definition (icon-component svg/standard-definition-regular))
(def standard-definition-light (icon-component svg/standard-definition-light))
(def standard-definition-thin (icon-component svg/standard-definition-thin))
(def standard-definition-fill (icon-component svg/standard-definition-fill))
(def standard-definition-duotone (icon-component svg/standard-definition-duotone))
(def star-bold (icon-component svg/star-bold))
(def star (icon-component svg/star-regular))
(def star-light (icon-component svg/star-light))
(def star-thin (icon-component svg/star-thin))
(def star-fill (icon-component svg/star-fill))
(def star-duotone (icon-component svg/star-duotone))
(def star-and-crescent-bold (icon-component svg/star-and-crescent-bold))
(def star-and-crescent (icon-component svg/star-and-crescent-regular))
(def star-and-crescent-light (icon-component svg/star-and-crescent-light))
(def star-and-crescent-thin (icon-component svg/star-and-crescent-thin))
(def star-and-crescent-fill (icon-component svg/star-and-crescent-fill))
(def star-and-crescent-duotone (icon-component svg/star-and-crescent-duotone))
(def star-four-bold (icon-component svg/star-four-bold))
(def star-four (icon-component svg/star-four-regular))
(def star-four-light (icon-component svg/star-four-light))
(def star-four-thin (icon-component svg/star-four-thin))
(def star-four-fill (icon-component svg/star-four-fill))
(def star-four-duotone (icon-component svg/star-four-duotone))
(def star-half-bold (icon-component svg/star-half-bold))
(def star-half (icon-component svg/star-half-regular))
(def star-half-light (icon-component svg/star-half-light))
(def star-half-thin (icon-component svg/star-half-thin))
(def star-half-fill (icon-component svg/star-half-fill))
(def star-half-duotone (icon-component svg/star-half-duotone))
(def star-of-david-bold (icon-component svg/star-of-david-bold))
(def star-of-david (icon-component svg/star-of-david-regular))
(def star-of-david-light (icon-component svg/star-of-david-light))
(def star-of-david-thin (icon-component svg/star-of-david-thin))
(def star-of-david-fill (icon-component svg/star-of-david-fill))
(def star-of-david-duotone (icon-component svg/star-of-david-duotone))
(def steam-logo-bold (icon-component svg/steam-logo-bold))
(def steam-logo (icon-component svg/steam-logo-regular))
(def steam-logo-light (icon-component svg/steam-logo-light))
(def steam-logo-thin (icon-component svg/steam-logo-thin))
(def steam-logo-fill (icon-component svg/steam-logo-fill))
(def steam-logo-duotone (icon-component svg/steam-logo-duotone))
(def steering-wheel-bold (icon-component svg/steering-wheel-bold))
(def steering-wheel (icon-component svg/steering-wheel-regular))
(def steering-wheel-light (icon-component svg/steering-wheel-light))
(def steering-wheel-thin (icon-component svg/steering-wheel-thin))
(def steering-wheel-fill (icon-component svg/steering-wheel-fill))
(def steering-wheel-duotone (icon-component svg/steering-wheel-duotone))
(def steps-bold (icon-component svg/steps-bold))
(def steps (icon-component svg/steps-regular))
(def steps-light (icon-component svg/steps-light))
(def steps-thin (icon-component svg/steps-thin))
(def steps-fill (icon-component svg/steps-fill))
(def steps-duotone (icon-component svg/steps-duotone))
(def stethoscope-bold (icon-component svg/stethoscope-bold))
(def stethoscope (icon-component svg/stethoscope-regular))
(def stethoscope-light (icon-component svg/stethoscope-light))
(def stethoscope-thin (icon-component svg/stethoscope-thin))
(def stethoscope-fill (icon-component svg/stethoscope-fill))
(def stethoscope-duotone (icon-component svg/stethoscope-duotone))
(def sticker-bold (icon-component svg/sticker-bold))
(def sticker (icon-component svg/sticker-regular))
(def sticker-light (icon-component svg/sticker-light))
(def sticker-thin (icon-component svg/sticker-thin))
(def sticker-fill (icon-component svg/sticker-fill))
(def sticker-duotone (icon-component svg/sticker-duotone))
(def stool-bold (icon-component svg/stool-bold))
(def stool (icon-component svg/stool-regular))
(def stool-light (icon-component svg/stool-light))
(def stool-thin (icon-component svg/stool-thin))
(def stool-fill (icon-component svg/stool-fill))
(def stool-duotone (icon-component svg/stool-duotone))
(def stop-bold (icon-component svg/stop-bold))
(def stop (icon-component svg/stop-regular))
(def stop-light (icon-component svg/stop-light))
(def stop-thin (icon-component svg/stop-thin))
(def stop-fill (icon-component svg/stop-fill))
(def stop-duotone (icon-component svg/stop-duotone))
(def stop-circle-bold (icon-component svg/stop-circle-bold))
(def stop-circle (icon-component svg/stop-circle-regular))
(def stop-circle-light (icon-component svg/stop-circle-light))
(def stop-circle-thin (icon-component svg/stop-circle-thin))
(def stop-circle-fill (icon-component svg/stop-circle-fill))
(def stop-circle-duotone (icon-component svg/stop-circle-duotone))
(def storefront-bold (icon-component svg/storefront-bold))
(def storefront (icon-component svg/storefront-regular))
(def storefront-light (icon-component svg/storefront-light))
(def storefront-thin (icon-component svg/storefront-thin))
(def storefront-fill (icon-component svg/storefront-fill))
(def storefront-duotone (icon-component svg/storefront-duotone))
(def strategy-bold (icon-component svg/strategy-bold))
(def strategy (icon-component svg/strategy-regular))
(def strategy-light (icon-component svg/strategy-light))
(def strategy-thin (icon-component svg/strategy-thin))
(def strategy-fill (icon-component svg/strategy-fill))
(def strategy-duotone (icon-component svg/strategy-duotone))
(def stripe-logo-bold (icon-component svg/stripe-logo-bold))
(def stripe-logo (icon-component svg/stripe-logo-regular))
(def stripe-logo-light (icon-component svg/stripe-logo-light))
(def stripe-logo-thin (icon-component svg/stripe-logo-thin))
(def stripe-logo-fill (icon-component svg/stripe-logo-fill))
(def stripe-logo-duotone (icon-component svg/stripe-logo-duotone))
(def student-bold (icon-component svg/student-bold))
(def student (icon-component svg/student-regular))
(def student-light (icon-component svg/student-light))
(def student-thin (icon-component svg/student-thin))
(def student-fill (icon-component svg/student-fill))
(def student-duotone (icon-component svg/student-duotone))
(def subset-of-bold (icon-component svg/subset-of-bold))
(def subset-of (icon-component svg/subset-of-regular))
(def subset-of-light (icon-component svg/subset-of-light))
(def subset-of-thin (icon-component svg/subset-of-thin))
(def subset-of-fill (icon-component svg/subset-of-fill))
(def subset-of-duotone (icon-component svg/subset-of-duotone))
(def subset-proper-of-bold (icon-component svg/subset-proper-of-bold))
(def subset-proper-of (icon-component svg/subset-proper-of-regular))
(def subset-proper-of-light (icon-component svg/subset-proper-of-light))
(def subset-proper-of-thin (icon-component svg/subset-proper-of-thin))
(def subset-proper-of-fill (icon-component svg/subset-proper-of-fill))
(def subset-proper-of-duotone (icon-component svg/subset-proper-of-duotone))
(def subtitles-bold (icon-component svg/subtitles-bold))
(def subtitles (icon-component svg/subtitles-regular))
(def subtitles-light (icon-component svg/subtitles-light))
(def subtitles-thin (icon-component svg/subtitles-thin))
(def subtitles-fill (icon-component svg/subtitles-fill))
(def subtitles-duotone (icon-component svg/subtitles-duotone))
(def subtitles-slash-bold (icon-component svg/subtitles-slash-bold))
(def subtitles-slash (icon-component svg/subtitles-slash-regular))
(def subtitles-slash-light (icon-component svg/subtitles-slash-light))
(def subtitles-slash-thin (icon-component svg/subtitles-slash-thin))
(def subtitles-slash-fill (icon-component svg/subtitles-slash-fill))
(def subtitles-slash-duotone (icon-component svg/subtitles-slash-duotone))
(def subtract-bold (icon-component svg/subtract-bold))
(def subtract (icon-component svg/subtract-regular))
(def subtract-light (icon-component svg/subtract-light))
(def subtract-thin (icon-component svg/subtract-thin))
(def subtract-fill (icon-component svg/subtract-fill))
(def subtract-duotone (icon-component svg/subtract-duotone))
(def subtract-square-bold (icon-component svg/subtract-square-bold))
(def subtract-square (icon-component svg/subtract-square-regular))
(def subtract-square-light (icon-component svg/subtract-square-light))
(def subtract-square-thin (icon-component svg/subtract-square-thin))
(def subtract-square-fill (icon-component svg/subtract-square-fill))
(def subtract-square-duotone (icon-component svg/subtract-square-duotone))
(def subway-bold (icon-component svg/subway-bold))
(def subway (icon-component svg/subway-regular))
(def subway-light (icon-component svg/subway-light))
(def subway-thin (icon-component svg/subway-thin))
(def subway-fill (icon-component svg/subway-fill))
(def subway-duotone (icon-component svg/subway-duotone))
(def suitcase-bold (icon-component svg/suitcase-bold))
(def suitcase (icon-component svg/suitcase-regular))
(def suitcase-light (icon-component svg/suitcase-light))
(def suitcase-thin (icon-component svg/suitcase-thin))
(def suitcase-fill (icon-component svg/suitcase-fill))
(def suitcase-duotone (icon-component svg/suitcase-duotone))
(def suitcase-rolling-bold (icon-component svg/suitcase-rolling-bold))
(def suitcase-rolling (icon-component svg/suitcase-rolling-regular))
(def suitcase-rolling-light (icon-component svg/suitcase-rolling-light))
(def suitcase-rolling-thin (icon-component svg/suitcase-rolling-thin))
(def suitcase-rolling-fill (icon-component svg/suitcase-rolling-fill))
(def suitcase-rolling-duotone (icon-component svg/suitcase-rolling-duotone))
(def suitcase-simple-bold (icon-component svg/suitcase-simple-bold))
(def suitcase-simple (icon-component svg/suitcase-simple-regular))
(def suitcase-simple-light (icon-component svg/suitcase-simple-light))
(def suitcase-simple-thin (icon-component svg/suitcase-simple-thin))
(def suitcase-simple-fill (icon-component svg/suitcase-simple-fill))
(def suitcase-simple-duotone (icon-component svg/suitcase-simple-duotone))
(def sun-bold (icon-component svg/sun-bold))
(def sun (icon-component svg/sun-regular))
(def sun-light (icon-component svg/sun-light))
(def sun-thin (icon-component svg/sun-thin))
(def sun-fill (icon-component svg/sun-fill))
(def sun-duotone (icon-component svg/sun-duotone))
(def sun-dim-bold (icon-component svg/sun-dim-bold))
(def sun-dim (icon-component svg/sun-dim-regular))
(def sun-dim-light (icon-component svg/sun-dim-light))
(def sun-dim-thin (icon-component svg/sun-dim-thin))
(def sun-dim-fill (icon-component svg/sun-dim-fill))
(def sun-dim-duotone (icon-component svg/sun-dim-duotone))
(def sun-horizon-bold (icon-component svg/sun-horizon-bold))
(def sun-horizon (icon-component svg/sun-horizon-regular))
(def sun-horizon-light (icon-component svg/sun-horizon-light))
(def sun-horizon-thin (icon-component svg/sun-horizon-thin))
(def sun-horizon-fill (icon-component svg/sun-horizon-fill))
(def sun-horizon-duotone (icon-component svg/sun-horizon-duotone))
(def sunglasses-bold (icon-component svg/sunglasses-bold))
(def sunglasses (icon-component svg/sunglasses-regular))
(def sunglasses-light (icon-component svg/sunglasses-light))
(def sunglasses-thin (icon-component svg/sunglasses-thin))
(def sunglasses-fill (icon-component svg/sunglasses-fill))
(def sunglasses-duotone (icon-component svg/sunglasses-duotone))
(def superset-of-bold (icon-component svg/superset-of-bold))
(def superset-of (icon-component svg/superset-of-regular))
(def superset-of-light (icon-component svg/superset-of-light))
(def superset-of-thin (icon-component svg/superset-of-thin))
(def superset-of-fill (icon-component svg/superset-of-fill))
(def superset-of-duotone (icon-component svg/superset-of-duotone))
(def superset-proper-of-bold (icon-component svg/superset-proper-of-bold))
(def superset-proper-of (icon-component svg/superset-proper-of-regular))
(def superset-proper-of-light (icon-component svg/superset-proper-of-light))
(def superset-proper-of-thin (icon-component svg/superset-proper-of-thin))
(def superset-proper-of-fill (icon-component svg/superset-proper-of-fill))
(def superset-proper-of-duotone (icon-component svg/superset-proper-of-duotone))
(def swap-bold (icon-component svg/swap-bold))
(def swap (icon-component svg/swap-regular))
(def swap-light (icon-component svg/swap-light))
(def swap-thin (icon-component svg/swap-thin))
(def swap-fill (icon-component svg/swap-fill))
(def swap-duotone (icon-component svg/swap-duotone))
(def swatches-bold (icon-component svg/swatches-bold))
(def swatches (icon-component svg/swatches-regular))
(def swatches-light (icon-component svg/swatches-light))
(def swatches-thin (icon-component svg/swatches-thin))
(def swatches-fill (icon-component svg/swatches-fill))
(def swatches-duotone (icon-component svg/swatches-duotone))
(def swimming-pool-bold (icon-component svg/swimming-pool-bold))
(def swimming-pool (icon-component svg/swimming-pool-regular))
(def swimming-pool-light (icon-component svg/swimming-pool-light))
(def swimming-pool-thin (icon-component svg/swimming-pool-thin))
(def swimming-pool-fill (icon-component svg/swimming-pool-fill))
(def swimming-pool-duotone (icon-component svg/swimming-pool-duotone))
(def sword-bold (icon-component svg/sword-bold))
(def sword (icon-component svg/sword-regular))
(def sword-light (icon-component svg/sword-light))
(def sword-thin (icon-component svg/sword-thin))
(def sword-fill (icon-component svg/sword-fill))
(def sword-duotone (icon-component svg/sword-duotone))
(def synagogue-bold (icon-component svg/synagogue-bold))
(def synagogue (icon-component svg/synagogue-regular))
(def synagogue-light (icon-component svg/synagogue-light))
(def synagogue-thin (icon-component svg/synagogue-thin))
(def synagogue-fill (icon-component svg/synagogue-fill))
(def synagogue-duotone (icon-component svg/synagogue-duotone))
(def syringe-bold (icon-component svg/syringe-bold))
(def syringe (icon-component svg/syringe-regular))
(def syringe-light (icon-component svg/syringe-light))
(def syringe-thin (icon-component svg/syringe-thin))
(def syringe-fill (icon-component svg/syringe-fill))
(def syringe-duotone (icon-component svg/syringe-duotone))
(def t-shirt-bold (icon-component svg/t-shirt-bold))
(def t-shirt (icon-component svg/t-shirt-regular))
(def t-shirt-light (icon-component svg/t-shirt-light))
(def t-shirt-thin (icon-component svg/t-shirt-thin))
(def t-shirt-fill (icon-component svg/t-shirt-fill))
(def t-shirt-duotone (icon-component svg/t-shirt-duotone))
(def table-bold (icon-component svg/table-bold))
(def table (icon-component svg/table-regular))
(def table-light (icon-component svg/table-light))
(def table-thin (icon-component svg/table-thin))
(def table-fill (icon-component svg/table-fill))
(def table-duotone (icon-component svg/table-duotone))
(def tabs-bold (icon-component svg/tabs-bold))
(def tabs (icon-component svg/tabs-regular))
(def tabs-light (icon-component svg/tabs-light))
(def tabs-thin (icon-component svg/tabs-thin))
(def tabs-fill (icon-component svg/tabs-fill))
(def tabs-duotone (icon-component svg/tabs-duotone))
(def tag-bold (icon-component svg/tag-bold))
(def tag (icon-component svg/tag-regular))
(def tag-light (icon-component svg/tag-light))
(def tag-thin (icon-component svg/tag-thin))
(def tag-fill (icon-component svg/tag-fill))
(def tag-duotone (icon-component svg/tag-duotone))
(def tag-chevron-bold (icon-component svg/tag-chevron-bold))
(def tag-chevron (icon-component svg/tag-chevron-regular))
(def tag-chevron-light (icon-component svg/tag-chevron-light))
(def tag-chevron-thin (icon-component svg/tag-chevron-thin))
(def tag-chevron-fill (icon-component svg/tag-chevron-fill))
(def tag-chevron-duotone (icon-component svg/tag-chevron-duotone))
(def tag-simple-bold (icon-component svg/tag-simple-bold))
(def tag-simple (icon-component svg/tag-simple-regular))
(def tag-simple-light (icon-component svg/tag-simple-light))
(def tag-simple-thin (icon-component svg/tag-simple-thin))
(def tag-simple-fill (icon-component svg/tag-simple-fill))
(def tag-simple-duotone (icon-component svg/tag-simple-duotone))
(def target-bold (icon-component svg/target-bold))
(def target (icon-component svg/target-regular))
(def target-light (icon-component svg/target-light))
(def target-thin (icon-component svg/target-thin))
(def target-fill (icon-component svg/target-fill))
(def target-duotone (icon-component svg/target-duotone))
(def taxi-bold (icon-component svg/taxi-bold))
(def taxi (icon-component svg/taxi-regular))
(def taxi-light (icon-component svg/taxi-light))
(def taxi-thin (icon-component svg/taxi-thin))
(def taxi-fill (icon-component svg/taxi-fill))
(def taxi-duotone (icon-component svg/taxi-duotone))
(def tea-bag-bold (icon-component svg/tea-bag-bold))
(def tea-bag (icon-component svg/tea-bag-regular))
(def tea-bag-light (icon-component svg/tea-bag-light))
(def tea-bag-thin (icon-component svg/tea-bag-thin))
(def tea-bag-fill (icon-component svg/tea-bag-fill))
(def tea-bag-duotone (icon-component svg/tea-bag-duotone))
(def telegram-logo-bold (icon-component svg/telegram-logo-bold))
(def telegram-logo (icon-component svg/telegram-logo-regular))
(def telegram-logo-light (icon-component svg/telegram-logo-light))
(def telegram-logo-thin (icon-component svg/telegram-logo-thin))
(def telegram-logo-fill (icon-component svg/telegram-logo-fill))
(def telegram-logo-duotone (icon-component svg/telegram-logo-duotone))
(def television-bold (icon-component svg/television-bold))
(def television (icon-component svg/television-regular))
(def television-light (icon-component svg/television-light))
(def television-thin (icon-component svg/television-thin))
(def television-fill (icon-component svg/television-fill))
(def television-duotone (icon-component svg/television-duotone))
(def television-simple-bold (icon-component svg/television-simple-bold))
(def television-simple (icon-component svg/television-simple-regular))
(def television-simple-light (icon-component svg/television-simple-light))
(def television-simple-thin (icon-component svg/television-simple-thin))
(def television-simple-fill (icon-component svg/television-simple-fill))
(def television-simple-duotone (icon-component svg/television-simple-duotone))
(def tennis-ball-bold (icon-component svg/tennis-ball-bold))
(def tennis-ball (icon-component svg/tennis-ball-regular))
(def tennis-ball-light (icon-component svg/tennis-ball-light))
(def tennis-ball-thin (icon-component svg/tennis-ball-thin))
(def tennis-ball-fill (icon-component svg/tennis-ball-fill))
(def tennis-ball-duotone (icon-component svg/tennis-ball-duotone))
(def tent-bold (icon-component svg/tent-bold))
(def tent (icon-component svg/tent-regular))
(def tent-light (icon-component svg/tent-light))
(def tent-thin (icon-component svg/tent-thin))
(def tent-fill (icon-component svg/tent-fill))
(def tent-duotone (icon-component svg/tent-duotone))
(def terminal-bold (icon-component svg/terminal-bold))
(def terminal (icon-component svg/terminal-regular))
(def terminal-light (icon-component svg/terminal-light))
(def terminal-thin (icon-component svg/terminal-thin))
(def terminal-fill (icon-component svg/terminal-fill))
(def terminal-duotone (icon-component svg/terminal-duotone))
(def terminal-window-bold (icon-component svg/terminal-window-bold))
(def terminal-window (icon-component svg/terminal-window-regular))
(def terminal-window-light (icon-component svg/terminal-window-light))
(def terminal-window-thin (icon-component svg/terminal-window-thin))
(def terminal-window-fill (icon-component svg/terminal-window-fill))
(def terminal-window-duotone (icon-component svg/terminal-window-duotone))
(def test-tube-bold (icon-component svg/test-tube-bold))
(def test-tube (icon-component svg/test-tube-regular))
(def test-tube-light (icon-component svg/test-tube-light))
(def test-tube-thin (icon-component svg/test-tube-thin))
(def test-tube-fill (icon-component svg/test-tube-fill))
(def test-tube-duotone (icon-component svg/test-tube-duotone))
(def text-a-underline-bold (icon-component svg/text-a-underline-bold))
(def text-a-underline (icon-component svg/text-a-underline-regular))
(def text-a-underline-light (icon-component svg/text-a-underline-light))
(def text-a-underline-thin (icon-component svg/text-a-underline-thin))
(def text-a-underline-fill (icon-component svg/text-a-underline-fill))
(def text-a-underline-duotone (icon-component svg/text-a-underline-duotone))
(def text-aa-bold (icon-component svg/text-aa-bold))
(def text-aa (icon-component svg/text-aa-regular))
(def text-aa-light (icon-component svg/text-aa-light))
(def text-aa-thin (icon-component svg/text-aa-thin))
(def text-aa-fill (icon-component svg/text-aa-fill))
(def text-aa-duotone (icon-component svg/text-aa-duotone))
(def text-align-center-bold (icon-component svg/text-align-center-bold))
(def text-align-center (icon-component svg/text-align-center-regular))
(def text-align-center-light (icon-component svg/text-align-center-light))
(def text-align-center-thin (icon-component svg/text-align-center-thin))
(def text-align-center-fill (icon-component svg/text-align-center-fill))
(def text-align-center-duotone (icon-component svg/text-align-center-duotone))
(def text-align-justify-bold (icon-component svg/text-align-justify-bold))
(def text-align-justify (icon-component svg/text-align-justify-regular))
(def text-align-justify-light (icon-component svg/text-align-justify-light))
(def text-align-justify-thin (icon-component svg/text-align-justify-thin))
(def text-align-justify-fill (icon-component svg/text-align-justify-fill))
(def text-align-justify-duotone (icon-component svg/text-align-justify-duotone))
(def text-align-left-bold (icon-component svg/text-align-left-bold))
(def text-align-left (icon-component svg/text-align-left-regular))
(def text-align-left-light (icon-component svg/text-align-left-light))
(def text-align-left-thin (icon-component svg/text-align-left-thin))
(def text-align-left-fill (icon-component svg/text-align-left-fill))
(def text-align-left-duotone (icon-component svg/text-align-left-duotone))
(def text-align-right-bold (icon-component svg/text-align-right-bold))
(def text-align-right (icon-component svg/text-align-right-regular))
(def text-align-right-light (icon-component svg/text-align-right-light))
(def text-align-right-thin (icon-component svg/text-align-right-thin))
(def text-align-right-fill (icon-component svg/text-align-right-fill))
(def text-align-right-duotone (icon-component svg/text-align-right-duotone))
(def text-b-bold (icon-component svg/text-b-bold))
(def text-b (icon-component svg/text-b-regular))
(def text-b-light (icon-component svg/text-b-light))
(def text-b-thin (icon-component svg/text-b-thin))
(def text-b-fill (icon-component svg/text-b-fill))
(def text-b-duotone (icon-component svg/text-b-duotone))
(def text-columns-bold (icon-component svg/text-columns-bold))
(def text-columns (icon-component svg/text-columns-regular))
(def text-columns-light (icon-component svg/text-columns-light))
(def text-columns-thin (icon-component svg/text-columns-thin))
(def text-columns-fill (icon-component svg/text-columns-fill))
(def text-columns-duotone (icon-component svg/text-columns-duotone))
(def text-h-bold (icon-component svg/text-h-bold))
(def text-h (icon-component svg/text-h-regular))
(def text-h-light (icon-component svg/text-h-light))
(def text-h-thin (icon-component svg/text-h-thin))
(def text-h-fill (icon-component svg/text-h-fill))
(def text-h-duotone (icon-component svg/text-h-duotone))
(def text-h-five-bold (icon-component svg/text-h-five-bold))
(def text-h-five (icon-component svg/text-h-five-regular))
(def text-h-five-light (icon-component svg/text-h-five-light))
(def text-h-five-thin (icon-component svg/text-h-five-thin))
(def text-h-five-fill (icon-component svg/text-h-five-fill))
(def text-h-five-duotone (icon-component svg/text-h-five-duotone))
(def text-h-four-bold (icon-component svg/text-h-four-bold))
(def text-h-four (icon-component svg/text-h-four-regular))
(def text-h-four-light (icon-component svg/text-h-four-light))
(def text-h-four-thin (icon-component svg/text-h-four-thin))
(def text-h-four-fill (icon-component svg/text-h-four-fill))
(def text-h-four-duotone (icon-component svg/text-h-four-duotone))
(def text-h-one-bold (icon-component svg/text-h-one-bold))
(def text-h-one (icon-component svg/text-h-one-regular))
(def text-h-one-light (icon-component svg/text-h-one-light))
(def text-h-one-thin (icon-component svg/text-h-one-thin))
(def text-h-one-fill (icon-component svg/text-h-one-fill))
(def text-h-one-duotone (icon-component svg/text-h-one-duotone))
(def text-h-six-bold (icon-component svg/text-h-six-bold))
(def text-h-six (icon-component svg/text-h-six-regular))
(def text-h-six-light (icon-component svg/text-h-six-light))
(def text-h-six-thin (icon-component svg/text-h-six-thin))
(def text-h-six-fill (icon-component svg/text-h-six-fill))
(def text-h-six-duotone (icon-component svg/text-h-six-duotone))
(def text-h-three-bold (icon-component svg/text-h-three-bold))
(def text-h-three (icon-component svg/text-h-three-regular))
(def text-h-three-light (icon-component svg/text-h-three-light))
(def text-h-three-thin (icon-component svg/text-h-three-thin))
(def text-h-three-fill (icon-component svg/text-h-three-fill))
(def text-h-three-duotone (icon-component svg/text-h-three-duotone))
(def text-h-two-bold (icon-component svg/text-h-two-bold))
(def text-h-two (icon-component svg/text-h-two-regular))
(def text-h-two-light (icon-component svg/text-h-two-light))
(def text-h-two-thin (icon-component svg/text-h-two-thin))
(def text-h-two-fill (icon-component svg/text-h-two-fill))
(def text-h-two-duotone (icon-component svg/text-h-two-duotone))
(def text-indent-bold (icon-component svg/text-indent-bold))
(def text-indent (icon-component svg/text-indent-regular))
(def text-indent-light (icon-component svg/text-indent-light))
(def text-indent-thin (icon-component svg/text-indent-thin))
(def text-indent-fill (icon-component svg/text-indent-fill))
(def text-indent-duotone (icon-component svg/text-indent-duotone))
(def text-italic-bold (icon-component svg/text-italic-bold))
(def text-italic (icon-component svg/text-italic-regular))
(def text-italic-light (icon-component svg/text-italic-light))
(def text-italic-thin (icon-component svg/text-italic-thin))
(def text-italic-fill (icon-component svg/text-italic-fill))
(def text-italic-duotone (icon-component svg/text-italic-duotone))
(def text-outdent-bold (icon-component svg/text-outdent-bold))
(def text-outdent (icon-component svg/text-outdent-regular))
(def text-outdent-light (icon-component svg/text-outdent-light))
(def text-outdent-thin (icon-component svg/text-outdent-thin))
(def text-outdent-fill (icon-component svg/text-outdent-fill))
(def text-outdent-duotone (icon-component svg/text-outdent-duotone))
(def text-strikethrough-bold (icon-component svg/text-strikethrough-bold))
(def text-strikethrough (icon-component svg/text-strikethrough-regular))
(def text-strikethrough-light (icon-component svg/text-strikethrough-light))
(def text-strikethrough-thin (icon-component svg/text-strikethrough-thin))
(def text-strikethrough-fill (icon-component svg/text-strikethrough-fill))
(def text-strikethrough-duotone (icon-component svg/text-strikethrough-duotone))
(def text-subscript-bold (icon-component svg/text-subscript-bold))
(def text-subscript (icon-component svg/text-subscript-regular))
(def text-subscript-light (icon-component svg/text-subscript-light))
(def text-subscript-thin (icon-component svg/text-subscript-thin))
(def text-subscript-fill (icon-component svg/text-subscript-fill))
(def text-subscript-duotone (icon-component svg/text-subscript-duotone))
(def text-superscript-bold (icon-component svg/text-superscript-bold))
(def text-superscript (icon-component svg/text-superscript-regular))
(def text-superscript-light (icon-component svg/text-superscript-light))
(def text-superscript-thin (icon-component svg/text-superscript-thin))
(def text-superscript-fill (icon-component svg/text-superscript-fill))
(def text-superscript-duotone (icon-component svg/text-superscript-duotone))
(def text-t-bold (icon-component svg/text-t-bold))
(def text-t (icon-component svg/text-t-regular))
(def text-t-light (icon-component svg/text-t-light))
(def text-t-thin (icon-component svg/text-t-thin))
(def text-t-fill (icon-component svg/text-t-fill))
(def text-t-duotone (icon-component svg/text-t-duotone))
(def text-t-slash-bold (icon-component svg/text-t-slash-bold))
(def text-t-slash (icon-component svg/text-t-slash-regular))
(def text-t-slash-light (icon-component svg/text-t-slash-light))
(def text-t-slash-thin (icon-component svg/text-t-slash-thin))
(def text-t-slash-fill (icon-component svg/text-t-slash-fill))
(def text-t-slash-duotone (icon-component svg/text-t-slash-duotone))
(def text-underline-bold (icon-component svg/text-underline-bold))
(def text-underline (icon-component svg/text-underline-regular))
(def text-underline-light (icon-component svg/text-underline-light))
(def text-underline-thin (icon-component svg/text-underline-thin))
(def text-underline-fill (icon-component svg/text-underline-fill))
(def text-underline-duotone (icon-component svg/text-underline-duotone))
(def textbox-bold (icon-component svg/textbox-bold))
(def textbox (icon-component svg/textbox-regular))
(def textbox-light (icon-component svg/textbox-light))
(def textbox-thin (icon-component svg/textbox-thin))
(def textbox-fill (icon-component svg/textbox-fill))
(def textbox-duotone (icon-component svg/textbox-duotone))
(def thermometer-bold (icon-component svg/thermometer-bold))
(def thermometer (icon-component svg/thermometer-regular))
(def thermometer-light (icon-component svg/thermometer-light))
(def thermometer-thin (icon-component svg/thermometer-thin))
(def thermometer-fill (icon-component svg/thermometer-fill))
(def thermometer-duotone (icon-component svg/thermometer-duotone))
(def thermometer-cold-bold (icon-component svg/thermometer-cold-bold))
(def thermometer-cold (icon-component svg/thermometer-cold-regular))
(def thermometer-cold-light (icon-component svg/thermometer-cold-light))
(def thermometer-cold-thin (icon-component svg/thermometer-cold-thin))
(def thermometer-cold-fill (icon-component svg/thermometer-cold-fill))
(def thermometer-cold-duotone (icon-component svg/thermometer-cold-duotone))
(def thermometer-hot-bold (icon-component svg/thermometer-hot-bold))
(def thermometer-hot (icon-component svg/thermometer-hot-regular))
(def thermometer-hot-light (icon-component svg/thermometer-hot-light))
(def thermometer-hot-thin (icon-component svg/thermometer-hot-thin))
(def thermometer-hot-fill (icon-component svg/thermometer-hot-fill))
(def thermometer-hot-duotone (icon-component svg/thermometer-hot-duotone))
(def thermometer-simple-bold (icon-component svg/thermometer-simple-bold))
(def thermometer-simple (icon-component svg/thermometer-simple-regular))
(def thermometer-simple-light (icon-component svg/thermometer-simple-light))
(def thermometer-simple-thin (icon-component svg/thermometer-simple-thin))
(def thermometer-simple-fill (icon-component svg/thermometer-simple-fill))
(def thermometer-simple-duotone (icon-component svg/thermometer-simple-duotone))
(def threads-logo-bold (icon-component svg/threads-logo-bold))
(def threads-logo (icon-component svg/threads-logo-regular))
(def threads-logo-light (icon-component svg/threads-logo-light))
(def threads-logo-thin (icon-component svg/threads-logo-thin))
(def threads-logo-fill (icon-component svg/threads-logo-fill))
(def threads-logo-duotone (icon-component svg/threads-logo-duotone))
(def three-d-bold (icon-component svg/three-d-bold))
(def three-d (icon-component svg/three-d-regular))
(def three-d-light (icon-component svg/three-d-light))
(def three-d-thin (icon-component svg/three-d-thin))
(def three-d-fill (icon-component svg/three-d-fill))
(def three-d-duotone (icon-component svg/three-d-duotone))
(def thumbs-down-bold (icon-component svg/thumbs-down-bold))
(def thumbs-down (icon-component svg/thumbs-down-regular))
(def thumbs-down-light (icon-component svg/thumbs-down-light))
(def thumbs-down-thin (icon-component svg/thumbs-down-thin))
(def thumbs-down-fill (icon-component svg/thumbs-down-fill))
(def thumbs-down-duotone (icon-component svg/thumbs-down-duotone))
(def thumbs-up-bold (icon-component svg/thumbs-up-bold))
(def thumbs-up (icon-component svg/thumbs-up-regular))
(def thumbs-up-light (icon-component svg/thumbs-up-light))
(def thumbs-up-thin (icon-component svg/thumbs-up-thin))
(def thumbs-up-fill (icon-component svg/thumbs-up-fill))
(def thumbs-up-duotone (icon-component svg/thumbs-up-duotone))
(def ticket-bold (icon-component svg/ticket-bold))
(def ticket (icon-component svg/ticket-regular))
(def ticket-light (icon-component svg/ticket-light))
(def ticket-thin (icon-component svg/ticket-thin))
(def ticket-fill (icon-component svg/ticket-fill))
(def ticket-duotone (icon-component svg/ticket-duotone))
(def tidal-logo-bold (icon-component svg/tidal-logo-bold))
(def tidal-logo (icon-component svg/tidal-logo-regular))
(def tidal-logo-light (icon-component svg/tidal-logo-light))
(def tidal-logo-thin (icon-component svg/tidal-logo-thin))
(def tidal-logo-fill (icon-component svg/tidal-logo-fill))
(def tidal-logo-duotone (icon-component svg/tidal-logo-duotone))
(def tiktok-logo-bold (icon-component svg/tiktok-logo-bold))
(def tiktok-logo (icon-component svg/tiktok-logo-regular))
(def tiktok-logo-light (icon-component svg/tiktok-logo-light))
(def tiktok-logo-thin (icon-component svg/tiktok-logo-thin))
(def tiktok-logo-fill (icon-component svg/tiktok-logo-fill))
(def tiktok-logo-duotone (icon-component svg/tiktok-logo-duotone))
(def tilde-bold (icon-component svg/tilde-bold))
(def tilde (icon-component svg/tilde-regular))
(def tilde-light (icon-component svg/tilde-light))
(def tilde-thin (icon-component svg/tilde-thin))
(def tilde-fill (icon-component svg/tilde-fill))
(def tilde-duotone (icon-component svg/tilde-duotone))
(def timer-bold (icon-component svg/timer-bold))
(def timer (icon-component svg/timer-regular))
(def timer-light (icon-component svg/timer-light))
(def timer-thin (icon-component svg/timer-thin))
(def timer-fill (icon-component svg/timer-fill))
(def timer-duotone (icon-component svg/timer-duotone))
(def tip-jar-bold (icon-component svg/tip-jar-bold))
(def tip-jar (icon-component svg/tip-jar-regular))
(def tip-jar-light (icon-component svg/tip-jar-light))
(def tip-jar-thin (icon-component svg/tip-jar-thin))
(def tip-jar-fill (icon-component svg/tip-jar-fill))
(def tip-jar-duotone (icon-component svg/tip-jar-duotone))
(def tipi-bold (icon-component svg/tipi-bold))
(def tipi (icon-component svg/tipi-regular))
(def tipi-light (icon-component svg/tipi-light))
(def tipi-thin (icon-component svg/tipi-thin))
(def tipi-fill (icon-component svg/tipi-fill))
(def tipi-duotone (icon-component svg/tipi-duotone))
(def tire-bold (icon-component svg/tire-bold))
(def tire (icon-component svg/tire-regular))
(def tire-light (icon-component svg/tire-light))
(def tire-thin (icon-component svg/tire-thin))
(def tire-fill (icon-component svg/tire-fill))
(def tire-duotone (icon-component svg/tire-duotone))
(def toggle-left-bold (icon-component svg/toggle-left-bold))
(def toggle-left (icon-component svg/toggle-left-regular))
(def toggle-left-light (icon-component svg/toggle-left-light))
(def toggle-left-thin (icon-component svg/toggle-left-thin))
(def toggle-left-fill (icon-component svg/toggle-left-fill))
(def toggle-left-duotone (icon-component svg/toggle-left-duotone))
(def toggle-right-bold (icon-component svg/toggle-right-bold))
(def toggle-right (icon-component svg/toggle-right-regular))
(def toggle-right-light (icon-component svg/toggle-right-light))
(def toggle-right-thin (icon-component svg/toggle-right-thin))
(def toggle-right-fill (icon-component svg/toggle-right-fill))
(def toggle-right-duotone (icon-component svg/toggle-right-duotone))
(def toilet-bold (icon-component svg/toilet-bold))
(def toilet (icon-component svg/toilet-regular))
(def toilet-light (icon-component svg/toilet-light))
(def toilet-thin (icon-component svg/toilet-thin))
(def toilet-fill (icon-component svg/toilet-fill))
(def toilet-duotone (icon-component svg/toilet-duotone))
(def toilet-paper-bold (icon-component svg/toilet-paper-bold))
(def toilet-paper (icon-component svg/toilet-paper-regular))
(def toilet-paper-light (icon-component svg/toilet-paper-light))
(def toilet-paper-thin (icon-component svg/toilet-paper-thin))
(def toilet-paper-fill (icon-component svg/toilet-paper-fill))
(def toilet-paper-duotone (icon-component svg/toilet-paper-duotone))
(def toolbox-bold (icon-component svg/toolbox-bold))
(def toolbox (icon-component svg/toolbox-regular))
(def toolbox-light (icon-component svg/toolbox-light))
(def toolbox-thin (icon-component svg/toolbox-thin))
(def toolbox-fill (icon-component svg/toolbox-fill))
(def toolbox-duotone (icon-component svg/toolbox-duotone))
(def tooth-bold (icon-component svg/tooth-bold))
(def tooth (icon-component svg/tooth-regular))
(def tooth-light (icon-component svg/tooth-light))
(def tooth-thin (icon-component svg/tooth-thin))
(def tooth-fill (icon-component svg/tooth-fill))
(def tooth-duotone (icon-component svg/tooth-duotone))
(def tornado-bold (icon-component svg/tornado-bold))
(def tornado (icon-component svg/tornado-regular))
(def tornado-light (icon-component svg/tornado-light))
(def tornado-thin (icon-component svg/tornado-thin))
(def tornado-fill (icon-component svg/tornado-fill))
(def tornado-duotone (icon-component svg/tornado-duotone))
(def tote-bold (icon-component svg/tote-bold))
(def tote (icon-component svg/tote-regular))
(def tote-light (icon-component svg/tote-light))
(def tote-thin (icon-component svg/tote-thin))
(def tote-fill (icon-component svg/tote-fill))
(def tote-duotone (icon-component svg/tote-duotone))
(def tote-simple-bold (icon-component svg/tote-simple-bold))
(def tote-simple (icon-component svg/tote-simple-regular))
(def tote-simple-light (icon-component svg/tote-simple-light))
(def tote-simple-thin (icon-component svg/tote-simple-thin))
(def tote-simple-fill (icon-component svg/tote-simple-fill))
(def tote-simple-duotone (icon-component svg/tote-simple-duotone))
(def towel-bold (icon-component svg/towel-bold))
(def towel (icon-component svg/towel-regular))
(def towel-light (icon-component svg/towel-light))
(def towel-thin (icon-component svg/towel-thin))
(def towel-fill (icon-component svg/towel-fill))
(def towel-duotone (icon-component svg/towel-duotone))
(def tractor-bold (icon-component svg/tractor-bold))
(def tractor (icon-component svg/tractor-regular))
(def tractor-light (icon-component svg/tractor-light))
(def tractor-thin (icon-component svg/tractor-thin))
(def tractor-fill (icon-component svg/tractor-fill))
(def tractor-duotone (icon-component svg/tractor-duotone))
(def trademark-bold (icon-component svg/trademark-bold))
(def trademark (icon-component svg/trademark-regular))
(def trademark-light (icon-component svg/trademark-light))
(def trademark-thin (icon-component svg/trademark-thin))
(def trademark-fill (icon-component svg/trademark-fill))
(def trademark-duotone (icon-component svg/trademark-duotone))
(def trademark-registered-bold (icon-component svg/trademark-registered-bold))
(def trademark-registered (icon-component svg/trademark-registered-regular))
(def trademark-registered-light (icon-component svg/trademark-registered-light))
(def trademark-registered-thin (icon-component svg/trademark-registered-thin))
(def trademark-registered-fill (icon-component svg/trademark-registered-fill))
(def trademark-registered-duotone (icon-component svg/trademark-registered-duotone))
(def traffic-cone-bold (icon-component svg/traffic-cone-bold))
(def traffic-cone (icon-component svg/traffic-cone-regular))
(def traffic-cone-light (icon-component svg/traffic-cone-light))
(def traffic-cone-thin (icon-component svg/traffic-cone-thin))
(def traffic-cone-fill (icon-component svg/traffic-cone-fill))
(def traffic-cone-duotone (icon-component svg/traffic-cone-duotone))
(def traffic-sign-bold (icon-component svg/traffic-sign-bold))
(def traffic-sign (icon-component svg/traffic-sign-regular))
(def traffic-sign-light (icon-component svg/traffic-sign-light))
(def traffic-sign-thin (icon-component svg/traffic-sign-thin))
(def traffic-sign-fill (icon-component svg/traffic-sign-fill))
(def traffic-sign-duotone (icon-component svg/traffic-sign-duotone))
(def traffic-signal-bold (icon-component svg/traffic-signal-bold))
(def traffic-signal (icon-component svg/traffic-signal-regular))
(def traffic-signal-light (icon-component svg/traffic-signal-light))
(def traffic-signal-thin (icon-component svg/traffic-signal-thin))
(def traffic-signal-fill (icon-component svg/traffic-signal-fill))
(def traffic-signal-duotone (icon-component svg/traffic-signal-duotone))
(def train-bold (icon-component svg/train-bold))
(def train (icon-component svg/train-regular))
(def train-light (icon-component svg/train-light))
(def train-thin (icon-component svg/train-thin))
(def train-fill (icon-component svg/train-fill))
(def train-duotone (icon-component svg/train-duotone))
(def train-regional-bold (icon-component svg/train-regional-bold))
(def train-regional (icon-component svg/train-regional-regular))
(def train-regional-light (icon-component svg/train-regional-light))
(def train-regional-thin (icon-component svg/train-regional-thin))
(def train-regional-fill (icon-component svg/train-regional-fill))
(def train-regional-duotone (icon-component svg/train-regional-duotone))
(def train-simple-bold (icon-component svg/train-simple-bold))
(def train-simple (icon-component svg/train-simple-regular))
(def train-simple-light (icon-component svg/train-simple-light))
(def train-simple-thin (icon-component svg/train-simple-thin))
(def train-simple-fill (icon-component svg/train-simple-fill))
(def train-simple-duotone (icon-component svg/train-simple-duotone))
(def tram-bold (icon-component svg/tram-bold))
(def tram (icon-component svg/tram-regular))
(def tram-light (icon-component svg/tram-light))
(def tram-thin (icon-component svg/tram-thin))
(def tram-fill (icon-component svg/tram-fill))
(def tram-duotone (icon-component svg/tram-duotone))
(def translate-bold (icon-component svg/translate-bold))
(def translate (icon-component svg/translate-regular))
(def translate-light (icon-component svg/translate-light))
(def translate-thin (icon-component svg/translate-thin))
(def translate-fill (icon-component svg/translate-fill))
(def translate-duotone (icon-component svg/translate-duotone))
(def trash-bold (icon-component svg/trash-bold))
(def trash (icon-component svg/trash-regular))
(def trash-light (icon-component svg/trash-light))
(def trash-thin (icon-component svg/trash-thin))
(def trash-fill (icon-component svg/trash-fill))
(def trash-duotone (icon-component svg/trash-duotone))
(def trash-simple-bold (icon-component svg/trash-simple-bold))
(def trash-simple (icon-component svg/trash-simple-regular))
(def trash-simple-light (icon-component svg/trash-simple-light))
(def trash-simple-thin (icon-component svg/trash-simple-thin))
(def trash-simple-fill (icon-component svg/trash-simple-fill))
(def trash-simple-duotone (icon-component svg/trash-simple-duotone))
(def tray-bold (icon-component svg/tray-bold))
(def tray (icon-component svg/tray-regular))
(def tray-light (icon-component svg/tray-light))
(def tray-thin (icon-component svg/tray-thin))
(def tray-fill (icon-component svg/tray-fill))
(def tray-duotone (icon-component svg/tray-duotone))
(def tray-arrow-down-bold (icon-component svg/tray-arrow-down-bold))
(def tray-arrow-down (icon-component svg/tray-arrow-down-regular))
(def tray-arrow-down-light (icon-component svg/tray-arrow-down-light))
(def tray-arrow-down-thin (icon-component svg/tray-arrow-down-thin))
(def tray-arrow-down-fill (icon-component svg/tray-arrow-down-fill))
(def tray-arrow-down-duotone (icon-component svg/tray-arrow-down-duotone))
(def tray-arrow-up-bold (icon-component svg/tray-arrow-up-bold))
(def tray-arrow-up (icon-component svg/tray-arrow-up-regular))
(def tray-arrow-up-light (icon-component svg/tray-arrow-up-light))
(def tray-arrow-up-thin (icon-component svg/tray-arrow-up-thin))
(def tray-arrow-up-fill (icon-component svg/tray-arrow-up-fill))
(def tray-arrow-up-duotone (icon-component svg/tray-arrow-up-duotone))
(def treasure-chest-bold (icon-component svg/treasure-chest-bold))
(def treasure-chest (icon-component svg/treasure-chest-regular))
(def treasure-chest-light (icon-component svg/treasure-chest-light))
(def treasure-chest-thin (icon-component svg/treasure-chest-thin))
(def treasure-chest-fill (icon-component svg/treasure-chest-fill))
(def treasure-chest-duotone (icon-component svg/treasure-chest-duotone))
(def tree-bold (icon-component svg/tree-bold))
(def tree (icon-component svg/tree-regular))
(def tree-light (icon-component svg/tree-light))
(def tree-thin (icon-component svg/tree-thin))
(def tree-fill (icon-component svg/tree-fill))
(def tree-duotone (icon-component svg/tree-duotone))
(def tree-evergreen-bold (icon-component svg/tree-evergreen-bold))
(def tree-evergreen (icon-component svg/tree-evergreen-regular))
(def tree-evergreen-light (icon-component svg/tree-evergreen-light))
(def tree-evergreen-thin (icon-component svg/tree-evergreen-thin))
(def tree-evergreen-fill (icon-component svg/tree-evergreen-fill))
(def tree-evergreen-duotone (icon-component svg/tree-evergreen-duotone))
(def tree-palm-bold (icon-component svg/tree-palm-bold))
(def tree-palm (icon-component svg/tree-palm-regular))
(def tree-palm-light (icon-component svg/tree-palm-light))
(def tree-palm-thin (icon-component svg/tree-palm-thin))
(def tree-palm-fill (icon-component svg/tree-palm-fill))
(def tree-palm-duotone (icon-component svg/tree-palm-duotone))
(def tree-structure-bold (icon-component svg/tree-structure-bold))
(def tree-structure (icon-component svg/tree-structure-regular))
(def tree-structure-light (icon-component svg/tree-structure-light))
(def tree-structure-thin (icon-component svg/tree-structure-thin))
(def tree-structure-fill (icon-component svg/tree-structure-fill))
(def tree-structure-duotone (icon-component svg/tree-structure-duotone))
(def tree-view-bold (icon-component svg/tree-view-bold))
(def tree-view (icon-component svg/tree-view-regular))
(def tree-view-light (icon-component svg/tree-view-light))
(def tree-view-thin (icon-component svg/tree-view-thin))
(def tree-view-fill (icon-component svg/tree-view-fill))
(def tree-view-duotone (icon-component svg/tree-view-duotone))
(def trend-down-bold (icon-component svg/trend-down-bold))
(def trend-down (icon-component svg/trend-down-regular))
(def trend-down-light (icon-component svg/trend-down-light))
(def trend-down-thin (icon-component svg/trend-down-thin))
(def trend-down-fill (icon-component svg/trend-down-fill))
(def trend-down-duotone (icon-component svg/trend-down-duotone))
(def trend-up-bold (icon-component svg/trend-up-bold))
(def trend-up (icon-component svg/trend-up-regular))
(def trend-up-light (icon-component svg/trend-up-light))
(def trend-up-thin (icon-component svg/trend-up-thin))
(def trend-up-fill (icon-component svg/trend-up-fill))
(def trend-up-duotone (icon-component svg/trend-up-duotone))
(def triangle-bold (icon-component svg/triangle-bold))
(def triangle (icon-component svg/triangle-regular))
(def triangle-light (icon-component svg/triangle-light))
(def triangle-thin (icon-component svg/triangle-thin))
(def triangle-fill (icon-component svg/triangle-fill))
(def triangle-duotone (icon-component svg/triangle-duotone))
(def triangle-dashed-bold (icon-component svg/triangle-dashed-bold))
(def triangle-dashed (icon-component svg/triangle-dashed-regular))
(def triangle-dashed-light (icon-component svg/triangle-dashed-light))
(def triangle-dashed-thin (icon-component svg/triangle-dashed-thin))
(def triangle-dashed-fill (icon-component svg/triangle-dashed-fill))
(def triangle-dashed-duotone (icon-component svg/triangle-dashed-duotone))
(def trolley-bold (icon-component svg/trolley-bold))
(def trolley (icon-component svg/trolley-regular))
(def trolley-light (icon-component svg/trolley-light))
(def trolley-thin (icon-component svg/trolley-thin))
(def trolley-fill (icon-component svg/trolley-fill))
(def trolley-duotone (icon-component svg/trolley-duotone))
(def trolley-suitcase-bold (icon-component svg/trolley-suitcase-bold))
(def trolley-suitcase (icon-component svg/trolley-suitcase-regular))
(def trolley-suitcase-light (icon-component svg/trolley-suitcase-light))
(def trolley-suitcase-thin (icon-component svg/trolley-suitcase-thin))
(def trolley-suitcase-fill (icon-component svg/trolley-suitcase-fill))
(def trolley-suitcase-duotone (icon-component svg/trolley-suitcase-duotone))
(def trophy-bold (icon-component svg/trophy-bold))
(def trophy (icon-component svg/trophy-regular))
(def trophy-light (icon-component svg/trophy-light))
(def trophy-thin (icon-component svg/trophy-thin))
(def trophy-fill (icon-component svg/trophy-fill))
(def trophy-duotone (icon-component svg/trophy-duotone))
(def truck-bold (icon-component svg/truck-bold))
(def truck (icon-component svg/truck-regular))
(def truck-light (icon-component svg/truck-light))
(def truck-thin (icon-component svg/truck-thin))
(def truck-fill (icon-component svg/truck-fill))
(def truck-duotone (icon-component svg/truck-duotone))
(def truck-trailer-bold (icon-component svg/truck-trailer-bold))
(def truck-trailer (icon-component svg/truck-trailer-regular))
(def truck-trailer-light (icon-component svg/truck-trailer-light))
(def truck-trailer-thin (icon-component svg/truck-trailer-thin))
(def truck-trailer-fill (icon-component svg/truck-trailer-fill))
(def truck-trailer-duotone (icon-component svg/truck-trailer-duotone))
(def tumblr-logo-bold (icon-component svg/tumblr-logo-bold))
(def tumblr-logo (icon-component svg/tumblr-logo-regular))
(def tumblr-logo-light (icon-component svg/tumblr-logo-light))
(def tumblr-logo-thin (icon-component svg/tumblr-logo-thin))
(def tumblr-logo-fill (icon-component svg/tumblr-logo-fill))
(def tumblr-logo-duotone (icon-component svg/tumblr-logo-duotone))
(def twitch-logo-bold (icon-component svg/twitch-logo-bold))
(def twitch-logo (icon-component svg/twitch-logo-regular))
(def twitch-logo-light (icon-component svg/twitch-logo-light))
(def twitch-logo-thin (icon-component svg/twitch-logo-thin))
(def twitch-logo-fill (icon-component svg/twitch-logo-fill))
(def twitch-logo-duotone (icon-component svg/twitch-logo-duotone))
(def twitter-logo-bold (icon-component svg/twitter-logo-bold))
(def twitter-logo (icon-component svg/twitter-logo-regular))
(def twitter-logo-light (icon-component svg/twitter-logo-light))
(def twitter-logo-thin (icon-component svg/twitter-logo-thin))
(def twitter-logo-fill (icon-component svg/twitter-logo-fill))
(def twitter-logo-duotone (icon-component svg/twitter-logo-duotone))
(def umbrella-bold (icon-component svg/umbrella-bold))
(def umbrella (icon-component svg/umbrella-regular))
(def umbrella-light (icon-component svg/umbrella-light))
(def umbrella-thin (icon-component svg/umbrella-thin))
(def umbrella-fill (icon-component svg/umbrella-fill))
(def umbrella-duotone (icon-component svg/umbrella-duotone))
(def umbrella-simple-bold (icon-component svg/umbrella-simple-bold))
(def umbrella-simple (icon-component svg/umbrella-simple-regular))
(def umbrella-simple-light (icon-component svg/umbrella-simple-light))
(def umbrella-simple-thin (icon-component svg/umbrella-simple-thin))
(def umbrella-simple-fill (icon-component svg/umbrella-simple-fill))
(def umbrella-simple-duotone (icon-component svg/umbrella-simple-duotone))
(def union-bold (icon-component svg/union-bold))
(def union (icon-component svg/union-regular))
(def union-light (icon-component svg/union-light))
(def union-thin (icon-component svg/union-thin))
(def union-fill (icon-component svg/union-fill))
(def union-duotone (icon-component svg/union-duotone))
(def unite-bold (icon-component svg/unite-bold))
(def unite (icon-component svg/unite-regular))
(def unite-light (icon-component svg/unite-light))
(def unite-thin (icon-component svg/unite-thin))
(def unite-fill (icon-component svg/unite-fill))
(def unite-duotone (icon-component svg/unite-duotone))
(def unite-square-bold (icon-component svg/unite-square-bold))
(def unite-square (icon-component svg/unite-square-regular))
(def unite-square-light (icon-component svg/unite-square-light))
(def unite-square-thin (icon-component svg/unite-square-thin))
(def unite-square-fill (icon-component svg/unite-square-fill))
(def unite-square-duotone (icon-component svg/unite-square-duotone))
(def upload-bold (icon-component svg/upload-bold))
(def upload (icon-component svg/upload-regular))
(def upload-light (icon-component svg/upload-light))
(def upload-thin (icon-component svg/upload-thin))
(def upload-fill (icon-component svg/upload-fill))
(def upload-duotone (icon-component svg/upload-duotone))
(def upload-simple-bold (icon-component svg/upload-simple-bold))
(def upload-simple (icon-component svg/upload-simple-regular))
(def upload-simple-light (icon-component svg/upload-simple-light))
(def upload-simple-thin (icon-component svg/upload-simple-thin))
(def upload-simple-fill (icon-component svg/upload-simple-fill))
(def upload-simple-duotone (icon-component svg/upload-simple-duotone))
(def usb-bold (icon-component svg/usb-bold))
(def usb (icon-component svg/usb-regular))
(def usb-light (icon-component svg/usb-light))
(def usb-thin (icon-component svg/usb-thin))
(def usb-fill (icon-component svg/usb-fill))
(def usb-duotone (icon-component svg/usb-duotone))
(def user-bold (icon-component svg/user-bold))
(def user (icon-component svg/user-regular))
(def user-light (icon-component svg/user-light))
(def user-thin (icon-component svg/user-thin))
(def user-fill (icon-component svg/user-fill))
(def user-duotone (icon-component svg/user-duotone))
(def user-check-bold (icon-component svg/user-check-bold))
(def user-check (icon-component svg/user-check-regular))
(def user-check-light (icon-component svg/user-check-light))
(def user-check-thin (icon-component svg/user-check-thin))
(def user-check-fill (icon-component svg/user-check-fill))
(def user-check-duotone (icon-component svg/user-check-duotone))
(def user-circle-bold (icon-component svg/user-circle-bold))
(def user-circle (icon-component svg/user-circle-regular))
(def user-circle-light (icon-component svg/user-circle-light))
(def user-circle-thin (icon-component svg/user-circle-thin))
(def user-circle-fill (icon-component svg/user-circle-fill))
(def user-circle-duotone (icon-component svg/user-circle-duotone))
(def user-circle-check-bold (icon-component svg/user-circle-check-bold))
(def user-circle-check (icon-component svg/user-circle-check-regular))
(def user-circle-check-light (icon-component svg/user-circle-check-light))
(def user-circle-check-thin (icon-component svg/user-circle-check-thin))
(def user-circle-check-fill (icon-component svg/user-circle-check-fill))
(def user-circle-check-duotone (icon-component svg/user-circle-check-duotone))
(def user-circle-dashed-bold (icon-component svg/user-circle-dashed-bold))
(def user-circle-dashed (icon-component svg/user-circle-dashed-regular))
(def user-circle-dashed-light (icon-component svg/user-circle-dashed-light))
(def user-circle-dashed-thin (icon-component svg/user-circle-dashed-thin))
(def user-circle-dashed-fill (icon-component svg/user-circle-dashed-fill))
(def user-circle-dashed-duotone (icon-component svg/user-circle-dashed-duotone))
(def user-circle-gear-bold (icon-component svg/user-circle-gear-bold))
(def user-circle-gear (icon-component svg/user-circle-gear-regular))
(def user-circle-gear-light (icon-component svg/user-circle-gear-light))
(def user-circle-gear-thin (icon-component svg/user-circle-gear-thin))
(def user-circle-gear-fill (icon-component svg/user-circle-gear-fill))
(def user-circle-gear-duotone (icon-component svg/user-circle-gear-duotone))
(def user-circle-minus-bold (icon-component svg/user-circle-minus-bold))
(def user-circle-minus (icon-component svg/user-circle-minus-regular))
(def user-circle-minus-light (icon-component svg/user-circle-minus-light))
(def user-circle-minus-thin (icon-component svg/user-circle-minus-thin))
(def user-circle-minus-fill (icon-component svg/user-circle-minus-fill))
(def user-circle-minus-duotone (icon-component svg/user-circle-minus-duotone))
(def user-circle-plus-bold (icon-component svg/user-circle-plus-bold))
(def user-circle-plus (icon-component svg/user-circle-plus-regular))
(def user-circle-plus-light (icon-component svg/user-circle-plus-light))
(def user-circle-plus-thin (icon-component svg/user-circle-plus-thin))
(def user-circle-plus-fill (icon-component svg/user-circle-plus-fill))
(def user-circle-plus-duotone (icon-component svg/user-circle-plus-duotone))
(def user-focus-bold (icon-component svg/user-focus-bold))
(def user-focus (icon-component svg/user-focus-regular))
(def user-focus-light (icon-component svg/user-focus-light))
(def user-focus-thin (icon-component svg/user-focus-thin))
(def user-focus-fill (icon-component svg/user-focus-fill))
(def user-focus-duotone (icon-component svg/user-focus-duotone))
(def user-gear-bold (icon-component svg/user-gear-bold))
(def user-gear (icon-component svg/user-gear-regular))
(def user-gear-light (icon-component svg/user-gear-light))
(def user-gear-thin (icon-component svg/user-gear-thin))
(def user-gear-fill (icon-component svg/user-gear-fill))
(def user-gear-duotone (icon-component svg/user-gear-duotone))
(def user-list-bold (icon-component svg/user-list-bold))
(def user-list (icon-component svg/user-list-regular))
(def user-list-light (icon-component svg/user-list-light))
(def user-list-thin (icon-component svg/user-list-thin))
(def user-list-fill (icon-component svg/user-list-fill))
(def user-list-duotone (icon-component svg/user-list-duotone))
(def user-minus-bold (icon-component svg/user-minus-bold))
(def user-minus (icon-component svg/user-minus-regular))
(def user-minus-light (icon-component svg/user-minus-light))
(def user-minus-thin (icon-component svg/user-minus-thin))
(def user-minus-fill (icon-component svg/user-minus-fill))
(def user-minus-duotone (icon-component svg/user-minus-duotone))
(def user-plus-bold (icon-component svg/user-plus-bold))
(def user-plus (icon-component svg/user-plus-regular))
(def user-plus-light (icon-component svg/user-plus-light))
(def user-plus-thin (icon-component svg/user-plus-thin))
(def user-plus-fill (icon-component svg/user-plus-fill))
(def user-plus-duotone (icon-component svg/user-plus-duotone))
(def user-rectangle-bold (icon-component svg/user-rectangle-bold))
(def user-rectangle (icon-component svg/user-rectangle-regular))
(def user-rectangle-light (icon-component svg/user-rectangle-light))
(def user-rectangle-thin (icon-component svg/user-rectangle-thin))
(def user-rectangle-fill (icon-component svg/user-rectangle-fill))
(def user-rectangle-duotone (icon-component svg/user-rectangle-duotone))
(def user-sound-bold (icon-component svg/user-sound-bold))
(def user-sound (icon-component svg/user-sound-regular))
(def user-sound-light (icon-component svg/user-sound-light))
(def user-sound-thin (icon-component svg/user-sound-thin))
(def user-sound-fill (icon-component svg/user-sound-fill))
(def user-sound-duotone (icon-component svg/user-sound-duotone))
(def user-square-bold (icon-component svg/user-square-bold))
(def user-square (icon-component svg/user-square-regular))
(def user-square-light (icon-component svg/user-square-light))
(def user-square-thin (icon-component svg/user-square-thin))
(def user-square-fill (icon-component svg/user-square-fill))
(def user-square-duotone (icon-component svg/user-square-duotone))
(def user-switch-bold (icon-component svg/user-switch-bold))
(def user-switch (icon-component svg/user-switch-regular))
(def user-switch-light (icon-component svg/user-switch-light))
(def user-switch-thin (icon-component svg/user-switch-thin))
(def user-switch-fill (icon-component svg/user-switch-fill))
(def user-switch-duotone (icon-component svg/user-switch-duotone))
(def users-bold (icon-component svg/users-bold))
(def users (icon-component svg/users-regular))
(def users-light (icon-component svg/users-light))
(def users-thin (icon-component svg/users-thin))
(def users-fill (icon-component svg/users-fill))
(def users-duotone (icon-component svg/users-duotone))
(def users-four-bold (icon-component svg/users-four-bold))
(def users-four (icon-component svg/users-four-regular))
(def users-four-light (icon-component svg/users-four-light))
(def users-four-thin (icon-component svg/users-four-thin))
(def users-four-fill (icon-component svg/users-four-fill))
(def users-four-duotone (icon-component svg/users-four-duotone))
(def users-three-bold (icon-component svg/users-three-bold))
(def users-three (icon-component svg/users-three-regular))
(def users-three-light (icon-component svg/users-three-light))
(def users-three-thin (icon-component svg/users-three-thin))
(def users-three-fill (icon-component svg/users-three-fill))
(def users-three-duotone (icon-component svg/users-three-duotone))
(def van-bold (icon-component svg/van-bold))
(def van (icon-component svg/van-regular))
(def van-light (icon-component svg/van-light))
(def van-thin (icon-component svg/van-thin))
(def van-fill (icon-component svg/van-fill))
(def van-duotone (icon-component svg/van-duotone))
(def vault-bold (icon-component svg/vault-bold))
(def vault (icon-component svg/vault-regular))
(def vault-light (icon-component svg/vault-light))
(def vault-thin (icon-component svg/vault-thin))
(def vault-fill (icon-component svg/vault-fill))
(def vault-duotone (icon-component svg/vault-duotone))
(def vector-three-bold (icon-component svg/vector-three-bold))
(def vector-three (icon-component svg/vector-three-regular))
(def vector-three-light (icon-component svg/vector-three-light))
(def vector-three-thin (icon-component svg/vector-three-thin))
(def vector-three-fill (icon-component svg/vector-three-fill))
(def vector-three-duotone (icon-component svg/vector-three-duotone))
(def vector-two-bold (icon-component svg/vector-two-bold))
(def vector-two (icon-component svg/vector-two-regular))
(def vector-two-light (icon-component svg/vector-two-light))
(def vector-two-thin (icon-component svg/vector-two-thin))
(def vector-two-fill (icon-component svg/vector-two-fill))
(def vector-two-duotone (icon-component svg/vector-two-duotone))
(def vibrate-bold (icon-component svg/vibrate-bold))
(def vibrate (icon-component svg/vibrate-regular))
(def vibrate-light (icon-component svg/vibrate-light))
(def vibrate-thin (icon-component svg/vibrate-thin))
(def vibrate-fill (icon-component svg/vibrate-fill))
(def vibrate-duotone (icon-component svg/vibrate-duotone))
(def video-bold (icon-component svg/video-bold))
(def video (icon-component svg/video-regular))
(def video-light (icon-component svg/video-light))
(def video-thin (icon-component svg/video-thin))
(def video-fill (icon-component svg/video-fill))
(def video-duotone (icon-component svg/video-duotone))
(def video-camera-bold (icon-component svg/video-camera-bold))
(def video-camera (icon-component svg/video-camera-regular))
(def video-camera-light (icon-component svg/video-camera-light))
(def video-camera-thin (icon-component svg/video-camera-thin))
(def video-camera-fill (icon-component svg/video-camera-fill))
(def video-camera-duotone (icon-component svg/video-camera-duotone))
(def video-camera-slash-bold (icon-component svg/video-camera-slash-bold))
(def video-camera-slash (icon-component svg/video-camera-slash-regular))
(def video-camera-slash-light (icon-component svg/video-camera-slash-light))
(def video-camera-slash-thin (icon-component svg/video-camera-slash-thin))
(def video-camera-slash-fill (icon-component svg/video-camera-slash-fill))
(def video-camera-slash-duotone (icon-component svg/video-camera-slash-duotone))
(def video-conference-bold (icon-component svg/video-conference-bold))
(def video-conference (icon-component svg/video-conference-regular))
(def video-conference-light (icon-component svg/video-conference-light))
(def video-conference-thin (icon-component svg/video-conference-thin))
(def video-conference-fill (icon-component svg/video-conference-fill))
(def video-conference-duotone (icon-component svg/video-conference-duotone))
(def vignette-bold (icon-component svg/vignette-bold))
(def vignette (icon-component svg/vignette-regular))
(def vignette-light (icon-component svg/vignette-light))
(def vignette-thin (icon-component svg/vignette-thin))
(def vignette-fill (icon-component svg/vignette-fill))
(def vignette-duotone (icon-component svg/vignette-duotone))
(def vinyl-record-bold (icon-component svg/vinyl-record-bold))
(def vinyl-record (icon-component svg/vinyl-record-regular))
(def vinyl-record-light (icon-component svg/vinyl-record-light))
(def vinyl-record-thin (icon-component svg/vinyl-record-thin))
(def vinyl-record-fill (icon-component svg/vinyl-record-fill))
(def vinyl-record-duotone (icon-component svg/vinyl-record-duotone))
(def virtual-reality-bold (icon-component svg/virtual-reality-bold))
(def virtual-reality (icon-component svg/virtual-reality-regular))
(def virtual-reality-light (icon-component svg/virtual-reality-light))
(def virtual-reality-thin (icon-component svg/virtual-reality-thin))
(def virtual-reality-fill (icon-component svg/virtual-reality-fill))
(def virtual-reality-duotone (icon-component svg/virtual-reality-duotone))
(def virus-bold (icon-component svg/virus-bold))
(def virus (icon-component svg/virus-regular))
(def virus-light (icon-component svg/virus-light))
(def virus-thin (icon-component svg/virus-thin))
(def virus-fill (icon-component svg/virus-fill))
(def virus-duotone (icon-component svg/virus-duotone))
(def visor-bold (icon-component svg/visor-bold))
(def visor (icon-component svg/visor-regular))
(def visor-light (icon-component svg/visor-light))
(def visor-thin (icon-component svg/visor-thin))
(def visor-fill (icon-component svg/visor-fill))
(def visor-duotone (icon-component svg/visor-duotone))
(def voicemail-bold (icon-component svg/voicemail-bold))
(def voicemail (icon-component svg/voicemail-regular))
(def voicemail-light (icon-component svg/voicemail-light))
(def voicemail-thin (icon-component svg/voicemail-thin))
(def voicemail-fill (icon-component svg/voicemail-fill))
(def voicemail-duotone (icon-component svg/voicemail-duotone))
(def volleyball-bold (icon-component svg/volleyball-bold))
(def volleyball (icon-component svg/volleyball-regular))
(def volleyball-light (icon-component svg/volleyball-light))
(def volleyball-thin (icon-component svg/volleyball-thin))
(def volleyball-fill (icon-component svg/volleyball-fill))
(def volleyball-duotone (icon-component svg/volleyball-duotone))
(def wall-bold (icon-component svg/wall-bold))
(def wall (icon-component svg/wall-regular))
(def wall-light (icon-component svg/wall-light))
(def wall-thin (icon-component svg/wall-thin))
(def wall-fill (icon-component svg/wall-fill))
(def wall-duotone (icon-component svg/wall-duotone))
(def wallet-bold (icon-component svg/wallet-bold))
(def wallet (icon-component svg/wallet-regular))
(def wallet-light (icon-component svg/wallet-light))
(def wallet-thin (icon-component svg/wallet-thin))
(def wallet-fill (icon-component svg/wallet-fill))
(def wallet-duotone (icon-component svg/wallet-duotone))
(def warehouse-bold (icon-component svg/warehouse-bold))
(def warehouse (icon-component svg/warehouse-regular))
(def warehouse-light (icon-component svg/warehouse-light))
(def warehouse-thin (icon-component svg/warehouse-thin))
(def warehouse-fill (icon-component svg/warehouse-fill))
(def warehouse-duotone (icon-component svg/warehouse-duotone))
(def warning-bold (icon-component svg/warning-bold))
(def warning (icon-component svg/warning-regular))
(def warning-light (icon-component svg/warning-light))
(def warning-thin (icon-component svg/warning-thin))
(def warning-fill (icon-component svg/warning-fill))
(def warning-duotone (icon-component svg/warning-duotone))
(def warning-circle-bold (icon-component svg/warning-circle-bold))
(def warning-circle (icon-component svg/warning-circle-regular))
(def warning-circle-light (icon-component svg/warning-circle-light))
(def warning-circle-thin (icon-component svg/warning-circle-thin))
(def warning-circle-fill (icon-component svg/warning-circle-fill))
(def warning-circle-duotone (icon-component svg/warning-circle-duotone))
(def warning-diamond-bold (icon-component svg/warning-diamond-bold))
(def warning-diamond (icon-component svg/warning-diamond-regular))
(def warning-diamond-light (icon-component svg/warning-diamond-light))
(def warning-diamond-thin (icon-component svg/warning-diamond-thin))
(def warning-diamond-fill (icon-component svg/warning-diamond-fill))
(def warning-diamond-duotone (icon-component svg/warning-diamond-duotone))
(def warning-octagon-bold (icon-component svg/warning-octagon-bold))
(def warning-octagon (icon-component svg/warning-octagon-regular))
(def warning-octagon-light (icon-component svg/warning-octagon-light))
(def warning-octagon-thin (icon-component svg/warning-octagon-thin))
(def warning-octagon-fill (icon-component svg/warning-octagon-fill))
(def warning-octagon-duotone (icon-component svg/warning-octagon-duotone))
(def washing-machine-bold (icon-component svg/washing-machine-bold))
(def washing-machine (icon-component svg/washing-machine-regular))
(def washing-machine-light (icon-component svg/washing-machine-light))
(def washing-machine-thin (icon-component svg/washing-machine-thin))
(def washing-machine-fill (icon-component svg/washing-machine-fill))
(def washing-machine-duotone (icon-component svg/washing-machine-duotone))
(def watch-bold (icon-component svg/watch-bold))
(def watch (icon-component svg/watch-regular))
(def watch-light (icon-component svg/watch-light))
(def watch-thin (icon-component svg/watch-thin))
(def watch-fill (icon-component svg/watch-fill))
(def watch-duotone (icon-component svg/watch-duotone))
(def wave-sawtooth-bold (icon-component svg/wave-sawtooth-bold))
(def wave-sawtooth (icon-component svg/wave-sawtooth-regular))
(def wave-sawtooth-light (icon-component svg/wave-sawtooth-light))
(def wave-sawtooth-thin (icon-component svg/wave-sawtooth-thin))
(def wave-sawtooth-fill (icon-component svg/wave-sawtooth-fill))
(def wave-sawtooth-duotone (icon-component svg/wave-sawtooth-duotone))
(def wave-sine-bold (icon-component svg/wave-sine-bold))
(def wave-sine (icon-component svg/wave-sine-regular))
(def wave-sine-light (icon-component svg/wave-sine-light))
(def wave-sine-thin (icon-component svg/wave-sine-thin))
(def wave-sine-fill (icon-component svg/wave-sine-fill))
(def wave-sine-duotone (icon-component svg/wave-sine-duotone))
(def wave-square-bold (icon-component svg/wave-square-bold))
(def wave-square (icon-component svg/wave-square-regular))
(def wave-square-light (icon-component svg/wave-square-light))
(def wave-square-thin (icon-component svg/wave-square-thin))
(def wave-square-fill (icon-component svg/wave-square-fill))
(def wave-square-duotone (icon-component svg/wave-square-duotone))
(def wave-triangle-bold (icon-component svg/wave-triangle-bold))
(def wave-triangle (icon-component svg/wave-triangle-regular))
(def wave-triangle-light (icon-component svg/wave-triangle-light))
(def wave-triangle-thin (icon-component svg/wave-triangle-thin))
(def wave-triangle-fill (icon-component svg/wave-triangle-fill))
(def wave-triangle-duotone (icon-component svg/wave-triangle-duotone))
(def waveform-bold (icon-component svg/waveform-bold))
(def waveform (icon-component svg/waveform-regular))
(def waveform-light (icon-component svg/waveform-light))
(def waveform-thin (icon-component svg/waveform-thin))
(def waveform-fill (icon-component svg/waveform-fill))
(def waveform-duotone (icon-component svg/waveform-duotone))
(def waveform-slash-bold (icon-component svg/waveform-slash-bold))
(def waveform-slash (icon-component svg/waveform-slash-regular))
(def waveform-slash-light (icon-component svg/waveform-slash-light))
(def waveform-slash-thin (icon-component svg/waveform-slash-thin))
(def waveform-slash-fill (icon-component svg/waveform-slash-fill))
(def waveform-slash-duotone (icon-component svg/waveform-slash-duotone))
(def waves-bold (icon-component svg/waves-bold))
(def waves (icon-component svg/waves-regular))
(def waves-light (icon-component svg/waves-light))
(def waves-thin (icon-component svg/waves-thin))
(def waves-fill (icon-component svg/waves-fill))
(def waves-duotone (icon-component svg/waves-duotone))
(def webcam-bold (icon-component svg/webcam-bold))
(def webcam (icon-component svg/webcam-regular))
(def webcam-light (icon-component svg/webcam-light))
(def webcam-thin (icon-component svg/webcam-thin))
(def webcam-fill (icon-component svg/webcam-fill))
(def webcam-duotone (icon-component svg/webcam-duotone))
(def webcam-slash-bold (icon-component svg/webcam-slash-bold))
(def webcam-slash (icon-component svg/webcam-slash-regular))
(def webcam-slash-light (icon-component svg/webcam-slash-light))
(def webcam-slash-thin (icon-component svg/webcam-slash-thin))
(def webcam-slash-fill (icon-component svg/webcam-slash-fill))
(def webcam-slash-duotone (icon-component svg/webcam-slash-duotone))
(def webhooks-logo-bold (icon-component svg/webhooks-logo-bold))
(def webhooks-logo (icon-component svg/webhooks-logo-regular))
(def webhooks-logo-light (icon-component svg/webhooks-logo-light))
(def webhooks-logo-thin (icon-component svg/webhooks-logo-thin))
(def webhooks-logo-fill (icon-component svg/webhooks-logo-fill))
(def webhooks-logo-duotone (icon-component svg/webhooks-logo-duotone))
(def wechat-logo-bold (icon-component svg/wechat-logo-bold))
(def wechat-logo (icon-component svg/wechat-logo-regular))
(def wechat-logo-light (icon-component svg/wechat-logo-light))
(def wechat-logo-thin (icon-component svg/wechat-logo-thin))
(def wechat-logo-fill (icon-component svg/wechat-logo-fill))
(def wechat-logo-duotone (icon-component svg/wechat-logo-duotone))
(def whatsapp-logo-bold (icon-component svg/whatsapp-logo-bold))
(def whatsapp-logo (icon-component svg/whatsapp-logo-regular))
(def whatsapp-logo-light (icon-component svg/whatsapp-logo-light))
(def whatsapp-logo-thin (icon-component svg/whatsapp-logo-thin))
(def whatsapp-logo-fill (icon-component svg/whatsapp-logo-fill))
(def whatsapp-logo-duotone (icon-component svg/whatsapp-logo-duotone))
(def wheelchair-bold (icon-component svg/wheelchair-bold))
(def wheelchair (icon-component svg/wheelchair-regular))
(def wheelchair-light (icon-component svg/wheelchair-light))
(def wheelchair-thin (icon-component svg/wheelchair-thin))
(def wheelchair-fill (icon-component svg/wheelchair-fill))
(def wheelchair-duotone (icon-component svg/wheelchair-duotone))
(def wheelchair-motion-bold (icon-component svg/wheelchair-motion-bold))
(def wheelchair-motion (icon-component svg/wheelchair-motion-regular))
(def wheelchair-motion-light (icon-component svg/wheelchair-motion-light))
(def wheelchair-motion-thin (icon-component svg/wheelchair-motion-thin))
(def wheelchair-motion-fill (icon-component svg/wheelchair-motion-fill))
(def wheelchair-motion-duotone (icon-component svg/wheelchair-motion-duotone))
(def wifi-high-bold (icon-component svg/wifi-high-bold))
(def wifi-high (icon-component svg/wifi-high-regular))
(def wifi-high-light (icon-component svg/wifi-high-light))
(def wifi-high-thin (icon-component svg/wifi-high-thin))
(def wifi-high-fill (icon-component svg/wifi-high-fill))
(def wifi-high-duotone (icon-component svg/wifi-high-duotone))
(def wifi-low-bold (icon-component svg/wifi-low-bold))
(def wifi-low (icon-component svg/wifi-low-regular))
(def wifi-low-light (icon-component svg/wifi-low-light))
(def wifi-low-thin (icon-component svg/wifi-low-thin))
(def wifi-low-fill (icon-component svg/wifi-low-fill))
(def wifi-low-duotone (icon-component svg/wifi-low-duotone))
(def wifi-medium-bold (icon-component svg/wifi-medium-bold))
(def wifi-medium (icon-component svg/wifi-medium-regular))
(def wifi-medium-light (icon-component svg/wifi-medium-light))
(def wifi-medium-thin (icon-component svg/wifi-medium-thin))
(def wifi-medium-fill (icon-component svg/wifi-medium-fill))
(def wifi-medium-duotone (icon-component svg/wifi-medium-duotone))
(def wifi-none-bold (icon-component svg/wifi-none-bold))
(def wifi-none (icon-component svg/wifi-none-regular))
(def wifi-none-light (icon-component svg/wifi-none-light))
(def wifi-none-thin (icon-component svg/wifi-none-thin))
(def wifi-none-fill (icon-component svg/wifi-none-fill))
(def wifi-none-duotone (icon-component svg/wifi-none-duotone))
(def wifi-slash-bold (icon-component svg/wifi-slash-bold))
(def wifi-slash (icon-component svg/wifi-slash-regular))
(def wifi-slash-light (icon-component svg/wifi-slash-light))
(def wifi-slash-thin (icon-component svg/wifi-slash-thin))
(def wifi-slash-fill (icon-component svg/wifi-slash-fill))
(def wifi-slash-duotone (icon-component svg/wifi-slash-duotone))
(def wifi-x-bold (icon-component svg/wifi-x-bold))
(def wifi-x (icon-component svg/wifi-x-regular))
(def wifi-x-light (icon-component svg/wifi-x-light))
(def wifi-x-thin (icon-component svg/wifi-x-thin))
(def wifi-x-fill (icon-component svg/wifi-x-fill))
(def wifi-x-duotone (icon-component svg/wifi-x-duotone))
(def wind-bold (icon-component svg/wind-bold))
(def wind (icon-component svg/wind-regular))
(def wind-light (icon-component svg/wind-light))
(def wind-thin (icon-component svg/wind-thin))
(def wind-fill (icon-component svg/wind-fill))
(def wind-duotone (icon-component svg/wind-duotone))
(def windmill-bold (icon-component svg/windmill-bold))
(def windmill (icon-component svg/windmill-regular))
(def windmill-light (icon-component svg/windmill-light))
(def windmill-thin (icon-component svg/windmill-thin))
(def windmill-fill (icon-component svg/windmill-fill))
(def windmill-duotone (icon-component svg/windmill-duotone))
(def windows-logo-bold (icon-component svg/windows-logo-bold))
(def windows-logo (icon-component svg/windows-logo-regular))
(def windows-logo-light (icon-component svg/windows-logo-light))
(def windows-logo-thin (icon-component svg/windows-logo-thin))
(def windows-logo-fill (icon-component svg/windows-logo-fill))
(def windows-logo-duotone (icon-component svg/windows-logo-duotone))
(def wine-bold (icon-component svg/wine-bold))
(def wine (icon-component svg/wine-regular))
(def wine-light (icon-component svg/wine-light))
(def wine-thin (icon-component svg/wine-thin))
(def wine-fill (icon-component svg/wine-fill))
(def wine-duotone (icon-component svg/wine-duotone))
(def wrench-bold (icon-component svg/wrench-bold))
(def wrench (icon-component svg/wrench-regular))
(def wrench-light (icon-component svg/wrench-light))
(def wrench-thin (icon-component svg/wrench-thin))
(def wrench-fill (icon-component svg/wrench-fill))
(def wrench-duotone (icon-component svg/wrench-duotone))
(def x-bold (icon-component svg/x-bold))
(def x (icon-component svg/x-regular))
(def x-light (icon-component svg/x-light))
(def x-thin (icon-component svg/x-thin))
(def x-fill (icon-component svg/x-fill))
(def x-duotone (icon-component svg/x-duotone))
(def x-circle-bold (icon-component svg/x-circle-bold))
(def x-circle (icon-component svg/x-circle-regular))
(def x-circle-light (icon-component svg/x-circle-light))
(def x-circle-thin (icon-component svg/x-circle-thin))
(def x-circle-fill (icon-component svg/x-circle-fill))
(def x-circle-duotone (icon-component svg/x-circle-duotone))
(def x-logo-bold (icon-component svg/x-logo-bold))
(def x-logo (icon-component svg/x-logo-regular))
(def x-logo-light (icon-component svg/x-logo-light))
(def x-logo-thin (icon-component svg/x-logo-thin))
(def x-logo-fill (icon-component svg/x-logo-fill))
(def x-logo-duotone (icon-component svg/x-logo-duotone))
(def x-square-bold (icon-component svg/x-square-bold))
(def x-square (icon-component svg/x-square-regular))
(def x-square-light (icon-component svg/x-square-light))
(def x-square-thin (icon-component svg/x-square-thin))
(def x-square-fill (icon-component svg/x-square-fill))
(def x-square-duotone (icon-component svg/x-square-duotone))
(def yarn-bold (icon-component svg/yarn-bold))
(def yarn (icon-component svg/yarn-regular))
(def yarn-light (icon-component svg/yarn-light))
(def yarn-thin (icon-component svg/yarn-thin))
(def yarn-fill (icon-component svg/yarn-fill))
(def yarn-duotone (icon-component svg/yarn-duotone))
(def yin-yang-bold (icon-component svg/yin-yang-bold))
(def yin-yang (icon-component svg/yin-yang-regular))
(def yin-yang-light (icon-component svg/yin-yang-light))
(def yin-yang-thin (icon-component svg/yin-yang-thin))
(def yin-yang-fill (icon-component svg/yin-yang-fill))
(def yin-yang-duotone (icon-component svg/yin-yang-duotone))
(def youtube-logo-bold (icon-component svg/youtube-logo-bold))
(def youtube-logo (icon-component svg/youtube-logo-regular))
(def youtube-logo-light (icon-component svg/youtube-logo-light))
(def youtube-logo-thin (icon-component svg/youtube-logo-thin))
(def youtube-logo-fill (icon-component svg/youtube-logo-fill))
(def youtube-logo-duotone (icon-component svg/youtube-logo-duotone))
