(ns tailrecursion.javelin
  (:require-macros
   [tailrecursion.javelin.macros :refer [with-let cell]])
  (:require
   [tailrecursion.javelin.specials :as specials]
   [tailrecursion.javelin.core :as core]
   [tailrecursion.priority-map  :refer [priority-map]]))

;; internal ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; core

;;; specials

;; (defn no-supported #(apply specials/no-supported %&))
;; (defn if*          #(apply specials/if* %&))
;; (def def*          specials/def*)
;; (def do*           #(apply specials/do* %&))
;; (def loop**        #(apply specials/loop** %&))
;; (def letfn**       specials/letfn**)
;; (def throw*        #(apply specials/throw* %&))
;; (def try**         specials/try**)
;; (def recur*        specials/recur*)
;; (def set!*         specials/set!*)
;; (def ns*           specials/ns*)
;; (def deftype**     specials/deftype**)
;; (def defrecord**   specials/defrecord**)
;; (def dot*          specials/dot*)
;; (def &*            specials/&*)
;; (defn new*         #(apply specials/new* %&))

;; public ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def input      core/input)

(def log        #(js/console.log %1 (clj->js %2)))
(def timeout    #(.setTimeout js/window %1 %2))
(def interval   #(.setInterval js/window %1 %2))

(defn all! [x]
  (set! (.-always x) true)
  (doseq [c (core/sinks-seq x)] (set! (.-always c) true))
  x)

(defn distinct! [x]
  (set! (.-always x) false)
  (doseq [c (core/sinks-seq x)] (set! (.-always c) false))
  x)

(defn timer*
  [msec f init]
  (with-let [out (cell init)]
    ((fn rec []
       (timeout #(do (if-not (neg? @msec) (swap! out f)) (rec))
                (if (neg? @msec) 0 @msec))))))

(defn count* [x]
  (cell (#(if (nil? %2) %1 (inc %1)) ~0 x)))