(ns tailrecursion.boot.gitignore
  (:require
    [clojure.java.io  :refer [file]]
    [clojure.string   :refer [blank? join split]]
    )
  (:import
    [java.nio.file FileSystems]
    )
  )

(defprotocol IMatcher
  (-negated? [this] "Is this pattern negated?")
  (-matches? [this f] "Does file f match this pattern?"))

(defrecord Matcher [negated? matcher]
  IMatcher
  (-negated? [this] negated?)
  (-matches? [this f] (matcher f)))

(defn path-matcher [pattern & [negated?]]
  (let [m (.. FileSystems (getDefault) (getPathMatcher pattern))]
    (Matcher. negated? (fn [f] (.matches m (.getPath f))))))

(defn matches? [matchers f]
  (loop [match? nil, [matcher & more-matchers] matchers]
    (if-not matcher
      match?
      (let [m?  (-matches? matcher f)
            n?  (-negated? matcher)] 
        (recur (if (not m?) match? (not n?)) more-matchers)))))

(defn parse-gitignore [f]
  (let [skip? #(or (blank? %) (re-find #"^\s*#" %))
        lines (->> f slurp (split #"\n") (remove skip?))
        ])
  )
