(ns t6.graph-transform.util)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Utility functions
;;; =================

(defmacro if-schema
  "Evals `body` when `prismatic/schema` is on the classpath, `else` otherwise.
  **Warning**: Aliases `schema.core` to `s` in the current namespace."
  ([then] `(if-schema ~then nil))
  ([then else]
     (if (try (require 'schema.core) true
              (catch java.io.FileNotFoundException e))
       (do (alias 's 'schema.core)
           then)
       else)))


(defn setify-values
  "Takes a map and applies `clojure.core/set` to all of its collection values."
  [m]
  (if m
    (persistent!
     (reduce-kv
      (fn [acc k v]
        (if (coll? v)
          (assoc! acc k (set v))
          acc))
      (transient m)
      m))
    m))
