(ns t6.graph-transform.logic
  (:require [clojure.core.logic :as l]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; core.logic support
;;; ==================

(defn edge
  [parent label child]
  (fn [a]
    (l/to-stream
     (for [[p edges] (:edges t6.graph-transform.core/*current-graph*)
           [l c]     edges]
       (l/unify a [parent label child] [p l c])))))

(defn node
  [q]
  (fn [a]
    (l/to-stream
     (for [node (:nodes t6.graph-transform.core/*current-graph*)]
       (l/unify a q node)))))
