# graph-transform

A Clojure library for transforming graphs.

## Usage

To include in your project, add this to your `project.clj`:

```clojure
[t6/graph-transform "0.1.0"]
[org.clojure/core.logic "0.8.8"] ; Optional: Add if you want to use the core.logic functionality
[rhizome "0.2.1"] ; Optional: Add if you want to visualize graphs
[prismatic/schema "0.2.6"] ; Optional: Add schema if you want to validate your graph data structures
```

For further documentation see https://t6.github.io/graph-transform/

## Example

Goal: Transform the following graph

![graph before transformation](https://raw.github.com/t6/graph-transform/master/docs/graph.svg)

into this graph

![graph after transformation](https://raw.github.com/t6/graph-transform/master/docs/transformed-graph.svg)

We can represent the graph as

```clojure
(def graph
  {:nodes #{1 2 3 4 5}
   :edges {1 #{["a" 2] ["d" 5]}
           2 #{["b" 3]}
           3 #{["c" 4]}}})
```

and the resulting graph as

```clojure
{:nodes #{1 4 3 5}
 :edges {1 #{["ab" 3] ["a" 2] ["d" 5]}
         3 #{["c" 4]}}}
```

which we can get with the following transformation:

```clojure
(require '[clojure.core.logic :as l]
         '[t6.graph-transform.core :refer (transform)]
         '[t6.graph-transform.logic :refer (edge)])

(transform graph
           [(fn [_]
              (l/run* [q]
                (l/fresh [from to parent]
                  (edge from "b" to)
                  (edge parent "a" from)
                  (l/== q
                        {:nodes {:- [from]}
                         :edges {:- {from [["b" to]]}
                                 :+ {parent [["ab" to]]}}}))))])
```

## License

Copyright © 2014 Tobias Kortkamp

Distributed under the MIT License.
