
/* @service services:Session
*/


(function() {
  var __slice = [].slice;

  define(['routes', 'util/actorSocket', 'collaboration/Operation', 'collaboration/CodeMirror', 'collaboration/Client', 'collaboration/Annotations', 'modes/isabelle/defaultWords', 'codemirror'], function(routes, ActorSocket, Operation, CMAdapter, Client, Annotations, idw, CodeMirror) {
    return function($q, $rootScope, $http, Toasts, Dialog) {
      return function(username, project) {
        var apply, getOpenFile, getUser, initFile, remove, session, setActiveFile, update, url;
        session = {
          state: 'closed',
          collaborators: null,
          openFiles: null,
          talkback: null,
          kicked: null,
          inline: {
            output: false,
            errors: true,
            warnings: true
          },
          fileStates: {},
          chat: [],
          me: null
        };
        session.activeDoc = function() {
          var _ref, _ref1;
          return (_ref = session.openFiles) != null ? (_ref1 = _ref[session.me.activeFile]) != null ? _ref1.doc : void 0 : void 0;
        };
        session.activeAnnotations = function() {
          var _ref, _ref1;
          return (_ref = session.openFiles) != null ? (_ref1 = _ref[session.me.activeFile]) != null ? _ref1.annotations : void 0 : void 0;
        };
        session.activeOutput = function() {
          var filtered, k, n, result, u, v, _ref;
          if ((session.cursor != null) && (session.me.activeFile != null)) {
            result = [];
            _ref = session.openFiles[session.me.activeFile].$output;
            for (u in _ref) {
              v = _ref[u];
              for (n in v) {
                k = v[n];
                filtered = k.filter(function(out) {
                  var cursor;
                  cursor = session.cursor;
                  return (out.type !== 'progress') && (out.from.line < cursor.line || out.from.line === cursor.line && out.from.ch <= cursor.ch) && (out.to.line > cursor.line || out.to.line === cursor.line && out.to.ch >= cursor.ch);
                });
                result.push.apply(result, filtered);
              }
            }
            return result;
          }
        };
        session.syncState = function() {
          var _ref, _ref1;
          return (_ref = session.openFiles) != null ? (_ref1 = _ref[session.me.activeFile]) != null ? _ref1.$syncState() : void 0 : void 0;
        };
        apply = function(f) {
          if (!$rootScope.$$phase) {
            return $rootScope.$apply(f);
          } else {
            return f();
          }
        };
        setActiveFile = function(id, send) {
          if (session.me.activeFile != null) {
            send({
              t: 'ignoring',
              f: session.me.activeFile
            });
          }
          session.me.activeFile = id;
          if (id != null) {
            return send({
              t: 'looking',
              f: id
            });
          }
        };
        initFile = function(file, send) {
          var adapter, client, nfile, reset;
          nfile = session.openFiles[file.info.id] || {};
          nfile.id = file.info.id;
          nfile.name = file.info.name;
          if (nfile.doc != null) {
            nfile.doc.setValue(file.state);
          } else {
            if (file.info.mimeType === 'text/isabelle') {
              nfile.doc = CodeMirror.Doc(file.state, {
                name: 'isabelle',
                words: idw
              });
            } else {
              nfile.doc = CodeMirror.Doc(file.state, file.info.mimeType || 'text/plain');
            }
            nfile.doc.on("cursorActivity", function(doc) {
              return apply(function() {
                return session.cursor = doc.getCursor();
              });
            });
          }
          client = new Client(file.revision);
          adapter = new CMAdapter(nfile.doc, session.me.color);
          client.applyOperation = adapter.applyOperation;
          reset = function() {
            console.warning('warning', 'emergency resetting ' + nfile.name + ' due to server timeout');
            nfile.$$emergencyResetMode = true;
            send({
              t: 'close',
              id: file.info.id
            });
            return send({
              t: 'open',
              id: file.info.id
            });
          };
          client.sendOperation = function(rev, op) {
            nfile.$$emergencyReset = setTimeout(reset, 1000);
            return send({
              f: nfile.id,
              r: rev,
              o: op.actions
            });
          };
          client.sendAnnotation = function(rev, an, name) {
            return send({
              f: nfile.id,
              r: rev,
              a: an.annotations,
              n: name
            });
          };
          adapter.registerCallbacks({
            change: function(op) {
              return client.applyClient(op);
            },
            annotate: function(a) {
              return client.annotate(a);
            }
          });
          nfile.$ackEdit = function() {
            clearTimeout(nfile.$$emergencyReset);
            return client.serverAckEdit();
          };
          nfile.$ackAnnotation = function() {
            return client.serverAckAnnotation();
          };
          nfile.$apply = function(os) {
            return client.applyServer(os);
          };
          nfile.$syncState = function() {
            return client.syncState();
          };
          nfile.$setColor = function(c) {
            return adapter.setColor(c);
          };
          nfile.$output = {};
          nfile.$gutter = {};
          nfile.$annotate = function(a, u, n) {
            var s, stream, _i, _len, _ref;
            nfile.$output[u] = nfile.$output[u] || {};
            nfile.$output[u][n] = [];
            nfile.$gutter[u] = nfile.$gutter[u] || {};
            nfile.$gutter[u][n] = [];
            nfile.annotations = nfile.annotations || {};
            nfile.annotations[u.id] = nfile.annotations[u.id] || [];
            s = null;
            _ref = nfile.annotations[u.id];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              stream = _ref[_i];
              if (stream.name === n) {
                s = stream;
                break;
              }
            }
            if (s == null) {
              s = {
                show: true,
                name: n
              };
              nfile.annotations[u.id].push(s);
            }
            s.show = true;
            a = client.transformAnnotation(a);
            adapter.applyAnnotation(a, u, n, nfile.$gutter[u][n], nfile.$output[u][n], session.inline);
            return adapter.updateGutter(nfile.$gutter);
          };
          nfile.$addAnnotations = function(u, n, d) {
            var stream, _i, _len, _ref;
            nfile.annotations = nfile.annotations || {};
            nfile.annotations[u] = nfile.annotations[u] || [];
            _ref = nfile.annotations[u];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              stream = _ref[_i];
              if (stream.name === n) {
                stream.description = d;
                return;
              }
            }
            return nfile.annotations[u].push({
              show: false,
              name: n,
              description: d
            });
          };
          nfile.$removeAnnotations = function(u, n) {
            var stream, _i, _len, _ref;
            nfile.annotations = nfile.annotations || {};
            nfile.annotations[u] = nfile.annotations[u] || [];
            _ref = nfile.annotations[u];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              stream = _ref[_i];
              if (stream.name === n) {
                stream.show = false;
                break;
              }
            }
            return adapter.resetAnnotations(u, n);
          };
          if (nfile.$$emergencyResetMode) {
            nfile.$$emergencyResetMode = false;
            console.log('resetted ' + nfile.name);
          }
          return session.openFiles[file.info.id] = nfile;
        };
        getOpenFile = function(id) {
          return session.openFiles[id] || false;
        };
        remove = function(id) {
          var i, s, _i, _len, _ref;
          _ref = session.collaborators;
          for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
            s = _ref[i];
            if (s.id === id) {
              s.active = false;
              return session.collaborators.splice(i, 1);
            }
          }
        };
        update = function(info) {
          var i, k, s, v, _i, _len, _ref;
          _ref = session.collaborators;
          for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
            s = _ref[i];
            if (s.id === info.id) {
              for (k in info) {
                v = info[k];
                session.collaborators[i][k] = v;
              }
              session.collaborators[i].activeFile = info.activeFile;
              return true;
            }
          }
          return session.collaborators.push(info);
        };
        getUser = function(id) {
          var s, _i, _len, _ref;
          _ref = session.collaborators;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            s = _ref[_i];
            if (s.id === id) {
              return s;
            }
          }
          return null;
        };
        url = routes.clide.web.controllers.Projects.session(username, project).webSocketURL();
        return new ActorSocket(url, "" + username + "/" + project + "/session", function(context) {
          return {
            data: session,
            "interface": {
              openFile: function(id) {
                var existing;
                if (id !== session.me.activeFile) {
                  existing = getOpenFile(id);
                  if (existing) {
                    return setActiveFile(id, context.tell);
                  } else {
                    return context.tell({
                      t: 'open',
                      id: id
                    });
                  }
                }
              },
              closeFile: function(id) {
                apply(function() {
                  delete session.openFiles[id];
                  return setActiveFile(null, context.tell);
                });
                return context.tell({
                  t: 'close',
                  id: id
                });
              },
              chat: function(msg) {
                return context.tell({
                  t: 'chat',
                  msg: msg
                });
              },
              invite: function(name) {
                return context.tell({
                  t: 'invite',
                  u: name
                });
              },
              kick: function(id) {
                return context.tell({
                  t: 'kick',
                  s: id
                });
              },
              subscribe: function(file, user, name) {
                return context.tell({
                  t: 'subscribe',
                  f: file,
                  u: user,
                  n: name
                });
              },
              unsubscribe: function(file, user, name) {
                return context.tell({
                  t: 'unsubscribe',
                  f: file,
                  u: user,
                  n: name
                });
              },
              setColor: function(color) {
                var file, key, _ref;
                session.me.color = color;
                _ref = session.openFiles;
                for (key in _ref) {
                  file = _ref[key];
                  if (typeof file.$setColor === "function") {
                    file.$setColor(color);
                  }
                }
                return context.tell({
                  t: 'color',
                  c: color
                });
              },
              hints: function(cm, options) {
                return void 0;
              },
              close: function() {
                var queue;
                queue = [];
                context.tell({
                  t: 'eof'
                });
                return typeof socket !== "undefined" && socket !== null ? socket.close() : void 0;
              }
            },
            preStart: function() {
              session.state = 'connected';
              context.setReceiveTimeout(250);
              context.tell({
                t: 'init'
              });
              return CodeMirror.registerHelper("hint", function() {
                var e;
                e = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
                return {
                  showHint: function() {
                    return console.log('hn');
                  }
                }({
                  getOpenFile: getOpenFile
                });
              });
            },
            receive: function(msg) {
              var f, silence;
              silence = false;
              f = function(msg) {
                var event, user, _i, _j, _len, _ref, _results;
                switch (typeof msg) {
                  case 'number':
                    f = getOpenFile(msg);
                    if (f) {
                      return f.$ackEdit();
                    } else {
                      return log.warning("acknowledge for unknown file " + msg);
                    }
                    break;
                  case 'object':
                    if ((msg.f != null) && (msg.o != null)) {
                      getOpenFile(msg.f).$apply(Operation.fromJSON(msg.o));
                    } else if ((msg.f != null) && (msg.a != null) && ((user = getUser(msg.u)) != null)) {
                      apply(function() {
                        return getOpenFile(msg.f).$annotate(Annotations.fromJSON(msg.a), user, msg.n);
                      });
                    }
                    switch (msg.t) {
                      case 'timeout':
                        return context.tell({
                          t: 'flush',
                          blowup: (function() {
                            _results = [];
                            for (_i = 1; _i <= 1000; _i++){ _results.push(_i); }
                            return _results;
                          }).apply(this)
                        });
                      case 'e':
                        return Toasts.push('danger', msg.c);
                      case 'welcome':
                        context.setReceiveTimeout(null);
                        session.openFiles = {};
                        apply(function() {
                          session.me = msg.info;
                          return session.collaborators = msg.others;
                        });
                        silence = true;
                        _ref = msg.events.reverse();
                        for (_j = 0, _len = _ref.length; _j < _len; _j++) {
                          event = _ref[_j];
                          f(event);
                        }
                        return silence = false;
                      case 'kicked':
                        return apply(function() {
                          return typeof session.kicked === "function" ? session.kicked() : void 0;
                        });
                      case 'opened':
                        return apply(function() {
                          initFile(msg.c, context.tell);
                          return setActiveFile(msg.c.info.id, context.tell);
                        });
                      case 'failed':
                        return Toasts.push("danger", "the initialization of the requested file failed on the server");
                      case 'ao':
                        return apply(function() {
                          return getOpenFile(msg.f).$addAnnotations(msg.u, msg.n, msg.d);
                        });
                      case 'ac':
                        return apply(function() {
                          return getOpenFile(msg.f).$removeAnnotations(msg.u, msg.n);
                        });
                      case 'talk':
                        if (msg.c.s === session.me.id) {
                          msg.c.s = session.me;
                        } else {
                          msg.c.s = getUser(msg.c.s);
                        }
                        session.chat.unshift(msg.c);
                        if (!silence) {
                          return apply(function() {
                            return typeof session.talkback === "function" ? session.talkback(msg.c) : void 0;
                          });
                        }
                        break;
                      case 'close':
                        return console.log('close file acknowledged');
                      case 'session_changed':
                        return apply(function() {
                          return update(msg.c);
                        });
                      case 'session_stopped':
                        return apply(function() {
                          return remove(msg.c.id);
                        });
                      case 'process':
                        f = function() {
                          session.fileStates[msg.c.f] = session.fileStates[msg.c.f] || {};
                          session.fileStates[msg.c.f][msg.c.u] = session.fileStates[msg.c.f][msg.c.u] || {};
                          switch (msg.c.t) {
                            case 'w':
                              return session.fileStates[msg.c.f][msg.c.u].working = true;
                            case 'd':
                              return session.fileStates[msg.c.f][msg.c.u].working = false;
                            case 'l':
                              return session.fileStates[msg.c.f][msg.c.u].looking = true;
                            case 'i':
                              return session.fileStates[msg.c.f][msg.c.u].looking = false;
                          }
                        };
                        if (silence) {
                          return f();
                        } else {
                          return apply(f);
                        }
                    }
                }
              };
              return f(msg);
            }
          };
        });
      };
    };
  });

}).call(this);
