(function() {

  define(['modes/isabelle/defaultWords', 'codemirror'], function(defaultWords) {
    CodeMirror.defineMode("isabelle", function(config, parserConfig) {
      var control, digit, escaped, floating, greek, ident, incomplete, latin, letter, lineComment, longident, nat, num, quasiletter, speciale, sym, symident, tokenAltString, tokenBase, tokenComment, tokenString, tokenVerbatim, typefree, typevar, variable;
      parserConfig = parserConfig || {};
      parserConfig.words = parserConfig.words || defaultWords;
      greek = "(?:\\\\<(?:alpha|beta|gamma|delta|epsilon|zeta|eta|theta|iota|kappa|' +      'mu|nu|xi|pi|rho|sigma|tau|upsilon|phi|chi|psi|omega|Gamma|Delta|Theta|Lambda|Xi|' +      'Pi|Sigma|Upsilon|Phi|Psi|Omega)>)";
      digit = "[0-9]";
      latin = "[a-zA-Z]";
      sym = "[\\!\\#\\$\\%\\&\\*\\+\\-\\/\\<\\=\\>\\?\\@\\^\\_\\|\\~]";
      letter = "(?:" + latin + "|\\\\<" + latin + "{1,2}>|" + greek + "|\\\\<\\^isu[bp]>)";
      quasiletter = "(?:" + letter + "|" + digit + "|\\_|\\')";
      ident = "(?:" + letter + quasiletter + "*)";
      longident = "(?:" + ident + "(?:\\." + ident + ")+)";
      symident = "(?:" + sym + "+|\\\\<" + ident + ">)";
      nat = "(?:" + digit + "+)";
      floating = "(?:-?" + nat + "\\." + nat + ")";
      variable = "(?:\\?" + ident + "(?:\\." + nat + ")?)";
      typefree = "'" + ident;
      typevar = "\\?" + typefree + "(?:\\." + nat + ")";
      greek = RegExp(greek);
      digit = RegExp(digit);
      latin = RegExp(latin);
      sym = RegExp(sym);
      letter = RegExp(letter);
      quasiletter = RegExp(quasiletter);
      ident = RegExp(ident);
      longident = RegExp(longident);
      symident = RegExp(symident);
      nat = RegExp(nat);
      floating = RegExp(floating);
      variable = RegExp(variable);
      typefree = RegExp(typefree);
      typevar = RegExp(typevar);
      num = /\#?-?[0-9]+(?:\.[0-9]+)?/;
      escaped = /\\[\"\\]/;
      speciale = /\\<[A-Za-z]+>/;
      control = /\\<\^[A-Za-z]+>/;
      incomplete = /\\<\^{0,1}[A-Za-z]*>?/;
      lineComment = /--.*/;
      tokenBase = function(stream, state) {
        var ch, type;
        ch = stream.peek();
        if (ch === '{') {
          stream.next();
          if (stream.eat('*')) {
            state.verbatimLevel++;
            state.tokenize = tokenVerbatim;
            return state.tokenize(stream, state);
          } else {
            stream.backUp(1);
          }
        }
        state.command = null;
        if (ch === '"') {
          stream.next();
          state.tokenize = tokenString;
          return "string";
        }
        if (ch === '`') {
          stream.next();
          state.tokenize = tokenAltString;
          return "altstring";
        }
        if (ch === '(') {
          stream.next();
          if (stream.eat('*')) {
            state.commentLevel++;
            state.tokenize = tokenComment;
            return state.tokenize(stream, state);
          } else {
            stream.backUp(1);
          }
        }
        if (stream.match(typefree)) {
          return 'tfree';
        } else if (stream.match(typevar)) {
          return "tvar";
        } else if (stream.match(variable)) {
          return "var";
        } else if (stream.match(longident) || stream.match(ident)) {
          type = parserConfig.words[stream.current()] || "identifier";
          if (type === 'command') {
            type = type + " " + stream.current();
            state.command = stream.current();
          }
          return type;
        } else if (stream.match(symident)) {
          return "symbol";
        } else if (stream.match(control)) {
          return "control";
        } else if (stream.match(incomplete)) {
          return 'incomplete';
        }
        stream.next();
        return null;
      };
      tokenString = function(stream, state) {
        if (stream.eatSpace()) {
          return 'string';
        }
        if (stream.match('\"')) {
          state.tokenize = tokenBase;
          return 'string';
        }
        if (stream.match(escaped)) {
          return 'string';
        }
        if (stream.match(longident)) {
          return 'string longident';
        }
        if (stream.match(ident)) {
          return 'string ident';
        }
        if (stream.match(typefree)) {
          return 'string tfree';
        }
        if (stream.match(typevar)) {
          return 'string tvar';
        }
        if (stream.match(num)) {
          return 'string num';
        }
        if (stream.match(symident)) {
          return 'string symbol';
        }
        if (stream.match(control)) {
          return null;
        }
        if (stream.match(incomplete)) {
          return 'string incomplete';
        }
        stream.next();
        return 'string';
      };
      tokenAltString = function(stream, state) {
        var end, next;
        next = false;
        end = false;
        escaped = false;
        while (((next = stream.next()) != null)) {
          if (next === '`' && !escaped) {
            end = true;
            break;
          }
          escaped = !escaped && next === '\\';
        }
        if (end && !escaped) {
          state.tokenize = tokenBase;
        }
        return 'alt_string';
      };
      tokenComment = function(stream, state) {
        var next, prev;
        prev = null;
        next = null;
        while (state.commentLevel > 0 && ((next = stream.next()) != null)) {
          if (prev === '(' && next === '*') {
            state.commentLevel++;
          }
          if (prev === '*' && next === ')') {
            state.commentLevel--;
          }
          prev = next;
        }
        if (state.commentLevel <= 0) {
          state.tokenize = tokenBase;
        }
        return 'comment';
      };
      tokenVerbatim = function(stream, state) {
        var next, prev;
        prev = null;
        next = null;
        while ((next = stream.next()) != null) {
          if (prev === '*' && next === '}') {
            state.tokenize = tokenBase;
            return 'verbatim' + (state.command != null ? ' ' + state.command : '');
          }
          prev = next;
        }
        return 'verbatim' + (state.command != null ? ' ' + state.command : '');
      };
      return {
        startState: function() {
          return {
            string: null,
            tokenize: tokenBase,
            command: null,
            commentLevel: 0
          };
        },
        blockCommentStart: '(*',
        blockCommentEnd: '*)',
        token: function(stream, state) {
          if (stream.eatSpace()) {
            return null;
          } else {
            return state.tokenize(stream, state);
          }
        }
      };
    });
    return CodeMirror.defineMIME("text/x-isabelle", "isabelle");
  });

}).call(this);
