(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __slice = [].slice;

  define(['collaboration/Operation', 'collaboration/Annotations', 'codemirror'], function(Operation, Annotations, CodeMirror) {
    var CodeMirrorAdapter;
    CodeMirror.commands.getHelp = function(cm) {
      var doc;
      doc = cm.getDoc();
      if ((doc != null) && !doc.somethingSelected()) {
        return CodeMirror.signal(doc, 'getHelp', doc, doc.indexFromPos(doc.getCursor()));
      }
    };
    CodeMirror.keyMap['default']['Ctrl-Space'] = 'getHelp';
    return CodeMirrorAdapter = (function() {

      function CodeMirrorAdapter(doc, color) {
        this.doc = doc;
        this.color = color;
        this.updateGutter = __bind(this.updateGutter, this);

        this.applyAnnotation = __bind(this.applyAnnotation, this);

        this.resetAnnotations = __bind(this.resetAnnotations, this);

        this.annotate = __bind(this.annotate, this);

        this.applyOperation = __bind(this.applyOperation, this);

        this.trigger = __bind(this.trigger, this);

        this.getValue = __bind(this.getValue, this);

        this.onGetHelp = __bind(this.onGetHelp, this);

        this.onSelectionChange = __bind(this.onSelectionChange, this);

        this.onChange = __bind(this.onChange, this);

        this.registerCallbacks = __bind(this.registerCallbacks, this);

        this.detach = __bind(this.detach, this);

        this.setColor = __bind(this.setColor, this);

        this.doc.on("beforeChange", this.onChange);
        this.doc.on("cursorActivity", this.onSelectionChange);
        this.doc.on("getHelp", this.onGetHelp);
        this.annotations = {};
      }

      CodeMirrorAdapter.prototype.setColor = function(color) {
        this.color = color;
        return this.doc.setSelection(this.doc.getCursor('anchor'), this.doc.getCursor('head'));
      };

      CodeMirrorAdapter.prototype.detach = function() {
        return this.doc.off("beforeChange", this.onChange);
      };

      CodeMirrorAdapter.operationFromCodeMirrorChange = function(change, doc) {
        var from, length, to;
        from = doc.indexFromPos(change.from);
        to = doc.indexFromPos(change.to);
        length = to - from;
        return new Operation().retain(from)["delete"](length).insert(change.text.join('\n')).retain(doc.getValue().length - to);
      };

      CodeMirrorAdapter.applyOperationToCodeMirror = function(operation, doc) {
        var a, from, index, to, _i, _len, _ref, _results;
        index = 0;
        _ref = operation.actions;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          a = _ref[_i];
          switch (Operation.actionType(a)) {
            case 'retain':
              _results.push(index += a);
              break;
            case 'insert':
              doc.replaceRange(a, doc.posFromIndex(index));
              _results.push(index += a.length);
              break;
            case 'delete':
              from = doc.posFromIndex(index);
              to = doc.posFromIndex(index - a);
              _results.push(doc.replaceRange("", from, to));
              break;
            default:
              _results.push(void 0);
          }
        }
        return _results;
      };

      CodeMirrorAdapter.annotationFromCodeMirrorSelection = function(doc, color) {
        var anchor, head, length;
        anchor = doc.indexFromPos(doc.getCursor('anchor'));
        head = doc.indexFromPos(doc.getCursor('head'));
        length = doc.getValue().length;
        if (anchor === head) {
          return new Annotations().plain(anchor).annotate(0, {
            'c': ['cursor', color]
          }).plain(length - anchor);
        } else if (anchor < head) {
          return new Annotations().plain(anchor).annotate(head - anchor, {
            'c': ['selection', color]
          }).annotate(0, {
            'c': ['cursor', color]
          }).plain(length - head);
        } else {
          return new Annotations().plain(head).annotate(0, {
            'c': ['cursor', color]
          }).annotate(anchor - head, {
            'c': ['selection', color]
          }).plain(length - anchor);
        }
      };

      CodeMirrorAdapter.prototype.registerCallbacks = function(cb) {
        return this.callbacks = cb;
      };

      CodeMirrorAdapter.prototype.onChange = function(doc, change) {
        if (!this.silent) {
          return this.trigger("change", CodeMirrorAdapter.operationFromCodeMirrorChange(change, doc));
        }
      };

      CodeMirrorAdapter.prototype.onSelectionChange = function(cm) {
        if (!this.silent) {
          return this.trigger("annotate", CodeMirrorAdapter.annotationFromCodeMirrorSelection(this.doc, this.color));
        }
      };

      CodeMirrorAdapter.prototype.onGetHelp = function(doc, index) {
        var annotation, key;
        key = Math.random().toString(36).substr(2);
        annotation = new Annotations().plain(index).annotate(0, {
          'c': ['cursor', this.color],
          'h': [key]
        }).plain(doc.getValue().length - index);
        return this.trigger('annotate', annotation);
      };

      CodeMirrorAdapter.prototype.getValue = function() {
        return this.doc.getValue();
      };

      CodeMirrorAdapter.prototype.trigger = function() {
        var action, args, event;
        event = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
        action = this.callbacks && this.callbacks[event];
        if (action) {
          return action.apply(this, args);
        }
      };

      CodeMirrorAdapter.prototype.applyOperation = function(operation) {
        var cm,
          _this = this;
        this.silent = true;
        cm = this.doc.getEditor();
        if (cm != null) {
          cm.operation(function() {
            return CodeMirrorAdapter.applyOperationToCodeMirror(operation, _this.doc);
          });
        } else {
          CodeMirrorAdapter.applyOperationToCodeMirror(operation, this.doc);
        }
        return this.silent = false;
      };

      CodeMirrorAdapter.prototype.annotate = function(c, user, name, gutter, output, inline, from, to) {
        var bookmark, classes, cm, e, i, line, marker, tooltip, w, widget, _i, _j, _k, _l, _len, _len1, _len2, _len3, _ref, _ref1, _ref2, _ref3, _ref4;
        classes = (_ref = c.c) != null ? _ref.join(' ') : void 0;
        widget = function(type, cs, content) {
          var w;
          w = angular.element("<" + type + " class='" + classes + " " + cs + "'>" + content + "</" + type + ">")[0];
          if (c.t) {
            w.title = c.t;
          }
          return w;
        };
        line = to != null ? to.line : from.line;
        if (c.e != null) {
          output.push({
            from: from,
            to: to || from,
            type: 'error',
            content: c.e
          });
          if (inline.errors && (cm = this.doc.getEditor())) {
            _ref1 = c.e;
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
              e = _ref1[_i];
              this.annotations[user.id][name].push(cm.addLineWidget(line, widget('div', 'outputWidget error', e)));
            }
          }
        }
        if (c.w != null) {
          output.push({
            from: from,
            to: to || from,
            type: 'warning',
            content: c.w
          });
          if (inline.warnings && (cm = this.doc.getEditor())) {
            _ref2 = c.w;
            for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
              w = _ref2[_j];
              this.annotations[user.id][name].push(cm.addLineWidget(line, widget('div', 'outputWidget warning', w)));
            }
          }
        }
        if (c.i != null) {
          output.push({
            from: from,
            to: to || from,
            type: 'info',
            content: c.i
          });
          if (inline.output && (cm = this.doc.getEditor())) {
            _ref3 = c.i;
            for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
              i = _ref3[_k];
              this.annotations[user.id][name].push(cm.addLineWidget(line, widget('div', 'outputWidget info', i)));
            }
          }
        }
        if (c.o != null) {
          output.push({
            from: from,
            to: to || from,
            type: 'info',
            content: c.o
          });
          if (inline.output && (cm = this.doc.getEditor())) {
            _ref4 = c.o;
            for (_l = 0, _len3 = _ref4.length; _l < _len3; _l++) {
              i = _ref4[_l];
              this.annotations[user.id][name].push(cm.addLineWidget(line, widget('div', 'outputWidget info', i)));
            }
          }
        }
        if (c.ls != null) {
          gutter.push({
            line: from.line,
            type: 'progress',
            state: c.ls
          });
        }
        if (classes != null) {
          if ((to != null) && (c.s != null)) {
            marker = this.doc.markText(from, to, {
              replacedWith: widget('span', classes, c.s),
              handleMouseEvents: true
            });
            return this.annotations[user.id][name].push(marker);
          } else if (to != null) {
            marker = this.doc.markText(from, to, {
              className: classes,
              title: c.t
            });
            return this.annotations[user.id][name].push(marker);
          } else {
            bookmark = this.doc.setBookmark(from, {
              widget: widget('span', '', ''),
              insertLeft: true
            });
            return this.annotations[user.id][name].push(bookmark);
          }
        } else if (c["if"]) {
          tooltip = this.doc.markText(from, to, {
            title: c.t
          });
          return this.annotations[user.id][name].push(tooltip);
        }
      };

      CodeMirrorAdapter.registerMouseEvents = function(doc) {};

      CodeMirrorAdapter.prototype.resetAnnotations = function(user, name) {
        var existing, marker, _i, _len;
        if (user != null) {
          if (this.annotations[user] == null) {
            this.annotations[user] = {};
          }
          existing = this.annotations[user][name];
          if (existing != null) {
            for (_i = 0, _len = existing.length; _i < _len; _i++) {
              marker = existing[_i];
              marker.clear();
            }
          }
          return this.annotations[user][name] = [];
        }
      };

      CodeMirrorAdapter.prototype.applyAnnotation = function(annotation, user, name, gutter, output, inline) {
        var cm, work,
          _this = this;
        cm = this.doc.getEditor();
        work = function() {
          var a, from, index, to, _i, _len, _ref, _results;
          if (user != null) {
            _this.resetAnnotations(user.id, name);
          }
          index = 0;
          _ref = annotation.annotations;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            a = _ref[_i];
            if (Annotations.isPlain(a)) {
              _results.push(index += a);
            } else {
              from = _this.doc.posFromIndex(index);
              if (a.l > 0) {
                index += a.l;
                to = _this.doc.posFromIndex(index);
                _results.push(_this.annotate(a.c, user, name, gutter, output, inline, from, to));
              } else {
                _results.push(_this.annotate(a.c, user, name, gutter, output, inline, from));
              }
            }
          }
          return _results;
        };
        if (cm != null) {
          return cm.operation(function() {
            return work();
          });
        } else {
          return work();
        }
      };

      CodeMirrorAdapter.prototype.updateGutter = function(output) {
        var cm,
          _this = this;
        if (cm = this.doc.getEditor()) {
          return cm.operation(function() {
            var c, n, s, span, u, v, vs, _results;
            cm.clearGutter('progress-gutter');
            _results = [];
            for (u in output) {
              c = output[u];
              _results.push((function() {
                var _results1;
                _results1 = [];
                for (n in c) {
                  vs = c[n];
                  _results1.push((function() {
                    var _i, _j, _len, _len1, _ref, _results2;
                    _results2 = [];
                    for (_i = 0, _len = vs.length; _i < _len; _i++) {
                      v = vs[_i];
                      if (v.type === 'progress') {
                        span = document.createElement('div');
                        _ref = v.state;
                        for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
                          s = _ref[_j];
                          span.classList.add("gutter-state-" + s);
                        }
                        _results2.push(cm.setGutterMarker(v.line, 'progress-gutter', span));
                      } else {
                        _results2.push(void 0);
                      }
                    }
                    return _results2;
                  })());
                }
                return _results1;
              })());
            }
            return _results;
          });
        }
      };

      return CodeMirrorAdapter;

    }).call(this);
  });

}).call(this);
