
/* @service services:Projects
*/


(function() {

  define(['routes'], function(routes) {
    return function($q, $http) {
      var del, get, pc, put;
      pc = routes.clide.web.controllers.Projects;
      get = function(username, project) {
        var result;
        result = $q.defer();
        if (project != null) {
          $http.get(pc.details(username, project).url).success(result.resolve).error(result.reject);
        } else {
          $http.get(pc.index(username).url).success(result.resolve).error(result.reject);
        }
        return result.promise;
      };
      put = function(username, project) {
        var result;
        result = $q.defer();
        $http.put(pc.put(username).url, project).success(result.resolve).error(result.reject);
        return result.promise;
      };
      del = function(username, project) {
        var result;
        result = $q.defer();
        $http["delete"](pc["delete"](username, project.name).url).success(result.resolve).error(result.reject);
        return result.promise;
      };
      return {
        get: get,
        put: put,
        "delete": del
      };
    };
  });

}).call(this);
