
/* @controller controllers:LoginController
*/


(function() {

  define(['routes'], function(routes) {
    return function($scope, $location, Auth, Toasts) {
      $scope.data = {
        username: null,
        password: null,
        staySignedIn: true
      };
      return $scope.login = function() {
        $scope.error = {};
        return Auth.login($scope.data, {
          success: function() {
            $location.path("/" + Auth.user.username + "/backstage");
            return Toasts.push('success', "You have been successfully logged in as " + Auth.user.username + "!");
          },
          error: function(data, status) {
            switch (status) {
              case 401:
                return $scope.error = data;
              case 404:
                return $scope.error[''] = 'the server did not respond';
              default:
                return $scope.error[''] = 'sorry, something is broken...';
            }
          }
        });
      };
    };
  });

}).call(this);
