
/* @service services:Dialog
*/


(function() {

  define(function() {
    return function() {
      var next, push, queue, state;
      queue = [];
      state = {
        current: null
      };
      next = function(action) {
        var done, q, res, result, _i, _len, _ref;
        done = function() {
          return state.current = queue.splice(0, 1)[0];
        };
        if (state.current != null) {
          result = {};
          state.current.wait = false;
          if (action) {
            if (state.current.queries != null) {
              _ref = state.current.queries;
              for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                q = _ref[_i];
                result[q.name] = q.value;
              }
            }
            res = action(result);
            switch (typeof res) {
              case 'function':
                done();
                return res();
              case 'object':
                if (res.then != null) {
                  return res.then(done, function(error) {
                    console.log(error);
                    return state.current.error = error;
                  });
                } else {
                  return done();
                }
                break;
              case 'boolean':
                if (res) {
                  return done();
                }
                break;
              case 'string':
                return state.current.error = res;
              default:
                return done();
            }
          }
        }
      };
      push = function(config) {
        var _ref;
        if (state.current != null) {
          queue.unshift(state.current);
          state.current = null;
        }
        config.queries = (_ref = config.queries) != null ? _ref.map(function(q) {
          switch (typeof q) {
            case 'string':
              return {
                type: 'text',
                text: q + ':',
                name: q
              };
            case 'object':
              q.type = q.type || 'text';
              q.text = q.text || q.name + ':';
              return q;
          }
        }) : void 0;
        config.buttons = config.buttons || ['Ok'];
        config.buttons = config.buttons.map(function(button) {
          var action, name;
          switch (typeof button) {
            case 'string':
              return {
                text: button,
                action: function(result) {
                  return typeof config.done === "function" ? config.done(button, result) : void 0;
                }
              };
            case 'object':
              if (button.action == null) {
                for (name in button) {
                  action = button[name];
                  button.text = name;
                  button.action = action;
                }
              }
              return button;
          }
        });
        if (state.current != null) {
          queue.unshift(state.current);
        }
        return state.current = config;
      };
      state.push = push;
      state.next = next;
      return state;
    };
  });

}).call(this);
