(defproject szew/repl "0.2.0"

  :description "Simple Clojure REPL seeder."

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.9.0"]
                 ;; Environment variables in Clojure
                 [environ "1.1.0"]
                 ;; For vim-fireplace and rest.
                 ;[org.clojure/tools.nrepl "0.2.13"]
                 [nrepl "0.4.4"]
                 ;; Logging infrastructure!
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [org.slf4j/slf4j-api "1.7.25"]
                 [org.slf4j/log4j-over-slf4j "1.7.25"]
                 [org.clojure/tools.logging "0.4.1"]]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]]
                   :plugins [[lein-auto "0.1.3"]
                             [lein-codox "0.10.1"]
                             [lein-environ "1.1.0"]]
                   :source-paths ["dev"]
                   :env {}}
             :1.10 {:dependencies [[org.clojure/clojure "1.10.0-alpha6"]]}
             :uberjar {:aot :all
                       :env {}}}

  :plugins [[lein-environ "1.1.0"]]

  :main szew.repl

  :aot [clojure.tools.logging.impl ;; aot or die!!!1
        szew.repl]

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/repl"}
          :namespaces [#"^szew\.repl.*$"]
          :doc-files ["CHANGELOG.md"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-repl/src/"
                            "cc17c5ecc7b41ea68ff386b9ff8352d4cab2fbcc" ;; 0.1.0
                            ;"1d990cf4ce4e68b301c864b7b13dae23fbbd1e24" ;; initial
                            "/{filepath}#{basename}-{line}")}

  :repl-options {:timeout 120000
                 :init-ns user}

  ;; file masks for lein-auto
  :auto {:default {:file-pattern #"\.(clj|cljs|cljc)$"}}

  ;; doing the n33dful
  :aliases {"test!" ["do" "clean," "compile," "test"]
            "pack!" ["do" "clean," "compile," "uberjar"]
            ;"prep!" ["do" "test!," "marg"]
            "autotest" ["auto" "test!"]}

  ;:global-vars {*warn-on-reflection* true}

  :jar-exclusions [#"logback-test\.xml"]
  :omit-source false
  :target-path "target/"
  )
