(defproject szew/io "0.5.4"

  :description "File to data and back."
  :url "https://bitbucket.org/spottr/szew-io"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.11.1"]
                 ;; Proper CSV handling, combat proven:
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; There is no life without XML
                 [org.clojure/data.xml "0.0.8"]
                 ;; Zippers, mainly because XML
                 [org.clojure/data.zip "1.0.0"]
                 ;; Literally headers.
                 [camel-snake-kebab "0.4.2"]]

  :profiles {:dev {:dependencies [[criterium "0.4.6"]
                                  [org.clojure/test.check "1.1.1"]
                                  [eftest "0.5.9"]
                                  [orchestra "2021.01.01-1"]
                                  [hashp "0.2.1"]]
                   :plugins [[lein-codox "0.10.7"]]
                   :source-paths ["dev"]
                   ;; opts for Java 9+ and data.xml
                   ;:jvm-opts ["--illegal-access=debug"]
                   ;:jvm-opts ["--illegal-access=deny"]
                   :jvm-opts ["--illegal-access=deny"]}
             :codox {:jvm-opts ["--illegal-access=warn"]}
             ;:test {:jvm-opts ["--illegal-access=deny"]}
             :1.10 {:dependencies [[org.clojure/clojure "1.10.3"]]
                    :jvm-opts ["--illegal-access=deny"]}
             #_#_:1.12 {:dependencies [[org.clojure/clojure "1.12.0-alpha1"]]
                    :jvm-opts ["--illegal-access=deny"]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* true
                *assert* true}

  :repl-options {:init-ns user
                 :timeout 380000}
  :aot :all

  :codox {:project {:name "szew/io"}
          :namespaces [#"^szew\.io.*$"]
          :doc-files ["CHANGELOG.md"]
          ;; source links here
          :source-uri ~(str "https://bitbucket.org/spottr/szew-io/src/"
                            "f43e439968d572b78aa8e9d1112e26331e0fec0d" ;; 0.5.3
                            "/{filepath}#{basename}-{line}")})
