(defproject szew/io "0.3.6"

  :description "File to data and back."
  :url "https://bitbucket.org/spottr/szew-io"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.0"]
                 ;; Proper CSV handling, combat proven:
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; There is no life without XML
                 [org.clojure/data.xml "0.0.8"]
                 ;; Zippers, mainly because XML
                 [org.clojure/data.zip "0.1.3"]
                 ;; Literally headrs.
                 [camel-snake-kebab "0.4.0"]]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]
                                  [org.clojure/test.check "0.9.0"]
                                  [eftest "0.5.7"]
                                  [orchestra "2019.02.06-1"]]
                   :plugins [[lein-codox "0.10.6"]]
                   :source-paths ["dev"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* true
                *assert* true}

  :aot [szew.io]

  :jar-name "szew-io.jar"
  :uberjar-name "szew-io-fat.jar"

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/io"}
          :namespaces [#"^szew\.io.*$"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-io/src/"
                            "51945f520a7aa3399061df4766093989ad7c4ecf" ;; 0.3.5
                            "/{filepath}#{basename}-{line}")})
