(defproject szew/h2 "0.3.2"

  :description "Clojure wrapper for H2 database."
  :url "https://bitbucket.org/spottr/szew-h2"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies []

  :profiles {:dev      {:dependencies [[criterium "0.4.5"]
                                       [orchestra "2019.02.06-1"]]
                        :eftest {:thread-count 2}
                        :plugins [[lein-codox "0.10.6"]]
                        :source-paths ["dev"]}
             :provided {:dependencies [[org.clojure/clojure "1.10.1"]
                                       ;; last stable = 1.3.176
                                       [com.h2database/h2 "1.4.200"]
                                       ;; The must: database interop
                                       [org.clojure/java.jdbc "0.7.11"]
                                       ;; Next gen database interop
                                       [seancorfield/next.jdbc "1.0.13"]]}
             :1.9      {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :1.10.2   {:dependencies [[org.clojure/clojure "1.10.2-alpha1"]]}
             :uberjar  {:aot :all}}

  :global-vars {;*warn-on-reflection* true
                ;*assert* true
                }

  :aot [szew.h2
        szew.h2.util
        szew.h2.server]

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/h2"}
          :namespaces [#"^(szew\.h2|szew\.h2\.[juns].+)$"]
          :source-uri ~(str "https://bitbucket.org/spottr/szew-h2/src/"
                            "94686f634a6a43c42e5d03fad5ff51b5b034b499" ;; 0.3.1
                            "/{filepath}#{basename}-{line}")}
  )

