(defproject szew/h2 "0.2.1"

  :description "Clojure wrapper for H2 database."
  :url "https://bitbucket.org/spottr/szew-h2"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.0"]
                 ;; The must: database interop
                 [org.clojure/java.jdbc "0.7.9"]
                 ;; Embedded database engine, BETA, last stable = 1.3.176
                 [com.h2database/h2 "1.4.198"]]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]
                                  [orchestra "2019.02.06-1"]]
                   :plugins [[lein-codox "0.10.6"]]
                   :source-paths ["dev"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :uberjar {:aot :all}}

  :global-vars {;*warn-on-reflection* true
                *assert* true}

  :aot [szew.h2]

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/h2"}
          :namespaces [#"^szew\.h2$"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-h2/src/"
                            "86cf086d6771c2be3aef1a4364b8438d19c72388" ;; 0.2.0
                            "/{filepath}#{basename}-{line}")}
  )

