(defproject szew/h2 "0.1.0"

  :description "Clojure wrapper for H2 database."
  :url "https://bitbucket.org/spottr/szew-h2"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.8.0"]
                 ;; The must: database interop
                 [org.clojure/java.jdbc "0.6.1"]
                 ;; Embedded database engine, BETA, last stable = 1.3.176
                 [com.h2database/h2 "1.4.192"]]

  :profiles {:dev {:dependencies [[criterium "0.4.4"]]
                   :plugins [[lein-codox "0.10.0"]]
                   :source-paths ["dev"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0-alpha13"]]}
             :uberjar {:aot :all}}

  :global-vars {*warn-on-reflection* true
                *assert* true}

  :aot [szew.h2]

  :jar-name "szew-h2.jar"
  :uberjar-name "szew-h2-fat.jar"

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/h2"}
          :namespaces [#"^szew\.h2\..*$"]
          ;; that was fun:
          :source-uri ~(str "https://bitbucket.org/spottr/szew-h2/src/"
                            "not yet" ;; initial
                            "/{filepath}#{basename}-{line}")}
  )

; vim:tw=80 cc=+1 ts=2 sw=2 et ai

