(defproject szew/fi "0.3.4"

  :description "Index and compare file trees."
  :url "https://bitbucket.org/spottr/szew-fi"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.2-alpha1"]
                 [org.clojure/core.async "1.2.603"]
                 ;; Szew stuff
                 [szew/io "0.4.0" :exclusions [orc.clojure/clojure]]
                 [szew/h2 "0.3.2"]
                 [szew/repl "0.3.3"]
                 ;; Integrant
                 [integrant "0.8.0"]
                 ;; diff report writer
                 [hiccup "1.0.5"]
                 ;; diffing is a solved problem
                 [com.googlecode.java-diff-utils/diffutils "1.3.0"]
                 ;; Logging infrastructure!
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [org.slf4j/slf4j-api "1.7.30"]
                 [org.slf4j/log4j-over-slf4j "1.7.30"]
                 [org.clojure/tools.logging "1.1.0"]
                 ;; Environment variables in Clojure
                 [environ "1.2.0"]
                 ;; SQL stuffs
                 [org.clojure/java.jdbc "0.7.11"]
                 [com.h2database/h2 "1.4.200"]
                 [com.layerware/hugsql "0.5.1"]]

  :profiles {:dev {:dependencies [[criterium "0.4.5"]]
                   :plugins [[lein-codox "0.10.6"]]
                   :source-paths ["dev"]}
             :1.9 {:dependencies [[org.clojure/clojure "1.9.0"]]}
             :uberjar {:aot :all
                       :jvm-opts ["-Dclojure.compiler.direct-linking=true"]}}

  ;:global-vars {*warn-on-reflection* false
  ;              *assert* true}

  :aot [clojure.tools.logging.impl ;; aot or die!!!11
        szew.fi.diff
        szew.fi.entry
        szew.fi.index
        szew.fi]

  :main szew.repl

  :repl-options {:init-ns user
                 :init    (binding [*compile-files* true]
                            (require 'user :reload-all))}

  :codox {:project {:name "szew/fi"}
          :namespaces [#"^szew\.fi.*$"]
          ;; that was fun:
          :source-uri
          ~(str "https://bitbucket.org/spottr/szew-fi/src/"
                "f8be24cae5842fda7bae7d95bce7df680e747ad0" ;; 0.3.3
                "/{filepath}#{basename}-{line}")}

  :jar-exclusions [#"logback-test\.xml"]

  :jvm-opts [])

