(defproject szew/essbase "0.3.3"

  :description "Consume various files produced by Essbase."
  :url "https://bitbucket.org/spottr/szew-essbase"

  :license {:name "MIT Public License"
            :distribution :repo
            :comments "LICENSE file in project root directory."}

  :dependencies [[org.clojure/clojure "1.10.3"]
                 ;; Basic szew/io library.
                 [szew/io "0.5.3" :exclusions [orc.clojure/clojure]]
                 ;; Proper CSV handling, combat proven.
                 [clojure-csv/clojure-csv "2.0.2"]
                 ;; Date and Time manipulation.
                 [clojure.java-time "0.3.3"]
                 ;; Proper names and stuff.
                 [camel-snake-kebab "0.4.2"]]

  :profiles {:dev    {:dependencies [[criterium "0.4.6"]
                                     [orchestra "2021.01.01-1"]
                                     [eftest "0.5.9"]]
                      :plugins [[lein-codox "0.10.7"]]
                      :source-paths ["dev/src"]
                      :eastwood {:exclude-linters [:def-in-def :deprecations]
                                 :debug [:time]}
                      #_#_:jvm-opts ["--illegal-access=debug"]
                      :jvm-opts ["--illegal-access=warn"] ;; codox
                      #_#_:jvm-opts ["--illegal-access=deny"]}
             :1.9     {:dependencies [[org.clojure/clojure "1.9.0"]]
                       :jvm-opts ["--illegal-access=warn"]}
             :1.11    {:dependencies [[org.clojure/clojure "1.11.0-alpha1"]]}
             :uberjar {:aot :all
                       :jvm-opts ["--illegal-access=deny"]}}

  :global-vars {*warn-on-reflection* true
                *assert* false}

  :aot :all

  :codox {;:metadata {:doc/format :markdown}
          :project {:name "szew/essbase"}
          :namespaces [#"^szew\.essbase\.\w+$"]
          ;; that was fun:
          :source-uri
          ~(str "https://bitbucket.org/spottr/szew-essbase/src/"
                "2d08b4187c0c44b7c89f30063cf0609f1f1d4a92" ; 0.3.3
                "/{filepath}#{basename}-{line}")})
