# szew/essbase

Consume various files produced by Essbase.

[![szew/essbase](https://clojars.org/szew/essbase/latest-version.svg)](https://clojars.org/szew/essbase)

[API Codox][1]

## Why

I've been dogfooding my private Clo*j*ure toolbox (named `szew`) since 2012.

Splitting out and releasing non-proprietary parts.

### What's here

Namespace breakdown:

* `szew.essbase.aso`  -- ASO data export
* `szew.essbase.bso`  -- BSO data export
* `szew.essbase.cols` -- Column export
* `szew.essbase.logs` -- Application logs and MaxL spools
* `szew.essbase.otl`  -- Outline XML export processing
* `szew.essbase.txl`  -- BSO transaction logs (alg+atx)

Processing is based on contracts established by `szew.io`, namely `szew.io/in!`
protocol method provided there.

## Usage

Like all the other `szew` pieces this library is REPL workflow oriented and
with a bit of scripting in mind.

```clojure
(ns dev
  (:require [clojure.core :refer :all]
            [szew.io :as io]
            [szew.essbase.otl :as ess.otl]
            [szew.essbase.txl :as ess.txl]
            [szew.essbase.bso :as ess.bso]
            [szew.essbase.logs :as ess.logs]))

;; Outline XML export

(let [otl "datasets/sample_basic.xml"]

  (def light-dimensions
    (io/in! (io/xml {:processor (comp vec ess.otl/list-dimensions)})
            otl))

  (def full-dimensions
    (io/in! (io/xml {:processor (comp vec ess.otl/extract-dimensions)})
            otl))

  (def full-lut (io/in! (io/xml {:processor ess.otl/member-lut}) otl))

  (def data-lut (io/in! (io/xml {:processor ess.otl/data-member-lut}) otl))

  (def lut-pkg (ess.otl/lut-package otl)))

;; BSO level 0 export

(let [bso "datasets/sample_basic_level0.txt"
      tnc (fn [[c _]]
            (and (= "Texas" (c "Market")) (= "COGS" (c "Measures"))))]

  (def b-cells
    (io/in! (ess.bso/cells {:dim-count (-> data-lut meta :data-dims)
                            :m->d data-lut
                            :processor (partial filterv tnc)})
            bso))

  ;; alternatively
  (def b-cells-alt
    (io/in! (ess.bso/cells (assoc lut-pkg :processor (partial filterv tnc)))
            bso)))

;; SSAudit files

(let [p (comp ess.txl/printable
              (partial filterv (ess.txl/user-matches? #"johny")))
      alg "datasets/sample.alg"
      atx "datasets/sample.atx"]

  (def txl (io/in! (ess.txl/tx-log {:processor p}) {:alg alg :atx atx})))

;; MaxL spool

(def spools (io/in! (ess.logs/maxl-spool {:processor vec, :column-width 256})
                    "datasets/maxl-output.log"))
```

## License

Copyright © 2012-2017 Sławek Gwizdowski

MIT License, text can be found in the LICENSE file.

[1]: http://spottr.bitbucket.io/szew-essbase/latest/

