// Compiled by ClojureScript 1.9.542 {}
goog.provide('timi.client.time.form');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('om.core');
goog.require('om.dom');
goog.require('time.core');
goog.require('timi.client.actions');
goog.require('timi.client.logging');
goog.require('timi.client.time.state');
goog.require('timi.client.util');
timi.client.time.form.active_errors = (function timi$client$time$form$active_errors(form){
return cljs.core.seq.call(null,(cljs.core.truth_(timi.client.time.state.form_submitted_QMARK_.call(null,form))?timi.client.time.state.form_validate_form.call(null,form):null));
});
timi.client.time.form.summary_errors = (function timi$client$time$form$summary_errors(form){
return cljs.core.seq.call(null,(cljs.core.truth_(timi.client.time.state.form_submitted_QMARK_.call(null,form))?timi.client.time.state.form_validate_form.call(null,timi.client.time.state.form_form_at_submit_time.call(null,form)):null));
});
timi.client.time.form.on_form_submit = (function timi$client$time$form$on_form_submit(form,on_error,event){
var errors = timi.client.time.state.form_validate_form.call(null,form);
if(cljs.core.seq.call(null,errors)){
event.preventDefault();

return on_error.call(null,form);
} else {
return null;
}
});
timi.client.time.form.datepicker = (function timi$client$time$form$datepicker(data,owner){
var get_elements = (function (){
var el = om.core.get_node.call(null,owner,"element");
var $el = $(el);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"$input-element","$input-element",1071922091),$el.find(".datepicker-input"),new cljs.core.Keyword(null,"$show-btn","$show-btn",-1316241264),$el.find(".datepicker-show-btn")], null);
});
if(typeof timi.client.time.form.t_timi$client$time$form45660 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
timi.client.time.form.t_timi$client$time$form45660 = (function (data,owner,get_elements,meta45661){
this.data = data;
this.owner = owner;
this.get_elements = get_elements;
this.meta45661 = meta45661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
timi.client.time.form.t_timi$client$time$form45660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (get_elements){
return (function (_45662,meta45661__$1){
var self__ = this;
var _45662__$1 = this;
return (new timi.client.time.form.t_timi$client$time$form45660(self__.data,self__.owner,self__.get_elements,meta45661__$1));
});})(get_elements))
;

timi.client.time.form.t_timi$client$time$form45660.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (get_elements){
return (function (_45662){
var self__ = this;
var _45662__$1 = this;
return self__.meta45661;
});})(get_elements))
;

timi.client.time.form.t_timi$client$time$form45660.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

timi.client.time.form.t_timi$client$time$form45660.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (get_elements){
return (function (_){
var self__ = this;
var ___$1 = this;
var map__45663 = self__.get_elements.call(null);
var map__45663__$1 = ((((!((map__45663 == null)))?((((map__45663.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45663.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45663):map__45663);
var $input_element = cljs.core.get.call(null,map__45663__$1,new cljs.core.Keyword(null,"$input-element","$input-element",1071922091));
var $show_btn = cljs.core.get.call(null,map__45663__$1,new cljs.core.Keyword(null,"$show-btn","$show-btn",-1316241264));
$input_element.datepicker(({"todayBtn": "linked", "todayHighlight": true, "language": "nl", "format": "yyyy-mm-dd", "autoclose": true}));

$input_element.datepicker().on("changeDate",((function (map__45663,map__45663__$1,$input_element,$show_btn,___$1,get_elements){
return (function (event){
var instant = JSJoda.Instant.ofEpochMilli(event.date.getTime());
var new_date = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSJoda.LocalDate.ofInstant(instant))].join('');
return new cljs.core.Keyword(null,"onChangeDate","onChangeDate",-1769286481).cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.identity).call(null,new_date);
});})(map__45663,map__45663__$1,$input_element,$show_btn,___$1,get_elements))
);

return $show_btn.on("click",((function (map__45663,map__45663__$1,$input_element,$show_btn,___$1,get_elements){
return (function (){
return $input_element.datepicker("show");
});})(map__45663,map__45663__$1,$input_element,$show_btn,___$1,get_elements))
);
});})(get_elements))
;

timi.client.time.form.t_timi$client$time$form45660.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

timi.client.time.form.t_timi$client$time$form45660.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (get_elements){
return (function (_){
var self__ = this;
var ___$1 = this;
var map__45665 = self__.get_elements.call(null);
var map__45665__$1 = ((((!((map__45665 == null)))?((((map__45665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45665.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45665):map__45665);
var $input_element = cljs.core.get.call(null,map__45665__$1,new cljs.core.Keyword(null,"$input-element","$input-element",1071922091));
var $show_btn = cljs.core.get.call(null,map__45665__$1,new cljs.core.Keyword(null,"$show-btn","$show-btn",-1316241264));
$input_element.datepicker("destroy");

return $show_btn.off();
});})(get_elements))
;

timi.client.time.form.t_timi$client$time$form45660.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

timi.client.time.form.t_timi$client$time$form45660.prototype.om$core$IRender$render$arity$1 = ((function (get_elements){
return (function (_){
var self__ = this;
var ___$1 = this;
return React.DOM.div(({"className": "input-group input-group-datepicker", "ref": "element"}),om.dom.input.call(null,({"className": "form-control datepicker-input", "type": "text", "value": new cljs.core.Keyword(null,"selected-date","selected-date",-1397749548).cljs$core$IFn$_invoke$arity$1(self__.data), "name": new cljs.core.Keyword(null,"input-name","input-name",323608185).cljs$core$IFn$_invoke$arity$1(self__.data), "readOnly": true})),React.DOM.span(({"className": "input-group-addon datepicker-show-btn"}),React.DOM.i(({"className": "glyphicon glyphicon-calendar"}))));
});})(get_elements))
;

timi.client.time.form.t_timi$client$time$form45660.getBasis = ((function (get_elements){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"get-elements","get-elements",-157481681,null),new cljs.core.Symbol(null,"meta45661","meta45661",-1508462376,null)], null);
});})(get_elements))
;

timi.client.time.form.t_timi$client$time$form45660.cljs$lang$type = true;

timi.client.time.form.t_timi$client$time$form45660.cljs$lang$ctorStr = "timi.client.time.form/t_timi$client$time$form45660";

timi.client.time.form.t_timi$client$time$form45660.cljs$lang$ctorPrWriter = ((function (get_elements){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"timi.client.time.form/t_timi$client$time$form45660");
});})(get_elements))
;

timi.client.time.form.__GT_t_timi$client$time$form45660 = ((function (get_elements){
return (function timi$client$time$form$datepicker_$___GT_t_timi$client$time$form45660(data__$1,owner__$1,get_elements__$1,meta45661){
return (new timi.client.time.form.t_timi$client$time$form45660(data__$1,owner__$1,get_elements__$1,meta45661));
});})(get_elements))
;

}

return (new timi.client.time.form.t_timi$client$time$form45660(data,owner,get_elements,cljs.core.PersistentArrayMap.EMPTY));
});
timi.client.time.form.validation_summary = (function timi$client$time$form$validation_summary(form){
var summary_errors = timi.client.time.form.summary_errors.call(null,form);
return React.DOM.div(({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("alert entry-form-errors"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(timi.client.time.form.active_errors.call(null,form))?" alert-danger":" alert-success")),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(summary_errors)?" entry-form-errors-has-errors":null))].join('')}),"There is a problem with one or more fields in the form, please correct them:",React.DOM.ul(({"className": "entry-form-errors-list-container"}),cljs.core.map.call(null,((function (summary_errors){
return (function (p1__45667_SHARP_){
return React.DOM.li(({"key": cljs.core.get.call(null,p1__45667_SHARP_,(0))}),React.DOM.strong(null,cljs.core.get.call(null,p1__45667_SHARP_,(0))),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,p1__45667_SHARP_,(1)))].join(''));
});})(summary_errors))
,summary_errors)));
});
timi.client.time.form.time_input = (function timi$client$time$form$time_input(id,value,on_change){
return om.dom.input.call(null,({"placeholder": "Time", "name": id, "autoComplete": "off", "value": value, "type": "text", "onBlur": (function (p1__45670_SHARP_){
return on_change.call(null,time.core.expand_time.call(null,p1__45670_SHARP_.target.value));
}), "className": "form-control time-entry-input", "size": "5", "id": id, "maxLength": "5", "onKeyDown": (function (p1__45671_SHARP_){
if(cljs.core._EQ_.call(null,p1__45671_SHARP_.keyCode,(13))){
return on_change.call(null,time.core.expand_time.call(null,p1__45671_SHARP_.target.value));
} else {
return null;
}
}), "onChange": (function (p1__45669_SHARP_){
return on_change.call(null,p1__45669_SHARP_.target.value);
}), "onFocus": (function (p1__45668_SHARP_){
return p1__45668_SHARP_.target.select();
})}));
});
timi.client.time.form.date_time_entry_row = (function timi$client$time$form$date_time_entry_row(dispatch_BANG_,form){
var failed_fields = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,timi.client.time.form.active_errors.call(null,form));
var start_time_error_QMARK_ = failed_fields.call(null,"Start time");
var end_time_error_QMARK_ = failed_fields.call(null,"End time");
var time_errors_QMARK_ = (function (){var or__41174__auto__ = start_time_error_QMARK_;
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return end_time_error_QMARK_;
}
})();
var on_change_start_time = ((function (failed_fields,start_time_error_QMARK_,end_time_error_QMARK_,time_errors_QMARK_){
return (function (p1__45672_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"change-start-time","change-start-time",229187789),new cljs.core.Keyword(null,"start-time","start-time",814801386),p1__45672_SHARP_], null));
});})(failed_fields,start_time_error_QMARK_,end_time_error_QMARK_,time_errors_QMARK_))
;
var on_change_end_time = ((function (failed_fields,start_time_error_QMARK_,end_time_error_QMARK_,time_errors_QMARK_,on_change_start_time){
return (function (p1__45673_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"change-end-time","change-end-time",2008428072),new cljs.core.Keyword(null,"end-time","end-time",-1849817460),p1__45673_SHARP_], null));
});})(failed_fields,start_time_error_QMARK_,end_time_error_QMARK_,time_errors_QMARK_,on_change_start_time))
;
return React.DOM.div(({"className": "form-group"}),React.DOM.label(({"className": "control-label col-md-2"}),"Date:"),React.DOM.div(({"className": "col-md-10"}),React.DOM.div(({"className": "form-inline form-inline-no-horz-margin"}),React.DOM.div(({"className": "form-group"}),om.core.build.call(null,timi.client.time.form.datepicker,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"input-name","input-name",323608185),"for-date",new cljs.core.Keyword(null,"selected-date","selected-date",-1397749548),timi.client.time.state.form_selected_date.call(null,form),new cljs.core.Keyword(null,"onChangeDate","onChangeDate",-1769286481),((function (failed_fields,start_time_error_QMARK_,end_time_error_QMARK_,time_errors_QMARK_,on_change_start_time,on_change_end_time){
return (function (p1__45674_SHARP_){
return dispatch_BANG_.call(null,timi.client.actions.time_page_change_date.call(null,p1__45674_SHARP_));
});})(failed_fields,start_time_error_QMARK_,end_time_error_QMARK_,time_errors_QMARK_,on_change_start_time,on_change_end_time))
], null)))," ",React.DOM.div(({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("form-group"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(start_time_error_QMARK_)?" has-error":null))].join('')}),React.DOM.label(({"htmlFor": "start-time"}),"From:")," ",timi.client.time.form.time_input.call(null,"start-time",timi.client.time.state.form_start_time.call(null,form),on_change_start_time))," ",React.DOM.div(({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("form-group"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(end_time_error_QMARK_)?" has-error":null))].join('')}),React.DOM.label(({"htmlFor": "end-time"}),"To:")," ",timi.client.time.form.time_input.call(null,"end-time",timi.client.time.state.form_end_time.call(null,form),on_change_end_time))," ",React.DOM.div(({"className": "form-group help-block"}),"Use format 13:37"),React.DOM.div(({"className": (cljs.core.truth_(time_errors_QMARK_)?"has-error":null)}),React.DOM.span(({"className": "help-block entry-forms-errors-date-time-errors"}),(cljs.core.truth_(start_time_error_QMARK_)?React.DOM.span(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Start time: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(start_time_error_QMARK_)].join(''),React.DOM.br(null)):null),(cljs.core.truth_(end_time_error_QMARK_)?React.DOM.span(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("End time: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(end_time_error_QMARK_)].join('')):null))))));
});
timi.client.time.form.comment_row = (function timi$client$time$form$comment_row(dispatch_BANG_,form){
return React.DOM.div(({"className": "form-group"}),React.DOM.label(({"className": "col-md-2 control-label", "htmlFor": "opmerking"}),"Comment:"),React.DOM.div(({"className": "col-md-10"}),om.dom.textarea.call(null,({"name": "comment", "value": timi.client.time.state.form_comment.call(null,form), "onChange": (function (p1__45675_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"change-comment","change-comment",-1973363024),new cljs.core.Keyword(null,"comment","comment",532206069),p1__45675_SHARP_.target.value], null));
}), "id": "comment", "className": "form-control"})),React.DOM.span(({"className": "help-block"}),"Provide any details that can help the customer understand what you've worked on.")));
});
timi.client.time.form.billable_QMARK__row = (function timi$client$time$form$billable_QMARK__row(dispatch_BANG_,form){
return React.DOM.div(({"className": "form-group"}),React.DOM.div(({"className": "col-md-offset-2 col-md-10"}),React.DOM.div(({"className": "checkbox"}),null,React.DOM.label(null,om.dom.input.call(null,({"type": "checkbox", "id": "billable", "name": "billable?", "checked": timi.client.time.state.form_billable_QMARK_.call(null,form), "onChange": (function (p1__45676_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"change-billable?","change-billable?",-400613637),new cljs.core.Keyword(null,"billable?","billable?",136214971),p1__45676_SHARP_.target.checked], null));
})})),"This entry is billable"))));
});
timi.client.time.form.btn_row = (function timi$client$time$form$btn_row(dispatch_BANG_,form){
var editing_QMARK_ = cljs.core.integer_QMARK_.call(null,timi.client.util.parse_float.call(null,timi.client.time.state.form_entry_id.call(null,form)));
return React.DOM.div(({"className": "form-group"}),React.DOM.div(({"className": "col-md-offset-2 col-md-10 form-actions"}),React.DOM.button(({"className": "btn btn-success save-hours", "type": "submit"}),((editing_QMARK_)?" Save changes":" Post entry"))," ",((editing_QMARK_)?React.DOM.button(({"className": "btn btn-danger delete-entry", "name": "delete-entry"}),"Delete entry"):null)," ",React.DOM.button(({"className": "btn btn-link", "name": "cancel", "onClick": ((function (editing_QMARK_){
return (function (p1__45677_SHARP_){
p1__45677_SHARP_.preventDefault();

return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"cancel-entry","cancel-entry",1096668894)], null));
});})(editing_QMARK_))
}),"Cancel")));
});
timi.client.time.form.render = (function timi$client$time$form$render(dispatch_BANG_,form){
return React.DOM.form(({"method": "post", "action": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/time/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(timi.client.time.state.form_selected_date.call(null,form))].join(''), "className": "entry-form", "onSubmit": cljs.core.partial.call(null,timi.client.time.form.on_form_submit,form,(function (p1__45678_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"entry-form-show-errors","entry-form-show-errors",2051558004),new cljs.core.Keyword(null,"form","form",-1624062471),p1__45678_SHARP_], null));
}))}),React.DOM.div(({"className": clojure.string.join.call(null," ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(timi.client.time.form.summary_errors.call(null,form))?"has-errors":null),((cljs.core.seq.call(null,timi.client.time.state.form_selected_task.call(null,form)))?"entry-form-visible well":null)], null)), "id": "entry-form-container"}),om.dom.input.call(null,({"type": "hidden", "name": "selected-project-id", "value": (function (){var or__41174__auto__ = timi.client.time.state.form_selected_project_id.call(null,form);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return "";
}
})()})),om.dom.input.call(null,({"type": "hidden", "name": "selected-task-id", "value": (function (){var or__41174__auto__ = timi.client.time.state.form_selected_task_id.call(null,form);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return "";
}
})()})),om.dom.input.call(null,({"type": "hidden", "name": "entry-id", "value": (function (){var or__41174__auto__ = timi.client.time.state.form_entry_id.call(null,form);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return "";
}
})()})),React.DOM.div(({"className": "row"}),React.DOM.div(({"className": "col-md-12"}),timi.client.time.form.validation_summary.call(null,form),React.DOM.fieldset(null,timi.client.time.form.date_time_entry_row.call(null,dispatch_BANG_,form),timi.client.time.form.comment_row.call(null,dispatch_BANG_,form),timi.client.time.form.billable_QMARK__row.call(null,dispatch_BANG_,form),timi.client.time.form.btn_row.call(null,dispatch_BANG_,form))))));
});
timi.client.time.form.om_component = (function timi$client$time$form$om_component(p__45679,owner){
var map__45685 = p__45679;
var map__45685__$1 = ((((!((map__45685 == null)))?((((map__45685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45685.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45685):map__45685);
var dispatch_BANG_ = cljs.core.get.call(null,map__45685__$1,new cljs.core.Keyword(null,"dispatch!","dispatch!",-1927281664));
var get_state = cljs.core.get.call(null,map__45685__$1,new cljs.core.Keyword(null,"get-state","get-state",1572463657));
if(typeof timi.client.time.form.t_timi$client$time$form45687 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
timi.client.time.form.t_timi$client$time$form45687 = (function (p__45679,owner,map__45685,dispatch_BANG_,get_state,meta45688){
this.p__45679 = p__45679;
this.owner = owner;
this.map__45685 = map__45685;
this.dispatch_BANG_ = dispatch_BANG_;
this.get_state = get_state;
this.meta45688 = meta45688;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
timi.client.time.form.t_timi$client$time$form45687.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__45685,map__45685__$1,dispatch_BANG_,get_state){
return (function (_45689,meta45688__$1){
var self__ = this;
var _45689__$1 = this;
return (new timi.client.time.form.t_timi$client$time$form45687(self__.p__45679,self__.owner,self__.map__45685,self__.dispatch_BANG_,self__.get_state,meta45688__$1));
});})(map__45685,map__45685__$1,dispatch_BANG_,get_state))
;

timi.client.time.form.t_timi$client$time$form45687.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__45685,map__45685__$1,dispatch_BANG_,get_state){
return (function (_45689){
var self__ = this;
var _45689__$1 = this;
return self__.meta45688;
});})(map__45685,map__45685__$1,dispatch_BANG_,get_state))
;

timi.client.time.form.t_timi$client$time$form45687.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

timi.client.time.form.t_timi$client$time$form45687.prototype.om$core$IRender$render$arity$1 = ((function (map__45685,map__45685__$1,dispatch_BANG_,get_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.observe.call(null,self__.owner,timi.client.time.state.entry_screen_form_cursor.call(null,self__.get_state.call(null)));
return timi.client.time.form.render.call(null,self__.dispatch_BANG_,cljs.core.deref.call(null,form));
});})(map__45685,map__45685__$1,dispatch_BANG_,get_state))
;

timi.client.time.form.t_timi$client$time$form45687.getBasis = ((function (map__45685,map__45685__$1,dispatch_BANG_,get_state){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__45679","p__45679",1078508507,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__45685","map__45685",-1772208638,null),new cljs.core.Symbol(null,"dispatch!","dispatch!",-286750137,null),new cljs.core.Symbol(null,"get-state","get-state",-1081972112,null),new cljs.core.Symbol(null,"meta45688","meta45688",203903000,null)], null);
});})(map__45685,map__45685__$1,dispatch_BANG_,get_state))
;

timi.client.time.form.t_timi$client$time$form45687.cljs$lang$type = true;

timi.client.time.form.t_timi$client$time$form45687.cljs$lang$ctorStr = "timi.client.time.form/t_timi$client$time$form45687";

timi.client.time.form.t_timi$client$time$form45687.cljs$lang$ctorPrWriter = ((function (map__45685,map__45685__$1,dispatch_BANG_,get_state){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"timi.client.time.form/t_timi$client$time$form45687");
});})(map__45685,map__45685__$1,dispatch_BANG_,get_state))
;

timi.client.time.form.__GT_t_timi$client$time$form45687 = ((function (map__45685,map__45685__$1,dispatch_BANG_,get_state){
return (function timi$client$time$form$om_component_$___GT_t_timi$client$time$form45687(p__45679__$1,owner__$1,map__45685__$2,dispatch_BANG___$1,get_state__$1,meta45688){
return (new timi.client.time.form.t_timi$client$time$form45687(p__45679__$1,owner__$1,map__45685__$2,dispatch_BANG___$1,get_state__$1,meta45688));
});})(map__45685,map__45685__$1,dispatch_BANG_,get_state))
;

}

return (new timi.client.time.form.t_timi$client$time$form45687(p__45679,owner,map__45685__$1,dispatch_BANG_,get_state,cljs.core.PersistentArrayMap.EMPTY));
});

//# sourceMappingURL=form.js.map?rel=1495428386706