// Compiled by ClojureScript 1.9.542 {}
goog.provide('timi.client.activity.graphic.grid');
goog.require('cljs.core');
goog.require('cljs_time.coerce');
goog.require('cljs_time.format');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('om.core');
goog.require('om.dom');
goog.require('timi.client.actions');
goog.require('timi.client.activity.graphic.draw');
goog.require('timi.client.logging');
goog.require('timi.client.time.state');
goog.require('timi.client.util');
timi.client.activity.graphic.grid.ZoneId = JSJoda.ZoneId;
timi.client.activity.graphic.grid.LocalDate = JSJoda.LocalDate;
timi.client.activity.graphic.grid.LocalTime = JSJoda.LocalTime;
timi.client.activity.graphic.grid.ChronoUnit = JSJoda.ChronoUnit;
timi.client.activity.graphic.grid.Duration = JSJoda.Duration;
timi.client.activity.graphic.grid.DayOfWeek = JSJoda.DayOfWeek;
timi.client.activity.graphic.grid.Instant = JSJoda.Instant;
timi.client.activity.graphic.grid.long_format = "EEEE, d MMMM yyyy";
timi.client.activity.graphic.grid.long_formatter = cljs_time.format.formatter.call(null,timi.client.activity.graphic.grid.long_format);
timi.client.activity.graphic.grid.default_min_time = timi.client.activity.graphic.grid.LocalTime.parse("08:00");
timi.client.activity.graphic.grid.default_max_time = timi.client.activity.graphic.grid.LocalTime.parse("18:00");
timi.client.activity.graphic.grid.days_order = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(0),(1),(2),(3),(4),(5)], null);
timi.client.activity.graphic.grid.find_first_monday = (function timi$client$activity$graphic$grid$find_first_monday(for_date){
while(true){
if(typeof for_date === 'string'){
var G__45284 = timi.client.activity.graphic.grid.LocalDate.parse(for_date);
for_date = G__45284;
continue;
} else {
if(cljs.core._EQ_.call(null,for_date.dayOfWeek(),timi.client.activity.graphic.grid.DayOfWeek.MONDAY)){
return for_date;
} else {
var G__45285 = for_date.plusDays((-1));
for_date = G__45285;
continue;
}
}
break;
}
});
timi.client.activity.graphic.grid.bars_sum_duration = (function timi$client$activity$graphic$grid$bars_sum_duration(bars){
return timi.client.activity.graphic.grid.Duration.ofMinutes(cljs.core.reduce.call(null,(function (sum,p__45289){
var map__45290 = p__45289;
var map__45290__$1 = ((((!((map__45290 == null)))?((((map__45290.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45290.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45290):map__45290);
var next = map__45290__$1;
var from = cljs.core.get.call(null,map__45290__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var till = cljs.core.get.call(null,map__45290__$1,new cljs.core.Keyword(null,"till","till",-469717226));
return (sum + from.until(till,timi.client.activity.graphic.grid.ChronoUnit.MINUTES));
}),(0),bars));
});
timi.client.activity.graphic.grid.bars_merge = (function timi$client$activity$graphic$grid$bars_merge(bars){
var bars_overlap_QMARK_ = (function timi$client$activity$graphic$grid$bars_merge_$_bars_overlap_QMARK_(a,b){
while(true){
if((new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(b).compareTo(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(a)) < (0))){
var G__45332 = b;
var G__45333 = a;
a = G__45332;
b = G__45333;
continue;
} else {
return (new cljs.core.Keyword(null,"till","till",-469717226).cljs$core$IFn$_invoke$arity$1(a).compareTo(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(b)) >= (0));
}
break;
}
});
var merge_recur = (function timi$client$activity$graphic$grid$bars_merge_$_merge_recur(merged,p__45319){
while(true){
var vec__45323 = p__45319;
var seq__45324 = cljs.core.seq.call(null,vec__45323);
var first__45325 = cljs.core.first.call(null,seq__45324);
var seq__45324__$1 = cljs.core.next.call(null,seq__45324);
var first = first__45325;
var first__45325__$1 = cljs.core.first.call(null,seq__45324__$1);
var seq__45324__$2 = cljs.core.next.call(null,seq__45324__$1);
var second = first__45325__$1;
var more = seq__45324__$2;
var remaining = vec__45323;
if(cljs.core.not.call(null,first)){
return merged;
} else {
if((cljs.core.not.call(null,second)) || (cljs.core.not.call(null,bars_overlap_QMARK_.call(null,first,second)))){
var G__45334 = cljs.core.conj.call(null,merged,first);
var G__45335 = cljs.core.rest.call(null,remaining);
merged = G__45334;
p__45319 = G__45335;
continue;
} else {
var G__45336 = merged;
var G__45337 = cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(first),new cljs.core.Keyword(null,"till","till",-469717226),new cljs.core.Keyword(null,"till","till",-469717226).cljs$core$IFn$_invoke$arity$1(second)], null)], null),more);
merged = G__45336;
p__45319 = G__45337;
continue;

}
}
break;
}
});
return merge_recur.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.sort.call(null,(function (p__45326,p__45327){
var map__45328 = p__45326;
var map__45328__$1 = ((((!((map__45328 == null)))?((((map__45328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45328.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45328):map__45328);
var a_from = cljs.core.get.call(null,map__45328__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var map__45329 = p__45327;
var map__45329__$1 = ((((!((map__45329 == null)))?((((map__45329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45329.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45329):map__45329);
var b_from = cljs.core.get.call(null,map__45329__$1,new cljs.core.Keyword(null,"from","from",1815293044));
return a_from.compareTo(b_from);
}),bars));
});
timi.client.activity.graphic.grid.date__GT_grid_label = (function timi$client$activity$graphic$grid$date__GT_grid_label(for_date){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(for_date.dayOfWeek())].join('');
});
timi.client.activity.graphic.grid.init_data = (function timi$client$activity$graphic$grid$init_data(project_data){
return cljs.core.map.call(null,(function (p__45357){
var vec__45358 = p__45357;
var k = cljs.core.nth.call(null,vec__45358,(0),null);
var vs = cljs.core.nth.call(null,vec__45358,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),k,new cljs.core.Keyword(null,"bars","bars",-586907130),cljs.core.sort.call(null,((function (vec__45358,k,vs){
return (function (p__45361,p__45362){
var map__45363 = p__45361;
var map__45363__$1 = ((((!((map__45363 == null)))?((((map__45363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45363.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45363):map__45363);
var a_from = cljs.core.get.call(null,map__45363__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var map__45364 = p__45362;
var map__45364__$1 = ((((!((map__45364 == null)))?((((map__45364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45364.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45364):map__45364);
var b_from = cljs.core.get.call(null,map__45364__$1,new cljs.core.Keyword(null,"from","from",1815293044));
return a_from.compareTo(b_from);
});})(vec__45358,k,vs))
,vs)], null);
}),cljs.core.group_by.call(null,new cljs.core.Keyword(null,"project","project",1124394579),cljs.core.map.call(null,(function (p__45367){
var map__45368 = p__45367;
var map__45368__$1 = ((((!((map__45368 == null)))?((((map__45368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45368.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45368):map__45368);
var project_row = map__45368__$1;
var from = cljs.core.get.call(null,map__45368__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var till = cljs.core.get.call(null,map__45368__$1,new cljs.core.Keyword(null,"till","till",-469717226));
var task_id = cljs.core.get.call(null,map__45368__$1,new cljs.core.Keyword(null,"task-id","task-id",-1045480126));
return cljs.core.assoc.call(null,project_row,new cljs.core.Keyword(null,"task-id","task-id",-1045480126),timi.client.util.parse_float.call(null,task_id),new cljs.core.Keyword(null,"from","from",1815293044),timi.client.activity.graphic.grid.Instant.ofEpochSecond(from),new cljs.core.Keyword(null,"till","till",-469717226),timi.client.activity.graphic.grid.Instant.ofEpochSecond(till));
}),cljs.core.sort.call(null,(function (p__45370,p__45371){
var map__45372 = p__45370;
var map__45372__$1 = ((((!((map__45372 == null)))?((((map__45372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45372.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45372):map__45372);
var a_from = cljs.core.get.call(null,map__45372__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var map__45373 = p__45371;
var map__45373__$1 = ((((!((map__45373 == null)))?((((map__45373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45373.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45373):map__45373);
var b_from = cljs.core.get.call(null,map__45373__$1,new cljs.core.Keyword(null,"from","from",1815293044));
return cljs.core.compare.call(null,a_from,b_from);
}),project_data))));
});
timi.client.activity.graphic.grid.calc_min_max_time = (function timi$client$activity$graphic$grid$calc_min_max_time(projects){
if((cljs.core.count.call(null,projects) === (0))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [timi.client.activity.graphic.grid.default_min_time,timi.client.activity.graphic.grid.default_max_time], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,cljs.core.map.call(null,(function (p1__45377_SHARP_){
return p1__45377_SHARP_.truncatedTo(timi.client.activity.graphic.grid.ChronoUnit.HOURS);
}),cljs.core.take.call(null,(1),cljs.core.sort.call(null,(function (a,b){
return a.compareTo(b);
}),cljs.core.map.call(null,(function (p1__45376_SHARP_){
return timi.client.activity.graphic.grid.LocalTime.ofInstant(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__45376_SHARP_));
}),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"bars","bars",-586907130),projects)))))),cljs.core.first.call(null,cljs.core.map.call(null,(function (p1__45380_SHARP_){
return p1__45380_SHARP_.plusHours((1));
}),cljs.core.map.call(null,(function (p1__45379_SHARP_){
return p1__45379_SHARP_.truncatedTo(timi.client.activity.graphic.grid.ChronoUnit.HOURS);
}),cljs.core.take.call(null,(1),cljs.core.sort.call(null,(function (a,b){
return b.compareTo(a);
}),cljs.core.map.call(null,(function (p1__45378_SHARP_){
return timi.client.activity.graphic.grid.LocalTime.ofInstant(new cljs.core.Keyword(null,"till","till",-469717226).cljs$core$IFn$_invoke$arity$1(p1__45378_SHARP_));
}),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"bars","bars",-586907130),projects)))))))], null);

}
});
timi.client.activity.graphic.grid.instant_to_x = (function timi$client$activity$graphic$grid$instant_to_x(min_time,min_date,minutes_per_day,pixels_per_minute,instant){
var day = min_date.until(timi.client.activity.graphic.grid.LocalDate.ofInstant(instant),timi.client.activity.graphic.grid.ChronoUnit.DAYS);
var time__$1 = timi.client.activity.graphic.grid.LocalTime.ofInstant(instant);
return ((((day * minutes_per_day) * pixels_per_minute) + (pixels_per_minute * min_time.until(time__$1,timi.client.activity.graphic.grid.ChronoUnit.MINUTES))) + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"left-axis-px","left-axis-px",-234886135)], null)));
});
timi.client.activity.graphic.grid.iterate_day_grid = (function timi$client$activity$graphic$grid$iterate_day_grid(min_time,min_date,instant_to_x,f,init_value){
return cljs.core.reduce.call(null,(function (acc,day_index){
var get_instant = (function (for_day_index){
return min_date.plusDays(for_day_index).atTime(min_time).atZone(timi.client.activity.graphic.grid.ZoneId.systemDefault()).toInstant();
});
var day_instant = get_instant.call(null,day_index);
var next_day_instant = get_instant.call(null,(day_index + (1)));
var x1 = instant_to_x.call(null,day_instant);
var x2 = instant_to_x.call(null,next_day_instant);
return f.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"left-x","left-x",694184648),x1,new cljs.core.Keyword(null,"right-x","right-x",1257924552),x2,new cljs.core.Keyword(null,"left-instant","left-instant",-819863359),day_instant,new cljs.core.Keyword(null,"right-instant","right-instant",473658713),next_day_instant,new cljs.core.Keyword(null,"is-first","is-first",978437250),cljs.core._EQ_.call(null,day_index,cljs.core.first.call(null,timi.client.activity.graphic.grid.days_order)),new cljs.core.Keyword(null,"is-last","is-last",-2060069857),cljs.core._EQ_.call(null,day_index,cljs.core.last.call(null,timi.client.activity.graphic.grid.days_order))], null),acc);
}),init_value,timi.client.activity.graphic.grid.days_order);
});
timi.client.activity.graphic.grid.render_grid_labels = (function timi$client$activity$graphic$grid$render_grid_labels(on_change_date,selected_date,min_time,max_time,iterate_day_grid,draw_result){
return iterate_day_grid.call(null,(function (p__45393,p__45394){
var map__45395 = p__45393;
var map__45395__$1 = ((((!((map__45395 == null)))?((((map__45395.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45395.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45395):map__45395);
var left_x = cljs.core.get.call(null,map__45395__$1,new cljs.core.Keyword(null,"left-x","left-x",694184648));
var right_x = cljs.core.get.call(null,map__45395__$1,new cljs.core.Keyword(null,"right-x","right-x",1257924552));
var map__45396 = p__45394;
var map__45396__$1 = ((((!((map__45396 == null)))?((((map__45396.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45396.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45396):map__45396);
var draw_result__$1 = map__45396__$1;
var y_offset = cljs.core.get.call(null,map__45396__$1,new cljs.core.Keyword(null,"y-offset","y-offset",-1716542));
return timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": "grid-time-label", "x": (right_x - timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"grid-time-label","grid-time-label",-916019126),new cljs.core.Keyword(null,"x-offset-px","x-offset-px",2008527066)], null))), "y": y_offset, "textAnchor": "end"}),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_time)].join('')),timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": "grid-time-label", "x": (left_x + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"grid-time-label","grid-time-label",-916019126),new cljs.core.Keyword(null,"x-offset-px","x-offset-px",2008527066)], null))), "y": y_offset}),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(min_time)].join('')),draw_result__$1));
}),timi.client.activity.graphic.draw.result_add_to_y.call(null,(timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"grid-day-label","grid-day-label",1354468510),new cljs.core.Keyword(null,"height-px","height-px",-1391665005)], null)) + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"grid-time-label","grid-time-label",-916019126),new cljs.core.Keyword(null,"height-px","height-px",-1391665005)], null))),iterate_day_grid.call(null,(function (p__45399,p__45400){
var map__45401 = p__45399;
var map__45401__$1 = ((((!((map__45401 == null)))?((((map__45401.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45401.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45401):map__45401);
var left_x = cljs.core.get.call(null,map__45401__$1,new cljs.core.Keyword(null,"left-x","left-x",694184648));
var left_instant = cljs.core.get.call(null,map__45401__$1,new cljs.core.Keyword(null,"left-instant","left-instant",-819863359));
var map__45402 = p__45400;
var map__45402__$1 = ((((!((map__45402 == null)))?((((map__45402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45402.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45402):map__45402);
var draw_result__$1 = map__45402__$1;
var y_offset = cljs.core.get.call(null,map__45402__$1,new cljs.core.Keyword(null,"y-offset","y-offset",-1716542));
var date = timi.client.activity.graphic.grid.LocalDate.ofInstant(left_instant);
var date_elem1 = document.getElementById("entries-for-day-date");
var date_elem2 = document.getElementById("day-entry-table-for-date");
(date_elem1["innerHTML"] = cljs_time.format.unparse.call(null,timi.client.activity.graphic.grid.long_formatter,cljs_time.coerce.from_string.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(selected_date)].join(''))));

(date_elem2["value"] = selected_date);

return timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("grid-day-label"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(date.equals(selected_date))?" grid-day-label-is-selected":null))].join(''), "x": (left_x + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"grid-day-label","grid-day-label",1354468510),new cljs.core.Keyword(null,"x-offset-px","x-offset-px",2008527066)], null))), "y": (y_offset + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"grid-day-label","grid-day-label",1354468510),new cljs.core.Keyword(null,"height-px","height-px",-1391665005)], null))), "onClick": ((function (date,date_elem1,date_elem2,map__45401,map__45401__$1,left_x,left_instant,map__45402,map__45402__$1,draw_result__$1,y_offset){
return (function (){
return on_change_date.call(null,date);
});})(date,date_elem1,date_elem2,map__45401,map__45401__$1,left_x,left_instant,map__45402,map__45402__$1,draw_result__$1,y_offset))
}),timi.client.activity.graphic.grid.date__GT_grid_label.call(null,timi.client.activity.graphic.grid.LocalDate.ofInstant(left_instant))),draw_result__$1);
}),draw_result)));
});
timi.client.activity.graphic.grid.noop = (function timi$client$activity$graphic$grid$noop(var_args){
var args__42294__auto__ = [];
var len__42287__auto___45406 = arguments.length;
var i__42288__auto___45407 = (0);
while(true){
if((i__42288__auto___45407 < len__42287__auto___45406)){
args__42294__auto__.push((arguments[i__42288__auto___45407]));

var G__45408 = (i__42288__auto___45407 + (1));
i__42288__auto___45407 = G__45408;
continue;
} else {
}
break;
}

var argseq__42295__auto__ = ((((0) < args__42294__auto__.length))?(new cljs.core.IndexedSeq(args__42294__auto__.slice((0)),(0),null)):null);
return timi.client.activity.graphic.grid.noop.cljs$core$IFn$_invoke$arity$variadic(argseq__42295__auto__);
});

timi.client.activity.graphic.grid.noop.cljs$core$IFn$_invoke$arity$variadic = (function (more){
return null;
});

timi.client.activity.graphic.grid.noop.cljs$lang$maxFixedArity = (0);

timi.client.activity.graphic.grid.noop.cljs$lang$applyTo = (function (seq45405){
return timi.client.activity.graphic.grid.noop.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq45405));
});

timi.client.activity.graphic.grid.render_row = (function timi$client$activity$graphic$grid$render_row(selected_entry,instant_to_x,text,bars,p__45410,draw_result){
var map__45418 = p__45410;
var map__45418__$1 = ((((!((map__45418 == null)))?((((map__45418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45418.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45418):map__45418);
var opts = map__45418__$1;
var right_label = cljs.core.get.call(null,map__45418__$1,new cljs.core.Keyword(null,"right-label","right-label",1465344334));
var on_mouse_over_bar = cljs.core.get.call(null,map__45418__$1,new cljs.core.Keyword(null,"on-mouse-over-bar","on-mouse-over-bar",-829936176),timi.client.activity.graphic.grid.noop);
var on_mouse_leave_bar = cljs.core.get.call(null,map__45418__$1,new cljs.core.Keyword(null,"on-mouse-leave-bar","on-mouse-leave-bar",-941530087),timi.client.activity.graphic.grid.noop);
var on_click_bar = cljs.core.get.call(null,map__45418__$1,new cljs.core.Keyword(null,"on-click-bar","on-click-bar",718637448));
var x_start = (instant_to_x.call(null,cljs.core.first.call(null,cljs.core.sort.call(null,((function (map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (a,b){
return a.compareTo(b);
});})(map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
,cljs.core.map.call(null,new cljs.core.Keyword(null,"from","from",1815293044),bars)))) - timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-label-offset-px","project-label-offset-px",-530151825)], null)));
var introduce_gap_between_adjacent_bars = ((function (x_start,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (result,p__45420){
while(true){
var vec__45421 = p__45420;
var seq__45422 = cljs.core.seq.call(null,vec__45421);
var first__45423 = cljs.core.first.call(null,seq__45422);
var seq__45422__$1 = cljs.core.next.call(null,seq__45422);
var first = first__45423;
var first__45423__$1 = cljs.core.first.call(null,seq__45422__$1);
var seq__45422__$2 = cljs.core.next.call(null,seq__45422__$1);
var second = first__45423__$1;
var more = seq__45422__$2;
var bars_with_positions = vec__45421;
if(cljs.core.not.call(null,first)){
return result;
} else {
if((cljs.core.not.call(null,second)) || (cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"x2","x2",-1362513475).cljs$core$IFn$_invoke$arity$1(first),new cljs.core.Keyword(null,"x1","x1",-1863922247).cljs$core$IFn$_invoke$arity$1(second)))){
var G__45425 = cljs.core.conj.call(null,result,first);
var G__45426 = cljs.core.rest.call(null,bars_with_positions);
result = G__45425;
p__45420 = G__45426;
continue;
} else {
var G__45427 = cljs.core.conj.call(null,result,cljs.core.update.call(null,first,new cljs.core.Keyword(null,"x2","x2",-1362513475),cljs.core.dec));
var G__45428 = cljs.core.rest.call(null,bars_with_positions);
result = G__45427;
p__45420 = G__45428;
continue;

}
}
break;
}
});})(x_start,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
;
var drawable_bars = introduce_gap_between_adjacent_bars.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,((function (x_start,introduce_gap_between_adjacent_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (p1__45409_SHARP_){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x1","x1",-1863922247),instant_to_x.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__45409_SHARP_)),new cljs.core.Keyword(null,"x2","x2",-1362513475),instant_to_x.call(null,new cljs.core.Keyword(null,"till","till",-469717226).cljs$core$IFn$_invoke$arity$1(p1__45409_SHARP_)),new cljs.core.Keyword(null,"bar","bar",-1386246584),p1__45409_SHARP_], null);
});})(x_start,introduce_gap_between_adjacent_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
,bars));
var draw_bars = ((function (x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (draw_result__$1){
return cljs.core.reduce.call(null,((function (x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (draw_result__$2,bar){
var G__45424 = draw_result__$2;
var G__45424__$1 = ((cljs.core._EQ_.call(null,cljs.core.get_in.call(null,bar,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bar","bar",-1386246584),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null)),selected_entry))?timi.client.activity.graphic.draw.result_append_el.call(null,(function (){var height = timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hour-entry","hour-entry",496551832),new cljs.core.Keyword(null,"height-px","height-px",-1391665005)], null));
return React.DOM.rect(({"className": "hour-entry-active", "x": new cljs.core.Keyword(null,"x1","x1",-1863922247).cljs$core$IFn$_invoke$arity$1(bar), "width": (new cljs.core.Keyword(null,"x2","x2",-1362513475).cljs$core$IFn$_invoke$arity$1(bar) - new cljs.core.Keyword(null,"x1","x1",-1863922247).cljs$core$IFn$_invoke$arity$1(bar)), "y": (new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result__$2) - (height / (2))), "height": height, "style": ({"filter": "url(#hour-entry-active-glow)"})}));
})(),G__45424):G__45424);
return timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.line(({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("time-line hour-line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(new cljs.core.Keyword(null,"billable?","billable?",136214971).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"bar","bar",-1386246584).cljs$core$IFn$_invoke$arity$1(bar)))?"hour-line-is-billable":null))].join(''), "x1": new cljs.core.Keyword(null,"x1","x1",-1863922247).cljs$core$IFn$_invoke$arity$1(bar), "x2": new cljs.core.Keyword(null,"x2","x2",-1362513475).cljs$core$IFn$_invoke$arity$1(bar), "y1": new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result__$2), "y2": new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result__$2), "onMouseOver": ((function (G__45424,G__45424__$1,x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (ev){
var rect = timi.client.activity.graphic.draw.get_abs_bounding_client_rect.call(null,ev.target);
return on_mouse_over_bar.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"entry-id","entry-id",591934358),cljs.core.get_in.call(null,bar,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bar","bar",-1386246584),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null)),new cljs.core.Keyword(null,"pos","pos",-864607220),rect], null));
});})(G__45424,G__45424__$1,x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
, "onMouseOut": ((function (G__45424,G__45424__$1,x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (){
return on_mouse_leave_bar.call(null);
});})(G__45424,G__45424__$1,x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
, "onClick": ((function (G__45424,G__45424__$1,x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (ev){
return on_click_bar.call(null,cljs.core.get_in.call(null,bar,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bar","bar",-1386246584),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null)));
});})(G__45424,G__45424__$1,x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
})),G__45424__$1);

});})(x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
,draw_result__$1,drawable_bars);
});})(x_start,introduce_gap_between_adjacent_bars,drawable_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
;
var draw_right_label = ((function (x_start,introduce_gap_between_adjacent_bars,drawable_bars,draw_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar){
return (function (draw_result__$1){
if(cljs.core.not.call(null,right_label)){
return draw_result__$1;
} else {
return timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": "project-label project-label-summary", "x": (new cljs.core.Keyword(null,"x2","x2",-1362513475).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,drawable_bars)) + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-label-offset-px","project-label-offset-px",-530151825)], null))), "y": (new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result__$1) + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-label-vert-offset-px","project-label-vert-offset-px",-1742185019)], null)))}),right_label),draw_result__$1);
}
});})(x_start,introduce_gap_between_adjacent_bars,drawable_bars,draw_bars,map__45418,map__45418__$1,opts,right_label,on_mouse_over_bar,on_mouse_leave_bar,on_click_bar))
;
return timi.client.activity.graphic.draw.result_add_to_y.call(null,timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"row-spacing-px","row-spacing-px",859983260)], null)),draw_right_label.call(null,draw_bars.call(null,timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": "project-label project-label-taskname", "x": x_start, "y": (new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result) + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-label-vert-offset-px","project-label-vert-offset-px",-1742185019)], null))), "textAnchor": "end"}),text),draw_result))));
});
timi.client.activity.graphic.grid.format_duration = (function timi$client$activity$graphic$grid$format_duration(duration){
var hours = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(duration.toHours())].join('');
var minutes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.mod.call(null,duration.toMinutes(),(60)))].join('');
var minutes__$1 = (((cljs.core.count.call(null,minutes) < (2)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1("0"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(minutes)].join(''):minutes);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(hours),cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(minutes__$1)].join('');
});
timi.client.activity.graphic.grid.render_project_heading = (function timi$client$activity$graphic$grid$render_project_heading(label,start_at_instant,draw_result){
var x = timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-heading-x-px","project-heading-x-px",-299111417)], null));
return timi.client.activity.graphic.draw.result_add_to_y.call(null,timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"heading-to-rows-px","heading-to-rows-px",-1862649994)], null)),timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": "project-heading", "x": x, "y": new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result)}),label),draw_result));
});
timi.client.activity.graphic.grid.render_project_tasks = (function timi$client$activity$graphic$grid$render_project_tasks(render_row,tasks,draw_result){
return cljs.core.reduce.call(null,(function (draw_result__$1,p__45433){
var vec__45434 = p__45433;
var task_id = cljs.core.nth.call(null,vec__45434,(0),null);
var entries = cljs.core.nth.call(null,vec__45434,(1),null);
return render_row.call(null,new cljs.core.Keyword(null,"task","task",-1476607993).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,entries)),entries,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"right-label","right-label",1465344334),timi.client.activity.graphic.grid.format_duration.call(null,timi.client.activity.graphic.grid.bars_sum_duration.call(null,entries))], null),draw_result__$1);
}),draw_result,tasks);
});
timi.client.activity.graphic.grid.render_project = (function timi$client$activity$graphic$grid$render_project(render_project_tasks,project,draw_result){
var tasks = cljs.core.sort.call(null,(function (p__45451,p__45452){
var vec__45453 = p__45451;
var _ = cljs.core.nth.call(null,vec__45453,(0),null);
var vec__45456 = cljs.core.nth.call(null,vec__45453,(1),null);
var seq__45457 = cljs.core.seq.call(null,vec__45456);
var first__45458 = cljs.core.first.call(null,seq__45457);
var seq__45457__$1 = cljs.core.next.call(null,seq__45457);
var a = first__45458;
var ___$1 = seq__45457__$1;
var vec__45459 = p__45452;
var ___$2 = cljs.core.nth.call(null,vec__45459,(0),null);
var vec__45462 = cljs.core.nth.call(null,vec__45459,(1),null);
var seq__45463 = cljs.core.seq.call(null,vec__45462);
var first__45464 = cljs.core.first.call(null,seq__45463);
var seq__45463__$1 = cljs.core.next.call(null,seq__45463);
var b = first__45464;
var more = seq__45463__$1;
return new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(a).compareTo(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(b));
}),cljs.core.group_by.call(null,new cljs.core.Keyword(null,"task-id","task-id",-1045480126),new cljs.core.Keyword(null,"bars","bars",-586907130).cljs$core$IFn$_invoke$arity$1(project)));
return timi.client.activity.graphic.draw.result_add_to_y.call(null,timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"project-spacing-px","project-spacing-px",-878187526)], null)),render_project_tasks.call(null,tasks,timi.client.activity.graphic.grid.render_project_heading.call(null,new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(project),cljs.core.get_in.call(null,tasks,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),new cljs.core.Keyword(null,"items","items",1031954938),(0),new cljs.core.Keyword(null,"from","from",1815293044)], null)),draw_result)));
});
timi.client.activity.graphic.grid.render_projects = (function timi$client$activity$graphic$grid$render_projects(projects,render_row,draw_result){
var render_project_tasks = cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_project_tasks,render_row);
var render_project = cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_project,render_project_tasks);
var draw_projects = ((function (render_project_tasks,render_project){
return (function (draw_result__$1){
return cljs.core.reduce.call(null,((function (render_project_tasks,render_project){
return (function (p1__45466_SHARP_,p2__45465_SHARP_){
return render_project.call(null,p2__45465_SHARP_,p1__45466_SHARP_);
});})(render_project_tasks,render_project))
,draw_result__$1,projects);
});})(render_project_tasks,render_project))
;
return draw_projects.call(null,timi.client.activity.graphic.draw.result_add_to_y.call(null,timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects","projects",-364845983),new cljs.core.Keyword(null,"vertical-offset-px","vertical-offset-px",450530715)], null)),draw_result));
});
timi.client.activity.graphic.grid.render_grid = (function timi$client$activity$graphic$grid$render_grid(iterate_day_grid,selected_date,height,draw_result){
return iterate_day_grid.call(null,(function (p__45471,draw_result__$1){
var map__45472 = p__45471;
var map__45472__$1 = ((((!((map__45472 == null)))?((((map__45472.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45472.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45472):map__45472);
var left_x = cljs.core.get.call(null,map__45472__$1,new cljs.core.Keyword(null,"left-x","left-x",694184648));
var right_x = cljs.core.get.call(null,map__45472__$1,new cljs.core.Keyword(null,"right-x","right-x",1257924552));
var left_instant = cljs.core.get.call(null,map__45472__$1,new cljs.core.Keyword(null,"left-instant","left-instant",-819863359));
var G__45474 = draw_result__$1;
var G__45474__$1 = (cljs.core.truth_(timi.client.activity.graphic.grid.LocalDate.ofInstant(left_instant).equals(selected_date))?timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.rect(({"className": "selected-date-highlight", "x": left_x, "width": (right_x - left_x), "y": (0), "height": height})),G__45474):G__45474);
return timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.line(({"className": "grid-day-separator", "x1": left_x, "x2": left_x, "y1": (0), "y2": height})),G__45474__$1);

}),draw_result);
});
timi.client.activity.graphic.grid.render_now_indicator = (function timi$client$activity$graphic$grid$render_now_indicator(instant_to_x,min_time,max_time,height,draw_result){
var now = timi.client.activity.graphic.grid.Instant.now();
var time__$1 = timi.client.activity.graphic.grid.LocalTime.ofInstant(now);
var max_time_is_midnight_QMARK_ = timi.client.activity.graphic.grid.LocalTime.MIDNIGHT.equals(max_time);
if(((time__$1.compareTo(min_time) < (0))) || ((cljs.core.not.call(null,max_time_is_midnight_QMARK_)) && ((time__$1.compareTo(max_time) > (0))))){
return draw_result;
} else {
var x = (Math.floor(instant_to_x.call(null,now)) - 0.5);
return timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.line(({"className": "now-indicator", "x1": x, "x2": x, "y1": (0), "y2": height})),draw_result);
}
});
timi.client.activity.graphic.grid.bars_filter_date = (function timi$client$activity$graphic$grid$bars_filter_date(date,bars){
return cljs.core.filter.call(null,(function (p1__45475_SHARP_){
var bar_date = timi.client.activity.graphic.grid.LocalDate.ofInstant(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__45475_SHARP_));
return (bar_date.compareTo(date) === (0));
}),bars);
});
timi.client.activity.graphic.grid.bars_filter_billable = (function timi$client$activity$graphic$grid$bars_filter_billable(billable_QMARK_,bars){
return cljs.core.filter.call(null,(function (p1__45476_SHARP_){
return cljs.core._EQ_.call(null,billable_QMARK_,new cljs.core.Keyword(null,"billable?","billable?",136214971).cljs$core$IFn$_invoke$arity$1(p1__45476_SHARP_));
}),bars);
});
timi.client.activity.graphic.grid.render_bars = (function timi$client$activity$graphic$grid$render_bars(instant_to_x,bars,y_offset,p__45477,draw_result){
var map__45480 = p__45477;
var map__45480__$1 = ((((!((map__45480 == null)))?((((map__45480.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45480.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45480):map__45480);
var opts = map__45480__$1;
var bar_classes = cljs.core.get.call(null,map__45480__$1,new cljs.core.Keyword(null,"bar-classes","bar-classes",-554358755));
if(cljs.core.not.call(null,cljs.core.seq.call(null,bars))){
return draw_result;
} else {
return cljs.core.reduce.call(null,((function (map__45480,map__45480__$1,opts,bar_classes){
return (function (draw_result__$1,bar){
var x1 = instant_to_x.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(bar));
var x2 = instant_to_x.call(null,new cljs.core.Keyword(null,"till","till",-469717226).cljs$core$IFn$_invoke$arity$1(bar));
var classes = clojure.string.join.call(null," ",cljs.core.conj.call(null,bar_classes,"time-line"));
var el = React.DOM.line(({"className": classes, "x1": x1, "x2": x2, "y1": y_offset, "y2": y_offset}));
return timi.client.activity.graphic.draw.result_append_el.call(null,el,draw_result__$1);
});})(map__45480,map__45480__$1,opts,bar_classes))
,draw_result,bars);
}
});
timi.client.activity.graphic.grid.render_day_summaries = (function timi$client$activity$graphic$grid$render_day_summaries(render_bars,iterate_day_grid,projects,p__45482){
var map__45488 = p__45482;
var map__45488__$1 = ((((!((map__45488 == null)))?((((map__45488.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45488.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45488):map__45488);
var draw_result = map__45488__$1;
var y_offset = cljs.core.get.call(null,map__45488__$1,new cljs.core.Keyword(null,"y-offset","y-offset",-1716542));
var all_bars = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"bars","bars",-586907130),projects);
var total_duration = timi.client.activity.graphic.grid.bars_sum_duration.call(null,all_bars);
var bar_offset = (y_offset + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"day-summary","day-summary",-467179835),new cljs.core.Keyword(null,"bar","bar",-1386246584),new cljs.core.Keyword(null,"y-offset-px","y-offset-px",1733814564)], null)));
var text_offset = (bar_offset + timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"day-summary","day-summary",-467179835),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"y-offset-px","y-offset-px",1733814564)], null)));
var min_hours = timi.client.activity.graphic.grid.Duration.ofHours((8));
return iterate_day_grid.call(null,((function (all_bars,total_duration,bar_offset,text_offset,min_hours,map__45488,map__45488__$1,draw_result,y_offset){
return (function (p__45490,draw_result__$1){
var map__45491 = p__45490;
var map__45491__$1 = ((((!((map__45491 == null)))?((((map__45491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45491.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45491):map__45491);
var right_x = cljs.core.get.call(null,map__45491__$1,new cljs.core.Keyword(null,"right-x","right-x",1257924552));
var left_instant = cljs.core.get.call(null,map__45491__$1,new cljs.core.Keyword(null,"left-instant","left-instant",-819863359));
var date = timi.client.activity.graphic.grid.LocalDate.ofInstant(left_instant);
var day_bars = timi.client.activity.graphic.grid.bars_filter_date.call(null,date,all_bars);
var billable = timi.client.activity.graphic.grid.bars_merge.call(null,timi.client.activity.graphic.grid.bars_filter_billable.call(null,true,day_bars));
var non_billable = timi.client.activity.graphic.grid.bars_merge.call(null,timi.client.activity.graphic.grid.bars_filter_billable.call(null,false,day_bars));
var day_duration = timi.client.activity.graphic.grid.bars_sum_duration.call(null,day_bars);
var day_complete_class = (((day_duration.compareTo(min_hours) >= (0)))?"day-complete-complete":"day-complete-not-complete");
if(cljs.core.not.call(null,cljs.core.seq.call(null,day_bars))){
return draw_result__$1;
} else {
return timi.client.activity.graphic.draw.result_set_y_offset.call(null,text_offset,timi.client.activity.graphic.draw.result_append_el.call(null,React.DOM.text(({"className": "day-summary-label", "x": (right_x - timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"day-summary","day-summary",-467179835),new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.Keyword(null,"x-offset-px","x-offset-px",2008527066)], null))), "y": text_offset, "textAnchor": "end"}),React.DOM.tspan(({"className": day_complete_class}),timi.client.activity.graphic.grid.format_duration.call(null,day_duration)),React.DOM.tspan(null,(function (){var day_billability = (timi.client.activity.graphic.grid.bars_sum_duration.call(null,billable).toMinutes() / day_duration.toMinutes());
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(" ("),cljs.core.str.cljs$core$IFn$_invoke$arity$1(Math.floor(((100) * day_billability))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("%)")].join('');
})())),render_bars.call(null,non_billable,(bar_offset - 0.5),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bar-classes","bar-classes",-554358755),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["day-summary","non-billable",day_complete_class], null)], null),render_bars.call(null,billable,(bar_offset + 0.5),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bar-classes","bar-classes",-554358755),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["day-summary","billable",day_complete_class], null)], null),draw_result__$1))));
}
});})(all_bars,total_duration,bar_offset,text_offset,min_hours,map__45488,map__45488__$1,draw_result,y_offset))
,draw_result);
});
timi.client.activity.graphic.grid.get_render_fns = (function timi$client$activity$graphic$grid$get_render_fns(dispatch_BANG_,selected_date_str,projects,selected_entry,on_change_date){
var selected_date = timi.client.activity.graphic.grid.LocalDate.parse(selected_date_str);
var min_date = timi.client.activity.graphic.grid.find_first_monday.call(null,selected_date);
var vec__45498 = timi.client.activity.graphic.grid.calc_min_max_time.call(null,projects);
var min_time = cljs.core.nth.call(null,vec__45498,(0),null);
var max_time = cljs.core.nth.call(null,vec__45498,(1),null);
var minutes_per_day = min_time.until(max_time,timi.client.activity.graphic.grid.ChronoUnit.MINUTES);
var minutes_per_day__$1 = (((minutes_per_day > (0)))?minutes_per_day:(minutes_per_day + timi.client.activity.graphic.grid.Duration.ofDays((1)).toMinutes()));
var pixels_per_minute = (timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pixels-per-day","pixels-per-day",992441323)], null)) / minutes_per_day__$1);
var instant_to_x = cljs.core.partial.call(null,timi.client.activity.graphic.grid.instant_to_x,min_time,min_date,minutes_per_day__$1,pixels_per_minute);
var iterate_day_grid = cljs.core.partial.call(null,timi.client.activity.graphic.grid.iterate_day_grid,min_time,min_date,instant_to_x);
var render_row = ((function (selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid){
return (function (text,bars,opts,draw_result){
var opts_SINGLEQUOTE_ = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-mouse-over-bar","on-mouse-over-bar",-829936176),((function (selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid){
return (function (p1__45493_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"mouse-over-entry","mouse-over-entry",-113766931),new cljs.core.Keyword(null,"entry","entry",505168823),p1__45493_SHARP_], null));
});})(selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid))
,new cljs.core.Keyword(null,"on-mouse-leave-bar","on-mouse-leave-bar",-941530087),((function (selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid){
return (function (){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"mouse-leave-entry","mouse-leave-entry",640549738)], null));
});})(selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid))
,new cljs.core.Keyword(null,"on-click-bar","on-click-bar",718637448),((function (selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid){
return (function (p1__45494_SHARP_){
return dispatch_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"edit-entry","edit-entry",-691961202),new cljs.core.Keyword(null,"entry-id","entry-id",591934358),p1__45494_SHARP_], null));
});})(selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid))
], null),opts);
return timi.client.activity.graphic.grid.render_row.call(null,selected_entry,instant_to_x,text,bars,opts_SINGLEQUOTE_,draw_result);
});})(selected_date,min_date,vec__45498,min_time,max_time,minutes_per_day,minutes_per_day__$1,pixels_per_minute,instant_to_x,iterate_day_grid))
;
var render_bars = cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_bars,instant_to_x);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"render-projects","render-projects",233824904),cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_projects,projects,render_row),new cljs.core.Keyword(null,"render-grid","render-grid",-812993066),cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_grid,iterate_day_grid,selected_date),new cljs.core.Keyword(null,"render-grid-labels","render-grid-labels",1370188481),cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_grid_labels,on_change_date,selected_date,min_time,max_time,iterate_day_grid),new cljs.core.Keyword(null,"render-now-indicator","render-now-indicator",-536403028),cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_now_indicator,instant_to_x,min_time,max_time),new cljs.core.Keyword(null,"render-day-summaries","render-day-summaries",-2015859993),cljs.core.partial.call(null,timi.client.activity.graphic.grid.render_day_summaries,render_bars,iterate_day_grid,projects)], null);
});
timi.client.activity.graphic.grid.render_svg = (function timi$client$activity$graphic$grid$render_svg(dispatch_BANG_,selected_date_str,projects,on_change_date,p__45501){
var map__45506 = p__45501;
var map__45506__$1 = ((((!((map__45506 == null)))?((((map__45506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45506.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45506):map__45506);
var opts = map__45506__$1;
var selected_entry = cljs.core.get.call(null,map__45506__$1,new cljs.core.Keyword(null,"selected-entry","selected-entry",642178636));
var map__45508 = timi.client.activity.graphic.grid.get_render_fns.call(null,dispatch_BANG_,selected_date_str,projects,selected_entry,on_change_date);
var map__45508__$1 = ((((!((map__45508 == null)))?((((map__45508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45508.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45508):map__45508);
var render_grid_labels = cljs.core.get.call(null,map__45508__$1,new cljs.core.Keyword(null,"render-grid-labels","render-grid-labels",1370188481));
var render_projects = cljs.core.get.call(null,map__45508__$1,new cljs.core.Keyword(null,"render-projects","render-projects",233824904));
var render_grid = cljs.core.get.call(null,map__45508__$1,new cljs.core.Keyword(null,"render-grid","render-grid",-812993066));
var render_now_indicator = cljs.core.get.call(null,map__45508__$1,new cljs.core.Keyword(null,"render-now-indicator","render-now-indicator",-536403028));
var render_day_summaries = cljs.core.get.call(null,map__45508__$1,new cljs.core.Keyword(null,"render-day-summaries","render-day-summaries",-2015859993));
var has_project_data_QMARK_ = cljs.core.seq.call(null,projects);
var draw_result = render_grid_labels.call(null,timi.client.activity.graphic.draw.result_empty.call(null));
var draw_result__$1 = ((has_project_data_QMARK_)?timi.client.activity.graphic.draw.result_add_to_y.call(null,timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"canvas","canvas",-1798817489),new cljs.core.Keyword(null,"bottom-padding-px","bottom-padding-px",-512265792)], null)),render_day_summaries.call(null,render_projects.call(null,draw_result))):timi.client.activity.graphic.draw.no_data_msg.call(null,draw_result));
var height = new cljs.core.Keyword(null,"y-offset","y-offset",-1716542).cljs$core$IFn$_invoke$arity$1(draw_result__$1);
var grid = render_now_indicator.call(null,height,render_grid.call(null,height,timi.client.activity.graphic.draw.result_empty.call(null)));
return cljs.core.apply.call(null,om.dom.svg,({"version": "1.1", "baseProfile": "full", "width": "100%", "height": height}),React.DOM.defs(({"dangerouslySetInnerHTML": ({"__html": timi.client.activity.graphic.draw.svg_glow.call(null,"hour-entry-active-glow",timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hour-entry","hour-entry",496551832),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"color","color",1011675173)], null)),new cljs.core.Keyword(null,"radius","radius",-2073122258),timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hour-entry","hour-entry",496551832),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"radius","radius",-2073122258)], null),(1)),new cljs.core.Keyword(null,"std-dev","std-dev",-1087996489),timi.client.activity.graphic.draw.const$.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"hour-entry","hour-entry",496551832),new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"std-dev","std-dev",-1087996489)], null),(1)))})})),cljs.core.concat.call(null,new cljs.core.Keyword(null,"els","els",-1382351487).cljs$core$IFn$_invoke$arity$1(grid),new cljs.core.Keyword(null,"els","els",-1382351487).cljs$core$IFn$_invoke$arity$1(draw_result__$1)));
});

//# sourceMappingURL=grid.js.map?rel=1495428386204