// Compiled by ClojureScript 1.9.542 {}
goog.provide('time.core');
goog.require('cljs.core');
goog.require('clojure.string');
time.core.LocalDate = JSJoda.LocalDate;
time.core.DayOfWeek = JSJoda.DayOfWeek;
time.core.parse_float = (function time$core$parse_float(v){
return parseFloat(v);
});
time.core.expand_time = (function time$core$expand_time(time_val){
var match_table = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/[0-9]{1}/,cljs.core.constantly.call(null,true),(function (p1__43643_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("0"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43643_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1(":00")].join('');
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/([0-9]{2})/,(function (_,hours){
return (time.core.parse_float.call(null,hours) < (24));
}),(function (p1__43644_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43644_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1(":00")].join('');
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/([0-9]{1})([0-9]{2})/,(function (_,hrs,mins){
return (time.core.parse_float.call(null,mins) < (60));
}),(function (_,hrs,mins){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("0"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hrs),cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mins)].join('');
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/([0-9]{2})([0-9]{2})/,(function (_,hrs,mins){
return ((time.core.parse_float.call(null,hrs) < (24))) && ((time.core.parse_float.call(null,mins) < (60)));
}),(function (_,hrs,mins){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(hrs),cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mins)].join('');
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/([0-9]{2}):/,(function (_,hrs){
return (time.core.parse_float.call(null,hrs) < (24));
}),(function (p1__43645_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43645_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("00")].join('');
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/([0-9]{2}):([0-9]{1})/,(function (_,hrs,mins){
return ((time.core.parse_float.call(null,hrs) < (24))) && ((time.core.parse_float.call(null,mins) < (6)));
}),(function (p1__43646_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43646_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("0")].join('');
})], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [/[0-9]{1}:([0-9]{2})/,(function (_,mins){
return (time.core.parse_float.call(null,mins) < (60));
}),(function (p1__43647_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("0"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__43647_SHARP_)].join('');
})], null)], null);
var match_entry = ((function (match_table){
return (function (v,p__43653){
var vec__43654 = p__43653;
var regex = cljs.core.nth.call(null,vec__43654,(0),null);
var pred_QMARK_ = cljs.core.nth.call(null,vec__43654,(1),null);
var make_value = cljs.core.nth.call(null,vec__43654,(2),null);
var match = cljs.core.re_matches.call(null,regex,v);
if(cljs.core.truth_((function (){var and__41162__auto__ = match;
if(cljs.core.truth_(and__41162__auto__)){
return cljs.core.apply.call(null,pred_QMARK_,match);
} else {
return and__41162__auto__;
}
})())){
return cljs.core.apply.call(null,make_value,match);
} else {
return null;
}
});})(match_table))
;
if((time_val == null)){
return time_val;
} else {
if(cljs.core.truth_(clojure.string.index_of.call(null,time_val,";"))){
return time.core.expand_time.call(null,clojure.string.replace.call(null,time_val,";",":"));
} else {
var temp__4655__auto__ = cljs.core.some.call(null,((function (match_table,match_entry){
return (function (p1__43648_SHARP_){
return match_entry.call(null,time_val,p1__43648_SHARP_);
});})(match_table,match_entry))
,match_table);
if(cljs.core.truth_(temp__4655__auto__)){
var match = temp__4655__auto__;
return match;
} else {
return time_val;
}

}
}
});
time.core.time_formatter = JSJoda.DateTimeFormatter.ofPattern("HH:mm");
time.core.str__GT_unix = (function time$core$str__GT_unix(date_str,time_str){
return JSJoda.LocalDate.parse(date_str).atTime(JSJoda.LocalTime.parse(time_str,time.core.time_formatter)).atZone(JSJoda.ZoneId.systemDefault()).toInstant().epochSecond();
});
time.core.unix__GT_time_str = (function time$core$unix__GT_time_str(epoch){
return JSJoda.LocalTime.ofInstant(JSJoda.Instant.ofEpochSecond(epoch)).format(time.core.time_formatter);
});
time.core.unix__GT_date_str = (function time$core$unix__GT_date_str(epoch){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSJoda.LocalDate.ofInstant(JSJoda.Instant.ofEpochSecond(epoch)))].join('');
});
time.core.try_parse_time = (function time$core$try_parse_time(v){
if(cljs.core._EQ_.call(null,v,"24:00")){
return null;
} else {
try{return JSJoda.LocalTime.from(time.core.time_formatter.parse(v));
}catch (e43658){if((e43658 instanceof Error)){
var e = e43658;
return null;
} else {
throw e43658;

}
}}
});
time.core.find_monday_before = (function time$core$find_monday_before(for_date){
while(true){
if(typeof for_date === 'string'){
var G__43659 = time.core.LocalDate.parse(for_date);
for_date = G__43659;
continue;
} else {
if(cljs.core._EQ_.call(null,for_date.dayOfWeek(),time.core.DayOfWeek.MONDAY)){
return for_date;
} else {
var G__43660 = for_date.plusDays((-1));
for_date = G__43660;
continue;
}
}
break;
}
});

//# sourceMappingURL=core.js.map?rel=1495428383040