// Compiled by ClojureScript 1.9.542 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.10";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args54068 = [];
var len__42287__auto___54071 = arguments.length;
var i__42288__auto___54072 = (0);
while(true){
if((i__42288__auto___54072 < len__42287__auto___54071)){
args54068.push((arguments[i__42288__auto___54072]));

var G__54073 = (i__42288__auto___54072 + (1));
i__42288__auto___54072 = G__54073;
continue;
} else {
}
break;
}

var G__54070 = args54068.length;
switch (G__54070) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args54068.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__42294__auto__ = [];
var len__42287__auto___54076 = arguments.length;
var i__42288__auto___54077 = (0);
while(true){
if((i__42288__auto___54077 < len__42287__auto___54076)){
args__42294__auto__.push((arguments[i__42288__auto___54077]));

var G__54078 = (i__42288__auto___54077 + (1));
i__42288__auto___54077 = G__54078;
continue;
} else {
}
break;
}

var argseq__42295__auto__ = ((((0) < args__42294__auto__.length))?(new cljs.core.IndexedSeq(args__42294__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__42295__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq54075){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq54075));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__42294__auto__ = [];
var len__42287__auto___54080 = arguments.length;
var i__42288__auto___54081 = (0);
while(true){
if((i__42288__auto___54081 < len__42287__auto___54080)){
args__42294__auto__.push((arguments[i__42288__auto___54081]));

var G__54082 = (i__42288__auto___54081 + (1));
i__42288__auto___54081 = G__54082;
continue;
} else {
}
break;
}

var argseq__42295__auto__ = ((((0) < args__42294__auto__.length))?(new cljs.core.IndexedSeq(args__42294__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__42295__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq54079){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq54079));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__54083){
var map__54086 = p__54083;
var map__54086__$1 = ((((!((map__54086 == null)))?((((map__54086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54086.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54086):map__54086);
var message = cljs.core.get.call(null,map__54086__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__54086__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__41174__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__41162__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__41162__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__41162__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__46724__auto___54248 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___54248,ch){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___54248,ch){
return (function (state_54217){
var state_val_54218 = (state_54217[(1)]);
if((state_val_54218 === (7))){
var inst_54213 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
var statearr_54219_54249 = state_54217__$1;
(statearr_54219_54249[(2)] = inst_54213);

(statearr_54219_54249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (1))){
var state_54217__$1 = state_54217;
var statearr_54220_54250 = state_54217__$1;
(statearr_54220_54250[(2)] = null);

(statearr_54220_54250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (4))){
var inst_54170 = (state_54217[(7)]);
var inst_54170__$1 = (state_54217[(2)]);
var state_54217__$1 = (function (){var statearr_54221 = state_54217;
(statearr_54221[(7)] = inst_54170__$1);

return statearr_54221;
})();
if(cljs.core.truth_(inst_54170__$1)){
var statearr_54222_54251 = state_54217__$1;
(statearr_54222_54251[(1)] = (5));

} else {
var statearr_54223_54252 = state_54217__$1;
(statearr_54223_54252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (15))){
var inst_54177 = (state_54217[(8)]);
var inst_54192 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_54177);
var inst_54193 = cljs.core.first.call(null,inst_54192);
var inst_54194 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_54193);
var inst_54195 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54194)].join('');
var inst_54196 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_54195);
var state_54217__$1 = state_54217;
var statearr_54224_54253 = state_54217__$1;
(statearr_54224_54253[(2)] = inst_54196);

(statearr_54224_54253[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (13))){
var inst_54201 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
var statearr_54225_54254 = state_54217__$1;
(statearr_54225_54254[(2)] = inst_54201);

(statearr_54225_54254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (6))){
var state_54217__$1 = state_54217;
var statearr_54226_54255 = state_54217__$1;
(statearr_54226_54255[(2)] = null);

(statearr_54226_54255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (17))){
var inst_54199 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
var statearr_54227_54256 = state_54217__$1;
(statearr_54227_54256[(2)] = inst_54199);

(statearr_54227_54256[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (3))){
var inst_54215 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54217__$1,inst_54215);
} else {
if((state_val_54218 === (12))){
var inst_54176 = (state_54217[(9)]);
var inst_54190 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_54176,opts);
var state_54217__$1 = state_54217;
if(cljs.core.truth_(inst_54190)){
var statearr_54228_54257 = state_54217__$1;
(statearr_54228_54257[(1)] = (15));

} else {
var statearr_54229_54258 = state_54217__$1;
(statearr_54229_54258[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (2))){
var state_54217__$1 = state_54217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54217__$1,(4),ch);
} else {
if((state_val_54218 === (11))){
var inst_54177 = (state_54217[(8)]);
var inst_54182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54183 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_54177);
var inst_54184 = cljs.core.async.timeout.call(null,(1000));
var inst_54185 = [inst_54183,inst_54184];
var inst_54186 = (new cljs.core.PersistentVector(null,2,(5),inst_54182,inst_54185,null));
var state_54217__$1 = state_54217;
return cljs.core.async.ioc_alts_BANG_.call(null,state_54217__$1,(14),inst_54186);
} else {
if((state_val_54218 === (9))){
var inst_54177 = (state_54217[(8)]);
var inst_54203 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_54204 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_54177);
var inst_54205 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_54204);
var inst_54206 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54205)].join('');
var inst_54207 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_54206);
var state_54217__$1 = (function (){var statearr_54230 = state_54217;
(statearr_54230[(10)] = inst_54203);

return statearr_54230;
})();
var statearr_54231_54259 = state_54217__$1;
(statearr_54231_54259[(2)] = inst_54207);

(statearr_54231_54259[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (5))){
var inst_54170 = (state_54217[(7)]);
var inst_54172 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_54173 = (new cljs.core.PersistentArrayMap(null,2,inst_54172,null));
var inst_54174 = (new cljs.core.PersistentHashSet(null,inst_54173,null));
var inst_54175 = figwheel.client.focus_msgs.call(null,inst_54174,inst_54170);
var inst_54176 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_54175);
var inst_54177 = cljs.core.first.call(null,inst_54175);
var inst_54178 = figwheel.client.autoload_QMARK_.call(null);
var state_54217__$1 = (function (){var statearr_54232 = state_54217;
(statearr_54232[(9)] = inst_54176);

(statearr_54232[(8)] = inst_54177);

return statearr_54232;
})();
if(cljs.core.truth_(inst_54178)){
var statearr_54233_54260 = state_54217__$1;
(statearr_54233_54260[(1)] = (8));

} else {
var statearr_54234_54261 = state_54217__$1;
(statearr_54234_54261[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (14))){
var inst_54188 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
var statearr_54235_54262 = state_54217__$1;
(statearr_54235_54262[(2)] = inst_54188);

(statearr_54235_54262[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (16))){
var state_54217__$1 = state_54217;
var statearr_54236_54263 = state_54217__$1;
(statearr_54236_54263[(2)] = null);

(statearr_54236_54263[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (10))){
var inst_54209 = (state_54217[(2)]);
var state_54217__$1 = (function (){var statearr_54237 = state_54217;
(statearr_54237[(11)] = inst_54209);

return statearr_54237;
})();
var statearr_54238_54264 = state_54217__$1;
(statearr_54238_54264[(2)] = null);

(statearr_54238_54264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (8))){
var inst_54176 = (state_54217[(9)]);
var inst_54180 = figwheel.client.reload_file_state_QMARK_.call(null,inst_54176,opts);
var state_54217__$1 = state_54217;
if(cljs.core.truth_(inst_54180)){
var statearr_54239_54265 = state_54217__$1;
(statearr_54239_54265[(1)] = (11));

} else {
var statearr_54240_54266 = state_54217__$1;
(statearr_54240_54266[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___54248,ch))
;
return ((function (switch__46612__auto__,c__46724__auto___54248,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__46613__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__46613__auto____0 = (function (){
var statearr_54244 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54244[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__46613__auto__);

(statearr_54244[(1)] = (1));

return statearr_54244;
});
var figwheel$client$file_reloader_plugin_$_state_machine__46613__auto____1 = (function (state_54217){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_54217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e54245){if((e54245 instanceof Object)){
var ex__46616__auto__ = e54245;
var statearr_54246_54267 = state_54217;
(statearr_54246_54267[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54217);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54268 = state_54217;
state_54217 = G__54268;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__46613__auto__ = function(state_54217){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__46613__auto____1.call(this,state_54217);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__46613__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__46613__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___54248,ch))
})();
var state__46726__auto__ = (function (){var statearr_54247 = f__46725__auto__.call(null);
(statearr_54247[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___54248);

return statearr_54247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___54248,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__54269_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__54269_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_54272 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_54272){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e54271){if((e54271 instanceof Error)){
var e = e54271;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_54272], null));
} else {
var e = e54271;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_54272))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__54273){
var map__54282 = p__54273;
var map__54282__$1 = ((((!((map__54282 == null)))?((((map__54282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54282.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54282):map__54282);
var opts = map__54282__$1;
var build_id = cljs.core.get.call(null,map__54282__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__54282,map__54282__$1,opts,build_id){
return (function (p__54284){
var vec__54285 = p__54284;
var seq__54286 = cljs.core.seq.call(null,vec__54285);
var first__54287 = cljs.core.first.call(null,seq__54286);
var seq__54286__$1 = cljs.core.next.call(null,seq__54286);
var map__54288 = first__54287;
var map__54288__$1 = ((((!((map__54288 == null)))?((((map__54288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54288.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54288):map__54288);
var msg = map__54288__$1;
var msg_name = cljs.core.get.call(null,map__54288__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__54286__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__54285,seq__54286,first__54287,seq__54286__$1,map__54288,map__54288__$1,msg,msg_name,_,map__54282,map__54282__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__54285,seq__54286,first__54287,seq__54286__$1,map__54288,map__54288__$1,msg,msg_name,_,map__54282,map__54282__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__54282,map__54282__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__54296){
var vec__54297 = p__54296;
var seq__54298 = cljs.core.seq.call(null,vec__54297);
var first__54299 = cljs.core.first.call(null,seq__54298);
var seq__54298__$1 = cljs.core.next.call(null,seq__54298);
var map__54300 = first__54299;
var map__54300__$1 = ((((!((map__54300 == null)))?((((map__54300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54300.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54300):map__54300);
var msg = map__54300__$1;
var msg_name = cljs.core.get.call(null,map__54300__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__54298__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__54302){
var map__54314 = p__54302;
var map__54314__$1 = ((((!((map__54314 == null)))?((((map__54314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54314.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54314):map__54314);
var on_compile_warning = cljs.core.get.call(null,map__54314__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__54314__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__54314,map__54314__$1,on_compile_warning,on_compile_fail){
return (function (p__54316){
var vec__54317 = p__54316;
var seq__54318 = cljs.core.seq.call(null,vec__54317);
var first__54319 = cljs.core.first.call(null,seq__54318);
var seq__54318__$1 = cljs.core.next.call(null,seq__54318);
var map__54320 = first__54319;
var map__54320__$1 = ((((!((map__54320 == null)))?((((map__54320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54320.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54320):map__54320);
var msg = map__54320__$1;
var msg_name = cljs.core.get.call(null,map__54320__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__54318__$1;
var pred__54322 = cljs.core._EQ_;
var expr__54323 = msg_name;
if(cljs.core.truth_(pred__54322.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__54323))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__54322.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__54323))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__54314,map__54314__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__,msg_hist,msg_names,msg){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__,msg_hist,msg_names,msg){
return (function (state_54551){
var state_val_54552 = (state_54551[(1)]);
if((state_val_54552 === (7))){
var inst_54471 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54471)){
var statearr_54553_54603 = state_54551__$1;
(statearr_54553_54603[(1)] = (8));

} else {
var statearr_54554_54604 = state_54551__$1;
(statearr_54554_54604[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (20))){
var inst_54545 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54555_54605 = state_54551__$1;
(statearr_54555_54605[(2)] = inst_54545);

(statearr_54555_54605[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (27))){
var inst_54541 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54556_54606 = state_54551__$1;
(statearr_54556_54606[(2)] = inst_54541);

(statearr_54556_54606[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (1))){
var inst_54464 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54464)){
var statearr_54557_54607 = state_54551__$1;
(statearr_54557_54607[(1)] = (2));

} else {
var statearr_54558_54608 = state_54551__$1;
(statearr_54558_54608[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (24))){
var inst_54543 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54559_54609 = state_54551__$1;
(statearr_54559_54609[(2)] = inst_54543);

(statearr_54559_54609[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (4))){
var inst_54549 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54551__$1,inst_54549);
} else {
if((state_val_54552 === (15))){
var inst_54547 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54560_54610 = state_54551__$1;
(statearr_54560_54610[(2)] = inst_54547);

(statearr_54560_54610[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (21))){
var inst_54500 = (state_54551[(2)]);
var inst_54501 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54502 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54501);
var state_54551__$1 = (function (){var statearr_54561 = state_54551;
(statearr_54561[(7)] = inst_54500);

return statearr_54561;
})();
var statearr_54562_54611 = state_54551__$1;
(statearr_54562_54611[(2)] = inst_54502);

(statearr_54562_54611[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (31))){
var inst_54530 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54530)){
var statearr_54563_54612 = state_54551__$1;
(statearr_54563_54612[(1)] = (34));

} else {
var statearr_54564_54613 = state_54551__$1;
(statearr_54564_54613[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (32))){
var inst_54539 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54565_54614 = state_54551__$1;
(statearr_54565_54614[(2)] = inst_54539);

(statearr_54565_54614[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (33))){
var inst_54526 = (state_54551[(2)]);
var inst_54527 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54528 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54527);
var state_54551__$1 = (function (){var statearr_54566 = state_54551;
(statearr_54566[(8)] = inst_54526);

return statearr_54566;
})();
var statearr_54567_54615 = state_54551__$1;
(statearr_54567_54615[(2)] = inst_54528);

(statearr_54567_54615[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (13))){
var inst_54485 = figwheel.client.heads_up.clear.call(null);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(16),inst_54485);
} else {
if((state_val_54552 === (22))){
var inst_54506 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54507 = figwheel.client.heads_up.append_warning_message.call(null,inst_54506);
var state_54551__$1 = state_54551;
var statearr_54568_54616 = state_54551__$1;
(statearr_54568_54616[(2)] = inst_54507);

(statearr_54568_54616[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (36))){
var inst_54537 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54569_54617 = state_54551__$1;
(statearr_54569_54617[(2)] = inst_54537);

(statearr_54569_54617[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (29))){
var inst_54517 = (state_54551[(2)]);
var inst_54518 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54519 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54518);
var state_54551__$1 = (function (){var statearr_54570 = state_54551;
(statearr_54570[(9)] = inst_54517);

return statearr_54570;
})();
var statearr_54571_54618 = state_54551__$1;
(statearr_54571_54618[(2)] = inst_54519);

(statearr_54571_54618[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (6))){
var inst_54466 = (state_54551[(10)]);
var state_54551__$1 = state_54551;
var statearr_54572_54619 = state_54551__$1;
(statearr_54572_54619[(2)] = inst_54466);

(statearr_54572_54619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (28))){
var inst_54513 = (state_54551[(2)]);
var inst_54514 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54515 = figwheel.client.heads_up.display_warning.call(null,inst_54514);
var state_54551__$1 = (function (){var statearr_54573 = state_54551;
(statearr_54573[(11)] = inst_54513);

return statearr_54573;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(29),inst_54515);
} else {
if((state_val_54552 === (25))){
var inst_54511 = figwheel.client.heads_up.clear.call(null);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(28),inst_54511);
} else {
if((state_val_54552 === (34))){
var inst_54532 = figwheel.client.heads_up.flash_loaded.call(null);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(37),inst_54532);
} else {
if((state_val_54552 === (17))){
var inst_54491 = (state_54551[(2)]);
var inst_54492 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54493 = figwheel.client.auto_jump_to_error.call(null,opts,inst_54492);
var state_54551__$1 = (function (){var statearr_54574 = state_54551;
(statearr_54574[(12)] = inst_54491);

return statearr_54574;
})();
var statearr_54575_54620 = state_54551__$1;
(statearr_54575_54620[(2)] = inst_54493);

(statearr_54575_54620[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (3))){
var inst_54483 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54483)){
var statearr_54576_54621 = state_54551__$1;
(statearr_54576_54621[(1)] = (13));

} else {
var statearr_54577_54622 = state_54551__$1;
(statearr_54577_54622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (12))){
var inst_54479 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54578_54623 = state_54551__$1;
(statearr_54578_54623[(2)] = inst_54479);

(statearr_54578_54623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (2))){
var inst_54466 = (state_54551[(10)]);
var inst_54466__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_54551__$1 = (function (){var statearr_54579 = state_54551;
(statearr_54579[(10)] = inst_54466__$1);

return statearr_54579;
})();
if(cljs.core.truth_(inst_54466__$1)){
var statearr_54580_54624 = state_54551__$1;
(statearr_54580_54624[(1)] = (5));

} else {
var statearr_54581_54625 = state_54551__$1;
(statearr_54581_54625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (23))){
var inst_54509 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54509)){
var statearr_54582_54626 = state_54551__$1;
(statearr_54582_54626[(1)] = (25));

} else {
var statearr_54583_54627 = state_54551__$1;
(statearr_54583_54627[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (35))){
var state_54551__$1 = state_54551;
var statearr_54584_54628 = state_54551__$1;
(statearr_54584_54628[(2)] = null);

(statearr_54584_54628[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (19))){
var inst_54504 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54504)){
var statearr_54585_54629 = state_54551__$1;
(statearr_54585_54629[(1)] = (22));

} else {
var statearr_54586_54630 = state_54551__$1;
(statearr_54586_54630[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (11))){
var inst_54475 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54587_54631 = state_54551__$1;
(statearr_54587_54631[(2)] = inst_54475);

(statearr_54587_54631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (9))){
var inst_54477 = figwheel.client.heads_up.clear.call(null);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(12),inst_54477);
} else {
if((state_val_54552 === (5))){
var inst_54468 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_54551__$1 = state_54551;
var statearr_54588_54632 = state_54551__$1;
(statearr_54588_54632[(2)] = inst_54468);

(statearr_54588_54632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (14))){
var inst_54495 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54495)){
var statearr_54589_54633 = state_54551__$1;
(statearr_54589_54633[(1)] = (18));

} else {
var statearr_54590_54634 = state_54551__$1;
(statearr_54590_54634[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (26))){
var inst_54521 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_54551__$1 = state_54551;
if(cljs.core.truth_(inst_54521)){
var statearr_54591_54635 = state_54551__$1;
(statearr_54591_54635[(1)] = (30));

} else {
var statearr_54592_54636 = state_54551__$1;
(statearr_54592_54636[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (16))){
var inst_54487 = (state_54551[(2)]);
var inst_54488 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54489 = figwheel.client.heads_up.display_exception.call(null,inst_54488);
var state_54551__$1 = (function (){var statearr_54593 = state_54551;
(statearr_54593[(13)] = inst_54487);

return statearr_54593;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(17),inst_54489);
} else {
if((state_val_54552 === (30))){
var inst_54523 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54524 = figwheel.client.heads_up.display_warning.call(null,inst_54523);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(33),inst_54524);
} else {
if((state_val_54552 === (10))){
var inst_54481 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54594_54637 = state_54551__$1;
(statearr_54594_54637[(2)] = inst_54481);

(statearr_54594_54637[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (18))){
var inst_54497 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_54498 = figwheel.client.heads_up.display_exception.call(null,inst_54497);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(21),inst_54498);
} else {
if((state_val_54552 === (37))){
var inst_54534 = (state_54551[(2)]);
var state_54551__$1 = state_54551;
var statearr_54595_54638 = state_54551__$1;
(statearr_54595_54638[(2)] = inst_54534);

(statearr_54595_54638[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54552 === (8))){
var inst_54473 = figwheel.client.heads_up.flash_loaded.call(null);
var state_54551__$1 = state_54551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54551__$1,(11),inst_54473);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__46612__auto__,c__46724__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto____0 = (function (){
var statearr_54599 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54599[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto__);

(statearr_54599[(1)] = (1));

return statearr_54599;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto____1 = (function (state_54551){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_54551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e54600){if((e54600 instanceof Object)){
var ex__46616__auto__ = e54600;
var statearr_54601_54639 = state_54551;
(statearr_54601_54639[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54600;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54640 = state_54551;
state_54551 = G__54640;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto__ = function(state_54551){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto____1.call(this,state_54551);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__,msg_hist,msg_names,msg))
})();
var state__46726__auto__ = (function (){var statearr_54602 = f__46725__auto__.call(null);
(statearr_54602[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_54602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__,msg_hist,msg_names,msg))
);

return c__46724__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__46724__auto___54703 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___54703,ch){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___54703,ch){
return (function (state_54686){
var state_val_54687 = (state_54686[(1)]);
if((state_val_54687 === (1))){
var state_54686__$1 = state_54686;
var statearr_54688_54704 = state_54686__$1;
(statearr_54688_54704[(2)] = null);

(statearr_54688_54704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (2))){
var state_54686__$1 = state_54686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54686__$1,(4),ch);
} else {
if((state_val_54687 === (3))){
var inst_54684 = (state_54686[(2)]);
var state_54686__$1 = state_54686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54686__$1,inst_54684);
} else {
if((state_val_54687 === (4))){
var inst_54674 = (state_54686[(7)]);
var inst_54674__$1 = (state_54686[(2)]);
var state_54686__$1 = (function (){var statearr_54689 = state_54686;
(statearr_54689[(7)] = inst_54674__$1);

return statearr_54689;
})();
if(cljs.core.truth_(inst_54674__$1)){
var statearr_54690_54705 = state_54686__$1;
(statearr_54690_54705[(1)] = (5));

} else {
var statearr_54691_54706 = state_54686__$1;
(statearr_54691_54706[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (5))){
var inst_54674 = (state_54686[(7)]);
var inst_54676 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_54674);
var state_54686__$1 = state_54686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54686__$1,(8),inst_54676);
} else {
if((state_val_54687 === (6))){
var state_54686__$1 = state_54686;
var statearr_54692_54707 = state_54686__$1;
(statearr_54692_54707[(2)] = null);

(statearr_54692_54707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (7))){
var inst_54682 = (state_54686[(2)]);
var state_54686__$1 = state_54686;
var statearr_54693_54708 = state_54686__$1;
(statearr_54693_54708[(2)] = inst_54682);

(statearr_54693_54708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (8))){
var inst_54678 = (state_54686[(2)]);
var state_54686__$1 = (function (){var statearr_54694 = state_54686;
(statearr_54694[(8)] = inst_54678);

return statearr_54694;
})();
var statearr_54695_54709 = state_54686__$1;
(statearr_54695_54709[(2)] = null);

(statearr_54695_54709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__46724__auto___54703,ch))
;
return ((function (switch__46612__auto__,c__46724__auto___54703,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__46613__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__46613__auto____0 = (function (){
var statearr_54699 = [null,null,null,null,null,null,null,null,null];
(statearr_54699[(0)] = figwheel$client$heads_up_plugin_$_state_machine__46613__auto__);

(statearr_54699[(1)] = (1));

return statearr_54699;
});
var figwheel$client$heads_up_plugin_$_state_machine__46613__auto____1 = (function (state_54686){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_54686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e54700){if((e54700 instanceof Object)){
var ex__46616__auto__ = e54700;
var statearr_54701_54710 = state_54686;
(statearr_54701_54710[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54686);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54700;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54711 = state_54686;
state_54686 = G__54711;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__46613__auto__ = function(state_54686){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__46613__auto____1.call(this,state_54686);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__46613__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__46613__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___54703,ch))
})();
var state__46726__auto__ = (function (){var statearr_54702 = f__46725__auto__.call(null);
(statearr_54702[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___54703);

return statearr_54702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___54703,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__){
return (function (state_54732){
var state_val_54733 = (state_54732[(1)]);
if((state_val_54733 === (1))){
var inst_54727 = cljs.core.async.timeout.call(null,(3000));
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54732__$1,(2),inst_54727);
} else {
if((state_val_54733 === (2))){
var inst_54729 = (state_54732[(2)]);
var inst_54730 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_54732__$1 = (function (){var statearr_54734 = state_54732;
(statearr_54734[(7)] = inst_54729);

return statearr_54734;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54732__$1,inst_54730);
} else {
return null;
}
}
});})(c__46724__auto__))
;
return ((function (switch__46612__auto__,c__46724__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__46613__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__46613__auto____0 = (function (){
var statearr_54738 = [null,null,null,null,null,null,null,null];
(statearr_54738[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__46613__auto__);

(statearr_54738[(1)] = (1));

return statearr_54738;
});
var figwheel$client$enforce_project_plugin_$_state_machine__46613__auto____1 = (function (state_54732){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_54732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e54739){if((e54739 instanceof Object)){
var ex__46616__auto__ = e54739;
var statearr_54740_54742 = state_54732;
(statearr_54740_54742[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54732);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54739;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54743 = state_54732;
state_54732 = G__54743;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__46613__auto__ = function(state_54732){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__46613__auto____1.call(this,state_54732);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__46613__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__46613__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__))
})();
var state__46726__auto__ = (function (){var statearr_54741 = f__46725__auto__.call(null);
(statearr_54741[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_54741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__))
);

return c__46724__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__,figwheel_version,temp__4657__auto__){
return (function (state_54766){
var state_val_54767 = (state_54766[(1)]);
if((state_val_54767 === (1))){
var inst_54760 = cljs.core.async.timeout.call(null,(2000));
var state_54766__$1 = state_54766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54766__$1,(2),inst_54760);
} else {
if((state_val_54767 === (2))){
var inst_54762 = (state_54766[(2)]);
var inst_54763 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_54764 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_54763);
var state_54766__$1 = (function (){var statearr_54768 = state_54766;
(statearr_54768[(7)] = inst_54762);

return statearr_54768;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54766__$1,inst_54764);
} else {
return null;
}
}
});})(c__46724__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__46612__auto__,c__46724__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto____0 = (function (){
var statearr_54772 = [null,null,null,null,null,null,null,null];
(statearr_54772[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto__);

(statearr_54772[(1)] = (1));

return statearr_54772;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto____1 = (function (state_54766){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_54766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e54773){if((e54773 instanceof Object)){
var ex__46616__auto__ = e54773;
var statearr_54774_54776 = state_54766;
(statearr_54774_54776[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_54766);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e54773;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54777 = state_54766;
state_54766 = G__54777;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto__ = function(state_54766){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto____1.call(this,state_54766);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__,figwheel_version,temp__4657__auto__))
})();
var state__46726__auto__ = (function (){var statearr_54775 = f__46725__auto__.call(null);
(statearr_54775[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_54775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__,figwheel_version,temp__4657__auto__))
);

return c__46724__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__54778){
var map__54782 = p__54778;
var map__54782__$1 = ((((!((map__54782 == null)))?((((map__54782.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54782.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54782):map__54782);
var file = cljs.core.get.call(null,map__54782__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__54782__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__54782__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__54784 = "";
var G__54784__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54784),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__54784);
var G__54784__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54784__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__54784__$1);
if(cljs.core.truth_((function (){var and__41162__auto__ = line;
if(cljs.core.truth_(and__41162__auto__)){
return column;
} else {
return and__41162__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54784__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__54784__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__54785){
var map__54792 = p__54785;
var map__54792__$1 = ((((!((map__54792 == null)))?((((map__54792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54792.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54792):map__54792);
var ed = map__54792__$1;
var formatted_exception = cljs.core.get.call(null,map__54792__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__54792__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__54792__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__54794_54798 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__54795_54799 = null;
var count__54796_54800 = (0);
var i__54797_54801 = (0);
while(true){
if((i__54797_54801 < count__54796_54800)){
var msg_54802 = cljs.core._nth.call(null,chunk__54795_54799,i__54797_54801);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_54802);

var G__54803 = seq__54794_54798;
var G__54804 = chunk__54795_54799;
var G__54805 = count__54796_54800;
var G__54806 = (i__54797_54801 + (1));
seq__54794_54798 = G__54803;
chunk__54795_54799 = G__54804;
count__54796_54800 = G__54805;
i__54797_54801 = G__54806;
continue;
} else {
var temp__4657__auto___54807 = cljs.core.seq.call(null,seq__54794_54798);
if(temp__4657__auto___54807){
var seq__54794_54808__$1 = temp__4657__auto___54807;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54794_54808__$1)){
var c__41993__auto___54809 = cljs.core.chunk_first.call(null,seq__54794_54808__$1);
var G__54810 = cljs.core.chunk_rest.call(null,seq__54794_54808__$1);
var G__54811 = c__41993__auto___54809;
var G__54812 = cljs.core.count.call(null,c__41993__auto___54809);
var G__54813 = (0);
seq__54794_54798 = G__54810;
chunk__54795_54799 = G__54811;
count__54796_54800 = G__54812;
i__54797_54801 = G__54813;
continue;
} else {
var msg_54814 = cljs.core.first.call(null,seq__54794_54808__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_54814);

var G__54815 = cljs.core.next.call(null,seq__54794_54808__$1);
var G__54816 = null;
var G__54817 = (0);
var G__54818 = (0);
seq__54794_54798 = G__54815;
chunk__54795_54799 = G__54816;
count__54796_54800 = G__54817;
i__54797_54801 = G__54818;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__54819){
var map__54822 = p__54819;
var map__54822__$1 = ((((!((map__54822 == null)))?((((map__54822.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54822.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54822):map__54822);
var w = map__54822__$1;
var message = cljs.core.get.call(null,map__54822__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/dist/cljs/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/dist/cljs/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__41162__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__41162__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__41162__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__54834 = cljs.core.seq.call(null,plugins);
var chunk__54835 = null;
var count__54836 = (0);
var i__54837 = (0);
while(true){
if((i__54837 < count__54836)){
var vec__54838 = cljs.core._nth.call(null,chunk__54835,i__54837);
var k = cljs.core.nth.call(null,vec__54838,(0),null);
var plugin = cljs.core.nth.call(null,vec__54838,(1),null);
if(cljs.core.truth_(plugin)){
var pl_54844 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__54834,chunk__54835,count__54836,i__54837,pl_54844,vec__54838,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_54844.call(null,msg_hist);
});})(seq__54834,chunk__54835,count__54836,i__54837,pl_54844,vec__54838,k,plugin))
);
} else {
}

var G__54845 = seq__54834;
var G__54846 = chunk__54835;
var G__54847 = count__54836;
var G__54848 = (i__54837 + (1));
seq__54834 = G__54845;
chunk__54835 = G__54846;
count__54836 = G__54847;
i__54837 = G__54848;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__54834);
if(temp__4657__auto__){
var seq__54834__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54834__$1)){
var c__41993__auto__ = cljs.core.chunk_first.call(null,seq__54834__$1);
var G__54849 = cljs.core.chunk_rest.call(null,seq__54834__$1);
var G__54850 = c__41993__auto__;
var G__54851 = cljs.core.count.call(null,c__41993__auto__);
var G__54852 = (0);
seq__54834 = G__54849;
chunk__54835 = G__54850;
count__54836 = G__54851;
i__54837 = G__54852;
continue;
} else {
var vec__54841 = cljs.core.first.call(null,seq__54834__$1);
var k = cljs.core.nth.call(null,vec__54841,(0),null);
var plugin = cljs.core.nth.call(null,vec__54841,(1),null);
if(cljs.core.truth_(plugin)){
var pl_54853 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__54834,chunk__54835,count__54836,i__54837,pl_54853,vec__54841,k,plugin,seq__54834__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_54853.call(null,msg_hist);
});})(seq__54834,chunk__54835,count__54836,i__54837,pl_54853,vec__54841,k,plugin,seq__54834__$1,temp__4657__auto__))
);
} else {
}

var G__54854 = cljs.core.next.call(null,seq__54834__$1);
var G__54855 = null;
var G__54856 = (0);
var G__54857 = (0);
seq__54834 = G__54854;
chunk__54835 = G__54855;
count__54836 = G__54856;
i__54837 = G__54857;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args54858 = [];
var len__42287__auto___54865 = arguments.length;
var i__42288__auto___54866 = (0);
while(true){
if((i__42288__auto___54866 < len__42287__auto___54865)){
args54858.push((arguments[i__42288__auto___54866]));

var G__54867 = (i__42288__auto___54866 + (1));
i__42288__auto___54866 = G__54867;
continue;
} else {
}
break;
}

var G__54860 = args54858.length;
switch (G__54860) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args54858.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__54861_54869 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__54862_54870 = null;
var count__54863_54871 = (0);
var i__54864_54872 = (0);
while(true){
if((i__54864_54872 < count__54863_54871)){
var msg_54873 = cljs.core._nth.call(null,chunk__54862_54870,i__54864_54872);
figwheel.client.socket.handle_incoming_message.call(null,msg_54873);

var G__54874 = seq__54861_54869;
var G__54875 = chunk__54862_54870;
var G__54876 = count__54863_54871;
var G__54877 = (i__54864_54872 + (1));
seq__54861_54869 = G__54874;
chunk__54862_54870 = G__54875;
count__54863_54871 = G__54876;
i__54864_54872 = G__54877;
continue;
} else {
var temp__4657__auto___54878 = cljs.core.seq.call(null,seq__54861_54869);
if(temp__4657__auto___54878){
var seq__54861_54879__$1 = temp__4657__auto___54878;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__54861_54879__$1)){
var c__41993__auto___54880 = cljs.core.chunk_first.call(null,seq__54861_54879__$1);
var G__54881 = cljs.core.chunk_rest.call(null,seq__54861_54879__$1);
var G__54882 = c__41993__auto___54880;
var G__54883 = cljs.core.count.call(null,c__41993__auto___54880);
var G__54884 = (0);
seq__54861_54869 = G__54881;
chunk__54862_54870 = G__54882;
count__54863_54871 = G__54883;
i__54864_54872 = G__54884;
continue;
} else {
var msg_54885 = cljs.core.first.call(null,seq__54861_54879__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_54885);

var G__54886 = cljs.core.next.call(null,seq__54861_54879__$1);
var G__54887 = null;
var G__54888 = (0);
var G__54889 = (0);
seq__54861_54869 = G__54886;
chunk__54862_54870 = G__54887;
count__54863_54871 = G__54888;
i__54864_54872 = G__54889;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__42294__auto__ = [];
var len__42287__auto___54894 = arguments.length;
var i__42288__auto___54895 = (0);
while(true){
if((i__42288__auto___54895 < len__42287__auto___54894)){
args__42294__auto__.push((arguments[i__42288__auto___54895]));

var G__54896 = (i__42288__auto___54895 + (1));
i__42288__auto___54895 = G__54896;
continue;
} else {
}
break;
}

var argseq__42295__auto__ = ((((0) < args__42294__auto__.length))?(new cljs.core.IndexedSeq(args__42294__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__42295__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__54891){
var map__54892 = p__54891;
var map__54892__$1 = ((((!((map__54892 == null)))?((((map__54892.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54892.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54892):map__54892);
var opts = map__54892__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq54890){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq54890));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e54898){if((e54898 instanceof Error)){
var e = e54898;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e54898;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__54902){
var map__54903 = p__54902;
var map__54903__$1 = ((((!((map__54903 == null)))?((((map__54903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54903.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__54903):map__54903);
var msg_name = cljs.core.get.call(null,map__54903__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1495428394995