// Compiled by ClojureScript 1.9.542 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args46769 = [];
var len__42287__auto___46775 = arguments.length;
var i__42288__auto___46776 = (0);
while(true){
if((i__42288__auto___46776 < len__42287__auto___46775)){
args46769.push((arguments[i__42288__auto___46776]));

var G__46777 = (i__42288__auto___46776 + (1));
i__42288__auto___46776 = G__46777;
continue;
} else {
}
break;
}

var G__46771 = args46769.length;
switch (G__46771) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46769.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async46772 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46772 = (function (f,blockable,meta46773){
this.f = f;
this.blockable = blockable;
this.meta46773 = meta46773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46774,meta46773__$1){
var self__ = this;
var _46774__$1 = this;
return (new cljs.core.async.t_cljs$core$async46772(self__.f,self__.blockable,meta46773__$1));
});

cljs.core.async.t_cljs$core$async46772.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46774){
var self__ = this;
var _46774__$1 = this;
return self__.meta46773;
});

cljs.core.async.t_cljs$core$async46772.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46772.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async46772.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async46772.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async46772.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta46773","meta46773",678749074,null)], null);
});

cljs.core.async.t_cljs$core$async46772.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46772.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46772";

cljs.core.async.t_cljs$core$async46772.cljs$lang$ctorPrWriter = (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async46772");
});

cljs.core.async.__GT_t_cljs$core$async46772 = (function cljs$core$async$__GT_t_cljs$core$async46772(f__$1,blockable__$1,meta46773){
return (new cljs.core.async.t_cljs$core$async46772(f__$1,blockable__$1,meta46773));
});

}

return (new cljs.core.async.t_cljs$core$async46772(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args46781 = [];
var len__42287__auto___46784 = arguments.length;
var i__42288__auto___46785 = (0);
while(true){
if((i__42288__auto___46785 < len__42287__auto___46784)){
args46781.push((arguments[i__42288__auto___46785]));

var G__46786 = (i__42288__auto___46785 + (1));
i__42288__auto___46785 = G__46786;
continue;
} else {
}
break;
}

var G__46783 = args46781.length;
switch (G__46783) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46781.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args46788 = [];
var len__42287__auto___46791 = arguments.length;
var i__42288__auto___46792 = (0);
while(true){
if((i__42288__auto___46792 < len__42287__auto___46791)){
args46788.push((arguments[i__42288__auto___46792]));

var G__46793 = (i__42288__auto___46792 + (1));
i__42288__auto___46792 = G__46793;
continue;
} else {
}
break;
}

var G__46790 = args46788.length;
switch (G__46790) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46788.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args46795 = [];
var len__42287__auto___46798 = arguments.length;
var i__42288__auto___46799 = (0);
while(true){
if((i__42288__auto___46799 < len__42287__auto___46798)){
args46795.push((arguments[i__42288__auto___46799]));

var G__46800 = (i__42288__auto___46799 + (1));
i__42288__auto___46799 = G__46800;
continue;
} else {
}
break;
}

var G__46797 = args46795.length;
switch (G__46797) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46795.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_46802 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_46802);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_46802,ret){
return (function (){
return fn1.call(null,val_46802);
});})(val_46802,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args46803 = [];
var len__42287__auto___46806 = arguments.length;
var i__42288__auto___46807 = (0);
while(true){
if((i__42288__auto___46807 < len__42287__auto___46806)){
args46803.push((arguments[i__42288__auto___46807]));

var G__46808 = (i__42288__auto___46807 + (1));
i__42288__auto___46807 = G__46808;
continue;
} else {
}
break;
}

var G__46805 = args46803.length;
switch (G__46805) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46803.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__42097__auto___46810 = n;
var x_46811 = (0);
while(true){
if((x_46811 < n__42097__auto___46810)){
(a[x_46811] = (0));

var G__46812 = (x_46811 + (1));
x_46811 = G__46812;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__46813 = (i + (1));
i = G__46813;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async46817 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46817 = (function (flag,meta46818){
this.flag = flag;
this.meta46818 = meta46818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_46819,meta46818__$1){
var self__ = this;
var _46819__$1 = this;
return (new cljs.core.async.t_cljs$core$async46817(self__.flag,meta46818__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async46817.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_46819){
var self__ = this;
var _46819__$1 = this;
return self__.meta46818;
});})(flag))
;

cljs.core.async.t_cljs$core$async46817.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46817.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async46817.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async46817.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async46817.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta46818","meta46818",611045506,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async46817.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46817.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46817";

cljs.core.async.t_cljs$core$async46817.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async46817");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async46817 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async46817(flag__$1,meta46818){
return (new cljs.core.async.t_cljs$core$async46817(flag__$1,meta46818));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async46817(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async46823 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46823 = (function (flag,cb,meta46824){
this.flag = flag;
this.cb = cb;
this.meta46824 = meta46824;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async46823.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46825,meta46824__$1){
var self__ = this;
var _46825__$1 = this;
return (new cljs.core.async.t_cljs$core$async46823(self__.flag,self__.cb,meta46824__$1));
});

cljs.core.async.t_cljs$core$async46823.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46825){
var self__ = this;
var _46825__$1 = this;
return self__.meta46824;
});

cljs.core.async.t_cljs$core$async46823.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46823.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async46823.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async46823.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async46823.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta46824","meta46824",1761787442,null)], null);
});

cljs.core.async.t_cljs$core$async46823.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46823.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46823";

cljs.core.async.t_cljs$core$async46823.cljs$lang$ctorPrWriter = (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async46823");
});

cljs.core.async.__GT_t_cljs$core$async46823 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async46823(flag__$1,cb__$1,meta46824){
return (new cljs.core.async.t_cljs$core$async46823(flag__$1,cb__$1,meta46824));
});

}

return (new cljs.core.async.t_cljs$core$async46823(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46826_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46826_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46827_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46827_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__41174__auto__ = wport;
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46828 = (i + (1));
i = G__46828;
continue;
}
} else {
return null;
}
break;
}
})();
var or__41174__auto__ = ret;
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__41162__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__41162__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__41162__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__42294__auto__ = [];
var len__42287__auto___46834 = arguments.length;
var i__42288__auto___46835 = (0);
while(true){
if((i__42288__auto___46835 < len__42287__auto___46834)){
args__42294__auto__.push((arguments[i__42288__auto___46835]));

var G__46836 = (i__42288__auto___46835 + (1));
i__42288__auto___46835 = G__46836;
continue;
} else {
}
break;
}

var argseq__42295__auto__ = ((((1) < args__42294__auto__.length))?(new cljs.core.IndexedSeq(args__42294__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__42295__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__46831){
var map__46832 = p__46831;
var map__46832__$1 = ((((!((map__46832 == null)))?((((map__46832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46832.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46832):map__46832);
var opts = map__46832__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq46829){
var G__46830 = cljs.core.first.call(null,seq46829);
var seq46829__$1 = cljs.core.next.call(null,seq46829);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__46830,seq46829__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args46837 = [];
var len__42287__auto___46887 = arguments.length;
var i__42288__auto___46888 = (0);
while(true){
if((i__42288__auto___46888 < len__42287__auto___46887)){
args46837.push((arguments[i__42288__auto___46888]));

var G__46889 = (i__42288__auto___46888 + (1));
i__42288__auto___46888 = G__46889;
continue;
} else {
}
break;
}

var G__46839 = args46837.length;
switch (G__46839) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args46837.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__46724__auto___46891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___46891){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___46891){
return (function (state_46863){
var state_val_46864 = (state_46863[(1)]);
if((state_val_46864 === (7))){
var inst_46859 = (state_46863[(2)]);
var state_46863__$1 = state_46863;
var statearr_46865_46892 = state_46863__$1;
(statearr_46865_46892[(2)] = inst_46859);

(statearr_46865_46892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (1))){
var state_46863__$1 = state_46863;
var statearr_46866_46893 = state_46863__$1;
(statearr_46866_46893[(2)] = null);

(statearr_46866_46893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (4))){
var inst_46842 = (state_46863[(7)]);
var inst_46842__$1 = (state_46863[(2)]);
var inst_46843 = (inst_46842__$1 == null);
var state_46863__$1 = (function (){var statearr_46867 = state_46863;
(statearr_46867[(7)] = inst_46842__$1);

return statearr_46867;
})();
if(cljs.core.truth_(inst_46843)){
var statearr_46868_46894 = state_46863__$1;
(statearr_46868_46894[(1)] = (5));

} else {
var statearr_46869_46895 = state_46863__$1;
(statearr_46869_46895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (13))){
var state_46863__$1 = state_46863;
var statearr_46870_46896 = state_46863__$1;
(statearr_46870_46896[(2)] = null);

(statearr_46870_46896[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (6))){
var inst_46842 = (state_46863[(7)]);
var state_46863__$1 = state_46863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46863__$1,(11),to,inst_46842);
} else {
if((state_val_46864 === (3))){
var inst_46861 = (state_46863[(2)]);
var state_46863__$1 = state_46863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46863__$1,inst_46861);
} else {
if((state_val_46864 === (12))){
var state_46863__$1 = state_46863;
var statearr_46871_46897 = state_46863__$1;
(statearr_46871_46897[(2)] = null);

(statearr_46871_46897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (2))){
var state_46863__$1 = state_46863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46863__$1,(4),from);
} else {
if((state_val_46864 === (11))){
var inst_46852 = (state_46863[(2)]);
var state_46863__$1 = state_46863;
if(cljs.core.truth_(inst_46852)){
var statearr_46872_46898 = state_46863__$1;
(statearr_46872_46898[(1)] = (12));

} else {
var statearr_46873_46899 = state_46863__$1;
(statearr_46873_46899[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (9))){
var state_46863__$1 = state_46863;
var statearr_46874_46900 = state_46863__$1;
(statearr_46874_46900[(2)] = null);

(statearr_46874_46900[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (5))){
var state_46863__$1 = state_46863;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46875_46901 = state_46863__$1;
(statearr_46875_46901[(1)] = (8));

} else {
var statearr_46876_46902 = state_46863__$1;
(statearr_46876_46902[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (14))){
var inst_46857 = (state_46863[(2)]);
var state_46863__$1 = state_46863;
var statearr_46877_46903 = state_46863__$1;
(statearr_46877_46903[(2)] = inst_46857);

(statearr_46877_46903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (10))){
var inst_46849 = (state_46863[(2)]);
var state_46863__$1 = state_46863;
var statearr_46878_46904 = state_46863__$1;
(statearr_46878_46904[(2)] = inst_46849);

(statearr_46878_46904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46864 === (8))){
var inst_46846 = cljs.core.async.close_BANG_.call(null,to);
var state_46863__$1 = state_46863;
var statearr_46879_46905 = state_46863__$1;
(statearr_46879_46905[(2)] = inst_46846);

(statearr_46879_46905[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___46891))
;
return ((function (switch__46612__auto__,c__46724__auto___46891){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_46883 = [null,null,null,null,null,null,null,null];
(statearr_46883[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_46883[(1)] = (1));

return statearr_46883;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_46863){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_46863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e46884){if((e46884 instanceof Object)){
var ex__46616__auto__ = e46884;
var statearr_46885_46906 = state_46863;
(statearr_46885_46906[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46863);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46907 = state_46863;
state_46863 = G__46907;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_46863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_46863);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___46891))
})();
var state__46726__auto__ = (function (){var statearr_46886 = f__46725__auto__.call(null);
(statearr_46886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___46891);

return statearr_46886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___46891))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__47095){
var vec__47096 = p__47095;
var v = cljs.core.nth.call(null,vec__47096,(0),null);
var p = cljs.core.nth.call(null,vec__47096,(1),null);
var job = vec__47096;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__46724__auto___47282 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___47282,res,vec__47096,v,p,job,jobs,results){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___47282,res,vec__47096,v,p,job,jobs,results){
return (function (state_47103){
var state_val_47104 = (state_47103[(1)]);
if((state_val_47104 === (1))){
var state_47103__$1 = state_47103;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47103__$1,(2),res,v);
} else {
if((state_val_47104 === (2))){
var inst_47100 = (state_47103[(2)]);
var inst_47101 = cljs.core.async.close_BANG_.call(null,res);
var state_47103__$1 = (function (){var statearr_47105 = state_47103;
(statearr_47105[(7)] = inst_47100);

return statearr_47105;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47103__$1,inst_47101);
} else {
return null;
}
}
});})(c__46724__auto___47282,res,vec__47096,v,p,job,jobs,results))
;
return ((function (switch__46612__auto__,c__46724__auto___47282,res,vec__47096,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0 = (function (){
var statearr_47109 = [null,null,null,null,null,null,null,null];
(statearr_47109[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__);

(statearr_47109[(1)] = (1));

return statearr_47109;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1 = (function (state_47103){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47110){if((e47110 instanceof Object)){
var ex__46616__auto__ = e47110;
var statearr_47111_47283 = state_47103;
(statearr_47111_47283[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47103);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47284 = state_47103;
state_47103 = G__47284;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = function(state_47103){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1.call(this,state_47103);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___47282,res,vec__47096,v,p,job,jobs,results))
})();
var state__46726__auto__ = (function (){var statearr_47112 = f__46725__auto__.call(null);
(statearr_47112[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___47282);

return statearr_47112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___47282,res,vec__47096,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__47113){
var vec__47114 = p__47113;
var v = cljs.core.nth.call(null,vec__47114,(0),null);
var p = cljs.core.nth.call(null,vec__47114,(1),null);
var job = vec__47114;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__42097__auto___47285 = n;
var __47286 = (0);
while(true){
if((__47286 < n__42097__auto___47285)){
var G__47117_47287 = type;
var G__47117_47288__$1 = (((G__47117_47287 instanceof cljs.core.Keyword))?G__47117_47287.fqn:null);
switch (G__47117_47288__$1) {
case "compute":
var c__46724__auto___47290 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__47286,c__46724__auto___47290,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (__47286,c__46724__auto___47290,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async){
return (function (state_47130){
var state_val_47131 = (state_47130[(1)]);
if((state_val_47131 === (1))){
var state_47130__$1 = state_47130;
var statearr_47132_47291 = state_47130__$1;
(statearr_47132_47291[(2)] = null);

(statearr_47132_47291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47131 === (2))){
var state_47130__$1 = state_47130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47130__$1,(4),jobs);
} else {
if((state_val_47131 === (3))){
var inst_47128 = (state_47130[(2)]);
var state_47130__$1 = state_47130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47130__$1,inst_47128);
} else {
if((state_val_47131 === (4))){
var inst_47120 = (state_47130[(2)]);
var inst_47121 = process.call(null,inst_47120);
var state_47130__$1 = state_47130;
if(cljs.core.truth_(inst_47121)){
var statearr_47133_47292 = state_47130__$1;
(statearr_47133_47292[(1)] = (5));

} else {
var statearr_47134_47293 = state_47130__$1;
(statearr_47134_47293[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47131 === (5))){
var state_47130__$1 = state_47130;
var statearr_47135_47294 = state_47130__$1;
(statearr_47135_47294[(2)] = null);

(statearr_47135_47294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47131 === (6))){
var state_47130__$1 = state_47130;
var statearr_47136_47295 = state_47130__$1;
(statearr_47136_47295[(2)] = null);

(statearr_47136_47295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47131 === (7))){
var inst_47126 = (state_47130[(2)]);
var state_47130__$1 = state_47130;
var statearr_47137_47296 = state_47130__$1;
(statearr_47137_47296[(2)] = inst_47126);

(statearr_47137_47296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47286,c__46724__auto___47290,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async))
;
return ((function (__47286,switch__46612__auto__,c__46724__auto___47290,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0 = (function (){
var statearr_47141 = [null,null,null,null,null,null,null];
(statearr_47141[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__);

(statearr_47141[(1)] = (1));

return statearr_47141;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1 = (function (state_47130){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47142){if((e47142 instanceof Object)){
var ex__46616__auto__ = e47142;
var statearr_47143_47297 = state_47130;
(statearr_47143_47297[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47130);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47142;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47298 = state_47130;
state_47130 = G__47298;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = function(state_47130){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1.call(this,state_47130);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__;
})()
;})(__47286,switch__46612__auto__,c__46724__auto___47290,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async))
})();
var state__46726__auto__ = (function (){var statearr_47144 = f__46725__auto__.call(null);
(statearr_47144[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___47290);

return statearr_47144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(__47286,c__46724__auto___47290,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async))
);


break;
case "async":
var c__46724__auto___47299 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__47286,c__46724__auto___47299,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (__47286,c__46724__auto___47299,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async){
return (function (state_47157){
var state_val_47158 = (state_47157[(1)]);
if((state_val_47158 === (1))){
var state_47157__$1 = state_47157;
var statearr_47159_47300 = state_47157__$1;
(statearr_47159_47300[(2)] = null);

(statearr_47159_47300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47158 === (2))){
var state_47157__$1 = state_47157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47157__$1,(4),jobs);
} else {
if((state_val_47158 === (3))){
var inst_47155 = (state_47157[(2)]);
var state_47157__$1 = state_47157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47157__$1,inst_47155);
} else {
if((state_val_47158 === (4))){
var inst_47147 = (state_47157[(2)]);
var inst_47148 = async.call(null,inst_47147);
var state_47157__$1 = state_47157;
if(cljs.core.truth_(inst_47148)){
var statearr_47160_47301 = state_47157__$1;
(statearr_47160_47301[(1)] = (5));

} else {
var statearr_47161_47302 = state_47157__$1;
(statearr_47161_47302[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47158 === (5))){
var state_47157__$1 = state_47157;
var statearr_47162_47303 = state_47157__$1;
(statearr_47162_47303[(2)] = null);

(statearr_47162_47303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47158 === (6))){
var state_47157__$1 = state_47157;
var statearr_47163_47304 = state_47157__$1;
(statearr_47163_47304[(2)] = null);

(statearr_47163_47304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47158 === (7))){
var inst_47153 = (state_47157[(2)]);
var state_47157__$1 = state_47157;
var statearr_47164_47305 = state_47157__$1;
(statearr_47164_47305[(2)] = inst_47153);

(statearr_47164_47305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__47286,c__46724__auto___47299,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async))
;
return ((function (__47286,switch__46612__auto__,c__46724__auto___47299,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0 = (function (){
var statearr_47168 = [null,null,null,null,null,null,null];
(statearr_47168[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__);

(statearr_47168[(1)] = (1));

return statearr_47168;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1 = (function (state_47157){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47169){if((e47169 instanceof Object)){
var ex__46616__auto__ = e47169;
var statearr_47170_47306 = state_47157;
(statearr_47170_47306[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47169;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47307 = state_47157;
state_47157 = G__47307;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = function(state_47157){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1.call(this,state_47157);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__;
})()
;})(__47286,switch__46612__auto__,c__46724__auto___47299,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async))
})();
var state__46726__auto__ = (function (){var statearr_47171 = f__46725__auto__.call(null);
(statearr_47171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___47299);

return statearr_47171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(__47286,c__46724__auto___47299,G__47117_47287,G__47117_47288__$1,n__42097__auto___47285,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__47308 = (__47286 + (1));
__47286 = G__47308;
continue;
} else {
}
break;
}

var c__46724__auto___47309 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___47309,jobs,results,process,async){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___47309,jobs,results,process,async){
return (function (state_47193){
var state_val_47194 = (state_47193[(1)]);
if((state_val_47194 === (1))){
var state_47193__$1 = state_47193;
var statearr_47195_47310 = state_47193__$1;
(statearr_47195_47310[(2)] = null);

(statearr_47195_47310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47194 === (2))){
var state_47193__$1 = state_47193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47193__$1,(4),from);
} else {
if((state_val_47194 === (3))){
var inst_47191 = (state_47193[(2)]);
var state_47193__$1 = state_47193;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47193__$1,inst_47191);
} else {
if((state_val_47194 === (4))){
var inst_47174 = (state_47193[(7)]);
var inst_47174__$1 = (state_47193[(2)]);
var inst_47175 = (inst_47174__$1 == null);
var state_47193__$1 = (function (){var statearr_47196 = state_47193;
(statearr_47196[(7)] = inst_47174__$1);

return statearr_47196;
})();
if(cljs.core.truth_(inst_47175)){
var statearr_47197_47311 = state_47193__$1;
(statearr_47197_47311[(1)] = (5));

} else {
var statearr_47198_47312 = state_47193__$1;
(statearr_47198_47312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47194 === (5))){
var inst_47177 = cljs.core.async.close_BANG_.call(null,jobs);
var state_47193__$1 = state_47193;
var statearr_47199_47313 = state_47193__$1;
(statearr_47199_47313[(2)] = inst_47177);

(statearr_47199_47313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47194 === (6))){
var inst_47179 = (state_47193[(8)]);
var inst_47174 = (state_47193[(7)]);
var inst_47179__$1 = cljs.core.async.chan.call(null,(1));
var inst_47180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47181 = [inst_47174,inst_47179__$1];
var inst_47182 = (new cljs.core.PersistentVector(null,2,(5),inst_47180,inst_47181,null));
var state_47193__$1 = (function (){var statearr_47200 = state_47193;
(statearr_47200[(8)] = inst_47179__$1);

return statearr_47200;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47193__$1,(8),jobs,inst_47182);
} else {
if((state_val_47194 === (7))){
var inst_47189 = (state_47193[(2)]);
var state_47193__$1 = state_47193;
var statearr_47201_47314 = state_47193__$1;
(statearr_47201_47314[(2)] = inst_47189);

(statearr_47201_47314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47194 === (8))){
var inst_47179 = (state_47193[(8)]);
var inst_47184 = (state_47193[(2)]);
var state_47193__$1 = (function (){var statearr_47202 = state_47193;
(statearr_47202[(9)] = inst_47184);

return statearr_47202;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47193__$1,(9),results,inst_47179);
} else {
if((state_val_47194 === (9))){
var inst_47186 = (state_47193[(2)]);
var state_47193__$1 = (function (){var statearr_47203 = state_47193;
(statearr_47203[(10)] = inst_47186);

return statearr_47203;
})();
var statearr_47204_47315 = state_47193__$1;
(statearr_47204_47315[(2)] = null);

(statearr_47204_47315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___47309,jobs,results,process,async))
;
return ((function (switch__46612__auto__,c__46724__auto___47309,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0 = (function (){
var statearr_47208 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47208[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__);

(statearr_47208[(1)] = (1));

return statearr_47208;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1 = (function (state_47193){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47193);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47209){if((e47209 instanceof Object)){
var ex__46616__auto__ = e47209;
var statearr_47210_47316 = state_47193;
(statearr_47210_47316[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47193);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47317 = state_47193;
state_47193 = G__47317;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = function(state_47193){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1.call(this,state_47193);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___47309,jobs,results,process,async))
})();
var state__46726__auto__ = (function (){var statearr_47211 = f__46725__auto__.call(null);
(statearr_47211[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___47309);

return statearr_47211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___47309,jobs,results,process,async))
);


var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__,jobs,results,process,async){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__,jobs,results,process,async){
return (function (state_47249){
var state_val_47250 = (state_47249[(1)]);
if((state_val_47250 === (7))){
var inst_47245 = (state_47249[(2)]);
var state_47249__$1 = state_47249;
var statearr_47251_47318 = state_47249__$1;
(statearr_47251_47318[(2)] = inst_47245);

(statearr_47251_47318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (20))){
var state_47249__$1 = state_47249;
var statearr_47252_47319 = state_47249__$1;
(statearr_47252_47319[(2)] = null);

(statearr_47252_47319[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (1))){
var state_47249__$1 = state_47249;
var statearr_47253_47320 = state_47249__$1;
(statearr_47253_47320[(2)] = null);

(statearr_47253_47320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (4))){
var inst_47214 = (state_47249[(7)]);
var inst_47214__$1 = (state_47249[(2)]);
var inst_47215 = (inst_47214__$1 == null);
var state_47249__$1 = (function (){var statearr_47254 = state_47249;
(statearr_47254[(7)] = inst_47214__$1);

return statearr_47254;
})();
if(cljs.core.truth_(inst_47215)){
var statearr_47255_47321 = state_47249__$1;
(statearr_47255_47321[(1)] = (5));

} else {
var statearr_47256_47322 = state_47249__$1;
(statearr_47256_47322[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (15))){
var inst_47227 = (state_47249[(8)]);
var state_47249__$1 = state_47249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47249__$1,(18),to,inst_47227);
} else {
if((state_val_47250 === (21))){
var inst_47240 = (state_47249[(2)]);
var state_47249__$1 = state_47249;
var statearr_47257_47323 = state_47249__$1;
(statearr_47257_47323[(2)] = inst_47240);

(statearr_47257_47323[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (13))){
var inst_47242 = (state_47249[(2)]);
var state_47249__$1 = (function (){var statearr_47258 = state_47249;
(statearr_47258[(9)] = inst_47242);

return statearr_47258;
})();
var statearr_47259_47324 = state_47249__$1;
(statearr_47259_47324[(2)] = null);

(statearr_47259_47324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (6))){
var inst_47214 = (state_47249[(7)]);
var state_47249__$1 = state_47249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47249__$1,(11),inst_47214);
} else {
if((state_val_47250 === (17))){
var inst_47235 = (state_47249[(2)]);
var state_47249__$1 = state_47249;
if(cljs.core.truth_(inst_47235)){
var statearr_47260_47325 = state_47249__$1;
(statearr_47260_47325[(1)] = (19));

} else {
var statearr_47261_47326 = state_47249__$1;
(statearr_47261_47326[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (3))){
var inst_47247 = (state_47249[(2)]);
var state_47249__$1 = state_47249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47249__$1,inst_47247);
} else {
if((state_val_47250 === (12))){
var inst_47224 = (state_47249[(10)]);
var state_47249__$1 = state_47249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47249__$1,(14),inst_47224);
} else {
if((state_val_47250 === (2))){
var state_47249__$1 = state_47249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47249__$1,(4),results);
} else {
if((state_val_47250 === (19))){
var state_47249__$1 = state_47249;
var statearr_47262_47327 = state_47249__$1;
(statearr_47262_47327[(2)] = null);

(statearr_47262_47327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (11))){
var inst_47224 = (state_47249[(2)]);
var state_47249__$1 = (function (){var statearr_47263 = state_47249;
(statearr_47263[(10)] = inst_47224);

return statearr_47263;
})();
var statearr_47264_47328 = state_47249__$1;
(statearr_47264_47328[(2)] = null);

(statearr_47264_47328[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (9))){
var state_47249__$1 = state_47249;
var statearr_47265_47329 = state_47249__$1;
(statearr_47265_47329[(2)] = null);

(statearr_47265_47329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (5))){
var state_47249__$1 = state_47249;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47266_47330 = state_47249__$1;
(statearr_47266_47330[(1)] = (8));

} else {
var statearr_47267_47331 = state_47249__$1;
(statearr_47267_47331[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (14))){
var inst_47229 = (state_47249[(11)]);
var inst_47227 = (state_47249[(8)]);
var inst_47227__$1 = (state_47249[(2)]);
var inst_47228 = (inst_47227__$1 == null);
var inst_47229__$1 = cljs.core.not.call(null,inst_47228);
var state_47249__$1 = (function (){var statearr_47268 = state_47249;
(statearr_47268[(11)] = inst_47229__$1);

(statearr_47268[(8)] = inst_47227__$1);

return statearr_47268;
})();
if(inst_47229__$1){
var statearr_47269_47332 = state_47249__$1;
(statearr_47269_47332[(1)] = (15));

} else {
var statearr_47270_47333 = state_47249__$1;
(statearr_47270_47333[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (16))){
var inst_47229 = (state_47249[(11)]);
var state_47249__$1 = state_47249;
var statearr_47271_47334 = state_47249__$1;
(statearr_47271_47334[(2)] = inst_47229);

(statearr_47271_47334[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (10))){
var inst_47221 = (state_47249[(2)]);
var state_47249__$1 = state_47249;
var statearr_47272_47335 = state_47249__$1;
(statearr_47272_47335[(2)] = inst_47221);

(statearr_47272_47335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (18))){
var inst_47232 = (state_47249[(2)]);
var state_47249__$1 = state_47249;
var statearr_47273_47336 = state_47249__$1;
(statearr_47273_47336[(2)] = inst_47232);

(statearr_47273_47336[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47250 === (8))){
var inst_47218 = cljs.core.async.close_BANG_.call(null,to);
var state_47249__$1 = state_47249;
var statearr_47274_47337 = state_47249__$1;
(statearr_47274_47337[(2)] = inst_47218);

(statearr_47274_47337[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__,jobs,results,process,async))
;
return ((function (switch__46612__auto__,c__46724__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0 = (function (){
var statearr_47278 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47278[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__);

(statearr_47278[(1)] = (1));

return statearr_47278;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1 = (function (state_47249){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47279){if((e47279 instanceof Object)){
var ex__46616__auto__ = e47279;
var statearr_47280_47338 = state_47249;
(statearr_47280_47338[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47279;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47339 = state_47249;
state_47249 = G__47339;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__ = function(state_47249){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1.call(this,state_47249);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46613__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__,jobs,results,process,async))
})();
var state__46726__auto__ = (function (){var statearr_47281 = f__46725__auto__.call(null);
(statearr_47281[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_47281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__,jobs,results,process,async))
);

return c__46724__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args47340 = [];
var len__42287__auto___47343 = arguments.length;
var i__42288__auto___47344 = (0);
while(true){
if((i__42288__auto___47344 < len__42287__auto___47343)){
args47340.push((arguments[i__42288__auto___47344]));

var G__47345 = (i__42288__auto___47344 + (1));
i__42288__auto___47344 = G__47345;
continue;
} else {
}
break;
}

var G__47342 = args47340.length;
switch (G__47342) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47340.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args47347 = [];
var len__42287__auto___47350 = arguments.length;
var i__42288__auto___47351 = (0);
while(true){
if((i__42288__auto___47351 < len__42287__auto___47350)){
args47347.push((arguments[i__42288__auto___47351]));

var G__47352 = (i__42288__auto___47351 + (1));
i__42288__auto___47351 = G__47352;
continue;
} else {
}
break;
}

var G__47349 = args47347.length;
switch (G__47349) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47347.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args47354 = [];
var len__42287__auto___47407 = arguments.length;
var i__42288__auto___47408 = (0);
while(true){
if((i__42288__auto___47408 < len__42287__auto___47407)){
args47354.push((arguments[i__42288__auto___47408]));

var G__47409 = (i__42288__auto___47408 + (1));
i__42288__auto___47408 = G__47409;
continue;
} else {
}
break;
}

var G__47356 = args47354.length;
switch (G__47356) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47354.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__46724__auto___47411 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___47411,tc,fc){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___47411,tc,fc){
return (function (state_47382){
var state_val_47383 = (state_47382[(1)]);
if((state_val_47383 === (7))){
var inst_47378 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
var statearr_47384_47412 = state_47382__$1;
(statearr_47384_47412[(2)] = inst_47378);

(statearr_47384_47412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (1))){
var state_47382__$1 = state_47382;
var statearr_47385_47413 = state_47382__$1;
(statearr_47385_47413[(2)] = null);

(statearr_47385_47413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (4))){
var inst_47359 = (state_47382[(7)]);
var inst_47359__$1 = (state_47382[(2)]);
var inst_47360 = (inst_47359__$1 == null);
var state_47382__$1 = (function (){var statearr_47386 = state_47382;
(statearr_47386[(7)] = inst_47359__$1);

return statearr_47386;
})();
if(cljs.core.truth_(inst_47360)){
var statearr_47387_47414 = state_47382__$1;
(statearr_47387_47414[(1)] = (5));

} else {
var statearr_47388_47415 = state_47382__$1;
(statearr_47388_47415[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (13))){
var state_47382__$1 = state_47382;
var statearr_47389_47416 = state_47382__$1;
(statearr_47389_47416[(2)] = null);

(statearr_47389_47416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (6))){
var inst_47359 = (state_47382[(7)]);
var inst_47365 = p.call(null,inst_47359);
var state_47382__$1 = state_47382;
if(cljs.core.truth_(inst_47365)){
var statearr_47390_47417 = state_47382__$1;
(statearr_47390_47417[(1)] = (9));

} else {
var statearr_47391_47418 = state_47382__$1;
(statearr_47391_47418[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (3))){
var inst_47380 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47382__$1,inst_47380);
} else {
if((state_val_47383 === (12))){
var state_47382__$1 = state_47382;
var statearr_47392_47419 = state_47382__$1;
(statearr_47392_47419[(2)] = null);

(statearr_47392_47419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (2))){
var state_47382__$1 = state_47382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47382__$1,(4),ch);
} else {
if((state_val_47383 === (11))){
var inst_47359 = (state_47382[(7)]);
var inst_47369 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47382__$1,(8),inst_47369,inst_47359);
} else {
if((state_val_47383 === (9))){
var state_47382__$1 = state_47382;
var statearr_47393_47420 = state_47382__$1;
(statearr_47393_47420[(2)] = tc);

(statearr_47393_47420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (5))){
var inst_47362 = cljs.core.async.close_BANG_.call(null,tc);
var inst_47363 = cljs.core.async.close_BANG_.call(null,fc);
var state_47382__$1 = (function (){var statearr_47394 = state_47382;
(statearr_47394[(8)] = inst_47362);

return statearr_47394;
})();
var statearr_47395_47421 = state_47382__$1;
(statearr_47395_47421[(2)] = inst_47363);

(statearr_47395_47421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (14))){
var inst_47376 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
var statearr_47396_47422 = state_47382__$1;
(statearr_47396_47422[(2)] = inst_47376);

(statearr_47396_47422[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (10))){
var state_47382__$1 = state_47382;
var statearr_47397_47423 = state_47382__$1;
(statearr_47397_47423[(2)] = fc);

(statearr_47397_47423[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (8))){
var inst_47371 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
if(cljs.core.truth_(inst_47371)){
var statearr_47398_47424 = state_47382__$1;
(statearr_47398_47424[(1)] = (12));

} else {
var statearr_47399_47425 = state_47382__$1;
(statearr_47399_47425[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___47411,tc,fc))
;
return ((function (switch__46612__auto__,c__46724__auto___47411,tc,fc){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_47403 = [null,null,null,null,null,null,null,null,null];
(statearr_47403[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_47403[(1)] = (1));

return statearr_47403;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_47382){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47404){if((e47404 instanceof Object)){
var ex__46616__auto__ = e47404;
var statearr_47405_47426 = state_47382;
(statearr_47405_47426[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47382);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47404;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47427 = state_47382;
state_47382 = G__47427;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_47382){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_47382);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___47411,tc,fc))
})();
var state__46726__auto__ = (function (){var statearr_47406 = f__46725__auto__.call(null);
(statearr_47406[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___47411);

return statearr_47406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___47411,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__){
return (function (state_47491){
var state_val_47492 = (state_47491[(1)]);
if((state_val_47492 === (7))){
var inst_47487 = (state_47491[(2)]);
var state_47491__$1 = state_47491;
var statearr_47493_47514 = state_47491__$1;
(statearr_47493_47514[(2)] = inst_47487);

(statearr_47493_47514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (1))){
var inst_47471 = init;
var state_47491__$1 = (function (){var statearr_47494 = state_47491;
(statearr_47494[(7)] = inst_47471);

return statearr_47494;
})();
var statearr_47495_47515 = state_47491__$1;
(statearr_47495_47515[(2)] = null);

(statearr_47495_47515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (4))){
var inst_47474 = (state_47491[(8)]);
var inst_47474__$1 = (state_47491[(2)]);
var inst_47475 = (inst_47474__$1 == null);
var state_47491__$1 = (function (){var statearr_47496 = state_47491;
(statearr_47496[(8)] = inst_47474__$1);

return statearr_47496;
})();
if(cljs.core.truth_(inst_47475)){
var statearr_47497_47516 = state_47491__$1;
(statearr_47497_47516[(1)] = (5));

} else {
var statearr_47498_47517 = state_47491__$1;
(statearr_47498_47517[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (6))){
var inst_47471 = (state_47491[(7)]);
var inst_47478 = (state_47491[(9)]);
var inst_47474 = (state_47491[(8)]);
var inst_47478__$1 = f.call(null,inst_47471,inst_47474);
var inst_47479 = cljs.core.reduced_QMARK_.call(null,inst_47478__$1);
var state_47491__$1 = (function (){var statearr_47499 = state_47491;
(statearr_47499[(9)] = inst_47478__$1);

return statearr_47499;
})();
if(inst_47479){
var statearr_47500_47518 = state_47491__$1;
(statearr_47500_47518[(1)] = (8));

} else {
var statearr_47501_47519 = state_47491__$1;
(statearr_47501_47519[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (3))){
var inst_47489 = (state_47491[(2)]);
var state_47491__$1 = state_47491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47491__$1,inst_47489);
} else {
if((state_val_47492 === (2))){
var state_47491__$1 = state_47491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47491__$1,(4),ch);
} else {
if((state_val_47492 === (9))){
var inst_47478 = (state_47491[(9)]);
var inst_47471 = inst_47478;
var state_47491__$1 = (function (){var statearr_47502 = state_47491;
(statearr_47502[(7)] = inst_47471);

return statearr_47502;
})();
var statearr_47503_47520 = state_47491__$1;
(statearr_47503_47520[(2)] = null);

(statearr_47503_47520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (5))){
var inst_47471 = (state_47491[(7)]);
var state_47491__$1 = state_47491;
var statearr_47504_47521 = state_47491__$1;
(statearr_47504_47521[(2)] = inst_47471);

(statearr_47504_47521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (10))){
var inst_47485 = (state_47491[(2)]);
var state_47491__$1 = state_47491;
var statearr_47505_47522 = state_47491__$1;
(statearr_47505_47522[(2)] = inst_47485);

(statearr_47505_47522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47492 === (8))){
var inst_47478 = (state_47491[(9)]);
var inst_47481 = cljs.core.deref.call(null,inst_47478);
var state_47491__$1 = state_47491;
var statearr_47506_47523 = state_47491__$1;
(statearr_47506_47523[(2)] = inst_47481);

(statearr_47506_47523[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__))
;
return ((function (switch__46612__auto__,c__46724__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__46613__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46613__auto____0 = (function (){
var statearr_47510 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47510[(0)] = cljs$core$async$reduce_$_state_machine__46613__auto__);

(statearr_47510[(1)] = (1));

return statearr_47510;
});
var cljs$core$async$reduce_$_state_machine__46613__auto____1 = (function (state_47491){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47511){if((e47511 instanceof Object)){
var ex__46616__auto__ = e47511;
var statearr_47512_47524 = state_47491;
(statearr_47512_47524[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47491);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47511;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47525 = state_47491;
state_47491 = G__47525;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46613__auto__ = function(state_47491){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46613__auto____1.call(this,state_47491);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46613__auto____0;
cljs$core$async$reduce_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46613__auto____1;
return cljs$core$async$reduce_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__))
})();
var state__46726__auto__ = (function (){var statearr_47513 = f__46725__auto__.call(null);
(statearr_47513[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_47513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__))
);

return c__46724__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__,f__$1){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__,f__$1){
return (function (state_47545){
var state_val_47546 = (state_47545[(1)]);
if((state_val_47546 === (1))){
var inst_47540 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_47545__$1 = state_47545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47545__$1,(2),inst_47540);
} else {
if((state_val_47546 === (2))){
var inst_47542 = (state_47545[(2)]);
var inst_47543 = f__$1.call(null,inst_47542);
var state_47545__$1 = state_47545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47545__$1,inst_47543);
} else {
return null;
}
}
});})(c__46724__auto__,f__$1))
;
return ((function (switch__46612__auto__,c__46724__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__46613__auto__ = null;
var cljs$core$async$transduce_$_state_machine__46613__auto____0 = (function (){
var statearr_47550 = [null,null,null,null,null,null,null];
(statearr_47550[(0)] = cljs$core$async$transduce_$_state_machine__46613__auto__);

(statearr_47550[(1)] = (1));

return statearr_47550;
});
var cljs$core$async$transduce_$_state_machine__46613__auto____1 = (function (state_47545){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47551){if((e47551 instanceof Object)){
var ex__46616__auto__ = e47551;
var statearr_47552_47554 = state_47545;
(statearr_47552_47554[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47545);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47551;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47555 = state_47545;
state_47545 = G__47555;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__46613__auto__ = function(state_47545){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__46613__auto____1.call(this,state_47545);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__46613__auto____0;
cljs$core$async$transduce_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__46613__auto____1;
return cljs$core$async$transduce_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__,f__$1))
})();
var state__46726__auto__ = (function (){var statearr_47553 = f__46725__auto__.call(null);
(statearr_47553[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_47553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__,f__$1))
);

return c__46724__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args47556 = [];
var len__42287__auto___47608 = arguments.length;
var i__42288__auto___47609 = (0);
while(true){
if((i__42288__auto___47609 < len__42287__auto___47608)){
args47556.push((arguments[i__42288__auto___47609]));

var G__47610 = (i__42288__auto___47609 + (1));
i__42288__auto___47609 = G__47610;
continue;
} else {
}
break;
}

var G__47558 = args47556.length;
switch (G__47558) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47556.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__){
return (function (state_47583){
var state_val_47584 = (state_47583[(1)]);
if((state_val_47584 === (7))){
var inst_47565 = (state_47583[(2)]);
var state_47583__$1 = state_47583;
var statearr_47585_47612 = state_47583__$1;
(statearr_47585_47612[(2)] = inst_47565);

(statearr_47585_47612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (1))){
var inst_47559 = cljs.core.seq.call(null,coll);
var inst_47560 = inst_47559;
var state_47583__$1 = (function (){var statearr_47586 = state_47583;
(statearr_47586[(7)] = inst_47560);

return statearr_47586;
})();
var statearr_47587_47613 = state_47583__$1;
(statearr_47587_47613[(2)] = null);

(statearr_47587_47613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (4))){
var inst_47560 = (state_47583[(7)]);
var inst_47563 = cljs.core.first.call(null,inst_47560);
var state_47583__$1 = state_47583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_47583__$1,(7),ch,inst_47563);
} else {
if((state_val_47584 === (13))){
var inst_47577 = (state_47583[(2)]);
var state_47583__$1 = state_47583;
var statearr_47588_47614 = state_47583__$1;
(statearr_47588_47614[(2)] = inst_47577);

(statearr_47588_47614[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (6))){
var inst_47568 = (state_47583[(2)]);
var state_47583__$1 = state_47583;
if(cljs.core.truth_(inst_47568)){
var statearr_47589_47615 = state_47583__$1;
(statearr_47589_47615[(1)] = (8));

} else {
var statearr_47590_47616 = state_47583__$1;
(statearr_47590_47616[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (3))){
var inst_47581 = (state_47583[(2)]);
var state_47583__$1 = state_47583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47583__$1,inst_47581);
} else {
if((state_val_47584 === (12))){
var state_47583__$1 = state_47583;
var statearr_47591_47617 = state_47583__$1;
(statearr_47591_47617[(2)] = null);

(statearr_47591_47617[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (2))){
var inst_47560 = (state_47583[(7)]);
var state_47583__$1 = state_47583;
if(cljs.core.truth_(inst_47560)){
var statearr_47592_47618 = state_47583__$1;
(statearr_47592_47618[(1)] = (4));

} else {
var statearr_47593_47619 = state_47583__$1;
(statearr_47593_47619[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (11))){
var inst_47574 = cljs.core.async.close_BANG_.call(null,ch);
var state_47583__$1 = state_47583;
var statearr_47594_47620 = state_47583__$1;
(statearr_47594_47620[(2)] = inst_47574);

(statearr_47594_47620[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (9))){
var state_47583__$1 = state_47583;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47595_47621 = state_47583__$1;
(statearr_47595_47621[(1)] = (11));

} else {
var statearr_47596_47622 = state_47583__$1;
(statearr_47596_47622[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (5))){
var inst_47560 = (state_47583[(7)]);
var state_47583__$1 = state_47583;
var statearr_47597_47623 = state_47583__$1;
(statearr_47597_47623[(2)] = inst_47560);

(statearr_47597_47623[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (10))){
var inst_47579 = (state_47583[(2)]);
var state_47583__$1 = state_47583;
var statearr_47598_47624 = state_47583__$1;
(statearr_47598_47624[(2)] = inst_47579);

(statearr_47598_47624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47584 === (8))){
var inst_47560 = (state_47583[(7)]);
var inst_47570 = cljs.core.next.call(null,inst_47560);
var inst_47560__$1 = inst_47570;
var state_47583__$1 = (function (){var statearr_47599 = state_47583;
(statearr_47599[(7)] = inst_47560__$1);

return statearr_47599;
})();
var statearr_47600_47625 = state_47583__$1;
(statearr_47600_47625[(2)] = null);

(statearr_47600_47625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__))
;
return ((function (switch__46612__auto__,c__46724__auto__){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_47604 = [null,null,null,null,null,null,null,null];
(statearr_47604[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_47604[(1)] = (1));

return statearr_47604;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_47583){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e47605){if((e47605 instanceof Object)){
var ex__46616__auto__ = e47605;
var statearr_47606_47626 = state_47583;
(statearr_47606_47626[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47627 = state_47583;
state_47583 = G__47627;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_47583){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_47583);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__))
})();
var state__46726__auto__ = (function (){var statearr_47607 = f__46725__auto__.call(null);
(statearr_47607[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_47607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__))
);

return c__46724__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__41842__auto__ = (((_ == null))?null:_);
var m__41843__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,_);
} else {
var m__41843__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__41843__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m,ch);
} else {
var m__41843__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m);
} else {
var m__41843__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async47853 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47853 = (function (ch,cs,meta47854){
this.ch = ch;
this.cs = cs;
this.meta47854 = meta47854;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_47855,meta47854__$1){
var self__ = this;
var _47855__$1 = this;
return (new cljs.core.async.t_cljs$core$async47853(self__.ch,self__.cs,meta47854__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_47855){
var self__ = this;
var _47855__$1 = this;
return self__.meta47854;
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47854","meta47854",-659181980,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async47853.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47853.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47853";

cljs.core.async.t_cljs$core$async47853.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async47853");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async47853 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async47853(ch__$1,cs__$1,meta47854){
return (new cljs.core.async.t_cljs$core$async47853(ch__$1,cs__$1,meta47854));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async47853(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__46724__auto___48078 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___48078,cs,m,dchan,dctr,done){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___48078,cs,m,dchan,dctr,done){
return (function (state_47990){
var state_val_47991 = (state_47990[(1)]);
if((state_val_47991 === (7))){
var inst_47986 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_47992_48079 = state_47990__$1;
(statearr_47992_48079[(2)] = inst_47986);

(statearr_47992_48079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (20))){
var inst_47889 = (state_47990[(7)]);
var inst_47901 = cljs.core.first.call(null,inst_47889);
var inst_47902 = cljs.core.nth.call(null,inst_47901,(0),null);
var inst_47903 = cljs.core.nth.call(null,inst_47901,(1),null);
var state_47990__$1 = (function (){var statearr_47993 = state_47990;
(statearr_47993[(8)] = inst_47902);

return statearr_47993;
})();
if(cljs.core.truth_(inst_47903)){
var statearr_47994_48080 = state_47990__$1;
(statearr_47994_48080[(1)] = (22));

} else {
var statearr_47995_48081 = state_47990__$1;
(statearr_47995_48081[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (27))){
var inst_47858 = (state_47990[(9)]);
var inst_47938 = (state_47990[(10)]);
var inst_47933 = (state_47990[(11)]);
var inst_47931 = (state_47990[(12)]);
var inst_47938__$1 = cljs.core._nth.call(null,inst_47931,inst_47933);
var inst_47939 = cljs.core.async.put_BANG_.call(null,inst_47938__$1,inst_47858,done);
var state_47990__$1 = (function (){var statearr_47996 = state_47990;
(statearr_47996[(10)] = inst_47938__$1);

return statearr_47996;
})();
if(cljs.core.truth_(inst_47939)){
var statearr_47997_48082 = state_47990__$1;
(statearr_47997_48082[(1)] = (30));

} else {
var statearr_47998_48083 = state_47990__$1;
(statearr_47998_48083[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (1))){
var state_47990__$1 = state_47990;
var statearr_47999_48084 = state_47990__$1;
(statearr_47999_48084[(2)] = null);

(statearr_47999_48084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (24))){
var inst_47889 = (state_47990[(7)]);
var inst_47908 = (state_47990[(2)]);
var inst_47909 = cljs.core.next.call(null,inst_47889);
var inst_47867 = inst_47909;
var inst_47868 = null;
var inst_47869 = (0);
var inst_47870 = (0);
var state_47990__$1 = (function (){var statearr_48000 = state_47990;
(statearr_48000[(13)] = inst_47870);

(statearr_48000[(14)] = inst_47867);

(statearr_48000[(15)] = inst_47908);

(statearr_48000[(16)] = inst_47869);

(statearr_48000[(17)] = inst_47868);

return statearr_48000;
})();
var statearr_48001_48085 = state_47990__$1;
(statearr_48001_48085[(2)] = null);

(statearr_48001_48085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (39))){
var state_47990__$1 = state_47990;
var statearr_48005_48086 = state_47990__$1;
(statearr_48005_48086[(2)] = null);

(statearr_48005_48086[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (4))){
var inst_47858 = (state_47990[(9)]);
var inst_47858__$1 = (state_47990[(2)]);
var inst_47859 = (inst_47858__$1 == null);
var state_47990__$1 = (function (){var statearr_48006 = state_47990;
(statearr_48006[(9)] = inst_47858__$1);

return statearr_48006;
})();
if(cljs.core.truth_(inst_47859)){
var statearr_48007_48087 = state_47990__$1;
(statearr_48007_48087[(1)] = (5));

} else {
var statearr_48008_48088 = state_47990__$1;
(statearr_48008_48088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (15))){
var inst_47870 = (state_47990[(13)]);
var inst_47867 = (state_47990[(14)]);
var inst_47869 = (state_47990[(16)]);
var inst_47868 = (state_47990[(17)]);
var inst_47885 = (state_47990[(2)]);
var inst_47886 = (inst_47870 + (1));
var tmp48002 = inst_47867;
var tmp48003 = inst_47869;
var tmp48004 = inst_47868;
var inst_47867__$1 = tmp48002;
var inst_47868__$1 = tmp48004;
var inst_47869__$1 = tmp48003;
var inst_47870__$1 = inst_47886;
var state_47990__$1 = (function (){var statearr_48009 = state_47990;
(statearr_48009[(13)] = inst_47870__$1);

(statearr_48009[(18)] = inst_47885);

(statearr_48009[(14)] = inst_47867__$1);

(statearr_48009[(16)] = inst_47869__$1);

(statearr_48009[(17)] = inst_47868__$1);

return statearr_48009;
})();
var statearr_48010_48089 = state_47990__$1;
(statearr_48010_48089[(2)] = null);

(statearr_48010_48089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (21))){
var inst_47912 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48014_48090 = state_47990__$1;
(statearr_48014_48090[(2)] = inst_47912);

(statearr_48014_48090[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (31))){
var inst_47938 = (state_47990[(10)]);
var inst_47942 = done.call(null,null);
var inst_47943 = cljs.core.async.untap_STAR_.call(null,m,inst_47938);
var state_47990__$1 = (function (){var statearr_48015 = state_47990;
(statearr_48015[(19)] = inst_47942);

return statearr_48015;
})();
var statearr_48016_48091 = state_47990__$1;
(statearr_48016_48091[(2)] = inst_47943);

(statearr_48016_48091[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (32))){
var inst_47930 = (state_47990[(20)]);
var inst_47933 = (state_47990[(11)]);
var inst_47932 = (state_47990[(21)]);
var inst_47931 = (state_47990[(12)]);
var inst_47945 = (state_47990[(2)]);
var inst_47946 = (inst_47933 + (1));
var tmp48011 = inst_47930;
var tmp48012 = inst_47932;
var tmp48013 = inst_47931;
var inst_47930__$1 = tmp48011;
var inst_47931__$1 = tmp48013;
var inst_47932__$1 = tmp48012;
var inst_47933__$1 = inst_47946;
var state_47990__$1 = (function (){var statearr_48017 = state_47990;
(statearr_48017[(22)] = inst_47945);

(statearr_48017[(20)] = inst_47930__$1);

(statearr_48017[(11)] = inst_47933__$1);

(statearr_48017[(21)] = inst_47932__$1);

(statearr_48017[(12)] = inst_47931__$1);

return statearr_48017;
})();
var statearr_48018_48092 = state_47990__$1;
(statearr_48018_48092[(2)] = null);

(statearr_48018_48092[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (40))){
var inst_47958 = (state_47990[(23)]);
var inst_47962 = done.call(null,null);
var inst_47963 = cljs.core.async.untap_STAR_.call(null,m,inst_47958);
var state_47990__$1 = (function (){var statearr_48019 = state_47990;
(statearr_48019[(24)] = inst_47962);

return statearr_48019;
})();
var statearr_48020_48093 = state_47990__$1;
(statearr_48020_48093[(2)] = inst_47963);

(statearr_48020_48093[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (33))){
var inst_47949 = (state_47990[(25)]);
var inst_47951 = cljs.core.chunked_seq_QMARK_.call(null,inst_47949);
var state_47990__$1 = state_47990;
if(inst_47951){
var statearr_48021_48094 = state_47990__$1;
(statearr_48021_48094[(1)] = (36));

} else {
var statearr_48022_48095 = state_47990__$1;
(statearr_48022_48095[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (13))){
var inst_47879 = (state_47990[(26)]);
var inst_47882 = cljs.core.async.close_BANG_.call(null,inst_47879);
var state_47990__$1 = state_47990;
var statearr_48023_48096 = state_47990__$1;
(statearr_48023_48096[(2)] = inst_47882);

(statearr_48023_48096[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (22))){
var inst_47902 = (state_47990[(8)]);
var inst_47905 = cljs.core.async.close_BANG_.call(null,inst_47902);
var state_47990__$1 = state_47990;
var statearr_48024_48097 = state_47990__$1;
(statearr_48024_48097[(2)] = inst_47905);

(statearr_48024_48097[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (36))){
var inst_47949 = (state_47990[(25)]);
var inst_47953 = cljs.core.chunk_first.call(null,inst_47949);
var inst_47954 = cljs.core.chunk_rest.call(null,inst_47949);
var inst_47955 = cljs.core.count.call(null,inst_47953);
var inst_47930 = inst_47954;
var inst_47931 = inst_47953;
var inst_47932 = inst_47955;
var inst_47933 = (0);
var state_47990__$1 = (function (){var statearr_48025 = state_47990;
(statearr_48025[(20)] = inst_47930);

(statearr_48025[(11)] = inst_47933);

(statearr_48025[(21)] = inst_47932);

(statearr_48025[(12)] = inst_47931);

return statearr_48025;
})();
var statearr_48026_48098 = state_47990__$1;
(statearr_48026_48098[(2)] = null);

(statearr_48026_48098[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (41))){
var inst_47949 = (state_47990[(25)]);
var inst_47965 = (state_47990[(2)]);
var inst_47966 = cljs.core.next.call(null,inst_47949);
var inst_47930 = inst_47966;
var inst_47931 = null;
var inst_47932 = (0);
var inst_47933 = (0);
var state_47990__$1 = (function (){var statearr_48027 = state_47990;
(statearr_48027[(27)] = inst_47965);

(statearr_48027[(20)] = inst_47930);

(statearr_48027[(11)] = inst_47933);

(statearr_48027[(21)] = inst_47932);

(statearr_48027[(12)] = inst_47931);

return statearr_48027;
})();
var statearr_48028_48099 = state_47990__$1;
(statearr_48028_48099[(2)] = null);

(statearr_48028_48099[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (43))){
var state_47990__$1 = state_47990;
var statearr_48029_48100 = state_47990__$1;
(statearr_48029_48100[(2)] = null);

(statearr_48029_48100[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (29))){
var inst_47974 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48030_48101 = state_47990__$1;
(statearr_48030_48101[(2)] = inst_47974);

(statearr_48030_48101[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (44))){
var inst_47983 = (state_47990[(2)]);
var state_47990__$1 = (function (){var statearr_48031 = state_47990;
(statearr_48031[(28)] = inst_47983);

return statearr_48031;
})();
var statearr_48032_48102 = state_47990__$1;
(statearr_48032_48102[(2)] = null);

(statearr_48032_48102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (6))){
var inst_47922 = (state_47990[(29)]);
var inst_47921 = cljs.core.deref.call(null,cs);
var inst_47922__$1 = cljs.core.keys.call(null,inst_47921);
var inst_47923 = cljs.core.count.call(null,inst_47922__$1);
var inst_47924 = cljs.core.reset_BANG_.call(null,dctr,inst_47923);
var inst_47929 = cljs.core.seq.call(null,inst_47922__$1);
var inst_47930 = inst_47929;
var inst_47931 = null;
var inst_47932 = (0);
var inst_47933 = (0);
var state_47990__$1 = (function (){var statearr_48033 = state_47990;
(statearr_48033[(30)] = inst_47924);

(statearr_48033[(29)] = inst_47922__$1);

(statearr_48033[(20)] = inst_47930);

(statearr_48033[(11)] = inst_47933);

(statearr_48033[(21)] = inst_47932);

(statearr_48033[(12)] = inst_47931);

return statearr_48033;
})();
var statearr_48034_48103 = state_47990__$1;
(statearr_48034_48103[(2)] = null);

(statearr_48034_48103[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (28))){
var inst_47930 = (state_47990[(20)]);
var inst_47949 = (state_47990[(25)]);
var inst_47949__$1 = cljs.core.seq.call(null,inst_47930);
var state_47990__$1 = (function (){var statearr_48035 = state_47990;
(statearr_48035[(25)] = inst_47949__$1);

return statearr_48035;
})();
if(inst_47949__$1){
var statearr_48036_48104 = state_47990__$1;
(statearr_48036_48104[(1)] = (33));

} else {
var statearr_48037_48105 = state_47990__$1;
(statearr_48037_48105[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (25))){
var inst_47933 = (state_47990[(11)]);
var inst_47932 = (state_47990[(21)]);
var inst_47935 = (inst_47933 < inst_47932);
var inst_47936 = inst_47935;
var state_47990__$1 = state_47990;
if(cljs.core.truth_(inst_47936)){
var statearr_48038_48106 = state_47990__$1;
(statearr_48038_48106[(1)] = (27));

} else {
var statearr_48039_48107 = state_47990__$1;
(statearr_48039_48107[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (34))){
var state_47990__$1 = state_47990;
var statearr_48040_48108 = state_47990__$1;
(statearr_48040_48108[(2)] = null);

(statearr_48040_48108[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (17))){
var state_47990__$1 = state_47990;
var statearr_48041_48109 = state_47990__$1;
(statearr_48041_48109[(2)] = null);

(statearr_48041_48109[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (3))){
var inst_47988 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47990__$1,inst_47988);
} else {
if((state_val_47991 === (12))){
var inst_47917 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48042_48110 = state_47990__$1;
(statearr_48042_48110[(2)] = inst_47917);

(statearr_48042_48110[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (2))){
var state_47990__$1 = state_47990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47990__$1,(4),ch);
} else {
if((state_val_47991 === (23))){
var state_47990__$1 = state_47990;
var statearr_48043_48111 = state_47990__$1;
(statearr_48043_48111[(2)] = null);

(statearr_48043_48111[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (35))){
var inst_47972 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48044_48112 = state_47990__$1;
(statearr_48044_48112[(2)] = inst_47972);

(statearr_48044_48112[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (19))){
var inst_47889 = (state_47990[(7)]);
var inst_47893 = cljs.core.chunk_first.call(null,inst_47889);
var inst_47894 = cljs.core.chunk_rest.call(null,inst_47889);
var inst_47895 = cljs.core.count.call(null,inst_47893);
var inst_47867 = inst_47894;
var inst_47868 = inst_47893;
var inst_47869 = inst_47895;
var inst_47870 = (0);
var state_47990__$1 = (function (){var statearr_48045 = state_47990;
(statearr_48045[(13)] = inst_47870);

(statearr_48045[(14)] = inst_47867);

(statearr_48045[(16)] = inst_47869);

(statearr_48045[(17)] = inst_47868);

return statearr_48045;
})();
var statearr_48046_48113 = state_47990__$1;
(statearr_48046_48113[(2)] = null);

(statearr_48046_48113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (11))){
var inst_47889 = (state_47990[(7)]);
var inst_47867 = (state_47990[(14)]);
var inst_47889__$1 = cljs.core.seq.call(null,inst_47867);
var state_47990__$1 = (function (){var statearr_48047 = state_47990;
(statearr_48047[(7)] = inst_47889__$1);

return statearr_48047;
})();
if(inst_47889__$1){
var statearr_48048_48114 = state_47990__$1;
(statearr_48048_48114[(1)] = (16));

} else {
var statearr_48049_48115 = state_47990__$1;
(statearr_48049_48115[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (9))){
var inst_47919 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48050_48116 = state_47990__$1;
(statearr_48050_48116[(2)] = inst_47919);

(statearr_48050_48116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (5))){
var inst_47865 = cljs.core.deref.call(null,cs);
var inst_47866 = cljs.core.seq.call(null,inst_47865);
var inst_47867 = inst_47866;
var inst_47868 = null;
var inst_47869 = (0);
var inst_47870 = (0);
var state_47990__$1 = (function (){var statearr_48051 = state_47990;
(statearr_48051[(13)] = inst_47870);

(statearr_48051[(14)] = inst_47867);

(statearr_48051[(16)] = inst_47869);

(statearr_48051[(17)] = inst_47868);

return statearr_48051;
})();
var statearr_48052_48117 = state_47990__$1;
(statearr_48052_48117[(2)] = null);

(statearr_48052_48117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (14))){
var state_47990__$1 = state_47990;
var statearr_48053_48118 = state_47990__$1;
(statearr_48053_48118[(2)] = null);

(statearr_48053_48118[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (45))){
var inst_47980 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48054_48119 = state_47990__$1;
(statearr_48054_48119[(2)] = inst_47980);

(statearr_48054_48119[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (26))){
var inst_47922 = (state_47990[(29)]);
var inst_47976 = (state_47990[(2)]);
var inst_47977 = cljs.core.seq.call(null,inst_47922);
var state_47990__$1 = (function (){var statearr_48055 = state_47990;
(statearr_48055[(31)] = inst_47976);

return statearr_48055;
})();
if(inst_47977){
var statearr_48056_48120 = state_47990__$1;
(statearr_48056_48120[(1)] = (42));

} else {
var statearr_48057_48121 = state_47990__$1;
(statearr_48057_48121[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (16))){
var inst_47889 = (state_47990[(7)]);
var inst_47891 = cljs.core.chunked_seq_QMARK_.call(null,inst_47889);
var state_47990__$1 = state_47990;
if(inst_47891){
var statearr_48058_48122 = state_47990__$1;
(statearr_48058_48122[(1)] = (19));

} else {
var statearr_48059_48123 = state_47990__$1;
(statearr_48059_48123[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (38))){
var inst_47969 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48060_48124 = state_47990__$1;
(statearr_48060_48124[(2)] = inst_47969);

(statearr_48060_48124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (30))){
var state_47990__$1 = state_47990;
var statearr_48061_48125 = state_47990__$1;
(statearr_48061_48125[(2)] = null);

(statearr_48061_48125[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (10))){
var inst_47870 = (state_47990[(13)]);
var inst_47868 = (state_47990[(17)]);
var inst_47878 = cljs.core._nth.call(null,inst_47868,inst_47870);
var inst_47879 = cljs.core.nth.call(null,inst_47878,(0),null);
var inst_47880 = cljs.core.nth.call(null,inst_47878,(1),null);
var state_47990__$1 = (function (){var statearr_48062 = state_47990;
(statearr_48062[(26)] = inst_47879);

return statearr_48062;
})();
if(cljs.core.truth_(inst_47880)){
var statearr_48063_48126 = state_47990__$1;
(statearr_48063_48126[(1)] = (13));

} else {
var statearr_48064_48127 = state_47990__$1;
(statearr_48064_48127[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (18))){
var inst_47915 = (state_47990[(2)]);
var state_47990__$1 = state_47990;
var statearr_48065_48128 = state_47990__$1;
(statearr_48065_48128[(2)] = inst_47915);

(statearr_48065_48128[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (42))){
var state_47990__$1 = state_47990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47990__$1,(45),dchan);
} else {
if((state_val_47991 === (37))){
var inst_47858 = (state_47990[(9)]);
var inst_47958 = (state_47990[(23)]);
var inst_47949 = (state_47990[(25)]);
var inst_47958__$1 = cljs.core.first.call(null,inst_47949);
var inst_47959 = cljs.core.async.put_BANG_.call(null,inst_47958__$1,inst_47858,done);
var state_47990__$1 = (function (){var statearr_48066 = state_47990;
(statearr_48066[(23)] = inst_47958__$1);

return statearr_48066;
})();
if(cljs.core.truth_(inst_47959)){
var statearr_48067_48129 = state_47990__$1;
(statearr_48067_48129[(1)] = (39));

} else {
var statearr_48068_48130 = state_47990__$1;
(statearr_48068_48130[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47991 === (8))){
var inst_47870 = (state_47990[(13)]);
var inst_47869 = (state_47990[(16)]);
var inst_47872 = (inst_47870 < inst_47869);
var inst_47873 = inst_47872;
var state_47990__$1 = state_47990;
if(cljs.core.truth_(inst_47873)){
var statearr_48069_48131 = state_47990__$1;
(statearr_48069_48131[(1)] = (10));

} else {
var statearr_48070_48132 = state_47990__$1;
(statearr_48070_48132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___48078,cs,m,dchan,dctr,done))
;
return ((function (switch__46612__auto__,c__46724__auto___48078,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__46613__auto__ = null;
var cljs$core$async$mult_$_state_machine__46613__auto____0 = (function (){
var statearr_48074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48074[(0)] = cljs$core$async$mult_$_state_machine__46613__auto__);

(statearr_48074[(1)] = (1));

return statearr_48074;
});
var cljs$core$async$mult_$_state_machine__46613__auto____1 = (function (state_47990){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_47990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e48075){if((e48075 instanceof Object)){
var ex__46616__auto__ = e48075;
var statearr_48076_48133 = state_47990;
(statearr_48076_48133[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48134 = state_47990;
state_47990 = G__48134;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46613__auto__ = function(state_47990){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46613__auto____1.call(this,state_47990);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46613__auto____0;
cljs$core$async$mult_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46613__auto____1;
return cljs$core$async$mult_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___48078,cs,m,dchan,dctr,done))
})();
var state__46726__auto__ = (function (){var statearr_48077 = f__46725__auto__.call(null);
(statearr_48077[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___48078);

return statearr_48077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___48078,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args48135 = [];
var len__42287__auto___48138 = arguments.length;
var i__42288__auto___48139 = (0);
while(true){
if((i__42288__auto___48139 < len__42287__auto___48138)){
args48135.push((arguments[i__42288__auto___48139]));

var G__48140 = (i__42288__auto___48139 + (1));
i__42288__auto___48139 = G__48140;
continue;
} else {
}
break;
}

var G__48137 = args48135.length;
switch (G__48137) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48135.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m,ch);
} else {
var m__41843__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m,ch);
} else {
var m__41843__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m);
} else {
var m__41843__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m,state_map);
} else {
var m__41843__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__41842__auto__ = (((m == null))?null:m);
var m__41843__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,m,mode);
} else {
var m__41843__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__42294__auto__ = [];
var len__42287__auto___48152 = arguments.length;
var i__42288__auto___48153 = (0);
while(true){
if((i__42288__auto___48153 < len__42287__auto___48152)){
args__42294__auto__.push((arguments[i__42288__auto___48153]));

var G__48154 = (i__42288__auto___48153 + (1));
i__42288__auto___48153 = G__48154;
continue;
} else {
}
break;
}

var argseq__42295__auto__ = ((((3) < args__42294__auto__.length))?(new cljs.core.IndexedSeq(args__42294__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__42295__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__48146){
var map__48147 = p__48146;
var map__48147__$1 = ((((!((map__48147 == null)))?((((map__48147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48147.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48147):map__48147);
var opts = map__48147__$1;
var statearr_48149_48155 = state;
(statearr_48149_48155[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__48147,map__48147__$1,opts){
return (function (val){
var statearr_48150_48156 = state;
(statearr_48150_48156[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__48147,map__48147__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_48151_48157 = state;
(statearr_48151_48157[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq48142){
var G__48143 = cljs.core.first.call(null,seq48142);
var seq48142__$1 = cljs.core.next.call(null,seq48142);
var G__48144 = cljs.core.first.call(null,seq48142__$1);
var seq48142__$2 = cljs.core.next.call(null,seq48142__$1);
var G__48145 = cljs.core.first.call(null,seq48142__$2);
var seq48142__$3 = cljs.core.next.call(null,seq48142__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__48143,G__48144,G__48145,seq48142__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async48325 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48325 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta48326){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta48326 = meta48326;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_48327,meta48326__$1){
var self__ = this;
var _48327__$1 = this;
return (new cljs.core.async.t_cljs$core$async48325(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta48326__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_48327){
var self__ = this;
var _48327__$1 = this;
return self__.meta48326;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta48326","meta48326",-2095878641,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async48325.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48325.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48325";

cljs.core.async.t_cljs$core$async48325.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async48325");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async48325 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async48325(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta48326){
return (new cljs.core.async.t_cljs$core$async48325(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta48326));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async48325(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46724__auto___48492 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___48492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___48492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_48429){
var state_val_48430 = (state_48429[(1)]);
if((state_val_48430 === (7))){
var inst_48344 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
var statearr_48431_48493 = state_48429__$1;
(statearr_48431_48493[(2)] = inst_48344);

(statearr_48431_48493[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (20))){
var inst_48356 = (state_48429[(7)]);
var state_48429__$1 = state_48429;
var statearr_48432_48494 = state_48429__$1;
(statearr_48432_48494[(2)] = inst_48356);

(statearr_48432_48494[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (27))){
var state_48429__$1 = state_48429;
var statearr_48433_48495 = state_48429__$1;
(statearr_48433_48495[(2)] = null);

(statearr_48433_48495[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (1))){
var inst_48331 = (state_48429[(8)]);
var inst_48331__$1 = calc_state.call(null);
var inst_48333 = (inst_48331__$1 == null);
var inst_48334 = cljs.core.not.call(null,inst_48333);
var state_48429__$1 = (function (){var statearr_48434 = state_48429;
(statearr_48434[(8)] = inst_48331__$1);

return statearr_48434;
})();
if(inst_48334){
var statearr_48435_48496 = state_48429__$1;
(statearr_48435_48496[(1)] = (2));

} else {
var statearr_48436_48497 = state_48429__$1;
(statearr_48436_48497[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (24))){
var inst_48403 = (state_48429[(9)]);
var inst_48380 = (state_48429[(10)]);
var inst_48389 = (state_48429[(11)]);
var inst_48403__$1 = inst_48380.call(null,inst_48389);
var state_48429__$1 = (function (){var statearr_48437 = state_48429;
(statearr_48437[(9)] = inst_48403__$1);

return statearr_48437;
})();
if(cljs.core.truth_(inst_48403__$1)){
var statearr_48438_48498 = state_48429__$1;
(statearr_48438_48498[(1)] = (29));

} else {
var statearr_48439_48499 = state_48429__$1;
(statearr_48439_48499[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (4))){
var inst_48347 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48347)){
var statearr_48440_48500 = state_48429__$1;
(statearr_48440_48500[(1)] = (8));

} else {
var statearr_48441_48501 = state_48429__$1;
(statearr_48441_48501[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (15))){
var inst_48374 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48374)){
var statearr_48442_48502 = state_48429__$1;
(statearr_48442_48502[(1)] = (19));

} else {
var statearr_48443_48503 = state_48429__$1;
(statearr_48443_48503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (21))){
var inst_48379 = (state_48429[(12)]);
var inst_48379__$1 = (state_48429[(2)]);
var inst_48380 = cljs.core.get.call(null,inst_48379__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48381 = cljs.core.get.call(null,inst_48379__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48382 = cljs.core.get.call(null,inst_48379__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48429__$1 = (function (){var statearr_48444 = state_48429;
(statearr_48444[(10)] = inst_48380);

(statearr_48444[(13)] = inst_48381);

(statearr_48444[(12)] = inst_48379__$1);

return statearr_48444;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_48429__$1,(22),inst_48382);
} else {
if((state_val_48430 === (31))){
var inst_48411 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48411)){
var statearr_48445_48504 = state_48429__$1;
(statearr_48445_48504[(1)] = (32));

} else {
var statearr_48446_48505 = state_48429__$1;
(statearr_48446_48505[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (32))){
var inst_48388 = (state_48429[(14)]);
var state_48429__$1 = state_48429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48429__$1,(35),out,inst_48388);
} else {
if((state_val_48430 === (33))){
var inst_48379 = (state_48429[(12)]);
var inst_48356 = inst_48379;
var state_48429__$1 = (function (){var statearr_48447 = state_48429;
(statearr_48447[(7)] = inst_48356);

return statearr_48447;
})();
var statearr_48448_48506 = state_48429__$1;
(statearr_48448_48506[(2)] = null);

(statearr_48448_48506[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (13))){
var inst_48356 = (state_48429[(7)]);
var inst_48363 = inst_48356.cljs$lang$protocol_mask$partition0$;
var inst_48364 = (inst_48363 & (64));
var inst_48365 = inst_48356.cljs$core$ISeq$;
var inst_48366 = (cljs.core.PROTOCOL_SENTINEL === inst_48365);
var inst_48367 = (inst_48364) || (inst_48366);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48367)){
var statearr_48449_48507 = state_48429__$1;
(statearr_48449_48507[(1)] = (16));

} else {
var statearr_48450_48508 = state_48429__$1;
(statearr_48450_48508[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (22))){
var inst_48389 = (state_48429[(11)]);
var inst_48388 = (state_48429[(14)]);
var inst_48387 = (state_48429[(2)]);
var inst_48388__$1 = cljs.core.nth.call(null,inst_48387,(0),null);
var inst_48389__$1 = cljs.core.nth.call(null,inst_48387,(1),null);
var inst_48390 = (inst_48388__$1 == null);
var inst_48391 = cljs.core._EQ_.call(null,inst_48389__$1,change);
var inst_48392 = (inst_48390) || (inst_48391);
var state_48429__$1 = (function (){var statearr_48451 = state_48429;
(statearr_48451[(11)] = inst_48389__$1);

(statearr_48451[(14)] = inst_48388__$1);

return statearr_48451;
})();
if(cljs.core.truth_(inst_48392)){
var statearr_48452_48509 = state_48429__$1;
(statearr_48452_48509[(1)] = (23));

} else {
var statearr_48453_48510 = state_48429__$1;
(statearr_48453_48510[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (36))){
var inst_48379 = (state_48429[(12)]);
var inst_48356 = inst_48379;
var state_48429__$1 = (function (){var statearr_48454 = state_48429;
(statearr_48454[(7)] = inst_48356);

return statearr_48454;
})();
var statearr_48455_48511 = state_48429__$1;
(statearr_48455_48511[(2)] = null);

(statearr_48455_48511[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (29))){
var inst_48403 = (state_48429[(9)]);
var state_48429__$1 = state_48429;
var statearr_48456_48512 = state_48429__$1;
(statearr_48456_48512[(2)] = inst_48403);

(statearr_48456_48512[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (6))){
var state_48429__$1 = state_48429;
var statearr_48457_48513 = state_48429__$1;
(statearr_48457_48513[(2)] = false);

(statearr_48457_48513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (28))){
var inst_48399 = (state_48429[(2)]);
var inst_48400 = calc_state.call(null);
var inst_48356 = inst_48400;
var state_48429__$1 = (function (){var statearr_48458 = state_48429;
(statearr_48458[(15)] = inst_48399);

(statearr_48458[(7)] = inst_48356);

return statearr_48458;
})();
var statearr_48459_48514 = state_48429__$1;
(statearr_48459_48514[(2)] = null);

(statearr_48459_48514[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (25))){
var inst_48425 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
var statearr_48460_48515 = state_48429__$1;
(statearr_48460_48515[(2)] = inst_48425);

(statearr_48460_48515[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (34))){
var inst_48423 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
var statearr_48461_48516 = state_48429__$1;
(statearr_48461_48516[(2)] = inst_48423);

(statearr_48461_48516[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (17))){
var state_48429__$1 = state_48429;
var statearr_48462_48517 = state_48429__$1;
(statearr_48462_48517[(2)] = false);

(statearr_48462_48517[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (3))){
var state_48429__$1 = state_48429;
var statearr_48463_48518 = state_48429__$1;
(statearr_48463_48518[(2)] = false);

(statearr_48463_48518[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (12))){
var inst_48427 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48429__$1,inst_48427);
} else {
if((state_val_48430 === (2))){
var inst_48331 = (state_48429[(8)]);
var inst_48336 = inst_48331.cljs$lang$protocol_mask$partition0$;
var inst_48337 = (inst_48336 & (64));
var inst_48338 = inst_48331.cljs$core$ISeq$;
var inst_48339 = (cljs.core.PROTOCOL_SENTINEL === inst_48338);
var inst_48340 = (inst_48337) || (inst_48339);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48340)){
var statearr_48464_48519 = state_48429__$1;
(statearr_48464_48519[(1)] = (5));

} else {
var statearr_48465_48520 = state_48429__$1;
(statearr_48465_48520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (23))){
var inst_48388 = (state_48429[(14)]);
var inst_48394 = (inst_48388 == null);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48394)){
var statearr_48466_48521 = state_48429__$1;
(statearr_48466_48521[(1)] = (26));

} else {
var statearr_48467_48522 = state_48429__$1;
(statearr_48467_48522[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (35))){
var inst_48414 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
if(cljs.core.truth_(inst_48414)){
var statearr_48468_48523 = state_48429__$1;
(statearr_48468_48523[(1)] = (36));

} else {
var statearr_48469_48524 = state_48429__$1;
(statearr_48469_48524[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (19))){
var inst_48356 = (state_48429[(7)]);
var inst_48376 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48356);
var state_48429__$1 = state_48429;
var statearr_48470_48525 = state_48429__$1;
(statearr_48470_48525[(2)] = inst_48376);

(statearr_48470_48525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (11))){
var inst_48356 = (state_48429[(7)]);
var inst_48360 = (inst_48356 == null);
var inst_48361 = cljs.core.not.call(null,inst_48360);
var state_48429__$1 = state_48429;
if(inst_48361){
var statearr_48471_48526 = state_48429__$1;
(statearr_48471_48526[(1)] = (13));

} else {
var statearr_48472_48527 = state_48429__$1;
(statearr_48472_48527[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (9))){
var inst_48331 = (state_48429[(8)]);
var state_48429__$1 = state_48429;
var statearr_48473_48528 = state_48429__$1;
(statearr_48473_48528[(2)] = inst_48331);

(statearr_48473_48528[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (5))){
var state_48429__$1 = state_48429;
var statearr_48474_48529 = state_48429__$1;
(statearr_48474_48529[(2)] = true);

(statearr_48474_48529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (14))){
var state_48429__$1 = state_48429;
var statearr_48475_48530 = state_48429__$1;
(statearr_48475_48530[(2)] = false);

(statearr_48475_48530[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (26))){
var inst_48389 = (state_48429[(11)]);
var inst_48396 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_48389);
var state_48429__$1 = state_48429;
var statearr_48476_48531 = state_48429__$1;
(statearr_48476_48531[(2)] = inst_48396);

(statearr_48476_48531[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (16))){
var state_48429__$1 = state_48429;
var statearr_48477_48532 = state_48429__$1;
(statearr_48477_48532[(2)] = true);

(statearr_48477_48532[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (38))){
var inst_48419 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
var statearr_48478_48533 = state_48429__$1;
(statearr_48478_48533[(2)] = inst_48419);

(statearr_48478_48533[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (30))){
var inst_48380 = (state_48429[(10)]);
var inst_48381 = (state_48429[(13)]);
var inst_48389 = (state_48429[(11)]);
var inst_48406 = cljs.core.empty_QMARK_.call(null,inst_48380);
var inst_48407 = inst_48381.call(null,inst_48389);
var inst_48408 = cljs.core.not.call(null,inst_48407);
var inst_48409 = (inst_48406) && (inst_48408);
var state_48429__$1 = state_48429;
var statearr_48479_48534 = state_48429__$1;
(statearr_48479_48534[(2)] = inst_48409);

(statearr_48479_48534[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (10))){
var inst_48331 = (state_48429[(8)]);
var inst_48352 = (state_48429[(2)]);
var inst_48353 = cljs.core.get.call(null,inst_48352,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48354 = cljs.core.get.call(null,inst_48352,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48355 = cljs.core.get.call(null,inst_48352,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48356 = inst_48331;
var state_48429__$1 = (function (){var statearr_48480 = state_48429;
(statearr_48480[(16)] = inst_48355);

(statearr_48480[(17)] = inst_48353);

(statearr_48480[(7)] = inst_48356);

(statearr_48480[(18)] = inst_48354);

return statearr_48480;
})();
var statearr_48481_48535 = state_48429__$1;
(statearr_48481_48535[(2)] = null);

(statearr_48481_48535[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (18))){
var inst_48371 = (state_48429[(2)]);
var state_48429__$1 = state_48429;
var statearr_48482_48536 = state_48429__$1;
(statearr_48482_48536[(2)] = inst_48371);

(statearr_48482_48536[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (37))){
var state_48429__$1 = state_48429;
var statearr_48483_48537 = state_48429__$1;
(statearr_48483_48537[(2)] = null);

(statearr_48483_48537[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48430 === (8))){
var inst_48331 = (state_48429[(8)]);
var inst_48349 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48331);
var state_48429__$1 = state_48429;
var statearr_48484_48538 = state_48429__$1;
(statearr_48484_48538[(2)] = inst_48349);

(statearr_48484_48538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___48492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__46612__auto__,c__46724__auto___48492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__46613__auto__ = null;
var cljs$core$async$mix_$_state_machine__46613__auto____0 = (function (){
var statearr_48488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48488[(0)] = cljs$core$async$mix_$_state_machine__46613__auto__);

(statearr_48488[(1)] = (1));

return statearr_48488;
});
var cljs$core$async$mix_$_state_machine__46613__auto____1 = (function (state_48429){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_48429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e48489){if((e48489 instanceof Object)){
var ex__46616__auto__ = e48489;
var statearr_48490_48539 = state_48429;
(statearr_48490_48539[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48429);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48489;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48540 = state_48429;
state_48429 = G__48540;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46613__auto__ = function(state_48429){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46613__auto____1.call(this,state_48429);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46613__auto____0;
cljs$core$async$mix_$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46613__auto____1;
return cljs$core$async$mix_$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___48492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__46726__auto__ = (function (){var statearr_48491 = f__46725__auto__.call(null);
(statearr_48491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___48492);

return statearr_48491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___48492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__41842__auto__ = (((p == null))?null:p);
var m__41843__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__41843__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__41842__auto__ = (((p == null))?null:p);
var m__41843__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,p,v,ch);
} else {
var m__41843__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args48541 = [];
var len__42287__auto___48544 = arguments.length;
var i__42288__auto___48545 = (0);
while(true){
if((i__42288__auto___48545 < len__42287__auto___48544)){
args48541.push((arguments[i__42288__auto___48545]));

var G__48546 = (i__42288__auto___48545 + (1));
i__42288__auto___48545 = G__48546;
continue;
} else {
}
break;
}

var G__48543 = args48541.length;
switch (G__48543) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48541.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__41842__auto__ = (((p == null))?null:p);
var m__41843__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,p);
} else {
var m__41843__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__41842__auto__ = (((p == null))?null:p);
var m__41843__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__41842__auto__)]);
if(!((m__41843__auto__ == null))){
return m__41843__auto__.call(null,p,v);
} else {
var m__41843__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__41843__auto____$1 == null))){
return m__41843__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args48549 = [];
var len__42287__auto___48674 = arguments.length;
var i__42288__auto___48675 = (0);
while(true){
if((i__42288__auto___48675 < len__42287__auto___48674)){
args48549.push((arguments[i__42288__auto___48675]));

var G__48676 = (i__42288__auto___48675 + (1));
i__42288__auto___48675 = G__48676;
continue;
} else {
}
break;
}

var G__48551 = args48549.length;
switch (G__48551) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48549.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__41174__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__41174__auto__)){
return or__41174__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__41174__auto__,mults){
return (function (p1__48548_SHARP_){
if(cljs.core.truth_(p1__48548_SHARP_.call(null,topic))){
return p1__48548_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__48548_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__41174__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async48552 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48552 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48553){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48553 = meta48553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_48554,meta48553__$1){
var self__ = this;
var _48554__$1 = this;
return (new cljs.core.async.t_cljs$core$async48552(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48553__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_48554){
var self__ = this;
var _48554__$1 = this;
return self__.meta48553;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48553","meta48553",1549055030,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48552.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48552";

cljs.core.async.t_cljs$core$async48552.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async48552");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async48552 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async48552(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48553){
return (new cljs.core.async.t_cljs$core$async48552(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48553));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async48552(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46724__auto___48678 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___48678,mults,ensure_mult,p){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___48678,mults,ensure_mult,p){
return (function (state_48626){
var state_val_48627 = (state_48626[(1)]);
if((state_val_48627 === (7))){
var inst_48622 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
var statearr_48628_48679 = state_48626__$1;
(statearr_48628_48679[(2)] = inst_48622);

(statearr_48628_48679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (20))){
var state_48626__$1 = state_48626;
var statearr_48629_48680 = state_48626__$1;
(statearr_48629_48680[(2)] = null);

(statearr_48629_48680[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (1))){
var state_48626__$1 = state_48626;
var statearr_48630_48681 = state_48626__$1;
(statearr_48630_48681[(2)] = null);

(statearr_48630_48681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (24))){
var inst_48605 = (state_48626[(7)]);
var inst_48614 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_48605);
var state_48626__$1 = state_48626;
var statearr_48631_48682 = state_48626__$1;
(statearr_48631_48682[(2)] = inst_48614);

(statearr_48631_48682[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (4))){
var inst_48557 = (state_48626[(8)]);
var inst_48557__$1 = (state_48626[(2)]);
var inst_48558 = (inst_48557__$1 == null);
var state_48626__$1 = (function (){var statearr_48632 = state_48626;
(statearr_48632[(8)] = inst_48557__$1);

return statearr_48632;
})();
if(cljs.core.truth_(inst_48558)){
var statearr_48633_48683 = state_48626__$1;
(statearr_48633_48683[(1)] = (5));

} else {
var statearr_48634_48684 = state_48626__$1;
(statearr_48634_48684[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (15))){
var inst_48599 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
var statearr_48635_48685 = state_48626__$1;
(statearr_48635_48685[(2)] = inst_48599);

(statearr_48635_48685[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (21))){
var inst_48619 = (state_48626[(2)]);
var state_48626__$1 = (function (){var statearr_48636 = state_48626;
(statearr_48636[(9)] = inst_48619);

return statearr_48636;
})();
var statearr_48637_48686 = state_48626__$1;
(statearr_48637_48686[(2)] = null);

(statearr_48637_48686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (13))){
var inst_48581 = (state_48626[(10)]);
var inst_48583 = cljs.core.chunked_seq_QMARK_.call(null,inst_48581);
var state_48626__$1 = state_48626;
if(inst_48583){
var statearr_48638_48687 = state_48626__$1;
(statearr_48638_48687[(1)] = (16));

} else {
var statearr_48639_48688 = state_48626__$1;
(statearr_48639_48688[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (22))){
var inst_48611 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
if(cljs.core.truth_(inst_48611)){
var statearr_48640_48689 = state_48626__$1;
(statearr_48640_48689[(1)] = (23));

} else {
var statearr_48641_48690 = state_48626__$1;
(statearr_48641_48690[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (6))){
var inst_48557 = (state_48626[(8)]);
var inst_48607 = (state_48626[(11)]);
var inst_48605 = (state_48626[(7)]);
var inst_48605__$1 = topic_fn.call(null,inst_48557);
var inst_48606 = cljs.core.deref.call(null,mults);
var inst_48607__$1 = cljs.core.get.call(null,inst_48606,inst_48605__$1);
var state_48626__$1 = (function (){var statearr_48642 = state_48626;
(statearr_48642[(11)] = inst_48607__$1);

(statearr_48642[(7)] = inst_48605__$1);

return statearr_48642;
})();
if(cljs.core.truth_(inst_48607__$1)){
var statearr_48643_48691 = state_48626__$1;
(statearr_48643_48691[(1)] = (19));

} else {
var statearr_48644_48692 = state_48626__$1;
(statearr_48644_48692[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (25))){
var inst_48616 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
var statearr_48645_48693 = state_48626__$1;
(statearr_48645_48693[(2)] = inst_48616);

(statearr_48645_48693[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (17))){
var inst_48581 = (state_48626[(10)]);
var inst_48590 = cljs.core.first.call(null,inst_48581);
var inst_48591 = cljs.core.async.muxch_STAR_.call(null,inst_48590);
var inst_48592 = cljs.core.async.close_BANG_.call(null,inst_48591);
var inst_48593 = cljs.core.next.call(null,inst_48581);
var inst_48567 = inst_48593;
var inst_48568 = null;
var inst_48569 = (0);
var inst_48570 = (0);
var state_48626__$1 = (function (){var statearr_48646 = state_48626;
(statearr_48646[(12)] = inst_48569);

(statearr_48646[(13)] = inst_48567);

(statearr_48646[(14)] = inst_48568);

(statearr_48646[(15)] = inst_48592);

(statearr_48646[(16)] = inst_48570);

return statearr_48646;
})();
var statearr_48647_48694 = state_48626__$1;
(statearr_48647_48694[(2)] = null);

(statearr_48647_48694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (3))){
var inst_48624 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48626__$1,inst_48624);
} else {
if((state_val_48627 === (12))){
var inst_48601 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
var statearr_48648_48695 = state_48626__$1;
(statearr_48648_48695[(2)] = inst_48601);

(statearr_48648_48695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (2))){
var state_48626__$1 = state_48626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48626__$1,(4),ch);
} else {
if((state_val_48627 === (23))){
var state_48626__$1 = state_48626;
var statearr_48649_48696 = state_48626__$1;
(statearr_48649_48696[(2)] = null);

(statearr_48649_48696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (19))){
var inst_48557 = (state_48626[(8)]);
var inst_48607 = (state_48626[(11)]);
var inst_48609 = cljs.core.async.muxch_STAR_.call(null,inst_48607);
var state_48626__$1 = state_48626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48626__$1,(22),inst_48609,inst_48557);
} else {
if((state_val_48627 === (11))){
var inst_48567 = (state_48626[(13)]);
var inst_48581 = (state_48626[(10)]);
var inst_48581__$1 = cljs.core.seq.call(null,inst_48567);
var state_48626__$1 = (function (){var statearr_48650 = state_48626;
(statearr_48650[(10)] = inst_48581__$1);

return statearr_48650;
})();
if(inst_48581__$1){
var statearr_48651_48697 = state_48626__$1;
(statearr_48651_48697[(1)] = (13));

} else {
var statearr_48652_48698 = state_48626__$1;
(statearr_48652_48698[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (9))){
var inst_48603 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
var statearr_48653_48699 = state_48626__$1;
(statearr_48653_48699[(2)] = inst_48603);

(statearr_48653_48699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (5))){
var inst_48564 = cljs.core.deref.call(null,mults);
var inst_48565 = cljs.core.vals.call(null,inst_48564);
var inst_48566 = cljs.core.seq.call(null,inst_48565);
var inst_48567 = inst_48566;
var inst_48568 = null;
var inst_48569 = (0);
var inst_48570 = (0);
var state_48626__$1 = (function (){var statearr_48654 = state_48626;
(statearr_48654[(12)] = inst_48569);

(statearr_48654[(13)] = inst_48567);

(statearr_48654[(14)] = inst_48568);

(statearr_48654[(16)] = inst_48570);

return statearr_48654;
})();
var statearr_48655_48700 = state_48626__$1;
(statearr_48655_48700[(2)] = null);

(statearr_48655_48700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (14))){
var state_48626__$1 = state_48626;
var statearr_48659_48701 = state_48626__$1;
(statearr_48659_48701[(2)] = null);

(statearr_48659_48701[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (16))){
var inst_48581 = (state_48626[(10)]);
var inst_48585 = cljs.core.chunk_first.call(null,inst_48581);
var inst_48586 = cljs.core.chunk_rest.call(null,inst_48581);
var inst_48587 = cljs.core.count.call(null,inst_48585);
var inst_48567 = inst_48586;
var inst_48568 = inst_48585;
var inst_48569 = inst_48587;
var inst_48570 = (0);
var state_48626__$1 = (function (){var statearr_48660 = state_48626;
(statearr_48660[(12)] = inst_48569);

(statearr_48660[(13)] = inst_48567);

(statearr_48660[(14)] = inst_48568);

(statearr_48660[(16)] = inst_48570);

return statearr_48660;
})();
var statearr_48661_48702 = state_48626__$1;
(statearr_48661_48702[(2)] = null);

(statearr_48661_48702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (10))){
var inst_48569 = (state_48626[(12)]);
var inst_48567 = (state_48626[(13)]);
var inst_48568 = (state_48626[(14)]);
var inst_48570 = (state_48626[(16)]);
var inst_48575 = cljs.core._nth.call(null,inst_48568,inst_48570);
var inst_48576 = cljs.core.async.muxch_STAR_.call(null,inst_48575);
var inst_48577 = cljs.core.async.close_BANG_.call(null,inst_48576);
var inst_48578 = (inst_48570 + (1));
var tmp48656 = inst_48569;
var tmp48657 = inst_48567;
var tmp48658 = inst_48568;
var inst_48567__$1 = tmp48657;
var inst_48568__$1 = tmp48658;
var inst_48569__$1 = tmp48656;
var inst_48570__$1 = inst_48578;
var state_48626__$1 = (function (){var statearr_48662 = state_48626;
(statearr_48662[(12)] = inst_48569__$1);

(statearr_48662[(13)] = inst_48567__$1);

(statearr_48662[(14)] = inst_48568__$1);

(statearr_48662[(17)] = inst_48577);

(statearr_48662[(16)] = inst_48570__$1);

return statearr_48662;
})();
var statearr_48663_48703 = state_48626__$1;
(statearr_48663_48703[(2)] = null);

(statearr_48663_48703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (18))){
var inst_48596 = (state_48626[(2)]);
var state_48626__$1 = state_48626;
var statearr_48664_48704 = state_48626__$1;
(statearr_48664_48704[(2)] = inst_48596);

(statearr_48664_48704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48627 === (8))){
var inst_48569 = (state_48626[(12)]);
var inst_48570 = (state_48626[(16)]);
var inst_48572 = (inst_48570 < inst_48569);
var inst_48573 = inst_48572;
var state_48626__$1 = state_48626;
if(cljs.core.truth_(inst_48573)){
var statearr_48665_48705 = state_48626__$1;
(statearr_48665_48705[(1)] = (10));

} else {
var statearr_48666_48706 = state_48626__$1;
(statearr_48666_48706[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___48678,mults,ensure_mult,p))
;
return ((function (switch__46612__auto__,c__46724__auto___48678,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_48670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48670[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_48670[(1)] = (1));

return statearr_48670;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_48626){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_48626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e48671){if((e48671 instanceof Object)){
var ex__46616__auto__ = e48671;
var statearr_48672_48707 = state_48626;
(statearr_48672_48707[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48708 = state_48626;
state_48626 = G__48708;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_48626){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_48626);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___48678,mults,ensure_mult,p))
})();
var state__46726__auto__ = (function (){var statearr_48673 = f__46725__auto__.call(null);
(statearr_48673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___48678);

return statearr_48673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___48678,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args48709 = [];
var len__42287__auto___48712 = arguments.length;
var i__42288__auto___48713 = (0);
while(true){
if((i__42288__auto___48713 < len__42287__auto___48712)){
args48709.push((arguments[i__42288__auto___48713]));

var G__48714 = (i__42288__auto___48713 + (1));
i__42288__auto___48713 = G__48714;
continue;
} else {
}
break;
}

var G__48711 = args48709.length;
switch (G__48711) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48709.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args48716 = [];
var len__42287__auto___48719 = arguments.length;
var i__42288__auto___48720 = (0);
while(true){
if((i__42288__auto___48720 < len__42287__auto___48719)){
args48716.push((arguments[i__42288__auto___48720]));

var G__48721 = (i__42288__auto___48720 + (1));
i__42288__auto___48720 = G__48721;
continue;
} else {
}
break;
}

var G__48718 = args48716.length;
switch (G__48718) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48716.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args48723 = [];
var len__42287__auto___48794 = arguments.length;
var i__42288__auto___48795 = (0);
while(true){
if((i__42288__auto___48795 < len__42287__auto___48794)){
args48723.push((arguments[i__42288__auto___48795]));

var G__48796 = (i__42288__auto___48795 + (1));
i__42288__auto___48795 = G__48796;
continue;
} else {
}
break;
}

var G__48725 = args48723.length;
switch (G__48725) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48723.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__46724__auto___48798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___48798,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___48798,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_48764){
var state_val_48765 = (state_48764[(1)]);
if((state_val_48765 === (7))){
var state_48764__$1 = state_48764;
var statearr_48766_48799 = state_48764__$1;
(statearr_48766_48799[(2)] = null);

(statearr_48766_48799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (1))){
var state_48764__$1 = state_48764;
var statearr_48767_48800 = state_48764__$1;
(statearr_48767_48800[(2)] = null);

(statearr_48767_48800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (4))){
var inst_48728 = (state_48764[(7)]);
var inst_48730 = (inst_48728 < cnt);
var state_48764__$1 = state_48764;
if(cljs.core.truth_(inst_48730)){
var statearr_48768_48801 = state_48764__$1;
(statearr_48768_48801[(1)] = (6));

} else {
var statearr_48769_48802 = state_48764__$1;
(statearr_48769_48802[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (15))){
var inst_48760 = (state_48764[(2)]);
var state_48764__$1 = state_48764;
var statearr_48770_48803 = state_48764__$1;
(statearr_48770_48803[(2)] = inst_48760);

(statearr_48770_48803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (13))){
var inst_48753 = cljs.core.async.close_BANG_.call(null,out);
var state_48764__$1 = state_48764;
var statearr_48771_48804 = state_48764__$1;
(statearr_48771_48804[(2)] = inst_48753);

(statearr_48771_48804[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (6))){
var state_48764__$1 = state_48764;
var statearr_48772_48805 = state_48764__$1;
(statearr_48772_48805[(2)] = null);

(statearr_48772_48805[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (3))){
var inst_48762 = (state_48764[(2)]);
var state_48764__$1 = state_48764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48764__$1,inst_48762);
} else {
if((state_val_48765 === (12))){
var inst_48750 = (state_48764[(8)]);
var inst_48750__$1 = (state_48764[(2)]);
var inst_48751 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_48750__$1);
var state_48764__$1 = (function (){var statearr_48773 = state_48764;
(statearr_48773[(8)] = inst_48750__$1);

return statearr_48773;
})();
if(cljs.core.truth_(inst_48751)){
var statearr_48774_48806 = state_48764__$1;
(statearr_48774_48806[(1)] = (13));

} else {
var statearr_48775_48807 = state_48764__$1;
(statearr_48775_48807[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (2))){
var inst_48727 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_48728 = (0);
var state_48764__$1 = (function (){var statearr_48776 = state_48764;
(statearr_48776[(9)] = inst_48727);

(statearr_48776[(7)] = inst_48728);

return statearr_48776;
})();
var statearr_48777_48808 = state_48764__$1;
(statearr_48777_48808[(2)] = null);

(statearr_48777_48808[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (11))){
var inst_48728 = (state_48764[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48764,(10),Object,null,(9));
var inst_48737 = chs__$1.call(null,inst_48728);
var inst_48738 = done.call(null,inst_48728);
var inst_48739 = cljs.core.async.take_BANG_.call(null,inst_48737,inst_48738);
var state_48764__$1 = state_48764;
var statearr_48778_48809 = state_48764__$1;
(statearr_48778_48809[(2)] = inst_48739);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48764__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (9))){
var inst_48728 = (state_48764[(7)]);
var inst_48741 = (state_48764[(2)]);
var inst_48742 = (inst_48728 + (1));
var inst_48728__$1 = inst_48742;
var state_48764__$1 = (function (){var statearr_48779 = state_48764;
(statearr_48779[(7)] = inst_48728__$1);

(statearr_48779[(10)] = inst_48741);

return statearr_48779;
})();
var statearr_48780_48810 = state_48764__$1;
(statearr_48780_48810[(2)] = null);

(statearr_48780_48810[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (5))){
var inst_48748 = (state_48764[(2)]);
var state_48764__$1 = (function (){var statearr_48781 = state_48764;
(statearr_48781[(11)] = inst_48748);

return statearr_48781;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48764__$1,(12),dchan);
} else {
if((state_val_48765 === (14))){
var inst_48750 = (state_48764[(8)]);
var inst_48755 = cljs.core.apply.call(null,f,inst_48750);
var state_48764__$1 = state_48764;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48764__$1,(16),out,inst_48755);
} else {
if((state_val_48765 === (16))){
var inst_48757 = (state_48764[(2)]);
var state_48764__$1 = (function (){var statearr_48782 = state_48764;
(statearr_48782[(12)] = inst_48757);

return statearr_48782;
})();
var statearr_48783_48811 = state_48764__$1;
(statearr_48783_48811[(2)] = null);

(statearr_48783_48811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (10))){
var inst_48732 = (state_48764[(2)]);
var inst_48733 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_48764__$1 = (function (){var statearr_48784 = state_48764;
(statearr_48784[(13)] = inst_48732);

return statearr_48784;
})();
var statearr_48785_48812 = state_48764__$1;
(statearr_48785_48812[(2)] = inst_48733);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48764__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48765 === (8))){
var inst_48746 = (state_48764[(2)]);
var state_48764__$1 = state_48764;
var statearr_48786_48813 = state_48764__$1;
(statearr_48786_48813[(2)] = inst_48746);

(statearr_48786_48813[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___48798,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__46612__auto__,c__46724__auto___48798,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_48790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48790[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_48790[(1)] = (1));

return statearr_48790;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_48764){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_48764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e48791){if((e48791 instanceof Object)){
var ex__46616__auto__ = e48791;
var statearr_48792_48814 = state_48764;
(statearr_48792_48814[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48764);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48815 = state_48764;
state_48764 = G__48815;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_48764){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_48764);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___48798,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__46726__auto__ = (function (){var statearr_48793 = f__46725__auto__.call(null);
(statearr_48793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___48798);

return statearr_48793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___48798,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args48817 = [];
var len__42287__auto___48875 = arguments.length;
var i__42288__auto___48876 = (0);
while(true){
if((i__42288__auto___48876 < len__42287__auto___48875)){
args48817.push((arguments[i__42288__auto___48876]));

var G__48877 = (i__42288__auto___48876 + (1));
i__42288__auto___48876 = G__48877;
continue;
} else {
}
break;
}

var G__48819 = args48817.length;
switch (G__48819) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48817.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46724__auto___48879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___48879,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___48879,out){
return (function (state_48851){
var state_val_48852 = (state_48851[(1)]);
if((state_val_48852 === (7))){
var inst_48831 = (state_48851[(7)]);
var inst_48830 = (state_48851[(8)]);
var inst_48830__$1 = (state_48851[(2)]);
var inst_48831__$1 = cljs.core.nth.call(null,inst_48830__$1,(0),null);
var inst_48832 = cljs.core.nth.call(null,inst_48830__$1,(1),null);
var inst_48833 = (inst_48831__$1 == null);
var state_48851__$1 = (function (){var statearr_48853 = state_48851;
(statearr_48853[(7)] = inst_48831__$1);

(statearr_48853[(9)] = inst_48832);

(statearr_48853[(8)] = inst_48830__$1);

return statearr_48853;
})();
if(cljs.core.truth_(inst_48833)){
var statearr_48854_48880 = state_48851__$1;
(statearr_48854_48880[(1)] = (8));

} else {
var statearr_48855_48881 = state_48851__$1;
(statearr_48855_48881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (1))){
var inst_48820 = cljs.core.vec.call(null,chs);
var inst_48821 = inst_48820;
var state_48851__$1 = (function (){var statearr_48856 = state_48851;
(statearr_48856[(10)] = inst_48821);

return statearr_48856;
})();
var statearr_48857_48882 = state_48851__$1;
(statearr_48857_48882[(2)] = null);

(statearr_48857_48882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (4))){
var inst_48821 = (state_48851[(10)]);
var state_48851__$1 = state_48851;
return cljs.core.async.ioc_alts_BANG_.call(null,state_48851__$1,(7),inst_48821);
} else {
if((state_val_48852 === (6))){
var inst_48847 = (state_48851[(2)]);
var state_48851__$1 = state_48851;
var statearr_48858_48883 = state_48851__$1;
(statearr_48858_48883[(2)] = inst_48847);

(statearr_48858_48883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (3))){
var inst_48849 = (state_48851[(2)]);
var state_48851__$1 = state_48851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48851__$1,inst_48849);
} else {
if((state_val_48852 === (2))){
var inst_48821 = (state_48851[(10)]);
var inst_48823 = cljs.core.count.call(null,inst_48821);
var inst_48824 = (inst_48823 > (0));
var state_48851__$1 = state_48851;
if(cljs.core.truth_(inst_48824)){
var statearr_48860_48884 = state_48851__$1;
(statearr_48860_48884[(1)] = (4));

} else {
var statearr_48861_48885 = state_48851__$1;
(statearr_48861_48885[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (11))){
var inst_48821 = (state_48851[(10)]);
var inst_48840 = (state_48851[(2)]);
var tmp48859 = inst_48821;
var inst_48821__$1 = tmp48859;
var state_48851__$1 = (function (){var statearr_48862 = state_48851;
(statearr_48862[(10)] = inst_48821__$1);

(statearr_48862[(11)] = inst_48840);

return statearr_48862;
})();
var statearr_48863_48886 = state_48851__$1;
(statearr_48863_48886[(2)] = null);

(statearr_48863_48886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (9))){
var inst_48831 = (state_48851[(7)]);
var state_48851__$1 = state_48851;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48851__$1,(11),out,inst_48831);
} else {
if((state_val_48852 === (5))){
var inst_48845 = cljs.core.async.close_BANG_.call(null,out);
var state_48851__$1 = state_48851;
var statearr_48864_48887 = state_48851__$1;
(statearr_48864_48887[(2)] = inst_48845);

(statearr_48864_48887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (10))){
var inst_48843 = (state_48851[(2)]);
var state_48851__$1 = state_48851;
var statearr_48865_48888 = state_48851__$1;
(statearr_48865_48888[(2)] = inst_48843);

(statearr_48865_48888[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48852 === (8))){
var inst_48831 = (state_48851[(7)]);
var inst_48821 = (state_48851[(10)]);
var inst_48832 = (state_48851[(9)]);
var inst_48830 = (state_48851[(8)]);
var inst_48835 = (function (){var cs = inst_48821;
var vec__48826 = inst_48830;
var v = inst_48831;
var c = inst_48832;
return ((function (cs,vec__48826,v,c,inst_48831,inst_48821,inst_48832,inst_48830,state_val_48852,c__46724__auto___48879,out){
return (function (p1__48816_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__48816_SHARP_);
});
;})(cs,vec__48826,v,c,inst_48831,inst_48821,inst_48832,inst_48830,state_val_48852,c__46724__auto___48879,out))
})();
var inst_48836 = cljs.core.filterv.call(null,inst_48835,inst_48821);
var inst_48821__$1 = inst_48836;
var state_48851__$1 = (function (){var statearr_48866 = state_48851;
(statearr_48866[(10)] = inst_48821__$1);

return statearr_48866;
})();
var statearr_48867_48889 = state_48851__$1;
(statearr_48867_48889[(2)] = null);

(statearr_48867_48889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___48879,out))
;
return ((function (switch__46612__auto__,c__46724__auto___48879,out){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_48871 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48871[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_48871[(1)] = (1));

return statearr_48871;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_48851){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_48851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e48872){if((e48872 instanceof Object)){
var ex__46616__auto__ = e48872;
var statearr_48873_48890 = state_48851;
(statearr_48873_48890[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48851);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48872;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48891 = state_48851;
state_48851 = G__48891;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_48851){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_48851);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___48879,out))
})();
var state__46726__auto__ = (function (){var statearr_48874 = f__46725__auto__.call(null);
(statearr_48874[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___48879);

return statearr_48874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___48879,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args48892 = [];
var len__42287__auto___48941 = arguments.length;
var i__42288__auto___48942 = (0);
while(true){
if((i__42288__auto___48942 < len__42287__auto___48941)){
args48892.push((arguments[i__42288__auto___48942]));

var G__48943 = (i__42288__auto___48942 + (1));
i__42288__auto___48942 = G__48943;
continue;
} else {
}
break;
}

var G__48894 = args48892.length;
switch (G__48894) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48892.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46724__auto___48945 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___48945,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___48945,out){
return (function (state_48918){
var state_val_48919 = (state_48918[(1)]);
if((state_val_48919 === (7))){
var inst_48900 = (state_48918[(7)]);
var inst_48900__$1 = (state_48918[(2)]);
var inst_48901 = (inst_48900__$1 == null);
var inst_48902 = cljs.core.not.call(null,inst_48901);
var state_48918__$1 = (function (){var statearr_48920 = state_48918;
(statearr_48920[(7)] = inst_48900__$1);

return statearr_48920;
})();
if(inst_48902){
var statearr_48921_48946 = state_48918__$1;
(statearr_48921_48946[(1)] = (8));

} else {
var statearr_48922_48947 = state_48918__$1;
(statearr_48922_48947[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (1))){
var inst_48895 = (0);
var state_48918__$1 = (function (){var statearr_48923 = state_48918;
(statearr_48923[(8)] = inst_48895);

return statearr_48923;
})();
var statearr_48924_48948 = state_48918__$1;
(statearr_48924_48948[(2)] = null);

(statearr_48924_48948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (4))){
var state_48918__$1 = state_48918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48918__$1,(7),ch);
} else {
if((state_val_48919 === (6))){
var inst_48913 = (state_48918[(2)]);
var state_48918__$1 = state_48918;
var statearr_48925_48949 = state_48918__$1;
(statearr_48925_48949[(2)] = inst_48913);

(statearr_48925_48949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (3))){
var inst_48915 = (state_48918[(2)]);
var inst_48916 = cljs.core.async.close_BANG_.call(null,out);
var state_48918__$1 = (function (){var statearr_48926 = state_48918;
(statearr_48926[(9)] = inst_48915);

return statearr_48926;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48918__$1,inst_48916);
} else {
if((state_val_48919 === (2))){
var inst_48895 = (state_48918[(8)]);
var inst_48897 = (inst_48895 < n);
var state_48918__$1 = state_48918;
if(cljs.core.truth_(inst_48897)){
var statearr_48927_48950 = state_48918__$1;
(statearr_48927_48950[(1)] = (4));

} else {
var statearr_48928_48951 = state_48918__$1;
(statearr_48928_48951[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (11))){
var inst_48895 = (state_48918[(8)]);
var inst_48905 = (state_48918[(2)]);
var inst_48906 = (inst_48895 + (1));
var inst_48895__$1 = inst_48906;
var state_48918__$1 = (function (){var statearr_48929 = state_48918;
(statearr_48929[(8)] = inst_48895__$1);

(statearr_48929[(10)] = inst_48905);

return statearr_48929;
})();
var statearr_48930_48952 = state_48918__$1;
(statearr_48930_48952[(2)] = null);

(statearr_48930_48952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (9))){
var state_48918__$1 = state_48918;
var statearr_48931_48953 = state_48918__$1;
(statearr_48931_48953[(2)] = null);

(statearr_48931_48953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (5))){
var state_48918__$1 = state_48918;
var statearr_48932_48954 = state_48918__$1;
(statearr_48932_48954[(2)] = null);

(statearr_48932_48954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (10))){
var inst_48910 = (state_48918[(2)]);
var state_48918__$1 = state_48918;
var statearr_48933_48955 = state_48918__$1;
(statearr_48933_48955[(2)] = inst_48910);

(statearr_48933_48955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48919 === (8))){
var inst_48900 = (state_48918[(7)]);
var state_48918__$1 = state_48918;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_48918__$1,(11),out,inst_48900);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___48945,out))
;
return ((function (switch__46612__auto__,c__46724__auto___48945,out){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_48937 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48937[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_48937[(1)] = (1));

return statearr_48937;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_48918){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_48918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e48938){if((e48938 instanceof Object)){
var ex__46616__auto__ = e48938;
var statearr_48939_48956 = state_48918;
(statearr_48939_48956[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48957 = state_48918;
state_48918 = G__48957;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_48918){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_48918);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___48945,out))
})();
var state__46726__auto__ = (function (){var statearr_48940 = f__46725__auto__.call(null);
(statearr_48940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___48945);

return statearr_48940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___48945,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48965 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48965 = (function (f,ch,meta48966){
this.f = f;
this.ch = ch;
this.meta48966 = meta48966;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48967,meta48966__$1){
var self__ = this;
var _48967__$1 = this;
return (new cljs.core.async.t_cljs$core$async48965(self__.f,self__.ch,meta48966__$1));
});

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48967){
var self__ = this;
var _48967__$1 = this;
return self__.meta48966;
});

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async48968 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48968 = (function (f,ch,meta48966,_,fn1,meta48969){
this.f = f;
this.ch = ch;
this.meta48966 = meta48966;
this._ = _;
this.fn1 = fn1;
this.meta48969 = meta48969;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48968.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_48970,meta48969__$1){
var self__ = this;
var _48970__$1 = this;
return (new cljs.core.async.t_cljs$core$async48968(self__.f,self__.ch,self__.meta48966,self__._,self__.fn1,meta48969__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async48968.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_48970){
var self__ = this;
var _48970__$1 = this;
return self__.meta48969;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48968.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48968.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48968.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48968.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__48958_SHARP_){
return f1.call(null,(((p1__48958_SHARP_ == null))?null:self__.f.call(null,p1__48958_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async48968.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48966","meta48966",-40783742,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48965","cljs.core.async/t_cljs$core$async48965",-262234132,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48969","meta48969",453532237,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48968.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48968.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48968";

cljs.core.async.t_cljs$core$async48968.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async48968");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async48968 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48968(f__$1,ch__$1,meta48966__$1,___$2,fn1__$1,meta48969){
return (new cljs.core.async.t_cljs$core$async48968(f__$1,ch__$1,meta48966__$1,___$2,fn1__$1,meta48969));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async48968(self__.f,self__.ch,self__.meta48966,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__41162__auto__ = ret;
if(cljs.core.truth_(and__41162__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__41162__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48965.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async48965.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48966","meta48966",-40783742,null)], null);
});

cljs.core.async.t_cljs$core$async48965.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48965.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48965";

cljs.core.async.t_cljs$core$async48965.cljs$lang$ctorPrWriter = (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async48965");
});

cljs.core.async.__GT_t_cljs$core$async48965 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48965(f__$1,ch__$1,meta48966){
return (new cljs.core.async.t_cljs$core$async48965(f__$1,ch__$1,meta48966));
});

}

return (new cljs.core.async.t_cljs$core$async48965(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async48974 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48974 = (function (f,ch,meta48975){
this.f = f;
this.ch = ch;
this.meta48975 = meta48975;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48976,meta48975__$1){
var self__ = this;
var _48976__$1 = this;
return (new cljs.core.async.t_cljs$core$async48974(self__.f,self__.ch,meta48975__$1));
});

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48976){
var self__ = this;
var _48976__$1 = this;
return self__.meta48975;
});

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48974.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async48974.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48975","meta48975",-1249853874,null)], null);
});

cljs.core.async.t_cljs$core$async48974.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48974.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48974";

cljs.core.async.t_cljs$core$async48974.cljs$lang$ctorPrWriter = (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async48974");
});

cljs.core.async.__GT_t_cljs$core$async48974 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48974(f__$1,ch__$1,meta48975){
return (new cljs.core.async.t_cljs$core$async48974(f__$1,ch__$1,meta48975));
});

}

return (new cljs.core.async.t_cljs$core$async48974(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async48980 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48980 = (function (p,ch,meta48981){
this.p = p;
this.ch = ch;
this.meta48981 = meta48981;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48982,meta48981__$1){
var self__ = this;
var _48982__$1 = this;
return (new cljs.core.async.t_cljs$core$async48980(self__.p,self__.ch,meta48981__$1));
});

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48982){
var self__ = this;
var _48982__$1 = this;
return self__.meta48981;
});

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48980.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async48980.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48981","meta48981",1675963418,null)], null);
});

cljs.core.async.t_cljs$core$async48980.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48980.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48980";

cljs.core.async.t_cljs$core$async48980.cljs$lang$ctorPrWriter = (function (this__41785__auto__,writer__41786__auto__,opt__41787__auto__){
return cljs.core._write.call(null,writer__41786__auto__,"cljs.core.async/t_cljs$core$async48980");
});

cljs.core.async.__GT_t_cljs$core$async48980 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48980(p__$1,ch__$1,meta48981){
return (new cljs.core.async.t_cljs$core$async48980(p__$1,ch__$1,meta48981));
});

}

return (new cljs.core.async.t_cljs$core$async48980(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args48983 = [];
var len__42287__auto___49027 = arguments.length;
var i__42288__auto___49028 = (0);
while(true){
if((i__42288__auto___49028 < len__42287__auto___49027)){
args48983.push((arguments[i__42288__auto___49028]));

var G__49029 = (i__42288__auto___49028 + (1));
i__42288__auto___49028 = G__49029;
continue;
} else {
}
break;
}

var G__48985 = args48983.length;
switch (G__48985) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args48983.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46724__auto___49031 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___49031,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___49031,out){
return (function (state_49006){
var state_val_49007 = (state_49006[(1)]);
if((state_val_49007 === (7))){
var inst_49002 = (state_49006[(2)]);
var state_49006__$1 = state_49006;
var statearr_49008_49032 = state_49006__$1;
(statearr_49008_49032[(2)] = inst_49002);

(statearr_49008_49032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (1))){
var state_49006__$1 = state_49006;
var statearr_49009_49033 = state_49006__$1;
(statearr_49009_49033[(2)] = null);

(statearr_49009_49033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (4))){
var inst_48988 = (state_49006[(7)]);
var inst_48988__$1 = (state_49006[(2)]);
var inst_48989 = (inst_48988__$1 == null);
var state_49006__$1 = (function (){var statearr_49010 = state_49006;
(statearr_49010[(7)] = inst_48988__$1);

return statearr_49010;
})();
if(cljs.core.truth_(inst_48989)){
var statearr_49011_49034 = state_49006__$1;
(statearr_49011_49034[(1)] = (5));

} else {
var statearr_49012_49035 = state_49006__$1;
(statearr_49012_49035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (6))){
var inst_48988 = (state_49006[(7)]);
var inst_48993 = p.call(null,inst_48988);
var state_49006__$1 = state_49006;
if(cljs.core.truth_(inst_48993)){
var statearr_49013_49036 = state_49006__$1;
(statearr_49013_49036[(1)] = (8));

} else {
var statearr_49014_49037 = state_49006__$1;
(statearr_49014_49037[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (3))){
var inst_49004 = (state_49006[(2)]);
var state_49006__$1 = state_49006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49006__$1,inst_49004);
} else {
if((state_val_49007 === (2))){
var state_49006__$1 = state_49006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49006__$1,(4),ch);
} else {
if((state_val_49007 === (11))){
var inst_48996 = (state_49006[(2)]);
var state_49006__$1 = state_49006;
var statearr_49015_49038 = state_49006__$1;
(statearr_49015_49038[(2)] = inst_48996);

(statearr_49015_49038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (9))){
var state_49006__$1 = state_49006;
var statearr_49016_49039 = state_49006__$1;
(statearr_49016_49039[(2)] = null);

(statearr_49016_49039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (5))){
var inst_48991 = cljs.core.async.close_BANG_.call(null,out);
var state_49006__$1 = state_49006;
var statearr_49017_49040 = state_49006__$1;
(statearr_49017_49040[(2)] = inst_48991);

(statearr_49017_49040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (10))){
var inst_48999 = (state_49006[(2)]);
var state_49006__$1 = (function (){var statearr_49018 = state_49006;
(statearr_49018[(8)] = inst_48999);

return statearr_49018;
})();
var statearr_49019_49041 = state_49006__$1;
(statearr_49019_49041[(2)] = null);

(statearr_49019_49041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49007 === (8))){
var inst_48988 = (state_49006[(7)]);
var state_49006__$1 = state_49006;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49006__$1,(11),out,inst_48988);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___49031,out))
;
return ((function (switch__46612__auto__,c__46724__auto___49031,out){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_49023 = [null,null,null,null,null,null,null,null,null];
(statearr_49023[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_49023[(1)] = (1));

return statearr_49023;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_49006){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_49006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e49024){if((e49024 instanceof Object)){
var ex__46616__auto__ = e49024;
var statearr_49025_49042 = state_49006;
(statearr_49025_49042[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49006);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49024;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49043 = state_49006;
state_49006 = G__49043;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_49006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_49006);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___49031,out))
})();
var state__46726__auto__ = (function (){var statearr_49026 = f__46725__auto__.call(null);
(statearr_49026[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___49031);

return statearr_49026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___49031,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args49044 = [];
var len__42287__auto___49047 = arguments.length;
var i__42288__auto___49048 = (0);
while(true){
if((i__42288__auto___49048 < len__42287__auto___49047)){
args49044.push((arguments[i__42288__auto___49048]));

var G__49049 = (i__42288__auto___49048 + (1));
i__42288__auto___49048 = G__49049;
continue;
} else {
}
break;
}

var G__49046 = args49044.length;
switch (G__49046) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49044.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__46724__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto__){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto__){
return (function (state_49216){
var state_val_49217 = (state_49216[(1)]);
if((state_val_49217 === (7))){
var inst_49212 = (state_49216[(2)]);
var state_49216__$1 = state_49216;
var statearr_49218_49259 = state_49216__$1;
(statearr_49218_49259[(2)] = inst_49212);

(statearr_49218_49259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (20))){
var inst_49182 = (state_49216[(7)]);
var inst_49193 = (state_49216[(2)]);
var inst_49194 = cljs.core.next.call(null,inst_49182);
var inst_49168 = inst_49194;
var inst_49169 = null;
var inst_49170 = (0);
var inst_49171 = (0);
var state_49216__$1 = (function (){var statearr_49219 = state_49216;
(statearr_49219[(8)] = inst_49168);

(statearr_49219[(9)] = inst_49193);

(statearr_49219[(10)] = inst_49170);

(statearr_49219[(11)] = inst_49171);

(statearr_49219[(12)] = inst_49169);

return statearr_49219;
})();
var statearr_49220_49260 = state_49216__$1;
(statearr_49220_49260[(2)] = null);

(statearr_49220_49260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (1))){
var state_49216__$1 = state_49216;
var statearr_49221_49261 = state_49216__$1;
(statearr_49221_49261[(2)] = null);

(statearr_49221_49261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (4))){
var inst_49157 = (state_49216[(13)]);
var inst_49157__$1 = (state_49216[(2)]);
var inst_49158 = (inst_49157__$1 == null);
var state_49216__$1 = (function (){var statearr_49222 = state_49216;
(statearr_49222[(13)] = inst_49157__$1);

return statearr_49222;
})();
if(cljs.core.truth_(inst_49158)){
var statearr_49223_49262 = state_49216__$1;
(statearr_49223_49262[(1)] = (5));

} else {
var statearr_49224_49263 = state_49216__$1;
(statearr_49224_49263[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (15))){
var state_49216__$1 = state_49216;
var statearr_49228_49264 = state_49216__$1;
(statearr_49228_49264[(2)] = null);

(statearr_49228_49264[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (21))){
var state_49216__$1 = state_49216;
var statearr_49229_49265 = state_49216__$1;
(statearr_49229_49265[(2)] = null);

(statearr_49229_49265[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (13))){
var inst_49168 = (state_49216[(8)]);
var inst_49170 = (state_49216[(10)]);
var inst_49171 = (state_49216[(11)]);
var inst_49169 = (state_49216[(12)]);
var inst_49178 = (state_49216[(2)]);
var inst_49179 = (inst_49171 + (1));
var tmp49225 = inst_49168;
var tmp49226 = inst_49170;
var tmp49227 = inst_49169;
var inst_49168__$1 = tmp49225;
var inst_49169__$1 = tmp49227;
var inst_49170__$1 = tmp49226;
var inst_49171__$1 = inst_49179;
var state_49216__$1 = (function (){var statearr_49230 = state_49216;
(statearr_49230[(14)] = inst_49178);

(statearr_49230[(8)] = inst_49168__$1);

(statearr_49230[(10)] = inst_49170__$1);

(statearr_49230[(11)] = inst_49171__$1);

(statearr_49230[(12)] = inst_49169__$1);

return statearr_49230;
})();
var statearr_49231_49266 = state_49216__$1;
(statearr_49231_49266[(2)] = null);

(statearr_49231_49266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (22))){
var state_49216__$1 = state_49216;
var statearr_49232_49267 = state_49216__$1;
(statearr_49232_49267[(2)] = null);

(statearr_49232_49267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (6))){
var inst_49157 = (state_49216[(13)]);
var inst_49166 = f.call(null,inst_49157);
var inst_49167 = cljs.core.seq.call(null,inst_49166);
var inst_49168 = inst_49167;
var inst_49169 = null;
var inst_49170 = (0);
var inst_49171 = (0);
var state_49216__$1 = (function (){var statearr_49233 = state_49216;
(statearr_49233[(8)] = inst_49168);

(statearr_49233[(10)] = inst_49170);

(statearr_49233[(11)] = inst_49171);

(statearr_49233[(12)] = inst_49169);

return statearr_49233;
})();
var statearr_49234_49268 = state_49216__$1;
(statearr_49234_49268[(2)] = null);

(statearr_49234_49268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (17))){
var inst_49182 = (state_49216[(7)]);
var inst_49186 = cljs.core.chunk_first.call(null,inst_49182);
var inst_49187 = cljs.core.chunk_rest.call(null,inst_49182);
var inst_49188 = cljs.core.count.call(null,inst_49186);
var inst_49168 = inst_49187;
var inst_49169 = inst_49186;
var inst_49170 = inst_49188;
var inst_49171 = (0);
var state_49216__$1 = (function (){var statearr_49235 = state_49216;
(statearr_49235[(8)] = inst_49168);

(statearr_49235[(10)] = inst_49170);

(statearr_49235[(11)] = inst_49171);

(statearr_49235[(12)] = inst_49169);

return statearr_49235;
})();
var statearr_49236_49269 = state_49216__$1;
(statearr_49236_49269[(2)] = null);

(statearr_49236_49269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (3))){
var inst_49214 = (state_49216[(2)]);
var state_49216__$1 = state_49216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49216__$1,inst_49214);
} else {
if((state_val_49217 === (12))){
var inst_49202 = (state_49216[(2)]);
var state_49216__$1 = state_49216;
var statearr_49237_49270 = state_49216__$1;
(statearr_49237_49270[(2)] = inst_49202);

(statearr_49237_49270[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (2))){
var state_49216__$1 = state_49216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49216__$1,(4),in$);
} else {
if((state_val_49217 === (23))){
var inst_49210 = (state_49216[(2)]);
var state_49216__$1 = state_49216;
var statearr_49238_49271 = state_49216__$1;
(statearr_49238_49271[(2)] = inst_49210);

(statearr_49238_49271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (19))){
var inst_49197 = (state_49216[(2)]);
var state_49216__$1 = state_49216;
var statearr_49239_49272 = state_49216__$1;
(statearr_49239_49272[(2)] = inst_49197);

(statearr_49239_49272[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (11))){
var inst_49168 = (state_49216[(8)]);
var inst_49182 = (state_49216[(7)]);
var inst_49182__$1 = cljs.core.seq.call(null,inst_49168);
var state_49216__$1 = (function (){var statearr_49240 = state_49216;
(statearr_49240[(7)] = inst_49182__$1);

return statearr_49240;
})();
if(inst_49182__$1){
var statearr_49241_49273 = state_49216__$1;
(statearr_49241_49273[(1)] = (14));

} else {
var statearr_49242_49274 = state_49216__$1;
(statearr_49242_49274[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (9))){
var inst_49204 = (state_49216[(2)]);
var inst_49205 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_49216__$1 = (function (){var statearr_49243 = state_49216;
(statearr_49243[(15)] = inst_49204);

return statearr_49243;
})();
if(cljs.core.truth_(inst_49205)){
var statearr_49244_49275 = state_49216__$1;
(statearr_49244_49275[(1)] = (21));

} else {
var statearr_49245_49276 = state_49216__$1;
(statearr_49245_49276[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (5))){
var inst_49160 = cljs.core.async.close_BANG_.call(null,out);
var state_49216__$1 = state_49216;
var statearr_49246_49277 = state_49216__$1;
(statearr_49246_49277[(2)] = inst_49160);

(statearr_49246_49277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (14))){
var inst_49182 = (state_49216[(7)]);
var inst_49184 = cljs.core.chunked_seq_QMARK_.call(null,inst_49182);
var state_49216__$1 = state_49216;
if(inst_49184){
var statearr_49247_49278 = state_49216__$1;
(statearr_49247_49278[(1)] = (17));

} else {
var statearr_49248_49279 = state_49216__$1;
(statearr_49248_49279[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (16))){
var inst_49200 = (state_49216[(2)]);
var state_49216__$1 = state_49216;
var statearr_49249_49280 = state_49216__$1;
(statearr_49249_49280[(2)] = inst_49200);

(statearr_49249_49280[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49217 === (10))){
var inst_49171 = (state_49216[(11)]);
var inst_49169 = (state_49216[(12)]);
var inst_49176 = cljs.core._nth.call(null,inst_49169,inst_49171);
var state_49216__$1 = state_49216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49216__$1,(13),out,inst_49176);
} else {
if((state_val_49217 === (18))){
var inst_49182 = (state_49216[(7)]);
var inst_49191 = cljs.core.first.call(null,inst_49182);
var state_49216__$1 = state_49216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49216__$1,(20),out,inst_49191);
} else {
if((state_val_49217 === (8))){
var inst_49170 = (state_49216[(10)]);
var inst_49171 = (state_49216[(11)]);
var inst_49173 = (inst_49171 < inst_49170);
var inst_49174 = inst_49173;
var state_49216__$1 = state_49216;
if(cljs.core.truth_(inst_49174)){
var statearr_49250_49281 = state_49216__$1;
(statearr_49250_49281[(1)] = (10));

} else {
var statearr_49251_49282 = state_49216__$1;
(statearr_49251_49282[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto__))
;
return ((function (switch__46612__auto__,c__46724__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46613__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46613__auto____0 = (function (){
var statearr_49255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49255[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46613__auto__);

(statearr_49255[(1)] = (1));

return statearr_49255;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46613__auto____1 = (function (state_49216){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_49216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e49256){if((e49256 instanceof Object)){
var ex__46616__auto__ = e49256;
var statearr_49257_49283 = state_49216;
(statearr_49257_49283[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49256;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49284 = state_49216;
state_49216 = G__49284;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46613__auto__ = function(state_49216){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46613__auto____1.call(this,state_49216);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46613__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46613__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto__))
})();
var state__46726__auto__ = (function (){var statearr_49258 = f__46725__auto__.call(null);
(statearr_49258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto__);

return statearr_49258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto__))
);

return c__46724__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args49285 = [];
var len__42287__auto___49288 = arguments.length;
var i__42288__auto___49289 = (0);
while(true){
if((i__42288__auto___49289 < len__42287__auto___49288)){
args49285.push((arguments[i__42288__auto___49289]));

var G__49290 = (i__42288__auto___49289 + (1));
i__42288__auto___49289 = G__49290;
continue;
} else {
}
break;
}

var G__49287 = args49285.length;
switch (G__49287) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49285.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args49292 = [];
var len__42287__auto___49295 = arguments.length;
var i__42288__auto___49296 = (0);
while(true){
if((i__42288__auto___49296 < len__42287__auto___49295)){
args49292.push((arguments[i__42288__auto___49296]));

var G__49297 = (i__42288__auto___49296 + (1));
i__42288__auto___49296 = G__49297;
continue;
} else {
}
break;
}

var G__49294 = args49292.length;
switch (G__49294) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49292.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args49299 = [];
var len__42287__auto___49350 = arguments.length;
var i__42288__auto___49351 = (0);
while(true){
if((i__42288__auto___49351 < len__42287__auto___49350)){
args49299.push((arguments[i__42288__auto___49351]));

var G__49352 = (i__42288__auto___49351 + (1));
i__42288__auto___49351 = G__49352;
continue;
} else {
}
break;
}

var G__49301 = args49299.length;
switch (G__49301) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49299.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46724__auto___49354 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___49354,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___49354,out){
return (function (state_49325){
var state_val_49326 = (state_49325[(1)]);
if((state_val_49326 === (7))){
var inst_49320 = (state_49325[(2)]);
var state_49325__$1 = state_49325;
var statearr_49327_49355 = state_49325__$1;
(statearr_49327_49355[(2)] = inst_49320);

(statearr_49327_49355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (1))){
var inst_49302 = null;
var state_49325__$1 = (function (){var statearr_49328 = state_49325;
(statearr_49328[(7)] = inst_49302);

return statearr_49328;
})();
var statearr_49329_49356 = state_49325__$1;
(statearr_49329_49356[(2)] = null);

(statearr_49329_49356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (4))){
var inst_49305 = (state_49325[(8)]);
var inst_49305__$1 = (state_49325[(2)]);
var inst_49306 = (inst_49305__$1 == null);
var inst_49307 = cljs.core.not.call(null,inst_49306);
var state_49325__$1 = (function (){var statearr_49330 = state_49325;
(statearr_49330[(8)] = inst_49305__$1);

return statearr_49330;
})();
if(inst_49307){
var statearr_49331_49357 = state_49325__$1;
(statearr_49331_49357[(1)] = (5));

} else {
var statearr_49332_49358 = state_49325__$1;
(statearr_49332_49358[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (6))){
var state_49325__$1 = state_49325;
var statearr_49333_49359 = state_49325__$1;
(statearr_49333_49359[(2)] = null);

(statearr_49333_49359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (3))){
var inst_49322 = (state_49325[(2)]);
var inst_49323 = cljs.core.async.close_BANG_.call(null,out);
var state_49325__$1 = (function (){var statearr_49334 = state_49325;
(statearr_49334[(9)] = inst_49322);

return statearr_49334;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49325__$1,inst_49323);
} else {
if((state_val_49326 === (2))){
var state_49325__$1 = state_49325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49325__$1,(4),ch);
} else {
if((state_val_49326 === (11))){
var inst_49305 = (state_49325[(8)]);
var inst_49314 = (state_49325[(2)]);
var inst_49302 = inst_49305;
var state_49325__$1 = (function (){var statearr_49335 = state_49325;
(statearr_49335[(7)] = inst_49302);

(statearr_49335[(10)] = inst_49314);

return statearr_49335;
})();
var statearr_49336_49360 = state_49325__$1;
(statearr_49336_49360[(2)] = null);

(statearr_49336_49360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (9))){
var inst_49305 = (state_49325[(8)]);
var state_49325__$1 = state_49325;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49325__$1,(11),out,inst_49305);
} else {
if((state_val_49326 === (5))){
var inst_49302 = (state_49325[(7)]);
var inst_49305 = (state_49325[(8)]);
var inst_49309 = cljs.core._EQ_.call(null,inst_49305,inst_49302);
var state_49325__$1 = state_49325;
if(inst_49309){
var statearr_49338_49361 = state_49325__$1;
(statearr_49338_49361[(1)] = (8));

} else {
var statearr_49339_49362 = state_49325__$1;
(statearr_49339_49362[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (10))){
var inst_49317 = (state_49325[(2)]);
var state_49325__$1 = state_49325;
var statearr_49340_49363 = state_49325__$1;
(statearr_49340_49363[(2)] = inst_49317);

(statearr_49340_49363[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49326 === (8))){
var inst_49302 = (state_49325[(7)]);
var tmp49337 = inst_49302;
var inst_49302__$1 = tmp49337;
var state_49325__$1 = (function (){var statearr_49341 = state_49325;
(statearr_49341[(7)] = inst_49302__$1);

return statearr_49341;
})();
var statearr_49342_49364 = state_49325__$1;
(statearr_49342_49364[(2)] = null);

(statearr_49342_49364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___49354,out))
;
return ((function (switch__46612__auto__,c__46724__auto___49354,out){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_49346 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49346[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_49346[(1)] = (1));

return statearr_49346;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_49325){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_49325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e49347){if((e49347 instanceof Object)){
var ex__46616__auto__ = e49347;
var statearr_49348_49365 = state_49325;
(statearr_49348_49365[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49366 = state_49325;
state_49325 = G__49366;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_49325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_49325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___49354,out))
})();
var state__46726__auto__ = (function (){var statearr_49349 = f__46725__auto__.call(null);
(statearr_49349[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___49354);

return statearr_49349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___49354,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args49367 = [];
var len__42287__auto___49437 = arguments.length;
var i__42288__auto___49438 = (0);
while(true){
if((i__42288__auto___49438 < len__42287__auto___49437)){
args49367.push((arguments[i__42288__auto___49438]));

var G__49439 = (i__42288__auto___49438 + (1));
i__42288__auto___49438 = G__49439;
continue;
} else {
}
break;
}

var G__49369 = args49367.length;
switch (G__49369) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49367.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46724__auto___49441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___49441,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___49441,out){
return (function (state_49407){
var state_val_49408 = (state_49407[(1)]);
if((state_val_49408 === (7))){
var inst_49403 = (state_49407[(2)]);
var state_49407__$1 = state_49407;
var statearr_49409_49442 = state_49407__$1;
(statearr_49409_49442[(2)] = inst_49403);

(statearr_49409_49442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (1))){
var inst_49370 = (new Array(n));
var inst_49371 = inst_49370;
var inst_49372 = (0);
var state_49407__$1 = (function (){var statearr_49410 = state_49407;
(statearr_49410[(7)] = inst_49371);

(statearr_49410[(8)] = inst_49372);

return statearr_49410;
})();
var statearr_49411_49443 = state_49407__$1;
(statearr_49411_49443[(2)] = null);

(statearr_49411_49443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (4))){
var inst_49375 = (state_49407[(9)]);
var inst_49375__$1 = (state_49407[(2)]);
var inst_49376 = (inst_49375__$1 == null);
var inst_49377 = cljs.core.not.call(null,inst_49376);
var state_49407__$1 = (function (){var statearr_49412 = state_49407;
(statearr_49412[(9)] = inst_49375__$1);

return statearr_49412;
})();
if(inst_49377){
var statearr_49413_49444 = state_49407__$1;
(statearr_49413_49444[(1)] = (5));

} else {
var statearr_49414_49445 = state_49407__$1;
(statearr_49414_49445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (15))){
var inst_49397 = (state_49407[(2)]);
var state_49407__$1 = state_49407;
var statearr_49415_49446 = state_49407__$1;
(statearr_49415_49446[(2)] = inst_49397);

(statearr_49415_49446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (13))){
var state_49407__$1 = state_49407;
var statearr_49416_49447 = state_49407__$1;
(statearr_49416_49447[(2)] = null);

(statearr_49416_49447[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (6))){
var inst_49372 = (state_49407[(8)]);
var inst_49393 = (inst_49372 > (0));
var state_49407__$1 = state_49407;
if(cljs.core.truth_(inst_49393)){
var statearr_49417_49448 = state_49407__$1;
(statearr_49417_49448[(1)] = (12));

} else {
var statearr_49418_49449 = state_49407__$1;
(statearr_49418_49449[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (3))){
var inst_49405 = (state_49407[(2)]);
var state_49407__$1 = state_49407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49407__$1,inst_49405);
} else {
if((state_val_49408 === (12))){
var inst_49371 = (state_49407[(7)]);
var inst_49395 = cljs.core.vec.call(null,inst_49371);
var state_49407__$1 = state_49407;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49407__$1,(15),out,inst_49395);
} else {
if((state_val_49408 === (2))){
var state_49407__$1 = state_49407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49407__$1,(4),ch);
} else {
if((state_val_49408 === (11))){
var inst_49387 = (state_49407[(2)]);
var inst_49388 = (new Array(n));
var inst_49371 = inst_49388;
var inst_49372 = (0);
var state_49407__$1 = (function (){var statearr_49419 = state_49407;
(statearr_49419[(7)] = inst_49371);

(statearr_49419[(10)] = inst_49387);

(statearr_49419[(8)] = inst_49372);

return statearr_49419;
})();
var statearr_49420_49450 = state_49407__$1;
(statearr_49420_49450[(2)] = null);

(statearr_49420_49450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (9))){
var inst_49371 = (state_49407[(7)]);
var inst_49385 = cljs.core.vec.call(null,inst_49371);
var state_49407__$1 = state_49407;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49407__$1,(11),out,inst_49385);
} else {
if((state_val_49408 === (5))){
var inst_49371 = (state_49407[(7)]);
var inst_49375 = (state_49407[(9)]);
var inst_49372 = (state_49407[(8)]);
var inst_49380 = (state_49407[(11)]);
var inst_49379 = (inst_49371[inst_49372] = inst_49375);
var inst_49380__$1 = (inst_49372 + (1));
var inst_49381 = (inst_49380__$1 < n);
var state_49407__$1 = (function (){var statearr_49421 = state_49407;
(statearr_49421[(12)] = inst_49379);

(statearr_49421[(11)] = inst_49380__$1);

return statearr_49421;
})();
if(cljs.core.truth_(inst_49381)){
var statearr_49422_49451 = state_49407__$1;
(statearr_49422_49451[(1)] = (8));

} else {
var statearr_49423_49452 = state_49407__$1;
(statearr_49423_49452[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (14))){
var inst_49400 = (state_49407[(2)]);
var inst_49401 = cljs.core.async.close_BANG_.call(null,out);
var state_49407__$1 = (function (){var statearr_49425 = state_49407;
(statearr_49425[(13)] = inst_49400);

return statearr_49425;
})();
var statearr_49426_49453 = state_49407__$1;
(statearr_49426_49453[(2)] = inst_49401);

(statearr_49426_49453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (10))){
var inst_49391 = (state_49407[(2)]);
var state_49407__$1 = state_49407;
var statearr_49427_49454 = state_49407__$1;
(statearr_49427_49454[(2)] = inst_49391);

(statearr_49427_49454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49408 === (8))){
var inst_49371 = (state_49407[(7)]);
var inst_49380 = (state_49407[(11)]);
var tmp49424 = inst_49371;
var inst_49371__$1 = tmp49424;
var inst_49372 = inst_49380;
var state_49407__$1 = (function (){var statearr_49428 = state_49407;
(statearr_49428[(7)] = inst_49371__$1);

(statearr_49428[(8)] = inst_49372);

return statearr_49428;
})();
var statearr_49429_49455 = state_49407__$1;
(statearr_49429_49455[(2)] = null);

(statearr_49429_49455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___49441,out))
;
return ((function (switch__46612__auto__,c__46724__auto___49441,out){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_49433 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49433[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_49433[(1)] = (1));

return statearr_49433;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_49407){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_49407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e49434){if((e49434 instanceof Object)){
var ex__46616__auto__ = e49434;
var statearr_49435_49456 = state_49407;
(statearr_49435_49456[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49407);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49457 = state_49407;
state_49407 = G__49457;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_49407){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_49407);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___49441,out))
})();
var state__46726__auto__ = (function (){var statearr_49436 = f__46725__auto__.call(null);
(statearr_49436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___49441);

return statearr_49436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___49441,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args49458 = [];
var len__42287__auto___49532 = arguments.length;
var i__42288__auto___49533 = (0);
while(true){
if((i__42288__auto___49533 < len__42287__auto___49532)){
args49458.push((arguments[i__42288__auto___49533]));

var G__49534 = (i__42288__auto___49533 + (1));
i__42288__auto___49533 = G__49534;
continue;
} else {
}
break;
}

var G__49460 = args49458.length;
switch (G__49460) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49458.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__46724__auto___49536 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__46724__auto___49536,out){
return (function (){
var f__46725__auto__ = (function (){var switch__46612__auto__ = ((function (c__46724__auto___49536,out){
return (function (state_49502){
var state_val_49503 = (state_49502[(1)]);
if((state_val_49503 === (7))){
var inst_49498 = (state_49502[(2)]);
var state_49502__$1 = state_49502;
var statearr_49504_49537 = state_49502__$1;
(statearr_49504_49537[(2)] = inst_49498);

(statearr_49504_49537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (1))){
var inst_49461 = [];
var inst_49462 = inst_49461;
var inst_49463 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49502__$1 = (function (){var statearr_49505 = state_49502;
(statearr_49505[(7)] = inst_49462);

(statearr_49505[(8)] = inst_49463);

return statearr_49505;
})();
var statearr_49506_49538 = state_49502__$1;
(statearr_49506_49538[(2)] = null);

(statearr_49506_49538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (4))){
var inst_49466 = (state_49502[(9)]);
var inst_49466__$1 = (state_49502[(2)]);
var inst_49467 = (inst_49466__$1 == null);
var inst_49468 = cljs.core.not.call(null,inst_49467);
var state_49502__$1 = (function (){var statearr_49507 = state_49502;
(statearr_49507[(9)] = inst_49466__$1);

return statearr_49507;
})();
if(inst_49468){
var statearr_49508_49539 = state_49502__$1;
(statearr_49508_49539[(1)] = (5));

} else {
var statearr_49509_49540 = state_49502__$1;
(statearr_49509_49540[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (15))){
var inst_49492 = (state_49502[(2)]);
var state_49502__$1 = state_49502;
var statearr_49510_49541 = state_49502__$1;
(statearr_49510_49541[(2)] = inst_49492);

(statearr_49510_49541[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (13))){
var state_49502__$1 = state_49502;
var statearr_49511_49542 = state_49502__$1;
(statearr_49511_49542[(2)] = null);

(statearr_49511_49542[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (6))){
var inst_49462 = (state_49502[(7)]);
var inst_49487 = inst_49462.length;
var inst_49488 = (inst_49487 > (0));
var state_49502__$1 = state_49502;
if(cljs.core.truth_(inst_49488)){
var statearr_49512_49543 = state_49502__$1;
(statearr_49512_49543[(1)] = (12));

} else {
var statearr_49513_49544 = state_49502__$1;
(statearr_49513_49544[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (3))){
var inst_49500 = (state_49502[(2)]);
var state_49502__$1 = state_49502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_49502__$1,inst_49500);
} else {
if((state_val_49503 === (12))){
var inst_49462 = (state_49502[(7)]);
var inst_49490 = cljs.core.vec.call(null,inst_49462);
var state_49502__$1 = state_49502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49502__$1,(15),out,inst_49490);
} else {
if((state_val_49503 === (2))){
var state_49502__$1 = state_49502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_49502__$1,(4),ch);
} else {
if((state_val_49503 === (11))){
var inst_49466 = (state_49502[(9)]);
var inst_49470 = (state_49502[(10)]);
var inst_49480 = (state_49502[(2)]);
var inst_49481 = [];
var inst_49482 = inst_49481.push(inst_49466);
var inst_49462 = inst_49481;
var inst_49463 = inst_49470;
var state_49502__$1 = (function (){var statearr_49514 = state_49502;
(statearr_49514[(7)] = inst_49462);

(statearr_49514[(11)] = inst_49482);

(statearr_49514[(8)] = inst_49463);

(statearr_49514[(12)] = inst_49480);

return statearr_49514;
})();
var statearr_49515_49545 = state_49502__$1;
(statearr_49515_49545[(2)] = null);

(statearr_49515_49545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (9))){
var inst_49462 = (state_49502[(7)]);
var inst_49478 = cljs.core.vec.call(null,inst_49462);
var state_49502__$1 = state_49502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_49502__$1,(11),out,inst_49478);
} else {
if((state_val_49503 === (5))){
var inst_49466 = (state_49502[(9)]);
var inst_49470 = (state_49502[(10)]);
var inst_49463 = (state_49502[(8)]);
var inst_49470__$1 = f.call(null,inst_49466);
var inst_49471 = cljs.core._EQ_.call(null,inst_49470__$1,inst_49463);
var inst_49472 = cljs.core.keyword_identical_QMARK_.call(null,inst_49463,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49473 = (inst_49471) || (inst_49472);
var state_49502__$1 = (function (){var statearr_49516 = state_49502;
(statearr_49516[(10)] = inst_49470__$1);

return statearr_49516;
})();
if(cljs.core.truth_(inst_49473)){
var statearr_49517_49546 = state_49502__$1;
(statearr_49517_49546[(1)] = (8));

} else {
var statearr_49518_49547 = state_49502__$1;
(statearr_49518_49547[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (14))){
var inst_49495 = (state_49502[(2)]);
var inst_49496 = cljs.core.async.close_BANG_.call(null,out);
var state_49502__$1 = (function (){var statearr_49520 = state_49502;
(statearr_49520[(13)] = inst_49495);

return statearr_49520;
})();
var statearr_49521_49548 = state_49502__$1;
(statearr_49521_49548[(2)] = inst_49496);

(statearr_49521_49548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (10))){
var inst_49485 = (state_49502[(2)]);
var state_49502__$1 = state_49502;
var statearr_49522_49549 = state_49502__$1;
(statearr_49522_49549[(2)] = inst_49485);

(statearr_49522_49549[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49503 === (8))){
var inst_49466 = (state_49502[(9)]);
var inst_49470 = (state_49502[(10)]);
var inst_49462 = (state_49502[(7)]);
var inst_49475 = inst_49462.push(inst_49466);
var tmp49519 = inst_49462;
var inst_49462__$1 = tmp49519;
var inst_49463 = inst_49470;
var state_49502__$1 = (function (){var statearr_49523 = state_49502;
(statearr_49523[(7)] = inst_49462__$1);

(statearr_49523[(8)] = inst_49463);

(statearr_49523[(14)] = inst_49475);

return statearr_49523;
})();
var statearr_49524_49550 = state_49502__$1;
(statearr_49524_49550[(2)] = null);

(statearr_49524_49550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46724__auto___49536,out))
;
return ((function (switch__46612__auto__,c__46724__auto___49536,out){
return (function() {
var cljs$core$async$state_machine__46613__auto__ = null;
var cljs$core$async$state_machine__46613__auto____0 = (function (){
var statearr_49528 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49528[(0)] = cljs$core$async$state_machine__46613__auto__);

(statearr_49528[(1)] = (1));

return statearr_49528;
});
var cljs$core$async$state_machine__46613__auto____1 = (function (state_49502){
while(true){
var ret_value__46614__auto__ = (function (){try{while(true){
var result__46615__auto__ = switch__46612__auto__.call(null,state_49502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__46615__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46615__auto__;
}
break;
}
}catch (e49529){if((e49529 instanceof Object)){
var ex__46616__auto__ = e49529;
var statearr_49530_49551 = state_49502;
(statearr_49530_49551[(5)] = ex__46616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_49502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49529;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__46614__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49552 = state_49502;
state_49502 = G__49552;
continue;
} else {
return ret_value__46614__auto__;
}
break;
}
});
cljs$core$async$state_machine__46613__auto__ = function(state_49502){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46613__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46613__auto____1.call(this,state_49502);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46613__auto____0;
cljs$core$async$state_machine__46613__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46613__auto____1;
return cljs$core$async$state_machine__46613__auto__;
})()
;})(switch__46612__auto__,c__46724__auto___49536,out))
})();
var state__46726__auto__ = (function (){var statearr_49531 = f__46725__auto__.call(null);
(statearr_49531[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__46724__auto___49536);

return statearr_49531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__46726__auto__);
});})(c__46724__auto___49536,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1495428388910