(ns synnex-ent.log
  "synnex-ent log tool, format log for es analysis, es-log-format, weekly,
   and save log in resources/log/app.log by default. - JG"
  (:require [taoensso.timbre :as timbre]
            [taoensso.timbre.appenders.3rd-party.rolling :as rolling]
            [clojure.string :as s]))


;;:refer [log debug info warn error spy]
;;;; Expose the `Timbre` log functions - They are macros.
(defmacro log [level & args]  `(timbre/log ~level ~@args))
(defmacro info [& args] `(timbre/info  ~@args))
(defmacro error [& args] `(timbre/error  ~@args))
(defmacro spy
  ([expr] `(timbre/spy ~expr))
  ([level expr] `(timbre/spy ~level ~expr)))

(defn- es-log-output-fn
  "Adapte to ES log. ES Log output format, for ES standard log analysis tool. Most are based
   on `Timbre` standard functions. Only add Application Name info to the log - `app-name` "
  [app-name {:keys [vargs_ ?file timestamp_ level ?line] :as args}]
  (let [timestamp (str "[" @timestamp_ "]")
        file ?file
        line (str "[Line:" ?line "]")
        level (s/upper-case (str "[" (s/replace level ":" "") "]"))
        msg (s/join @vargs_)]
    (s/join " - " [timestamp app-name file line level msg])))


(defn start-log
  "Config to Start `Timbre` log.You can add your configuration in a map to start log.
   A default configuration will be used, if no conf provided when init:
             :app \"my-app\"
             :appender :rolling-appender
             :pattern :daily
             :path \"resoures/log/app.log\"
   Start with your own conf by: start-log :appender :x, pattern :y, :path :z."
  [ & {:keys [app appender pattern path] :or {app "my-app"
                                              appender "rolling"
                                              pattern :daily
                                              path "resources/log/app.log"}}]
  (timbre/merge-config!
   {:appenders {
                :println {:enabled? true}
                :spit    (merge (rolling/rolling-appender
                                 {:path path
                                  :pattern pattern})
                                {:output-fn (partial es-log-output-fn app)})}})
  (println "SYNNEX ENT->log by timbre initialized..."))

;; => (start-log :app "Vendor-Licence" :pattern :daily :path "resources/log/my-vend-licence.log).
