(defproject synnex-ent.log "0.1.1"
  :description "SYNNEX ENT clojure log common library based on Timbre."
  :url "https://git.synnex.org/projects/ENT/repos/synnex-ent-log"
  :license {:name "SYNNEX China Owned"
            :url  "http://www.synnex-china.com"}
  :dependencies [[org.clojure/clojure "1.10.1"] ;clojure major library.
                 [com.taoensso/timbre "5.1.2"]] ;log
  :main ^:skip-aot synnex-ent.log
  :repl-options {:init-ns synnex-ent.log}

  :profiles
  {:dev
   {:dependencies
    [[org.clojure/clojure "1.10.1"]
     [com.taoensso/timbre "5.1.2"]]

    :Jvm-opts
    ["-Xverify:none"]}

   :eastwood
   {:plugins
    [[jonase/eastwood "0.4.0" :exclusions [org.clojure/clojure]]]

    :add-linters
    [:unused-private-vars
     :unused-namespaces
     :unused-fn-args
     :unused-locals]

    :exclude-linters
    [:deprecations]}

   :docstring-checker
   {:plugins
    [[docstring-checker "1.1.0"]]

    :docstring-checker
    {:exclude [#"test"]}}

   :bikeshed
   {:plugins
    [[lein-bikeshed "0.5.2"]]}

   :check-namespace-decls
   {:plugins               [[lein-check-namespace-decls "1.0.3"]]
    :source-paths          ["test"]
    :check-namespace-decls {:prefix-rewriting true}}}

  :deploy-repositories
  [["clojars"
    {:url           "https://clojars.org/repo"
     :username      :env/clojars_username
     :password      :env/clojars_password
     :sign-releases false}]]

  )
