// Compiled by ClojureScript 1.8.51 {}
goog.provide('untangled_spec.async');
goog.require('cljs.core');
goog.require('cljs.pprint');

/**
 * @interface
 */
untangled_spec.async.IAsyncQueue = function(){};

/**
 * Returns the current time on the simulated clock, in ms
 */
untangled_spec.async.current_time = (function untangled_spec$async$current_time(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$current_time$arity$1 == null)))){
return this$.untangled_spec$async$IAsyncQueue$current_time$arity$1(this$);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (untangled_spec.async.current_time[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$);
} else {
var m__29364__auto____$1 = (untangled_spec.async.current_time["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.current-time",this$);
}
}
}
});

/**
 * Returns the first event on the queue
 */
untangled_spec.async.peek_event = (function untangled_spec$async$peek_event(this$){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$peek_event$arity$1 == null)))){
return this$.untangled_spec$async$IAsyncQueue$peek_event$arity$1(this$);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (untangled_spec.async.peek_event[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$);
} else {
var m__29364__auto____$1 = (untangled_spec.async.peek_event["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.peek-event",this$);
}
}
}
});

/**
 * Move the clock forward by the specified number of ms, triggering events (even those added by interstitial triggers) in the correct order up to (and including) events that coincide with the final time.
 */
untangled_spec.async.advance_clock = (function untangled_spec$async$advance_clock(this$,ms){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$advance_clock$arity$2 == null)))){
return this$.untangled_spec$async$IAsyncQueue$advance_clock$arity$2(this$,ms);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (untangled_spec.async.advance_clock[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$,ms);
} else {
var m__29364__auto____$1 = (untangled_spec.async.advance_clock["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$,ms);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.advance-clock",this$);
}
}
}
});

/**
 * Schedule an event which should occur at some time in the future (offset from now).
 */
untangled_spec.async.schedule_event = (function untangled_spec$async$schedule_event(this$,ms_from_now,fn_to_call){
if((!((this$ == null))) && (!((this$.untangled_spec$async$IAsyncQueue$schedule_event$arity$3 == null)))){
return this$.untangled_spec$async$IAsyncQueue$schedule_event$arity$3(this$,ms_from_now,fn_to_call);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (untangled_spec.async.schedule_event[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$,ms_from_now,fn_to_call);
} else {
var m__29364__auto____$1 = (untangled_spec.async.schedule_event["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$,ms_from_now,fn_to_call);
} else {
throw cljs.core.missing_protocol.call(null,"IAsyncQueue.schedule-event",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.async.Event = (function (abs_time,fn_to_call,__meta,__extmap,__hash){
this.abs_time = abs_time;
this.fn_to_call = fn_to_call;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
untangled_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__29322__auto__,k__29323__auto__){
var self__ = this;
var this__29322__auto____$1 = this;
return cljs.core._lookup.call(null,this__29322__auto____$1,k__29323__auto__,null);
});

untangled_spec.async.Event.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__29324__auto__,k31307,else__29325__auto__){
var self__ = this;
var this__29324__auto____$1 = this;
var G__31309 = (((k31307 instanceof cljs.core.Keyword))?k31307.fqn:null);
switch (G__31309) {
case "abs-time":
return self__.abs_time;

break;
case "fn-to-call":
return self__.fn_to_call;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k31307,else__29325__auto__);

}
});

untangled_spec.async.Event.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__29336__auto__,writer__29337__auto__,opts__29338__auto__){
var self__ = this;
var this__29336__auto____$1 = this;
var pr_pair__29339__auto__ = ((function (this__29336__auto____$1){
return (function (keyval__29340__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__29337__auto__,cljs.core.pr_writer,""," ","",opts__29338__auto__,keyval__29340__auto__);
});})(this__29336__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__29337__auto__,pr_pair__29339__auto__,"#untangled-spec.async.Event{",", ","}",opts__29338__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});

untangled_spec.async.Event.prototype.cljs$core$IIterable$ = true;

untangled_spec.async.Event.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31306){
var self__ = this;
var G__31306__$1 = this;
return (new cljs.core.RecordIter((0),G__31306__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

untangled_spec.async.Event.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__29320__auto__){
var self__ = this;
var this__29320__auto____$1 = this;
return self__.__meta;
});

untangled_spec.async.Event.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__29316__auto__){
var self__ = this;
var this__29316__auto____$1 = this;
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,self__.__extmap,self__.__hash));
});

untangled_spec.async.Event.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__29326__auto__){
var self__ = this;
var this__29326__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

untangled_spec.async.Event.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__29317__auto__){
var self__ = this;
var this__29317__auto____$1 = this;
var h__29135__auto__ = self__.__hash;
if(!((h__29135__auto__ == null))){
return h__29135__auto__;
} else {
var h__29135__auto____$1 = cljs.core.hash_imap.call(null,this__29317__auto____$1);
self__.__hash = h__29135__auto____$1;

return h__29135__auto____$1;
}
});

untangled_spec.async.Event.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__29318__auto__,other__29319__auto__){
var self__ = this;
var this__29318__auto____$1 = this;
if(cljs.core.truth_((function (){var and__28688__auto__ = other__29319__auto__;
if(cljs.core.truth_(and__28688__auto__)){
var and__28688__auto____$1 = (this__29318__auto____$1.constructor === other__29319__auto__.constructor);
if(and__28688__auto____$1){
return cljs.core.equiv_map.call(null,this__29318__auto____$1,other__29319__auto__);
} else {
return and__28688__auto____$1;
}
} else {
return and__28688__auto__;
}
})())){
return true;
} else {
return false;
}
});

untangled_spec.async.Event.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__29331__auto__,k__29332__auto__){
var self__ = this;
var this__29331__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"abs-time","abs-time",59488074),null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),null], null), null),k__29332__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__29331__auto____$1),self__.__meta),k__29332__auto__);
} else {
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__29332__auto__)),null));
}
});

untangled_spec.async.Event.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__29329__auto__,k__29330__auto__,G__31306){
var self__ = this;
var this__29329__auto____$1 = this;
var pred__31310 = cljs.core.keyword_identical_QMARK_;
var expr__31311 = k__29330__auto__;
if(cljs.core.truth_(pred__31310.call(null,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),expr__31311))){
return (new untangled_spec.async.Event(G__31306,self__.fn_to_call,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__31310.call(null,new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),expr__31311))){
return (new untangled_spec.async.Event(self__.abs_time,G__31306,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__29330__auto__,G__31306),null));
}
}
});

untangled_spec.async.Event.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__29334__auto__){
var self__ = this;
var this__29334__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"abs-time","abs-time",59488074),self__.abs_time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373),self__.fn_to_call],null))], null),self__.__extmap));
});

untangled_spec.async.Event.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__29321__auto__,G__31306){
var self__ = this;
var this__29321__auto____$1 = this;
return (new untangled_spec.async.Event(self__.abs_time,self__.fn_to_call,G__31306,self__.__extmap,self__.__hash));
});

untangled_spec.async.Event.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__29327__auto__,entry__29328__auto__){
var self__ = this;
var this__29327__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__29328__auto__)){
return cljs.core._assoc.call(null,this__29327__auto____$1,cljs.core._nth.call(null,entry__29328__auto__,(0)),cljs.core._nth.call(null,entry__29328__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__29327__auto____$1,entry__29328__auto__);
}
});

untangled_spec.async.Event.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"abs-time","abs-time",1700019601,null),new cljs.core.Symbol(null,"fn-to-call","fn-to-call",1043613154,null)], null);
});

untangled_spec.async.Event.cljs$lang$type = true;

untangled_spec.async.Event.cljs$lang$ctorPrSeq = (function (this__29356__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.async/Event");
});

untangled_spec.async.Event.cljs$lang$ctorPrWriter = (function (this__29356__auto__,writer__29357__auto__){
return cljs.core._write.call(null,writer__29357__auto__,"untangled-spec.async/Event");
});

untangled_spec.async.__GT_Event = (function untangled_spec$async$__GT_Event(abs_time,fn_to_call){
return (new untangled_spec.async.Event(abs_time,fn_to_call,null,null,null));
});

untangled_spec.async.map__GT_Event = (function untangled_spec$async$map__GT_Event(G__31308){
return (new untangled_spec.async.Event(new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(G__31308),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(G__31308),null,cljs.core.dissoc.call(null,G__31308,new cljs.core.Keyword(null,"abs-time","abs-time",59488074),new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373)),null));
});

/**
 * Triggers the first event in the queue (runs it), and removes it from the queue.
 */
untangled_spec.async.process_first_event_BANG_ = (function untangled_spec$async$process_first_event_BANG_(queue){
var temp__4655__auto__ = untangled_spec.async.peek_event.call(null,queue);
if(cljs.core.truth_(temp__4655__auto__)){
var evt = temp__4655__auto__;
new cljs.core.Keyword(null,"fn-to-call","fn-to-call",-596918373).cljs$core$IFn$_invoke$arity$1(evt).call(null);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(queue),((function (evt,temp__4655__auto__){
return (function (p1__31314_SHARP_){
return cljs.core.dissoc.call(null,p1__31314_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt));
});})(evt,temp__4655__auto__))
);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {untangled_spec.async.IAsyncQueue}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.async.AsyncQueue = (function (schedule,now,__meta,__extmap,__hash){
this.schedule = schedule;
this.now = now;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
untangled_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__29322__auto__,k__29323__auto__){
var self__ = this;
var this__29322__auto____$1 = this;
return cljs.core._lookup.call(null,this__29322__auto____$1,k__29323__auto__,null);
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__29324__auto__,k31317,else__29325__auto__){
var self__ = this;
var this__29324__auto____$1 = this;
var G__31319 = (((k31317 instanceof cljs.core.Keyword))?k31317.fqn:null);
switch (G__31319) {
case "schedule":
return self__.schedule;

break;
case "now":
return self__.now;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k31317,else__29325__auto__);

}
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__29336__auto__,writer__29337__auto__,opts__29338__auto__){
var self__ = this;
var this__29336__auto____$1 = this;
var pr_pair__29339__auto__ = ((function (this__29336__auto____$1){
return (function (keyval__29340__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__29337__auto__,cljs.core.pr_writer,""," ","",opts__29338__auto__,keyval__29340__auto__);
});})(this__29336__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__29337__auto__,pr_pair__29339__auto__,"#untangled-spec.async.AsyncQueue{",", ","}",opts__29338__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IIterable$ = true;

untangled_spec.async.AsyncQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31316){
var self__ = this;
var G__31316__$1 = this;
return (new cljs.core.RecordIter((0),G__31316__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__29320__auto__){
var self__ = this;
var this__29320__auto____$1 = this;
return self__.__meta;
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__29316__auto__){
var self__ = this;
var this__29316__auto____$1 = this;
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,self__.__extmap,self__.__hash));
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__29326__auto__){
var self__ = this;
var this__29326__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__29317__auto__){
var self__ = this;
var this__29317__auto____$1 = this;
var h__29135__auto__ = self__.__hash;
if(!((h__29135__auto__ == null))){
return h__29135__auto__;
} else {
var h__29135__auto____$1 = cljs.core.hash_imap.call(null,this__29317__auto____$1);
self__.__hash = h__29135__auto____$1;

return h__29135__auto____$1;
}
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__29318__auto__,other__29319__auto__){
var self__ = this;
var this__29318__auto____$1 = this;
if(cljs.core.truth_((function (){var and__28688__auto__ = other__29319__auto__;
if(cljs.core.truth_(and__28688__auto__)){
var and__28688__auto____$1 = (this__29318__auto____$1.constructor === other__29319__auto__.constructor);
if(and__28688__auto____$1){
return cljs.core.equiv_map.call(null,this__29318__auto____$1,other__29319__auto__);
} else {
return and__28688__auto____$1;
}
} else {
return and__28688__auto__;
}
})())){
return true;
} else {
return false;
}
});

untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$ = true;

untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$current_time$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1));
});

untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$peek_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1))));
});

untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$advance_clock$arity$2 = (function (this$,ms){
var self__ = this;
var this$__$1 = this;
var stop_time = (ms + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var evt_31324 = untangled_spec.async.peek_event.call(null,this$__$1);
while(true){
var now_31325__$1 = (function (){var or__28700__auto__ = new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(evt_31324);
if(cljs.core.truth_(or__28700__auto__)){
return or__28700__auto__;
} else {
return (stop_time + (1));
}
})();
if((now_31325__$1 <= stop_time)){
cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),now_31325__$1);

untangled_spec.async.process_first_event_BANG_.call(null,this$__$1);

var G__31326 = untangled_spec.async.peek_event.call(null,this$__$1);
evt_31324 = G__31326;
continue;
} else {
}
break;
}

return cljs.core.reset_BANG_.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1),stop_time);
});

untangled_spec.async.AsyncQueue.prototype.untangled_spec$async$IAsyncQueue$schedule_event$arity$3 = (function (this$,ms_from_now,fn_to_call){
var self__ = this;
var this$__$1 = this;
var tm = (ms_from_now + cljs.core.deref.call(null,new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(this$__$1)));
var event = (new untangled_spec.async.Event(tm,fn_to_call,null,null,null));
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1)),tm)){
throw cljs.core.ex_info.call(null,[cljs.core.str("Schedule already contains an event "),cljs.core.str(ms_from_now),cljs.core.str("ms from 'now' which would generate an indeterminant ordering for your events. Please offset your submission time a bit")].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(this$__$1),((function (tm,event,this$__$1){
return (function (p1__31315_SHARP_){
return cljs.core.assoc.call(null,p1__31315_SHARP_,new cljs.core.Keyword(null,"abs-time","abs-time",59488074).cljs$core$IFn$_invoke$arity$1(event),event);
});})(tm,event,this$__$1))
);
}
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__29331__auto__,k__29332__auto__){
var self__ = this;
var this__29331__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schedule","schedule",349275266),null,new cljs.core.Keyword(null,"now","now",-1650525531),null], null), null),k__29332__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__29331__auto____$1),self__.__meta),k__29332__auto__);
} else {
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__29332__auto__)),null));
}
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__29329__auto__,k__29330__auto__,G__31316){
var self__ = this;
var this__29329__auto____$1 = this;
var pred__31320 = cljs.core.keyword_identical_QMARK_;
var expr__31321 = k__29330__auto__;
if(cljs.core.truth_(pred__31320.call(null,new cljs.core.Keyword(null,"schedule","schedule",349275266),expr__31321))){
return (new untangled_spec.async.AsyncQueue(G__31316,self__.now,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__31320.call(null,new cljs.core.Keyword(null,"now","now",-1650525531),expr__31321))){
return (new untangled_spec.async.AsyncQueue(self__.schedule,G__31316,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__29330__auto__,G__31316),null));
}
}
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__29334__auto__){
var self__ = this;
var this__29334__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schedule","schedule",349275266),self__.schedule],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"now","now",-1650525531),self__.now],null))], null),self__.__extmap));
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__29321__auto__,G__31316){
var self__ = this;
var this__29321__auto____$1 = this;
return (new untangled_spec.async.AsyncQueue(self__.schedule,self__.now,G__31316,self__.__extmap,self__.__hash));
});

untangled_spec.async.AsyncQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__29327__auto__,entry__29328__auto__){
var self__ = this;
var this__29327__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__29328__auto__)){
return cljs.core._assoc.call(null,this__29327__auto____$1,cljs.core._nth.call(null,entry__29328__auto__,(0)),cljs.core._nth.call(null,entry__29328__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__29327__auto____$1,entry__29328__auto__);
}
});

untangled_spec.async.AsyncQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schedule","schedule",1989806793,null),new cljs.core.Symbol(null,"now","now",-9994004,null)], null);
});

untangled_spec.async.AsyncQueue.cljs$lang$type = true;

untangled_spec.async.AsyncQueue.cljs$lang$ctorPrSeq = (function (this__29356__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.async/AsyncQueue");
});

untangled_spec.async.AsyncQueue.cljs$lang$ctorPrWriter = (function (this__29356__auto__,writer__29357__auto__){
return cljs.core._write.call(null,writer__29357__auto__,"untangled-spec.async/AsyncQueue");
});

untangled_spec.async.__GT_AsyncQueue = (function untangled_spec$async$__GT_AsyncQueue(schedule,now){
return (new untangled_spec.async.AsyncQueue(schedule,now,null,null,null));
});

untangled_spec.async.map__GT_AsyncQueue = (function untangled_spec$async$map__GT_AsyncQueue(G__31318){
return (new untangled_spec.async.AsyncQueue(new cljs.core.Keyword(null,"schedule","schedule",349275266).cljs$core$IFn$_invoke$arity$1(G__31318),new cljs.core.Keyword(null,"now","now",-1650525531).cljs$core$IFn$_invoke$arity$1(G__31318),null,cljs.core.dissoc.call(null,G__31318,new cljs.core.Keyword(null,"schedule","schedule",349275266),new cljs.core.Keyword(null,"now","now",-1650525531)),null));
});

/**
 * Build an asynchronous event simulation queue.
 */
untangled_spec.async.make_async_queue = (function untangled_spec$async$make_async_queue(){
return (new untangled_spec.async.AsyncQueue(cljs.core.atom.call(null,cljs.core.sorted_map.call(null)),cljs.core.atom.call(null,(0)),null,null,null));
});

//# sourceMappingURL=async.js.map