// Compiled by ClojureScript 1.8.51 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
/**
 * Traverses up the DOM tree and returns the first node that contains a href attr
 */
pushy.core.recur_href = (function pushy$core$recur_href(target){
if(cljs.core.truth_(target.href)){
return target;
} else {
if(cljs.core.truth_(target.parentNode)){
return pushy$core$recur_href.call(null,target.parentNode);
} else {
return null;
}
}
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__34848 = h;
G__34848.setUseFragment(false);

G__34848.setPathPrefix("");

G__34848.setEnabled(true);

return G__34848;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str(location.pathname),cljs.core.str(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str(path_prefix),cljs.core.str(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var args34849 = [];
var len__29770__auto___34852 = arguments.length;
var i__29771__auto___34853 = (0);
while(true){
if((i__29771__auto___34853 < len__29770__auto___34852)){
args34849.push((arguments[i__29771__auto___34853]));

var G__34854 = (i__29771__auto___34853 + (1));
i__29771__auto___34853 = G__34854;
continue;
} else {
}
break;
}

var G__34851 = args34849.length;
switch (G__34851) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34849.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;

/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var args34856 = [];
var len__29770__auto___34862 = arguments.length;
var i__29771__auto___34863 = (0);
while(true){
if((i__29771__auto___34863 < len__29770__auto___34862)){
args34856.push((arguments[i__29771__auto___34863]));

var G__34864 = (i__29771__auto___34863 + (1));
i__29771__auto___34863 = G__34864;
continue;
} else {
}
break;
}

var G__34858 = args34856.length;
switch (G__34858) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34856.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$,token);
} else {
var m__29364__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$,token,title);
} else {
var m__29364__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;

pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var args34859 = [];
var len__29770__auto___34866 = arguments.length;
var i__29771__auto___34867 = (0);
while(true){
if((i__29771__auto___34867 < len__29770__auto___34866)){
args34859.push((arguments[i__29771__auto___34867]));

var G__34868 = (i__29771__auto___34867 + (1));
i__29771__auto___34867 = G__34868;
continue;
} else {
}
break;
}

var G__34861 = args34859.length;
switch (G__34861) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34859.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$,token);
} else {
var m__29364__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$,token,title);
} else {
var m__29364__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;

pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.get_token[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$);
} else {
var m__29364__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$);
} else {
var m__29364__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__29363__auto__ = (((this$ == null))?null:this$);
var m__29364__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__29363__auto__)]);
if(!((m__29364__auto__ == null))){
return m__29364__auto__.call(null,this$);
} else {
var m__29364__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__29364__auto____$1 == null))){
return m__29364__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (cljs.core.some_QMARK_.call(null,cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("^"),cljs.core.str(location.origin),cljs.core.str(".*$")].join('')),[cljs.core.str(uri)].join('')))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str(path),cljs.core.str("?"),cljs.core.str(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__29777__auto__ = [];
var len__29770__auto___34883 = arguments.length;
var i__29771__auto___34884 = (0);
while(true){
if((i__29771__auto___34884 < len__29770__auto___34883)){
args__29777__auto__.push((arguments[i__29771__auto___34884]));

var G__34885 = (i__29771__auto___34884 + (1));
i__29771__auto___34884 = G__34885;
continue;
} else {
}
break;
}

var argseq__29778__auto__ = ((((2) < args__29777__auto__.length))?(new cljs.core.IndexedSeq(args__29777__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29778__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__34873){
var map__34874 = p__34873;
var map__34874__$1 = ((((!((map__34874 == null)))?((((map__34874.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34874.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34874):map__34874);
var processable_url_QMARK_ = cljs.core.get.call(null,map__34874__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__34874__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core34876 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core34876 = (function (dispatch_fn,match_fn,p__34873,map__34874,processable_url_QMARK_,identity_fn,history,event_keys,meta34877){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__34873 = p__34873;
this.map__34874 = map__34874;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.history = history;
this.event_keys = event_keys;
this.meta34877 = meta34877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
pushy.core.t_pushy$core34876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_34878,meta34877__$1){
var self__ = this;
var _34878__$1 = this;
return (new pushy.core.t_pushy$core34876(self__.dispatch_fn,self__.match_fn,self__.p__34873,self__.map__34874,self__.processable_url_QMARK_,self__.identity_fn,self__.history,self__.event_keys,meta34877__$1));
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_34878){
var self__ = this;
var _34878__$1 = this;
return self__.meta34877;
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$ = true;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__4657__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__4657__auto__)){
var match = temp__4657__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
));

var temp__4657__auto___34886 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__4657__auto___34886)){
var match_34887 = temp__4657__auto___34886;
self__.dispatch_fn.call(null,match_34887);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__4657__auto__ = pushy.core.recur_href.call(null,e.target);
if(cljs.core.truth_(temp__4657__auto__)){
var el = temp__4657__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__28688__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__28688__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && (cljs.core.not_EQ_.call(null,(1),e.button));
} else {
return and__28688__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__4655__auto___34888 = el.title;
if(cljs.core.truth_(temp__4655__auto___34888)){
var title_34889 = temp__4655__auto___34888;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_34889);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
));

return null;
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__34879_34890 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__34880_34891 = null;
var count__34881_34892 = (0);
var i__34882_34893 = (0);
while(true){
if((i__34882_34893 < count__34881_34892)){
var key_34894 = cljs.core._nth.call(null,chunk__34880_34891,i__34882_34893);
goog.events.unlistenByKey(key_34894);

var G__34895 = seq__34879_34890;
var G__34896 = chunk__34880_34891;
var G__34897 = count__34881_34892;
var G__34898 = (i__34882_34893 + (1));
seq__34879_34890 = G__34895;
chunk__34880_34891 = G__34896;
count__34881_34892 = G__34897;
i__34882_34893 = G__34898;
continue;
} else {
var temp__4657__auto___34899 = cljs.core.seq.call(null,seq__34879_34890);
if(temp__4657__auto___34899){
var seq__34879_34900__$1 = temp__4657__auto___34899;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34879_34900__$1)){
var c__29511__auto___34901 = cljs.core.chunk_first.call(null,seq__34879_34900__$1);
var G__34902 = cljs.core.chunk_rest.call(null,seq__34879_34900__$1);
var G__34903 = c__29511__auto___34901;
var G__34904 = cljs.core.count.call(null,c__29511__auto___34901);
var G__34905 = (0);
seq__34879_34890 = G__34902;
chunk__34880_34891 = G__34903;
count__34881_34892 = G__34904;
i__34882_34893 = G__34905;
continue;
} else {
var key_34906 = cljs.core.first.call(null,seq__34879_34900__$1);
goog.events.unlistenByKey(key_34906);

var G__34907 = cljs.core.next.call(null,seq__34879_34900__$1);
var G__34908 = null;
var G__34909 = (0);
var G__34910 = (0);
seq__34879_34890 = G__34907;
chunk__34880_34891 = G__34908;
count__34881_34892 = G__34909;
i__34882_34893 = G__34910;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.getBasis = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__34873","p__34873",-748010252,null),new cljs.core.Symbol(null,"map__34874","map__34874",915215894,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta34877","meta34877",1983283533,null)], null);
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core34876.cljs$lang$type = true;

pushy.core.t_pushy$core34876.cljs$lang$ctorStr = "pushy.core/t_pushy$core34876";

pushy.core.t_pushy$core34876.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"pushy.core/t_pushy$core34876");
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.__GT_t_pushy$core34876 = ((function (history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn){
return (function pushy$core$__GT_t_pushy$core34876(dispatch_fn__$1,match_fn__$1,p__34873__$1,map__34874__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta34877){
return (new pushy.core.t_pushy$core34876(dispatch_fn__$1,match_fn__$1,p__34873__$1,map__34874__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta34877));
});})(history,event_keys,map__34874,map__34874__$1,processable_url_QMARK_,identity_fn))
;

}

return (new pushy.core.t_pushy$core34876(dispatch_fn,match_fn,p__34873,map__34874__$1,processable_url_QMARK_,identity_fn,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq34870){
var G__34871 = cljs.core.first.call(null,seq34870);
var seq34870__$1 = cljs.core.next.call(null,seq34870);
var G__34872 = cljs.core.first.call(null,seq34870__$1);
var seq34870__$2 = cljs.core.next.call(null,seq34870__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__34871,G__34872,seq34870__$2);
});
/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var args34911 = [];
var len__29770__auto___34914 = arguments.length;
var i__29771__auto___34915 = (0);
while(true){
if((i__29771__auto___34915 < len__29770__auto___34914)){
args34911.push((arguments[i__29771__auto___34915]));

var G__34916 = (i__29771__auto___34915 + (1));
i__29771__auto___34915 = G__34916;
continue;
} else {
}
break;
}

var G__34913 = args34911.length;
switch (G__34913) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34911.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;
pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var args34918 = [];
var len__29770__auto___34921 = arguments.length;
var i__29771__auto___34922 = (0);
while(true){
if((i__29771__auto___34922 < len__29770__auto___34921)){
args34918.push((arguments[i__29771__auto___34922]));

var G__34923 = (i__29771__auto___34922 + (1));
i__29771__auto___34922 = G__34923;
continue;
} else {
}
break;
}

var G__34920 = args34918.length;
switch (G__34920) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34918.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=core.js.map