// Compiled by ClojureScript 1.8.51 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28696__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28696__auto__){
return or__28696__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28696__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__28696__auto__)){
return or__28696__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33647_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33647_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__33652 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__33653 = null;
var count__33654 = (0);
var i__33655 = (0);
while(true){
if((i__33655 < count__33654)){
var n = cljs.core._nth.call(null,chunk__33653,i__33655);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33656 = seq__33652;
var G__33657 = chunk__33653;
var G__33658 = count__33654;
var G__33659 = (i__33655 + (1));
seq__33652 = G__33656;
chunk__33653 = G__33657;
count__33654 = G__33658;
i__33655 = G__33659;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33652);
if(temp__4657__auto__){
var seq__33652__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33652__$1)){
var c__29507__auto__ = cljs.core.chunk_first.call(null,seq__33652__$1);
var G__33660 = cljs.core.chunk_rest.call(null,seq__33652__$1);
var G__33661 = c__29507__auto__;
var G__33662 = cljs.core.count.call(null,c__29507__auto__);
var G__33663 = (0);
seq__33652 = G__33660;
chunk__33653 = G__33661;
count__33654 = G__33662;
i__33655 = G__33663;
continue;
} else {
var n = cljs.core.first.call(null,seq__33652__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33664 = cljs.core.next.call(null,seq__33652__$1);
var G__33665 = null;
var G__33666 = (0);
var G__33667 = (0);
seq__33652 = G__33664;
chunk__33653 = G__33665;
count__33654 = G__33666;
i__33655 = G__33667;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33706_33713 = cljs.core.seq.call(null,deps);
var chunk__33707_33714 = null;
var count__33708_33715 = (0);
var i__33709_33716 = (0);
while(true){
if((i__33709_33716 < count__33708_33715)){
var dep_33717 = cljs.core._nth.call(null,chunk__33707_33714,i__33709_33716);
topo_sort_helper_STAR_.call(null,dep_33717,(depth + (1)),state);

var G__33718 = seq__33706_33713;
var G__33719 = chunk__33707_33714;
var G__33720 = count__33708_33715;
var G__33721 = (i__33709_33716 + (1));
seq__33706_33713 = G__33718;
chunk__33707_33714 = G__33719;
count__33708_33715 = G__33720;
i__33709_33716 = G__33721;
continue;
} else {
var temp__4657__auto___33722 = cljs.core.seq.call(null,seq__33706_33713);
if(temp__4657__auto___33722){
var seq__33706_33723__$1 = temp__4657__auto___33722;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33706_33723__$1)){
var c__29507__auto___33724 = cljs.core.chunk_first.call(null,seq__33706_33723__$1);
var G__33725 = cljs.core.chunk_rest.call(null,seq__33706_33723__$1);
var G__33726 = c__29507__auto___33724;
var G__33727 = cljs.core.count.call(null,c__29507__auto___33724);
var G__33728 = (0);
seq__33706_33713 = G__33725;
chunk__33707_33714 = G__33726;
count__33708_33715 = G__33727;
i__33709_33716 = G__33728;
continue;
} else {
var dep_33729 = cljs.core.first.call(null,seq__33706_33723__$1);
topo_sort_helper_STAR_.call(null,dep_33729,(depth + (1)),state);

var G__33730 = cljs.core.next.call(null,seq__33706_33723__$1);
var G__33731 = null;
var G__33732 = (0);
var G__33733 = (0);
seq__33706_33713 = G__33730;
chunk__33707_33714 = G__33731;
count__33708_33715 = G__33732;
i__33709_33716 = G__33733;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33710){
var vec__33712 = p__33710;
var x = cljs.core.nth.call(null,vec__33712,(0),null);
var xs = cljs.core.nthnext.call(null,vec__33712,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__33712,x,xs,get_deps__$1){
return (function (p1__33668_SHARP_){
return clojure.set.difference.call(null,p1__33668_SHARP_,x);
});})(vec__33712,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__33746 = cljs.core.seq.call(null,provides);
var chunk__33747 = null;
var count__33748 = (0);
var i__33749 = (0);
while(true){
if((i__33749 < count__33748)){
var prov = cljs.core._nth.call(null,chunk__33747,i__33749);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33750_33758 = cljs.core.seq.call(null,requires);
var chunk__33751_33759 = null;
var count__33752_33760 = (0);
var i__33753_33761 = (0);
while(true){
if((i__33753_33761 < count__33752_33760)){
var req_33762 = cljs.core._nth.call(null,chunk__33751_33759,i__33753_33761);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33762,prov);

var G__33763 = seq__33750_33758;
var G__33764 = chunk__33751_33759;
var G__33765 = count__33752_33760;
var G__33766 = (i__33753_33761 + (1));
seq__33750_33758 = G__33763;
chunk__33751_33759 = G__33764;
count__33752_33760 = G__33765;
i__33753_33761 = G__33766;
continue;
} else {
var temp__4657__auto___33767 = cljs.core.seq.call(null,seq__33750_33758);
if(temp__4657__auto___33767){
var seq__33750_33768__$1 = temp__4657__auto___33767;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33750_33768__$1)){
var c__29507__auto___33769 = cljs.core.chunk_first.call(null,seq__33750_33768__$1);
var G__33770 = cljs.core.chunk_rest.call(null,seq__33750_33768__$1);
var G__33771 = c__29507__auto___33769;
var G__33772 = cljs.core.count.call(null,c__29507__auto___33769);
var G__33773 = (0);
seq__33750_33758 = G__33770;
chunk__33751_33759 = G__33771;
count__33752_33760 = G__33772;
i__33753_33761 = G__33773;
continue;
} else {
var req_33774 = cljs.core.first.call(null,seq__33750_33768__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33774,prov);

var G__33775 = cljs.core.next.call(null,seq__33750_33768__$1);
var G__33776 = null;
var G__33777 = (0);
var G__33778 = (0);
seq__33750_33758 = G__33775;
chunk__33751_33759 = G__33776;
count__33752_33760 = G__33777;
i__33753_33761 = G__33778;
continue;
}
} else {
}
}
break;
}

var G__33779 = seq__33746;
var G__33780 = chunk__33747;
var G__33781 = count__33748;
var G__33782 = (i__33749 + (1));
seq__33746 = G__33779;
chunk__33747 = G__33780;
count__33748 = G__33781;
i__33749 = G__33782;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33746);
if(temp__4657__auto__){
var seq__33746__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33746__$1)){
var c__29507__auto__ = cljs.core.chunk_first.call(null,seq__33746__$1);
var G__33783 = cljs.core.chunk_rest.call(null,seq__33746__$1);
var G__33784 = c__29507__auto__;
var G__33785 = cljs.core.count.call(null,c__29507__auto__);
var G__33786 = (0);
seq__33746 = G__33783;
chunk__33747 = G__33784;
count__33748 = G__33785;
i__33749 = G__33786;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33746__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33754_33787 = cljs.core.seq.call(null,requires);
var chunk__33755_33788 = null;
var count__33756_33789 = (0);
var i__33757_33790 = (0);
while(true){
if((i__33757_33790 < count__33756_33789)){
var req_33791 = cljs.core._nth.call(null,chunk__33755_33788,i__33757_33790);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33791,prov);

var G__33792 = seq__33754_33787;
var G__33793 = chunk__33755_33788;
var G__33794 = count__33756_33789;
var G__33795 = (i__33757_33790 + (1));
seq__33754_33787 = G__33792;
chunk__33755_33788 = G__33793;
count__33756_33789 = G__33794;
i__33757_33790 = G__33795;
continue;
} else {
var temp__4657__auto___33796__$1 = cljs.core.seq.call(null,seq__33754_33787);
if(temp__4657__auto___33796__$1){
var seq__33754_33797__$1 = temp__4657__auto___33796__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33754_33797__$1)){
var c__29507__auto___33798 = cljs.core.chunk_first.call(null,seq__33754_33797__$1);
var G__33799 = cljs.core.chunk_rest.call(null,seq__33754_33797__$1);
var G__33800 = c__29507__auto___33798;
var G__33801 = cljs.core.count.call(null,c__29507__auto___33798);
var G__33802 = (0);
seq__33754_33787 = G__33799;
chunk__33755_33788 = G__33800;
count__33756_33789 = G__33801;
i__33757_33790 = G__33802;
continue;
} else {
var req_33803 = cljs.core.first.call(null,seq__33754_33797__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33803,prov);

var G__33804 = cljs.core.next.call(null,seq__33754_33797__$1);
var G__33805 = null;
var G__33806 = (0);
var G__33807 = (0);
seq__33754_33787 = G__33804;
chunk__33755_33788 = G__33805;
count__33756_33789 = G__33806;
i__33757_33790 = G__33807;
continue;
}
} else {
}
}
break;
}

var G__33808 = cljs.core.next.call(null,seq__33746__$1);
var G__33809 = null;
var G__33810 = (0);
var G__33811 = (0);
seq__33746 = G__33808;
chunk__33747 = G__33809;
count__33748 = G__33810;
i__33749 = G__33811;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__33816_33820 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__33817_33821 = null;
var count__33818_33822 = (0);
var i__33819_33823 = (0);
while(true){
if((i__33819_33823 < count__33818_33822)){
var ns_33824 = cljs.core._nth.call(null,chunk__33817_33821,i__33819_33823);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33824);

var G__33825 = seq__33816_33820;
var G__33826 = chunk__33817_33821;
var G__33827 = count__33818_33822;
var G__33828 = (i__33819_33823 + (1));
seq__33816_33820 = G__33825;
chunk__33817_33821 = G__33826;
count__33818_33822 = G__33827;
i__33819_33823 = G__33828;
continue;
} else {
var temp__4657__auto___33829 = cljs.core.seq.call(null,seq__33816_33820);
if(temp__4657__auto___33829){
var seq__33816_33830__$1 = temp__4657__auto___33829;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33816_33830__$1)){
var c__29507__auto___33831 = cljs.core.chunk_first.call(null,seq__33816_33830__$1);
var G__33832 = cljs.core.chunk_rest.call(null,seq__33816_33830__$1);
var G__33833 = c__29507__auto___33831;
var G__33834 = cljs.core.count.call(null,c__29507__auto___33831);
var G__33835 = (0);
seq__33816_33820 = G__33832;
chunk__33817_33821 = G__33833;
count__33818_33822 = G__33834;
i__33819_33823 = G__33835;
continue;
} else {
var ns_33836 = cljs.core.first.call(null,seq__33816_33830__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33836);

var G__33837 = cljs.core.next.call(null,seq__33816_33830__$1);
var G__33838 = null;
var G__33839 = (0);
var G__33840 = (0);
seq__33816_33820 = G__33837;
chunk__33817_33821 = G__33838;
count__33818_33822 = G__33839;
i__33819_33823 = G__33840;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28696__auto__ = goog.require__;
if(cljs.core.truth_(or__28696__auto__)){
return or__28696__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__33841__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__33841 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33842__i = 0, G__33842__a = new Array(arguments.length -  0);
while (G__33842__i < G__33842__a.length) {G__33842__a[G__33842__i] = arguments[G__33842__i + 0]; ++G__33842__i;}
  args = new cljs.core.IndexedSeq(G__33842__a,0);
} 
return G__33841__delegate.call(this,args);};
G__33841.cljs$lang$maxFixedArity = 0;
G__33841.cljs$lang$applyTo = (function (arglist__33843){
var args = cljs.core.seq(arglist__33843);
return G__33841__delegate(args);
});
G__33841.cljs$core$IFn$_invoke$arity$variadic = G__33841__delegate;
return G__33841;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__33845 = cljs.core._EQ_;
var expr__33846 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__33845.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__33846))){
var path_parts = ((function (pred__33845,expr__33846){
return (function (p1__33844_SHARP_){
return clojure.string.split.call(null,p1__33844_SHARP_,/[\/\\]/);
});})(pred__33845,expr__33846))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__33845,expr__33846){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e33848){if((e33848 instanceof Error)){
var e = e33848;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33848;

}
}})());
});
;})(path_parts,sep,root,pred__33845,expr__33846))
} else {
if(cljs.core.truth_(pred__33845.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__33846))){
return ((function (pred__33845,expr__33846){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__33845,expr__33846){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__33845,expr__33846))
);

return deferred.addErrback(((function (deferred,pred__33845,expr__33846){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__33845,expr__33846))
);
});
;})(pred__33845,expr__33846))
} else {
return ((function (pred__33845,expr__33846){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__33845,expr__33846))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__33849,callback){
var map__33852 = p__33849;
var map__33852__$1 = ((((!((map__33852 == null)))?((((map__33852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33852):map__33852);
var file_msg = map__33852__$1;
var request_url = cljs.core.get.call(null,map__33852__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__33852,map__33852__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__33852,map__33852__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30814__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto__){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto__){
return (function (state_33876){
var state_val_33877 = (state_33876[(1)]);
if((state_val_33877 === (7))){
var inst_33872 = (state_33876[(2)]);
var state_33876__$1 = state_33876;
var statearr_33878_33898 = state_33876__$1;
(statearr_33878_33898[(2)] = inst_33872);

(statearr_33878_33898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (1))){
var state_33876__$1 = state_33876;
var statearr_33879_33899 = state_33876__$1;
(statearr_33879_33899[(2)] = null);

(statearr_33879_33899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (4))){
var inst_33856 = (state_33876[(7)]);
var inst_33856__$1 = (state_33876[(2)]);
var state_33876__$1 = (function (){var statearr_33880 = state_33876;
(statearr_33880[(7)] = inst_33856__$1);

return statearr_33880;
})();
if(cljs.core.truth_(inst_33856__$1)){
var statearr_33881_33900 = state_33876__$1;
(statearr_33881_33900[(1)] = (5));

} else {
var statearr_33882_33901 = state_33876__$1;
(statearr_33882_33901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (6))){
var state_33876__$1 = state_33876;
var statearr_33883_33902 = state_33876__$1;
(statearr_33883_33902[(2)] = null);

(statearr_33883_33902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (3))){
var inst_33874 = (state_33876[(2)]);
var state_33876__$1 = state_33876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33876__$1,inst_33874);
} else {
if((state_val_33877 === (2))){
var state_33876__$1 = state_33876;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33876__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_33877 === (11))){
var inst_33868 = (state_33876[(2)]);
var state_33876__$1 = (function (){var statearr_33884 = state_33876;
(statearr_33884[(8)] = inst_33868);

return statearr_33884;
})();
var statearr_33885_33903 = state_33876__$1;
(statearr_33885_33903[(2)] = null);

(statearr_33885_33903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (9))){
var inst_33860 = (state_33876[(9)]);
var inst_33862 = (state_33876[(10)]);
var inst_33864 = inst_33862.call(null,inst_33860);
var state_33876__$1 = state_33876;
var statearr_33886_33904 = state_33876__$1;
(statearr_33886_33904[(2)] = inst_33864);

(statearr_33886_33904[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (5))){
var inst_33856 = (state_33876[(7)]);
var inst_33858 = figwheel.client.file_reloading.blocking_load.call(null,inst_33856);
var state_33876__$1 = state_33876;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33876__$1,(8),inst_33858);
} else {
if((state_val_33877 === (10))){
var inst_33860 = (state_33876[(9)]);
var inst_33866 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_33860);
var state_33876__$1 = state_33876;
var statearr_33887_33905 = state_33876__$1;
(statearr_33887_33905[(2)] = inst_33866);

(statearr_33887_33905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33877 === (8))){
var inst_33856 = (state_33876[(7)]);
var inst_33862 = (state_33876[(10)]);
var inst_33860 = (state_33876[(2)]);
var inst_33861 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_33862__$1 = cljs.core.get.call(null,inst_33861,inst_33856);
var state_33876__$1 = (function (){var statearr_33888 = state_33876;
(statearr_33888[(9)] = inst_33860);

(statearr_33888[(10)] = inst_33862__$1);

return statearr_33888;
})();
if(cljs.core.truth_(inst_33862__$1)){
var statearr_33889_33906 = state_33876__$1;
(statearr_33889_33906[(1)] = (9));

} else {
var statearr_33890_33907 = state_33876__$1;
(statearr_33890_33907[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto__))
;
return ((function (switch__30702__auto__,c__30814__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30703__auto__ = null;
var figwheel$client$file_reloading$state_machine__30703__auto____0 = (function (){
var statearr_33894 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33894[(0)] = figwheel$client$file_reloading$state_machine__30703__auto__);

(statearr_33894[(1)] = (1));

return statearr_33894;
});
var figwheel$client$file_reloading$state_machine__30703__auto____1 = (function (state_33876){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e33895){if((e33895 instanceof Object)){
var ex__30706__auto__ = e33895;
var statearr_33896_33908 = state_33876;
(statearr_33896_33908[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33876);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33895;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33909 = state_33876;
state_33876 = G__33909;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30703__auto__ = function(state_33876){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30703__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30703__auto____1.call(this,state_33876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30703__auto____0;
figwheel$client$file_reloading$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30703__auto____1;
return figwheel$client$file_reloading$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto__))
})();
var state__30816__auto__ = (function (){var statearr_33897 = f__30815__auto__.call(null);
(statearr_33897[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto__);

return statearr_33897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto__))
);

return c__30814__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__33910,callback){
var map__33913 = p__33910;
var map__33913__$1 = ((((!((map__33913 == null)))?((((map__33913.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33913.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33913):map__33913);
var file_msg = map__33913__$1;
var namespace = cljs.core.get.call(null,map__33913__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__33913,map__33913__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__33913,map__33913__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__33915){
var map__33918 = p__33915;
var map__33918__$1 = ((((!((map__33918 == null)))?((((map__33918.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33918.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33918):map__33918);
var file_msg = map__33918__$1;
var namespace = cljs.core.get.call(null,map__33918__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28684__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__28684__auto__){
var or__28696__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28696__auto__)){
return or__28696__auto__;
} else {
var or__28696__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28696__auto____$1)){
return or__28696__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28684__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__33920,callback){
var map__33923 = p__33920;
var map__33923__$1 = ((((!((map__33923 == null)))?((((map__33923.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33923.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33923):map__33923);
var file_msg = map__33923__$1;
var request_url = cljs.core.get.call(null,map__33923__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__33923__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30814__auto___34011 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___34011,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___34011,out){
return (function (state_33993){
var state_val_33994 = (state_33993[(1)]);
if((state_val_33994 === (1))){
var inst_33971 = cljs.core.nth.call(null,files,(0),null);
var inst_33972 = cljs.core.nthnext.call(null,files,(1));
var inst_33973 = files;
var state_33993__$1 = (function (){var statearr_33995 = state_33993;
(statearr_33995[(7)] = inst_33971);

(statearr_33995[(8)] = inst_33973);

(statearr_33995[(9)] = inst_33972);

return statearr_33995;
})();
var statearr_33996_34012 = state_33993__$1;
(statearr_33996_34012[(2)] = null);

(statearr_33996_34012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33994 === (2))){
var inst_33973 = (state_33993[(8)]);
var inst_33976 = (state_33993[(10)]);
var inst_33976__$1 = cljs.core.nth.call(null,inst_33973,(0),null);
var inst_33977 = cljs.core.nthnext.call(null,inst_33973,(1));
var inst_33978 = (inst_33976__$1 == null);
var inst_33979 = cljs.core.not.call(null,inst_33978);
var state_33993__$1 = (function (){var statearr_33997 = state_33993;
(statearr_33997[(10)] = inst_33976__$1);

(statearr_33997[(11)] = inst_33977);

return statearr_33997;
})();
if(inst_33979){
var statearr_33998_34013 = state_33993__$1;
(statearr_33998_34013[(1)] = (4));

} else {
var statearr_33999_34014 = state_33993__$1;
(statearr_33999_34014[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33994 === (3))){
var inst_33991 = (state_33993[(2)]);
var state_33993__$1 = state_33993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33993__$1,inst_33991);
} else {
if((state_val_33994 === (4))){
var inst_33976 = (state_33993[(10)]);
var inst_33981 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33976);
var state_33993__$1 = state_33993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33993__$1,(7),inst_33981);
} else {
if((state_val_33994 === (5))){
var inst_33987 = cljs.core.async.close_BANG_.call(null,out);
var state_33993__$1 = state_33993;
var statearr_34000_34015 = state_33993__$1;
(statearr_34000_34015[(2)] = inst_33987);

(statearr_34000_34015[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33994 === (6))){
var inst_33989 = (state_33993[(2)]);
var state_33993__$1 = state_33993;
var statearr_34001_34016 = state_33993__$1;
(statearr_34001_34016[(2)] = inst_33989);

(statearr_34001_34016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33994 === (7))){
var inst_33977 = (state_33993[(11)]);
var inst_33983 = (state_33993[(2)]);
var inst_33984 = cljs.core.async.put_BANG_.call(null,out,inst_33983);
var inst_33973 = inst_33977;
var state_33993__$1 = (function (){var statearr_34002 = state_33993;
(statearr_34002[(8)] = inst_33973);

(statearr_34002[(12)] = inst_33984);

return statearr_34002;
})();
var statearr_34003_34017 = state_33993__$1;
(statearr_34003_34017[(2)] = null);

(statearr_34003_34017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30814__auto___34011,out))
;
return ((function (switch__30702__auto__,c__30814__auto___34011,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto____0 = (function (){
var statearr_34007 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34007[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto__);

(statearr_34007[(1)] = (1));

return statearr_34007;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto____1 = (function (state_33993){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e34008){if((e34008 instanceof Object)){
var ex__30706__auto__ = e34008;
var statearr_34009_34018 = state_33993;
(statearr_34009_34018[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34019 = state_33993;
state_33993 = G__34019;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto__ = function(state_33993){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto____1.call(this,state_33993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___34011,out))
})();
var state__30816__auto__ = (function (){var statearr_34010 = f__30815__auto__.call(null);
(statearr_34010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___34011);

return statearr_34010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___34011,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__34020,opts){
var map__34024 = p__34020;
var map__34024__$1 = ((((!((map__34024 == null)))?((((map__34024.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34024.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34024):map__34024);
var eval_body__$1 = cljs.core.get.call(null,map__34024__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__34024__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28684__auto__ = eval_body__$1;
if(cljs.core.truth_(and__28684__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__28684__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e34026){var e = e34026;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__34027_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34027_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__34032){
var vec__34033 = p__34032;
var k = cljs.core.nth.call(null,vec__34033,(0),null);
var v = cljs.core.nth.call(null,vec__34033,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__34034){
var vec__34035 = p__34034;
var k = cljs.core.nth.call(null,vec__34035,(0),null);
var v = cljs.core.nth.call(null,vec__34035,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__34039,p__34040){
var map__34287 = p__34039;
var map__34287__$1 = ((((!((map__34287 == null)))?((((map__34287.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34287.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34287):map__34287);
var opts = map__34287__$1;
var before_jsload = cljs.core.get.call(null,map__34287__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__34287__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__34287__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__34288 = p__34040;
var map__34288__$1 = ((((!((map__34288 == null)))?((((map__34288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34288):map__34288);
var msg = map__34288__$1;
var files = cljs.core.get.call(null,map__34288__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__34288__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__34288__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30814__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_34441){
var state_val_34442 = (state_34441[(1)]);
if((state_val_34442 === (7))){
var inst_34305 = (state_34441[(7)]);
var inst_34302 = (state_34441[(8)]);
var inst_34303 = (state_34441[(9)]);
var inst_34304 = (state_34441[(10)]);
var inst_34310 = cljs.core._nth.call(null,inst_34303,inst_34305);
var inst_34311 = figwheel.client.file_reloading.eval_body.call(null,inst_34310,opts);
var inst_34312 = (inst_34305 + (1));
var tmp34443 = inst_34302;
var tmp34444 = inst_34303;
var tmp34445 = inst_34304;
var inst_34302__$1 = tmp34443;
var inst_34303__$1 = tmp34444;
var inst_34304__$1 = tmp34445;
var inst_34305__$1 = inst_34312;
var state_34441__$1 = (function (){var statearr_34446 = state_34441;
(statearr_34446[(7)] = inst_34305__$1);

(statearr_34446[(8)] = inst_34302__$1);

(statearr_34446[(11)] = inst_34311);

(statearr_34446[(9)] = inst_34303__$1);

(statearr_34446[(10)] = inst_34304__$1);

return statearr_34446;
})();
var statearr_34447_34533 = state_34441__$1;
(statearr_34447_34533[(2)] = null);

(statearr_34447_34533[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (20))){
var inst_34345 = (state_34441[(12)]);
var inst_34353 = figwheel.client.file_reloading.sort_files.call(null,inst_34345);
var state_34441__$1 = state_34441;
var statearr_34448_34534 = state_34441__$1;
(statearr_34448_34534[(2)] = inst_34353);

(statearr_34448_34534[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (27))){
var state_34441__$1 = state_34441;
var statearr_34449_34535 = state_34441__$1;
(statearr_34449_34535[(2)] = null);

(statearr_34449_34535[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (1))){
var inst_34294 = (state_34441[(13)]);
var inst_34291 = before_jsload.call(null,files);
var inst_34292 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_34293 = (function (){return ((function (inst_34294,inst_34291,inst_34292,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34036_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34036_SHARP_);
});
;})(inst_34294,inst_34291,inst_34292,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34294__$1 = cljs.core.filter.call(null,inst_34293,files);
var inst_34295 = cljs.core.not_empty.call(null,inst_34294__$1);
var state_34441__$1 = (function (){var statearr_34450 = state_34441;
(statearr_34450[(14)] = inst_34292);

(statearr_34450[(13)] = inst_34294__$1);

(statearr_34450[(15)] = inst_34291);

return statearr_34450;
})();
if(cljs.core.truth_(inst_34295)){
var statearr_34451_34536 = state_34441__$1;
(statearr_34451_34536[(1)] = (2));

} else {
var statearr_34452_34537 = state_34441__$1;
(statearr_34452_34537[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (24))){
var state_34441__$1 = state_34441;
var statearr_34453_34538 = state_34441__$1;
(statearr_34453_34538[(2)] = null);

(statearr_34453_34538[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (39))){
var inst_34395 = (state_34441[(16)]);
var state_34441__$1 = state_34441;
var statearr_34454_34539 = state_34441__$1;
(statearr_34454_34539[(2)] = inst_34395);

(statearr_34454_34539[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (46))){
var inst_34436 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
var statearr_34455_34540 = state_34441__$1;
(statearr_34455_34540[(2)] = inst_34436);

(statearr_34455_34540[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (4))){
var inst_34339 = (state_34441[(2)]);
var inst_34340 = cljs.core.List.EMPTY;
var inst_34341 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34340);
var inst_34342 = (function (){return ((function (inst_34339,inst_34340,inst_34341,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34037_SHARP_){
var and__28684__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34037_SHARP_);
if(cljs.core.truth_(and__28684__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34037_SHARP_));
} else {
return and__28684__auto__;
}
});
;})(inst_34339,inst_34340,inst_34341,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34343 = cljs.core.filter.call(null,inst_34342,files);
var inst_34344 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34345 = cljs.core.concat.call(null,inst_34343,inst_34344);
var state_34441__$1 = (function (){var statearr_34456 = state_34441;
(statearr_34456[(12)] = inst_34345);

(statearr_34456[(17)] = inst_34341);

(statearr_34456[(18)] = inst_34339);

return statearr_34456;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34457_34541 = state_34441__$1;
(statearr_34457_34541[(1)] = (16));

} else {
var statearr_34458_34542 = state_34441__$1;
(statearr_34458_34542[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (15))){
var inst_34329 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
var statearr_34459_34543 = state_34441__$1;
(statearr_34459_34543[(2)] = inst_34329);

(statearr_34459_34543[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (21))){
var inst_34355 = (state_34441[(19)]);
var inst_34355__$1 = (state_34441[(2)]);
var inst_34356 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34355__$1);
var state_34441__$1 = (function (){var statearr_34460 = state_34441;
(statearr_34460[(19)] = inst_34355__$1);

return statearr_34460;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34441__$1,(22),inst_34356);
} else {
if((state_val_34442 === (31))){
var inst_34439 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34441__$1,inst_34439);
} else {
if((state_val_34442 === (32))){
var inst_34395 = (state_34441[(16)]);
var inst_34400 = inst_34395.cljs$lang$protocol_mask$partition0$;
var inst_34401 = (inst_34400 & (64));
var inst_34402 = inst_34395.cljs$core$ISeq$;
var inst_34403 = (inst_34401) || (inst_34402);
var state_34441__$1 = state_34441;
if(cljs.core.truth_(inst_34403)){
var statearr_34461_34544 = state_34441__$1;
(statearr_34461_34544[(1)] = (35));

} else {
var statearr_34462_34545 = state_34441__$1;
(statearr_34462_34545[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (40))){
var inst_34416 = (state_34441[(20)]);
var inst_34415 = (state_34441[(2)]);
var inst_34416__$1 = cljs.core.get.call(null,inst_34415,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34417 = cljs.core.get.call(null,inst_34415,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34418 = cljs.core.not_empty.call(null,inst_34416__$1);
var state_34441__$1 = (function (){var statearr_34463 = state_34441;
(statearr_34463[(21)] = inst_34417);

(statearr_34463[(20)] = inst_34416__$1);

return statearr_34463;
})();
if(cljs.core.truth_(inst_34418)){
var statearr_34464_34546 = state_34441__$1;
(statearr_34464_34546[(1)] = (41));

} else {
var statearr_34465_34547 = state_34441__$1;
(statearr_34465_34547[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (33))){
var state_34441__$1 = state_34441;
var statearr_34466_34548 = state_34441__$1;
(statearr_34466_34548[(2)] = false);

(statearr_34466_34548[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (13))){
var inst_34315 = (state_34441[(22)]);
var inst_34319 = cljs.core.chunk_first.call(null,inst_34315);
var inst_34320 = cljs.core.chunk_rest.call(null,inst_34315);
var inst_34321 = cljs.core.count.call(null,inst_34319);
var inst_34302 = inst_34320;
var inst_34303 = inst_34319;
var inst_34304 = inst_34321;
var inst_34305 = (0);
var state_34441__$1 = (function (){var statearr_34467 = state_34441;
(statearr_34467[(7)] = inst_34305);

(statearr_34467[(8)] = inst_34302);

(statearr_34467[(9)] = inst_34303);

(statearr_34467[(10)] = inst_34304);

return statearr_34467;
})();
var statearr_34468_34549 = state_34441__$1;
(statearr_34468_34549[(2)] = null);

(statearr_34468_34549[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (22))){
var inst_34359 = (state_34441[(23)]);
var inst_34358 = (state_34441[(24)]);
var inst_34355 = (state_34441[(19)]);
var inst_34363 = (state_34441[(25)]);
var inst_34358__$1 = (state_34441[(2)]);
var inst_34359__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34358__$1);
var inst_34360 = (function (){var all_files = inst_34355;
var res_SINGLEQUOTE_ = inst_34358__$1;
var res = inst_34359__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_34359,inst_34358,inst_34355,inst_34363,inst_34358__$1,inst_34359__$1,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34038_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__34038_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_34359,inst_34358,inst_34355,inst_34363,inst_34358__$1,inst_34359__$1,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34361 = cljs.core.filter.call(null,inst_34360,inst_34358__$1);
var inst_34362 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34363__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34362);
var inst_34364 = cljs.core.not_empty.call(null,inst_34363__$1);
var state_34441__$1 = (function (){var statearr_34469 = state_34441;
(statearr_34469[(23)] = inst_34359__$1);

(statearr_34469[(26)] = inst_34361);

(statearr_34469[(24)] = inst_34358__$1);

(statearr_34469[(25)] = inst_34363__$1);

return statearr_34469;
})();
if(cljs.core.truth_(inst_34364)){
var statearr_34470_34550 = state_34441__$1;
(statearr_34470_34550[(1)] = (23));

} else {
var statearr_34471_34551 = state_34441__$1;
(statearr_34471_34551[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (36))){
var state_34441__$1 = state_34441;
var statearr_34472_34552 = state_34441__$1;
(statearr_34472_34552[(2)] = false);

(statearr_34472_34552[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (41))){
var inst_34416 = (state_34441[(20)]);
var inst_34420 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34421 = cljs.core.map.call(null,inst_34420,inst_34416);
var inst_34422 = cljs.core.pr_str.call(null,inst_34421);
var inst_34423 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_34422)].join('');
var inst_34424 = figwheel.client.utils.log.call(null,inst_34423);
var state_34441__$1 = state_34441;
var statearr_34473_34553 = state_34441__$1;
(statearr_34473_34553[(2)] = inst_34424);

(statearr_34473_34553[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (43))){
var inst_34417 = (state_34441[(21)]);
var inst_34427 = (state_34441[(2)]);
var inst_34428 = cljs.core.not_empty.call(null,inst_34417);
var state_34441__$1 = (function (){var statearr_34474 = state_34441;
(statearr_34474[(27)] = inst_34427);

return statearr_34474;
})();
if(cljs.core.truth_(inst_34428)){
var statearr_34475_34554 = state_34441__$1;
(statearr_34475_34554[(1)] = (44));

} else {
var statearr_34476_34555 = state_34441__$1;
(statearr_34476_34555[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (29))){
var inst_34359 = (state_34441[(23)]);
var inst_34395 = (state_34441[(16)]);
var inst_34361 = (state_34441[(26)]);
var inst_34358 = (state_34441[(24)]);
var inst_34355 = (state_34441[(19)]);
var inst_34363 = (state_34441[(25)]);
var inst_34391 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34394 = (function (){var all_files = inst_34355;
var res_SINGLEQUOTE_ = inst_34358;
var res = inst_34359;
var files_not_loaded = inst_34361;
var dependencies_that_loaded = inst_34363;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34395,inst_34361,inst_34358,inst_34355,inst_34363,inst_34391,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34393){
var map__34477 = p__34393;
var map__34477__$1 = ((((!((map__34477 == null)))?((((map__34477.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34477.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34477):map__34477);
var namespace = cljs.core.get.call(null,map__34477__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34395,inst_34361,inst_34358,inst_34355,inst_34363,inst_34391,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34395__$1 = cljs.core.group_by.call(null,inst_34394,inst_34361);
var inst_34397 = (inst_34395__$1 == null);
var inst_34398 = cljs.core.not.call(null,inst_34397);
var state_34441__$1 = (function (){var statearr_34479 = state_34441;
(statearr_34479[(28)] = inst_34391);

(statearr_34479[(16)] = inst_34395__$1);

return statearr_34479;
})();
if(inst_34398){
var statearr_34480_34556 = state_34441__$1;
(statearr_34480_34556[(1)] = (32));

} else {
var statearr_34481_34557 = state_34441__$1;
(statearr_34481_34557[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (44))){
var inst_34417 = (state_34441[(21)]);
var inst_34430 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34417);
var inst_34431 = cljs.core.pr_str.call(null,inst_34430);
var inst_34432 = [cljs.core.str("not required: "),cljs.core.str(inst_34431)].join('');
var inst_34433 = figwheel.client.utils.log.call(null,inst_34432);
var state_34441__$1 = state_34441;
var statearr_34482_34558 = state_34441__$1;
(statearr_34482_34558[(2)] = inst_34433);

(statearr_34482_34558[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (6))){
var inst_34336 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
var statearr_34483_34559 = state_34441__$1;
(statearr_34483_34559[(2)] = inst_34336);

(statearr_34483_34559[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (28))){
var inst_34361 = (state_34441[(26)]);
var inst_34388 = (state_34441[(2)]);
var inst_34389 = cljs.core.not_empty.call(null,inst_34361);
var state_34441__$1 = (function (){var statearr_34484 = state_34441;
(statearr_34484[(29)] = inst_34388);

return statearr_34484;
})();
if(cljs.core.truth_(inst_34389)){
var statearr_34485_34560 = state_34441__$1;
(statearr_34485_34560[(1)] = (29));

} else {
var statearr_34486_34561 = state_34441__$1;
(statearr_34486_34561[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (25))){
var inst_34359 = (state_34441[(23)]);
var inst_34375 = (state_34441[(2)]);
var inst_34376 = cljs.core.not_empty.call(null,inst_34359);
var state_34441__$1 = (function (){var statearr_34487 = state_34441;
(statearr_34487[(30)] = inst_34375);

return statearr_34487;
})();
if(cljs.core.truth_(inst_34376)){
var statearr_34488_34562 = state_34441__$1;
(statearr_34488_34562[(1)] = (26));

} else {
var statearr_34489_34563 = state_34441__$1;
(statearr_34489_34563[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (34))){
var inst_34410 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
if(cljs.core.truth_(inst_34410)){
var statearr_34490_34564 = state_34441__$1;
(statearr_34490_34564[(1)] = (38));

} else {
var statearr_34491_34565 = state_34441__$1;
(statearr_34491_34565[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (17))){
var state_34441__$1 = state_34441;
var statearr_34492_34566 = state_34441__$1;
(statearr_34492_34566[(2)] = recompile_dependents);

(statearr_34492_34566[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (3))){
var state_34441__$1 = state_34441;
var statearr_34493_34567 = state_34441__$1;
(statearr_34493_34567[(2)] = null);

(statearr_34493_34567[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (12))){
var inst_34332 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
var statearr_34494_34568 = state_34441__$1;
(statearr_34494_34568[(2)] = inst_34332);

(statearr_34494_34568[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (2))){
var inst_34294 = (state_34441[(13)]);
var inst_34301 = cljs.core.seq.call(null,inst_34294);
var inst_34302 = inst_34301;
var inst_34303 = null;
var inst_34304 = (0);
var inst_34305 = (0);
var state_34441__$1 = (function (){var statearr_34495 = state_34441;
(statearr_34495[(7)] = inst_34305);

(statearr_34495[(8)] = inst_34302);

(statearr_34495[(9)] = inst_34303);

(statearr_34495[(10)] = inst_34304);

return statearr_34495;
})();
var statearr_34496_34569 = state_34441__$1;
(statearr_34496_34569[(2)] = null);

(statearr_34496_34569[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (23))){
var inst_34359 = (state_34441[(23)]);
var inst_34361 = (state_34441[(26)]);
var inst_34358 = (state_34441[(24)]);
var inst_34355 = (state_34441[(19)]);
var inst_34363 = (state_34441[(25)]);
var inst_34366 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34368 = (function (){var all_files = inst_34355;
var res_SINGLEQUOTE_ = inst_34358;
var res = inst_34359;
var files_not_loaded = inst_34361;
var dependencies_that_loaded = inst_34363;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34361,inst_34358,inst_34355,inst_34363,inst_34366,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34367){
var map__34497 = p__34367;
var map__34497__$1 = ((((!((map__34497 == null)))?((((map__34497.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34497.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34497):map__34497);
var request_url = cljs.core.get.call(null,map__34497__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34361,inst_34358,inst_34355,inst_34363,inst_34366,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34369 = cljs.core.reverse.call(null,inst_34363);
var inst_34370 = cljs.core.map.call(null,inst_34368,inst_34369);
var inst_34371 = cljs.core.pr_str.call(null,inst_34370);
var inst_34372 = figwheel.client.utils.log.call(null,inst_34371);
var state_34441__$1 = (function (){var statearr_34499 = state_34441;
(statearr_34499[(31)] = inst_34366);

return statearr_34499;
})();
var statearr_34500_34570 = state_34441__$1;
(statearr_34500_34570[(2)] = inst_34372);

(statearr_34500_34570[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (35))){
var state_34441__$1 = state_34441;
var statearr_34501_34571 = state_34441__$1;
(statearr_34501_34571[(2)] = true);

(statearr_34501_34571[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (19))){
var inst_34345 = (state_34441[(12)]);
var inst_34351 = figwheel.client.file_reloading.expand_files.call(null,inst_34345);
var state_34441__$1 = state_34441;
var statearr_34502_34572 = state_34441__$1;
(statearr_34502_34572[(2)] = inst_34351);

(statearr_34502_34572[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (11))){
var state_34441__$1 = state_34441;
var statearr_34503_34573 = state_34441__$1;
(statearr_34503_34573[(2)] = null);

(statearr_34503_34573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (9))){
var inst_34334 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
var statearr_34504_34574 = state_34441__$1;
(statearr_34504_34574[(2)] = inst_34334);

(statearr_34504_34574[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (5))){
var inst_34305 = (state_34441[(7)]);
var inst_34304 = (state_34441[(10)]);
var inst_34307 = (inst_34305 < inst_34304);
var inst_34308 = inst_34307;
var state_34441__$1 = state_34441;
if(cljs.core.truth_(inst_34308)){
var statearr_34505_34575 = state_34441__$1;
(statearr_34505_34575[(1)] = (7));

} else {
var statearr_34506_34576 = state_34441__$1;
(statearr_34506_34576[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (14))){
var inst_34315 = (state_34441[(22)]);
var inst_34324 = cljs.core.first.call(null,inst_34315);
var inst_34325 = figwheel.client.file_reloading.eval_body.call(null,inst_34324,opts);
var inst_34326 = cljs.core.next.call(null,inst_34315);
var inst_34302 = inst_34326;
var inst_34303 = null;
var inst_34304 = (0);
var inst_34305 = (0);
var state_34441__$1 = (function (){var statearr_34507 = state_34441;
(statearr_34507[(7)] = inst_34305);

(statearr_34507[(32)] = inst_34325);

(statearr_34507[(8)] = inst_34302);

(statearr_34507[(9)] = inst_34303);

(statearr_34507[(10)] = inst_34304);

return statearr_34507;
})();
var statearr_34508_34577 = state_34441__$1;
(statearr_34508_34577[(2)] = null);

(statearr_34508_34577[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (45))){
var state_34441__$1 = state_34441;
var statearr_34509_34578 = state_34441__$1;
(statearr_34509_34578[(2)] = null);

(statearr_34509_34578[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (26))){
var inst_34359 = (state_34441[(23)]);
var inst_34361 = (state_34441[(26)]);
var inst_34358 = (state_34441[(24)]);
var inst_34355 = (state_34441[(19)]);
var inst_34363 = (state_34441[(25)]);
var inst_34378 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34380 = (function (){var all_files = inst_34355;
var res_SINGLEQUOTE_ = inst_34358;
var res = inst_34359;
var files_not_loaded = inst_34361;
var dependencies_that_loaded = inst_34363;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34361,inst_34358,inst_34355,inst_34363,inst_34378,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34379){
var map__34510 = p__34379;
var map__34510__$1 = ((((!((map__34510 == null)))?((((map__34510.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34510.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34510):map__34510);
var namespace = cljs.core.get.call(null,map__34510__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34510__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34361,inst_34358,inst_34355,inst_34363,inst_34378,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34381 = cljs.core.map.call(null,inst_34380,inst_34359);
var inst_34382 = cljs.core.pr_str.call(null,inst_34381);
var inst_34383 = figwheel.client.utils.log.call(null,inst_34382);
var inst_34384 = (function (){var all_files = inst_34355;
var res_SINGLEQUOTE_ = inst_34358;
var res = inst_34359;
var files_not_loaded = inst_34361;
var dependencies_that_loaded = inst_34363;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34361,inst_34358,inst_34355,inst_34363,inst_34378,inst_34380,inst_34381,inst_34382,inst_34383,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34359,inst_34361,inst_34358,inst_34355,inst_34363,inst_34378,inst_34380,inst_34381,inst_34382,inst_34383,state_val_34442,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34385 = setTimeout(inst_34384,(10));
var state_34441__$1 = (function (){var statearr_34512 = state_34441;
(statearr_34512[(33)] = inst_34383);

(statearr_34512[(34)] = inst_34378);

return statearr_34512;
})();
var statearr_34513_34579 = state_34441__$1;
(statearr_34513_34579[(2)] = inst_34385);

(statearr_34513_34579[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (16))){
var state_34441__$1 = state_34441;
var statearr_34514_34580 = state_34441__$1;
(statearr_34514_34580[(2)] = reload_dependents);

(statearr_34514_34580[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (38))){
var inst_34395 = (state_34441[(16)]);
var inst_34412 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34395);
var state_34441__$1 = state_34441;
var statearr_34515_34581 = state_34441__$1;
(statearr_34515_34581[(2)] = inst_34412);

(statearr_34515_34581[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (30))){
var state_34441__$1 = state_34441;
var statearr_34516_34582 = state_34441__$1;
(statearr_34516_34582[(2)] = null);

(statearr_34516_34582[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (10))){
var inst_34315 = (state_34441[(22)]);
var inst_34317 = cljs.core.chunked_seq_QMARK_.call(null,inst_34315);
var state_34441__$1 = state_34441;
if(inst_34317){
var statearr_34517_34583 = state_34441__$1;
(statearr_34517_34583[(1)] = (13));

} else {
var statearr_34518_34584 = state_34441__$1;
(statearr_34518_34584[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (18))){
var inst_34349 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
if(cljs.core.truth_(inst_34349)){
var statearr_34519_34585 = state_34441__$1;
(statearr_34519_34585[(1)] = (19));

} else {
var statearr_34520_34586 = state_34441__$1;
(statearr_34520_34586[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (42))){
var state_34441__$1 = state_34441;
var statearr_34521_34587 = state_34441__$1;
(statearr_34521_34587[(2)] = null);

(statearr_34521_34587[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (37))){
var inst_34407 = (state_34441[(2)]);
var state_34441__$1 = state_34441;
var statearr_34522_34588 = state_34441__$1;
(statearr_34522_34588[(2)] = inst_34407);

(statearr_34522_34588[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34442 === (8))){
var inst_34315 = (state_34441[(22)]);
var inst_34302 = (state_34441[(8)]);
var inst_34315__$1 = cljs.core.seq.call(null,inst_34302);
var state_34441__$1 = (function (){var statearr_34523 = state_34441;
(statearr_34523[(22)] = inst_34315__$1);

return statearr_34523;
})();
if(inst_34315__$1){
var statearr_34524_34589 = state_34441__$1;
(statearr_34524_34589[(1)] = (10));

} else {
var statearr_34525_34590 = state_34441__$1;
(statearr_34525_34590[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30702__auto__,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto____0 = (function (){
var statearr_34529 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34529[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto__);

(statearr_34529[(1)] = (1));

return statearr_34529;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto____1 = (function (state_34441){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_34441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e34530){if((e34530 instanceof Object)){
var ex__30706__auto__ = e34530;
var statearr_34531_34591 = state_34441;
(statearr_34531_34591[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34530;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34592 = state_34441;
state_34441 = G__34592;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto__ = function(state_34441){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto____1.call(this,state_34441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30816__auto__ = (function (){var statearr_34532 = f__30815__auto__.call(null);
(statearr_34532[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto__);

return statearr_34532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto__,map__34287,map__34287__$1,opts,before_jsload,on_jsload,reload_dependents,map__34288,map__34288__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30814__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34595,link){
var map__34598 = p__34595;
var map__34598__$1 = ((((!((map__34598 == null)))?((((map__34598.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34598.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34598):map__34598);
var file = cljs.core.get.call(null,map__34598__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__34598,map__34598__$1,file){
return (function (p1__34593_SHARP_,p2__34594_SHARP_){
if(cljs.core._EQ_.call(null,p1__34593_SHARP_,p2__34594_SHARP_)){
return p1__34593_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__34598,map__34598__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34604){
var map__34605 = p__34604;
var map__34605__$1 = ((((!((map__34605 == null)))?((((map__34605.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34605.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34605):map__34605);
var match_length = cljs.core.get.call(null,map__34605__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34605__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34600_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34600_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args34607 = [];
var len__29766__auto___34610 = arguments.length;
var i__29767__auto___34611 = (0);
while(true){
if((i__29767__auto___34611 < len__29766__auto___34610)){
args34607.push((arguments[i__29767__auto___34611]));

var G__34612 = (i__29767__auto___34611 + (1));
i__29767__auto___34611 = G__34612;
continue;
} else {
}
break;
}

var G__34609 = args34607.length;
switch (G__34609) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34607.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__34614_SHARP_,p2__34615_SHARP_){
return cljs.core.assoc.call(null,p1__34614_SHARP_,cljs.core.get.call(null,p2__34615_SHARP_,key),p2__34615_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__34616){
var map__34619 = p__34616;
var map__34619__$1 = ((((!((map__34619 == null)))?((((map__34619.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34619.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34619):map__34619);
var f_data = map__34619__$1;
var file = cljs.core.get.call(null,map__34619__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34621,files_msg){
var map__34628 = p__34621;
var map__34628__$1 = ((((!((map__34628 == null)))?((((map__34628.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34628.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34628):map__34628);
var opts = map__34628__$1;
var on_cssload = cljs.core.get.call(null,map__34628__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__34630_34634 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__34631_34635 = null;
var count__34632_34636 = (0);
var i__34633_34637 = (0);
while(true){
if((i__34633_34637 < count__34632_34636)){
var f_34638 = cljs.core._nth.call(null,chunk__34631_34635,i__34633_34637);
figwheel.client.file_reloading.reload_css_file.call(null,f_34638);

var G__34639 = seq__34630_34634;
var G__34640 = chunk__34631_34635;
var G__34641 = count__34632_34636;
var G__34642 = (i__34633_34637 + (1));
seq__34630_34634 = G__34639;
chunk__34631_34635 = G__34640;
count__34632_34636 = G__34641;
i__34633_34637 = G__34642;
continue;
} else {
var temp__4657__auto___34643 = cljs.core.seq.call(null,seq__34630_34634);
if(temp__4657__auto___34643){
var seq__34630_34644__$1 = temp__4657__auto___34643;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34630_34644__$1)){
var c__29507__auto___34645 = cljs.core.chunk_first.call(null,seq__34630_34644__$1);
var G__34646 = cljs.core.chunk_rest.call(null,seq__34630_34644__$1);
var G__34647 = c__29507__auto___34645;
var G__34648 = cljs.core.count.call(null,c__29507__auto___34645);
var G__34649 = (0);
seq__34630_34634 = G__34646;
chunk__34631_34635 = G__34647;
count__34632_34636 = G__34648;
i__34633_34637 = G__34649;
continue;
} else {
var f_34650 = cljs.core.first.call(null,seq__34630_34644__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_34650);

var G__34651 = cljs.core.next.call(null,seq__34630_34644__$1);
var G__34652 = null;
var G__34653 = (0);
var G__34654 = (0);
seq__34630_34634 = G__34651;
chunk__34631_34635 = G__34652;
count__34632_34636 = G__34653;
i__34633_34637 = G__34654;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__34628,map__34628__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__34628,map__34628__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map