// Compiled by ClojureScript 1.8.51 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = true;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__33742_33746 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__33743_33747 = null;
var count__33744_33748 = (0);
var i__33745_33749 = (0);
while(true){
if((i__33745_33749 < count__33744_33748)){
var k_33750 = cljs.core._nth.call(null,chunk__33743_33747,i__33745_33749);
var v_33751 = (b[k_33750]);
(a[k_33750] = v_33751);

var G__33752 = seq__33742_33746;
var G__33753 = chunk__33743_33747;
var G__33754 = count__33744_33748;
var G__33755 = (i__33745_33749 + (1));
seq__33742_33746 = G__33752;
chunk__33743_33747 = G__33753;
count__33744_33748 = G__33754;
i__33745_33749 = G__33755;
continue;
} else {
var temp__4657__auto___33756 = cljs.core.seq.call(null,seq__33742_33746);
if(temp__4657__auto___33756){
var seq__33742_33757__$1 = temp__4657__auto___33756;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33742_33757__$1)){
var c__29511__auto___33758 = cljs.core.chunk_first.call(null,seq__33742_33757__$1);
var G__33759 = cljs.core.chunk_rest.call(null,seq__33742_33757__$1);
var G__33760 = c__29511__auto___33758;
var G__33761 = cljs.core.count.call(null,c__29511__auto___33758);
var G__33762 = (0);
seq__33742_33746 = G__33759;
chunk__33743_33747 = G__33760;
count__33744_33748 = G__33761;
i__33745_33749 = G__33762;
continue;
} else {
var k_33763 = cljs.core.first.call(null,seq__33742_33757__$1);
var v_33764 = (b[k_33763]);
(a[k_33763] = v_33764);

var G__33765 = cljs.core.next.call(null,seq__33742_33757__$1);
var G__33766 = null;
var G__33767 = (0);
var G__33768 = (0);
seq__33742_33746 = G__33765;
chunk__33743_33747 = G__33766;
count__33744_33748 = G__33767;
i__33745_33749 = G__33768;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args33769 = [];
var len__29770__auto___33772 = arguments.length;
var i__29771__auto___33773 = (0);
while(true){
if((i__29771__auto___33773 < len__29770__auto___33772)){
args33769.push((arguments[i__29771__auto___33773]));

var G__33774 = (i__29771__auto___33773 + (1));
i__29771__auto___33773 = G__33774;
continue;
} else {
}
break;
}

var G__33771 = args33769.length;
switch (G__33771) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33769.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__33776 = (i + (2));
var G__33777 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__33776;
ret = G__33777;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__33778_33782 = cljs.core.seq.call(null,v);
var chunk__33779_33783 = null;
var count__33780_33784 = (0);
var i__33781_33785 = (0);
while(true){
if((i__33781_33785 < count__33780_33784)){
var x_33786 = cljs.core._nth.call(null,chunk__33779_33783,i__33781_33785);
ret.push(x_33786);

var G__33787 = seq__33778_33782;
var G__33788 = chunk__33779_33783;
var G__33789 = count__33780_33784;
var G__33790 = (i__33781_33785 + (1));
seq__33778_33782 = G__33787;
chunk__33779_33783 = G__33788;
count__33780_33784 = G__33789;
i__33781_33785 = G__33790;
continue;
} else {
var temp__4657__auto___33791 = cljs.core.seq.call(null,seq__33778_33782);
if(temp__4657__auto___33791){
var seq__33778_33792__$1 = temp__4657__auto___33791;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33778_33792__$1)){
var c__29511__auto___33793 = cljs.core.chunk_first.call(null,seq__33778_33792__$1);
var G__33794 = cljs.core.chunk_rest.call(null,seq__33778_33792__$1);
var G__33795 = c__29511__auto___33793;
var G__33796 = cljs.core.count.call(null,c__29511__auto___33793);
var G__33797 = (0);
seq__33778_33782 = G__33794;
chunk__33779_33783 = G__33795;
count__33780_33784 = G__33796;
i__33781_33785 = G__33797;
continue;
} else {
var x_33798 = cljs.core.first.call(null,seq__33778_33792__$1);
ret.push(x_33798);

var G__33799 = cljs.core.next.call(null,seq__33778_33792__$1);
var G__33800 = null;
var G__33801 = (0);
var G__33802 = (0);
seq__33778_33782 = G__33799;
chunk__33779_33783 = G__33800;
count__33780_33784 = G__33801;
i__33781_33785 = G__33802;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__33803_33807 = cljs.core.seq.call(null,v);
var chunk__33804_33808 = null;
var count__33805_33809 = (0);
var i__33806_33810 = (0);
while(true){
if((i__33806_33810 < count__33805_33809)){
var x_33811 = cljs.core._nth.call(null,chunk__33804_33808,i__33806_33810);
ret.push(x_33811);

var G__33812 = seq__33803_33807;
var G__33813 = chunk__33804_33808;
var G__33814 = count__33805_33809;
var G__33815 = (i__33806_33810 + (1));
seq__33803_33807 = G__33812;
chunk__33804_33808 = G__33813;
count__33805_33809 = G__33814;
i__33806_33810 = G__33815;
continue;
} else {
var temp__4657__auto___33816 = cljs.core.seq.call(null,seq__33803_33807);
if(temp__4657__auto___33816){
var seq__33803_33817__$1 = temp__4657__auto___33816;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33803_33817__$1)){
var c__29511__auto___33818 = cljs.core.chunk_first.call(null,seq__33803_33817__$1);
var G__33819 = cljs.core.chunk_rest.call(null,seq__33803_33817__$1);
var G__33820 = c__29511__auto___33818;
var G__33821 = cljs.core.count.call(null,c__29511__auto___33818);
var G__33822 = (0);
seq__33803_33807 = G__33819;
chunk__33804_33808 = G__33820;
count__33805_33809 = G__33821;
i__33806_33810 = G__33822;
continue;
} else {
var x_33823 = cljs.core.first.call(null,seq__33803_33817__$1);
ret.push(x_33823);

var G__33824 = cljs.core.next.call(null,seq__33803_33817__$1);
var G__33825 = null;
var G__33826 = (0);
var G__33827 = (0);
seq__33803_33807 = G__33824;
chunk__33804_33808 = G__33825;
count__33805_33809 = G__33826;
i__33806_33810 = G__33827;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__33828_33832 = cljs.core.seq.call(null,v);
var chunk__33829_33833 = null;
var count__33830_33834 = (0);
var i__33831_33835 = (0);
while(true){
if((i__33831_33835 < count__33830_33834)){
var x_33836 = cljs.core._nth.call(null,chunk__33829_33833,i__33831_33835);
ret.push(x_33836);

var G__33837 = seq__33828_33832;
var G__33838 = chunk__33829_33833;
var G__33839 = count__33830_33834;
var G__33840 = (i__33831_33835 + (1));
seq__33828_33832 = G__33837;
chunk__33829_33833 = G__33838;
count__33830_33834 = G__33839;
i__33831_33835 = G__33840;
continue;
} else {
var temp__4657__auto___33841 = cljs.core.seq.call(null,seq__33828_33832);
if(temp__4657__auto___33841){
var seq__33828_33842__$1 = temp__4657__auto___33841;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33828_33842__$1)){
var c__29511__auto___33843 = cljs.core.chunk_first.call(null,seq__33828_33842__$1);
var G__33844 = cljs.core.chunk_rest.call(null,seq__33828_33842__$1);
var G__33845 = c__29511__auto___33843;
var G__33846 = cljs.core.count.call(null,c__29511__auto___33843);
var G__33847 = (0);
seq__33828_33832 = G__33844;
chunk__33829_33833 = G__33845;
count__33830_33834 = G__33846;
i__33831_33835 = G__33847;
continue;
} else {
var x_33848 = cljs.core.first.call(null,seq__33828_33842__$1);
ret.push(x_33848);

var G__33849 = cljs.core.next.call(null,seq__33828_33842__$1);
var G__33850 = null;
var G__33851 = (0);
var G__33852 = (0);
seq__33828_33832 = G__33849;
chunk__33829_33833 = G__33850;
count__33830_33834 = G__33851;
i__33831_33835 = G__33852;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args33853 = [];
var len__29770__auto___33864 = arguments.length;
var i__29771__auto___33865 = (0);
while(true){
if((i__29771__auto___33865 < len__29770__auto___33864)){
args33853.push((arguments[i__29771__auto___33865]));

var G__33866 = (i__29771__auto___33865 + (1));
i__29771__auto___33865 = G__33866;
continue;
} else {
}
break;
}

var G__33855 = args33853.length;
switch (G__33855) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33853.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__33856 = obj;
G__33856.push(kfn.call(null,k),vfn.call(null,v));

return G__33856;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x33857 = cljs.core.clone.call(null,handlers);
x33857.forEach = ((function (x33857,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__33858 = cljs.core.seq.call(null,coll);
var chunk__33859 = null;
var count__33860 = (0);
var i__33861 = (0);
while(true){
if((i__33861 < count__33860)){
var vec__33862 = cljs.core._nth.call(null,chunk__33859,i__33861);
var k = cljs.core.nth.call(null,vec__33862,(0),null);
var v = cljs.core.nth.call(null,vec__33862,(1),null);
f.call(null,v,k);

var G__33868 = seq__33858;
var G__33869 = chunk__33859;
var G__33870 = count__33860;
var G__33871 = (i__33861 + (1));
seq__33858 = G__33868;
chunk__33859 = G__33869;
count__33860 = G__33870;
i__33861 = G__33871;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__33858);
if(temp__4657__auto__){
var seq__33858__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33858__$1)){
var c__29511__auto__ = cljs.core.chunk_first.call(null,seq__33858__$1);
var G__33872 = cljs.core.chunk_rest.call(null,seq__33858__$1);
var G__33873 = c__29511__auto__;
var G__33874 = cljs.core.count.call(null,c__29511__auto__);
var G__33875 = (0);
seq__33858 = G__33872;
chunk__33859 = G__33873;
count__33860 = G__33874;
i__33861 = G__33875;
continue;
} else {
var vec__33863 = cljs.core.first.call(null,seq__33858__$1);
var k = cljs.core.nth.call(null,vec__33863,(0),null);
var v = cljs.core.nth.call(null,vec__33863,(1),null);
f.call(null,v,k);

var G__33876 = cljs.core.next.call(null,seq__33858__$1);
var G__33877 = null;
var G__33878 = (0);
var G__33879 = (0);
seq__33858 = G__33876;
chunk__33859 = G__33877;
count__33860 = G__33878;
i__33861 = G__33879;
continue;
}
} else {
return null;
}
}
break;
}
});})(x33857,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x33857;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args33880 = [];
var len__29770__auto___33886 = arguments.length;
var i__29771__auto___33887 = (0);
while(true){
if((i__29771__auto___33887 < len__29770__auto___33886)){
args33880.push((arguments[i__29771__auto___33887]));

var G__33888 = (i__29771__auto___33887 + (1));
i__29771__auto___33887 = G__33888;
continue;
} else {
}
break;
}

var G__33882 = args33880.length;
switch (G__33882) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33880.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit33883 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit33883 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta33884){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta33884 = meta33884;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit33883.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33885,meta33884__$1){
var self__ = this;
var _33885__$1 = this;
return (new cognitect.transit.t_cognitect$transit33883(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta33884__$1));
});

cognitect.transit.t_cognitect$transit33883.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33885){
var self__ = this;
var _33885__$1 = this;
return self__.meta33884;
});

cognitect.transit.t_cognitect$transit33883.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit33883.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit33883.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit33883.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit33883.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta33884","meta33884",-231601211,null)], null);
});

cognitect.transit.t_cognitect$transit33883.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit33883.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit33883";

cognitect.transit.t_cognitect$transit33883.cljs$lang$ctorPrWriter = (function (this__29306__auto__,writer__29307__auto__,opt__29308__auto__){
return cljs.core._write.call(null,writer__29307__auto__,"cognitect.transit/t_cognitect$transit33883");
});

cognitect.transit.__GT_t_cognitect$transit33883 = (function cognitect$transit$__GT_t_cognitect$transit33883(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta33884){
return (new cognitect.transit.t_cognitect$transit33883(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta33884));
});

}

return (new cognitect.transit.t_cognitect$transit33883(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__28700__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__28700__auto__)){
return or__28700__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map