// Compiled by ClojureScript 1.8.51 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args30859 = [];
var len__29766__auto___30865 = arguments.length;
var i__29767__auto___30866 = (0);
while(true){
if((i__29767__auto___30866 < len__29766__auto___30865)){
args30859.push((arguments[i__29767__auto___30866]));

var G__30867 = (i__29767__auto___30866 + (1));
i__29767__auto___30866 = G__30867;
continue;
} else {
}
break;
}

var G__30861 = args30859.length;
switch (G__30861) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30859.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30862 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30862 = (function (f,blockable,meta30863){
this.f = f;
this.blockable = blockable;
this.meta30863 = meta30863;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30862.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30864,meta30863__$1){
var self__ = this;
var _30864__$1 = this;
return (new cljs.core.async.t_cljs$core$async30862(self__.f,self__.blockable,meta30863__$1));
});

cljs.core.async.t_cljs$core$async30862.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30864){
var self__ = this;
var _30864__$1 = this;
return self__.meta30863;
});

cljs.core.async.t_cljs$core$async30862.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async30862.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30862.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30862.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30862.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30863","meta30863",-1726334172,null)], null);
});

cljs.core.async.t_cljs$core$async30862.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30862.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30862";

cljs.core.async.t_cljs$core$async30862.cljs$lang$ctorPrWriter = (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async30862");
});

cljs.core.async.__GT_t_cljs$core$async30862 = (function cljs$core$async$__GT_t_cljs$core$async30862(f__$1,blockable__$1,meta30863){
return (new cljs.core.async.t_cljs$core$async30862(f__$1,blockable__$1,meta30863));
});

}

return (new cljs.core.async.t_cljs$core$async30862(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args30871 = [];
var len__29766__auto___30874 = arguments.length;
var i__29767__auto___30875 = (0);
while(true){
if((i__29767__auto___30875 < len__29766__auto___30874)){
args30871.push((arguments[i__29767__auto___30875]));

var G__30876 = (i__29767__auto___30875 + (1));
i__29767__auto___30875 = G__30876;
continue;
} else {
}
break;
}

var G__30873 = args30871.length;
switch (G__30873) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30871.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args30878 = [];
var len__29766__auto___30881 = arguments.length;
var i__29767__auto___30882 = (0);
while(true){
if((i__29767__auto___30882 < len__29766__auto___30881)){
args30878.push((arguments[i__29767__auto___30882]));

var G__30883 = (i__29767__auto___30882 + (1));
i__29767__auto___30882 = G__30883;
continue;
} else {
}
break;
}

var G__30880 = args30878.length;
switch (G__30880) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30878.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args30885 = [];
var len__29766__auto___30888 = arguments.length;
var i__29767__auto___30889 = (0);
while(true){
if((i__29767__auto___30889 < len__29766__auto___30888)){
args30885.push((arguments[i__29767__auto___30889]));

var G__30890 = (i__29767__auto___30889 + (1));
i__29767__auto___30889 = G__30890;
continue;
} else {
}
break;
}

var G__30887 = args30885.length;
switch (G__30887) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30885.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_30892 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_30892);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_30892,ret){
return (function (){
return fn1.call(null,val_30892);
});})(val_30892,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args30893 = [];
var len__29766__auto___30896 = arguments.length;
var i__29767__auto___30897 = (0);
while(true){
if((i__29767__auto___30897 < len__29766__auto___30896)){
args30893.push((arguments[i__29767__auto___30897]));

var G__30898 = (i__29767__auto___30897 + (1));
i__29767__auto___30897 = G__30898;
continue;
} else {
}
break;
}

var G__30895 = args30893.length;
switch (G__30895) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30893.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29611__auto___30900 = n;
var x_30901 = (0);
while(true){
if((x_30901 < n__29611__auto___30900)){
(a[x_30901] = (0));

var G__30902 = (x_30901 + (1));
x_30901 = G__30902;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__30903 = (i + (1));
i = G__30903;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async30907 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30907 = (function (alt_flag,flag,meta30908){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta30908 = meta30908;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30907.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30909,meta30908__$1){
var self__ = this;
var _30909__$1 = this;
return (new cljs.core.async.t_cljs$core$async30907(self__.alt_flag,self__.flag,meta30908__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async30907.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30909){
var self__ = this;
var _30909__$1 = this;
return self__.meta30908;
});})(flag))
;

cljs.core.async.t_cljs$core$async30907.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async30907.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async30907.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30907.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30907.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30908","meta30908",103049699,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async30907.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30907.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30907";

cljs.core.async.t_cljs$core$async30907.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async30907");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async30907 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30907(alt_flag__$1,flag__$1,meta30908){
return (new cljs.core.async.t_cljs$core$async30907(alt_flag__$1,flag__$1,meta30908));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async30907(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async30913 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30913 = (function (alt_handler,flag,cb,meta30914){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta30914 = meta30914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30915,meta30914__$1){
var self__ = this;
var _30915__$1 = this;
return (new cljs.core.async.t_cljs$core$async30913(self__.alt_handler,self__.flag,self__.cb,meta30914__$1));
});

cljs.core.async.t_cljs$core$async30913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30915){
var self__ = this;
var _30915__$1 = this;
return self__.meta30914;
});

cljs.core.async.t_cljs$core$async30913.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async30913.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async30913.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30913.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async30913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30914","meta30914",1691831774,null)], null);
});

cljs.core.async.t_cljs$core$async30913.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30913.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30913";

cljs.core.async.t_cljs$core$async30913.cljs$lang$ctorPrWriter = (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async30913");
});

cljs.core.async.__GT_t_cljs$core$async30913 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30913(alt_handler__$1,flag__$1,cb__$1,meta30914){
return (new cljs.core.async.t_cljs$core$async30913(alt_handler__$1,flag__$1,cb__$1,meta30914));
});

}

return (new cljs.core.async.t_cljs$core$async30913(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30916_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30916_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30917_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30917_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28696__auto__ = wport;
if(cljs.core.truth_(or__28696__auto__)){
return or__28696__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30918 = (i + (1));
i = G__30918;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28696__auto__ = ret;
if(cljs.core.truth_(or__28696__auto__)){
return or__28696__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28684__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28684__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28684__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29773__auto__ = [];
var len__29766__auto___30924 = arguments.length;
var i__29767__auto___30925 = (0);
while(true){
if((i__29767__auto___30925 < len__29766__auto___30924)){
args__29773__auto__.push((arguments[i__29767__auto___30925]));

var G__30926 = (i__29767__auto___30925 + (1));
i__29767__auto___30925 = G__30926;
continue;
} else {
}
break;
}

var argseq__29774__auto__ = ((((1) < args__29773__auto__.length))?(new cljs.core.IndexedSeq(args__29773__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29774__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30921){
var map__30922 = p__30921;
var map__30922__$1 = ((((!((map__30922 == null)))?((((map__30922.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30922.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30922):map__30922);
var opts = map__30922__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30919){
var G__30920 = cljs.core.first.call(null,seq30919);
var seq30919__$1 = cljs.core.next.call(null,seq30919);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30920,seq30919__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args30927 = [];
var len__29766__auto___30977 = arguments.length;
var i__29767__auto___30978 = (0);
while(true){
if((i__29767__auto___30978 < len__29766__auto___30977)){
args30927.push((arguments[i__29767__auto___30978]));

var G__30979 = (i__29767__auto___30978 + (1));
i__29767__auto___30978 = G__30979;
continue;
} else {
}
break;
}

var G__30929 = args30927.length;
switch (G__30929) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30927.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30814__auto___30981 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___30981){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___30981){
return (function (state_30953){
var state_val_30954 = (state_30953[(1)]);
if((state_val_30954 === (7))){
var inst_30949 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
var statearr_30955_30982 = state_30953__$1;
(statearr_30955_30982[(2)] = inst_30949);

(statearr_30955_30982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (1))){
var state_30953__$1 = state_30953;
var statearr_30956_30983 = state_30953__$1;
(statearr_30956_30983[(2)] = null);

(statearr_30956_30983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (4))){
var inst_30932 = (state_30953[(7)]);
var inst_30932__$1 = (state_30953[(2)]);
var inst_30933 = (inst_30932__$1 == null);
var state_30953__$1 = (function (){var statearr_30957 = state_30953;
(statearr_30957[(7)] = inst_30932__$1);

return statearr_30957;
})();
if(cljs.core.truth_(inst_30933)){
var statearr_30958_30984 = state_30953__$1;
(statearr_30958_30984[(1)] = (5));

} else {
var statearr_30959_30985 = state_30953__$1;
(statearr_30959_30985[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (13))){
var state_30953__$1 = state_30953;
var statearr_30960_30986 = state_30953__$1;
(statearr_30960_30986[(2)] = null);

(statearr_30960_30986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (6))){
var inst_30932 = (state_30953[(7)]);
var state_30953__$1 = state_30953;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30953__$1,(11),to,inst_30932);
} else {
if((state_val_30954 === (3))){
var inst_30951 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30953__$1,inst_30951);
} else {
if((state_val_30954 === (12))){
var state_30953__$1 = state_30953;
var statearr_30961_30987 = state_30953__$1;
(statearr_30961_30987[(2)] = null);

(statearr_30961_30987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (2))){
var state_30953__$1 = state_30953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30953__$1,(4),from);
} else {
if((state_val_30954 === (11))){
var inst_30942 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
if(cljs.core.truth_(inst_30942)){
var statearr_30962_30988 = state_30953__$1;
(statearr_30962_30988[(1)] = (12));

} else {
var statearr_30963_30989 = state_30953__$1;
(statearr_30963_30989[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (9))){
var state_30953__$1 = state_30953;
var statearr_30964_30990 = state_30953__$1;
(statearr_30964_30990[(2)] = null);

(statearr_30964_30990[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (5))){
var state_30953__$1 = state_30953;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30965_30991 = state_30953__$1;
(statearr_30965_30991[(1)] = (8));

} else {
var statearr_30966_30992 = state_30953__$1;
(statearr_30966_30992[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (14))){
var inst_30947 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
var statearr_30967_30993 = state_30953__$1;
(statearr_30967_30993[(2)] = inst_30947);

(statearr_30967_30993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (10))){
var inst_30939 = (state_30953[(2)]);
var state_30953__$1 = state_30953;
var statearr_30968_30994 = state_30953__$1;
(statearr_30968_30994[(2)] = inst_30939);

(statearr_30968_30994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30954 === (8))){
var inst_30936 = cljs.core.async.close_BANG_.call(null,to);
var state_30953__$1 = state_30953;
var statearr_30969_30995 = state_30953__$1;
(statearr_30969_30995[(2)] = inst_30936);

(statearr_30969_30995[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___30981))
;
return ((function (switch__30702__auto__,c__30814__auto___30981){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_30973 = [null,null,null,null,null,null,null,null];
(statearr_30973[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_30973[(1)] = (1));

return statearr_30973;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_30953){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_30953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e30974){if((e30974 instanceof Object)){
var ex__30706__auto__ = e30974;
var statearr_30975_30996 = state_30953;
(statearr_30975_30996[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30974;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30997 = state_30953;
state_30953 = G__30997;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_30953){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_30953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___30981))
})();
var state__30816__auto__ = (function (){var statearr_30976 = f__30815__auto__.call(null);
(statearr_30976[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___30981);

return statearr_30976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___30981))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31181){
var vec__31182 = p__31181;
var v = cljs.core.nth.call(null,vec__31182,(0),null);
var p = cljs.core.nth.call(null,vec__31182,(1),null);
var job = vec__31182;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30814__auto___31364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___31364,res,vec__31182,v,p,job,jobs,results){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___31364,res,vec__31182,v,p,job,jobs,results){
return (function (state_31187){
var state_val_31188 = (state_31187[(1)]);
if((state_val_31188 === (1))){
var state_31187__$1 = state_31187;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31187__$1,(2),res,v);
} else {
if((state_val_31188 === (2))){
var inst_31184 = (state_31187[(2)]);
var inst_31185 = cljs.core.async.close_BANG_.call(null,res);
var state_31187__$1 = (function (){var statearr_31189 = state_31187;
(statearr_31189[(7)] = inst_31184);

return statearr_31189;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31187__$1,inst_31185);
} else {
return null;
}
}
});})(c__30814__auto___31364,res,vec__31182,v,p,job,jobs,results))
;
return ((function (switch__30702__auto__,c__30814__auto___31364,res,vec__31182,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0 = (function (){
var statearr_31193 = [null,null,null,null,null,null,null,null];
(statearr_31193[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__);

(statearr_31193[(1)] = (1));

return statearr_31193;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1 = (function (state_31187){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31194){if((e31194 instanceof Object)){
var ex__30706__auto__ = e31194;
var statearr_31195_31365 = state_31187;
(statearr_31195_31365[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31366 = state_31187;
state_31187 = G__31366;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = function(state_31187){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1.call(this,state_31187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___31364,res,vec__31182,v,p,job,jobs,results))
})();
var state__30816__auto__ = (function (){var statearr_31196 = f__30815__auto__.call(null);
(statearr_31196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___31364);

return statearr_31196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___31364,res,vec__31182,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31197){
var vec__31198 = p__31197;
var v = cljs.core.nth.call(null,vec__31198,(0),null);
var p = cljs.core.nth.call(null,vec__31198,(1),null);
var job = vec__31198;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29611__auto___31367 = n;
var __31368 = (0);
while(true){
if((__31368 < n__29611__auto___31367)){
var G__31199_31369 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31199_31369) {
case "compute":
var c__30814__auto___31371 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31368,c__30814__auto___31371,G__31199_31369,n__29611__auto___31367,jobs,results,process,async){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (__31368,c__30814__auto___31371,G__31199_31369,n__29611__auto___31367,jobs,results,process,async){
return (function (state_31212){
var state_val_31213 = (state_31212[(1)]);
if((state_val_31213 === (1))){
var state_31212__$1 = state_31212;
var statearr_31214_31372 = state_31212__$1;
(statearr_31214_31372[(2)] = null);

(statearr_31214_31372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (2))){
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31212__$1,(4),jobs);
} else {
if((state_val_31213 === (3))){
var inst_31210 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31212__$1,inst_31210);
} else {
if((state_val_31213 === (4))){
var inst_31202 = (state_31212[(2)]);
var inst_31203 = process.call(null,inst_31202);
var state_31212__$1 = state_31212;
if(cljs.core.truth_(inst_31203)){
var statearr_31215_31373 = state_31212__$1;
(statearr_31215_31373[(1)] = (5));

} else {
var statearr_31216_31374 = state_31212__$1;
(statearr_31216_31374[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (5))){
var state_31212__$1 = state_31212;
var statearr_31217_31375 = state_31212__$1;
(statearr_31217_31375[(2)] = null);

(statearr_31217_31375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (6))){
var state_31212__$1 = state_31212;
var statearr_31218_31376 = state_31212__$1;
(statearr_31218_31376[(2)] = null);

(statearr_31218_31376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31213 === (7))){
var inst_31208 = (state_31212[(2)]);
var state_31212__$1 = state_31212;
var statearr_31219_31377 = state_31212__$1;
(statearr_31219_31377[(2)] = inst_31208);

(statearr_31219_31377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31368,c__30814__auto___31371,G__31199_31369,n__29611__auto___31367,jobs,results,process,async))
;
return ((function (__31368,switch__30702__auto__,c__30814__auto___31371,G__31199_31369,n__29611__auto___31367,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0 = (function (){
var statearr_31223 = [null,null,null,null,null,null,null];
(statearr_31223[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__);

(statearr_31223[(1)] = (1));

return statearr_31223;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1 = (function (state_31212){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31224){if((e31224 instanceof Object)){
var ex__30706__auto__ = e31224;
var statearr_31225_31378 = state_31212;
(statearr_31225_31378[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31224;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31379 = state_31212;
state_31212 = G__31379;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = function(state_31212){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1.call(this,state_31212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__;
})()
;})(__31368,switch__30702__auto__,c__30814__auto___31371,G__31199_31369,n__29611__auto___31367,jobs,results,process,async))
})();
var state__30816__auto__ = (function (){var statearr_31226 = f__30815__auto__.call(null);
(statearr_31226[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___31371);

return statearr_31226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(__31368,c__30814__auto___31371,G__31199_31369,n__29611__auto___31367,jobs,results,process,async))
);


break;
case "async":
var c__30814__auto___31380 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31368,c__30814__auto___31380,G__31199_31369,n__29611__auto___31367,jobs,results,process,async){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (__31368,c__30814__auto___31380,G__31199_31369,n__29611__auto___31367,jobs,results,process,async){
return (function (state_31239){
var state_val_31240 = (state_31239[(1)]);
if((state_val_31240 === (1))){
var state_31239__$1 = state_31239;
var statearr_31241_31381 = state_31239__$1;
(statearr_31241_31381[(2)] = null);

(statearr_31241_31381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31240 === (2))){
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31239__$1,(4),jobs);
} else {
if((state_val_31240 === (3))){
var inst_31237 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31239__$1,inst_31237);
} else {
if((state_val_31240 === (4))){
var inst_31229 = (state_31239[(2)]);
var inst_31230 = async.call(null,inst_31229);
var state_31239__$1 = state_31239;
if(cljs.core.truth_(inst_31230)){
var statearr_31242_31382 = state_31239__$1;
(statearr_31242_31382[(1)] = (5));

} else {
var statearr_31243_31383 = state_31239__$1;
(statearr_31243_31383[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31240 === (5))){
var state_31239__$1 = state_31239;
var statearr_31244_31384 = state_31239__$1;
(statearr_31244_31384[(2)] = null);

(statearr_31244_31384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31240 === (6))){
var state_31239__$1 = state_31239;
var statearr_31245_31385 = state_31239__$1;
(statearr_31245_31385[(2)] = null);

(statearr_31245_31385[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31240 === (7))){
var inst_31235 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31246_31386 = state_31239__$1;
(statearr_31246_31386[(2)] = inst_31235);

(statearr_31246_31386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31368,c__30814__auto___31380,G__31199_31369,n__29611__auto___31367,jobs,results,process,async))
;
return ((function (__31368,switch__30702__auto__,c__30814__auto___31380,G__31199_31369,n__29611__auto___31367,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0 = (function (){
var statearr_31250 = [null,null,null,null,null,null,null];
(statearr_31250[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__);

(statearr_31250[(1)] = (1));

return statearr_31250;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1 = (function (state_31239){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31251){if((e31251 instanceof Object)){
var ex__30706__auto__ = e31251;
var statearr_31252_31387 = state_31239;
(statearr_31252_31387[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31239);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31388 = state_31239;
state_31239 = G__31388;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = function(state_31239){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1.call(this,state_31239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__;
})()
;})(__31368,switch__30702__auto__,c__30814__auto___31380,G__31199_31369,n__29611__auto___31367,jobs,results,process,async))
})();
var state__30816__auto__ = (function (){var statearr_31253 = f__30815__auto__.call(null);
(statearr_31253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___31380);

return statearr_31253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(__31368,c__30814__auto___31380,G__31199_31369,n__29611__auto___31367,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31389 = (__31368 + (1));
__31368 = G__31389;
continue;
} else {
}
break;
}

var c__30814__auto___31390 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___31390,jobs,results,process,async){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___31390,jobs,results,process,async){
return (function (state_31275){
var state_val_31276 = (state_31275[(1)]);
if((state_val_31276 === (1))){
var state_31275__$1 = state_31275;
var statearr_31277_31391 = state_31275__$1;
(statearr_31277_31391[(2)] = null);

(statearr_31277_31391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31276 === (2))){
var state_31275__$1 = state_31275;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31275__$1,(4),from);
} else {
if((state_val_31276 === (3))){
var inst_31273 = (state_31275[(2)]);
var state_31275__$1 = state_31275;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31275__$1,inst_31273);
} else {
if((state_val_31276 === (4))){
var inst_31256 = (state_31275[(7)]);
var inst_31256__$1 = (state_31275[(2)]);
var inst_31257 = (inst_31256__$1 == null);
var state_31275__$1 = (function (){var statearr_31278 = state_31275;
(statearr_31278[(7)] = inst_31256__$1);

return statearr_31278;
})();
if(cljs.core.truth_(inst_31257)){
var statearr_31279_31392 = state_31275__$1;
(statearr_31279_31392[(1)] = (5));

} else {
var statearr_31280_31393 = state_31275__$1;
(statearr_31280_31393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31276 === (5))){
var inst_31259 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31275__$1 = state_31275;
var statearr_31281_31394 = state_31275__$1;
(statearr_31281_31394[(2)] = inst_31259);

(statearr_31281_31394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31276 === (6))){
var inst_31256 = (state_31275[(7)]);
var inst_31261 = (state_31275[(8)]);
var inst_31261__$1 = cljs.core.async.chan.call(null,(1));
var inst_31262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31263 = [inst_31256,inst_31261__$1];
var inst_31264 = (new cljs.core.PersistentVector(null,2,(5),inst_31262,inst_31263,null));
var state_31275__$1 = (function (){var statearr_31282 = state_31275;
(statearr_31282[(8)] = inst_31261__$1);

return statearr_31282;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31275__$1,(8),jobs,inst_31264);
} else {
if((state_val_31276 === (7))){
var inst_31271 = (state_31275[(2)]);
var state_31275__$1 = state_31275;
var statearr_31283_31395 = state_31275__$1;
(statearr_31283_31395[(2)] = inst_31271);

(statearr_31283_31395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31276 === (8))){
var inst_31261 = (state_31275[(8)]);
var inst_31266 = (state_31275[(2)]);
var state_31275__$1 = (function (){var statearr_31284 = state_31275;
(statearr_31284[(9)] = inst_31266);

return statearr_31284;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31275__$1,(9),results,inst_31261);
} else {
if((state_val_31276 === (9))){
var inst_31268 = (state_31275[(2)]);
var state_31275__$1 = (function (){var statearr_31285 = state_31275;
(statearr_31285[(10)] = inst_31268);

return statearr_31285;
})();
var statearr_31286_31396 = state_31275__$1;
(statearr_31286_31396[(2)] = null);

(statearr_31286_31396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___31390,jobs,results,process,async))
;
return ((function (switch__30702__auto__,c__30814__auto___31390,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0 = (function (){
var statearr_31290 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31290[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__);

(statearr_31290[(1)] = (1));

return statearr_31290;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1 = (function (state_31275){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31275);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31291){if((e31291 instanceof Object)){
var ex__30706__auto__ = e31291;
var statearr_31292_31397 = state_31275;
(statearr_31292_31397[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31275);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31291;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31398 = state_31275;
state_31275 = G__31398;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = function(state_31275){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1.call(this,state_31275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___31390,jobs,results,process,async))
})();
var state__30816__auto__ = (function (){var statearr_31293 = f__30815__auto__.call(null);
(statearr_31293[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___31390);

return statearr_31293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___31390,jobs,results,process,async))
);


var c__30814__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto__,jobs,results,process,async){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto__,jobs,results,process,async){
return (function (state_31331){
var state_val_31332 = (state_31331[(1)]);
if((state_val_31332 === (7))){
var inst_31327 = (state_31331[(2)]);
var state_31331__$1 = state_31331;
var statearr_31333_31399 = state_31331__$1;
(statearr_31333_31399[(2)] = inst_31327);

(statearr_31333_31399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (20))){
var state_31331__$1 = state_31331;
var statearr_31334_31400 = state_31331__$1;
(statearr_31334_31400[(2)] = null);

(statearr_31334_31400[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (1))){
var state_31331__$1 = state_31331;
var statearr_31335_31401 = state_31331__$1;
(statearr_31335_31401[(2)] = null);

(statearr_31335_31401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (4))){
var inst_31296 = (state_31331[(7)]);
var inst_31296__$1 = (state_31331[(2)]);
var inst_31297 = (inst_31296__$1 == null);
var state_31331__$1 = (function (){var statearr_31336 = state_31331;
(statearr_31336[(7)] = inst_31296__$1);

return statearr_31336;
})();
if(cljs.core.truth_(inst_31297)){
var statearr_31337_31402 = state_31331__$1;
(statearr_31337_31402[(1)] = (5));

} else {
var statearr_31338_31403 = state_31331__$1;
(statearr_31338_31403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (15))){
var inst_31309 = (state_31331[(8)]);
var state_31331__$1 = state_31331;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31331__$1,(18),to,inst_31309);
} else {
if((state_val_31332 === (21))){
var inst_31322 = (state_31331[(2)]);
var state_31331__$1 = state_31331;
var statearr_31339_31404 = state_31331__$1;
(statearr_31339_31404[(2)] = inst_31322);

(statearr_31339_31404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (13))){
var inst_31324 = (state_31331[(2)]);
var state_31331__$1 = (function (){var statearr_31340 = state_31331;
(statearr_31340[(9)] = inst_31324);

return statearr_31340;
})();
var statearr_31341_31405 = state_31331__$1;
(statearr_31341_31405[(2)] = null);

(statearr_31341_31405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (6))){
var inst_31296 = (state_31331[(7)]);
var state_31331__$1 = state_31331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31331__$1,(11),inst_31296);
} else {
if((state_val_31332 === (17))){
var inst_31317 = (state_31331[(2)]);
var state_31331__$1 = state_31331;
if(cljs.core.truth_(inst_31317)){
var statearr_31342_31406 = state_31331__$1;
(statearr_31342_31406[(1)] = (19));

} else {
var statearr_31343_31407 = state_31331__$1;
(statearr_31343_31407[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (3))){
var inst_31329 = (state_31331[(2)]);
var state_31331__$1 = state_31331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31331__$1,inst_31329);
} else {
if((state_val_31332 === (12))){
var inst_31306 = (state_31331[(10)]);
var state_31331__$1 = state_31331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31331__$1,(14),inst_31306);
} else {
if((state_val_31332 === (2))){
var state_31331__$1 = state_31331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31331__$1,(4),results);
} else {
if((state_val_31332 === (19))){
var state_31331__$1 = state_31331;
var statearr_31344_31408 = state_31331__$1;
(statearr_31344_31408[(2)] = null);

(statearr_31344_31408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (11))){
var inst_31306 = (state_31331[(2)]);
var state_31331__$1 = (function (){var statearr_31345 = state_31331;
(statearr_31345[(10)] = inst_31306);

return statearr_31345;
})();
var statearr_31346_31409 = state_31331__$1;
(statearr_31346_31409[(2)] = null);

(statearr_31346_31409[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (9))){
var state_31331__$1 = state_31331;
var statearr_31347_31410 = state_31331__$1;
(statearr_31347_31410[(2)] = null);

(statearr_31347_31410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (5))){
var state_31331__$1 = state_31331;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31348_31411 = state_31331__$1;
(statearr_31348_31411[(1)] = (8));

} else {
var statearr_31349_31412 = state_31331__$1;
(statearr_31349_31412[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (14))){
var inst_31309 = (state_31331[(8)]);
var inst_31311 = (state_31331[(11)]);
var inst_31309__$1 = (state_31331[(2)]);
var inst_31310 = (inst_31309__$1 == null);
var inst_31311__$1 = cljs.core.not.call(null,inst_31310);
var state_31331__$1 = (function (){var statearr_31350 = state_31331;
(statearr_31350[(8)] = inst_31309__$1);

(statearr_31350[(11)] = inst_31311__$1);

return statearr_31350;
})();
if(inst_31311__$1){
var statearr_31351_31413 = state_31331__$1;
(statearr_31351_31413[(1)] = (15));

} else {
var statearr_31352_31414 = state_31331__$1;
(statearr_31352_31414[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (16))){
var inst_31311 = (state_31331[(11)]);
var state_31331__$1 = state_31331;
var statearr_31353_31415 = state_31331__$1;
(statearr_31353_31415[(2)] = inst_31311);

(statearr_31353_31415[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (10))){
var inst_31303 = (state_31331[(2)]);
var state_31331__$1 = state_31331;
var statearr_31354_31416 = state_31331__$1;
(statearr_31354_31416[(2)] = inst_31303);

(statearr_31354_31416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (18))){
var inst_31314 = (state_31331[(2)]);
var state_31331__$1 = state_31331;
var statearr_31355_31417 = state_31331__$1;
(statearr_31355_31417[(2)] = inst_31314);

(statearr_31355_31417[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31332 === (8))){
var inst_31300 = cljs.core.async.close_BANG_.call(null,to);
var state_31331__$1 = state_31331;
var statearr_31356_31418 = state_31331__$1;
(statearr_31356_31418[(2)] = inst_31300);

(statearr_31356_31418[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto__,jobs,results,process,async))
;
return ((function (switch__30702__auto__,c__30814__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0 = (function (){
var statearr_31360 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31360[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__);

(statearr_31360[(1)] = (1));

return statearr_31360;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1 = (function (state_31331){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31361){if((e31361 instanceof Object)){
var ex__30706__auto__ = e31361;
var statearr_31362_31419 = state_31331;
(statearr_31362_31419[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31331);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31361;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31420 = state_31331;
state_31331 = G__31420;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__ = function(state_31331){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1.call(this,state_31331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30703__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto__,jobs,results,process,async))
})();
var state__30816__auto__ = (function (){var statearr_31363 = f__30815__auto__.call(null);
(statearr_31363[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto__);

return statearr_31363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto__,jobs,results,process,async))
);

return c__30814__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31421 = [];
var len__29766__auto___31424 = arguments.length;
var i__29767__auto___31425 = (0);
while(true){
if((i__29767__auto___31425 < len__29766__auto___31424)){
args31421.push((arguments[i__29767__auto___31425]));

var G__31426 = (i__29767__auto___31425 + (1));
i__29767__auto___31425 = G__31426;
continue;
} else {
}
break;
}

var G__31423 = args31421.length;
switch (G__31423) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31421.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31428 = [];
var len__29766__auto___31431 = arguments.length;
var i__29767__auto___31432 = (0);
while(true){
if((i__29767__auto___31432 < len__29766__auto___31431)){
args31428.push((arguments[i__29767__auto___31432]));

var G__31433 = (i__29767__auto___31432 + (1));
i__29767__auto___31432 = G__31433;
continue;
} else {
}
break;
}

var G__31430 = args31428.length;
switch (G__31430) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31428.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31435 = [];
var len__29766__auto___31488 = arguments.length;
var i__29767__auto___31489 = (0);
while(true){
if((i__29767__auto___31489 < len__29766__auto___31488)){
args31435.push((arguments[i__29767__auto___31489]));

var G__31490 = (i__29767__auto___31489 + (1));
i__29767__auto___31489 = G__31490;
continue;
} else {
}
break;
}

var G__31437 = args31435.length;
switch (G__31437) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31435.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30814__auto___31492 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___31492,tc,fc){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___31492,tc,fc){
return (function (state_31463){
var state_val_31464 = (state_31463[(1)]);
if((state_val_31464 === (7))){
var inst_31459 = (state_31463[(2)]);
var state_31463__$1 = state_31463;
var statearr_31465_31493 = state_31463__$1;
(statearr_31465_31493[(2)] = inst_31459);

(statearr_31465_31493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (1))){
var state_31463__$1 = state_31463;
var statearr_31466_31494 = state_31463__$1;
(statearr_31466_31494[(2)] = null);

(statearr_31466_31494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (4))){
var inst_31440 = (state_31463[(7)]);
var inst_31440__$1 = (state_31463[(2)]);
var inst_31441 = (inst_31440__$1 == null);
var state_31463__$1 = (function (){var statearr_31467 = state_31463;
(statearr_31467[(7)] = inst_31440__$1);

return statearr_31467;
})();
if(cljs.core.truth_(inst_31441)){
var statearr_31468_31495 = state_31463__$1;
(statearr_31468_31495[(1)] = (5));

} else {
var statearr_31469_31496 = state_31463__$1;
(statearr_31469_31496[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (13))){
var state_31463__$1 = state_31463;
var statearr_31470_31497 = state_31463__$1;
(statearr_31470_31497[(2)] = null);

(statearr_31470_31497[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (6))){
var inst_31440 = (state_31463[(7)]);
var inst_31446 = p.call(null,inst_31440);
var state_31463__$1 = state_31463;
if(cljs.core.truth_(inst_31446)){
var statearr_31471_31498 = state_31463__$1;
(statearr_31471_31498[(1)] = (9));

} else {
var statearr_31472_31499 = state_31463__$1;
(statearr_31472_31499[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (3))){
var inst_31461 = (state_31463[(2)]);
var state_31463__$1 = state_31463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31463__$1,inst_31461);
} else {
if((state_val_31464 === (12))){
var state_31463__$1 = state_31463;
var statearr_31473_31500 = state_31463__$1;
(statearr_31473_31500[(2)] = null);

(statearr_31473_31500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (2))){
var state_31463__$1 = state_31463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31463__$1,(4),ch);
} else {
if((state_val_31464 === (11))){
var inst_31440 = (state_31463[(7)]);
var inst_31450 = (state_31463[(2)]);
var state_31463__$1 = state_31463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31463__$1,(8),inst_31450,inst_31440);
} else {
if((state_val_31464 === (9))){
var state_31463__$1 = state_31463;
var statearr_31474_31501 = state_31463__$1;
(statearr_31474_31501[(2)] = tc);

(statearr_31474_31501[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (5))){
var inst_31443 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31444 = cljs.core.async.close_BANG_.call(null,fc);
var state_31463__$1 = (function (){var statearr_31475 = state_31463;
(statearr_31475[(8)] = inst_31443);

return statearr_31475;
})();
var statearr_31476_31502 = state_31463__$1;
(statearr_31476_31502[(2)] = inst_31444);

(statearr_31476_31502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (14))){
var inst_31457 = (state_31463[(2)]);
var state_31463__$1 = state_31463;
var statearr_31477_31503 = state_31463__$1;
(statearr_31477_31503[(2)] = inst_31457);

(statearr_31477_31503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (10))){
var state_31463__$1 = state_31463;
var statearr_31478_31504 = state_31463__$1;
(statearr_31478_31504[(2)] = fc);

(statearr_31478_31504[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31464 === (8))){
var inst_31452 = (state_31463[(2)]);
var state_31463__$1 = state_31463;
if(cljs.core.truth_(inst_31452)){
var statearr_31479_31505 = state_31463__$1;
(statearr_31479_31505[(1)] = (12));

} else {
var statearr_31480_31506 = state_31463__$1;
(statearr_31480_31506[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___31492,tc,fc))
;
return ((function (switch__30702__auto__,c__30814__auto___31492,tc,fc){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_31484 = [null,null,null,null,null,null,null,null,null];
(statearr_31484[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_31484[(1)] = (1));

return statearr_31484;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_31463){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31485){if((e31485 instanceof Object)){
var ex__30706__auto__ = e31485;
var statearr_31486_31507 = state_31463;
(statearr_31486_31507[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31485;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31508 = state_31463;
state_31463 = G__31508;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_31463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_31463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___31492,tc,fc))
})();
var state__30816__auto__ = (function (){var statearr_31487 = f__30815__auto__.call(null);
(statearr_31487[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___31492);

return statearr_31487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___31492,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30814__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto__){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto__){
return (function (state_31572){
var state_val_31573 = (state_31572[(1)]);
if((state_val_31573 === (7))){
var inst_31568 = (state_31572[(2)]);
var state_31572__$1 = state_31572;
var statearr_31574_31595 = state_31572__$1;
(statearr_31574_31595[(2)] = inst_31568);

(statearr_31574_31595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (1))){
var inst_31552 = init;
var state_31572__$1 = (function (){var statearr_31575 = state_31572;
(statearr_31575[(7)] = inst_31552);

return statearr_31575;
})();
var statearr_31576_31596 = state_31572__$1;
(statearr_31576_31596[(2)] = null);

(statearr_31576_31596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (4))){
var inst_31555 = (state_31572[(8)]);
var inst_31555__$1 = (state_31572[(2)]);
var inst_31556 = (inst_31555__$1 == null);
var state_31572__$1 = (function (){var statearr_31577 = state_31572;
(statearr_31577[(8)] = inst_31555__$1);

return statearr_31577;
})();
if(cljs.core.truth_(inst_31556)){
var statearr_31578_31597 = state_31572__$1;
(statearr_31578_31597[(1)] = (5));

} else {
var statearr_31579_31598 = state_31572__$1;
(statearr_31579_31598[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (6))){
var inst_31552 = (state_31572[(7)]);
var inst_31555 = (state_31572[(8)]);
var inst_31559 = (state_31572[(9)]);
var inst_31559__$1 = f.call(null,inst_31552,inst_31555);
var inst_31560 = cljs.core.reduced_QMARK_.call(null,inst_31559__$1);
var state_31572__$1 = (function (){var statearr_31580 = state_31572;
(statearr_31580[(9)] = inst_31559__$1);

return statearr_31580;
})();
if(inst_31560){
var statearr_31581_31599 = state_31572__$1;
(statearr_31581_31599[(1)] = (8));

} else {
var statearr_31582_31600 = state_31572__$1;
(statearr_31582_31600[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (3))){
var inst_31570 = (state_31572[(2)]);
var state_31572__$1 = state_31572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31572__$1,inst_31570);
} else {
if((state_val_31573 === (2))){
var state_31572__$1 = state_31572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31572__$1,(4),ch);
} else {
if((state_val_31573 === (9))){
var inst_31559 = (state_31572[(9)]);
var inst_31552 = inst_31559;
var state_31572__$1 = (function (){var statearr_31583 = state_31572;
(statearr_31583[(7)] = inst_31552);

return statearr_31583;
})();
var statearr_31584_31601 = state_31572__$1;
(statearr_31584_31601[(2)] = null);

(statearr_31584_31601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (5))){
var inst_31552 = (state_31572[(7)]);
var state_31572__$1 = state_31572;
var statearr_31585_31602 = state_31572__$1;
(statearr_31585_31602[(2)] = inst_31552);

(statearr_31585_31602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (10))){
var inst_31566 = (state_31572[(2)]);
var state_31572__$1 = state_31572;
var statearr_31586_31603 = state_31572__$1;
(statearr_31586_31603[(2)] = inst_31566);

(statearr_31586_31603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31573 === (8))){
var inst_31559 = (state_31572[(9)]);
var inst_31562 = cljs.core.deref.call(null,inst_31559);
var state_31572__$1 = state_31572;
var statearr_31587_31604 = state_31572__$1;
(statearr_31587_31604[(2)] = inst_31562);

(statearr_31587_31604[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto__))
;
return ((function (switch__30702__auto__,c__30814__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30703__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30703__auto____0 = (function (){
var statearr_31591 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31591[(0)] = cljs$core$async$reduce_$_state_machine__30703__auto__);

(statearr_31591[(1)] = (1));

return statearr_31591;
});
var cljs$core$async$reduce_$_state_machine__30703__auto____1 = (function (state_31572){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31592){if((e31592 instanceof Object)){
var ex__30706__auto__ = e31592;
var statearr_31593_31605 = state_31572;
(statearr_31593_31605[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31606 = state_31572;
state_31572 = G__31606;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30703__auto__ = function(state_31572){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30703__auto____1.call(this,state_31572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30703__auto____0;
cljs$core$async$reduce_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30703__auto____1;
return cljs$core$async$reduce_$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto__))
})();
var state__30816__auto__ = (function (){var statearr_31594 = f__30815__auto__.call(null);
(statearr_31594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto__);

return statearr_31594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto__))
);

return c__30814__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args31607 = [];
var len__29766__auto___31659 = arguments.length;
var i__29767__auto___31660 = (0);
while(true){
if((i__29767__auto___31660 < len__29766__auto___31659)){
args31607.push((arguments[i__29767__auto___31660]));

var G__31661 = (i__29767__auto___31660 + (1));
i__29767__auto___31660 = G__31661;
continue;
} else {
}
break;
}

var G__31609 = args31607.length;
switch (G__31609) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31607.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30814__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto__){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto__){
return (function (state_31634){
var state_val_31635 = (state_31634[(1)]);
if((state_val_31635 === (7))){
var inst_31616 = (state_31634[(2)]);
var state_31634__$1 = state_31634;
var statearr_31636_31663 = state_31634__$1;
(statearr_31636_31663[(2)] = inst_31616);

(statearr_31636_31663[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (1))){
var inst_31610 = cljs.core.seq.call(null,coll);
var inst_31611 = inst_31610;
var state_31634__$1 = (function (){var statearr_31637 = state_31634;
(statearr_31637[(7)] = inst_31611);

return statearr_31637;
})();
var statearr_31638_31664 = state_31634__$1;
(statearr_31638_31664[(2)] = null);

(statearr_31638_31664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (4))){
var inst_31611 = (state_31634[(7)]);
var inst_31614 = cljs.core.first.call(null,inst_31611);
var state_31634__$1 = state_31634;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31634__$1,(7),ch,inst_31614);
} else {
if((state_val_31635 === (13))){
var inst_31628 = (state_31634[(2)]);
var state_31634__$1 = state_31634;
var statearr_31639_31665 = state_31634__$1;
(statearr_31639_31665[(2)] = inst_31628);

(statearr_31639_31665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (6))){
var inst_31619 = (state_31634[(2)]);
var state_31634__$1 = state_31634;
if(cljs.core.truth_(inst_31619)){
var statearr_31640_31666 = state_31634__$1;
(statearr_31640_31666[(1)] = (8));

} else {
var statearr_31641_31667 = state_31634__$1;
(statearr_31641_31667[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (3))){
var inst_31632 = (state_31634[(2)]);
var state_31634__$1 = state_31634;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31634__$1,inst_31632);
} else {
if((state_val_31635 === (12))){
var state_31634__$1 = state_31634;
var statearr_31642_31668 = state_31634__$1;
(statearr_31642_31668[(2)] = null);

(statearr_31642_31668[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (2))){
var inst_31611 = (state_31634[(7)]);
var state_31634__$1 = state_31634;
if(cljs.core.truth_(inst_31611)){
var statearr_31643_31669 = state_31634__$1;
(statearr_31643_31669[(1)] = (4));

} else {
var statearr_31644_31670 = state_31634__$1;
(statearr_31644_31670[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (11))){
var inst_31625 = cljs.core.async.close_BANG_.call(null,ch);
var state_31634__$1 = state_31634;
var statearr_31645_31671 = state_31634__$1;
(statearr_31645_31671[(2)] = inst_31625);

(statearr_31645_31671[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (9))){
var state_31634__$1 = state_31634;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31646_31672 = state_31634__$1;
(statearr_31646_31672[(1)] = (11));

} else {
var statearr_31647_31673 = state_31634__$1;
(statearr_31647_31673[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (5))){
var inst_31611 = (state_31634[(7)]);
var state_31634__$1 = state_31634;
var statearr_31648_31674 = state_31634__$1;
(statearr_31648_31674[(2)] = inst_31611);

(statearr_31648_31674[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (10))){
var inst_31630 = (state_31634[(2)]);
var state_31634__$1 = state_31634;
var statearr_31649_31675 = state_31634__$1;
(statearr_31649_31675[(2)] = inst_31630);

(statearr_31649_31675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31635 === (8))){
var inst_31611 = (state_31634[(7)]);
var inst_31621 = cljs.core.next.call(null,inst_31611);
var inst_31611__$1 = inst_31621;
var state_31634__$1 = (function (){var statearr_31650 = state_31634;
(statearr_31650[(7)] = inst_31611__$1);

return statearr_31650;
})();
var statearr_31651_31676 = state_31634__$1;
(statearr_31651_31676[(2)] = null);

(statearr_31651_31676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto__))
;
return ((function (switch__30702__auto__,c__30814__auto__){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_31655 = [null,null,null,null,null,null,null,null];
(statearr_31655[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_31655[(1)] = (1));

return statearr_31655;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_31634){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_31634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e31656){if((e31656 instanceof Object)){
var ex__30706__auto__ = e31656;
var statearr_31657_31677 = state_31634;
(statearr_31657_31677[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31634);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31678 = state_31634;
state_31634 = G__31678;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_31634){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_31634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto__))
})();
var state__30816__auto__ = (function (){var statearr_31658 = f__30815__auto__.call(null);
(statearr_31658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto__);

return statearr_31658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto__))
);

return c__30814__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29359__auto__ = (((_ == null))?null:_);
var m__29360__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,_);
} else {
var m__29360__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29360__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m,ch);
} else {
var m__29360__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m);
} else {
var m__29360__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31900 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31900 = (function (mult,ch,cs,meta31901){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta31901 = meta31901;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31902,meta31901__$1){
var self__ = this;
var _31902__$1 = this;
return (new cljs.core.async.t_cljs$core$async31900(self__.mult,self__.ch,self__.cs,meta31901__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31902){
var self__ = this;
var _31902__$1 = this;
return self__.meta31901;
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31901","meta31901",-711685164,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31900.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31900.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31900";

cljs.core.async.t_cljs$core$async31900.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async31900");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31900 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31900(mult__$1,ch__$1,cs__$1,meta31901){
return (new cljs.core.async.t_cljs$core$async31900(mult__$1,ch__$1,cs__$1,meta31901));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31900(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30814__auto___32121 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___32121,cs,m,dchan,dctr,done){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___32121,cs,m,dchan,dctr,done){
return (function (state_32033){
var state_val_32034 = (state_32033[(1)]);
if((state_val_32034 === (7))){
var inst_32029 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32035_32122 = state_32033__$1;
(statearr_32035_32122[(2)] = inst_32029);

(statearr_32035_32122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (20))){
var inst_31934 = (state_32033[(7)]);
var inst_31944 = cljs.core.first.call(null,inst_31934);
var inst_31945 = cljs.core.nth.call(null,inst_31944,(0),null);
var inst_31946 = cljs.core.nth.call(null,inst_31944,(1),null);
var state_32033__$1 = (function (){var statearr_32036 = state_32033;
(statearr_32036[(8)] = inst_31945);

return statearr_32036;
})();
if(cljs.core.truth_(inst_31946)){
var statearr_32037_32123 = state_32033__$1;
(statearr_32037_32123[(1)] = (22));

} else {
var statearr_32038_32124 = state_32033__$1;
(statearr_32038_32124[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (27))){
var inst_31976 = (state_32033[(9)]);
var inst_31974 = (state_32033[(10)]);
var inst_31905 = (state_32033[(11)]);
var inst_31981 = (state_32033[(12)]);
var inst_31981__$1 = cljs.core._nth.call(null,inst_31974,inst_31976);
var inst_31982 = cljs.core.async.put_BANG_.call(null,inst_31981__$1,inst_31905,done);
var state_32033__$1 = (function (){var statearr_32039 = state_32033;
(statearr_32039[(12)] = inst_31981__$1);

return statearr_32039;
})();
if(cljs.core.truth_(inst_31982)){
var statearr_32040_32125 = state_32033__$1;
(statearr_32040_32125[(1)] = (30));

} else {
var statearr_32041_32126 = state_32033__$1;
(statearr_32041_32126[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (1))){
var state_32033__$1 = state_32033;
var statearr_32042_32127 = state_32033__$1;
(statearr_32042_32127[(2)] = null);

(statearr_32042_32127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (24))){
var inst_31934 = (state_32033[(7)]);
var inst_31951 = (state_32033[(2)]);
var inst_31952 = cljs.core.next.call(null,inst_31934);
var inst_31914 = inst_31952;
var inst_31915 = null;
var inst_31916 = (0);
var inst_31917 = (0);
var state_32033__$1 = (function (){var statearr_32043 = state_32033;
(statearr_32043[(13)] = inst_31916);

(statearr_32043[(14)] = inst_31951);

(statearr_32043[(15)] = inst_31915);

(statearr_32043[(16)] = inst_31917);

(statearr_32043[(17)] = inst_31914);

return statearr_32043;
})();
var statearr_32044_32128 = state_32033__$1;
(statearr_32044_32128[(2)] = null);

(statearr_32044_32128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (39))){
var state_32033__$1 = state_32033;
var statearr_32048_32129 = state_32033__$1;
(statearr_32048_32129[(2)] = null);

(statearr_32048_32129[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (4))){
var inst_31905 = (state_32033[(11)]);
var inst_31905__$1 = (state_32033[(2)]);
var inst_31906 = (inst_31905__$1 == null);
var state_32033__$1 = (function (){var statearr_32049 = state_32033;
(statearr_32049[(11)] = inst_31905__$1);

return statearr_32049;
})();
if(cljs.core.truth_(inst_31906)){
var statearr_32050_32130 = state_32033__$1;
(statearr_32050_32130[(1)] = (5));

} else {
var statearr_32051_32131 = state_32033__$1;
(statearr_32051_32131[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (15))){
var inst_31916 = (state_32033[(13)]);
var inst_31915 = (state_32033[(15)]);
var inst_31917 = (state_32033[(16)]);
var inst_31914 = (state_32033[(17)]);
var inst_31930 = (state_32033[(2)]);
var inst_31931 = (inst_31917 + (1));
var tmp32045 = inst_31916;
var tmp32046 = inst_31915;
var tmp32047 = inst_31914;
var inst_31914__$1 = tmp32047;
var inst_31915__$1 = tmp32046;
var inst_31916__$1 = tmp32045;
var inst_31917__$1 = inst_31931;
var state_32033__$1 = (function (){var statearr_32052 = state_32033;
(statearr_32052[(13)] = inst_31916__$1);

(statearr_32052[(18)] = inst_31930);

(statearr_32052[(15)] = inst_31915__$1);

(statearr_32052[(16)] = inst_31917__$1);

(statearr_32052[(17)] = inst_31914__$1);

return statearr_32052;
})();
var statearr_32053_32132 = state_32033__$1;
(statearr_32053_32132[(2)] = null);

(statearr_32053_32132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (21))){
var inst_31955 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32057_32133 = state_32033__$1;
(statearr_32057_32133[(2)] = inst_31955);

(statearr_32057_32133[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (31))){
var inst_31981 = (state_32033[(12)]);
var inst_31985 = done.call(null,null);
var inst_31986 = cljs.core.async.untap_STAR_.call(null,m,inst_31981);
var state_32033__$1 = (function (){var statearr_32058 = state_32033;
(statearr_32058[(19)] = inst_31985);

return statearr_32058;
})();
var statearr_32059_32134 = state_32033__$1;
(statearr_32059_32134[(2)] = inst_31986);

(statearr_32059_32134[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (32))){
var inst_31975 = (state_32033[(20)]);
var inst_31976 = (state_32033[(9)]);
var inst_31974 = (state_32033[(10)]);
var inst_31973 = (state_32033[(21)]);
var inst_31988 = (state_32033[(2)]);
var inst_31989 = (inst_31976 + (1));
var tmp32054 = inst_31975;
var tmp32055 = inst_31974;
var tmp32056 = inst_31973;
var inst_31973__$1 = tmp32056;
var inst_31974__$1 = tmp32055;
var inst_31975__$1 = tmp32054;
var inst_31976__$1 = inst_31989;
var state_32033__$1 = (function (){var statearr_32060 = state_32033;
(statearr_32060[(20)] = inst_31975__$1);

(statearr_32060[(9)] = inst_31976__$1);

(statearr_32060[(10)] = inst_31974__$1);

(statearr_32060[(22)] = inst_31988);

(statearr_32060[(21)] = inst_31973__$1);

return statearr_32060;
})();
var statearr_32061_32135 = state_32033__$1;
(statearr_32061_32135[(2)] = null);

(statearr_32061_32135[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (40))){
var inst_32001 = (state_32033[(23)]);
var inst_32005 = done.call(null,null);
var inst_32006 = cljs.core.async.untap_STAR_.call(null,m,inst_32001);
var state_32033__$1 = (function (){var statearr_32062 = state_32033;
(statearr_32062[(24)] = inst_32005);

return statearr_32062;
})();
var statearr_32063_32136 = state_32033__$1;
(statearr_32063_32136[(2)] = inst_32006);

(statearr_32063_32136[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (33))){
var inst_31992 = (state_32033[(25)]);
var inst_31994 = cljs.core.chunked_seq_QMARK_.call(null,inst_31992);
var state_32033__$1 = state_32033;
if(inst_31994){
var statearr_32064_32137 = state_32033__$1;
(statearr_32064_32137[(1)] = (36));

} else {
var statearr_32065_32138 = state_32033__$1;
(statearr_32065_32138[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (13))){
var inst_31924 = (state_32033[(26)]);
var inst_31927 = cljs.core.async.close_BANG_.call(null,inst_31924);
var state_32033__$1 = state_32033;
var statearr_32066_32139 = state_32033__$1;
(statearr_32066_32139[(2)] = inst_31927);

(statearr_32066_32139[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (22))){
var inst_31945 = (state_32033[(8)]);
var inst_31948 = cljs.core.async.close_BANG_.call(null,inst_31945);
var state_32033__$1 = state_32033;
var statearr_32067_32140 = state_32033__$1;
(statearr_32067_32140[(2)] = inst_31948);

(statearr_32067_32140[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (36))){
var inst_31992 = (state_32033[(25)]);
var inst_31996 = cljs.core.chunk_first.call(null,inst_31992);
var inst_31997 = cljs.core.chunk_rest.call(null,inst_31992);
var inst_31998 = cljs.core.count.call(null,inst_31996);
var inst_31973 = inst_31997;
var inst_31974 = inst_31996;
var inst_31975 = inst_31998;
var inst_31976 = (0);
var state_32033__$1 = (function (){var statearr_32068 = state_32033;
(statearr_32068[(20)] = inst_31975);

(statearr_32068[(9)] = inst_31976);

(statearr_32068[(10)] = inst_31974);

(statearr_32068[(21)] = inst_31973);

return statearr_32068;
})();
var statearr_32069_32141 = state_32033__$1;
(statearr_32069_32141[(2)] = null);

(statearr_32069_32141[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (41))){
var inst_31992 = (state_32033[(25)]);
var inst_32008 = (state_32033[(2)]);
var inst_32009 = cljs.core.next.call(null,inst_31992);
var inst_31973 = inst_32009;
var inst_31974 = null;
var inst_31975 = (0);
var inst_31976 = (0);
var state_32033__$1 = (function (){var statearr_32070 = state_32033;
(statearr_32070[(20)] = inst_31975);

(statearr_32070[(9)] = inst_31976);

(statearr_32070[(10)] = inst_31974);

(statearr_32070[(27)] = inst_32008);

(statearr_32070[(21)] = inst_31973);

return statearr_32070;
})();
var statearr_32071_32142 = state_32033__$1;
(statearr_32071_32142[(2)] = null);

(statearr_32071_32142[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (43))){
var state_32033__$1 = state_32033;
var statearr_32072_32143 = state_32033__$1;
(statearr_32072_32143[(2)] = null);

(statearr_32072_32143[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (29))){
var inst_32017 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32073_32144 = state_32033__$1;
(statearr_32073_32144[(2)] = inst_32017);

(statearr_32073_32144[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (44))){
var inst_32026 = (state_32033[(2)]);
var state_32033__$1 = (function (){var statearr_32074 = state_32033;
(statearr_32074[(28)] = inst_32026);

return statearr_32074;
})();
var statearr_32075_32145 = state_32033__$1;
(statearr_32075_32145[(2)] = null);

(statearr_32075_32145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (6))){
var inst_31965 = (state_32033[(29)]);
var inst_31964 = cljs.core.deref.call(null,cs);
var inst_31965__$1 = cljs.core.keys.call(null,inst_31964);
var inst_31966 = cljs.core.count.call(null,inst_31965__$1);
var inst_31967 = cljs.core.reset_BANG_.call(null,dctr,inst_31966);
var inst_31972 = cljs.core.seq.call(null,inst_31965__$1);
var inst_31973 = inst_31972;
var inst_31974 = null;
var inst_31975 = (0);
var inst_31976 = (0);
var state_32033__$1 = (function (){var statearr_32076 = state_32033;
(statearr_32076[(20)] = inst_31975);

(statearr_32076[(30)] = inst_31967);

(statearr_32076[(9)] = inst_31976);

(statearr_32076[(10)] = inst_31974);

(statearr_32076[(29)] = inst_31965__$1);

(statearr_32076[(21)] = inst_31973);

return statearr_32076;
})();
var statearr_32077_32146 = state_32033__$1;
(statearr_32077_32146[(2)] = null);

(statearr_32077_32146[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (28))){
var inst_31992 = (state_32033[(25)]);
var inst_31973 = (state_32033[(21)]);
var inst_31992__$1 = cljs.core.seq.call(null,inst_31973);
var state_32033__$1 = (function (){var statearr_32078 = state_32033;
(statearr_32078[(25)] = inst_31992__$1);

return statearr_32078;
})();
if(inst_31992__$1){
var statearr_32079_32147 = state_32033__$1;
(statearr_32079_32147[(1)] = (33));

} else {
var statearr_32080_32148 = state_32033__$1;
(statearr_32080_32148[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (25))){
var inst_31975 = (state_32033[(20)]);
var inst_31976 = (state_32033[(9)]);
var inst_31978 = (inst_31976 < inst_31975);
var inst_31979 = inst_31978;
var state_32033__$1 = state_32033;
if(cljs.core.truth_(inst_31979)){
var statearr_32081_32149 = state_32033__$1;
(statearr_32081_32149[(1)] = (27));

} else {
var statearr_32082_32150 = state_32033__$1;
(statearr_32082_32150[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (34))){
var state_32033__$1 = state_32033;
var statearr_32083_32151 = state_32033__$1;
(statearr_32083_32151[(2)] = null);

(statearr_32083_32151[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (17))){
var state_32033__$1 = state_32033;
var statearr_32084_32152 = state_32033__$1;
(statearr_32084_32152[(2)] = null);

(statearr_32084_32152[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (3))){
var inst_32031 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32033__$1,inst_32031);
} else {
if((state_val_32034 === (12))){
var inst_31960 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32085_32153 = state_32033__$1;
(statearr_32085_32153[(2)] = inst_31960);

(statearr_32085_32153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (2))){
var state_32033__$1 = state_32033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32033__$1,(4),ch);
} else {
if((state_val_32034 === (23))){
var state_32033__$1 = state_32033;
var statearr_32086_32154 = state_32033__$1;
(statearr_32086_32154[(2)] = null);

(statearr_32086_32154[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (35))){
var inst_32015 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32087_32155 = state_32033__$1;
(statearr_32087_32155[(2)] = inst_32015);

(statearr_32087_32155[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (19))){
var inst_31934 = (state_32033[(7)]);
var inst_31938 = cljs.core.chunk_first.call(null,inst_31934);
var inst_31939 = cljs.core.chunk_rest.call(null,inst_31934);
var inst_31940 = cljs.core.count.call(null,inst_31938);
var inst_31914 = inst_31939;
var inst_31915 = inst_31938;
var inst_31916 = inst_31940;
var inst_31917 = (0);
var state_32033__$1 = (function (){var statearr_32088 = state_32033;
(statearr_32088[(13)] = inst_31916);

(statearr_32088[(15)] = inst_31915);

(statearr_32088[(16)] = inst_31917);

(statearr_32088[(17)] = inst_31914);

return statearr_32088;
})();
var statearr_32089_32156 = state_32033__$1;
(statearr_32089_32156[(2)] = null);

(statearr_32089_32156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (11))){
var inst_31934 = (state_32033[(7)]);
var inst_31914 = (state_32033[(17)]);
var inst_31934__$1 = cljs.core.seq.call(null,inst_31914);
var state_32033__$1 = (function (){var statearr_32090 = state_32033;
(statearr_32090[(7)] = inst_31934__$1);

return statearr_32090;
})();
if(inst_31934__$1){
var statearr_32091_32157 = state_32033__$1;
(statearr_32091_32157[(1)] = (16));

} else {
var statearr_32092_32158 = state_32033__$1;
(statearr_32092_32158[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (9))){
var inst_31962 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32093_32159 = state_32033__$1;
(statearr_32093_32159[(2)] = inst_31962);

(statearr_32093_32159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (5))){
var inst_31912 = cljs.core.deref.call(null,cs);
var inst_31913 = cljs.core.seq.call(null,inst_31912);
var inst_31914 = inst_31913;
var inst_31915 = null;
var inst_31916 = (0);
var inst_31917 = (0);
var state_32033__$1 = (function (){var statearr_32094 = state_32033;
(statearr_32094[(13)] = inst_31916);

(statearr_32094[(15)] = inst_31915);

(statearr_32094[(16)] = inst_31917);

(statearr_32094[(17)] = inst_31914);

return statearr_32094;
})();
var statearr_32095_32160 = state_32033__$1;
(statearr_32095_32160[(2)] = null);

(statearr_32095_32160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (14))){
var state_32033__$1 = state_32033;
var statearr_32096_32161 = state_32033__$1;
(statearr_32096_32161[(2)] = null);

(statearr_32096_32161[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (45))){
var inst_32023 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32097_32162 = state_32033__$1;
(statearr_32097_32162[(2)] = inst_32023);

(statearr_32097_32162[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (26))){
var inst_31965 = (state_32033[(29)]);
var inst_32019 = (state_32033[(2)]);
var inst_32020 = cljs.core.seq.call(null,inst_31965);
var state_32033__$1 = (function (){var statearr_32098 = state_32033;
(statearr_32098[(31)] = inst_32019);

return statearr_32098;
})();
if(inst_32020){
var statearr_32099_32163 = state_32033__$1;
(statearr_32099_32163[(1)] = (42));

} else {
var statearr_32100_32164 = state_32033__$1;
(statearr_32100_32164[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (16))){
var inst_31934 = (state_32033[(7)]);
var inst_31936 = cljs.core.chunked_seq_QMARK_.call(null,inst_31934);
var state_32033__$1 = state_32033;
if(inst_31936){
var statearr_32101_32165 = state_32033__$1;
(statearr_32101_32165[(1)] = (19));

} else {
var statearr_32102_32166 = state_32033__$1;
(statearr_32102_32166[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (38))){
var inst_32012 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32103_32167 = state_32033__$1;
(statearr_32103_32167[(2)] = inst_32012);

(statearr_32103_32167[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (30))){
var state_32033__$1 = state_32033;
var statearr_32104_32168 = state_32033__$1;
(statearr_32104_32168[(2)] = null);

(statearr_32104_32168[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (10))){
var inst_31915 = (state_32033[(15)]);
var inst_31917 = (state_32033[(16)]);
var inst_31923 = cljs.core._nth.call(null,inst_31915,inst_31917);
var inst_31924 = cljs.core.nth.call(null,inst_31923,(0),null);
var inst_31925 = cljs.core.nth.call(null,inst_31923,(1),null);
var state_32033__$1 = (function (){var statearr_32105 = state_32033;
(statearr_32105[(26)] = inst_31924);

return statearr_32105;
})();
if(cljs.core.truth_(inst_31925)){
var statearr_32106_32169 = state_32033__$1;
(statearr_32106_32169[(1)] = (13));

} else {
var statearr_32107_32170 = state_32033__$1;
(statearr_32107_32170[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (18))){
var inst_31958 = (state_32033[(2)]);
var state_32033__$1 = state_32033;
var statearr_32108_32171 = state_32033__$1;
(statearr_32108_32171[(2)] = inst_31958);

(statearr_32108_32171[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (42))){
var state_32033__$1 = state_32033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32033__$1,(45),dchan);
} else {
if((state_val_32034 === (37))){
var inst_32001 = (state_32033[(23)]);
var inst_31905 = (state_32033[(11)]);
var inst_31992 = (state_32033[(25)]);
var inst_32001__$1 = cljs.core.first.call(null,inst_31992);
var inst_32002 = cljs.core.async.put_BANG_.call(null,inst_32001__$1,inst_31905,done);
var state_32033__$1 = (function (){var statearr_32109 = state_32033;
(statearr_32109[(23)] = inst_32001__$1);

return statearr_32109;
})();
if(cljs.core.truth_(inst_32002)){
var statearr_32110_32172 = state_32033__$1;
(statearr_32110_32172[(1)] = (39));

} else {
var statearr_32111_32173 = state_32033__$1;
(statearr_32111_32173[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32034 === (8))){
var inst_31916 = (state_32033[(13)]);
var inst_31917 = (state_32033[(16)]);
var inst_31919 = (inst_31917 < inst_31916);
var inst_31920 = inst_31919;
var state_32033__$1 = state_32033;
if(cljs.core.truth_(inst_31920)){
var statearr_32112_32174 = state_32033__$1;
(statearr_32112_32174[(1)] = (10));

} else {
var statearr_32113_32175 = state_32033__$1;
(statearr_32113_32175[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___32121,cs,m,dchan,dctr,done))
;
return ((function (switch__30702__auto__,c__30814__auto___32121,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30703__auto__ = null;
var cljs$core$async$mult_$_state_machine__30703__auto____0 = (function (){
var statearr_32117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32117[(0)] = cljs$core$async$mult_$_state_machine__30703__auto__);

(statearr_32117[(1)] = (1));

return statearr_32117;
});
var cljs$core$async$mult_$_state_machine__30703__auto____1 = (function (state_32033){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_32033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e32118){if((e32118 instanceof Object)){
var ex__30706__auto__ = e32118;
var statearr_32119_32176 = state_32033;
(statearr_32119_32176[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32033);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32118;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32177 = state_32033;
state_32033 = G__32177;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30703__auto__ = function(state_32033){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30703__auto____1.call(this,state_32033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30703__auto____0;
cljs$core$async$mult_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30703__auto____1;
return cljs$core$async$mult_$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___32121,cs,m,dchan,dctr,done))
})();
var state__30816__auto__ = (function (){var statearr_32120 = f__30815__auto__.call(null);
(statearr_32120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___32121);

return statearr_32120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___32121,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args32178 = [];
var len__29766__auto___32181 = arguments.length;
var i__29767__auto___32182 = (0);
while(true){
if((i__29767__auto___32182 < len__29766__auto___32181)){
args32178.push((arguments[i__29767__auto___32182]));

var G__32183 = (i__29767__auto___32182 + (1));
i__29767__auto___32182 = G__32183;
continue;
} else {
}
break;
}

var G__32180 = args32178.length;
switch (G__32180) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32178.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m,ch);
} else {
var m__29360__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m,ch);
} else {
var m__29360__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m);
} else {
var m__29360__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m,state_map);
} else {
var m__29360__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29359__auto__ = (((m == null))?null:m);
var m__29360__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,m,mode);
} else {
var m__29360__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29773__auto__ = [];
var len__29766__auto___32195 = arguments.length;
var i__29767__auto___32196 = (0);
while(true){
if((i__29767__auto___32196 < len__29766__auto___32195)){
args__29773__auto__.push((arguments[i__29767__auto___32196]));

var G__32197 = (i__29767__auto___32196 + (1));
i__29767__auto___32196 = G__32197;
continue;
} else {
}
break;
}

var argseq__29774__auto__ = ((((3) < args__29773__auto__.length))?(new cljs.core.IndexedSeq(args__29773__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29774__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32189){
var map__32190 = p__32189;
var map__32190__$1 = ((((!((map__32190 == null)))?((((map__32190.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32190.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32190):map__32190);
var opts = map__32190__$1;
var statearr_32192_32198 = state;
(statearr_32192_32198[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__32190,map__32190__$1,opts){
return (function (val){
var statearr_32193_32199 = state;
(statearr_32193_32199[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__32190,map__32190__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32194_32200 = state;
(statearr_32194_32200[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32185){
var G__32186 = cljs.core.first.call(null,seq32185);
var seq32185__$1 = cljs.core.next.call(null,seq32185);
var G__32187 = cljs.core.first.call(null,seq32185__$1);
var seq32185__$2 = cljs.core.next.call(null,seq32185__$1);
var G__32188 = cljs.core.first.call(null,seq32185__$2);
var seq32185__$3 = cljs.core.next.call(null,seq32185__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32186,G__32187,G__32188,seq32185__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32364 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32364 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32365){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32365 = meta32365;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32366,meta32365__$1){
var self__ = this;
var _32366__$1 = this;
return (new cljs.core.async.t_cljs$core$async32364(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32365__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32366){
var self__ = this;
var _32366__$1 = this;
return self__.meta32365;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32365","meta32365",1977396865,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32364.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32364.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32364";

cljs.core.async.t_cljs$core$async32364.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async32364");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32364 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32364(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32365){
return (new cljs.core.async.t_cljs$core$async32364(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32365));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32364(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30814__auto___32527 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___32527,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___32527,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32464){
var state_val_32465 = (state_32464[(1)]);
if((state_val_32465 === (7))){
var inst_32382 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
var statearr_32466_32528 = state_32464__$1;
(statearr_32466_32528[(2)] = inst_32382);

(statearr_32466_32528[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (20))){
var inst_32394 = (state_32464[(7)]);
var state_32464__$1 = state_32464;
var statearr_32467_32529 = state_32464__$1;
(statearr_32467_32529[(2)] = inst_32394);

(statearr_32467_32529[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (27))){
var state_32464__$1 = state_32464;
var statearr_32468_32530 = state_32464__$1;
(statearr_32468_32530[(2)] = null);

(statearr_32468_32530[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (1))){
var inst_32370 = (state_32464[(8)]);
var inst_32370__$1 = calc_state.call(null);
var inst_32372 = (inst_32370__$1 == null);
var inst_32373 = cljs.core.not.call(null,inst_32372);
var state_32464__$1 = (function (){var statearr_32469 = state_32464;
(statearr_32469[(8)] = inst_32370__$1);

return statearr_32469;
})();
if(inst_32373){
var statearr_32470_32531 = state_32464__$1;
(statearr_32470_32531[(1)] = (2));

} else {
var statearr_32471_32532 = state_32464__$1;
(statearr_32471_32532[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (24))){
var inst_32424 = (state_32464[(9)]);
var inst_32417 = (state_32464[(10)]);
var inst_32438 = (state_32464[(11)]);
var inst_32438__$1 = inst_32417.call(null,inst_32424);
var state_32464__$1 = (function (){var statearr_32472 = state_32464;
(statearr_32472[(11)] = inst_32438__$1);

return statearr_32472;
})();
if(cljs.core.truth_(inst_32438__$1)){
var statearr_32473_32533 = state_32464__$1;
(statearr_32473_32533[(1)] = (29));

} else {
var statearr_32474_32534 = state_32464__$1;
(statearr_32474_32534[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (4))){
var inst_32385 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32385)){
var statearr_32475_32535 = state_32464__$1;
(statearr_32475_32535[(1)] = (8));

} else {
var statearr_32476_32536 = state_32464__$1;
(statearr_32476_32536[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (15))){
var inst_32411 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32411)){
var statearr_32477_32537 = state_32464__$1;
(statearr_32477_32537[(1)] = (19));

} else {
var statearr_32478_32538 = state_32464__$1;
(statearr_32478_32538[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (21))){
var inst_32416 = (state_32464[(12)]);
var inst_32416__$1 = (state_32464[(2)]);
var inst_32417 = cljs.core.get.call(null,inst_32416__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32418 = cljs.core.get.call(null,inst_32416__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32419 = cljs.core.get.call(null,inst_32416__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32464__$1 = (function (){var statearr_32479 = state_32464;
(statearr_32479[(10)] = inst_32417);

(statearr_32479[(12)] = inst_32416__$1);

(statearr_32479[(13)] = inst_32418);

return statearr_32479;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_32464__$1,(22),inst_32419);
} else {
if((state_val_32465 === (31))){
var inst_32446 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32446)){
var statearr_32480_32539 = state_32464__$1;
(statearr_32480_32539[(1)] = (32));

} else {
var statearr_32481_32540 = state_32464__$1;
(statearr_32481_32540[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (32))){
var inst_32423 = (state_32464[(14)]);
var state_32464__$1 = state_32464;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32464__$1,(35),out,inst_32423);
} else {
if((state_val_32465 === (33))){
var inst_32416 = (state_32464[(12)]);
var inst_32394 = inst_32416;
var state_32464__$1 = (function (){var statearr_32482 = state_32464;
(statearr_32482[(7)] = inst_32394);

return statearr_32482;
})();
var statearr_32483_32541 = state_32464__$1;
(statearr_32483_32541[(2)] = null);

(statearr_32483_32541[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (13))){
var inst_32394 = (state_32464[(7)]);
var inst_32401 = inst_32394.cljs$lang$protocol_mask$partition0$;
var inst_32402 = (inst_32401 & (64));
var inst_32403 = inst_32394.cljs$core$ISeq$;
var inst_32404 = (inst_32402) || (inst_32403);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32404)){
var statearr_32484_32542 = state_32464__$1;
(statearr_32484_32542[(1)] = (16));

} else {
var statearr_32485_32543 = state_32464__$1;
(statearr_32485_32543[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (22))){
var inst_32424 = (state_32464[(9)]);
var inst_32423 = (state_32464[(14)]);
var inst_32422 = (state_32464[(2)]);
var inst_32423__$1 = cljs.core.nth.call(null,inst_32422,(0),null);
var inst_32424__$1 = cljs.core.nth.call(null,inst_32422,(1),null);
var inst_32425 = (inst_32423__$1 == null);
var inst_32426 = cljs.core._EQ_.call(null,inst_32424__$1,change);
var inst_32427 = (inst_32425) || (inst_32426);
var state_32464__$1 = (function (){var statearr_32486 = state_32464;
(statearr_32486[(9)] = inst_32424__$1);

(statearr_32486[(14)] = inst_32423__$1);

return statearr_32486;
})();
if(cljs.core.truth_(inst_32427)){
var statearr_32487_32544 = state_32464__$1;
(statearr_32487_32544[(1)] = (23));

} else {
var statearr_32488_32545 = state_32464__$1;
(statearr_32488_32545[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (36))){
var inst_32416 = (state_32464[(12)]);
var inst_32394 = inst_32416;
var state_32464__$1 = (function (){var statearr_32489 = state_32464;
(statearr_32489[(7)] = inst_32394);

return statearr_32489;
})();
var statearr_32490_32546 = state_32464__$1;
(statearr_32490_32546[(2)] = null);

(statearr_32490_32546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (29))){
var inst_32438 = (state_32464[(11)]);
var state_32464__$1 = state_32464;
var statearr_32491_32547 = state_32464__$1;
(statearr_32491_32547[(2)] = inst_32438);

(statearr_32491_32547[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (6))){
var state_32464__$1 = state_32464;
var statearr_32492_32548 = state_32464__$1;
(statearr_32492_32548[(2)] = false);

(statearr_32492_32548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (28))){
var inst_32434 = (state_32464[(2)]);
var inst_32435 = calc_state.call(null);
var inst_32394 = inst_32435;
var state_32464__$1 = (function (){var statearr_32493 = state_32464;
(statearr_32493[(15)] = inst_32434);

(statearr_32493[(7)] = inst_32394);

return statearr_32493;
})();
var statearr_32494_32549 = state_32464__$1;
(statearr_32494_32549[(2)] = null);

(statearr_32494_32549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (25))){
var inst_32460 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
var statearr_32495_32550 = state_32464__$1;
(statearr_32495_32550[(2)] = inst_32460);

(statearr_32495_32550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (34))){
var inst_32458 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
var statearr_32496_32551 = state_32464__$1;
(statearr_32496_32551[(2)] = inst_32458);

(statearr_32496_32551[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (17))){
var state_32464__$1 = state_32464;
var statearr_32497_32552 = state_32464__$1;
(statearr_32497_32552[(2)] = false);

(statearr_32497_32552[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (3))){
var state_32464__$1 = state_32464;
var statearr_32498_32553 = state_32464__$1;
(statearr_32498_32553[(2)] = false);

(statearr_32498_32553[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (12))){
var inst_32462 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32464__$1,inst_32462);
} else {
if((state_val_32465 === (2))){
var inst_32370 = (state_32464[(8)]);
var inst_32375 = inst_32370.cljs$lang$protocol_mask$partition0$;
var inst_32376 = (inst_32375 & (64));
var inst_32377 = inst_32370.cljs$core$ISeq$;
var inst_32378 = (inst_32376) || (inst_32377);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32378)){
var statearr_32499_32554 = state_32464__$1;
(statearr_32499_32554[(1)] = (5));

} else {
var statearr_32500_32555 = state_32464__$1;
(statearr_32500_32555[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (23))){
var inst_32423 = (state_32464[(14)]);
var inst_32429 = (inst_32423 == null);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32429)){
var statearr_32501_32556 = state_32464__$1;
(statearr_32501_32556[(1)] = (26));

} else {
var statearr_32502_32557 = state_32464__$1;
(statearr_32502_32557[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (35))){
var inst_32449 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
if(cljs.core.truth_(inst_32449)){
var statearr_32503_32558 = state_32464__$1;
(statearr_32503_32558[(1)] = (36));

} else {
var statearr_32504_32559 = state_32464__$1;
(statearr_32504_32559[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (19))){
var inst_32394 = (state_32464[(7)]);
var inst_32413 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32394);
var state_32464__$1 = state_32464;
var statearr_32505_32560 = state_32464__$1;
(statearr_32505_32560[(2)] = inst_32413);

(statearr_32505_32560[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (11))){
var inst_32394 = (state_32464[(7)]);
var inst_32398 = (inst_32394 == null);
var inst_32399 = cljs.core.not.call(null,inst_32398);
var state_32464__$1 = state_32464;
if(inst_32399){
var statearr_32506_32561 = state_32464__$1;
(statearr_32506_32561[(1)] = (13));

} else {
var statearr_32507_32562 = state_32464__$1;
(statearr_32507_32562[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (9))){
var inst_32370 = (state_32464[(8)]);
var state_32464__$1 = state_32464;
var statearr_32508_32563 = state_32464__$1;
(statearr_32508_32563[(2)] = inst_32370);

(statearr_32508_32563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (5))){
var state_32464__$1 = state_32464;
var statearr_32509_32564 = state_32464__$1;
(statearr_32509_32564[(2)] = true);

(statearr_32509_32564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (14))){
var state_32464__$1 = state_32464;
var statearr_32510_32565 = state_32464__$1;
(statearr_32510_32565[(2)] = false);

(statearr_32510_32565[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (26))){
var inst_32424 = (state_32464[(9)]);
var inst_32431 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_32424);
var state_32464__$1 = state_32464;
var statearr_32511_32566 = state_32464__$1;
(statearr_32511_32566[(2)] = inst_32431);

(statearr_32511_32566[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (16))){
var state_32464__$1 = state_32464;
var statearr_32512_32567 = state_32464__$1;
(statearr_32512_32567[(2)] = true);

(statearr_32512_32567[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (38))){
var inst_32454 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
var statearr_32513_32568 = state_32464__$1;
(statearr_32513_32568[(2)] = inst_32454);

(statearr_32513_32568[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (30))){
var inst_32424 = (state_32464[(9)]);
var inst_32417 = (state_32464[(10)]);
var inst_32418 = (state_32464[(13)]);
var inst_32441 = cljs.core.empty_QMARK_.call(null,inst_32417);
var inst_32442 = inst_32418.call(null,inst_32424);
var inst_32443 = cljs.core.not.call(null,inst_32442);
var inst_32444 = (inst_32441) && (inst_32443);
var state_32464__$1 = state_32464;
var statearr_32514_32569 = state_32464__$1;
(statearr_32514_32569[(2)] = inst_32444);

(statearr_32514_32569[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (10))){
var inst_32370 = (state_32464[(8)]);
var inst_32390 = (state_32464[(2)]);
var inst_32391 = cljs.core.get.call(null,inst_32390,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32392 = cljs.core.get.call(null,inst_32390,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32393 = cljs.core.get.call(null,inst_32390,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32394 = inst_32370;
var state_32464__$1 = (function (){var statearr_32515 = state_32464;
(statearr_32515[(7)] = inst_32394);

(statearr_32515[(16)] = inst_32393);

(statearr_32515[(17)] = inst_32391);

(statearr_32515[(18)] = inst_32392);

return statearr_32515;
})();
var statearr_32516_32570 = state_32464__$1;
(statearr_32516_32570[(2)] = null);

(statearr_32516_32570[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (18))){
var inst_32408 = (state_32464[(2)]);
var state_32464__$1 = state_32464;
var statearr_32517_32571 = state_32464__$1;
(statearr_32517_32571[(2)] = inst_32408);

(statearr_32517_32571[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (37))){
var state_32464__$1 = state_32464;
var statearr_32518_32572 = state_32464__$1;
(statearr_32518_32572[(2)] = null);

(statearr_32518_32572[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32465 === (8))){
var inst_32370 = (state_32464[(8)]);
var inst_32387 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32370);
var state_32464__$1 = state_32464;
var statearr_32519_32573 = state_32464__$1;
(statearr_32519_32573[(2)] = inst_32387);

(statearr_32519_32573[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___32527,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30702__auto__,c__30814__auto___32527,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30703__auto__ = null;
var cljs$core$async$mix_$_state_machine__30703__auto____0 = (function (){
var statearr_32523 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32523[(0)] = cljs$core$async$mix_$_state_machine__30703__auto__);

(statearr_32523[(1)] = (1));

return statearr_32523;
});
var cljs$core$async$mix_$_state_machine__30703__auto____1 = (function (state_32464){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_32464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e32524){if((e32524 instanceof Object)){
var ex__30706__auto__ = e32524;
var statearr_32525_32574 = state_32464;
(statearr_32525_32574[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32524;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32575 = state_32464;
state_32464 = G__32575;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30703__auto__ = function(state_32464){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30703__auto____1.call(this,state_32464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30703__auto____0;
cljs$core$async$mix_$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30703__auto____1;
return cljs$core$async$mix_$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___32527,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30816__auto__ = (function (){var statearr_32526 = f__30815__auto__.call(null);
(statearr_32526[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___32527);

return statearr_32526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___32527,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29359__auto__ = (((p == null))?null:p);
var m__29360__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29360__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29359__auto__ = (((p == null))?null:p);
var m__29360__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,p,v,ch);
} else {
var m__29360__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args32576 = [];
var len__29766__auto___32579 = arguments.length;
var i__29767__auto___32580 = (0);
while(true){
if((i__29767__auto___32580 < len__29766__auto___32579)){
args32576.push((arguments[i__29767__auto___32580]));

var G__32581 = (i__29767__auto___32580 + (1));
i__29767__auto___32580 = G__32581;
continue;
} else {
}
break;
}

var G__32578 = args32576.length;
switch (G__32578) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32576.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29359__auto__ = (((p == null))?null:p);
var m__29360__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,p);
} else {
var m__29360__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29359__auto__ = (((p == null))?null:p);
var m__29360__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29359__auto__)]);
if(!((m__29360__auto__ == null))){
return m__29360__auto__.call(null,p,v);
} else {
var m__29360__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29360__auto____$1 == null))){
return m__29360__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args32584 = [];
var len__29766__auto___32709 = arguments.length;
var i__29767__auto___32710 = (0);
while(true){
if((i__29767__auto___32710 < len__29766__auto___32709)){
args32584.push((arguments[i__29767__auto___32710]));

var G__32711 = (i__29767__auto___32710 + (1));
i__29767__auto___32710 = G__32711;
continue;
} else {
}
break;
}

var G__32586 = args32584.length;
switch (G__32586) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32584.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28696__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28696__auto__)){
return or__28696__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28696__auto__,mults){
return (function (p1__32583_SHARP_){
if(cljs.core.truth_(p1__32583_SHARP_.call(null,topic))){
return p1__32583_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32583_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28696__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32587 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32587 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32588){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32588 = meta32588;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32589,meta32588__$1){
var self__ = this;
var _32589__$1 = this;
return (new cljs.core.async.t_cljs$core$async32587(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32588__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32589){
var self__ = this;
var _32589__$1 = this;
return self__.meta32588;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32588","meta32588",-1751436326,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32587.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32587.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32587";

cljs.core.async.t_cljs$core$async32587.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async32587");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32587 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32587(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32588){
return (new cljs.core.async.t_cljs$core$async32587(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32588));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32587(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30814__auto___32713 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___32713,mults,ensure_mult,p){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___32713,mults,ensure_mult,p){
return (function (state_32661){
var state_val_32662 = (state_32661[(1)]);
if((state_val_32662 === (7))){
var inst_32657 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
var statearr_32663_32714 = state_32661__$1;
(statearr_32663_32714[(2)] = inst_32657);

(statearr_32663_32714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (20))){
var state_32661__$1 = state_32661;
var statearr_32664_32715 = state_32661__$1;
(statearr_32664_32715[(2)] = null);

(statearr_32664_32715[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (1))){
var state_32661__$1 = state_32661;
var statearr_32665_32716 = state_32661__$1;
(statearr_32665_32716[(2)] = null);

(statearr_32665_32716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (24))){
var inst_32640 = (state_32661[(7)]);
var inst_32649 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32640);
var state_32661__$1 = state_32661;
var statearr_32666_32717 = state_32661__$1;
(statearr_32666_32717[(2)] = inst_32649);

(statearr_32666_32717[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (4))){
var inst_32592 = (state_32661[(8)]);
var inst_32592__$1 = (state_32661[(2)]);
var inst_32593 = (inst_32592__$1 == null);
var state_32661__$1 = (function (){var statearr_32667 = state_32661;
(statearr_32667[(8)] = inst_32592__$1);

return statearr_32667;
})();
if(cljs.core.truth_(inst_32593)){
var statearr_32668_32718 = state_32661__$1;
(statearr_32668_32718[(1)] = (5));

} else {
var statearr_32669_32719 = state_32661__$1;
(statearr_32669_32719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (15))){
var inst_32634 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
var statearr_32670_32720 = state_32661__$1;
(statearr_32670_32720[(2)] = inst_32634);

(statearr_32670_32720[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (21))){
var inst_32654 = (state_32661[(2)]);
var state_32661__$1 = (function (){var statearr_32671 = state_32661;
(statearr_32671[(9)] = inst_32654);

return statearr_32671;
})();
var statearr_32672_32721 = state_32661__$1;
(statearr_32672_32721[(2)] = null);

(statearr_32672_32721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (13))){
var inst_32616 = (state_32661[(10)]);
var inst_32618 = cljs.core.chunked_seq_QMARK_.call(null,inst_32616);
var state_32661__$1 = state_32661;
if(inst_32618){
var statearr_32673_32722 = state_32661__$1;
(statearr_32673_32722[(1)] = (16));

} else {
var statearr_32674_32723 = state_32661__$1;
(statearr_32674_32723[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (22))){
var inst_32646 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
if(cljs.core.truth_(inst_32646)){
var statearr_32675_32724 = state_32661__$1;
(statearr_32675_32724[(1)] = (23));

} else {
var statearr_32676_32725 = state_32661__$1;
(statearr_32676_32725[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (6))){
var inst_32642 = (state_32661[(11)]);
var inst_32592 = (state_32661[(8)]);
var inst_32640 = (state_32661[(7)]);
var inst_32640__$1 = topic_fn.call(null,inst_32592);
var inst_32641 = cljs.core.deref.call(null,mults);
var inst_32642__$1 = cljs.core.get.call(null,inst_32641,inst_32640__$1);
var state_32661__$1 = (function (){var statearr_32677 = state_32661;
(statearr_32677[(11)] = inst_32642__$1);

(statearr_32677[(7)] = inst_32640__$1);

return statearr_32677;
})();
if(cljs.core.truth_(inst_32642__$1)){
var statearr_32678_32726 = state_32661__$1;
(statearr_32678_32726[(1)] = (19));

} else {
var statearr_32679_32727 = state_32661__$1;
(statearr_32679_32727[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (25))){
var inst_32651 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
var statearr_32680_32728 = state_32661__$1;
(statearr_32680_32728[(2)] = inst_32651);

(statearr_32680_32728[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (17))){
var inst_32616 = (state_32661[(10)]);
var inst_32625 = cljs.core.first.call(null,inst_32616);
var inst_32626 = cljs.core.async.muxch_STAR_.call(null,inst_32625);
var inst_32627 = cljs.core.async.close_BANG_.call(null,inst_32626);
var inst_32628 = cljs.core.next.call(null,inst_32616);
var inst_32602 = inst_32628;
var inst_32603 = null;
var inst_32604 = (0);
var inst_32605 = (0);
var state_32661__$1 = (function (){var statearr_32681 = state_32661;
(statearr_32681[(12)] = inst_32604);

(statearr_32681[(13)] = inst_32627);

(statearr_32681[(14)] = inst_32603);

(statearr_32681[(15)] = inst_32602);

(statearr_32681[(16)] = inst_32605);

return statearr_32681;
})();
var statearr_32682_32729 = state_32661__$1;
(statearr_32682_32729[(2)] = null);

(statearr_32682_32729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (3))){
var inst_32659 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32661__$1,inst_32659);
} else {
if((state_val_32662 === (12))){
var inst_32636 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
var statearr_32683_32730 = state_32661__$1;
(statearr_32683_32730[(2)] = inst_32636);

(statearr_32683_32730[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (2))){
var state_32661__$1 = state_32661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32661__$1,(4),ch);
} else {
if((state_val_32662 === (23))){
var state_32661__$1 = state_32661;
var statearr_32684_32731 = state_32661__$1;
(statearr_32684_32731[(2)] = null);

(statearr_32684_32731[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (19))){
var inst_32642 = (state_32661[(11)]);
var inst_32592 = (state_32661[(8)]);
var inst_32644 = cljs.core.async.muxch_STAR_.call(null,inst_32642);
var state_32661__$1 = state_32661;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32661__$1,(22),inst_32644,inst_32592);
} else {
if((state_val_32662 === (11))){
var inst_32616 = (state_32661[(10)]);
var inst_32602 = (state_32661[(15)]);
var inst_32616__$1 = cljs.core.seq.call(null,inst_32602);
var state_32661__$1 = (function (){var statearr_32685 = state_32661;
(statearr_32685[(10)] = inst_32616__$1);

return statearr_32685;
})();
if(inst_32616__$1){
var statearr_32686_32732 = state_32661__$1;
(statearr_32686_32732[(1)] = (13));

} else {
var statearr_32687_32733 = state_32661__$1;
(statearr_32687_32733[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (9))){
var inst_32638 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
var statearr_32688_32734 = state_32661__$1;
(statearr_32688_32734[(2)] = inst_32638);

(statearr_32688_32734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (5))){
var inst_32599 = cljs.core.deref.call(null,mults);
var inst_32600 = cljs.core.vals.call(null,inst_32599);
var inst_32601 = cljs.core.seq.call(null,inst_32600);
var inst_32602 = inst_32601;
var inst_32603 = null;
var inst_32604 = (0);
var inst_32605 = (0);
var state_32661__$1 = (function (){var statearr_32689 = state_32661;
(statearr_32689[(12)] = inst_32604);

(statearr_32689[(14)] = inst_32603);

(statearr_32689[(15)] = inst_32602);

(statearr_32689[(16)] = inst_32605);

return statearr_32689;
})();
var statearr_32690_32735 = state_32661__$1;
(statearr_32690_32735[(2)] = null);

(statearr_32690_32735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (14))){
var state_32661__$1 = state_32661;
var statearr_32694_32736 = state_32661__$1;
(statearr_32694_32736[(2)] = null);

(statearr_32694_32736[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (16))){
var inst_32616 = (state_32661[(10)]);
var inst_32620 = cljs.core.chunk_first.call(null,inst_32616);
var inst_32621 = cljs.core.chunk_rest.call(null,inst_32616);
var inst_32622 = cljs.core.count.call(null,inst_32620);
var inst_32602 = inst_32621;
var inst_32603 = inst_32620;
var inst_32604 = inst_32622;
var inst_32605 = (0);
var state_32661__$1 = (function (){var statearr_32695 = state_32661;
(statearr_32695[(12)] = inst_32604);

(statearr_32695[(14)] = inst_32603);

(statearr_32695[(15)] = inst_32602);

(statearr_32695[(16)] = inst_32605);

return statearr_32695;
})();
var statearr_32696_32737 = state_32661__$1;
(statearr_32696_32737[(2)] = null);

(statearr_32696_32737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (10))){
var inst_32604 = (state_32661[(12)]);
var inst_32603 = (state_32661[(14)]);
var inst_32602 = (state_32661[(15)]);
var inst_32605 = (state_32661[(16)]);
var inst_32610 = cljs.core._nth.call(null,inst_32603,inst_32605);
var inst_32611 = cljs.core.async.muxch_STAR_.call(null,inst_32610);
var inst_32612 = cljs.core.async.close_BANG_.call(null,inst_32611);
var inst_32613 = (inst_32605 + (1));
var tmp32691 = inst_32604;
var tmp32692 = inst_32603;
var tmp32693 = inst_32602;
var inst_32602__$1 = tmp32693;
var inst_32603__$1 = tmp32692;
var inst_32604__$1 = tmp32691;
var inst_32605__$1 = inst_32613;
var state_32661__$1 = (function (){var statearr_32697 = state_32661;
(statearr_32697[(12)] = inst_32604__$1);

(statearr_32697[(14)] = inst_32603__$1);

(statearr_32697[(15)] = inst_32602__$1);

(statearr_32697[(16)] = inst_32605__$1);

(statearr_32697[(17)] = inst_32612);

return statearr_32697;
})();
var statearr_32698_32738 = state_32661__$1;
(statearr_32698_32738[(2)] = null);

(statearr_32698_32738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (18))){
var inst_32631 = (state_32661[(2)]);
var state_32661__$1 = state_32661;
var statearr_32699_32739 = state_32661__$1;
(statearr_32699_32739[(2)] = inst_32631);

(statearr_32699_32739[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32662 === (8))){
var inst_32604 = (state_32661[(12)]);
var inst_32605 = (state_32661[(16)]);
var inst_32607 = (inst_32605 < inst_32604);
var inst_32608 = inst_32607;
var state_32661__$1 = state_32661;
if(cljs.core.truth_(inst_32608)){
var statearr_32700_32740 = state_32661__$1;
(statearr_32700_32740[(1)] = (10));

} else {
var statearr_32701_32741 = state_32661__$1;
(statearr_32701_32741[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___32713,mults,ensure_mult,p))
;
return ((function (switch__30702__auto__,c__30814__auto___32713,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_32705 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32705[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_32705[(1)] = (1));

return statearr_32705;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_32661){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_32661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e32706){if((e32706 instanceof Object)){
var ex__30706__auto__ = e32706;
var statearr_32707_32742 = state_32661;
(statearr_32707_32742[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32661);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32706;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32743 = state_32661;
state_32661 = G__32743;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_32661){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_32661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___32713,mults,ensure_mult,p))
})();
var state__30816__auto__ = (function (){var statearr_32708 = f__30815__auto__.call(null);
(statearr_32708[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___32713);

return statearr_32708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___32713,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args32744 = [];
var len__29766__auto___32747 = arguments.length;
var i__29767__auto___32748 = (0);
while(true){
if((i__29767__auto___32748 < len__29766__auto___32747)){
args32744.push((arguments[i__29767__auto___32748]));

var G__32749 = (i__29767__auto___32748 + (1));
i__29767__auto___32748 = G__32749;
continue;
} else {
}
break;
}

var G__32746 = args32744.length;
switch (G__32746) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32744.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args32751 = [];
var len__29766__auto___32754 = arguments.length;
var i__29767__auto___32755 = (0);
while(true){
if((i__29767__auto___32755 < len__29766__auto___32754)){
args32751.push((arguments[i__29767__auto___32755]));

var G__32756 = (i__29767__auto___32755 + (1));
i__29767__auto___32755 = G__32756;
continue;
} else {
}
break;
}

var G__32753 = args32751.length;
switch (G__32753) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32751.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args32758 = [];
var len__29766__auto___32829 = arguments.length;
var i__29767__auto___32830 = (0);
while(true){
if((i__29767__auto___32830 < len__29766__auto___32829)){
args32758.push((arguments[i__29767__auto___32830]));

var G__32831 = (i__29767__auto___32830 + (1));
i__29767__auto___32830 = G__32831;
continue;
} else {
}
break;
}

var G__32760 = args32758.length;
switch (G__32760) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32758.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30814__auto___32833 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___32833,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___32833,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32799){
var state_val_32800 = (state_32799[(1)]);
if((state_val_32800 === (7))){
var state_32799__$1 = state_32799;
var statearr_32801_32834 = state_32799__$1;
(statearr_32801_32834[(2)] = null);

(statearr_32801_32834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (1))){
var state_32799__$1 = state_32799;
var statearr_32802_32835 = state_32799__$1;
(statearr_32802_32835[(2)] = null);

(statearr_32802_32835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (4))){
var inst_32763 = (state_32799[(7)]);
var inst_32765 = (inst_32763 < cnt);
var state_32799__$1 = state_32799;
if(cljs.core.truth_(inst_32765)){
var statearr_32803_32836 = state_32799__$1;
(statearr_32803_32836[(1)] = (6));

} else {
var statearr_32804_32837 = state_32799__$1;
(statearr_32804_32837[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (15))){
var inst_32795 = (state_32799[(2)]);
var state_32799__$1 = state_32799;
var statearr_32805_32838 = state_32799__$1;
(statearr_32805_32838[(2)] = inst_32795);

(statearr_32805_32838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (13))){
var inst_32788 = cljs.core.async.close_BANG_.call(null,out);
var state_32799__$1 = state_32799;
var statearr_32806_32839 = state_32799__$1;
(statearr_32806_32839[(2)] = inst_32788);

(statearr_32806_32839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (6))){
var state_32799__$1 = state_32799;
var statearr_32807_32840 = state_32799__$1;
(statearr_32807_32840[(2)] = null);

(statearr_32807_32840[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (3))){
var inst_32797 = (state_32799[(2)]);
var state_32799__$1 = state_32799;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32799__$1,inst_32797);
} else {
if((state_val_32800 === (12))){
var inst_32785 = (state_32799[(8)]);
var inst_32785__$1 = (state_32799[(2)]);
var inst_32786 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32785__$1);
var state_32799__$1 = (function (){var statearr_32808 = state_32799;
(statearr_32808[(8)] = inst_32785__$1);

return statearr_32808;
})();
if(cljs.core.truth_(inst_32786)){
var statearr_32809_32841 = state_32799__$1;
(statearr_32809_32841[(1)] = (13));

} else {
var statearr_32810_32842 = state_32799__$1;
(statearr_32810_32842[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (2))){
var inst_32762 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32763 = (0);
var state_32799__$1 = (function (){var statearr_32811 = state_32799;
(statearr_32811[(7)] = inst_32763);

(statearr_32811[(9)] = inst_32762);

return statearr_32811;
})();
var statearr_32812_32843 = state_32799__$1;
(statearr_32812_32843[(2)] = null);

(statearr_32812_32843[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (11))){
var inst_32763 = (state_32799[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32799,(10),Object,null,(9));
var inst_32772 = chs__$1.call(null,inst_32763);
var inst_32773 = done.call(null,inst_32763);
var inst_32774 = cljs.core.async.take_BANG_.call(null,inst_32772,inst_32773);
var state_32799__$1 = state_32799;
var statearr_32813_32844 = state_32799__$1;
(statearr_32813_32844[(2)] = inst_32774);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32799__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (9))){
var inst_32763 = (state_32799[(7)]);
var inst_32776 = (state_32799[(2)]);
var inst_32777 = (inst_32763 + (1));
var inst_32763__$1 = inst_32777;
var state_32799__$1 = (function (){var statearr_32814 = state_32799;
(statearr_32814[(7)] = inst_32763__$1);

(statearr_32814[(10)] = inst_32776);

return statearr_32814;
})();
var statearr_32815_32845 = state_32799__$1;
(statearr_32815_32845[(2)] = null);

(statearr_32815_32845[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (5))){
var inst_32783 = (state_32799[(2)]);
var state_32799__$1 = (function (){var statearr_32816 = state_32799;
(statearr_32816[(11)] = inst_32783);

return statearr_32816;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32799__$1,(12),dchan);
} else {
if((state_val_32800 === (14))){
var inst_32785 = (state_32799[(8)]);
var inst_32790 = cljs.core.apply.call(null,f,inst_32785);
var state_32799__$1 = state_32799;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32799__$1,(16),out,inst_32790);
} else {
if((state_val_32800 === (16))){
var inst_32792 = (state_32799[(2)]);
var state_32799__$1 = (function (){var statearr_32817 = state_32799;
(statearr_32817[(12)] = inst_32792);

return statearr_32817;
})();
var statearr_32818_32846 = state_32799__$1;
(statearr_32818_32846[(2)] = null);

(statearr_32818_32846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (10))){
var inst_32767 = (state_32799[(2)]);
var inst_32768 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32799__$1 = (function (){var statearr_32819 = state_32799;
(statearr_32819[(13)] = inst_32767);

return statearr_32819;
})();
var statearr_32820_32847 = state_32799__$1;
(statearr_32820_32847[(2)] = inst_32768);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32799__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32800 === (8))){
var inst_32781 = (state_32799[(2)]);
var state_32799__$1 = state_32799;
var statearr_32821_32848 = state_32799__$1;
(statearr_32821_32848[(2)] = inst_32781);

(statearr_32821_32848[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___32833,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30702__auto__,c__30814__auto___32833,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_32825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32825[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_32825[(1)] = (1));

return statearr_32825;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_32799){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_32799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e32826){if((e32826 instanceof Object)){
var ex__30706__auto__ = e32826;
var statearr_32827_32849 = state_32799;
(statearr_32827_32849[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32799);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32826;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32850 = state_32799;
state_32799 = G__32850;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_32799){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_32799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___32833,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30816__auto__ = (function (){var statearr_32828 = f__30815__auto__.call(null);
(statearr_32828[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___32833);

return statearr_32828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___32833,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args32852 = [];
var len__29766__auto___32908 = arguments.length;
var i__29767__auto___32909 = (0);
while(true){
if((i__29767__auto___32909 < len__29766__auto___32908)){
args32852.push((arguments[i__29767__auto___32909]));

var G__32910 = (i__29767__auto___32909 + (1));
i__29767__auto___32909 = G__32910;
continue;
} else {
}
break;
}

var G__32854 = args32852.length;
switch (G__32854) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32852.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30814__auto___32912 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___32912,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___32912,out){
return (function (state_32884){
var state_val_32885 = (state_32884[(1)]);
if((state_val_32885 === (7))){
var inst_32864 = (state_32884[(7)]);
var inst_32863 = (state_32884[(8)]);
var inst_32863__$1 = (state_32884[(2)]);
var inst_32864__$1 = cljs.core.nth.call(null,inst_32863__$1,(0),null);
var inst_32865 = cljs.core.nth.call(null,inst_32863__$1,(1),null);
var inst_32866 = (inst_32864__$1 == null);
var state_32884__$1 = (function (){var statearr_32886 = state_32884;
(statearr_32886[(7)] = inst_32864__$1);

(statearr_32886[(8)] = inst_32863__$1);

(statearr_32886[(9)] = inst_32865);

return statearr_32886;
})();
if(cljs.core.truth_(inst_32866)){
var statearr_32887_32913 = state_32884__$1;
(statearr_32887_32913[(1)] = (8));

} else {
var statearr_32888_32914 = state_32884__$1;
(statearr_32888_32914[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (1))){
var inst_32855 = cljs.core.vec.call(null,chs);
var inst_32856 = inst_32855;
var state_32884__$1 = (function (){var statearr_32889 = state_32884;
(statearr_32889[(10)] = inst_32856);

return statearr_32889;
})();
var statearr_32890_32915 = state_32884__$1;
(statearr_32890_32915[(2)] = null);

(statearr_32890_32915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (4))){
var inst_32856 = (state_32884[(10)]);
var state_32884__$1 = state_32884;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32884__$1,(7),inst_32856);
} else {
if((state_val_32885 === (6))){
var inst_32880 = (state_32884[(2)]);
var state_32884__$1 = state_32884;
var statearr_32891_32916 = state_32884__$1;
(statearr_32891_32916[(2)] = inst_32880);

(statearr_32891_32916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (3))){
var inst_32882 = (state_32884[(2)]);
var state_32884__$1 = state_32884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32884__$1,inst_32882);
} else {
if((state_val_32885 === (2))){
var inst_32856 = (state_32884[(10)]);
var inst_32858 = cljs.core.count.call(null,inst_32856);
var inst_32859 = (inst_32858 > (0));
var state_32884__$1 = state_32884;
if(cljs.core.truth_(inst_32859)){
var statearr_32893_32917 = state_32884__$1;
(statearr_32893_32917[(1)] = (4));

} else {
var statearr_32894_32918 = state_32884__$1;
(statearr_32894_32918[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (11))){
var inst_32856 = (state_32884[(10)]);
var inst_32873 = (state_32884[(2)]);
var tmp32892 = inst_32856;
var inst_32856__$1 = tmp32892;
var state_32884__$1 = (function (){var statearr_32895 = state_32884;
(statearr_32895[(10)] = inst_32856__$1);

(statearr_32895[(11)] = inst_32873);

return statearr_32895;
})();
var statearr_32896_32919 = state_32884__$1;
(statearr_32896_32919[(2)] = null);

(statearr_32896_32919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (9))){
var inst_32864 = (state_32884[(7)]);
var state_32884__$1 = state_32884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32884__$1,(11),out,inst_32864);
} else {
if((state_val_32885 === (5))){
var inst_32878 = cljs.core.async.close_BANG_.call(null,out);
var state_32884__$1 = state_32884;
var statearr_32897_32920 = state_32884__$1;
(statearr_32897_32920[(2)] = inst_32878);

(statearr_32897_32920[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (10))){
var inst_32876 = (state_32884[(2)]);
var state_32884__$1 = state_32884;
var statearr_32898_32921 = state_32884__$1;
(statearr_32898_32921[(2)] = inst_32876);

(statearr_32898_32921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32885 === (8))){
var inst_32864 = (state_32884[(7)]);
var inst_32856 = (state_32884[(10)]);
var inst_32863 = (state_32884[(8)]);
var inst_32865 = (state_32884[(9)]);
var inst_32868 = (function (){var cs = inst_32856;
var vec__32861 = inst_32863;
var v = inst_32864;
var c = inst_32865;
return ((function (cs,vec__32861,v,c,inst_32864,inst_32856,inst_32863,inst_32865,state_val_32885,c__30814__auto___32912,out){
return (function (p1__32851_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32851_SHARP_);
});
;})(cs,vec__32861,v,c,inst_32864,inst_32856,inst_32863,inst_32865,state_val_32885,c__30814__auto___32912,out))
})();
var inst_32869 = cljs.core.filterv.call(null,inst_32868,inst_32856);
var inst_32856__$1 = inst_32869;
var state_32884__$1 = (function (){var statearr_32899 = state_32884;
(statearr_32899[(10)] = inst_32856__$1);

return statearr_32899;
})();
var statearr_32900_32922 = state_32884__$1;
(statearr_32900_32922[(2)] = null);

(statearr_32900_32922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___32912,out))
;
return ((function (switch__30702__auto__,c__30814__auto___32912,out){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_32904 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32904[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_32904[(1)] = (1));

return statearr_32904;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_32884){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_32884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e32905){if((e32905 instanceof Object)){
var ex__30706__auto__ = e32905;
var statearr_32906_32923 = state_32884;
(statearr_32906_32923[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32905;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32924 = state_32884;
state_32884 = G__32924;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_32884){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_32884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___32912,out))
})();
var state__30816__auto__ = (function (){var statearr_32907 = f__30815__auto__.call(null);
(statearr_32907[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___32912);

return statearr_32907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___32912,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args32925 = [];
var len__29766__auto___32974 = arguments.length;
var i__29767__auto___32975 = (0);
while(true){
if((i__29767__auto___32975 < len__29766__auto___32974)){
args32925.push((arguments[i__29767__auto___32975]));

var G__32976 = (i__29767__auto___32975 + (1));
i__29767__auto___32975 = G__32976;
continue;
} else {
}
break;
}

var G__32927 = args32925.length;
switch (G__32927) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32925.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30814__auto___32978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___32978,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___32978,out){
return (function (state_32951){
var state_val_32952 = (state_32951[(1)]);
if((state_val_32952 === (7))){
var inst_32933 = (state_32951[(7)]);
var inst_32933__$1 = (state_32951[(2)]);
var inst_32934 = (inst_32933__$1 == null);
var inst_32935 = cljs.core.not.call(null,inst_32934);
var state_32951__$1 = (function (){var statearr_32953 = state_32951;
(statearr_32953[(7)] = inst_32933__$1);

return statearr_32953;
})();
if(inst_32935){
var statearr_32954_32979 = state_32951__$1;
(statearr_32954_32979[(1)] = (8));

} else {
var statearr_32955_32980 = state_32951__$1;
(statearr_32955_32980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (1))){
var inst_32928 = (0);
var state_32951__$1 = (function (){var statearr_32956 = state_32951;
(statearr_32956[(8)] = inst_32928);

return statearr_32956;
})();
var statearr_32957_32981 = state_32951__$1;
(statearr_32957_32981[(2)] = null);

(statearr_32957_32981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (4))){
var state_32951__$1 = state_32951;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32951__$1,(7),ch);
} else {
if((state_val_32952 === (6))){
var inst_32946 = (state_32951[(2)]);
var state_32951__$1 = state_32951;
var statearr_32958_32982 = state_32951__$1;
(statearr_32958_32982[(2)] = inst_32946);

(statearr_32958_32982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (3))){
var inst_32948 = (state_32951[(2)]);
var inst_32949 = cljs.core.async.close_BANG_.call(null,out);
var state_32951__$1 = (function (){var statearr_32959 = state_32951;
(statearr_32959[(9)] = inst_32948);

return statearr_32959;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32951__$1,inst_32949);
} else {
if((state_val_32952 === (2))){
var inst_32928 = (state_32951[(8)]);
var inst_32930 = (inst_32928 < n);
var state_32951__$1 = state_32951;
if(cljs.core.truth_(inst_32930)){
var statearr_32960_32983 = state_32951__$1;
(statearr_32960_32983[(1)] = (4));

} else {
var statearr_32961_32984 = state_32951__$1;
(statearr_32961_32984[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (11))){
var inst_32928 = (state_32951[(8)]);
var inst_32938 = (state_32951[(2)]);
var inst_32939 = (inst_32928 + (1));
var inst_32928__$1 = inst_32939;
var state_32951__$1 = (function (){var statearr_32962 = state_32951;
(statearr_32962[(10)] = inst_32938);

(statearr_32962[(8)] = inst_32928__$1);

return statearr_32962;
})();
var statearr_32963_32985 = state_32951__$1;
(statearr_32963_32985[(2)] = null);

(statearr_32963_32985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (9))){
var state_32951__$1 = state_32951;
var statearr_32964_32986 = state_32951__$1;
(statearr_32964_32986[(2)] = null);

(statearr_32964_32986[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (5))){
var state_32951__$1 = state_32951;
var statearr_32965_32987 = state_32951__$1;
(statearr_32965_32987[(2)] = null);

(statearr_32965_32987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (10))){
var inst_32943 = (state_32951[(2)]);
var state_32951__$1 = state_32951;
var statearr_32966_32988 = state_32951__$1;
(statearr_32966_32988[(2)] = inst_32943);

(statearr_32966_32988[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32952 === (8))){
var inst_32933 = (state_32951[(7)]);
var state_32951__$1 = state_32951;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32951__$1,(11),out,inst_32933);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___32978,out))
;
return ((function (switch__30702__auto__,c__30814__auto___32978,out){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_32970 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32970[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_32970[(1)] = (1));

return statearr_32970;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_32951){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_32951);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e32971){if((e32971 instanceof Object)){
var ex__30706__auto__ = e32971;
var statearr_32972_32989 = state_32951;
(statearr_32972_32989[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32951);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32971;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32990 = state_32951;
state_32951 = G__32990;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_32951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_32951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___32978,out))
})();
var state__30816__auto__ = (function (){var statearr_32973 = f__30815__auto__.call(null);
(statearr_32973[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___32978);

return statearr_32973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___32978,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32998 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32998 = (function (map_LT_,f,ch,meta32999){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32999 = meta32999;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33000,meta32999__$1){
var self__ = this;
var _33000__$1 = this;
return (new cljs.core.async.t_cljs$core$async32998(self__.map_LT_,self__.f,self__.ch,meta32999__$1));
});

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33000){
var self__ = this;
var _33000__$1 = this;
return self__.meta32999;
});

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33001 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33001 = (function (map_LT_,f,ch,meta32999,_,fn1,meta33002){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32999 = meta32999;
this._ = _;
this.fn1 = fn1;
this.meta33002 = meta33002;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33001.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33003,meta33002__$1){
var self__ = this;
var _33003__$1 = this;
return (new cljs.core.async.t_cljs$core$async33001(self__.map_LT_,self__.f,self__.ch,self__.meta32999,self__._,self__.fn1,meta33002__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33001.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33003){
var self__ = this;
var _33003__$1 = this;
return self__.meta33002;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33001.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33001.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33001.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33001.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32991_SHARP_){
return f1.call(null,(((p1__32991_SHARP_ == null))?null:self__.f.call(null,p1__32991_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33001.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32999","meta32999",-1821665903,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32998","cljs.core.async/t_cljs$core$async32998",-1588142196,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33002","meta33002",-2649914,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33001.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33001.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33001";

cljs.core.async.t_cljs$core$async33001.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async33001");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33001 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33001(map_LT___$1,f__$1,ch__$1,meta32999__$1,___$2,fn1__$1,meta33002){
return (new cljs.core.async.t_cljs$core$async33001(map_LT___$1,f__$1,ch__$1,meta32999__$1,___$2,fn1__$1,meta33002));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33001(self__.map_LT_,self__.f,self__.ch,self__.meta32999,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28684__auto__ = ret;
if(cljs.core.truth_(and__28684__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28684__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32998.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32998.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32999","meta32999",-1821665903,null)], null);
});

cljs.core.async.t_cljs$core$async32998.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32998.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32998";

cljs.core.async.t_cljs$core$async32998.cljs$lang$ctorPrWriter = (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async32998");
});

cljs.core.async.__GT_t_cljs$core$async32998 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32998(map_LT___$1,f__$1,ch__$1,meta32999){
return (new cljs.core.async.t_cljs$core$async32998(map_LT___$1,f__$1,ch__$1,meta32999));
});

}

return (new cljs.core.async.t_cljs$core$async32998(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33007 = (function (map_GT_,f,ch,meta33008){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta33008 = meta33008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33009,meta33008__$1){
var self__ = this;
var _33009__$1 = this;
return (new cljs.core.async.t_cljs$core$async33007(self__.map_GT_,self__.f,self__.ch,meta33008__$1));
});

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33009){
var self__ = this;
var _33009__$1 = this;
return self__.meta33008;
});

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33007.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async33007.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33008","meta33008",-1569820904,null)], null);
});

cljs.core.async.t_cljs$core$async33007.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33007.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33007";

cljs.core.async.t_cljs$core$async33007.cljs$lang$ctorPrWriter = (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async33007");
});

cljs.core.async.__GT_t_cljs$core$async33007 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33007(map_GT___$1,f__$1,ch__$1,meta33008){
return (new cljs.core.async.t_cljs$core$async33007(map_GT___$1,f__$1,ch__$1,meta33008));
});

}

return (new cljs.core.async.t_cljs$core$async33007(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33013 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33013 = (function (filter_GT_,p,ch,meta33014){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta33014 = meta33014;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33015,meta33014__$1){
var self__ = this;
var _33015__$1 = this;
return (new cljs.core.async.t_cljs$core$async33013(self__.filter_GT_,self__.p,self__.ch,meta33014__$1));
});

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33015){
var self__ = this;
var _33015__$1 = this;
return self__.meta33014;
});

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33013.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33013.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33014","meta33014",-1074791026,null)], null);
});

cljs.core.async.t_cljs$core$async33013.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33013.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33013";

cljs.core.async.t_cljs$core$async33013.cljs$lang$ctorPrWriter = (function (this__29302__auto__,writer__29303__auto__,opt__29304__auto__){
return cljs.core._write.call(null,writer__29303__auto__,"cljs.core.async/t_cljs$core$async33013");
});

cljs.core.async.__GT_t_cljs$core$async33013 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33013(filter_GT___$1,p__$1,ch__$1,meta33014){
return (new cljs.core.async.t_cljs$core$async33013(filter_GT___$1,p__$1,ch__$1,meta33014));
});

}

return (new cljs.core.async.t_cljs$core$async33013(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33016 = [];
var len__29766__auto___33060 = arguments.length;
var i__29767__auto___33061 = (0);
while(true){
if((i__29767__auto___33061 < len__29766__auto___33060)){
args33016.push((arguments[i__29767__auto___33061]));

var G__33062 = (i__29767__auto___33061 + (1));
i__29767__auto___33061 = G__33062;
continue;
} else {
}
break;
}

var G__33018 = args33016.length;
switch (G__33018) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33016.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30814__auto___33064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___33064,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___33064,out){
return (function (state_33039){
var state_val_33040 = (state_33039[(1)]);
if((state_val_33040 === (7))){
var inst_33035 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33041_33065 = state_33039__$1;
(statearr_33041_33065[(2)] = inst_33035);

(statearr_33041_33065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (1))){
var state_33039__$1 = state_33039;
var statearr_33042_33066 = state_33039__$1;
(statearr_33042_33066[(2)] = null);

(statearr_33042_33066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (4))){
var inst_33021 = (state_33039[(7)]);
var inst_33021__$1 = (state_33039[(2)]);
var inst_33022 = (inst_33021__$1 == null);
var state_33039__$1 = (function (){var statearr_33043 = state_33039;
(statearr_33043[(7)] = inst_33021__$1);

return statearr_33043;
})();
if(cljs.core.truth_(inst_33022)){
var statearr_33044_33067 = state_33039__$1;
(statearr_33044_33067[(1)] = (5));

} else {
var statearr_33045_33068 = state_33039__$1;
(statearr_33045_33068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (6))){
var inst_33021 = (state_33039[(7)]);
var inst_33026 = p.call(null,inst_33021);
var state_33039__$1 = state_33039;
if(cljs.core.truth_(inst_33026)){
var statearr_33046_33069 = state_33039__$1;
(statearr_33046_33069[(1)] = (8));

} else {
var statearr_33047_33070 = state_33039__$1;
(statearr_33047_33070[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (3))){
var inst_33037 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33039__$1,inst_33037);
} else {
if((state_val_33040 === (2))){
var state_33039__$1 = state_33039;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33039__$1,(4),ch);
} else {
if((state_val_33040 === (11))){
var inst_33029 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33048_33071 = state_33039__$1;
(statearr_33048_33071[(2)] = inst_33029);

(statearr_33048_33071[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (9))){
var state_33039__$1 = state_33039;
var statearr_33049_33072 = state_33039__$1;
(statearr_33049_33072[(2)] = null);

(statearr_33049_33072[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (5))){
var inst_33024 = cljs.core.async.close_BANG_.call(null,out);
var state_33039__$1 = state_33039;
var statearr_33050_33073 = state_33039__$1;
(statearr_33050_33073[(2)] = inst_33024);

(statearr_33050_33073[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (10))){
var inst_33032 = (state_33039[(2)]);
var state_33039__$1 = (function (){var statearr_33051 = state_33039;
(statearr_33051[(8)] = inst_33032);

return statearr_33051;
})();
var statearr_33052_33074 = state_33039__$1;
(statearr_33052_33074[(2)] = null);

(statearr_33052_33074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33040 === (8))){
var inst_33021 = (state_33039[(7)]);
var state_33039__$1 = state_33039;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33039__$1,(11),out,inst_33021);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___33064,out))
;
return ((function (switch__30702__auto__,c__30814__auto___33064,out){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_33056 = [null,null,null,null,null,null,null,null,null];
(statearr_33056[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_33056[(1)] = (1));

return statearr_33056;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_33039){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33039);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e33057){if((e33057 instanceof Object)){
var ex__30706__auto__ = e33057;
var statearr_33058_33075 = state_33039;
(statearr_33058_33075[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33039);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33057;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33076 = state_33039;
state_33039 = G__33076;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_33039){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_33039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___33064,out))
})();
var state__30816__auto__ = (function (){var statearr_33059 = f__30815__auto__.call(null);
(statearr_33059[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___33064);

return statearr_33059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___33064,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args33077 = [];
var len__29766__auto___33080 = arguments.length;
var i__29767__auto___33081 = (0);
while(true){
if((i__29767__auto___33081 < len__29766__auto___33080)){
args33077.push((arguments[i__29767__auto___33081]));

var G__33082 = (i__29767__auto___33081 + (1));
i__29767__auto___33081 = G__33082;
continue;
} else {
}
break;
}

var G__33079 = args33077.length;
switch (G__33079) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33077.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30814__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto__){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto__){
return (function (state_33249){
var state_val_33250 = (state_33249[(1)]);
if((state_val_33250 === (7))){
var inst_33245 = (state_33249[(2)]);
var state_33249__$1 = state_33249;
var statearr_33251_33292 = state_33249__$1;
(statearr_33251_33292[(2)] = inst_33245);

(statearr_33251_33292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (20))){
var inst_33215 = (state_33249[(7)]);
var inst_33226 = (state_33249[(2)]);
var inst_33227 = cljs.core.next.call(null,inst_33215);
var inst_33201 = inst_33227;
var inst_33202 = null;
var inst_33203 = (0);
var inst_33204 = (0);
var state_33249__$1 = (function (){var statearr_33252 = state_33249;
(statearr_33252[(8)] = inst_33201);

(statearr_33252[(9)] = inst_33203);

(statearr_33252[(10)] = inst_33226);

(statearr_33252[(11)] = inst_33202);

(statearr_33252[(12)] = inst_33204);

return statearr_33252;
})();
var statearr_33253_33293 = state_33249__$1;
(statearr_33253_33293[(2)] = null);

(statearr_33253_33293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (1))){
var state_33249__$1 = state_33249;
var statearr_33254_33294 = state_33249__$1;
(statearr_33254_33294[(2)] = null);

(statearr_33254_33294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (4))){
var inst_33190 = (state_33249[(13)]);
var inst_33190__$1 = (state_33249[(2)]);
var inst_33191 = (inst_33190__$1 == null);
var state_33249__$1 = (function (){var statearr_33255 = state_33249;
(statearr_33255[(13)] = inst_33190__$1);

return statearr_33255;
})();
if(cljs.core.truth_(inst_33191)){
var statearr_33256_33295 = state_33249__$1;
(statearr_33256_33295[(1)] = (5));

} else {
var statearr_33257_33296 = state_33249__$1;
(statearr_33257_33296[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (15))){
var state_33249__$1 = state_33249;
var statearr_33261_33297 = state_33249__$1;
(statearr_33261_33297[(2)] = null);

(statearr_33261_33297[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (21))){
var state_33249__$1 = state_33249;
var statearr_33262_33298 = state_33249__$1;
(statearr_33262_33298[(2)] = null);

(statearr_33262_33298[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (13))){
var inst_33201 = (state_33249[(8)]);
var inst_33203 = (state_33249[(9)]);
var inst_33202 = (state_33249[(11)]);
var inst_33204 = (state_33249[(12)]);
var inst_33211 = (state_33249[(2)]);
var inst_33212 = (inst_33204 + (1));
var tmp33258 = inst_33201;
var tmp33259 = inst_33203;
var tmp33260 = inst_33202;
var inst_33201__$1 = tmp33258;
var inst_33202__$1 = tmp33260;
var inst_33203__$1 = tmp33259;
var inst_33204__$1 = inst_33212;
var state_33249__$1 = (function (){var statearr_33263 = state_33249;
(statearr_33263[(8)] = inst_33201__$1);

(statearr_33263[(14)] = inst_33211);

(statearr_33263[(9)] = inst_33203__$1);

(statearr_33263[(11)] = inst_33202__$1);

(statearr_33263[(12)] = inst_33204__$1);

return statearr_33263;
})();
var statearr_33264_33299 = state_33249__$1;
(statearr_33264_33299[(2)] = null);

(statearr_33264_33299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (22))){
var state_33249__$1 = state_33249;
var statearr_33265_33300 = state_33249__$1;
(statearr_33265_33300[(2)] = null);

(statearr_33265_33300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (6))){
var inst_33190 = (state_33249[(13)]);
var inst_33199 = f.call(null,inst_33190);
var inst_33200 = cljs.core.seq.call(null,inst_33199);
var inst_33201 = inst_33200;
var inst_33202 = null;
var inst_33203 = (0);
var inst_33204 = (0);
var state_33249__$1 = (function (){var statearr_33266 = state_33249;
(statearr_33266[(8)] = inst_33201);

(statearr_33266[(9)] = inst_33203);

(statearr_33266[(11)] = inst_33202);

(statearr_33266[(12)] = inst_33204);

return statearr_33266;
})();
var statearr_33267_33301 = state_33249__$1;
(statearr_33267_33301[(2)] = null);

(statearr_33267_33301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (17))){
var inst_33215 = (state_33249[(7)]);
var inst_33219 = cljs.core.chunk_first.call(null,inst_33215);
var inst_33220 = cljs.core.chunk_rest.call(null,inst_33215);
var inst_33221 = cljs.core.count.call(null,inst_33219);
var inst_33201 = inst_33220;
var inst_33202 = inst_33219;
var inst_33203 = inst_33221;
var inst_33204 = (0);
var state_33249__$1 = (function (){var statearr_33268 = state_33249;
(statearr_33268[(8)] = inst_33201);

(statearr_33268[(9)] = inst_33203);

(statearr_33268[(11)] = inst_33202);

(statearr_33268[(12)] = inst_33204);

return statearr_33268;
})();
var statearr_33269_33302 = state_33249__$1;
(statearr_33269_33302[(2)] = null);

(statearr_33269_33302[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (3))){
var inst_33247 = (state_33249[(2)]);
var state_33249__$1 = state_33249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33249__$1,inst_33247);
} else {
if((state_val_33250 === (12))){
var inst_33235 = (state_33249[(2)]);
var state_33249__$1 = state_33249;
var statearr_33270_33303 = state_33249__$1;
(statearr_33270_33303[(2)] = inst_33235);

(statearr_33270_33303[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (2))){
var state_33249__$1 = state_33249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33249__$1,(4),in$);
} else {
if((state_val_33250 === (23))){
var inst_33243 = (state_33249[(2)]);
var state_33249__$1 = state_33249;
var statearr_33271_33304 = state_33249__$1;
(statearr_33271_33304[(2)] = inst_33243);

(statearr_33271_33304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (19))){
var inst_33230 = (state_33249[(2)]);
var state_33249__$1 = state_33249;
var statearr_33272_33305 = state_33249__$1;
(statearr_33272_33305[(2)] = inst_33230);

(statearr_33272_33305[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (11))){
var inst_33201 = (state_33249[(8)]);
var inst_33215 = (state_33249[(7)]);
var inst_33215__$1 = cljs.core.seq.call(null,inst_33201);
var state_33249__$1 = (function (){var statearr_33273 = state_33249;
(statearr_33273[(7)] = inst_33215__$1);

return statearr_33273;
})();
if(inst_33215__$1){
var statearr_33274_33306 = state_33249__$1;
(statearr_33274_33306[(1)] = (14));

} else {
var statearr_33275_33307 = state_33249__$1;
(statearr_33275_33307[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (9))){
var inst_33237 = (state_33249[(2)]);
var inst_33238 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_33249__$1 = (function (){var statearr_33276 = state_33249;
(statearr_33276[(15)] = inst_33237);

return statearr_33276;
})();
if(cljs.core.truth_(inst_33238)){
var statearr_33277_33308 = state_33249__$1;
(statearr_33277_33308[(1)] = (21));

} else {
var statearr_33278_33309 = state_33249__$1;
(statearr_33278_33309[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (5))){
var inst_33193 = cljs.core.async.close_BANG_.call(null,out);
var state_33249__$1 = state_33249;
var statearr_33279_33310 = state_33249__$1;
(statearr_33279_33310[(2)] = inst_33193);

(statearr_33279_33310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (14))){
var inst_33215 = (state_33249[(7)]);
var inst_33217 = cljs.core.chunked_seq_QMARK_.call(null,inst_33215);
var state_33249__$1 = state_33249;
if(inst_33217){
var statearr_33280_33311 = state_33249__$1;
(statearr_33280_33311[(1)] = (17));

} else {
var statearr_33281_33312 = state_33249__$1;
(statearr_33281_33312[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (16))){
var inst_33233 = (state_33249[(2)]);
var state_33249__$1 = state_33249;
var statearr_33282_33313 = state_33249__$1;
(statearr_33282_33313[(2)] = inst_33233);

(statearr_33282_33313[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33250 === (10))){
var inst_33202 = (state_33249[(11)]);
var inst_33204 = (state_33249[(12)]);
var inst_33209 = cljs.core._nth.call(null,inst_33202,inst_33204);
var state_33249__$1 = state_33249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33249__$1,(13),out,inst_33209);
} else {
if((state_val_33250 === (18))){
var inst_33215 = (state_33249[(7)]);
var inst_33224 = cljs.core.first.call(null,inst_33215);
var state_33249__$1 = state_33249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33249__$1,(20),out,inst_33224);
} else {
if((state_val_33250 === (8))){
var inst_33203 = (state_33249[(9)]);
var inst_33204 = (state_33249[(12)]);
var inst_33206 = (inst_33204 < inst_33203);
var inst_33207 = inst_33206;
var state_33249__$1 = state_33249;
if(cljs.core.truth_(inst_33207)){
var statearr_33283_33314 = state_33249__$1;
(statearr_33283_33314[(1)] = (10));

} else {
var statearr_33284_33315 = state_33249__$1;
(statearr_33284_33315[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto__))
;
return ((function (switch__30702__auto__,c__30814__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30703__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30703__auto____0 = (function (){
var statearr_33288 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33288[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30703__auto__);

(statearr_33288[(1)] = (1));

return statearr_33288;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30703__auto____1 = (function (state_33249){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e33289){if((e33289 instanceof Object)){
var ex__30706__auto__ = e33289;
var statearr_33290_33316 = state_33249;
(statearr_33290_33316[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33289;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33317 = state_33249;
state_33249 = G__33317;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30703__auto__ = function(state_33249){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30703__auto____1.call(this,state_33249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30703__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30703__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto__))
})();
var state__30816__auto__ = (function (){var statearr_33291 = f__30815__auto__.call(null);
(statearr_33291[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto__);

return statearr_33291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto__))
);

return c__30814__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args33318 = [];
var len__29766__auto___33321 = arguments.length;
var i__29767__auto___33322 = (0);
while(true){
if((i__29767__auto___33322 < len__29766__auto___33321)){
args33318.push((arguments[i__29767__auto___33322]));

var G__33323 = (i__29767__auto___33322 + (1));
i__29767__auto___33322 = G__33323;
continue;
} else {
}
break;
}

var G__33320 = args33318.length;
switch (G__33320) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33318.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args33325 = [];
var len__29766__auto___33328 = arguments.length;
var i__29767__auto___33329 = (0);
while(true){
if((i__29767__auto___33329 < len__29766__auto___33328)){
args33325.push((arguments[i__29767__auto___33329]));

var G__33330 = (i__29767__auto___33329 + (1));
i__29767__auto___33329 = G__33330;
continue;
} else {
}
break;
}

var G__33327 = args33325.length;
switch (G__33327) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33325.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args33332 = [];
var len__29766__auto___33383 = arguments.length;
var i__29767__auto___33384 = (0);
while(true){
if((i__29767__auto___33384 < len__29766__auto___33383)){
args33332.push((arguments[i__29767__auto___33384]));

var G__33385 = (i__29767__auto___33384 + (1));
i__29767__auto___33384 = G__33385;
continue;
} else {
}
break;
}

var G__33334 = args33332.length;
switch (G__33334) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33332.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30814__auto___33387 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___33387,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___33387,out){
return (function (state_33358){
var state_val_33359 = (state_33358[(1)]);
if((state_val_33359 === (7))){
var inst_33353 = (state_33358[(2)]);
var state_33358__$1 = state_33358;
var statearr_33360_33388 = state_33358__$1;
(statearr_33360_33388[(2)] = inst_33353);

(statearr_33360_33388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (1))){
var inst_33335 = null;
var state_33358__$1 = (function (){var statearr_33361 = state_33358;
(statearr_33361[(7)] = inst_33335);

return statearr_33361;
})();
var statearr_33362_33389 = state_33358__$1;
(statearr_33362_33389[(2)] = null);

(statearr_33362_33389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (4))){
var inst_33338 = (state_33358[(8)]);
var inst_33338__$1 = (state_33358[(2)]);
var inst_33339 = (inst_33338__$1 == null);
var inst_33340 = cljs.core.not.call(null,inst_33339);
var state_33358__$1 = (function (){var statearr_33363 = state_33358;
(statearr_33363[(8)] = inst_33338__$1);

return statearr_33363;
})();
if(inst_33340){
var statearr_33364_33390 = state_33358__$1;
(statearr_33364_33390[(1)] = (5));

} else {
var statearr_33365_33391 = state_33358__$1;
(statearr_33365_33391[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (6))){
var state_33358__$1 = state_33358;
var statearr_33366_33392 = state_33358__$1;
(statearr_33366_33392[(2)] = null);

(statearr_33366_33392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (3))){
var inst_33355 = (state_33358[(2)]);
var inst_33356 = cljs.core.async.close_BANG_.call(null,out);
var state_33358__$1 = (function (){var statearr_33367 = state_33358;
(statearr_33367[(9)] = inst_33355);

return statearr_33367;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33358__$1,inst_33356);
} else {
if((state_val_33359 === (2))){
var state_33358__$1 = state_33358;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33358__$1,(4),ch);
} else {
if((state_val_33359 === (11))){
var inst_33338 = (state_33358[(8)]);
var inst_33347 = (state_33358[(2)]);
var inst_33335 = inst_33338;
var state_33358__$1 = (function (){var statearr_33368 = state_33358;
(statearr_33368[(7)] = inst_33335);

(statearr_33368[(10)] = inst_33347);

return statearr_33368;
})();
var statearr_33369_33393 = state_33358__$1;
(statearr_33369_33393[(2)] = null);

(statearr_33369_33393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (9))){
var inst_33338 = (state_33358[(8)]);
var state_33358__$1 = state_33358;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33358__$1,(11),out,inst_33338);
} else {
if((state_val_33359 === (5))){
var inst_33335 = (state_33358[(7)]);
var inst_33338 = (state_33358[(8)]);
var inst_33342 = cljs.core._EQ_.call(null,inst_33338,inst_33335);
var state_33358__$1 = state_33358;
if(inst_33342){
var statearr_33371_33394 = state_33358__$1;
(statearr_33371_33394[(1)] = (8));

} else {
var statearr_33372_33395 = state_33358__$1;
(statearr_33372_33395[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (10))){
var inst_33350 = (state_33358[(2)]);
var state_33358__$1 = state_33358;
var statearr_33373_33396 = state_33358__$1;
(statearr_33373_33396[(2)] = inst_33350);

(statearr_33373_33396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33359 === (8))){
var inst_33335 = (state_33358[(7)]);
var tmp33370 = inst_33335;
var inst_33335__$1 = tmp33370;
var state_33358__$1 = (function (){var statearr_33374 = state_33358;
(statearr_33374[(7)] = inst_33335__$1);

return statearr_33374;
})();
var statearr_33375_33397 = state_33358__$1;
(statearr_33375_33397[(2)] = null);

(statearr_33375_33397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___33387,out))
;
return ((function (switch__30702__auto__,c__30814__auto___33387,out){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_33379 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33379[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_33379[(1)] = (1));

return statearr_33379;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_33358){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33358);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e33380){if((e33380 instanceof Object)){
var ex__30706__auto__ = e33380;
var statearr_33381_33398 = state_33358;
(statearr_33381_33398[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33358);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33380;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33399 = state_33358;
state_33358 = G__33399;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_33358){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_33358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___33387,out))
})();
var state__30816__auto__ = (function (){var statearr_33382 = f__30815__auto__.call(null);
(statearr_33382[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___33387);

return statearr_33382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___33387,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33400 = [];
var len__29766__auto___33470 = arguments.length;
var i__29767__auto___33471 = (0);
while(true){
if((i__29767__auto___33471 < len__29766__auto___33470)){
args33400.push((arguments[i__29767__auto___33471]));

var G__33472 = (i__29767__auto___33471 + (1));
i__29767__auto___33471 = G__33472;
continue;
} else {
}
break;
}

var G__33402 = args33400.length;
switch (G__33402) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33400.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30814__auto___33474 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___33474,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___33474,out){
return (function (state_33440){
var state_val_33441 = (state_33440[(1)]);
if((state_val_33441 === (7))){
var inst_33436 = (state_33440[(2)]);
var state_33440__$1 = state_33440;
var statearr_33442_33475 = state_33440__$1;
(statearr_33442_33475[(2)] = inst_33436);

(statearr_33442_33475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (1))){
var inst_33403 = (new Array(n));
var inst_33404 = inst_33403;
var inst_33405 = (0);
var state_33440__$1 = (function (){var statearr_33443 = state_33440;
(statearr_33443[(7)] = inst_33404);

(statearr_33443[(8)] = inst_33405);

return statearr_33443;
})();
var statearr_33444_33476 = state_33440__$1;
(statearr_33444_33476[(2)] = null);

(statearr_33444_33476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (4))){
var inst_33408 = (state_33440[(9)]);
var inst_33408__$1 = (state_33440[(2)]);
var inst_33409 = (inst_33408__$1 == null);
var inst_33410 = cljs.core.not.call(null,inst_33409);
var state_33440__$1 = (function (){var statearr_33445 = state_33440;
(statearr_33445[(9)] = inst_33408__$1);

return statearr_33445;
})();
if(inst_33410){
var statearr_33446_33477 = state_33440__$1;
(statearr_33446_33477[(1)] = (5));

} else {
var statearr_33447_33478 = state_33440__$1;
(statearr_33447_33478[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (15))){
var inst_33430 = (state_33440[(2)]);
var state_33440__$1 = state_33440;
var statearr_33448_33479 = state_33440__$1;
(statearr_33448_33479[(2)] = inst_33430);

(statearr_33448_33479[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (13))){
var state_33440__$1 = state_33440;
var statearr_33449_33480 = state_33440__$1;
(statearr_33449_33480[(2)] = null);

(statearr_33449_33480[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (6))){
var inst_33405 = (state_33440[(8)]);
var inst_33426 = (inst_33405 > (0));
var state_33440__$1 = state_33440;
if(cljs.core.truth_(inst_33426)){
var statearr_33450_33481 = state_33440__$1;
(statearr_33450_33481[(1)] = (12));

} else {
var statearr_33451_33482 = state_33440__$1;
(statearr_33451_33482[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (3))){
var inst_33438 = (state_33440[(2)]);
var state_33440__$1 = state_33440;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33440__$1,inst_33438);
} else {
if((state_val_33441 === (12))){
var inst_33404 = (state_33440[(7)]);
var inst_33428 = cljs.core.vec.call(null,inst_33404);
var state_33440__$1 = state_33440;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33440__$1,(15),out,inst_33428);
} else {
if((state_val_33441 === (2))){
var state_33440__$1 = state_33440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33440__$1,(4),ch);
} else {
if((state_val_33441 === (11))){
var inst_33420 = (state_33440[(2)]);
var inst_33421 = (new Array(n));
var inst_33404 = inst_33421;
var inst_33405 = (0);
var state_33440__$1 = (function (){var statearr_33452 = state_33440;
(statearr_33452[(7)] = inst_33404);

(statearr_33452[(10)] = inst_33420);

(statearr_33452[(8)] = inst_33405);

return statearr_33452;
})();
var statearr_33453_33483 = state_33440__$1;
(statearr_33453_33483[(2)] = null);

(statearr_33453_33483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (9))){
var inst_33404 = (state_33440[(7)]);
var inst_33418 = cljs.core.vec.call(null,inst_33404);
var state_33440__$1 = state_33440;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33440__$1,(11),out,inst_33418);
} else {
if((state_val_33441 === (5))){
var inst_33404 = (state_33440[(7)]);
var inst_33413 = (state_33440[(11)]);
var inst_33408 = (state_33440[(9)]);
var inst_33405 = (state_33440[(8)]);
var inst_33412 = (inst_33404[inst_33405] = inst_33408);
var inst_33413__$1 = (inst_33405 + (1));
var inst_33414 = (inst_33413__$1 < n);
var state_33440__$1 = (function (){var statearr_33454 = state_33440;
(statearr_33454[(11)] = inst_33413__$1);

(statearr_33454[(12)] = inst_33412);

return statearr_33454;
})();
if(cljs.core.truth_(inst_33414)){
var statearr_33455_33484 = state_33440__$1;
(statearr_33455_33484[(1)] = (8));

} else {
var statearr_33456_33485 = state_33440__$1;
(statearr_33456_33485[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (14))){
var inst_33433 = (state_33440[(2)]);
var inst_33434 = cljs.core.async.close_BANG_.call(null,out);
var state_33440__$1 = (function (){var statearr_33458 = state_33440;
(statearr_33458[(13)] = inst_33433);

return statearr_33458;
})();
var statearr_33459_33486 = state_33440__$1;
(statearr_33459_33486[(2)] = inst_33434);

(statearr_33459_33486[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (10))){
var inst_33424 = (state_33440[(2)]);
var state_33440__$1 = state_33440;
var statearr_33460_33487 = state_33440__$1;
(statearr_33460_33487[(2)] = inst_33424);

(statearr_33460_33487[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33441 === (8))){
var inst_33404 = (state_33440[(7)]);
var inst_33413 = (state_33440[(11)]);
var tmp33457 = inst_33404;
var inst_33404__$1 = tmp33457;
var inst_33405 = inst_33413;
var state_33440__$1 = (function (){var statearr_33461 = state_33440;
(statearr_33461[(7)] = inst_33404__$1);

(statearr_33461[(8)] = inst_33405);

return statearr_33461;
})();
var statearr_33462_33488 = state_33440__$1;
(statearr_33462_33488[(2)] = null);

(statearr_33462_33488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___33474,out))
;
return ((function (switch__30702__auto__,c__30814__auto___33474,out){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_33466 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33466[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_33466[(1)] = (1));

return statearr_33466;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_33440){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e33467){if((e33467 instanceof Object)){
var ex__30706__auto__ = e33467;
var statearr_33468_33489 = state_33440;
(statearr_33468_33489[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33440);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33467;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33490 = state_33440;
state_33440 = G__33490;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_33440){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_33440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___33474,out))
})();
var state__30816__auto__ = (function (){var statearr_33469 = f__30815__auto__.call(null);
(statearr_33469[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___33474);

return statearr_33469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___33474,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args33491 = [];
var len__29766__auto___33565 = arguments.length;
var i__29767__auto___33566 = (0);
while(true){
if((i__29767__auto___33566 < len__29766__auto___33565)){
args33491.push((arguments[i__29767__auto___33566]));

var G__33567 = (i__29767__auto___33566 + (1));
i__29767__auto___33566 = G__33567;
continue;
} else {
}
break;
}

var G__33493 = args33491.length;
switch (G__33493) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33491.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30814__auto___33569 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30814__auto___33569,out){
return (function (){
var f__30815__auto__ = (function (){var switch__30702__auto__ = ((function (c__30814__auto___33569,out){
return (function (state_33535){
var state_val_33536 = (state_33535[(1)]);
if((state_val_33536 === (7))){
var inst_33531 = (state_33535[(2)]);
var state_33535__$1 = state_33535;
var statearr_33537_33570 = state_33535__$1;
(statearr_33537_33570[(2)] = inst_33531);

(statearr_33537_33570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (1))){
var inst_33494 = [];
var inst_33495 = inst_33494;
var inst_33496 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33535__$1 = (function (){var statearr_33538 = state_33535;
(statearr_33538[(7)] = inst_33495);

(statearr_33538[(8)] = inst_33496);

return statearr_33538;
})();
var statearr_33539_33571 = state_33535__$1;
(statearr_33539_33571[(2)] = null);

(statearr_33539_33571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (4))){
var inst_33499 = (state_33535[(9)]);
var inst_33499__$1 = (state_33535[(2)]);
var inst_33500 = (inst_33499__$1 == null);
var inst_33501 = cljs.core.not.call(null,inst_33500);
var state_33535__$1 = (function (){var statearr_33540 = state_33535;
(statearr_33540[(9)] = inst_33499__$1);

return statearr_33540;
})();
if(inst_33501){
var statearr_33541_33572 = state_33535__$1;
(statearr_33541_33572[(1)] = (5));

} else {
var statearr_33542_33573 = state_33535__$1;
(statearr_33542_33573[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (15))){
var inst_33525 = (state_33535[(2)]);
var state_33535__$1 = state_33535;
var statearr_33543_33574 = state_33535__$1;
(statearr_33543_33574[(2)] = inst_33525);

(statearr_33543_33574[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (13))){
var state_33535__$1 = state_33535;
var statearr_33544_33575 = state_33535__$1;
(statearr_33544_33575[(2)] = null);

(statearr_33544_33575[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (6))){
var inst_33495 = (state_33535[(7)]);
var inst_33520 = inst_33495.length;
var inst_33521 = (inst_33520 > (0));
var state_33535__$1 = state_33535;
if(cljs.core.truth_(inst_33521)){
var statearr_33545_33576 = state_33535__$1;
(statearr_33545_33576[(1)] = (12));

} else {
var statearr_33546_33577 = state_33535__$1;
(statearr_33546_33577[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (3))){
var inst_33533 = (state_33535[(2)]);
var state_33535__$1 = state_33535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33535__$1,inst_33533);
} else {
if((state_val_33536 === (12))){
var inst_33495 = (state_33535[(7)]);
var inst_33523 = cljs.core.vec.call(null,inst_33495);
var state_33535__$1 = state_33535;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33535__$1,(15),out,inst_33523);
} else {
if((state_val_33536 === (2))){
var state_33535__$1 = state_33535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33535__$1,(4),ch);
} else {
if((state_val_33536 === (11))){
var inst_33499 = (state_33535[(9)]);
var inst_33503 = (state_33535[(10)]);
var inst_33513 = (state_33535[(2)]);
var inst_33514 = [];
var inst_33515 = inst_33514.push(inst_33499);
var inst_33495 = inst_33514;
var inst_33496 = inst_33503;
var state_33535__$1 = (function (){var statearr_33547 = state_33535;
(statearr_33547[(11)] = inst_33513);

(statearr_33547[(7)] = inst_33495);

(statearr_33547[(12)] = inst_33515);

(statearr_33547[(8)] = inst_33496);

return statearr_33547;
})();
var statearr_33548_33578 = state_33535__$1;
(statearr_33548_33578[(2)] = null);

(statearr_33548_33578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (9))){
var inst_33495 = (state_33535[(7)]);
var inst_33511 = cljs.core.vec.call(null,inst_33495);
var state_33535__$1 = state_33535;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33535__$1,(11),out,inst_33511);
} else {
if((state_val_33536 === (5))){
var inst_33496 = (state_33535[(8)]);
var inst_33499 = (state_33535[(9)]);
var inst_33503 = (state_33535[(10)]);
var inst_33503__$1 = f.call(null,inst_33499);
var inst_33504 = cljs.core._EQ_.call(null,inst_33503__$1,inst_33496);
var inst_33505 = cljs.core.keyword_identical_QMARK_.call(null,inst_33496,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33506 = (inst_33504) || (inst_33505);
var state_33535__$1 = (function (){var statearr_33549 = state_33535;
(statearr_33549[(10)] = inst_33503__$1);

return statearr_33549;
})();
if(cljs.core.truth_(inst_33506)){
var statearr_33550_33579 = state_33535__$1;
(statearr_33550_33579[(1)] = (8));

} else {
var statearr_33551_33580 = state_33535__$1;
(statearr_33551_33580[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (14))){
var inst_33528 = (state_33535[(2)]);
var inst_33529 = cljs.core.async.close_BANG_.call(null,out);
var state_33535__$1 = (function (){var statearr_33553 = state_33535;
(statearr_33553[(13)] = inst_33528);

return statearr_33553;
})();
var statearr_33554_33581 = state_33535__$1;
(statearr_33554_33581[(2)] = inst_33529);

(statearr_33554_33581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (10))){
var inst_33518 = (state_33535[(2)]);
var state_33535__$1 = state_33535;
var statearr_33555_33582 = state_33535__$1;
(statearr_33555_33582[(2)] = inst_33518);

(statearr_33555_33582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33536 === (8))){
var inst_33495 = (state_33535[(7)]);
var inst_33499 = (state_33535[(9)]);
var inst_33503 = (state_33535[(10)]);
var inst_33508 = inst_33495.push(inst_33499);
var tmp33552 = inst_33495;
var inst_33495__$1 = tmp33552;
var inst_33496 = inst_33503;
var state_33535__$1 = (function (){var statearr_33556 = state_33535;
(statearr_33556[(14)] = inst_33508);

(statearr_33556[(7)] = inst_33495__$1);

(statearr_33556[(8)] = inst_33496);

return statearr_33556;
})();
var statearr_33557_33583 = state_33535__$1;
(statearr_33557_33583[(2)] = null);

(statearr_33557_33583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30814__auto___33569,out))
;
return ((function (switch__30702__auto__,c__30814__auto___33569,out){
return (function() {
var cljs$core$async$state_machine__30703__auto__ = null;
var cljs$core$async$state_machine__30703__auto____0 = (function (){
var statearr_33561 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33561[(0)] = cljs$core$async$state_machine__30703__auto__);

(statearr_33561[(1)] = (1));

return statearr_33561;
});
var cljs$core$async$state_machine__30703__auto____1 = (function (state_33535){
while(true){
var ret_value__30704__auto__ = (function (){try{while(true){
var result__30705__auto__ = switch__30702__auto__.call(null,state_33535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30705__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30705__auto__;
}
break;
}
}catch (e33562){if((e33562 instanceof Object)){
var ex__30706__auto__ = e33562;
var statearr_33563_33584 = state_33535;
(statearr_33563_33584[(5)] = ex__30706__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33535);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33562;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30704__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33585 = state_33535;
state_33535 = G__33585;
continue;
} else {
return ret_value__30704__auto__;
}
break;
}
});
cljs$core$async$state_machine__30703__auto__ = function(state_33535){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30703__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30703__auto____1.call(this,state_33535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30703__auto____0;
cljs$core$async$state_machine__30703__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30703__auto____1;
return cljs$core$async$state_machine__30703__auto__;
})()
;})(switch__30702__auto__,c__30814__auto___33569,out))
})();
var state__30816__auto__ = (function (){var statearr_33564 = f__30815__auto__.call(null);
(statearr_33564[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30814__auto___33569);

return statearr_33564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30816__auto__);
});})(c__30814__auto___33569,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map