// Compiled by ClojureScript 1.8.51 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
/**
 * Traverses up the DOM tree and returns the first node that contains a href attr
 */
pushy.core.recur_href = (function pushy$core$recur_href(target){
if(cljs.core.truth_(target.href)){
return target;
} else {
if(cljs.core.truth_(target.parentNode)){
return pushy$core$recur_href.call(null,target.parentNode);
} else {
return null;
}
}
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__10277 = h;
G__10277.setUseFragment(false);

G__10277.setPathPrefix("");

G__10277.setEnabled(true);

return G__10277;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str(location.pathname),cljs.core.str(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str(path_prefix),cljs.core.str(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var args10278 = [];
var len__7084__auto___10281 = arguments.length;
var i__7085__auto___10282 = (0);
while(true){
if((i__7085__auto___10282 < len__7084__auto___10281)){
args10278.push((arguments[i__7085__auto___10282]));

var G__10283 = (i__7085__auto___10282 + (1));
i__7085__auto___10282 = G__10283;
continue;
} else {
}
break;
}

var G__10280 = args10278.length;
switch (G__10280) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10278.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;

/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var args10285 = [];
var len__7084__auto___10291 = arguments.length;
var i__7085__auto___10292 = (0);
while(true){
if((i__7085__auto___10292 < len__7084__auto___10291)){
args10285.push((arguments[i__7085__auto___10292]));

var G__10293 = (i__7085__auto___10292 + (1));
i__7085__auto___10292 = G__10293;
continue;
} else {
}
break;
}

var G__10287 = args10285.length;
switch (G__10287) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10285.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$,token);
} else {
var m__6678__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$,token,title);
} else {
var m__6678__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;

pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var args10288 = [];
var len__7084__auto___10295 = arguments.length;
var i__7085__auto___10296 = (0);
while(true){
if((i__7085__auto___10296 < len__7084__auto___10295)){
args10288.push((arguments[i__7085__auto___10296]));

var G__10297 = (i__7085__auto___10296 + (1));
i__7085__auto___10296 = G__10297;
continue;
} else {
}
break;
}

var G__10290 = args10288.length;
switch (G__10290) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10288.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$,token);
} else {
var m__6678__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$,token,title);
} else {
var m__6678__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;

pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.get_token[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$);
} else {
var m__6678__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$);
} else {
var m__6678__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__6677__auto__ = (((this$ == null))?null:this$);
var m__6678__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__6677__auto__)]);
if(!((m__6678__auto__ == null))){
return m__6678__auto__.call(null,this$);
} else {
var m__6678__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__6678__auto____$1 == null))){
return m__6678__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (cljs.core.some_QMARK_.call(null,cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("^"),cljs.core.str(location.origin),cljs.core.str(".*$")].join('')),[cljs.core.str(uri)].join('')))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str(path),cljs.core.str("?"),cljs.core.str(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__7091__auto__ = [];
var len__7084__auto___10312 = arguments.length;
var i__7085__auto___10313 = (0);
while(true){
if((i__7085__auto___10313 < len__7084__auto___10312)){
args__7091__auto__.push((arguments[i__7085__auto___10313]));

var G__10314 = (i__7085__auto___10313 + (1));
i__7085__auto___10313 = G__10314;
continue;
} else {
}
break;
}

var argseq__7092__auto__ = ((((2) < args__7091__auto__.length))?(new cljs.core.IndexedSeq(args__7091__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7092__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__10302){
var map__10303 = p__10302;
var map__10303__$1 = ((((!((map__10303 == null)))?((((map__10303.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10303.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10303):map__10303);
var processable_url_QMARK_ = cljs.core.get.call(null,map__10303__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__10303__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core10305 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core10305 = (function (dispatch_fn,match_fn,p__10302,map__10303,processable_url_QMARK_,identity_fn,history,event_keys,meta10306){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__10302 = p__10302;
this.map__10303 = map__10303;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.history = history;
this.event_keys = event_keys;
this.meta10306 = meta10306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
pushy.core.t_pushy$core10305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_10307,meta10306__$1){
var self__ = this;
var _10307__$1 = this;
return (new pushy.core.t_pushy$core10305(self__.dispatch_fn,self__.match_fn,self__.p__10302,self__.map__10303,self__.processable_url_QMARK_,self__.identity_fn,self__.history,self__.event_keys,meta10306__$1));
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_10307){
var self__ = this;
var _10307__$1 = this;
return self__.meta10306;
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$ = true;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__4657__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__4657__auto__)){
var match = temp__4657__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
));

var temp__4657__auto___10315 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__4657__auto___10315)){
var match_10316 = temp__4657__auto___10315;
self__.dispatch_fn.call(null,match_10316);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__4657__auto__ = pushy.core.recur_href.call(null,e.target);
if(cljs.core.truth_(temp__4657__auto__)){
var el = temp__4657__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__6002__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__6002__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && (cljs.core.not_EQ_.call(null,(1),e.button));
} else {
return and__6002__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__4655__auto___10317 = el.title;
if(cljs.core.truth_(temp__4655__auto___10317)){
var title_10318 = temp__4655__auto___10317;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_10318);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
));

return null;
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__10308_10319 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__10309_10320 = null;
var count__10310_10321 = (0);
var i__10311_10322 = (0);
while(true){
if((i__10311_10322 < count__10310_10321)){
var key_10323 = cljs.core._nth.call(null,chunk__10309_10320,i__10311_10322);
goog.events.unlistenByKey(key_10323);

var G__10324 = seq__10308_10319;
var G__10325 = chunk__10309_10320;
var G__10326 = count__10310_10321;
var G__10327 = (i__10311_10322 + (1));
seq__10308_10319 = G__10324;
chunk__10309_10320 = G__10325;
count__10310_10321 = G__10326;
i__10311_10322 = G__10327;
continue;
} else {
var temp__4657__auto___10328 = cljs.core.seq.call(null,seq__10308_10319);
if(temp__4657__auto___10328){
var seq__10308_10329__$1 = temp__4657__auto___10328;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10308_10329__$1)){
var c__6825__auto___10330 = cljs.core.chunk_first.call(null,seq__10308_10329__$1);
var G__10331 = cljs.core.chunk_rest.call(null,seq__10308_10329__$1);
var G__10332 = c__6825__auto___10330;
var G__10333 = cljs.core.count.call(null,c__6825__auto___10330);
var G__10334 = (0);
seq__10308_10319 = G__10331;
chunk__10309_10320 = G__10332;
count__10310_10321 = G__10333;
i__10311_10322 = G__10334;
continue;
} else {
var key_10335 = cljs.core.first.call(null,seq__10308_10329__$1);
goog.events.unlistenByKey(key_10335);

var G__10336 = cljs.core.next.call(null,seq__10308_10329__$1);
var G__10337 = null;
var G__10338 = (0);
var G__10339 = (0);
seq__10308_10319 = G__10336;
chunk__10309_10320 = G__10337;
count__10310_10321 = G__10338;
i__10311_10322 = G__10339;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.getBasis = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__10302","p__10302",1488284915,null),new cljs.core.Symbol(null,"map__10303","map__10303",-1251825175,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta10306","meta10306",-1941394453,null)], null);
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core10305.cljs$lang$type = true;

pushy.core.t_pushy$core10305.cljs$lang$ctorStr = "pushy.core/t_pushy$core10305";

pushy.core.t_pushy$core10305.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"pushy.core/t_pushy$core10305");
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.__GT_t_pushy$core10305 = ((function (history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn){
return (function pushy$core$__GT_t_pushy$core10305(dispatch_fn__$1,match_fn__$1,p__10302__$1,map__10303__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta10306){
return (new pushy.core.t_pushy$core10305(dispatch_fn__$1,match_fn__$1,p__10302__$1,map__10303__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta10306));
});})(history,event_keys,map__10303,map__10303__$1,processable_url_QMARK_,identity_fn))
;

}

return (new pushy.core.t_pushy$core10305(dispatch_fn,match_fn,p__10302,map__10303__$1,processable_url_QMARK_,identity_fn,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq10299){
var G__10300 = cljs.core.first.call(null,seq10299);
var seq10299__$1 = cljs.core.next.call(null,seq10299);
var G__10301 = cljs.core.first.call(null,seq10299__$1);
var seq10299__$2 = cljs.core.next.call(null,seq10299__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__10300,G__10301,seq10299__$2);
});
/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var args10340 = [];
var len__7084__auto___10343 = arguments.length;
var i__7085__auto___10344 = (0);
while(true){
if((i__7085__auto___10344 < len__7084__auto___10343)){
args10340.push((arguments[i__7085__auto___10344]));

var G__10345 = (i__7085__auto___10344 + (1));
i__7085__auto___10344 = G__10345;
continue;
} else {
}
break;
}

var G__10342 = args10340.length;
switch (G__10342) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10340.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;
pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var args10347 = [];
var len__7084__auto___10350 = arguments.length;
var i__7085__auto___10351 = (0);
while(true){
if((i__7085__auto___10351 < len__7084__auto___10350)){
args10347.push((arguments[i__7085__auto___10351]));

var G__10352 = (i__7085__auto___10351 + (1));
i__7085__auto___10351 = G__10352;
continue;
} else {
}
break;
}

var G__10349 = args10347.length;
switch (G__10349) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10347.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=core.js.map