// Compiled by ClojureScript 1.8.51 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = true;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__9114_9118 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__9115_9119 = null;
var count__9116_9120 = (0);
var i__9117_9121 = (0);
while(true){
if((i__9117_9121 < count__9116_9120)){
var k_9122 = cljs.core._nth.call(null,chunk__9115_9119,i__9117_9121);
var v_9123 = (b[k_9122]);
(a[k_9122] = v_9123);

var G__9124 = seq__9114_9118;
var G__9125 = chunk__9115_9119;
var G__9126 = count__9116_9120;
var G__9127 = (i__9117_9121 + (1));
seq__9114_9118 = G__9124;
chunk__9115_9119 = G__9125;
count__9116_9120 = G__9126;
i__9117_9121 = G__9127;
continue;
} else {
var temp__4657__auto___9128 = cljs.core.seq.call(null,seq__9114_9118);
if(temp__4657__auto___9128){
var seq__9114_9129__$1 = temp__4657__auto___9128;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9114_9129__$1)){
var c__6825__auto___9130 = cljs.core.chunk_first.call(null,seq__9114_9129__$1);
var G__9131 = cljs.core.chunk_rest.call(null,seq__9114_9129__$1);
var G__9132 = c__6825__auto___9130;
var G__9133 = cljs.core.count.call(null,c__6825__auto___9130);
var G__9134 = (0);
seq__9114_9118 = G__9131;
chunk__9115_9119 = G__9132;
count__9116_9120 = G__9133;
i__9117_9121 = G__9134;
continue;
} else {
var k_9135 = cljs.core.first.call(null,seq__9114_9129__$1);
var v_9136 = (b[k_9135]);
(a[k_9135] = v_9136);

var G__9137 = cljs.core.next.call(null,seq__9114_9129__$1);
var G__9138 = null;
var G__9139 = (0);
var G__9140 = (0);
seq__9114_9118 = G__9137;
chunk__9115_9119 = G__9138;
count__9116_9120 = G__9139;
i__9117_9121 = G__9140;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args9141 = [];
var len__7084__auto___9144 = arguments.length;
var i__7085__auto___9145 = (0);
while(true){
if((i__7085__auto___9145 < len__7084__auto___9144)){
args9141.push((arguments[i__7085__auto___9145]));

var G__9146 = (i__7085__auto___9145 + (1));
i__7085__auto___9145 = G__9146;
continue;
} else {
}
break;
}

var G__9143 = args9141.length;
switch (G__9143) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9141.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__9148 = (i + (2));
var G__9149 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__9148;
ret = G__9149;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__9150_9154 = cljs.core.seq.call(null,v);
var chunk__9151_9155 = null;
var count__9152_9156 = (0);
var i__9153_9157 = (0);
while(true){
if((i__9153_9157 < count__9152_9156)){
var x_9158 = cljs.core._nth.call(null,chunk__9151_9155,i__9153_9157);
ret.push(x_9158);

var G__9159 = seq__9150_9154;
var G__9160 = chunk__9151_9155;
var G__9161 = count__9152_9156;
var G__9162 = (i__9153_9157 + (1));
seq__9150_9154 = G__9159;
chunk__9151_9155 = G__9160;
count__9152_9156 = G__9161;
i__9153_9157 = G__9162;
continue;
} else {
var temp__4657__auto___9163 = cljs.core.seq.call(null,seq__9150_9154);
if(temp__4657__auto___9163){
var seq__9150_9164__$1 = temp__4657__auto___9163;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9150_9164__$1)){
var c__6825__auto___9165 = cljs.core.chunk_first.call(null,seq__9150_9164__$1);
var G__9166 = cljs.core.chunk_rest.call(null,seq__9150_9164__$1);
var G__9167 = c__6825__auto___9165;
var G__9168 = cljs.core.count.call(null,c__6825__auto___9165);
var G__9169 = (0);
seq__9150_9154 = G__9166;
chunk__9151_9155 = G__9167;
count__9152_9156 = G__9168;
i__9153_9157 = G__9169;
continue;
} else {
var x_9170 = cljs.core.first.call(null,seq__9150_9164__$1);
ret.push(x_9170);

var G__9171 = cljs.core.next.call(null,seq__9150_9164__$1);
var G__9172 = null;
var G__9173 = (0);
var G__9174 = (0);
seq__9150_9154 = G__9171;
chunk__9151_9155 = G__9172;
count__9152_9156 = G__9173;
i__9153_9157 = G__9174;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__9175_9179 = cljs.core.seq.call(null,v);
var chunk__9176_9180 = null;
var count__9177_9181 = (0);
var i__9178_9182 = (0);
while(true){
if((i__9178_9182 < count__9177_9181)){
var x_9183 = cljs.core._nth.call(null,chunk__9176_9180,i__9178_9182);
ret.push(x_9183);

var G__9184 = seq__9175_9179;
var G__9185 = chunk__9176_9180;
var G__9186 = count__9177_9181;
var G__9187 = (i__9178_9182 + (1));
seq__9175_9179 = G__9184;
chunk__9176_9180 = G__9185;
count__9177_9181 = G__9186;
i__9178_9182 = G__9187;
continue;
} else {
var temp__4657__auto___9188 = cljs.core.seq.call(null,seq__9175_9179);
if(temp__4657__auto___9188){
var seq__9175_9189__$1 = temp__4657__auto___9188;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9175_9189__$1)){
var c__6825__auto___9190 = cljs.core.chunk_first.call(null,seq__9175_9189__$1);
var G__9191 = cljs.core.chunk_rest.call(null,seq__9175_9189__$1);
var G__9192 = c__6825__auto___9190;
var G__9193 = cljs.core.count.call(null,c__6825__auto___9190);
var G__9194 = (0);
seq__9175_9179 = G__9191;
chunk__9176_9180 = G__9192;
count__9177_9181 = G__9193;
i__9178_9182 = G__9194;
continue;
} else {
var x_9195 = cljs.core.first.call(null,seq__9175_9189__$1);
ret.push(x_9195);

var G__9196 = cljs.core.next.call(null,seq__9175_9189__$1);
var G__9197 = null;
var G__9198 = (0);
var G__9199 = (0);
seq__9175_9179 = G__9196;
chunk__9176_9180 = G__9197;
count__9177_9181 = G__9198;
i__9178_9182 = G__9199;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__9200_9204 = cljs.core.seq.call(null,v);
var chunk__9201_9205 = null;
var count__9202_9206 = (0);
var i__9203_9207 = (0);
while(true){
if((i__9203_9207 < count__9202_9206)){
var x_9208 = cljs.core._nth.call(null,chunk__9201_9205,i__9203_9207);
ret.push(x_9208);

var G__9209 = seq__9200_9204;
var G__9210 = chunk__9201_9205;
var G__9211 = count__9202_9206;
var G__9212 = (i__9203_9207 + (1));
seq__9200_9204 = G__9209;
chunk__9201_9205 = G__9210;
count__9202_9206 = G__9211;
i__9203_9207 = G__9212;
continue;
} else {
var temp__4657__auto___9213 = cljs.core.seq.call(null,seq__9200_9204);
if(temp__4657__auto___9213){
var seq__9200_9214__$1 = temp__4657__auto___9213;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9200_9214__$1)){
var c__6825__auto___9215 = cljs.core.chunk_first.call(null,seq__9200_9214__$1);
var G__9216 = cljs.core.chunk_rest.call(null,seq__9200_9214__$1);
var G__9217 = c__6825__auto___9215;
var G__9218 = cljs.core.count.call(null,c__6825__auto___9215);
var G__9219 = (0);
seq__9200_9204 = G__9216;
chunk__9201_9205 = G__9217;
count__9202_9206 = G__9218;
i__9203_9207 = G__9219;
continue;
} else {
var x_9220 = cljs.core.first.call(null,seq__9200_9214__$1);
ret.push(x_9220);

var G__9221 = cljs.core.next.call(null,seq__9200_9214__$1);
var G__9222 = null;
var G__9223 = (0);
var G__9224 = (0);
seq__9200_9204 = G__9221;
chunk__9201_9205 = G__9222;
count__9202_9206 = G__9223;
i__9203_9207 = G__9224;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args9225 = [];
var len__7084__auto___9236 = arguments.length;
var i__7085__auto___9237 = (0);
while(true){
if((i__7085__auto___9237 < len__7084__auto___9236)){
args9225.push((arguments[i__7085__auto___9237]));

var G__9238 = (i__7085__auto___9237 + (1));
i__7085__auto___9237 = G__9238;
continue;
} else {
}
break;
}

var G__9227 = args9225.length;
switch (G__9227) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9225.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__9228 = obj;
G__9228.push(kfn.call(null,k),vfn.call(null,v));

return G__9228;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x9229 = cljs.core.clone.call(null,handlers);
x9229.forEach = ((function (x9229,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__9230 = cljs.core.seq.call(null,coll);
var chunk__9231 = null;
var count__9232 = (0);
var i__9233 = (0);
while(true){
if((i__9233 < count__9232)){
var vec__9234 = cljs.core._nth.call(null,chunk__9231,i__9233);
var k = cljs.core.nth.call(null,vec__9234,(0),null);
var v = cljs.core.nth.call(null,vec__9234,(1),null);
f.call(null,v,k);

var G__9240 = seq__9230;
var G__9241 = chunk__9231;
var G__9242 = count__9232;
var G__9243 = (i__9233 + (1));
seq__9230 = G__9240;
chunk__9231 = G__9241;
count__9232 = G__9242;
i__9233 = G__9243;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__9230);
if(temp__4657__auto__){
var seq__9230__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9230__$1)){
var c__6825__auto__ = cljs.core.chunk_first.call(null,seq__9230__$1);
var G__9244 = cljs.core.chunk_rest.call(null,seq__9230__$1);
var G__9245 = c__6825__auto__;
var G__9246 = cljs.core.count.call(null,c__6825__auto__);
var G__9247 = (0);
seq__9230 = G__9244;
chunk__9231 = G__9245;
count__9232 = G__9246;
i__9233 = G__9247;
continue;
} else {
var vec__9235 = cljs.core.first.call(null,seq__9230__$1);
var k = cljs.core.nth.call(null,vec__9235,(0),null);
var v = cljs.core.nth.call(null,vec__9235,(1),null);
f.call(null,v,k);

var G__9248 = cljs.core.next.call(null,seq__9230__$1);
var G__9249 = null;
var G__9250 = (0);
var G__9251 = (0);
seq__9230 = G__9248;
chunk__9231 = G__9249;
count__9232 = G__9250;
i__9233 = G__9251;
continue;
}
} else {
return null;
}
}
break;
}
});})(x9229,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x9229;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args9252 = [];
var len__7084__auto___9258 = arguments.length;
var i__7085__auto___9259 = (0);
while(true){
if((i__7085__auto___9259 < len__7084__auto___9258)){
args9252.push((arguments[i__7085__auto___9259]));

var G__9260 = (i__7085__auto___9259 + (1));
i__7085__auto___9259 = G__9260;
continue;
} else {
}
break;
}

var G__9254 = args9252.length;
switch (G__9254) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9252.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit9255 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit9255 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta9256){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta9256 = meta9256;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit9255.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9257,meta9256__$1){
var self__ = this;
var _9257__$1 = this;
return (new cognitect.transit.t_cognitect$transit9255(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta9256__$1));
});

cognitect.transit.t_cognitect$transit9255.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9257){
var self__ = this;
var _9257__$1 = this;
return self__.meta9256;
});

cognitect.transit.t_cognitect$transit9255.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit9255.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit9255.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit9255.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit9255.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta9256","meta9256",-60736781,null)], null);
});

cognitect.transit.t_cognitect$transit9255.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit9255.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit9255";

cognitect.transit.t_cognitect$transit9255.cljs$lang$ctorPrWriter = (function (this__6620__auto__,writer__6621__auto__,opt__6622__auto__){
return cljs.core._write.call(null,writer__6621__auto__,"cognitect.transit/t_cognitect$transit9255");
});

cognitect.transit.__GT_t_cognitect$transit9255 = (function cognitect$transit$__GT_t_cognitect$transit9255(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta9256){
return (new cognitect.transit.t_cognitect$transit9255(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta9256));
});

}

return (new cognitect.transit.t_cognitect$transit9255(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__6014__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__6014__auto__)){
return or__6014__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map