(ns {{name}}.components.db
  (:require [schema.core :as s]
    [com.stuartsierra.component :as c]
    [taoensso.timbre :refer [info]])
  (:import (com.stuartsierra.component Lifecycle)))

;; Sample component
(s/defrecord Database
             []
             Lifecycle
             (start [component]
                    (info "DB component starting api")
                    (assoc component :test "TEST WORKS!"))

             (stop [component]
                   (info "DB component stopping")
                   component)

             )

(defn create-new-db
  []
  (c/using (map->Database {}) []))

