#!/bin/bash

DOCKER_INSTALLED=$(which docker)
AWS_INSTALLED=$(which aws)

test "$DOCKER_INSTALLED" = "" && echo "Docker must be installed"
test "$AWS_INSTALLED" = "" && echo "AWS CLI must be installed"
test "$DOCKER_INSTALLED" = "" -o "$AWS_INSTALLED" = "" && (echo "Please install dependencies before trying again."; exit 1)

echo "Logging into AWS ECR"
`aws ecr get-login`

REPO_EXISTS=`aws ecr describe-repositories | grep "synergy/{{service-name}}"`

test "$REPO_EXISTS" = "" && aws ecr create-repository --repository-name synergy/{{service-name}}

docker tag synergy/{{service-name}} 979590819078.dkr.ecr.eu-west-1.amazonaws.com/synergy/{{service-name}}
docker push 979590819078.dkr.ecr.eu-west-1.amazonaws.com/synergy/{{service-name}}