(ns {{dev}}
  (:require [clojure.tools.namespace.repl :refer [refresh]]
            [ai.hackthorn.synergy.system :as system]
            [{{name}}.data.system-map :refer [system-map-data]]
            ;; ensure commands is loaded into the REPL!!!
            [{{name}}.commands]))

;; Project: {{name}}
;; define functions to help manage system setup and tear-down during development


(defn go
  []
  (system/go (system/configure-system-map system-map-data :dev)))

(defn stop [] (system/stop))

(defn reset []
  (system/stop)
  (refresh :after 'dev/go))

