# Synergy Microservice - {{name}}

This project was generated by the synergy-microservice template, which aims to glue together a number of libraries and good practices to simplify microservice creation using Clojure:

* Component - support for lightweight DI pattern, and component lifecycle management
* Aero - configuration handling
* Timbre - native Clojure logging
* Yada - resources definition
* Bidi - route definition
* Schema - for data shape definition and validation
* the reloaded workflow, by Stuart Sierra

## Features:

* Component-based application architecture  
* reloaded workflow  
* dev profile, including helper functions, e.g. (dev)  
* conventions for source, e.g. ai.hackthorn.synergy.components directory  
* configuration from a resource file - all environments to use the same configuration file, using Aero's #profile  
* logging to the console, to support running as a Docker microservice where the log output is collected by fluentd.  
* support for Docker deployment  

## Component architecture  
TBD 

## Reloaded workflow  

This workflow is well covered in http://thinkrelevance.com/blog/2013/06/04/clojure-workflow-reloaded.

In practical terms, projects generated from this template support the concept of reloadable systems, whereby you can start a system, make changes and quickly reload the changes, without restarting the REPL.  This enables rapid development cycles.

The dev.clj file contains the key functions to enable the typical workflow.

When you start a REPL, invoke the (dev) function. This creates the system.

Invoke (go) to start the system.

## Conventions  

Components go in the components namespace, one component per source file.  



## Configuration  

## Logging

As it is intended that each microservice produced using this template will run in a container - Docker to start with - log output will be to the console, in order to be collected by fluentd and forwarded to Elasticsearch (and/or other data stores/messaging services).

## Docker support

The intention is that you will use the Leiningen uberimage plugin to generate a Docker image for your service, so the only explicit Docker support is in the form of the uberimage configuration section in project.clj. 

By default, the Docker container will be based on the Java Alpine image, a minimal image which is a good deal smaller than a similar Ubuntu based image.

### Plugin requirements  

You'll need Docker installed to be able to use the plugin.  https://docs.docker.com/engine/installation/. 

Also, note that the plugin communicates with Docker using a TCP connection, not a Unix socket. To configure Docker to support a TCP connection, follow the instructions here: https://docs.docker.com/engine/admin/configuring/.

To install the uberimage plugin, you'll need to amend your ~/.lein/profiles.clj file to include the plugin:  

```
{:user {:plugins [[com.palletops/uberimage "0.4.1"]]}}
```

(The Github project for the plugin: https://github.com/palletops/lein-uberimage. See this for more information on usage and configuration of the plugin.)


## Building and running the Dockerized service

Running `lein uberimage` will invoke `lein uberjar` first - the template ensures you have a suitable main namespace, and provides a main function too, in main.clj.  

If there are no compilation errors, uberimage will create a Docker image based on the uberjar, with the tag defined in the uberimage section of project.clj.  

On successful completion of `lein uberimage`, you will be able to run an instance of the image, e.g.  

```docker run -p 8080:8080 <project name>```  

This will run up the service, which is by default on port 8080, and expose the service on port 8080.  Log output will appear on the console - terminate the running application with CTRL+C.  

## Pushing to ECR

A helper script, deploy-to-ecr.sh, is provided to allow you to push your Dockerized service to Amazon's ECS Container Repository.  

### Pre-requisites  

First, ensure it's executable - `chmod +x deploy-to-ecr.sh`.  

Before you can run this script, you must have the AWS CLI installed: http://docs.aws.amazon.com/cli/latest/userguide/installing.html. 

You must also have set up the credentials file, with the appropriate AWS keys: http://docs.aws.amazon.com/cli/latest/userguide/cli-chap-getting-started.html#cli-config-files.

Finally, before you push to ECR, you need to have successfully run `lein uberimage`.

### Usage  

To run, simply execute: `./deploy-to-ecr.sh`.  

The script will ensure that a repository is available, with the name synergy/<service name>. Then, it tags and pushes the image to ECR - this process can take some time, typically 5-10 minutes.  

When complete, you should have an image in ECR ready for use by the Rancher environment.  

## Rancher deployment

To be able to deploy the service to Rancher, you must have pushed the image to ECR. Also, ensure you have rancher-compose installed. You can download the application from the Rancher UI - the link is in the right hand side of the footer.     

This project includes rancher-compose.yml and docker-compose.yml files, so to deploy to Rancher, from the root of the project:

```
rancher-compose --url=http://rancher.synergyxm.ai:8080/v1/projects/1a8 --access-key=080D285CEB48B8D64061 --secret-key=QuDF4gtwoUbqiMMT9wg8neL9FoziuTG9cSE6YmnP up -d --pull
```

The Rancher URL and the keys are for deployment to the Synergy environment.

Deployment will be to any host which doesn't have a service running on the port used by this service.

Note: the Rancher deployment support here is to allow you to test this service in isolation in a Rancher environment. In practice, the microservice would form part of a stack which would have its own project containing rancher-compose and docker-compose files.
 