# Synergy Microservice - {{name}}

This project was generated by the synergy-microservice template, which aims to glue together a number of libraries and good practices to simplify microservice creation using Clojure:

* Component - support for lightweight DI pattern, and component lifecycle management
* Aero - configuration handling
* Timbre - native Clojure logging
* Yada - resources definition
* Bidi - route definition
* Schema - for data shape definition and validation
* the reloaded workflow, by Stuart Sierra

## Logging

Output will be to the console, to support running as a Docker microservice, with output collected by fluentd. (ideally will be JSON)

## Features:

* Component-based application architecture
* reloaded workflow
* dev profile, including helper functions, e.g. (dev)
* conventions for source, e.g. ai.hackthorn.synergy.components directory
* configuration from a resource file - all environments to use the same configuration file, using Aero's #profile
* support for Docker

## Docker support

The intention is that you will use the Leiningen uberimage plugin to generate a Docker image for your service, so the only explicit Docker support is in the form of the uberimage configuration section in project.clj. 

By default, the Docker container will be based on the Java Alpine image, a minimal image which is a good deal smaller than a similar Ubuntu based image.

### Plugin requirements  

To install the uberimage plugin, you'll need to amend your ~/.lein/profiles.clj file to include the plugin:  

```
{:user {:plugins [[com.palletops/uberimage "0.4.1"]]}}
```

(The Github project for the plugin: https://github.com/palletops/lein-uberimage. See this for more information on usage and configuration of the plugin.)


## Building and running the Dockerized service

Running `lein uberimage` will invoke `lein uberjar` first - the template ensures you have a suitable main namespace, and provides a main function too, in main.clj.  

If there are no compilation errors, uberimage will create a Docker image based on the uberjar, with the tag defined in the uberimage section of project.clj.  

On successful completion of `lein uberimage`, you will be able to run an instance of the image, e.g.  

```docker run -p 8080:8080 <project name>```  

This will run up the service, which is by default on port 8080, and expose the service on port 8080.  Log output will appear on the console - terminate the running application with CTRL+C.  

## Rancher deployment

To be able to deploy the service to Rancher, ensure you have installed rancher-compose. You can download the application from the Rancher UI - the link is in the right hand side of the footer.     

This project includes rancher-compose.yml and docker-compose.yml files are included, so to deploy to Rancher, from the root of the project:

```
rancher-compose --url=http://rancher.synergyxm.ai:8080/v1/projects/1a8 --access-key=080D285CEB48B8D64061 --secret-key=QuDF4gtwoUbqiMMT9wg8neL9FoziuTG9cSE6YmnP up -d --pull
```

Note the Rancher URL and the keys are for deployment to the Synergy environment.

Deployment will be to any host which doesn't have a service running on the port used by this service.
