(ns {{name}}.processor
    (:require [uswitch.lambada.core :refer [deflambdafn]]
      [clojure.data.json :as json]
      [clojure.java.io :as io]
      [synergy-events.core :as eventcore]
      [taoensso.timbre :as timbre
       :refer [log  trace  debug  info  warn  error  fatal  report
               logf tracef debugf infof warnf errorf fatalf reportf
               spy get-env]])
    (:gen-class))


(def client-opts
  {
   ;; Note - defaults to eu-west-1 - need to change for other regions
   :endpoint "http://dynamodb.eu-west-1.amazonaws.com"
   })

;; Handler function
;; Very simple template:
;; Take a message in standard Synergy message format
;; Log that message out
;; Work on the event
;; Create a child event from this one with a given new state based on the lamda-end-state defined here
;; Dispatch to the next SNS queue in turn (defined in the next-sns-queue def) and finish
;;
;; Note - obviously end state, new event, next queue can all be dependent on function returns here

(def lambda-end-state "dummy1")

(def next-sns-queue "dummy2")

(defn handle-command [event]
      (info "Handling : " event)
      ;; Body of the handler here
      (eventcore/save-synergy-event (eventcore/create-event-insert-map (eventcore/create-pure-child-event event) lambda-end-state true) client-opts)
      (eventcore/dispatch-event-to-topic event (eventcore/lookup-sns-queue-for-action next-sns-queue client-opts))
      (merge {:statusCode 200, :headers { }, :body {}}))


(deflambdafn {{name}}.processor.CmdProc
             [in out ctx]
             (let [event (json/read (io/reader in) :key-fn keyword)
                   res (handle-command (eventcore/extract-internal-event event))]
                  (with-open [w (io/writer out)]
                             (json/write res w))
                  ))
