(ns leiningen.new.synergy-lambda
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "synergy-lambda"))

(defn synergy-lambda
  "Generates a new Clojure project for a Lambda function to be deployed to AWS"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' synergy-lambda project.")
    (->files data
             ["src/{{sanitized}}/processor.clj" (render "processor.clj" data)]
             ["project.clj" (render "project.clj" data)]
             ["addFunction.sh" (render "addFunction.sh" data)]
             ["updateFunction.sh" (render "updateFunction.sh" data)]
             ["runFunction.sh" (render "runFunction.sh" data)])))
