(ns symmetry.lib.web.file-session-store
  (:require [ring.middleware.session]
            [ring.middleware.session.store :refer [SessionStore]]
            [symmetry.lib.atomfile :refer [edn-atomfile
                                           fipp-atomfile]]))

;;==============================================================================
;; File-based session store, cached in ram.
;;==============================================================================

(defn file-session-store
  "path   - path to where session database gets stored in a file.
   opts   - optional map containing keys:

            :format   :edn, :fipp (default is :fipp)"
  [path & [opts]]
  (let [cache (case (get opts :format :edn)
                :edn   (edn-atomfile path {})
                :fipp  (fipp-atomfile path {})
                ;;:nippy (nippy-atomfile path {})
                )]
    (reify SessionStore
      (read-session [_ k]
        (get @cache k {}))
      (write-session [_ k data]
        (let [k (or k (str (java.util.UUID/randomUUID)))]
          (swap! cache assoc k data)
          (name k)))
      (delete-session [_ k]
        (swap! cache dissoc k)
        nil))))

(defn wrap-file-session [handler path & [opts]]
  (ring.middleware.session/wrap-session
   handler {:store (file-session-store path opts)}))
